/* # site_url: https://gibson.authorwebsiteinabox.com */;
/* # home_url: https://gibson.authorwebsiteinabox.com */;
/* # content_url: https://gibson.authorwebsiteinabox.com/wp-content */;
/* # upload_url: https://gibson.authorwebsiteinabox.com/wp-content/uploads */;
/* # table_prefix: wp5_ */;


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `wp5_actionscheduler_claims`
--

DROP TABLE IF EXISTS `wp5_actionscheduler_claims`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `wp5_actionscheduler_claims` (
  `claim_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wp5_actionscheduler_claims`
--

LOCK TABLES `wp5_actionscheduler_claims` WRITE;
/*!40000 ALTER TABLE `wp5_actionscheduler_claims` DISABLE KEYS */;
/*!40000 ALTER TABLE `wp5_actionscheduler_claims` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wp5_actionscheduler_logs`
--

DROP TABLE IF EXISTS `wp5_actionscheduler_logs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `wp5_actionscheduler_logs` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint(20) unsigned NOT NULL,
  `message` text NOT NULL,
  `log_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wp5_actionscheduler_logs`
--

LOCK TABLES `wp5_actionscheduler_logs` WRITE;
/*!40000 ALTER TABLE `wp5_actionscheduler_logs` DISABLE KEYS */;
/*!40000 ALTER TABLE `wp5_actionscheduler_logs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wp5_comments`
--

DROP TABLE IF EXISTS `wp5_comments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `wp5_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT 0,
  `comment_author` tinytext NOT NULL,
  `comment_author_email` varchar(100) NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT 0,
  `comment_approved` varchar(20) NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) NOT NULL DEFAULT '',
  `comment_type` varchar(20) NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=MyISAM AUTO_INCREMENT=667 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wp5_comments`
--

LOCK TABLES `wp5_comments` WRITE;
/*!40000 ALTER TABLE `wp5_comments` DISABLE KEYS */;
/*!40000 ALTER TABLE `wp5_comments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wp5_links`
--

DROP TABLE IF EXISTS `wp5_links`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `wp5_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) NOT NULL DEFAULT '',
  `link_name` varchar(255) NOT NULL DEFAULT '',
  `link_image` varchar(255) NOT NULL DEFAULT '',
  `link_target` varchar(25) NOT NULL DEFAULT '',
  `link_description` varchar(255) NOT NULL DEFAULT '',
  `link_visible` varchar(20) NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT 1,
  `link_rating` int(11) NOT NULL DEFAULT 0,
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) NOT NULL DEFAULT '',
  `link_notes` mediumtext NOT NULL,
  `link_rss` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wp5_links`
--

LOCK TABLES `wp5_links` WRITE;
/*!40000 ALTER TABLE `wp5_links` DISABLE KEYS */;
/*!40000 ALTER TABLE `wp5_links` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wp5_shortpixel_folders`
--

DROP TABLE IF EXISTS `wp5_shortpixel_folders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `wp5_shortpixel_folders` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `path` varchar(512) DEFAULT NULL,
  `name` varchar(64) DEFAULT NULL,
  `path_md5` char(32) DEFAULT NULL,
  `file_count` int(11) DEFAULT NULL,
  `status` smallint(6) NOT NULL DEFAULT 0,
  `ts_updated` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `ts_created` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  UNIQUE KEY `id` (`id`),
  UNIQUE KEY `spf_path_md5` (`path_md5`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wp5_shortpixel_folders`
--

LOCK TABLES `wp5_shortpixel_folders` WRITE;
/*!40000 ALTER TABLE `wp5_shortpixel_folders` DISABLE KEYS */;
/*!40000 ALTER TABLE `wp5_shortpixel_folders` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wp5_shortpixel_meta`
--

DROP TABLE IF EXISTS `wp5_shortpixel_meta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `wp5_shortpixel_meta` (
  `id` mediumint(10) NOT NULL AUTO_INCREMENT,
  `folder_id` mediumint(9) NOT NULL,
  `ext_meta_id` int(10) DEFAULT NULL,
  `path` varchar(512) DEFAULT NULL,
  `name` varchar(64) DEFAULT NULL,
  `path_md5` char(32) DEFAULT NULL,
  `compressed_size` int(10) NOT NULL DEFAULT 0,
  `compression_type` tinyint(4) DEFAULT NULL,
  `keep_exif` tinyint(4) DEFAULT 0,
  `cmyk2rgb` tinyint(4) DEFAULT 0,
  `resize` tinyint(4) DEFAULT NULL,
  `resize_width` smallint(6) DEFAULT NULL,
  `resize_height` smallint(6) DEFAULT NULL,
  `backup` tinyint(4) DEFAULT 0,
  `status` smallint(6) NOT NULL DEFAULT 0,
  `retries` tinyint(4) NOT NULL DEFAULT 0,
  `message` varchar(255) DEFAULT NULL,
  `ts_added` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `ts_optimized` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  UNIQUE KEY `sp_id` (`id`),
  UNIQUE KEY `sp_path_md5` (`path_md5`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wp5_shortpixel_meta`
--

LOCK TABLES `wp5_shortpixel_meta` WRITE;
/*!40000 ALTER TABLE `wp5_shortpixel_meta` DISABLE KEYS */;
/*!40000 ALTER TABLE `wp5_shortpixel_meta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wp5_yoast_indexable_hierarchy`
--

DROP TABLE IF EXISTS `wp5_yoast_indexable_hierarchy`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `wp5_yoast_indexable_hierarchy` (
  `indexable_id` int(11) unsigned NOT NULL,
  `ancestor_id` int(11) unsigned NOT NULL,
  `depth` int(11) unsigned DEFAULT NULL,
  `blog_id` bigint(20) NOT NULL DEFAULT 1,
  PRIMARY KEY (`indexable_id`,`ancestor_id`),
  KEY `indexable_id` (`indexable_id`),
  KEY `ancestor_id` (`ancestor_id`),
  KEY `depth` (`depth`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wp5_yoast_indexable_hierarchy`
--

LOCK TABLES `wp5_yoast_indexable_hierarchy` WRITE;
/*!40000 ALTER TABLE `wp5_yoast_indexable_hierarchy` DISABLE KEYS */;
/*!40000 ALTER TABLE `wp5_yoast_indexable_hierarchy` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wp5_yoast_primary_term`
--

DROP TABLE IF EXISTS `wp5_yoast_primary_term`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `wp5_yoast_primary_term` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` int(11) unsigned NOT NULL,
  `term_id` int(11) unsigned NOT NULL,
  `taxonomy` varchar(32) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `blog_id` bigint(20) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`),
  KEY `post_taxonomy` (`post_id`,`taxonomy`),
  KEY `post_term` (`post_id`,`term_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wp5_yoast_primary_term`
--

LOCK TABLES `wp5_yoast_primary_term` WRITE;
/*!40000 ALTER TABLE `wp5_yoast_primary_term` DISABLE KEYS */;
/*!40000 ALTER TABLE `wp5_yoast_primary_term` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wp5_yoast_seo_links`
--

DROP TABLE IF EXISTS `wp5_yoast_seo_links`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `wp5_yoast_seo_links` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(255) DEFAULT NULL,
  `post_id` bigint(20) unsigned DEFAULT NULL,
  `target_post_id` bigint(20) unsigned DEFAULT NULL,
  `type` varchar(8) DEFAULT NULL,
  `indexable_id` int(11) unsigned DEFAULT NULL,
  `target_indexable_id` int(11) unsigned DEFAULT NULL,
  `height` int(11) unsigned DEFAULT NULL,
  `width` int(11) unsigned DEFAULT NULL,
  `size` int(11) unsigned DEFAULT NULL,
  `language` varchar(32) DEFAULT NULL,
  `region` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `link_direction` (`post_id`,`type`),
  KEY `indexable_link_direction` (`indexable_id`,`type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wp5_yoast_seo_links`
--

LOCK TABLES `wp5_yoast_seo_links` WRITE;
/*!40000 ALTER TABLE `wp5_yoast_seo_links` DISABLE KEYS */;
/*!40000 ALTER TABLE `wp5_yoast_seo_links` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wp5_actionscheduler_actions`
--

DROP TABLE IF EXISTS `wp5_actionscheduler_actions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `wp5_actionscheduler_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) NOT NULL,
  `status` varchar(20) NOT NULL,
  `scheduled_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `args` varchar(191) DEFAULT NULL,
  `schedule` longtext DEFAULT NULL,
  `group_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `attempts` int(11) NOT NULL DEFAULT 0,
  `last_attempt_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `extended_args` varchar(8000) DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `hook` (`hook`),
  KEY `status` (`status`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id` (`claim_id`)
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wp5_actionscheduler_actions`
--

LOCK TABLES `wp5_actionscheduler_actions` WRITE;
/*!40000 ALTER TABLE `wp5_actionscheduler_actions` DISABLE KEYS */;
/*!40000 ALTER TABLE `wp5_actionscheduler_actions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wp5_actionscheduler_groups`
--

DROP TABLE IF EXISTS `wp5_actionscheduler_groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `wp5_actionscheduler_groups` (
  `group_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wp5_actionscheduler_groups`
--

LOCK TABLES `wp5_actionscheduler_groups` WRITE;
/*!40000 ALTER TABLE `wp5_actionscheduler_groups` DISABLE KEYS */;
/*!40000 ALTER TABLE `wp5_actionscheduler_groups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wp5_commentmeta`
--

DROP TABLE IF EXISTS `wp5_commentmeta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `wp5_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=1996 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wp5_commentmeta`
--

LOCK TABLES `wp5_commentmeta` WRITE;
/*!40000 ALTER TABLE `wp5_commentmeta` DISABLE KEYS */;
/*!40000 ALTER TABLE `wp5_commentmeta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wp5_termmeta`
--

DROP TABLE IF EXISTS `wp5_termmeta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `wp5_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wp5_termmeta`
--

LOCK TABLES `wp5_termmeta` WRITE;
/*!40000 ALTER TABLE `wp5_termmeta` DISABLE KEYS */;
/*!40000 ALTER TABLE `wp5_termmeta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wp5_term_taxonomy`
--

DROP TABLE IF EXISTS `wp5_term_taxonomy`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `wp5_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `taxonomy` varchar(32) NOT NULL DEFAULT '',
  `description` longtext NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=MyISAM AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wp5_term_taxonomy`
--

LOCK TABLES `wp5_term_taxonomy` WRITE;
/*!40000 ALTER TABLE `wp5_term_taxonomy` DISABLE KEYS */;
INSERT INTO `wp5_term_taxonomy` VALUES (1,1,'category','',0,6);
INSERT INTO `wp5_term_taxonomy` VALUES (2,2,'layout_type','',0,12);
INSERT INTO `wp5_term_taxonomy` VALUES (3,3,'scope','',0,32);
INSERT INTO `wp5_term_taxonomy` VALUES (4,4,'module_width','',0,29);
INSERT INTO `wp5_term_taxonomy` VALUES (5,5,'layout_type','',0,18);
INSERT INTO `wp5_term_taxonomy` VALUES (6,6,'module_width','',0,3);
INSERT INTO `wp5_term_taxonomy` VALUES (7,7,'layout_category','',0,1);
INSERT INTO `wp5_term_taxonomy` VALUES (8,8,'layout_type','',0,2);
INSERT INTO `wp5_term_taxonomy` VALUES (9,9,'nav_menu','',0,8);
/*!40000 ALTER TABLE `wp5_term_taxonomy` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wp5_et_bloom_stats`
--

DROP TABLE IF EXISTS `wp5_et_bloom_stats`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `wp5_et_bloom_stats` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `record_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `record_type` varchar(3) NOT NULL,
  `optin_id` varchar(20) NOT NULL,
  `list_id` varchar(100) NOT NULL,
  `page_id` varchar(20) NOT NULL,
  `removed_flag` tinyint(1) NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=61 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wp5_et_bloom_stats`
--

LOCK TABLES `wp5_et_bloom_stats` WRITE;
/*!40000 ALTER TABLE `wp5_et_bloom_stats` DISABLE KEYS */;
INSERT INTO `wp5_et_bloom_stats` VALUES (1,'2021-02-24 21:42:01','imp','optin_1','46650430','204274',0);
INSERT INTO `wp5_et_bloom_stats` VALUES (2,'2021-02-25 04:38:33','imp','optin_1','46650430','-1',0);
INSERT INTO `wp5_et_bloom_stats` VALUES (3,'2021-02-26 01:50:38','imp','optin_1','46650430','-1',0);
INSERT INTO `wp5_et_bloom_stats` VALUES (4,'2021-02-27 00:15:28','imp','optin_1','46650430','204808',0);
INSERT INTO `wp5_et_bloom_stats` VALUES (5,'2021-02-27 20:54:15','imp','optin_1','46650430','-1',0);
INSERT INTO `wp5_et_bloom_stats` VALUES (6,'2021-02-28 21:35:36','imp','optin_1','46650430','-1',0);
INSERT INTO `wp5_et_bloom_stats` VALUES (7,'2021-02-28 21:57:08','imp','optin_1','46650430','-1',0);
INSERT INTO `wp5_et_bloom_stats` VALUES (8,'2021-02-28 22:06:16','imp','optin_1','46650430','-1',0);
INSERT INTO `wp5_et_bloom_stats` VALUES (9,'2021-02-28 22:25:09','imp','optin_1','46650430','-1',0);
INSERT INTO `wp5_et_bloom_stats` VALUES (10,'2021-02-28 22:25:11','imp','optin_1','46650430','-1',0);
INSERT INTO `wp5_et_bloom_stats` VALUES (11,'2021-02-28 22:31:56','imp','optin_1','46650430','-1',0);
INSERT INTO `wp5_et_bloom_stats` VALUES (12,'2021-02-28 22:57:07','imp','optin_1','46650430','-1',0);
INSERT INTO `wp5_et_bloom_stats` VALUES (13,'2021-02-28 23:03:22','imp','optin_1','46650430','-1',0);
INSERT INTO `wp5_et_bloom_stats` VALUES (14,'2021-02-28 23:05:20','imp','optin_1','46650430','-1',0);
INSERT INTO `wp5_et_bloom_stats` VALUES (15,'2021-02-28 23:09:07','imp','optin_1','46650430','-1',0);
INSERT INTO `wp5_et_bloom_stats` VALUES (16,'2021-02-28 23:11:31','imp','optin_1','46650430','-1',0);
INSERT INTO `wp5_et_bloom_stats` VALUES (17,'2021-02-28 23:34:54','imp','optin_1','46650430','-1',0);
INSERT INTO `wp5_et_bloom_stats` VALUES (18,'2021-02-28 23:42:52','imp','optin_1','46650430','-1',0);
INSERT INTO `wp5_et_bloom_stats` VALUES (19,'2021-02-28 23:43:30','imp','optin_1','46650430','204351',0);
INSERT INTO `wp5_et_bloom_stats` VALUES (20,'2021-02-28 23:54:16','imp','optin_1','46650430','-1',0);
INSERT INTO `wp5_et_bloom_stats` VALUES (21,'2021-03-01 01:15:18','imp','optin_1','46650430','-1',0);
INSERT INTO `wp5_et_bloom_stats` VALUES (22,'2021-03-01 01:46:22','imp','optin_1','46650430','204808',0);
INSERT INTO `wp5_et_bloom_stats` VALUES (23,'2021-03-01 01:57:34','imp','optin_1','46650430','-1',0);
INSERT INTO `wp5_et_bloom_stats` VALUES (24,'2021-03-01 02:43:06','imp','optin_1','46650430','-1',0);
INSERT INTO `wp5_et_bloom_stats` VALUES (25,'2021-03-01 03:28:26','imp','optin_1','46650430','-1',0);
INSERT INTO `wp5_et_bloom_stats` VALUES (26,'2021-03-01 05:14:06','imp','optin_1','46650430','-1',0);
INSERT INTO `wp5_et_bloom_stats` VALUES (27,'2021-03-01 13:10:50','imp','optin_1','46650430','-1',0);
INSERT INTO `wp5_et_bloom_stats` VALUES (28,'2021-03-01 13:38:13','imp','optin_1','46650430','-1',0);
INSERT INTO `wp5_et_bloom_stats` VALUES (29,'2021-03-01 14:21:00','imp','optin_1','46650430','204274',0);
INSERT INTO `wp5_et_bloom_stats` VALUES (30,'2021-03-01 16:21:05','imp','optin_1','46650430','-1',0);
INSERT INTO `wp5_et_bloom_stats` VALUES (31,'2021-03-01 21:29:49','imp','optin_1','46650430','-1',0);
INSERT INTO `wp5_et_bloom_stats` VALUES (32,'2021-03-01 21:52:42','imp','optin_1','46650430','-1',0);
INSERT INTO `wp5_et_bloom_stats` VALUES (33,'2021-03-01 22:26:39','imp','optin_1','46650430','-1',0);
INSERT INTO `wp5_et_bloom_stats` VALUES (34,'2021-03-02 04:37:51','imp','optin_1','46650430','-1',0);
INSERT INTO `wp5_et_bloom_stats` VALUES (35,'2021-03-03 15:16:20','imp','optin_1','46650430','-1',0);
INSERT INTO `wp5_et_bloom_stats` VALUES (36,'2021-03-04 22:22:24','imp','optin_1','46650430','-1',0);
INSERT INTO `wp5_et_bloom_stats` VALUES (37,'2021-03-05 15:45:02','imp','optin_1','46650430','-1',0);
INSERT INTO `wp5_et_bloom_stats` VALUES (38,'2021-03-05 17:17:39','imp','optin_1','46650430','-1',0);
INSERT INTO `wp5_et_bloom_stats` VALUES (39,'2021-03-06 03:18:17','imp','optin_1','46650430','-1',0);
INSERT INTO `wp5_et_bloom_stats` VALUES (40,'2021-03-06 21:43:16','imp','optin_1','46650430','-1',0);
INSERT INTO `wp5_et_bloom_stats` VALUES (41,'2021-03-09 17:26:54','imp','optin_1','46650430','-1',0);
INSERT INTO `wp5_et_bloom_stats` VALUES (42,'2021-03-09 17:27:15','con','optin_1','mailerlite_46650430','-1',0);
INSERT INTO `wp5_et_bloom_stats` VALUES (43,'2021-03-11 14:06:39','imp','optin_1','46650430','-1',0);
INSERT INTO `wp5_et_bloom_stats` VALUES (44,'2021-03-13 00:19:05','imp','optin_1','46650430','-1',0);
INSERT INTO `wp5_et_bloom_stats` VALUES (45,'2021-03-13 02:02:12','imp','optin_1','46650430','-1',0);
INSERT INTO `wp5_et_bloom_stats` VALUES (46,'2021-03-13 02:18:04','imp','optin_1','46650430','-1',0);
INSERT INTO `wp5_et_bloom_stats` VALUES (47,'2021-03-13 05:55:50','imp','optin_1','46650430','204351',0);
INSERT INTO `wp5_et_bloom_stats` VALUES (48,'2021-03-13 10:39:31','imp','optin_1','46650430','-1',0);
INSERT INTO `wp5_et_bloom_stats` VALUES (49,'2021-03-14 00:59:07','imp','optin_1','46650430','-1',0);
INSERT INTO `wp5_et_bloom_stats` VALUES (50,'2021-03-14 01:54:06','imp','optin_1','46650430','-1',0);
INSERT INTO `wp5_et_bloom_stats` VALUES (51,'2021-03-15 12:39:09','imp','optin_1','46650430','-1',0);
INSERT INTO `wp5_et_bloom_stats` VALUES (52,'2021-03-15 21:18:45','imp','optin_1','46650430','-1',0);
INSERT INTO `wp5_et_bloom_stats` VALUES (53,'2021-03-17 23:22:34','imp','optin_1','46650430','204808',0);
INSERT INTO `wp5_et_bloom_stats` VALUES (54,'2021-03-18 22:22:42','imp','optin_1','46650430','-1',0);
INSERT INTO `wp5_et_bloom_stats` VALUES (55,'2021-03-18 22:40:52','imp','optin_1','46650430','204260',0);
INSERT INTO `wp5_et_bloom_stats` VALUES (56,'2021-03-19 02:10:49','imp','optin_1','46650430','-1',0);
INSERT INTO `wp5_et_bloom_stats` VALUES (57,'2021-03-19 03:43:09','imp','optin_1','46650430','-1',0);
INSERT INTO `wp5_et_bloom_stats` VALUES (58,'2021-03-19 05:32:28','imp','optin_1','46650430','-1',0);
INSERT INTO `wp5_et_bloom_stats` VALUES (59,'2021-03-21 22:08:44','imp','optin_1','46650430','-1',0);
INSERT INTO `wp5_et_bloom_stats` VALUES (60,'2021-03-22 19:53:43','imp','optin_1','46650430','-1',0);
/*!40000 ALTER TABLE `wp5_et_bloom_stats` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wp5_users`
--

DROP TABLE IF EXISTS `wp5_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `wp5_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) NOT NULL DEFAULT '',
  `user_pass` varchar(255) NOT NULL DEFAULT '',
  `user_nicename` varchar(50) NOT NULL DEFAULT '',
  `user_email` varchar(100) NOT NULL DEFAULT '',
  `user_url` varchar(100) NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT 0,
  `display_name` varchar(250) NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wp5_users`
--

LOCK TABLES `wp5_users` WRITE;
/*!40000 ALTER TABLE `wp5_users` DISABLE KEYS */;
INSERT INTO `wp5_users` VALUES (1,'Nate2hoffelder','$wp$2y$10$HNxwCUUM2b9HvY7esM35Ju5gSsCXx5k7SbOKApnIWyyc2jLQ.xysm','nate2hoffelder','natehoffelder@gmail.com','https://authorwebsiteinabox.com','2020-10-18 22:29:52','',0,'Nate Hoffelder');
INSERT INTO `wp5_users` VALUES (3,'new admin','$wp$2y$10$vMLUGCEEnH5fkspg0DyKMe23P38oDb06BAvnIZqjWWOw1twcCBXLC','new-admin','nate.hoffelder@gmail.com','','2021-02-24 13:46:29','',0,'new admin');
/*!40000 ALTER TABLE `wp5_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wp5_yoast_migrations`
--

DROP TABLE IF EXISTS `wp5_yoast_migrations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `wp5_yoast_migrations` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `version` varchar(191) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `wp5_yoast_migrations_version` (`version`)
) ENGINE=MyISAM AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wp5_yoast_migrations`
--

LOCK TABLES `wp5_yoast_migrations` WRITE;
/*!40000 ALTER TABLE `wp5_yoast_migrations` DISABLE KEYS */;
INSERT INTO `wp5_yoast_migrations` VALUES (1,'20171228151840');
INSERT INTO `wp5_yoast_migrations` VALUES (2,'20171228151841');
INSERT INTO `wp5_yoast_migrations` VALUES (3,'20190529075038');
INSERT INTO `wp5_yoast_migrations` VALUES (4,'20191011111109');
INSERT INTO `wp5_yoast_migrations` VALUES (5,'20200408101900');
INSERT INTO `wp5_yoast_migrations` VALUES (6,'20200420073606');
INSERT INTO `wp5_yoast_migrations` VALUES (7,'20200428123747');
INSERT INTO `wp5_yoast_migrations` VALUES (8,'20200428194858');
INSERT INTO `wp5_yoast_migrations` VALUES (9,'20200429105310');
INSERT INTO `wp5_yoast_migrations` VALUES (10,'20200430075614');
INSERT INTO `wp5_yoast_migrations` VALUES (11,'20200430150130');
INSERT INTO `wp5_yoast_migrations` VALUES (12,'20200507054848');
INSERT INTO `wp5_yoast_migrations` VALUES (13,'20200513133401');
INSERT INTO `wp5_yoast_migrations` VALUES (14,'20200609154515');
INSERT INTO `wp5_yoast_migrations` VALUES (15,'20200616130143');
INSERT INTO `wp5_yoast_migrations` VALUES (16,'20200617122511');
INSERT INTO `wp5_yoast_migrations` VALUES (17,'20200702141921');
INSERT INTO `wp5_yoast_migrations` VALUES (18,'20200728095334');
/*!40000 ALTER TABLE `wp5_yoast_migrations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wp5_term_relationships`
--

DROP TABLE IF EXISTS `wp5_term_relationships`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `wp5_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_order` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wp5_term_relationships`
--

LOCK TABLES `wp5_term_relationships` WRITE;
/*!40000 ALTER TABLE `wp5_term_relationships` DISABLE KEYS */;
INSERT INTO `wp5_term_relationships` VALUES (28139,2,0);
INSERT INTO `wp5_term_relationships` VALUES (28139,3,0);
INSERT INTO `wp5_term_relationships` VALUES (28139,4,0);
INSERT INTO `wp5_term_relationships` VALUES (28146,2,0);
INSERT INTO `wp5_term_relationships` VALUES (28169,1,0);
INSERT INTO `wp5_term_relationships` VALUES (28173,1,0);
INSERT INTO `wp5_term_relationships` VALUES (28175,1,0);
INSERT INTO `wp5_term_relationships` VALUES (28178,1,0);
INSERT INTO `wp5_term_relationships` VALUES (28183,1,0);
INSERT INTO `wp5_term_relationships` VALUES (28184,1,0);
INSERT INTO `wp5_term_relationships` VALUES (28200,3,0);
INSERT INTO `wp5_term_relationships` VALUES (28200,5,0);
INSERT INTO `wp5_term_relationships` VALUES (28200,4,0);
INSERT INTO `wp5_term_relationships` VALUES (204072,3,0);
INSERT INTO `wp5_term_relationships` VALUES (204072,4,0);
INSERT INTO `wp5_term_relationships` VALUES (204072,5,0);
INSERT INTO `wp5_term_relationships` VALUES (204784,4,0);
INSERT INTO `wp5_term_relationships` VALUES (204784,8,0);
INSERT INTO `wp5_term_relationships` VALUES (204784,3,0);
INSERT INTO `wp5_term_relationships` VALUES (28047,6,0);
INSERT INTO `wp5_term_relationships` VALUES (28047,3,0);
INSERT INTO `wp5_term_relationships` VALUES (28047,5,0);
INSERT INTO `wp5_term_relationships` VALUES (203951,3,0);
INSERT INTO `wp5_term_relationships` VALUES (203951,4,0);
INSERT INTO `wp5_term_relationships` VALUES (203951,5,0);
INSERT INTO `wp5_term_relationships` VALUES (235,3,0);
INSERT INTO `wp5_term_relationships` VALUES (235,4,0);
INSERT INTO `wp5_term_relationships` VALUES (235,5,0);
INSERT INTO `wp5_term_relationships` VALUES (220,6,0);
INSERT INTO `wp5_term_relationships` VALUES (220,3,0);
INSERT INTO `wp5_term_relationships` VALUES (220,5,0);
INSERT INTO `wp5_term_relationships` VALUES (204785,5,0);
INSERT INTO `wp5_term_relationships` VALUES (204785,3,0);
INSERT INTO `wp5_term_relationships` VALUES (204785,4,0);
INSERT INTO `wp5_term_relationships` VALUES (316,3,0);
INSERT INTO `wp5_term_relationships` VALUES (316,4,0);
INSERT INTO `wp5_term_relationships` VALUES (316,5,0);
INSERT INTO `wp5_term_relationships` VALUES (141,3,0);
INSERT INTO `wp5_term_relationships` VALUES (141,4,0);
INSERT INTO `wp5_term_relationships` VALUES (141,5,0);
INSERT INTO `wp5_term_relationships` VALUES (204842,3,0);
INSERT INTO `wp5_term_relationships` VALUES (204840,9,0);
INSERT INTO `wp5_term_relationships` VALUES (204818,9,0);
INSERT INTO `wp5_term_relationships` VALUES (203977,3,0);
INSERT INTO `wp5_term_relationships` VALUES (203977,4,0);
INSERT INTO `wp5_term_relationships` VALUES (203977,5,0);
INSERT INTO `wp5_term_relationships` VALUES (203978,3,0);
INSERT INTO `wp5_term_relationships` VALUES (203978,4,0);
INSERT INTO `wp5_term_relationships` VALUES (203978,5,0);
INSERT INTO `wp5_term_relationships` VALUES (204842,4,0);
INSERT INTO `wp5_term_relationships` VALUES (204842,2,0);
INSERT INTO `wp5_term_relationships` VALUES (27888,7,0);
INSERT INTO `wp5_term_relationships` VALUES (27888,6,0);
INSERT INTO `wp5_term_relationships` VALUES (27888,3,0);
INSERT INTO `wp5_term_relationships` VALUES (27888,5,0);
INSERT INTO `wp5_term_relationships` VALUES (203940,3,0);
INSERT INTO `wp5_term_relationships` VALUES (203940,4,0);
INSERT INTO `wp5_term_relationships` VALUES (203940,5,0);
INSERT INTO `wp5_term_relationships` VALUES (203938,3,0);
INSERT INTO `wp5_term_relationships` VALUES (203938,4,0);
INSERT INTO `wp5_term_relationships` VALUES (203938,5,0);
INSERT INTO `wp5_term_relationships` VALUES (203944,2,0);
INSERT INTO `wp5_term_relationships` VALUES (203944,3,0);
INSERT INTO `wp5_term_relationships` VALUES (203944,4,0);
INSERT INTO `wp5_term_relationships` VALUES (204194,3,0);
INSERT INTO `wp5_term_relationships` VALUES (204194,8,0);
INSERT INTO `wp5_term_relationships` VALUES (204194,4,0);
INSERT INTO `wp5_term_relationships` VALUES (204248,3,0);
INSERT INTO `wp5_term_relationships` VALUES (204248,5,0);
INSERT INTO `wp5_term_relationships` VALUES (204248,4,0);
INSERT INTO `wp5_term_relationships` VALUES (204268,3,0);
INSERT INTO `wp5_term_relationships` VALUES (204268,5,0);
INSERT INTO `wp5_term_relationships` VALUES (204268,4,0);
INSERT INTO `wp5_term_relationships` VALUES (204279,3,0);
INSERT INTO `wp5_term_relationships` VALUES (204279,5,0);
INSERT INTO `wp5_term_relationships` VALUES (204279,4,0);
INSERT INTO `wp5_term_relationships` VALUES (204298,9,0);
INSERT INTO `wp5_term_relationships` VALUES (204991,2,0);
INSERT INTO `wp5_term_relationships` VALUES (204300,9,0);
INSERT INTO `wp5_term_relationships` VALUES (204365,3,0);
INSERT INTO `wp5_term_relationships` VALUES (204365,2,0);
INSERT INTO `wp5_term_relationships` VALUES (204365,4,0);
INSERT INTO `wp5_term_relationships` VALUES (204370,9,0);
INSERT INTO `wp5_term_relationships` VALUES (204371,3,0);
INSERT INTO `wp5_term_relationships` VALUES (204371,2,0);
INSERT INTO `wp5_term_relationships` VALUES (204371,4,0);
INSERT INTO `wp5_term_relationships` VALUES (205004,4,0);
INSERT INTO `wp5_term_relationships` VALUES (205005,3,0);
INSERT INTO `wp5_term_relationships` VALUES (205004,2,0);
INSERT INTO `wp5_term_relationships` VALUES (205005,4,0);
INSERT INTO `wp5_term_relationships` VALUES (205006,3,0);
INSERT INTO `wp5_term_relationships` VALUES (205005,2,0);
INSERT INTO `wp5_term_relationships` VALUES (205006,4,0);
INSERT INTO `wp5_term_relationships` VALUES (205006,2,0);
INSERT INTO `wp5_term_relationships` VALUES (205003,4,0);
INSERT INTO `wp5_term_relationships` VALUES (205004,3,0);
INSERT INTO `wp5_term_relationships` VALUES (205003,2,0);
INSERT INTO `wp5_term_relationships` VALUES (204998,4,0);
INSERT INTO `wp5_term_relationships` VALUES (205001,3,0);
INSERT INTO `wp5_term_relationships` VALUES (204998,2,0);
INSERT INTO `wp5_term_relationships` VALUES (205001,4,0);
INSERT INTO `wp5_term_relationships` VALUES (205003,3,0);
INSERT INTO `wp5_term_relationships` VALUES (205001,5,0);
INSERT INTO `wp5_term_relationships` VALUES (204996,4,0);
INSERT INTO `wp5_term_relationships` VALUES (204997,3,0);
INSERT INTO `wp5_term_relationships` VALUES (204996,2,0);
INSERT INTO `wp5_term_relationships` VALUES (204988,9,0);
INSERT INTO `wp5_term_relationships` VALUES (204996,3,0);
INSERT INTO `wp5_term_relationships` VALUES (204976,9,0);
INSERT INTO `wp5_term_relationships` VALUES (204958,2,0);
INSERT INTO `wp5_term_relationships` VALUES (204973,9,0);
INSERT INTO `wp5_term_relationships` VALUES (204946,2,0);
INSERT INTO `wp5_term_relationships` VALUES (204997,4,0);
INSERT INTO `wp5_term_relationships` VALUES (204998,3,0);
INSERT INTO `wp5_term_relationships` VALUES (204997,2,0);
/*!40000 ALTER TABLE `wp5_term_relationships` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wp5_yoast_indexable`
--

DROP TABLE IF EXISTS `wp5_yoast_indexable`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `wp5_yoast_indexable` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `permalink` longtext DEFAULT NULL,
  `permalink_hash` varchar(40) DEFAULT NULL,
  `object_id` int(11) unsigned DEFAULT NULL,
  `object_type` varchar(32) NOT NULL,
  `object_sub_type` varchar(32) DEFAULT NULL,
  `author_id` int(11) unsigned DEFAULT NULL,
  `post_parent` int(11) unsigned DEFAULT NULL,
  `title` text DEFAULT NULL,
  `description` mediumtext DEFAULT NULL,
  `breadcrumb_title` text DEFAULT NULL,
  `post_status` varchar(20) DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  `is_protected` tinyint(1) DEFAULT 0,
  `has_public_posts` tinyint(1) DEFAULT NULL,
  `number_of_pages` int(11) unsigned DEFAULT NULL,
  `canonical` longtext DEFAULT NULL,
  `primary_focus_keyword` varchar(191) DEFAULT NULL,
  `primary_focus_keyword_score` int(3) DEFAULT NULL,
  `readability_score` int(3) DEFAULT NULL,
  `is_cornerstone` tinyint(1) DEFAULT 0,
  `is_robots_noindex` tinyint(1) DEFAULT 0,
  `is_robots_nofollow` tinyint(1) DEFAULT 0,
  `is_robots_noarchive` tinyint(1) DEFAULT 0,
  `is_robots_noimageindex` tinyint(1) DEFAULT 0,
  `is_robots_nosnippet` tinyint(1) DEFAULT 0,
  `twitter_title` text DEFAULT NULL,
  `twitter_image` longtext DEFAULT NULL,
  `twitter_description` longtext DEFAULT NULL,
  `twitter_image_id` varchar(191) DEFAULT NULL,
  `twitter_image_source` text DEFAULT NULL,
  `open_graph_title` text DEFAULT NULL,
  `open_graph_description` longtext DEFAULT NULL,
  `open_graph_image` longtext DEFAULT NULL,
  `open_graph_image_id` varchar(191) DEFAULT NULL,
  `open_graph_image_source` text DEFAULT NULL,
  `open_graph_image_meta` mediumtext DEFAULT NULL,
  `link_count` int(11) DEFAULT NULL,
  `incoming_link_count` int(11) DEFAULT NULL,
  `prominent_words_version` int(11) unsigned DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `blog_id` bigint(20) NOT NULL DEFAULT 1,
  `language` varchar(32) DEFAULT NULL,
  `region` varchar(32) DEFAULT NULL,
  `schema_page_type` varchar(64) DEFAULT NULL,
  `schema_article_type` varchar(64) DEFAULT NULL,
  `has_ancestors` tinyint(1) DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `object_type_and_sub_type` (`object_type`,`object_sub_type`),
  KEY `object_id_and_type` (`object_id`,`object_type`),
  KEY `permalink_hash_and_object_type` (`permalink_hash`,`object_type`),
  KEY `subpages` (`post_parent`,`object_type`,`post_status`,`object_id`),
  KEY `prominent_words` (`prominent_words_version`,`object_type`,`object_sub_type`,`post_status`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wp5_yoast_indexable`
--

LOCK TABLES `wp5_yoast_indexable` WRITE;
/*!40000 ALTER TABLE `wp5_yoast_indexable` DISABLE KEYS */;
INSERT INTO `wp5_yoast_indexable` VALUES (1,'https://gibson.authorwebsiteinabox.com/author/nate2hoffelder/','61:aab3c04c715594077ec9189ef04db14c',1,'user',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,'https://secure.gravatar.com/avatar/74adc9be8c36f85d4e3446f6245f0cdb?s=500&d=mm&r=g',NULL,NULL,'gravatar-image',NULL,NULL,'https://secure.gravatar.com/avatar/74adc9be8c36f85d4e3446f6245f0cdb?s=500&d=mm&r=g',NULL,'gravatar-image',NULL,NULL,NULL,NULL,'2020-11-26 23:09:09','2020-11-26 23:09:09',1,NULL,NULL,NULL,NULL,0);
INSERT INTO `wp5_yoast_indexable` VALUES (2,'https://gibson.authorwebsiteinabox.com/?post_type=wpcf7_contact_form&p=204780','77:cab02b42d45015be70b2b206080f5f45',204780,'post','wpcf7_contact_form',1,0,NULL,NULL,'Contact form 1','publish',NULL,0,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,'2020-11-26 23:09:09','2020-11-26 23:09:09',1,NULL,NULL,NULL,NULL,0);
INSERT INTO `wp5_yoast_indexable` VALUES (3,'https://gibson.authorwebsiteinabox.com/mercurial-ohearn-gmail-com/','66:a448cd48be006a59d822a7b3b40bd9f2',204781,'post','flamingo_contact',1,0,NULL,NULL,'mercurial.ohearn@gmail.com','publish',NULL,0,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,'2020-11-26 23:09:09','2020-11-26 23:09:09',1,NULL,NULL,NULL,NULL,0);
INSERT INTO `wp5_yoast_indexable` VALUES (4,'https://gibson.authorwebsiteinabox.com/natehoffelder-gmail-com/','63:f33b2947409d6ec41f639a04b1744737',204782,'post','flamingo_contact',1,0,NULL,NULL,'natehoffelder@gmail.com','publish',NULL,0,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,'2020-11-26 23:09:09','2020-11-26 23:09:09',1,NULL,NULL,NULL,NULL,0);
/*!40000 ALTER TABLE `wp5_yoast_indexable` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wp5_terms`
--

DROP TABLE IF EXISTS `wp5_terms`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `wp5_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=MyISAM AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wp5_terms`
--

LOCK TABLES `wp5_terms` WRITE;
/*!40000 ALTER TABLE `wp5_terms` DISABLE KEYS */;
INSERT INTO `wp5_terms` VALUES (1,'Uncategorized','uncategorized',0);
INSERT INTO `wp5_terms` VALUES (2,'layout','layout',0);
INSERT INTO `wp5_terms` VALUES (3,'not_global','not_global',0);
INSERT INTO `wp5_terms` VALUES (4,'regular','regular',0);
INSERT INTO `wp5_terms` VALUES (5,'section','section',0);
INSERT INTO `wp5_terms` VALUES (6,'fullwidth','fullwidth',0);
INSERT INTO `wp5_terms` VALUES (7,'Author','author',0);
INSERT INTO `wp5_terms` VALUES (8,'row','row',0);
INSERT INTO `wp5_terms` VALUES (9,'main','main',0);
/*!40000 ALTER TABLE `wp5_terms` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wp5_usermeta`
--

DROP TABLE IF EXISTS `wp5_usermeta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `wp5_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=76 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wp5_usermeta`
--

LOCK TABLES `wp5_usermeta` WRITE;
/*!40000 ALTER TABLE `wp5_usermeta` DISABLE KEYS */;
INSERT INTO `wp5_usermeta` VALUES (1,1,'nickname','Nate2hoffelder');
INSERT INTO `wp5_usermeta` VALUES (2,1,'first_name','Nate');
INSERT INTO `wp5_usermeta` VALUES (3,1,'last_name','Hoffelder');
INSERT INTO `wp5_usermeta` VALUES (4,1,'description','');
INSERT INTO `wp5_usermeta` VALUES (5,1,'rich_editing','true');
INSERT INTO `wp5_usermeta` VALUES (6,1,'syntax_highlighting','true');
INSERT INTO `wp5_usermeta` VALUES (7,1,'comment_shortcuts','false');
INSERT INTO `wp5_usermeta` VALUES (8,1,'admin_color','fresh');
INSERT INTO `wp5_usermeta` VALUES (9,1,'use_ssl','0');
INSERT INTO `wp5_usermeta` VALUES (10,1,'show_admin_bar_front','true');
INSERT INTO `wp5_usermeta` VALUES (11,1,'locale','');
INSERT INTO `wp5_usermeta` VALUES (12,1,'wp5_capabilities','a:1:{s:13:"administrator";b:1;}');
INSERT INTO `wp5_usermeta` VALUES (13,1,'wp5_user_level','10');
INSERT INTO `wp5_usermeta` VALUES (14,1,'dismissed_wp_pointers','');
INSERT INTO `wp5_usermeta` VALUES (15,1,'show_welcome_panel','0');
INSERT INTO `wp5_usermeta` VALUES (75,3,'session_tokens','a:1:{s:64:"432a54261ebf84334ddb5f9ca812cdb4a1504c90991f886cf662611cd258f759";a:4:{s:10:"expiration";i:1751151496;s:2:"ip";s:38:"2601:140:8e80:4f30:b104:1411:1229:5d28";s:2:"ua";s:111:"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36";s:5:"login";i:1750978696;}}');
INSERT INTO `wp5_usermeta` VALUES (17,1,'wp5_dashboard_quick_press_last_post_id','205028');
INSERT INTO `wp5_usermeta` VALUES (23,1,'_pfd_onboarding','done');
INSERT INTO `wp5_usermeta` VALUES (24,1,'managenav-menuscolumnshidden','a:5:{i:0;s:11:"link-target";i:1;s:11:"css-classes";i:2;s:3:"xfn";i:3;s:11:"description";i:4;s:15:"title-attribute";}');
INSERT INTO `wp5_usermeta` VALUES (25,1,'metaboxhidden_nav-menus','a:5:{i:0;s:21:"add-post-type-project";i:1;s:12:"add-post_tag";i:2;s:15:"add-post_format";i:3;s:20:"add-project_category";i:4;s:15:"add-project_tag";}');
INSERT INTO `wp5_usermeta` VALUES (26,1,'nav_menu_recently_edited','9');
INSERT INTO `wp5_usermeta` VALUES (18,1,'wp5_user-settings','imgsize=medium&libraryContent=browse&align=right');
INSERT INTO `wp5_usermeta` VALUES (19,1,'wp5_user-settings-time','1614109103');
INSERT INTO `wp5_usermeta` VALUES (20,1,'community-events-location','a:1:{s:2:"ip";s:20:"2601:140:8e80:4f30::";}');
INSERT INTO `wp5_usermeta` VALUES (21,1,'wp5_media_library_mode','list');
INSERT INTO `wp5_usermeta` VALUES (22,1,'upload_per_page','40');
INSERT INTO `wp5_usermeta` VALUES (47,3,'nickname','new admin');
INSERT INTO `wp5_usermeta` VALUES (48,3,'first_name','');
INSERT INTO `wp5_usermeta` VALUES (49,3,'last_name','');
INSERT INTO `wp5_usermeta` VALUES (50,3,'description','');
INSERT INTO `wp5_usermeta` VALUES (51,3,'rich_editing','true');
INSERT INTO `wp5_usermeta` VALUES (52,3,'syntax_highlighting','true');
INSERT INTO `wp5_usermeta` VALUES (53,3,'comment_shortcuts','false');
INSERT INTO `wp5_usermeta` VALUES (54,3,'admin_color','fresh');
INSERT INTO `wp5_usermeta` VALUES (55,3,'use_ssl','0');
INSERT INTO `wp5_usermeta` VALUES (56,3,'show_admin_bar_front','true');
INSERT INTO `wp5_usermeta` VALUES (57,3,'locale','');
INSERT INTO `wp5_usermeta` VALUES (58,3,'wp5_capabilities','a:1:{s:13:"administrator";b:1;}');
INSERT INTO `wp5_usermeta` VALUES (59,3,'wp5_user_level','10');
INSERT INTO `wp5_usermeta` VALUES (60,3,'dismissed_wp_pointers','');
INSERT INTO `wp5_usermeta` VALUES (63,3,'wp5_dashboard_quick_press_last_post_id','205010');
INSERT INTO `wp5_usermeta` VALUES (64,3,'community-events-location','a:1:{s:2:"ip";s:20:"2601:140:8e80:4f30::";}');
INSERT INTO `wp5_usermeta` VALUES (65,3,'_pfd_onboarding','done');
INSERT INTO `wp5_usermeta` VALUES (66,3,'_dm_dismissed','a:2:{i:0;s:0:"";i:108636;i:1635354808;}');
INSERT INTO `wp5_usermeta` VALUES (67,3,'wp5_user-settings','imgsize=&libraryContent=browse&posts_list_mode=list');
INSERT INTO `wp5_usermeta` VALUES (68,3,'wp5_user-settings-time','1665200493');
INSERT INTO `wp5_usermeta` VALUES (71,3,'metaboxhidden_nav-menus','a:5:{i:0;s:21:"add-post-type-project";i:1;s:12:"add-post_tag";i:2;s:15:"add-post_format";i:3;s:20:"add-project_category";i:4;s:15:"add-project_tag";}');
INSERT INTO `wp5_usermeta` VALUES (69,3,'nav_menu_recently_edited','9');
INSERT INTO `wp5_usermeta` VALUES (70,3,'managenav-menuscolumnshidden','a:5:{i:0;s:11:"link-target";i:1;s:11:"css-classes";i:2;s:3:"xfn";i:3;s:11:"description";i:4;s:15:"title-attribute";}');
INSERT INTO `wp5_usermeta` VALUES (72,3,'edit_comments_per_page','100');
INSERT INTO `wp5_usermeta` VALUES (73,1,'session_tokens','a:1:{s:64:"b3b4538deb446d72e4963ae1928dc0f9108d828d81409ea7d27bb386096d5837";a:4:{s:10:"expiration";i:1768317010;s:2:"ip";s:38:"2601:140:8e80:4f30:794f:9978:d5f0:fc7b";s:2:"ua";s:111:"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36";s:5:"login";i:1768144210;}}');
INSERT INTO `wp5_usermeta` VALUES (74,1,'_dm_dismissed','a:4:{i:0;s:0:"";i:122864;i:1750978481;i:128070;i:1768144274;i:128191;i:1768146287;}');
/*!40000 ALTER TABLE `wp5_usermeta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wp5_postmeta`
--

DROP TABLE IF EXISTS `wp5_postmeta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `wp5_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=4495 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wp5_postmeta`
--

LOCK TABLES `wp5_postmeta` WRITE;
/*!40000 ALTER TABLE `wp5_postmeta` DISABLE KEYS */;
INSERT INTO `wp5_postmeta` VALUES (2,3,'_wp_page_template','default');
INSERT INTO `wp5_postmeta` VALUES (5,8,'_wp_attached_file','2020/10/StockSnap_8QLS0HOYMM-scaled-1.jpg');
INSERT INTO `wp5_postmeta` VALUES (6,8,'_wp_attachment_metadata','a:7:{s:5:"width";i:2560;s:6:"height";i:1708;s:4:"file";s:41:"2020/10/StockSnap_8QLS0HOYMM-scaled-1.jpg";s:5:"sizes";a:15:{s:6:"medium";a:4:{s:4:"file";s:41:"StockSnap_8QLS0HOYMM-scaled-1-300x200.jpg";s:5:"width";i:300;s:6:"height";i:200;s:9:"mime-type";s:10:"image/jpeg";}s:5:"large";a:4:{s:4:"file";s:42:"StockSnap_8QLS0HOYMM-scaled-1-1024x683.jpg";s:5:"width";i:1024;s:6:"height";i:683;s:9:"mime-type";s:10:"image/jpeg";}s:9:"thumbnail";a:4:{s:4:"file";s:41:"StockSnap_8QLS0HOYMM-scaled-1-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:12:"medium_large";a:4:{s:4:"file";s:41:"StockSnap_8QLS0HOYMM-scaled-1-768x512.jpg";s:5:"width";i:768;s:6:"height";i:512;s:9:"mime-type";s:10:"image/jpeg";}s:9:"1536x1536";a:4:{s:4:"file";s:43:"StockSnap_8QLS0HOYMM-scaled-1-1536x1025.jpg";s:5:"width";i:1536;s:6:"height";i:1025;s:9:"mime-type";s:10:"image/jpeg";}s:9:"2048x2048";a:4:{s:4:"file";s:43:"StockSnap_8QLS0HOYMM-scaled-1-2048x1366.jpg";s:5:"width";i:2048;s:6:"height";i:1366;s:9:"mime-type";s:10:"image/jpeg";}s:21:"et-pb-post-main-image";a:4:{s:4:"file";s:41:"StockSnap_8QLS0HOYMM-scaled-1-400x250.jpg";s:5:"width";i:400;s:6:"height";i:250;s:9:"mime-type";s:10:"image/jpeg";}s:31:"et-pb-post-main-image-fullwidth";a:4:{s:4:"file";s:42:"StockSnap_8QLS0HOYMM-scaled-1-1080x675.jpg";s:5:"width";i:1080;s:6:"height";i:675;s:9:"mime-type";s:10:"image/jpeg";}s:21:"et-pb-portfolio-image";a:4:{s:4:"file";s:41:"StockSnap_8QLS0HOYMM-scaled-1-400x284.jpg";s:5:"width";i:400;s:6:"height";i:284;s:9:"mime-type";s:10:"image/jpeg";}s:28:"et-pb-portfolio-module-image";a:4:{s:4:"file";s:41:"StockSnap_8QLS0HOYMM-scaled-1-510x382.jpg";s:5:"width";i:510;s:6:"height";i:382;s:9:"mime-type";s:10:"image/jpeg";}s:28:"et-pb-portfolio-image-single";a:4:{s:4:"file";s:42:"StockSnap_8QLS0HOYMM-scaled-1-1080x721.jpg";s:5:"width";i:1080;s:6:"height";i:721;s:9:"mime-type";s:10:"image/jpeg";}s:35:"et-pb-gallery-module-image-portrait";a:4:{s:4:"file";s:41:"StockSnap_8QLS0HOYMM-scaled-1-400x516.jpg";s:5:"width";i:400;s:6:"height";i:516;s:9:"mime-type";s:10:"image/jpeg";}s:32:"et-pb-image--responsive--desktop";a:4:{s:4:"file";s:42:"StockSnap_8QLS0HOYMM-scaled-1-1280x854.jpg";s:5:"width";i:1280;s:6:"height";i:854;s:9:"mime-type";s:10:"image/jpeg";}s:31:"et-pb-image--responsive--tablet";a:4:{s:4:"file";s:41:"StockSnap_8QLS0HOYMM-scaled-1-980x654.jpg";s:5:"width";i:980;s:6:"height";i:654;s:9:"mime-type";s:10:"image/jpeg";}s:30:"et-pb-image--responsive--phone";a:4:{s:4:"file";s:41:"StockSnap_8QLS0HOYMM-scaled-1-480x320.jpg";s:5:"width";i:480;s:6:"height";i:320;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}s:10:"ShortPixel";a:8:{s:4:"type";s:6:"glossy";s:8:"exifKept";s:1:"0";s:4:"date";s:19:"2020-10-20 19:15:57";s:9:"thumbsOpt";i:15;s:13:"thumbsOptList";a:15:{i:0;s:41:"StockSnap_8QLS0HOYMM-scaled-1-300x200.jpg";i:1;s:42:"StockSnap_8QLS0HOYMM-scaled-1-1024x683.jpg";i:2;s:41:"StockSnap_8QLS0HOYMM-scaled-1-150x150.jpg";i:3;s:41:"StockSnap_8QLS0HOYMM-scaled-1-768x512.jpg";i:4;s:43:"StockSnap_8QLS0HOYMM-scaled-1-1536x1025.jpg";i:5;s:43:"StockSnap_8QLS0HOYMM-scaled-1-2048x1366.jpg";i:6;s:41:"StockSnap_8QLS0HOYMM-scaled-1-400x250.jpg";i:7;s:42:"StockSnap_8QLS0HOYMM-scaled-1-1080x675.jpg";i:8;s:41:"StockSnap_8QLS0HOYMM-scaled-1-400x284.jpg";i:9;s:41:"StockSnap_8QLS0HOYMM-scaled-1-510x382.jpg";i:10;s:42:"StockSnap_8QLS0HOYMM-scaled-1-1080x721.jpg";i:11;s:41:"StockSnap_8QLS0HOYMM-scaled-1-400x516.jpg";i:12;s:42:"StockSnap_8QLS0HOYMM-scaled-1-1280x854.jpg";i:13;s:41:"StockSnap_8QLS0HOYMM-scaled-1-980x654.jpg";i:14;s:41:"StockSnap_8QLS0HOYMM-scaled-1-480x320.jpg";}s:12:"excludeSizes";a:0:{}s:10:"retinasOpt";i:0;s:8:"NoBackup";b:1;}s:21:"ShortPixelImprovement";s:5:"16.37";}');
INSERT INTO `wp5_postmeta` VALUES (7,9,'_wp_attached_file','2020/10/Depositphotos_38610877_xl-2015-300x300-1.jpg');
INSERT INTO `wp5_postmeta` VALUES (8,9,'_wp_attachment_metadata','a:7:{s:5:"width";i:300;s:6:"height";i:300;s:4:"file";s:52:"2020/10/Depositphotos_38610877_xl-2015-300x300-1.jpg";s:5:"sizes";a:3:{s:9:"thumbnail";a:4:{s:4:"file";s:52:"Depositphotos_38610877_xl-2015-300x300-1-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:21:"et-pb-post-main-image";a:4:{s:4:"file";s:52:"Depositphotos_38610877_xl-2015-300x300-1-300x250.jpg";s:5:"width";i:300;s:6:"height";i:250;s:9:"mime-type";s:10:"image/jpeg";}s:21:"et-pb-portfolio-image";a:4:{s:4:"file";s:52:"Depositphotos_38610877_xl-2015-300x300-1-300x284.jpg";s:5:"width";i:300;s:6:"height";i:284;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}s:10:"ShortPixel";a:8:{s:4:"type";s:6:"glossy";s:8:"exifKept";s:1:"0";s:4:"date";s:19:"2020-10-20 19:15:38";s:9:"thumbsOpt";i:3;s:13:"thumbsOptList";a:3:{i:0;s:52:"Depositphotos_38610877_xl-2015-300x300-1-150x150.jpg";i:1;s:52:"Depositphotos_38610877_xl-2015-300x300-1-300x250.jpg";i:2;s:52:"Depositphotos_38610877_xl-2015-300x300-1-300x284.jpg";}s:12:"excludeSizes";a:0:{}s:10:"retinasOpt";i:0;s:8:"NoBackup";b:1;}s:21:"ShortPixelImprovement";s:5:"13.48";}');
INSERT INTO `wp5_postmeta` VALUES (719,9,'_shortpixel_status','2.1300');
INSERT INTO `wp5_postmeta` VALUES (705,28209,'_shortpixel_status','2.1400');
INSERT INTO `wp5_postmeta` VALUES (917,204271,'_wp_attached_file','2020/10/Depositphotos_185209912_xl-2015-1-scaled.jpg');
INSERT INTO `wp5_postmeta` VALUES (918,204271,'_wp_attachment_metadata','a:8:{s:5:"width";i:2560;s:6:"height";i:1025;s:4:"file";s:52:"2020/10/Depositphotos_185209912_xl-2015-1-scaled.jpg";s:5:"sizes";a:16:{s:6:"medium";a:4:{s:4:"file";s:45:"Depositphotos_185209912_xl-2015-1-300x120.jpg";s:5:"width";i:300;s:6:"height";i:120;s:9:"mime-type";s:10:"image/jpeg";}s:5:"large";a:4:{s:4:"file";s:46:"Depositphotos_185209912_xl-2015-1-1024x410.jpg";s:5:"width";i:1024;s:6:"height";i:410;s:9:"mime-type";s:10:"image/jpeg";}s:9:"thumbnail";a:4:{s:4:"file";s:45:"Depositphotos_185209912_xl-2015-1-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:12:"medium_large";a:4:{s:4:"file";s:45:"Depositphotos_185209912_xl-2015-1-768x308.jpg";s:5:"width";i:768;s:6:"height";i:308;s:9:"mime-type";s:10:"image/jpeg";}s:9:"1536x1536";a:4:{s:4:"file";s:46:"Depositphotos_185209912_xl-2015-1-1536x615.jpg";s:5:"width";i:1536;s:6:"height";i:615;s:9:"mime-type";s:10:"image/jpeg";}s:9:"2048x2048";a:4:{s:4:"file";s:46:"Depositphotos_185209912_xl-2015-1-2048x820.jpg";s:5:"width";i:2048;s:6:"height";i:820;s:9:"mime-type";s:10:"image/jpeg";}s:21:"et-pb-post-main-image";a:4:{s:4:"file";s:45:"Depositphotos_185209912_xl-2015-1-400x250.jpg";s:5:"width";i:400;s:6:"height";i:250;s:9:"mime-type";s:10:"image/jpeg";}s:31:"et-pb-post-main-image-fullwidth";a:4:{s:4:"file";s:46:"Depositphotos_185209912_xl-2015-1-1080x675.jpg";s:5:"width";i:1080;s:6:"height";i:675;s:9:"mime-type";s:10:"image/jpeg";}s:21:"et-pb-portfolio-image";a:4:{s:4:"file";s:45:"Depositphotos_185209912_xl-2015-1-400x284.jpg";s:5:"width";i:400;s:6:"height";i:284;s:9:"mime-type";s:10:"image/jpeg";}s:28:"et-pb-portfolio-module-image";a:4:{s:4:"file";s:45:"Depositphotos_185209912_xl-2015-1-510x382.jpg";s:5:"width";i:510;s:6:"height";i:382;s:9:"mime-type";s:10:"image/jpeg";}s:28:"et-pb-portfolio-image-single";a:4:{s:4:"file";s:46:"Depositphotos_185209912_xl-2015-1-1080x433.jpg";s:5:"width";i:1080;s:6:"height";i:433;s:9:"mime-type";s:10:"image/jpeg";}s:35:"et-pb-gallery-module-image-portrait";a:4:{s:4:"file";s:45:"Depositphotos_185209912_xl-2015-1-400x516.jpg";s:5:"width";i:400;s:6:"height";i:516;s:9:"mime-type";s:10:"image/jpeg";}s:37:"et-pb-post-main-image-fullwidth-large";a:4:{s:4:"file";s:47:"Depositphotos_185209912_xl-2015-1-2880x1800.jpg";s:5:"width";i:2880;s:6:"height";i:1800;s:9:"mime-type";s:10:"image/jpeg";}s:32:"et-pb-image--responsive--desktop";a:4:{s:4:"file";s:46:"Depositphotos_185209912_xl-2015-1-1280x513.jpg";s:5:"width";i:1280;s:6:"height";i:513;s:9:"mime-type";s:10:"image/jpeg";}s:31:"et-pb-image--responsive--tablet";a:4:{s:4:"file";s:45:"Depositphotos_185209912_xl-2015-1-980x392.jpg";s:5:"width";i:980;s:6:"height";i:392;s:9:"mime-type";s:10:"image/jpeg";}s:30:"et-pb-image--responsive--phone";a:4:{s:4:"file";s:45:"Depositphotos_185209912_xl-2015-1-480x192.jpg";s:5:"width";i:480;s:6:"height";i:192;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:112:"man standing on balcony looking at futuristic city with colorful light, digital art style, illustration painting";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"1";s:8:"keywords";a:26:{i:0;s:12:"illustration";i:1;s:8:"painting";i:2;s:3:"art";i:3;s:11:"imagination";i:4;s:8:"artistic";i:5;s:7:"artwork";i:6;s:7:"acrylic";i:7;s:5:"scene";i:8;s:11:"neon lights";i:9;s:5:"urban";i:10;s:5:"light";i:11;s:12:"illumination";i:12;s:9:"cyberpunk";i:13;s:10:"futuristic";i:14;s:15:"science fiction";i:15;s:6:"sci-fi";i:16;s:7:"outdoor";i:17;s:9:"cityscape";i:18;s:3:"man";i:19;s:8:"standing";i:20;s:10:"skyscraper";i:21;s:9:"buildings";i:22;s:4:"city";i:23;s:7:"looking";i:24;s:7:"concept";i:25;s:4:"view";}}s:14:"original_image";s:37:"Depositphotos_185209912_xl-2015-1.jpg";s:10:"ShortPixel";a:8:{s:4:"type";s:6:"glossy";s:8:"exifKept";s:1:"0";s:4:"date";s:19:"2020-10-22 15:20:04";s:9:"thumbsOpt";i:17;s:13:"thumbsOptList";a:17:{i:0;s:37:"Depositphotos_185209912_xl-2015-1.jpg";i:1;s:45:"Depositphotos_185209912_xl-2015-1-300x120.jpg";i:2;s:46:"Depositphotos_185209912_xl-2015-1-1024x410.jpg";i:3;s:45:"Depositphotos_185209912_xl-2015-1-150x150.jpg";i:4;s:45:"Depositphotos_185209912_xl-2015-1-768x308.jpg";i:5;s:46:"Depositphotos_185209912_xl-2015-1-1536x615.jpg";i:6;s:46:"Depositphotos_185209912_xl-2015-1-2048x820.jpg";i:7;s:45:"Depositphotos_185209912_xl-2015-1-400x250.jpg";i:8;s:46:"Depositphotos_185209912_xl-2015-1-1080x675.jpg";i:9;s:45:"Depositphotos_185209912_xl-2015-1-400x284.jpg";i:10;s:45:"Depositphotos_185209912_xl-2015-1-510x382.jpg";i:11;s:46:"Depositphotos_185209912_xl-2015-1-1080x433.jpg";i:12;s:45:"Depositphotos_185209912_xl-2015-1-400x516.jpg";i:13;s:47:"Depositphotos_185209912_xl-2015-1-2880x1800.jpg";i:14;s:46:"Depositphotos_185209912_xl-2015-1-1280x513.jpg";i:15;s:45:"Depositphotos_185209912_xl-2015-1-980x392.jpg";i:16;s:45:"Depositphotos_185209912_xl-2015-1-480x192.jpg";}s:12:"excludeSizes";a:0:{}s:10:"retinasOpt";i:0;s:8:"NoBackup";b:1;}s:21:"ShortPixelImprovement";s:4:"54.2";}');
INSERT INTO `wp5_postmeta` VALUES (21,16,'_wp_attached_file','2020/10/rsz_stocksnap_kpgb8iqqgc-scaled-1.jpg');
INSERT INTO `wp5_postmeta` VALUES (22,16,'_wp_attachment_metadata','a:7:{s:5:"width";i:2560;s:6:"height";i:1912;s:4:"file";s:45:"2020/10/rsz_stocksnap_kpgb8iqqgc-scaled-1.jpg";s:5:"sizes";a:16:{s:6:"medium";a:4:{s:4:"file";s:45:"rsz_stocksnap_kpgb8iqqgc-scaled-1-300x224.jpg";s:5:"width";i:300;s:6:"height";i:224;s:9:"mime-type";s:10:"image/jpeg";}s:5:"large";a:4:{s:4:"file";s:46:"rsz_stocksnap_kpgb8iqqgc-scaled-1-1024x765.jpg";s:5:"width";i:1024;s:6:"height";i:765;s:9:"mime-type";s:10:"image/jpeg";}s:9:"thumbnail";a:4:{s:4:"file";s:45:"rsz_stocksnap_kpgb8iqqgc-scaled-1-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:12:"medium_large";a:4:{s:4:"file";s:45:"rsz_stocksnap_kpgb8iqqgc-scaled-1-768x574.jpg";s:5:"width";i:768;s:6:"height";i:574;s:9:"mime-type";s:10:"image/jpeg";}s:9:"1536x1536";a:4:{s:4:"file";s:47:"rsz_stocksnap_kpgb8iqqgc-scaled-1-1536x1147.jpg";s:5:"width";i:1536;s:6:"height";i:1147;s:9:"mime-type";s:10:"image/jpeg";}s:9:"2048x2048";a:4:{s:4:"file";s:47:"rsz_stocksnap_kpgb8iqqgc-scaled-1-2048x1530.jpg";s:5:"width";i:2048;s:6:"height";i:1530;s:9:"mime-type";s:10:"image/jpeg";}s:21:"et-pb-post-main-image";a:4:{s:4:"file";s:45:"rsz_stocksnap_kpgb8iqqgc-scaled-1-400x250.jpg";s:5:"width";i:400;s:6:"height";i:250;s:9:"mime-type";s:10:"image/jpeg";}s:31:"et-pb-post-main-image-fullwidth";a:4:{s:4:"file";s:46:"rsz_stocksnap_kpgb8iqqgc-scaled-1-1080x675.jpg";s:5:"width";i:1080;s:6:"height";i:675;s:9:"mime-type";s:10:"image/jpeg";}s:21:"et-pb-portfolio-image";a:4:{s:4:"file";s:45:"rsz_stocksnap_kpgb8iqqgc-scaled-1-400x284.jpg";s:5:"width";i:400;s:6:"height";i:284;s:9:"mime-type";s:10:"image/jpeg";}s:28:"et-pb-portfolio-module-image";a:4:{s:4:"file";s:45:"rsz_stocksnap_kpgb8iqqgc-scaled-1-510x382.jpg";s:5:"width";i:510;s:6:"height";i:382;s:9:"mime-type";s:10:"image/jpeg";}s:28:"et-pb-portfolio-image-single";a:4:{s:4:"file";s:46:"rsz_stocksnap_kpgb8iqqgc-scaled-1-1080x807.jpg";s:5:"width";i:1080;s:6:"height";i:807;s:9:"mime-type";s:10:"image/jpeg";}s:35:"et-pb-gallery-module-image-portrait";a:4:{s:4:"file";s:45:"rsz_stocksnap_kpgb8iqqgc-scaled-1-400x516.jpg";s:5:"width";i:400;s:6:"height";i:516;s:9:"mime-type";s:10:"image/jpeg";}s:37:"et-pb-post-main-image-fullwidth-large";a:4:{s:4:"file";s:47:"rsz_stocksnap_kpgb8iqqgc-scaled-1-2560x1800.jpg";s:5:"width";i:2560;s:6:"height";i:1800;s:9:"mime-type";s:10:"image/jpeg";}s:32:"et-pb-image--responsive--desktop";a:4:{s:4:"file";s:46:"rsz_stocksnap_kpgb8iqqgc-scaled-1-1280x956.jpg";s:5:"width";i:1280;s:6:"height";i:956;s:9:"mime-type";s:10:"image/jpeg";}s:31:"et-pb-image--responsive--tablet";a:4:{s:4:"file";s:45:"rsz_stocksnap_kpgb8iqqgc-scaled-1-980x732.jpg";s:5:"width";i:980;s:6:"height";i:732;s:9:"mime-type";s:10:"image/jpeg";}s:30:"et-pb-image--responsive--phone";a:4:{s:4:"file";s:45:"rsz_stocksnap_kpgb8iqqgc-scaled-1-480x359.jpg";s:5:"width";i:480;s:6:"height";i:359;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}s:10:"ShortPixel";a:8:{s:4:"type";s:6:"glossy";s:8:"exifKept";s:1:"0";s:4:"date";s:19:"2020-10-20 19:15:27";s:9:"thumbsOpt";i:16;s:13:"thumbsOptList";a:16:{i:0;s:45:"rsz_stocksnap_kpgb8iqqgc-scaled-1-300x224.jpg";i:1;s:46:"rsz_stocksnap_kpgb8iqqgc-scaled-1-1024x765.jpg";i:2;s:45:"rsz_stocksnap_kpgb8iqqgc-scaled-1-150x150.jpg";i:3;s:45:"rsz_stocksnap_kpgb8iqqgc-scaled-1-768x574.jpg";i:4;s:47:"rsz_stocksnap_kpgb8iqqgc-scaled-1-1536x1147.jpg";i:5;s:47:"rsz_stocksnap_kpgb8iqqgc-scaled-1-2048x1530.jpg";i:6;s:45:"rsz_stocksnap_kpgb8iqqgc-scaled-1-400x250.jpg";i:7;s:46:"rsz_stocksnap_kpgb8iqqgc-scaled-1-1080x675.jpg";i:8;s:45:"rsz_stocksnap_kpgb8iqqgc-scaled-1-400x284.jpg";i:9;s:45:"rsz_stocksnap_kpgb8iqqgc-scaled-1-510x382.jpg";i:10;s:46:"rsz_stocksnap_kpgb8iqqgc-scaled-1-1080x807.jpg";i:11;s:45:"rsz_stocksnap_kpgb8iqqgc-scaled-1-400x516.jpg";i:12;s:47:"rsz_stocksnap_kpgb8iqqgc-scaled-1-2560x1800.jpg";i:13;s:46:"rsz_stocksnap_kpgb8iqqgc-scaled-1-1280x956.jpg";i:14;s:45:"rsz_stocksnap_kpgb8iqqgc-scaled-1-980x732.jpg";i:15;s:45:"rsz_stocksnap_kpgb8iqqgc-scaled-1-480x359.jpg";}s:12:"excludeSizes";a:0:{}s:10:"retinasOpt";i:0;s:8:"NoBackup";b:1;}s:21:"ShortPixelImprovement";s:4:"6.94";}');
INSERT INTO `wp5_postmeta` VALUES (715,28142,'_shortpixel_status','2.4500');
INSERT INTO `wp5_postmeta` VALUES (1391,204484,'_wp_attachment_metadata','a:7:{s:5:"width";i:2000;s:6:"height";i:200;s:4:"file";s:28:"2020/11/author_signature.png";s:5:"sizes";a:15:{s:6:"medium";a:4:{s:4:"file";s:27:"author_signature-300x30.png";s:5:"width";i:300;s:6:"height";i:30;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:29:"author_signature-1024x102.png";s:5:"width";i:1024;s:6:"height";i:102;s:9:"mime-type";s:9:"image/png";}s:9:"thumbnail";a:4:{s:4:"file";s:28:"author_signature-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:12:"medium_large";a:4:{s:4:"file";s:27:"author_signature-768x77.png";s:5:"width";i:768;s:6:"height";i:77;s:9:"mime-type";s:9:"image/png";}s:9:"1536x1536";a:4:{s:4:"file";s:29:"author_signature-1536x154.png";s:5:"width";i:1536;s:6:"height";i:154;s:9:"mime-type";s:9:"image/png";}s:11:"bloom_image";a:4:{s:4:"file";s:27:"author_signature-610x61.png";s:5:"width";i:610;s:6:"height";i:61;s:9:"mime-type";s:9:"image/png";}s:21:"et-pb-post-main-image";a:4:{s:4:"file";s:28:"author_signature-400x200.png";s:5:"width";i:400;s:6:"height";i:200;s:9:"mime-type";s:9:"image/png";}s:31:"et-pb-post-main-image-fullwidth";a:4:{s:4:"file";s:29:"author_signature-1080x200.png";s:5:"width";i:1080;s:6:"height";i:200;s:9:"mime-type";s:9:"image/png";}s:21:"et-pb-portfolio-image";a:4:{s:4:"file";s:28:"author_signature-400x200.png";s:5:"width";i:400;s:6:"height";i:200;s:9:"mime-type";s:9:"image/png";}s:28:"et-pb-portfolio-module-image";a:4:{s:4:"file";s:28:"author_signature-510x200.png";s:5:"width";i:510;s:6:"height";i:200;s:9:"mime-type";s:9:"image/png";}s:28:"et-pb-portfolio-image-single";a:4:{s:4:"file";s:29:"author_signature-1080x108.png";s:5:"width";i:1080;s:6:"height";i:108;s:9:"mime-type";s:9:"image/png";}s:35:"et-pb-gallery-module-image-portrait";a:4:{s:4:"file";s:28:"author_signature-400x200.png";s:5:"width";i:400;s:6:"height";i:200;s:9:"mime-type";s:9:"image/png";}s:32:"et-pb-image--responsive--desktop";a:4:{s:4:"file";s:29:"author_signature-1280x128.png";s:5:"width";i:1280;s:6:"height";i:128;s:9:"mime-type";s:9:"image/png";}s:31:"et-pb-image--responsive--tablet";a:4:{s:4:"file";s:27:"author_signature-980x98.png";s:5:"width";i:980;s:6:"height";i:98;s:9:"mime-type";s:9:"image/png";}s:30:"et-pb-image--responsive--phone";a:4:{s:4:"file";s:27:"author_signature-480x48.png";s:5:"width";i:480;s:6:"height";i:48;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}s:10:"ShortPixel";a:8:{s:4:"type";s:6:"glossy";s:8:"exifKept";s:1:"0";s:4:"date";s:19:"2020-11-06 04:53:35";s:9:"thumbsOpt";i:13;s:13:"thumbsOptList";a:13:{i:0;s:27:"author_signature-300x30.png";i:1;s:29:"author_signature-1024x102.png";i:2;s:28:"author_signature-150x150.png";i:3;s:27:"author_signature-768x77.png";i:4;s:29:"author_signature-1536x154.png";i:5;s:27:"author_signature-610x61.png";i:6;s:28:"author_signature-400x200.png";i:7;s:29:"author_signature-1080x200.png";i:8;s:28:"author_signature-510x200.png";i:9;s:29:"author_signature-1080x108.png";i:10;s:29:"author_signature-1280x128.png";i:11;s:27:"author_signature-980x98.png";i:12;s:27:"author_signature-480x48.png";}s:12:"excludeSizes";a:0:{}s:10:"retinasOpt";i:0;s:8:"NoBackup";b:1;}s:21:"ShortPixelImprovement";s:5:"82.39";}');
INSERT INTO `wp5_postmeta` VALUES (922,204270,'_shortpixel_status','2.8000');
INSERT INTO `wp5_postmeta` VALUES (923,204274,'_edit_last','1');
INSERT INTO `wp5_postmeta` VALUES (924,204274,'_edit_lock','1693165952:3');
INSERT INTO `wp5_postmeta` VALUES (925,204274,'_wp_page_template','default');
INSERT INTO `wp5_postmeta` VALUES (926,204274,'_et_pb_post_hide_nav','default');
INSERT INTO `wp5_postmeta` VALUES (927,204274,'_et_pb_page_layout','et_right_sidebar');
INSERT INTO `wp5_postmeta` VALUES (928,204274,'_et_pb_side_nav','off');
INSERT INTO `wp5_postmeta` VALUES (929,204274,'_et_pb_use_builder','on');
INSERT INTO `wp5_postmeta` VALUES (930,204274,'_et_pb_first_image','');
INSERT INTO `wp5_postmeta` VALUES (931,204274,'_et_pb_truncate_post','<p><div class="et_pb_section et_pb_section_8 about-me-title-section et_pb_with_background et_section_regular" >\n				\n				\n				\n				\n				\n				\n				<div class="et_pb_row et_pb_row_8">\n				<div class="et_pb_column et_pb_column_4_4 et_pb_column_12  et_pb_css_mix_blend_mode_passthrough et-last-child">\n				\n				\n				\n				\n				<div class="et_pb_module et_pb_text et_pb_text_7 about-me-title  et_pb_text_align_left et_pb_bg_layout_dark">\n				\n				\n				\n				\n				<div class="et_pb_text_inner">About Me</div>\n			</div>\n			</div>\n				\n				\n				\n				\n			</div>\n				\n				\n			</div><div class="et_pb_section et_pb_section_9 about-me-author-section et_pb_with_background et_pb_section_parallax et_section_regular" >\n				\n				\n				\n				\n				\n				\n				<div class="et_pb_row et_pb_row_9">\n				<div class="et_pb_column et_pb_column_1_2 et_pb_column_13  et_pb_css_mix_blend_mode_passthrough">\n				\n				\n				\n				\n				<div class="et_pb_module et_pb_image et_pb_image_3 about-me-author-image">\n				\n				\n				\n				\n				<span class="et_pb_image_wrap "><img decoding="async" width="1500" height="1500" src="https://gibson.authorwebsiteinabox.com/wp-content/uploads/2020/10/Author-Photo.jpg" alt="" title="Author Photo" srcset="https://gibson.authorwebsiteinabox.com/wp-content/uploads/2020/10/Author-Photo.jpg 1500w, https://gibson.authorwebsiteinabox.com/wp-content/uploads/2020/10/Author-Photo-1280x1280.jpg 1280w, https://gibson.authorwebsiteinabox.com/wp-content/uploads/2020/10/Author-Photo-980x980.jpg 980w, https://gibson.authorwebsiteinabox.com/wp-content/uploads/2020/10/Author-Photo-480x480.jpg 480w" sizes="(min-width: 0px) and (max-width: 480px) 480px, (min-width: 481px) and (max-width: 980px) 980px, (min-width: 981px) and (max-width: 1280px) 1280px, (min-width: 1281px) 1500px, 100vw" class="wp-image-204084" /></span>\n			</div>\n			</div><div class="et_pb_column et_pb_column_1_2 et_pb_column_14  et_pb_css_mix_blend_mode_passthrough et-last-child">\n				\n				\n				\n				\n				<div class="et_pb_module et_pb_text et_pb_text_8 about-me-author  et_pb_text_align_center et_pb_bg_layout_light">\n				\n				\n				\n				\n				<div class="et_pb_text_inner">Best Selling Author<br />\nAuthor Name</div>\n			</div>\n			</div>\n				\n				\n				\n				\n			</div><div class="et_pb_row et_pb_row_10">\n				<div class="et_pb_column et_pb_column_4_4 et_pb_column_15  et_pb_css_mix_blend_mode_passthrough et-last-child">\n				\n				\n				\n				\n				<div id="about-me-author-text" class="et_pb_module et_pb_text et_pb_text_9  et_pb_text_align_center et_pb_bg_layout_light">\n				\n				\n				\n				\n				<div class="et_pb_text_inner">Duis ut consectetur mauris, sit amet convallis mauris. Aenean lectus turpis, efficitur vel odio at, aliquet. Donec sollicitudin lacinia risus, non tempor sapien dignissim scelerisque. Integer eget pellentesque dui, quis ultrices urna. Duis ut consectetur mauris, sit amet convallis mauris. Aenean lectus turpis, efficitur vel odio at, aliquet. Donec sollicitudin lacinia risus,Duis ut consectetur mauris, sit amet convallis mauris. Aenean lectus turpis, efficitur vel odio at, aliquet. Donec sollicitudin lacinia risus, non tempor sapien dignissim scelerisque. Integer eget pellentesque dui,</div>\n			</div>\n			</div>\n				\n				\n				\n				\n			</div>\n				\n				\n			</div><div class="et_pb_section et_pb_section_10 at_section about-me-events et_pb_with_background et_section_regular" >\n				\n				\n				\n				\n				\n				\n				<div class="et_pb_row et_pb_row_11">\n				<div class="et_pb_column et_pb_column_4_4 et_pb_column_16  et_pb_css_mix_blend_mode_passthrough et-last-child">\n				\n				\n				\n				\n				<div class="et_pb_module et_pb_text et_pb_text_10  et_pb_text_align_center et_pb_bg_layout_light">\n				\n				\n				\n				\n				<div class="et_pb_text_inner">Events</div>\n			</div><div class="et_pb_module et_pb_divider et_pb_divider_0 et_pb_space"><div class="et_pb_divider_internal"></div></div><div class="et_pb_module et_pb_text et_pb_text_11  et_pb_text_align_center et_pb_bg_layout_dark">\n				\n				\n				\n				\n				<div class="et_pb_text_inner">Meet me if you dare</div>\n			</div>\n			</div>\n				\n				\n				\n				\n			</div><div class="et_pb_row et_pb_row_12 et_pb_gutters2">\n				<div class="et_pb_column et_pb_column_1_2 et_pb_column_17  et_pb_css_mix_blend_mode_passthrough">\n				\n				\n				\n				\n				<div class="et_pb_module et_pb_blurb et_pb_blurb_0 at_event et_pb_section_video_on_hover  et_pb_text_align_left  et_pb_blurb_position_left et_pb_bg_layout_dark">\n				\n				\n				\n				\n				<div class="et_pb_blurb_content">\n					<div class="et_pb_main_blurb_image"><span class="et_pb_image_wrap et_pb_only_image_mode_wrap"><img decoding="async" width="300" height="200" src="https://gibson.authorwebsiteinabox.com/wp-content/uploads/2020/10/StockSnap_75TIS9MIMF-300x200.jpg" alt="" class="et-waypoint et_pb_animation_off et_pb_animation_off_tablet et_pb_animation_off_phone wp-image-204091" /></span></div>\n					<div class="et_pb_blurb_container">\n						<h3 class="et_pb_module_header"><span>Location</span></h3>\n						<div class="et_pb_blurb_description">Platform<br />\nJan 20, 2021 |  Tickets: $XX</div>\n					</div>\n				</div>\n			</div><div class="et_pb_module et_pb_blurb et_pb_blurb_1 at_event et_pb_section_video_on_hover  et_pb_text_align_left  et_pb_blurb_position_left et_pb_bg_layout_dark">\n				\n				\n				\n				\n				<div class="et_pb_blurb_content">\n					<div class="et_pb_main_blurb_image"><span class="et_pb_image_wrap et_pb_only_image_mode_wrap"><img decoding="async" loading="lazy" width="300" height="199" src="https://gibson.authorwebsiteinabox.com/wp-content/uploads/2020/10/StockSnap_IUJWYVKFMQ-300x199.jpg" alt="" class="et-waypoint et_pb_animation_off et_pb_animation_off_tablet et_pb_animation_off_phone wp-image-204093" /></span></div>\n					<div class="et_pb_blurb_container">\n						<h3 class="et_pb_module_header"><span>Location</span></h3>\n						<div class="et_pb_blurb_description">Platform<br />\nJan 20, 2021 |  Tickets: $XX</div>\n					</div>\n				</div>\n			</div><div class="et_pb_module et_pb_blurb et_pb_blurb_2 at_event et_pb_section_video_on_hover  et_pb_text_align_left  et_pb_blurb_position_left et_pb_bg_layout_dark">\n				\n				\n				\n				\n				<div class="et_pb_blurb_content">\n					<div class="et_pb_main_blurb_image"><span class="et_pb_image_wrap et_pb_only_image_mode_wrap"><img decoding="async" loading="lazy" width="300" height="177" src="https://gibson.authorwebsiteinabox.com/wp-content/uploads/2020/10/StockSnap_RFPRHTKURW-300x177.jpg" alt="" class="et-waypoint et_pb_animation_off et_pb_animation_off_tablet et_pb_animation_off_phone wp-image-204092" /></span></div>\n					<div class="et_pb_blurb_container">\n						<h3 class="et_pb_module_header"><span>Location</span></h3>\n						<div class="et_pb_blurb_description">Platform<br />\nJan 20, 2021 |  Tickets: $XX</div>\n					</div>\n				</div>\n			</div>\n			</div><div class="et_pb_column et_pb_column_1_2 et_pb_column_18  et_pb_css_mix_blend_mode_passthrough et-last-child">\n				\n				\n				\n				\n				<div class="et_pb_module et_pb_blurb et_pb_blurb_3 at_event et_pb_section_video_on_hover  et_pb_text_align_left  et_pb_blurb_position_left et_pb_bg_layout_dark">\n				\n				\n				\n				\n				<div class="et_pb_blurb_content">\n					<div class="et_pb_main_blurb_image"><span class="et_pb_image_wrap et_pb_only_image_mode_wrap"><img decoding="async" loading="lazy" width="300" height="200" src="https://gibson.authorwebsiteinabox.com/wp-content/uploads/2020/10/StockSnap_NN7QYFUPXT-300x200.jpg" alt="" class="et-waypoint et_pb_animation_off et_pb_animation_off_tablet et_pb_animation_off_phone wp-image-204094" /></span></div>\n					<div class="et_pb_blurb_container">\n						<h3 class="et_pb_module_header"><span>Location</span></h3>\n						<div class="et_pb_blurb_description">Platform<br />\nJan 20, 2021 |  Tickets: $XX</div>\n					</div>\n				</div>\n			</div><div class="et_pb_module et_pb_blurb et_pb_blurb_4 at_event et_pb_section_video_on_hover  et_pb_text_align_left  et_pb_blurb_position_left et_pb_bg_layout_dark">\n				\n				\n				\n				\n				<div class="et_pb_blurb_content">\n					<div class="et_pb_main_blurb_image"><span class="et_pb_image_wrap et_pb_only_image_mode_wrap"><img decoding="async" loading="lazy" width="300" height="200" src="https://gibson.authorwebsiteinabox.com/wp-content/uploads/2020/10/StockSnap_3Q79ZWSUQS-300x200.jpg" alt="" class="et-waypoint et_pb_animation_off et_pb_animation_off_tablet et_pb_animation_off_phone wp-image-204096" /></span></div>\n					<div class="et_pb_blurb_container">\n						<h3 class="et_pb_module_header"><span>Location</span></h3>\n						<div class="et_pb_blurb_description">Platform<br />\nJan 20, 2021 |  Tickets: $XX</div>\n					</div>\n				</div>\n			</div><div class="et_pb_module et_pb_blurb et_pb_blurb_5 at_event et_pb_section_video_on_hover  et_pb_text_align_left  et_pb_blurb_position_left et_pb_bg_layout_dark">\n				\n				\n				\n				\n				<div class="et_pb_blurb_content">\n					<div class="et_pb_main_blurb_image"><span class="et_pb_image_wrap et_pb_only_image_mode_wrap"><img decoding="async" loading="lazy" width="300" height="169" src="https://gibson.authorwebsiteinabox.com/wp-content/uploads/2020/10/StockSnap_6TOUOJV8MB-300x169.jpg" alt="" class="et-waypoint et_pb_animation_off et_pb_animation_off_tablet et_pb_animation_off_phone wp-image-204095" /></span></div>\n					<div class="et_pb_blurb_container">\n						<h3 class="et_pb_module_header"><span>Location</span></h3>\n						<div class="et_pb_blurb_description">Platform<br />\nJan 20, 2021 |  Tickets: $XX</div>\n					</div>\n				</div>\n			</div>\n			</div>\n				\n				\n				\n				\n			</div>\n				\n				\n			</div><div class="et_pb_section et_pb_section_11 at_section about-me-faq et_pb_with_background et_section_regular" >\n				\n				\n				\n				\n				\n				\n				<div class="et_pb_row et_pb_row_13">\n				<div class="et_pb_column et_pb_column_4_4 et_pb_column_19  et_pb_css_mix_blend_mode_passthrough et-last-child">\n				\n				\n				\n				\n				<div class="et_pb_module et_pb_text et_pb_text_12  et_pb_text_align_center et_pb_bg_layout_light">\n				\n				\n				\n				\n				<div class="et_pb_text_inner">FAQ</div>\n			</div><div class="et_pb_module et_pb_divider et_pb_divider_1 et_pb_space"><div class="et_pb_divider_internal"></div></div><div class="et_pb_module et_pb_text et_pb_text_13  et_pb_text_align_center et_pb_bg_layout_light">\n				\n				\n				\n				\n				<div class="et_pb_text_inner">Nel settore della tipografia e della stampa.</div>\n			</div>\n			</div>\n				\n				\n				\n				\n			</div><div class="et_pb_row et_pb_row_14">\n				<div class="et_pb_column et_pb_column_1_2 et_pb_column_20  et_pb_css_mix_blend_mode_passthrough">\n				\n				\n				\n				\n				<div class="et_pb_module et_pb_text et_pb_text_14  et_pb_text_align_left et_pb_bg_layout_light">\n				\n				\n				\n				\n				<div class="et_pb_text_inner">Invite me to speak!</div>\n			</div><div class="et_pb_module et_pb_divider et_pb_divider_2 et_pb_space"><div class="et_pb_divider_internal"></div></div><div class="et_pb_module et_pb_text et_pb_text_15  et_pb_text_align_left et_pb_bg_layout_light">\n				\n				\n				\n				\n				<div class="et_pb_text_inner">Lorem ipsum is placeholder text. Replace this text with a pitch which describes what you can talk about, and how the audience would benefit.<br />\nPhasellus sed viverra diam, id pharetra nibh. Aliquam lorem nisl, vehicula sed erat ac, interdum gravida metus. Nunc sodales justo quis quam faucibus, vitae luctus nisl accumsan.<br />\nNulla non gravida orci, quis placerat magna. Praesent ut consequat dolor. Praesent id turpis dictum dui consequat sagittis pharetra ac nulla. Suspendisse molestie pulvinar lectus nec tempor. In varius magna eget hendrerit mollis. Vivamus in dolor aliquet, maximus ipsum ac, faucibus quam. Donec at ante non nunc imperdiet iaculis. Aliquam condimentum augue at ornare auctor. </div>\n			</div><div class="et_pb_module et_pb_blurb et_pb_blurb_6  et_pb_text_align_left  et_pb_blurb_position_left et_pb_bg_layout_light">\n				\n				\n				\n				\n				<div class="et_pb_blurb_content">\n					<div class="et_pb_main_blurb_image"><span class="et_pb_image_wrap"><span class="et-waypoint et_pb_animation_top et_pb_animation_top_tablet et_pb_animation_top_phone et-pb-icon"></span></span></div>\n					<div class="et_pb_blurb_container">\n						<h4 class="et_pb_module_header"><span>JDoe@authorwebsiteinabox.com</span></h4>\n						\n					</div>\n				</div>\n			</div><div class="et_pb_module et_pb_blurb et_pb_blurb_7  et_pb_text_align_left  et_pb_blurb_position_left et_pb_bg_layout_light">\n				\n				\n				\n				\n				<div class="et_pb_blurb_content">\n					<div class="et_pb_main_blurb_image"><span class="et_pb_image_wrap"><span class="et-waypoint et_pb_animation_top et_pb_animation_top_tablet et_pb_animation_top_phone et-pb-icon"></span></span></div>\n					<div class="et_pb_blurb_container">\n						<h4 class="et_pb_module_header"><span>8675309</span></h4>\n						\n					</div>\n				</div>\n			</div>\n			</div><div class="et_pb_column et_pb_column_1_2 et_pb_column_21  et_pb_css_mix_blend_mode_passthrough et-last-child">\n				\n				\n				\n				\n				<div class="et_pb_module et_pb_text et_pb_text_16  et_pb_text_align_left et_pb_bg_layout_light">\n				\n				\n				\n				\n				<div class="et_pb_text_inner">Got a Question?</div>\n			</div><div class="et_pb_module et_pb_divider et_pb_divider_3 et_pb_space"><div class="et_pb_divider_internal"></div></div><div class="et_pb_module et_pb_accordion et_pb_accordion_0 about-me-faq-accordion">\n				\n				\n				\n				\n				<div class="et_pb_toggle et_pb_module et_pb_accordion_item et_pb_accordion_item_0  et_pb_toggle_open">\n				\n				\n				\n				\n				<h5 class="et_pb_toggle_title">Replace this text with a question.</h5>\n				<div class="et_pb_toggle_content clearfix">Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Tincidunt nunc pulvinar sapien et ligula ullamcorper malesuada proin.<br />\nFill out each section with commonly asked questions.<br />\n&nbsp;</div>\n			</div><div class="et_pb_toggle et_pb_module et_pb_accordion_item et_pb_accordion_item_1  et_pb_toggle_close">\n				\n				\n				\n				\n				<h5 class="et_pb_toggle_title">Donec at ante non nunc imperdiet iaculis.</h5>\n				<div class="et_pb_toggle_content clearfix">Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Tincidunt nunc pulvinar sapien et ligula ullamcorper malesuada proin.</div>\n			</div><div class="et_pb_toggle et_pb_module et_pb_accordion_item et_pb_accordion_item_2  et_pb_toggle_close">\n				\n				\n				\n				\n				<h5 class="et_pb_toggle_title">Suspendisse aliquet urna non tellus aliquam</h5>\n				<div class="et_pb_toggle_content clearfix">Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Tincidunt nunc pulvinar sapien et ligula ullamcorper malesuada proin.</div>\n			</div><div class="et_pb_toggle et_pb_module et_pb_accordion_item et_pb_accordion_item_3  et_pb_toggle_close">\n				\n				\n				\n				\n				<h5 class="et_pb_toggle_title">Lorem ipsum began as scrambled</h5>\n				<div class="et_pb_toggle_content clearfix">Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Tincidunt nunc pulvinar sapien et ligula ullamcorper malesuada proin.</div>\n			</div>\n			</div>\n			</div>\n				\n				\n				\n				\n			</div>\n				\n				\n			</div><div class="et_pb_section et_pb_section_12 et_pb_with_background et_section_regular" >\n				\n				\n				\n				\n				\n				\n				<div class="et_pb_row et_pb_row_15">\n				<div class="et_pb_column et_pb_column_4_4 et_pb_column_22  et_pb_css_mix_blend_mode_passthrough et-last-child">\n				\n				\n				\n				\n				<div class="et_pb_module et_pb_signup_1 et_pb_newsletter_layout_left_right et_pb_newsletter et_pb_subscribe clearfix  et_pb_text_align_left et_pb_bg_layout_dark et_pb_no_bg">\n				\n				\n				\n				\n				<div class="et_pb_newsletter_description"><h2 class="et_pb_module_header">Join My Newsletter</h2><div>Curabitur ultricies blandit nisi ut convallis. Integer in augue feugiat laoreet risus. Etiam tempus lorem luctus hendrerit.</div></div>\n				\n				<div class="et_pb_newsletter_form">\n					<form method="post">\n						<div class="et_pb_newsletter_result et_pb_newsletter_error"></div>\n						<div class="et_pb_newsletter_result et_pb_newsletter_success">\n							<h2>Success!</h2>\n						</div>\n						<div class="et_pb_newsletter_fields">\n							\n							\n							\n					<p class="et_pb_newsletter_field et_pb_contact_field_last et_pb_contact_field_last_tablet et_pb_contact_field_last_phone">\n						<label class="et_pb_contact_form_label" for="et_pb_signup_email" style="display: none;">Email</label>\n						<input id="et_pb_signup_email" class="input" type="text" placeholder="Email" name="et_pb_signup_email">\n					</p>\n							\n							\n					<p class="et_pb_newsletter_button_wrap">\n						<a class="et_pb_newsletter_button et_pb_button" href="#" data-icon="">\n							<span class="et_subscribe_loader"></span>\n							<span class="et_pb_newsletter_button_text">Subscribe</span>\n						</a>\n					</p>\n							\n						</div>\n						\n						<input type="hidden" value="mailchimp" name="et_pb_signup_provider" />\n						<input type="hidden" value="03dac884f0" name="et_pb_signup_list_id" />\n						<input type="hidden" value="SlavaET" name="et_pb_signup_account_name" />\n						<input type="hidden" value="true" name="et_pb_signup_ip_address" /><input type="hidden" value="59d98e9b2454e930eba0b6fb8f9715f6" name="et_pb_signup_checksum" />\n					</form>\n				</div>\n			</div>\n			</div>\n				\n				\n				\n				\n			</div>\n				\n				\n			</div></p>\n');
INSERT INTO `wp5_postmeta` VALUES (932,204274,'_et_pb_truncate_post_date','2023-10-17 19:14:35');
INSERT INTO `wp5_postmeta` VALUES (933,204274,'_et_pb_old_content','');
INSERT INTO `wp5_postmeta` VALUES (31,21,'_wp_attached_file','2020/10/rsz_1depositphotos_79019970_xl-2015-scaled-1.jpg');
INSERT INTO `wp5_postmeta` VALUES (32,21,'_wp_attachment_metadata','a:7:{s:5:"width";i:2560;s:6:"height";i:1719;s:4:"file";s:56:"2020/10/rsz_1depositphotos_79019970_xl-2015-scaled-1.jpg";s:5:"sizes";a:15:{s:6:"medium";a:4:{s:4:"file";s:56:"rsz_1depositphotos_79019970_xl-2015-scaled-1-300x201.jpg";s:5:"width";i:300;s:6:"height";i:201;s:9:"mime-type";s:10:"image/jpeg";}s:5:"large";a:4:{s:4:"file";s:57:"rsz_1depositphotos_79019970_xl-2015-scaled-1-1024x688.jpg";s:5:"width";i:1024;s:6:"height";i:688;s:9:"mime-type";s:10:"image/jpeg";}s:9:"thumbnail";a:4:{s:4:"file";s:56:"rsz_1depositphotos_79019970_xl-2015-scaled-1-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:12:"medium_large";a:4:{s:4:"file";s:56:"rsz_1depositphotos_79019970_xl-2015-scaled-1-768x516.jpg";s:5:"width";i:768;s:6:"height";i:516;s:9:"mime-type";s:10:"image/jpeg";}s:9:"1536x1536";a:4:{s:4:"file";s:58:"rsz_1depositphotos_79019970_xl-2015-scaled-1-1536x1031.jpg";s:5:"width";i:1536;s:6:"height";i:1031;s:9:"mime-type";s:10:"image/jpeg";}s:9:"2048x2048";a:4:{s:4:"file";s:58:"rsz_1depositphotos_79019970_xl-2015-scaled-1-2048x1375.jpg";s:5:"width";i:2048;s:6:"height";i:1375;s:9:"mime-type";s:10:"image/jpeg";}s:21:"et-pb-post-main-image";a:4:{s:4:"file";s:56:"rsz_1depositphotos_79019970_xl-2015-scaled-1-400x250.jpg";s:5:"width";i:400;s:6:"height";i:250;s:9:"mime-type";s:10:"image/jpeg";}s:31:"et-pb-post-main-image-fullwidth";a:4:{s:4:"file";s:57:"rsz_1depositphotos_79019970_xl-2015-scaled-1-1080x675.jpg";s:5:"width";i:1080;s:6:"height";i:675;s:9:"mime-type";s:10:"image/jpeg";}s:21:"et-pb-portfolio-image";a:4:{s:4:"file";s:56:"rsz_1depositphotos_79019970_xl-2015-scaled-1-400x284.jpg";s:5:"width";i:400;s:6:"height";i:284;s:9:"mime-type";s:10:"image/jpeg";}s:28:"et-pb-portfolio-module-image";a:4:{s:4:"file";s:56:"rsz_1depositphotos_79019970_xl-2015-scaled-1-510x382.jpg";s:5:"width";i:510;s:6:"height";i:382;s:9:"mime-type";s:10:"image/jpeg";}s:28:"et-pb-portfolio-image-single";a:4:{s:4:"file";s:57:"rsz_1depositphotos_79019970_xl-2015-scaled-1-1080x725.jpg";s:5:"width";i:1080;s:6:"height";i:725;s:9:"mime-type";s:10:"image/jpeg";}s:35:"et-pb-gallery-module-image-portrait";a:4:{s:4:"file";s:56:"rsz_1depositphotos_79019970_xl-2015-scaled-1-400x516.jpg";s:5:"width";i:400;s:6:"height";i:516;s:9:"mime-type";s:10:"image/jpeg";}s:32:"et-pb-image--responsive--desktop";a:4:{s:4:"file";s:57:"rsz_1depositphotos_79019970_xl-2015-scaled-1-1280x860.jpg";s:5:"width";i:1280;s:6:"height";i:860;s:9:"mime-type";s:10:"image/jpeg";}s:31:"et-pb-image--responsive--tablet";a:4:{s:4:"file";s:56:"rsz_1depositphotos_79019970_xl-2015-scaled-1-980x658.jpg";s:5:"width";i:980;s:6:"height";i:658;s:9:"mime-type";s:10:"image/jpeg";}s:30:"et-pb-image--responsive--phone";a:4:{s:4:"file";s:56:"rsz_1depositphotos_79019970_xl-2015-scaled-1-480x322.jpg";s:5:"width";i:480;s:6:"height";i:322;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}s:10:"ShortPixel";a:8:{s:4:"type";s:6:"glossy";s:8:"exifKept";s:1:"0";s:4:"date";s:19:"2020-10-20 19:15:03";s:9:"thumbsOpt";i:15;s:13:"thumbsOptList";a:15:{i:0;s:56:"rsz_1depositphotos_79019970_xl-2015-scaled-1-300x201.jpg";i:1;s:57:"rsz_1depositphotos_79019970_xl-2015-scaled-1-1024x688.jpg";i:2;s:56:"rsz_1depositphotos_79019970_xl-2015-scaled-1-150x150.jpg";i:3;s:56:"rsz_1depositphotos_79019970_xl-2015-scaled-1-768x516.jpg";i:4;s:58:"rsz_1depositphotos_79019970_xl-2015-scaled-1-1536x1031.jpg";i:5;s:58:"rsz_1depositphotos_79019970_xl-2015-scaled-1-2048x1375.jpg";i:6;s:56:"rsz_1depositphotos_79019970_xl-2015-scaled-1-400x250.jpg";i:7;s:57:"rsz_1depositphotos_79019970_xl-2015-scaled-1-1080x675.jpg";i:8;s:56:"rsz_1depositphotos_79019970_xl-2015-scaled-1-400x284.jpg";i:9;s:56:"rsz_1depositphotos_79019970_xl-2015-scaled-1-510x382.jpg";i:10;s:57:"rsz_1depositphotos_79019970_xl-2015-scaled-1-1080x725.jpg";i:11;s:56:"rsz_1depositphotos_79019970_xl-2015-scaled-1-400x516.jpg";i:12;s:57:"rsz_1depositphotos_79019970_xl-2015-scaled-1-1280x860.jpg";i:13;s:56:"rsz_1depositphotos_79019970_xl-2015-scaled-1-980x658.jpg";i:14;s:56:"rsz_1depositphotos_79019970_xl-2015-scaled-1-480x322.jpg";}s:12:"excludeSizes";a:0:{}s:10:"retinasOpt";i:0;s:8:"NoBackup";b:1;}s:21:"ShortPixelImprovement";s:4:"4.49";}');
INSERT INTO `wp5_postmeta` VALUES (736,204183,'_shortpixel_status','2.6600');
INSERT INTO `wp5_postmeta` VALUES (737,204184,'_shortpixel_status','2.6300');
INSERT INTO `wp5_postmeta` VALUES (739,204183,'_edit_lock','1603227963:1');
INSERT INTO `wp5_postmeta` VALUES (825,204166,'_edit_lock','1615847356:1');
INSERT INTO `wp5_postmeta` VALUES (742,204189,'_edit_last','1');
INSERT INTO `wp5_postmeta` VALUES (743,204189,'_wp_page_template','default');
INSERT INTO `wp5_postmeta` VALUES (744,204189,'_et_pb_post_hide_nav','default');
INSERT INTO `wp5_postmeta` VALUES (745,204189,'_et_pb_page_layout','et_right_sidebar');
INSERT INTO `wp5_postmeta` VALUES (746,204189,'_et_pb_side_nav','off');
INSERT INTO `wp5_postmeta` VALUES (1245,204351,'_et_pb_built_for_post_type','page');
INSERT INTO `wp5_postmeta` VALUES (1246,204351,'_et_pb_ab_subjects','');
INSERT INTO `wp5_postmeta` VALUES (1247,204351,'_et_pb_enable_shortcode_tracking','');
INSERT INTO `wp5_postmeta` VALUES (1248,204351,'_et_pb_ab_current_shortcode','[et_pb_split_track id="204351" /]');
INSERT INTO `wp5_postmeta` VALUES (1249,204351,'_et_pb_custom_css','');
INSERT INTO `wp5_postmeta` VALUES (1250,204351,'_et_pb_gutter_width','3');
INSERT INTO `wp5_postmeta` VALUES (1257,204365,'_et_pb_built_for_post_type','page');
INSERT INTO `wp5_postmeta` VALUES (1252,204351,'_et_builder_version','VB|Divi|4.6.6');
INSERT INTO `wp5_postmeta` VALUES (1253,204351,'_et_pb_show_page_creation','off');
INSERT INTO `wp5_postmeta` VALUES (747,204189,'_et_pb_use_builder','on');
INSERT INTO `wp5_postmeta` VALUES (748,204189,'_et_pb_first_image','');
INSERT INTO `wp5_postmeta` VALUES (749,204189,'_et_pb_truncate_post','<p><div class="et_pb_section et_pb_section_0 et_pb_with_background et_section_regular" >\n				\n				\n				\n				\n					<div class="et_pb_row et_pb_row_0">\n				<div class="et_pb_column et_pb_column_1_2 et_pb_column_0  et_pb_css_mix_blend_mode_passthrough et_pb_column_empty">\n				\n				\n				\n			</div> <!-- .et_pb_column --><div class="et_pb_column et_pb_column_1_2 et_pb_column_1  et_pb_css_mix_blend_mode_passthrough et-last-child">\n				\n				\n				<div id="hero-contact-form" class="et_pb_module et_pb_signup_0 et_animated et_pb_newsletter_layout_left_right et_pb_newsletter et_pb_subscribe clearfix  et_pb_text_align_left et_pb_bg_layout_dark">\n				\n				\n				<div class="et_pb_newsletter_description"><h2 class="et_pb_module_header">Join My Newsletter</h2><div>Let me take you on a journey to a future city.</div></div>\n				\n				<div class="et_pb_newsletter_form">\n					<form method="post">\n						<div class="et_pb_newsletter_result et_pb_newsletter_error"></div>\n						<div class="et_pb_newsletter_result et_pb_newsletter_success">\n							<h2>Success!</h2>\n						</div>\n						<div class="et_pb_newsletter_fields">\n							\n							\n							\n					<p class="et_pb_newsletter_field et_pb_contact_field_last et_pb_contact_field_last_tablet et_pb_contact_field_last_phone">\n						<label class="et_pb_contact_form_label" for="et_pb_signup_email" style="display: none;">Email</label>\n						<input id="et_pb_signup_email" class="input" type="text" placeholder="Email" name="et_pb_signup_email">\n					</p>\n							\n							\n					<p class="et_pb_newsletter_button_wrap">\n						<a class="et_pb_newsletter_button et_pb_button" href="#" data-icon="">\n							<span class="et_subscribe_loader"></span>\n							<span class="et_pb_newsletter_button_text">Subscribe</span>\n						</a>\n					</p>\n							\n						</div>\n						\n						<input type="hidden" value="mailchimp" name="et_pb_signup_provider" />\n						<input type="hidden" value="03dac884f0" name="et_pb_signup_list_id" />\n						<input type="hidden" value="SlavaET" name="et_pb_signup_account_name" />\n						<input type="hidden" value="true" name="et_pb_signup_ip_address" /><input type="hidden" value="7c82f0a0ab4ea3f89c022cb452107efc" name="et_pb_signup_checksum" />\n					</form>\n				</div>\n			</div>\n			</div> <!-- .et_pb_column -->\n				\n				\n			</div> <!-- .et_pb_row -->\n				\n				\n			</div> <!-- .et_pb_section --><div id="my-books-bg" class="et_pb_section et_pb_section_1 et_section_regular" >\n				\n				\n				\n				\n					<div class="et_pb_row et_pb_row_1">\n				<div class="et_pb_column et_pb_column_4_4 et_pb_column_2  et_pb_css_mix_blend_mode_passthrough et-last-child">\n				\n				\n				<div class="et_pb_with_border et_pb_module et_pb_text et_pb_text_0  et_pb_text_align_center et_pb_bg_layout_light">\n				\n				\n				<div class="et_pb_text_inner">My Books</div>\n			</div> <!-- .et_pb_text --><div class="et_pb_module et_pb_divider et_pb_divider_0 et_pb_divider_position_ et_pb_space"><div class="et_pb_divider_internal"></div></div>\n			</div> <!-- .et_pb_column -->\n				\n				\n			</div> <!-- .et_pb_row --><div class="et_pb_row et_pb_row_2">\n				<div class="et_pb_column et_pb_column_1_4 et_pb_column_3  et_pb_css_mix_blend_mode_passthrough">\n				\n				\n				<div class="et_pb_module et_pb_image et_pb_image_0">\n				\n				\n				<span class="et_pb_image_wrap has-box-shadow-overlay"><div class="box-shadow-overlay"></div><img loading="lazy" src="https://gibson.authorwebsiteinabox.com/wp-content/uploads/2020/10/book-cover-generic.jpg" alt="" title="book cover generic" height="auto" width="auto" srcset="https://gibson.authorwebsiteinabox.com/wp-content/uploads/2020/10/book-cover-generic.jpg 1410w, https://gibson.authorwebsiteinabox.com/wp-content/uploads/2020/10/book-cover-generic-1280x2043.jpg 1280w, https://gibson.authorwebsiteinabox.com/wp-content/uploads/2020/10/book-cover-generic-980x1564.jpg 980w, https://gibson.authorwebsiteinabox.com/wp-content/uploads/2020/10/book-cover-generic-480x766.jpg 480w" sizes="(min-width: 0px) and (max-width: 480px) 480px, (min-width: 481px) and (max-width: 980px) 980px, (min-width: 981px) and (max-width: 1280px) 1280px, (min-width: 1281px) 1410px, 100vw" class="wp-image-28142" /></span>\n			</div><div class="et_pb_module et_pb_text et_pb_text_1 et_animated  et_pb_text_align_center et_pb_bg_layout_light">\n				\n				\n				<div class="et_pb_text_inner">Book 1<br />\nVarius natoque penatibus et magnis dis parturient montes. Varius natoque penatibus et magnis dis parturient montes.</div>\n			</div> <!-- .et_pb_text --><div class="et_pb_button_module_wrapper et_pb_button_0_wrapper et_pb_button_alignment_center et_pb_module ">\n				<a class="et_pb_button et_pb_button_0 my-books-button et_pb_bg_layout_light" href="#book-1">Buy This Book!</a>\n			</div>\n			</div> <!-- .et_pb_column --><div class="et_pb_column et_pb_column_1_4 et_pb_column_4  et_pb_css_mix_blend_mode_passthrough">\n				\n				\n				<div class="et_pb_module et_pb_image et_pb_image_1">\n				\n				\n				<span class="et_pb_image_wrap has-box-shadow-overlay"><div class="box-shadow-overlay"></div><img loading="lazy" src="https://gibson.authorwebsiteinabox.com/wp-content/uploads/2020/10/book-cover-generic.jpg" alt="" title="book cover generic" height="auto" width="auto" srcset="https://gibson.authorwebsiteinabox.com/wp-content/uploads/2020/10/book-cover-generic.jpg 1410w, https://gibson.authorwebsiteinabox.com/wp-content/uploads/2020/10/book-cover-generic-1280x2043.jpg 1280w, https://gibson.authorwebsiteinabox.com/wp-content/uploads/2020/10/book-cover-generic-980x1564.jpg 980w, https://gibson.authorwebsiteinabox.com/wp-content/uploads/2020/10/book-cover-generic-480x766.jpg 480w" sizes="(min-width: 0px) and (max-width: 480px) 480px, (min-width: 481px) and (max-width: 980px) 980px, (min-width: 981px) and (max-width: 1280px) 1280px, (min-width: 1281px) 1410px, 100vw" class="wp-image-28142" /></span>\n			</div><div class="et_pb_module et_pb_text et_pb_text_2 et_animated  et_pb_text_align_center et_pb_bg_layout_light">\n				\n				\n				<div class="et_pb_text_inner">Book 2<br />\nVarius natoque penatibus et magnis dis parturient montes. Varius natoque penatibus et magnis dis parturient montes.</div>\n			</div> <!-- .et_pb_text --><div class="et_pb_button_module_wrapper et_pb_button_1_wrapper et_pb_button_alignment_center et_pb_module ">\n				<a class="et_pb_button et_pb_button_1 my-books-button et_pb_bg_layout_light" href="#book-2">Buy This Book!</a>\n			</div>\n			</div> <!-- .et_pb_column --><div class="et_pb_column et_pb_column_1_4 et_pb_column_5  et_pb_css_mix_blend_mode_passthrough">\n				\n				\n				<div class="et_pb_module et_pb_image et_pb_image_2">\n				\n				\n				<span class="et_pb_image_wrap has-box-shadow-overlay"><div class="box-shadow-overlay"></div><img loading="lazy" src="https://gibson.authorwebsiteinabox.com/wp-content/uploads/2020/10/book-cover-generic.jpg" alt="" title="book cover generic" height="auto" width="auto" srcset="https://gibson.authorwebsiteinabox.com/wp-content/uploads/2020/10/book-cover-generic.jpg 1410w, https://gibson.authorwebsiteinabox.com/wp-content/uploads/2020/10/book-cover-generic-1280x2043.jpg 1280w, https://gibson.authorwebsiteinabox.com/wp-content/uploads/2020/10/book-cover-generic-980x1564.jpg 980w, https://gibson.authorwebsiteinabox.com/wp-content/uploads/2020/10/book-cover-generic-480x766.jpg 480w" sizes="(min-width: 0px) and (max-width: 480px) 480px, (min-width: 481px) and (max-width: 980px) 980px, (min-width: 981px) and (max-width: 1280px) 1280px, (min-width: 1281px) 1410px, 100vw" class="wp-image-28142" /></span>\n			</div><div class="et_pb_module et_pb_text et_pb_text_3 et_animated  et_pb_text_align_center et_pb_bg_layout_light">\n				\n				\n				<div class="et_pb_text_inner">Book 3<br />\nVarius natoque penatibus et magnis dis parturient montes. Varius natoque penatibus et magnis dis parturient montes.</div>\n			</div> <!-- .et_pb_text --><div class="et_pb_button_module_wrapper et_pb_button_2_wrapper et_pb_button_alignment_center et_pb_module ">\n				<a class="et_pb_button et_pb_button_2 my-books-button et_pb_bg_layout_light" href="#book-3">Buy This Book!</a>\n			</div>\n			</div> <!-- .et_pb_column --><div class="et_pb_column et_pb_column_1_4 et_pb_column_6  et_pb_css_mix_blend_mode_passthrough et-last-child">\n				\n				\n				<div class="et_pb_module et_pb_image et_pb_image_3">\n				\n				\n				<span class="et_pb_image_wrap has-box-shadow-overlay"><div class="box-shadow-overlay"></div><img loading="lazy" src="https://gibson.authorwebsiteinabox.com/wp-content/uploads/2020/10/book-cover-generic.jpg" alt="" title="book cover generic" height="auto" width="auto" srcset="https://gibson.authorwebsiteinabox.com/wp-content/uploads/2020/10/book-cover-generic.jpg 1410w, https://gibson.authorwebsiteinabox.com/wp-content/uploads/2020/10/book-cover-generic-1280x2043.jpg 1280w, https://gibson.authorwebsiteinabox.com/wp-content/uploads/2020/10/book-cover-generic-980x1564.jpg 980w, https://gibson.authorwebsiteinabox.com/wp-content/uploads/2020/10/book-cover-generic-480x766.jpg 480w" sizes="(min-width: 0px) and (max-width: 480px) 480px, (min-width: 481px) and (max-width: 980px) 980px, (min-width: 981px) and (max-width: 1280px) 1280px, (min-width: 1281px) 1410px, 100vw" class="wp-image-28142" /></span>\n			</div><div class="et_pb_module et_pb_text et_pb_text_4 et_animated  et_pb_text_align_center et_pb_bg_layout_light">\n				\n				\n				<div class="et_pb_text_inner">Book 4<br />\nVarius natoque penatibus et magnis dis parturient montes. Varius natoque penatibus et magnis dis parturient montes.</div>\n			</div> <!-- .et_pb_text --><div class="et_pb_button_module_wrapper et_pb_button_3_wrapper et_pb_button_alignment_center et_pb_module ">\n				<a class="et_pb_button et_pb_button_3 my-books-button et_pb_bg_layout_light" href="#book-4">Buy This Book!</a>\n			</div>\n			</div> <!-- .et_pb_column -->\n				\n				\n			</div> <!-- .et_pb_row -->\n				\n				\n			</div> <!-- .et_pb_section --><div class="et_pb_section et_pb_section_2 et_pb_with_background et_section_regular" >\n				\n				\n				\n				\n					<div class="et_pb_row et_pb_row_3">\n				<div class="et_pb_column et_pb_column_4_4 et_pb_column_7  et_pb_css_mix_blend_mode_passthrough et-last-child">\n				\n				\n				<div class="et_pb_with_border et_pb_module et_pb_text et_pb_text_5  et_pb_text_align_center et_pb_bg_layout_light">\n				\n				\n				<div class="et_pb_text_inner">About Me</div>\n			</div> <!-- .et_pb_text --><div class="et_pb_module et_pb_divider et_pb_divider_1 et_pb_divider_position_ et_pb_space"><div class="et_pb_divider_internal"></div></div>\n			</div> <!-- .et_pb_column -->\n				\n				\n			</div> <!-- .et_pb_row --><div class="et_pb_row et_pb_row_4">\n				<div class="et_pb_column et_pb_column_2_5 et_pb_column_8  et_pb_css_mix_blend_mode_passthrough">\n				\n				\n				<div class="et_pb_module et_pb_image et_pb_image_4">\n				\n				\n				<span class="et_pb_image_wrap "><img loading="lazy" src="https://gibson.authorwebsiteinabox.com/wp-content/uploads/2020/10/Author-Photo.jpg" alt="" title="Author Photo" height="auto" width="auto" srcset="https://gibson.authorwebsiteinabox.com/wp-content/uploads/2020/10/Author-Photo.jpg 1500w, https://gibson.authorwebsiteinabox.com/wp-content/uploads/2020/10/Author-Photo-1280x1280.jpg 1280w, https://gibson.authorwebsiteinabox.com/wp-content/uploads/2020/10/Author-Photo-980x980.jpg 980w, https://gibson.authorwebsiteinabox.com/wp-content/uploads/2020/10/Author-Photo-480x480.jpg 480w" sizes="(min-width: 0px) and (max-width: 480px) 480px, (min-width: 481px) and (max-width: 980px) 980px, (min-width: 981px) and (max-width: 1280px) 1280px, (min-width: 1281px) 1500px, 100vw" class="wp-image-204084" /></span>\n			</div>\n			</div> <!-- .et_pb_column --><div class="et_pb_column et_pb_column_3_5 et_pb_column_9  et_pb_css_mix_blend_mode_passthrough et-last-child">\n				\n				\n				<div class="et_pb_module et_pb_text et_pb_text_6  et_pb_text_align_justified et_pb_bg_layout_light">\n				\n				\n				<div class="et_pb_text_inner">Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam1, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo.<br />\nNemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam.</div>\n			</div> <!-- .et_pb_text --><div class="et_pb_module et_pb_text et_pb_text_7  et_pb_text_align_left et_pb_bg_layout_light">\n				\n				\n				<div class="et_pb_text_inner">Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo.</div>\n			</div> <!-- .et_pb_text --><div class="et_pb_module et_pb_image et_pb_image_5">\n				\n				\n				<span class="et_pb_image_wrap "><img loading="lazy" src="https://gibson.authorwebsiteinabox.com/wp-content/uploads/2021/02/Author-Signature-300x73.jpg" alt="" title="Author Signature" height="auto" width="auto" class="wp-image-204820" /></span>\n			</div><ul class="et_pb_module et_pb_social_media_follow et_pb_social_media_follow_0 clearfix  et_pb_text_align_left et_pb_bg_layout_light">\n				\n				\n				<li\n            class=\'et_pb_social_media_follow_network_0 et_pb_social_icon et_pb_social_network_link  et-social-facebook et_pb_social_media_follow_network_0\'><a\n              href=\'#\'\n              class=\'icon et_pb_with_border\'\n              title=\'Follow on Facebook\'\n               target="_blank"><span\n                class=\'et_pb_social_media_follow_network_name\'\n                aria-hidden=\'true\'\n                >Follow</span></a></li><li\n            class=\'et_pb_social_media_follow_network_1 et_pb_social_icon et_pb_social_network_link  et-social-twitter et_pb_social_media_follow_network_1\'><a\n              href=\'#\'\n              class=\'icon et_pb_with_border\'\n              title=\'Follow on Twitter\'\n               target="_blank"><span\n                class=\'et_pb_social_media_follow_network_name\'\n                aria-hidden=\'true\'\n                >Follow</span></a></li><li\n            class=\'et_pb_social_media_follow_network_2 et_pb_social_icon et_pb_social_network_link  et-social-instagram et_pb_social_media_follow_network_2\'><a\n              href=\'#\'\n              class=\'icon et_pb_with_border\'\n              title=\'Follow on Instagram\'\n               target="_blank"><span\n                class=\'et_pb_social_media_follow_network_name\'\n                aria-hidden=\'true\'\n                >Follow</span></a></li><li\n            class=\'et_pb_social_media_follow_network_3 et_pb_social_icon et_pb_social_network_link  et-social-linkedin et_pb_social_media_follow_network_3\'><a\n              href=\'#\'\n              class=\'icon et_pb_with_border\'\n              title=\'Follow on LinkedIn\'\n               target="_blank"><span\n                class=\'et_pb_social_media_follow_network_name\'\n                aria-hidden=\'true\'\n                >Follow</span></a></li>\n			</ul> <!-- .et_pb_counters -->\n			</div> <!-- .et_pb_column -->\n				\n				\n			</div> <!-- .et_pb_row -->\n				\n				\n			</div> <!-- .et_pb_section --><div id="my-blog-section" class="et_pb_section et_pb_section_3 at_section et_pb_with_background et_section_regular" >\n				\n				\n				\n				\n					<div class="et_pb_row et_pb_row_5">\n				<div class="et_pb_column et_pb_column_4_4 et_pb_column_10  et_pb_css_mix_blend_mode_passthrough et-last-child">\n				\n				\n				<div class="et_pb_with_border et_pb_module et_pb_text et_pb_text_8  et_pb_text_align_center et_pb_bg_layout_light">\n				\n				\n				<div class="et_pb_text_inner">My Blog</div>\n			</div> <!-- .et_pb_text --><div class="et_pb_module et_pb_divider et_pb_divider_2 et_pb_divider_position_ et_pb_space"><div class="et_pb_divider_internal"></div></div><div id="my-blog-description" class="et_pb_module et_pb_text et_pb_text_9  et_pb_text_align_center et_pb_bg_layout_light">\n				\n				\n				<div class="et_pb_text_inner">Nel settore della tipografia e della stampa.</div>\n			</div> <!-- .et_pb_text -->\n			</div> <!-- .et_pb_column -->\n				\n				\n			</div> <!-- .et_pb_row --><div class="et_pb_row et_pb_row_6 et_pb_equal_columns">\n				<div class="et_pb_column et_pb_column_4_4 et_pb_column_11  et_pb_css_mix_blend_mode_passthrough et-last-child">\n				\n				\n				<div class="et_pb_with_border et_pb_module et_pb_blog_0 at_blog et_animated et_pb_blog_grid_wrapper">\n					<div class="et_pb_blog_grid clearfix  et_pb_text_align_center">\n					\n					\n					<div class="et_pb_ajax_pagination_container">\n						<div class="et_pb_salvattore_content" data-columns>\n			<article id="post-28183" class="et_pb_post clearfix et_pb_has_overlay et_pb_blog_item_0_0 post-28183 post type-post status-publish format-standard has-post-thumbnail hentry category-uncategorized">\n\n				<div class="et_pb_image_container"><a href="https://gibson.authorwebsiteinabox.com/demo-post-6/" class="entry-featured-image-url"><img loading="lazy" src="https://gibson.authorwebsiteinabox.com/wp-content/uploads/2020/10/Featured-Image-400x250.jpg" alt="Demo Post #6" class="" srcset="https://gibson.authorwebsiteinabox.com/wp-content/uploads/2020/10/Featured-Image.jpg 479w, https://gibson.authorwebsiteinabox.com/wp-content/uploads/2020/10/Featured-Image-400x250.jpg 480w " sizes="(max-width:479px) 479px, 100vw "  width="400" height="250" /><span class="et_overlay et_pb_inline_icon" data-icon="&#x69;"></span></a></div> <!-- .et_pb_image_container -->\n														<h2 class="entry-title"><a href="https://gibson.authorwebsiteinabox.com/demo-post-6/">Demo Post #6</a></h2>\n				\n					<p class="post-meta"><span class="published">Oct 19, 2020</span> | <a href="https://gibson.authorwebsiteinabox.com/category/uncategorized/" rel="tag">Uncategorized</a></p><div class="post-content"><div class="post-content-inner"><p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent mattis quis odio sit amet iaculis. Pellentesque ut posuere quam, scelerisque fringilla ante. Cras facilisis scelerisque tortor, et porttitor nisi gravida at. Praesent vitae aliquam eros, sed aliquam...</p>\n</div><a href="https://gibson.authorwebsiteinabox.com/demo-post-6/" class="more-link">read more</a></div>			\n			</article> <!-- .et_pb_post -->\n				\n			<article id="post-28184" class="et_pb_post clearfix et_pb_has_overlay et_pb_blog_item_0_1 post-28184 post type-post status-publish format-standard has-post-thumbnail hentry category-uncategorized">\n\n				<div class="et_pb_image_container"><a href="https://gibson.authorwebsiteinabox.com/demo-post-5/" class="entry-featured-image-url"><img loading="lazy" src="https://gibson.authorwebsiteinabox.com/wp-content/uploads/2020/10/Featured-Image-400x250.jpg" alt="Demo Post #5" class="" srcset="https://gibson.authorwebsiteinabox.com/wp-content/uploads/2020/10/Featured-Image.jpg 479w, https://gibson.authorwebsiteinabox.com/wp-content/uploads/2020/10/Featured-Image-400x250.jpg 480w " sizes="(max-width:479px) 479px, 100vw "  width="400" height="250" /><span class="et_overlay et_pb_inline_icon" data-icon="&#x69;"></span></a></div> <!-- .et_pb_image_container -->\n														<h2 class="entry-title"><a href="https://gibson.authorwebsiteinabox.com/demo-post-5/">Demo Post #5</a></h2>\n				\n					<p class="post-meta"><span class="published">Oct 19, 2020</span> | <a href="https://gibson.authorwebsiteinabox.com/category/uncategorized/" rel="tag">Uncategorized</a></p><div class="post-content"><div class="post-content-inner"><p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent mattis quis odio sit amet iaculis. Pellentesque ut posuere quam, scelerisque fringilla ante. Cras facilisis scelerisque tortor, et porttitor nisi gravida at. Praesent vitae aliquam eros, sed aliquam...</p>\n</div><a href="https://gibson.authorwebsiteinabox.com/demo-post-5/" class="more-link">read more</a></div>			\n			</article> <!-- .et_pb_post -->\n				\n			<article id="post-28178" class="et_pb_post clearfix et_pb_has_overlay et_pb_blog_item_0_2 post-28178 post type-post status-publish format-standard has-post-thumbnail hentry category-uncategorized">\n\n				<div class="et_pb_image_container"><a href="https://gibson.authorwebsiteinabox.com/demo-post-4/" class="entry-featured-image-url"><img loading="lazy" src="https://gibson.authorwebsiteinabox.com/wp-content/uploads/2020/10/Featured-Image-400x250.jpg" alt="Demo Post #4" class="" srcset="https://gibson.authorwebsiteinabox.com/wp-content/uploads/2020/10/Featured-Image.jpg 479w, https://gibson.authorwebsiteinabox.com/wp-content/uploads/2020/10/Featured-Image-400x250.jpg 480w " sizes="(max-width:479px) 479px, 100vw "  width="400" height="250" /><span class="et_overlay et_pb_inline_icon" data-icon="&#x69;"></span></a></div> <!-- .et_pb_image_container -->\n														<h2 class="entry-title"><a href="https://gibson.authorwebsiteinabox.com/demo-post-4/">Demo Post #4</a></h2>\n				\n					<p class="post-meta"><span class="published">Oct 19, 2020</span> | <a href="https://gibson.authorwebsiteinabox.com/category/uncategorized/" rel="tag">Uncategorized</a></p><div class="post-content"><div class="post-content-inner"><p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent mattis quis odio sit amet iaculis. Pellentesque ut posuere quam, scelerisque fringilla ante. Cras facilisis scelerisque tortor, et porttitor nisi gravida at. Praesent vitae aliquam eros, sed aliquam...</p>\n</div><a href="https://gibson.authorwebsiteinabox.com/demo-post-4/" class="more-link">read more</a></div>			\n			</article> <!-- .et_pb_post -->\n				</div><!-- .et_pb_salvattore_content -->\n					</div>\n					</div> <!-- .et_pb_posts --> \n				</div>\n			</div> <!-- .et_pb_column -->\n				\n				\n			</div> <!-- .et_pb_row --><div class="et_pb_row et_pb_row_7">\n				<div class="et_pb_column et_pb_column_4_4 et_pb_column_12  et_pb_css_mix_blend_mode_passthrough et-last-child">\n				\n				\n				<div class="et_pb_button_module_wrapper et_pb_button_4_wrapper et_pb_button_alignment_center et_pb_module ">\n				<a id="see-more-button" class="et_pb_button et_pb_custom_button_icon et_pb_button_4 et_pb_bg_layout_dark" href="" data-icon="&#x24;">See More</a>\n			</div>\n			</div> <!-- .et_pb_column -->\n				\n				\n			</div> <!-- .et_pb_row -->\n				\n				\n			</div> <!-- .et_pb_section --><div id="buy-books-section" class="et_pb_section et_pb_section_4 at_section et_pb_with_background et_section_regular" >\n				\n				\n				\n				\n					<div class="et_pb_row et_pb_row_8">\n				<div class="et_pb_column et_pb_column_4_4 et_pb_column_13  et_pb_css_mix_blend_mode_passthrough et-last-child">\n				\n				\n				<div class="et_pb_with_border et_pb_module et_pb_text et_pb_text_10  et_pb_text_align_center et_pb_bg_layout_light">\n				\n				\n				<div class="et_pb_text_inner">Where to Buy My Books</div>\n			</div> <!-- .et_pb_text --><div class="et_pb_module et_pb_divider et_pb_divider_3 et_pb_divider_position_ et_pb_space"><div class="et_pb_divider_internal"></div></div><div class="et_pb_module et_pb_text et_pb_text_11  et_pb_text_align_center et_pb_bg_layout_light">\n				\n				\n				<div class="et_pb_text_inner">Link these logos to your author pages in the various ebookstores.</div>\n			</div> <!-- .et_pb_text -->\n			</div> <!-- .et_pb_column -->\n				\n				\n			</div> <!-- .et_pb_row --><div class="et_pb_row et_pb_row_9 et_animated">\n				<div class="et_pb_column et_pb_column_1_4 et_pb_column_14  et_pb_css_mix_blend_mode_passthrough">\n				\n				\n				<div class="et_pb_module et_pb_image et_pb_image_6 et_hover_enabled">\n				\n				\n				<span class="et_pb_image_wrap "><img loading="lazy" src="https://gibson.authorwebsiteinabox.com/wp-content/uploads/2020/10/logo-001-1-300x75.png" alt="" title="logo-001-1" height="auto" width="auto" class="wp-image-28238" /></span>\n			</div>\n			</div> <!-- .et_pb_column --><div class="et_pb_column et_pb_column_1_4 et_pb_column_15  et_pb_css_mix_blend_mode_passthrough">\n				\n				\n				<div class="et_pb_module et_pb_image et_pb_image_7 et_hover_enabled">\n				\n				\n				<span class="et_pb_image_wrap "><img loading="lazy" src="https://gibson.authorwebsiteinabox.com/wp-content/uploads/2020/10/logo-002-1.png" alt="" title="logo-002-1" height="auto" width="auto" srcset="https://gibson.authorwebsiteinabox.com/wp-content/uploads/2020/10/logo-002-1.png 500w, https://gibson.authorwebsiteinabox.com/wp-content/uploads/2020/10/logo-002-1-480x120.png 480w" sizes="(min-width: 0px) and (max-width: 480px) 480px, (min-width: 481px) 500px, 100vw" class="wp-image-28239" /></span>\n			</div>\n			</div> <!-- .et_pb_column --><div class="et_pb_column et_pb_column_1_4 et_pb_column_16  et_pb_css_mix_blend_mode_passthrough">\n				\n				\n				<div class="et_pb_module et_pb_image et_pb_image_8 et_hover_enabled">\n				\n				\n				<span class="et_pb_image_wrap "><img loading="lazy" src="https://gibson.authorwebsiteinabox.com/wp-content/uploads/2020/10/kobo-logo.png" alt="" title="kobo logo" height="auto" width="auto" srcset="https://gibson.authorwebsiteinabox.com/wp-content/uploads/2020/10/kobo-logo.png 320w, https://gibson.authorwebsiteinabox.com/wp-content/uploads/2020/10/kobo-logo-300x81.png 300w" sizes="(max-width: 320px) 100vw, 320px" class="wp-image-204086" /></span>\n			</div>\n			</div> <!-- .et_pb_column --><div class="et_pb_column et_pb_column_1_4 et_pb_column_17  et_pb_css_mix_blend_mode_passthrough et-last-child">\n				\n				\n				<div class="et_pb_module et_pb_image et_pb_image_9 et_hover_enabled">\n				\n				\n				<span class="et_pb_image_wrap "><img loading="lazy" src="https://gibson.authorwebsiteinabox.com/wp-content/uploads/2021/02/apple-books-store-button-300x85.png" alt="" title="apple-books-store-button" height="auto" width="auto" class="wp-image-204805" /></span>\n			</div>\n			</div> <!-- .et_pb_column -->\n				\n				\n			</div> <!-- .et_pb_row -->\n				\n				\n			</div> <!-- .et_pb_section --><div id="get-in-touch-section" class="et_pb_section et_pb_section_5 et_pb_with_background et_section_regular" >\n				\n				\n				\n				\n					<div class="et_pb_row et_pb_row_10 et_pb_row_fullwidth">\n				<div class="et_pb_column et_pb_column_1_2 et_pb_column_18  et_pb_css_mix_blend_mode_passthrough">\n				\n				\n				<div class="et_pb_module et_pb_text et_pb_text_12  et_pb_text_align_left et_pb_bg_layout_light">\n				\n				\n				<div class="et_pb_text_inner">Get in Touch</div>\n			</div> <!-- .et_pb_text -->\n			<div id="et_pb_contact_form_0" class="et_pb_with_border et_pb_module et_pb_contact_form_0 et_pb_contact_form_container clearfix" data-form_unique_num="0">\n				\n				\n				\n				<div class="et-pb-contact-message"></div>\n				\n				<div class="et_pb_contact">\n					<form class="et_pb_contact_form clearfix" method="post" action="https://gibson.authorwebsiteinabox.com/?s=2021">\n						<p class="et_pb_contact_field et_pb_contact_field_0 et_pb_contact_field_half" data-id="name" data-type="input">\n				\n				\n				<label for="et_pb_contact_name_0" class="et_pb_contact_form_label">Name</label>\n				<input type="text" id="et_pb_contact_name_0" class="input" value="" name="et_pb_contact_name_0" data-required_mark="required" data-field_type="input" data-original_id="name" placeholder="Name">\n			</p><p class="et_pb_with_border et_pb_contact_field et_pb_contact_field_1 et_pb_contact_field_half et_pb_contact_field_last" data-id="email" data-type="email">\n				\n				\n				<label for="et_pb_contact_email_0" class="et_pb_contact_form_label">Email Address</label>\n				<input type="text" id="et_pb_contact_email_0" class="input" value="" name="et_pb_contact_email_0" data-required_mark="required" data-field_type="email" data-original_id="email" placeholder="Email Address">\n			</p><p class="et_pb_with_border et_pb_contact_field et_pb_contact_field_2 et_pb_contact_field_last" data-id="message" data-type="text">\n				\n				\n				<label for="et_pb_contact_message_0" class="et_pb_contact_form_label">Message</label>\n				<textarea name="et_pb_contact_message_0" id="et_pb_contact_message_0" class="et_pb_contact_message input" data-required_mark="required" data-field_type="text" data-original_id="message" placeholder="Message"></textarea>\n			</p>\n						<input type="hidden" value="et_contact_proccess" name="et_pb_contactform_submit_0"/>\n						<div class="et_contact_bottom_container">\n							\n							<button type="submit" name="et_builder_submit_button" class="et_pb_contact_submit et_pb_button">Submit</button>\n						</div>\n						<input type="hidden" id="_wpnonce-et-pb-contact-form-submitted-0" name="_wpnonce-et-pb-contact-form-submitted-0" value="1903d546da" /><input type="hidden" name="_wp_http_referer" value="/?s=2021" />\n					</form>\n				</div> <!-- .et_pb_contact -->\n			</div> <!-- .et_pb_contact_form_container -->\n			\n			</div> <!-- .et_pb_column --><div class="et_pb_column et_pb_column_1_2 et_pb_column_19  et_pb_css_mix_blend_mode_passthrough et-last-child et_pb_column_empty">\n				\n				\n				\n			</div> <!-- .et_pb_column -->\n				\n				\n			</div> <!-- .et_pb_row -->\n				\n				\n			</div> <!-- .et_pb_section --><div id="book-1" class="et_pb_section et_pb_section_6 popup et_section_regular" >\n				\n				\n				\n				\n					<div class="et_pb_row et_pb_row_11">\n				<div class="et_pb_column et_pb_column_4_4 et_pb_column_20  et_pb_css_mix_blend_mode_passthrough et-last-child">\n				\n				\n				<div class="et_pb_module et_pb_text et_pb_text_13  et_pb_text_align_left et_pb_bg_layout_light">\n				\n				\n				<div class="et_pb_text_inner">Book 1</div>\n			</div> <!-- .et_pb_text -->\n			</div> <!-- .et_pb_column -->\n				\n				\n			</div> <!-- .et_pb_row --><div class="et_pb_row et_pb_row_12 at_books et_pb_gutters2">\n				<div class="et_pb_column et_pb_column_1_3 et_pb_column_21  et_pb_css_mix_blend_mode_passthrough">\n				\n				\n				<div class="et_pb_module et_pb_image et_pb_image_10">\n				\n				\n				<span class="et_pb_image_wrap "><img loading="lazy" src="https://gibson.authorwebsiteinabox.com/wp-content/uploads/2020/10/book-cover-generic-188x300.jpg" alt="" title="book cover generic" height="auto" width="auto" class="wp-image-28142" /></span>\n			</div>\n			</div> <!-- .et_pb_column --><div class="et_pb_column et_pb_column_2_3 et_pb_column_22  et_pb_css_mix_blend_mode_passthrough et-last-child">\n				\n				\n				<div class="et_pb_button_module_wrapper et_pb_button_5_wrapper et_pb_button_alignment_left et_pb_button_alignment_tablet_center et_pb_module ">\n				<a class="et_pb_button et_pb_button_5 et_pb_bg_layout_light" href="">Buy bookstore 1</a>\n			</div><div class="et_pb_button_module_wrapper et_pb_button_6_wrapper et_pb_button_alignment_left et_pb_button_alignment_tablet_center et_pb_button_alignment_phone_center et_pb_module ">\n				<a class="et_pb_button et_pb_button_6 et_pb_bg_layout_light" href="">Buy bookstore 2</a>\n			</div><div class="et_pb_button_module_wrapper et_pb_button_7_wrapper et_pb_button_alignment_left et_pb_button_alignment_tablet_center et_pb_button_alignment_phone_center et_pb_module ">\n				<a class="et_pb_button et_pb_button_7 et_pb_bg_layout_light" href="">Buy bookstore 3</a>\n			</div><div class="et_pb_button_module_wrapper et_pb_button_8_wrapper et_pb_button_alignment_left et_pb_button_alignment_tablet_center et_pb_button_alignment_phone_center et_pb_module ">\n				<a class="et_pb_button et_pb_button_8 et_pb_bg_layout_light" href="">Buy elsewhere</a>\n			</div>\n			</div> <!-- .et_pb_column -->\n				\n				\n			</div> <!-- .et_pb_row -->\n				\n				\n			</div> <!-- .et_pb_section --><div id="book-2" class="et_pb_section et_pb_section_7 popup et_section_regular" >\n				\n				\n				\n				\n					<div class="et_pb_row et_pb_row_13">\n				<div class="et_pb_column et_pb_column_4_4 et_pb_column_23  et_pb_css_mix_blend_mode_passthrough et-last-child">\n				\n				\n				<div class="et_pb_module et_pb_text et_pb_text_14  et_pb_text_align_left et_pb_bg_layout_light">\n				\n				\n				<div class="et_pb_text_inner">Book 2</div>\n			</div> <!-- .et_pb_text -->\n			</div> <!-- .et_pb_column -->\n				\n				\n			</div> <!-- .et_pb_row --><div class="et_pb_row et_pb_row_14 at_books et_pb_gutters2">\n				<div class="et_pb_column et_pb_column_1_3 et_pb_column_24  et_pb_css_mix_blend_mode_passthrough">\n				\n				\n				<div class="et_pb_module et_pb_image et_pb_image_11">\n				\n				\n				<span class="et_pb_image_wrap "><img loading="lazy" src="https://gibson.authorwebsiteinabox.com/wp-content/uploads/2020/10/book-cover-generic-188x300.jpg" alt="" title="book cover generic" height="auto" width="auto" class="wp-image-28142" /></span>\n			</div>\n			</div> <!-- .et_pb_column --><div class="et_pb_column et_pb_column_2_3 et_pb_column_25  et_pb_css_mix_blend_mode_passthrough et-last-child">\n				\n				\n				<div class="et_pb_button_module_wrapper et_pb_button_9_wrapper et_pb_button_alignment_left et_pb_button_alignment_tablet_center et_pb_module ">\n				<a class="et_pb_button et_pb_button_9 et_pb_bg_layout_light" href="">Buy bookstore 1</a>\n			</div><div class="et_pb_button_module_wrapper et_pb_button_10_wrapper et_pb_button_alignment_left et_pb_button_alignment_tablet_center et_pb_button_alignment_phone_center et_pb_module ">\n				<a class="et_pb_button et_pb_button_10 et_pb_bg_layout_light" href="">Buy bookstore 2</a>\n			</div><div class="et_pb_button_module_wrapper et_pb_button_11_wrapper et_pb_button_alignment_left et_pb_button_alignment_tablet_center et_pb_button_alignment_phone_center et_pb_module ">\n				<a class="et_pb_button et_pb_button_11 et_pb_bg_layout_light" href="">Buy bookstore 3</a>\n			</div><div class="et_pb_button_module_wrapper et_pb_button_12_wrapper et_pb_button_alignment_left et_pb_button_alignment_tablet_center et_pb_button_alignment_phone_center et_pb_module ">\n				<a class="et_pb_button et_pb_button_12 et_pb_bg_layout_light" href="">Buy elsewhere</a>\n			</div>\n			</div> <!-- .et_pb_column -->\n				\n				\n			</div> <!-- .et_pb_row -->\n				\n				\n			</div> <!-- .et_pb_section --><div id="book-3" class="et_pb_section et_pb_section_8 popup et_section_regular" >\n				\n				\n				\n				\n					<div class="et_pb_row et_pb_row_15">\n				<div class="et_pb_column et_pb_column_4_4 et_pb_column_26  et_pb_css_mix_blend_mode_passthrough et-last-child">\n				\n				\n				<div class="et_pb_module et_pb_text et_pb_text_15  et_pb_text_align_left et_pb_bg_layout_light">\n				\n				\n				<div class="et_pb_text_inner">Book 3</div>\n			</div> <!-- .et_pb_text -->\n			</div> <!-- .et_pb_column -->\n				\n				\n			</div> <!-- .et_pb_row --><div class="et_pb_row et_pb_row_16 at_books et_pb_gutters2">\n				<div class="et_pb_column et_pb_column_1_3 et_pb_column_27  et_pb_css_mix_blend_mode_passthrough">\n				\n				\n				<div class="et_pb_module et_pb_image et_pb_image_12">\n				\n				\n				<span class="et_pb_image_wrap "><img loading="lazy" src="https://gibson.authorwebsiteinabox.com/wp-content/uploads/2020/10/book-cover-generic-188x300.jpg" alt="" title="book cover generic" height="auto" width="auto" class="wp-image-28142" /></span>\n			</div>\n			</div> <!-- .et_pb_column --><div class="et_pb_column et_pb_column_2_3 et_pb_column_28  et_pb_css_mix_blend_mode_passthrough et-last-child">\n				\n				\n				<div class="et_pb_button_module_wrapper et_pb_button_13_wrapper et_pb_button_alignment_left et_pb_button_alignment_tablet_center et_pb_module ">\n				<a class="et_pb_button et_pb_button_13 et_pb_bg_layout_light" href="">Buy bookstore 1</a>\n			</div><div class="et_pb_button_module_wrapper et_pb_button_14_wrapper et_pb_button_alignment_left et_pb_button_alignment_tablet_center et_pb_button_alignment_phone_center et_pb_module ">\n				<a class="et_pb_button et_pb_button_14 et_pb_bg_layout_light" href="">Buy bookstore 2</a>\n			</div><div class="et_pb_button_module_wrapper et_pb_button_15_wrapper et_pb_button_alignment_left et_pb_button_alignment_tablet_center et_pb_button_alignment_phone_center et_pb_module ">\n				<a class="et_pb_button et_pb_button_15 et_pb_bg_layout_light" href="">Buy bookstore 3</a>\n			</div><div class="et_pb_button_module_wrapper et_pb_button_16_wrapper et_pb_button_alignment_left et_pb_button_alignment_tablet_center et_pb_button_alignment_phone_center et_pb_module ">\n				<a class="et_pb_button et_pb_button_16 et_pb_bg_layout_light" href="">Buy elsewhere</a>\n			</div>\n			</div> <!-- .et_pb_column -->\n				\n				\n			</div> <!-- .et_pb_row -->\n				\n				\n			</div> <!-- .et_pb_section --><div id="book-4" class="et_pb_section et_pb_section_9 popup et_section_regular" >\n				\n				\n				\n				\n					<div class="et_pb_row et_pb_row_17">\n				<div class="et_pb_column et_pb_column_4_4 et_pb_column_29  et_pb_css_mix_blend_mode_passthrough et-last-child">\n				\n				\n				<div class="et_pb_module et_pb_text et_pb_text_16  et_pb_text_align_left et_pb_bg_layout_light">\n				\n				\n				<div class="et_pb_text_inner">Book 4</div>\n			</div> <!-- .et_pb_text -->\n			</div> <!-- .et_pb_column -->\n				\n				\n			</div> <!-- .et_pb_row --><div class="et_pb_row et_pb_row_18 at_books et_pb_gutters2">\n				<div class="et_pb_column et_pb_column_1_3 et_pb_column_30  et_pb_css_mix_blend_mode_passthrough">\n				\n				\n				<div class="et_pb_module et_pb_image et_pb_image_13">\n				\n				\n				<span class="et_pb_image_wrap "><img loading="lazy" src="https://gibson.authorwebsiteinabox.com/wp-content/uploads/2020/10/book-cover-generic-188x300.jpg" alt="" title="book cover generic" height="auto" width="auto" class="wp-image-28142" /></span>\n			</div>\n			</div> <!-- .et_pb_column --><div class="et_pb_column et_pb_column_2_3 et_pb_column_31  et_pb_css_mix_blend_mode_passthrough et-last-child">\n				\n				\n				<div class="et_pb_button_module_wrapper et_pb_button_17_wrapper et_pb_button_alignment_left et_pb_button_alignment_tablet_center et_pb_module ">\n				<a class="et_pb_button et_pb_button_17 et_pb_bg_layout_light" href="">Buy bookstore 1</a>\n			</div><div class="et_pb_button_module_wrapper et_pb_button_18_wrapper et_pb_button_alignment_left et_pb_button_alignment_tablet_center et_pb_button_alignment_phone_center et_pb_module ">\n				<a class="et_pb_button et_pb_button_18 et_pb_bg_layout_light" href="">Buy bookstore 2</a>\n			</div><div class="et_pb_button_module_wrapper et_pb_button_19_wrapper et_pb_button_alignment_left et_pb_button_alignment_tablet_center et_pb_button_alignment_phone_center et_pb_module ">\n				<a class="et_pb_button et_pb_button_19 et_pb_bg_layout_light" href="">Buy bookstore 3</a>\n			</div><div class="et_pb_button_module_wrapper et_pb_button_20_wrapper et_pb_button_alignment_left et_pb_button_alignment_tablet_center et_pb_button_alignment_phone_center et_pb_module ">\n				<a class="et_pb_button et_pb_button_20 et_pb_bg_layout_light" href="">Buy elsewhere</a>\n			</div>\n			</div> <!-- .et_pb_column -->\n				\n				\n			</div> <!-- .et_pb_row -->\n				\n				\n			</div> <!-- .et_pb_section --></p>\n');
INSERT INTO `wp5_postmeta` VALUES (750,204189,'_et_pb_truncate_post_date','2021-12-09 01:49:25');
INSERT INTO `wp5_postmeta` VALUES (751,204189,'_et_pb_old_content','');
INSERT INTO `wp5_postmeta` VALUES (752,204189,'_edit_lock','1635355256:3');
INSERT INTO `wp5_postmeta` VALUES (753,204189,'_et_pb_built_for_post_type','page');
INSERT INTO `wp5_postmeta` VALUES (754,204189,'_et_pb_ab_subjects','');
INSERT INTO `wp5_postmeta` VALUES (755,204189,'_et_pb_enable_shortcode_tracking','');
INSERT INTO `wp5_postmeta` VALUES (756,204189,'_et_pb_ab_current_shortcode','[et_pb_split_track id="204189" /]');
INSERT INTO `wp5_postmeta` VALUES (757,204189,'_et_pb_custom_css','');
INSERT INTO `wp5_postmeta` VALUES (758,204189,'_et_pb_gutter_width','3');
INSERT INTO `wp5_postmeta` VALUES (760,204189,'_et_builder_version','VB|Divi|4.6.6');
INSERT INTO `wp5_postmeta` VALUES (761,204189,'_et_pb_show_page_creation','off');
INSERT INTO `wp5_postmeta` VALUES (1223,204338,'_shortpixel_status','2.5900');
INSERT INTO `wp5_postmeta` VALUES (763,204194,'_et_pb_row_layout','1_4,1_4,1_4,1_4');
INSERT INTO `wp5_postmeta` VALUES (764,204194,'_et_pb_built_for_post_type','page');
INSERT INTO `wp5_postmeta` VALUES (49,28139,'_et_pb_built_for_post_type','page');
INSERT INTO `wp5_postmeta` VALUES (50,28139,'_edit_lock','1603221819:1');
INSERT INTO `wp5_postmeta` VALUES (51,28139,'_et_pb_ab_subjects','');
INSERT INTO `wp5_postmeta` VALUES (52,28139,'_et_pb_enable_shortcode_tracking','');
INSERT INTO `wp5_postmeta` VALUES (53,28139,'_et_pb_ab_current_shortcode','[et_pb_split_track id="28139" /]');
INSERT INTO `wp5_postmeta` VALUES (54,28139,'_et_pb_custom_css','');
INSERT INTO `wp5_postmeta` VALUES (55,28139,'_et_pb_gutter_width','3');
INSERT INTO `wp5_postmeta` VALUES (63,28139,'_et_pb_use_builder','on');
INSERT INTO `wp5_postmeta` VALUES (57,28139,'_et_pb_first_image','');
INSERT INTO `wp5_postmeta` VALUES (58,28139,'_et_pb_truncate_post','');
INSERT INTO `wp5_postmeta` VALUES (59,28139,'_et_pb_truncate_post_date','');
INSERT INTO `wp5_postmeta` VALUES (60,28139,'_et_builder_version','VB|Divi|4.6.6');
INSERT INTO `wp5_postmeta` VALUES (61,28139,'_et_pb_show_page_creation','off');
INSERT INTO `wp5_postmeta` VALUES (62,28139,'_edit_last','1');
INSERT INTO `wp5_postmeta` VALUES (64,28139,'_et_pb_old_content','');
INSERT INTO `wp5_postmeta` VALUES (65,28142,'_wp_attached_file','2020/10/book-cover-generic.jpg');
INSERT INTO `wp5_postmeta` VALUES (66,28142,'_wp_attachment_metadata','a:7:{s:5:"width";i:1410;s:6:"height";i:2250;s:4:"file";s:30:"2020/10/book-cover-generic.jpg";s:5:"sizes";a:16:{s:6:"medium";a:4:{s:4:"file";s:30:"book-cover-generic-188x300.jpg";s:5:"width";i:188;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";}s:5:"large";a:4:{s:4:"file";s:31:"book-cover-generic-642x1024.jpg";s:5:"width";i:642;s:6:"height";i:1024;s:9:"mime-type";s:10:"image/jpeg";}s:9:"thumbnail";a:4:{s:4:"file";s:30:"book-cover-generic-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:12:"medium_large";a:4:{s:4:"file";s:31:"book-cover-generic-768x1226.jpg";s:5:"width";i:768;s:6:"height";i:1226;s:9:"mime-type";s:10:"image/jpeg";}s:9:"1536x1536";a:4:{s:4:"file";s:31:"book-cover-generic-963x1536.jpg";s:5:"width";i:963;s:6:"height";i:1536;s:9:"mime-type";s:10:"image/jpeg";}s:9:"2048x2048";a:4:{s:4:"file";s:32:"book-cover-generic-1283x2048.jpg";s:5:"width";i:1283;s:6:"height";i:2048;s:9:"mime-type";s:10:"image/jpeg";}s:21:"et-pb-post-main-image";a:4:{s:4:"file";s:30:"book-cover-generic-400x250.jpg";s:5:"width";i:400;s:6:"height";i:250;s:9:"mime-type";s:10:"image/jpeg";}s:31:"et-pb-post-main-image-fullwidth";a:4:{s:4:"file";s:31:"book-cover-generic-1080x675.jpg";s:5:"width";i:1080;s:6:"height";i:675;s:9:"mime-type";s:10:"image/jpeg";}s:21:"et-pb-portfolio-image";a:4:{s:4:"file";s:30:"book-cover-generic-400x284.jpg";s:5:"width";i:400;s:6:"height";i:284;s:9:"mime-type";s:10:"image/jpeg";}s:28:"et-pb-portfolio-module-image";a:4:{s:4:"file";s:30:"book-cover-generic-510x382.jpg";s:5:"width";i:510;s:6:"height";i:382;s:9:"mime-type";s:10:"image/jpeg";}s:28:"et-pb-portfolio-image-single";a:4:{s:4:"file";s:32:"book-cover-generic-1080x1723.jpg";s:5:"width";i:1080;s:6:"height";i:1723;s:9:"mime-type";s:10:"image/jpeg";}s:35:"et-pb-gallery-module-image-portrait";a:4:{s:4:"file";s:30:"book-cover-generic-400x516.jpg";s:5:"width";i:400;s:6:"height";i:516;s:9:"mime-type";s:10:"image/jpeg";}s:37:"et-pb-post-main-image-fullwidth-large";a:4:{s:4:"file";s:32:"book-cover-generic-1410x1800.jpg";s:5:"width";i:1410;s:6:"height";i:1800;s:9:"mime-type";s:10:"image/jpeg";}s:32:"et-pb-image--responsive--desktop";a:4:{s:4:"file";s:32:"book-cover-generic-1280x2043.jpg";s:5:"width";i:1280;s:6:"height";i:2043;s:9:"mime-type";s:10:"image/jpeg";}s:31:"et-pb-image--responsive--tablet";a:4:{s:4:"file";s:31:"book-cover-generic-980x1564.jpg";s:5:"width";i:980;s:6:"height";i:1564;s:9:"mime-type";s:10:"image/jpeg";}s:30:"et-pb-image--responsive--phone";a:4:{s:4:"file";s:30:"book-cover-generic-480x766.jpg";s:5:"width";i:480;s:6:"height";i:766;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"1";s:8:"keywords";a:0:{}}s:10:"ShortPixel";a:8:{s:4:"type";s:6:"glossy";s:8:"exifKept";s:1:"0";s:4:"date";s:19:"2020-10-20 19:14:41";s:9:"thumbsOpt";i:16;s:13:"thumbsOptList";a:16:{i:0;s:30:"book-cover-generic-188x300.jpg";i:1;s:31:"book-cover-generic-642x1024.jpg";i:2;s:30:"book-cover-generic-150x150.jpg";i:3;s:31:"book-cover-generic-768x1226.jpg";i:4;s:31:"book-cover-generic-963x1536.jpg";i:5;s:32:"book-cover-generic-1283x2048.jpg";i:6;s:30:"book-cover-generic-400x250.jpg";i:7;s:31:"book-cover-generic-1080x675.jpg";i:8;s:30:"book-cover-generic-400x284.jpg";i:9;s:30:"book-cover-generic-510x382.jpg";i:10;s:32:"book-cover-generic-1080x1723.jpg";i:11;s:30:"book-cover-generic-400x516.jpg";i:12;s:32:"book-cover-generic-1410x1800.jpg";i:13;s:32:"book-cover-generic-1280x2043.jpg";i:14;s:31:"book-cover-generic-980x1564.jpg";i:15;s:30:"book-cover-generic-480x766.jpg";}s:12:"excludeSizes";a:0:{}s:10:"retinasOpt";i:0;s:8:"NoBackup";b:1;}s:21:"ShortPixelImprovement";s:5:"45.47";}');
INSERT INTO `wp5_postmeta` VALUES (68,28142,'_edit_lock','1603062340:1');
INSERT INTO `wp5_postmeta` VALUES (69,28146,'_et_pb_use_builder','on');
INSERT INTO `wp5_postmeta` VALUES (70,28146,'_et_pb_show_page_creation','off');
INSERT INTO `wp5_postmeta` VALUES (71,28146,'_et_pb_built_for_post_type','page');
INSERT INTO `wp5_postmeta` VALUES (72,28146,'_et_pb_enable_shortcode_tracking','');
INSERT INTO `wp5_postmeta` VALUES (73,28146,'_et_pb_custom_css','');
INSERT INTO `wp5_postmeta` VALUES (74,28146,'_et_pb_gutter_width','3');
INSERT INTO `wp5_postmeta` VALUES (75,28146,'_et_pb_first_image','');
INSERT INTO `wp5_postmeta` VALUES (76,28146,'_et_pb_truncate_post','');
INSERT INTO `wp5_postmeta` VALUES (77,28146,'_et_pb_truncate_post_date','');
INSERT INTO `wp5_postmeta` VALUES (78,28146,'_et_builder_version','VB|Divi|4.6.6');
INSERT INTO `wp5_postmeta` VALUES (79,28148,'_et_autogenerated_title','0');
INSERT INTO `wp5_postmeta` VALUES (80,28148,'_et_default','1');
INSERT INTO `wp5_postmeta` VALUES (81,28148,'_et_enabled','1');
INSERT INTO `wp5_postmeta` VALUES (82,28148,'_et_header_layout_id','0');
INSERT INTO `wp5_postmeta` VALUES (83,28148,'_et_header_layout_enabled','1');
INSERT INTO `wp5_postmeta` VALUES (84,28148,'_et_body_layout_id','0');
INSERT INTO `wp5_postmeta` VALUES (85,28148,'_et_body_layout_enabled','1');
INSERT INTO `wp5_postmeta` VALUES (86,28148,'_et_footer_layout_id','0');
INSERT INTO `wp5_postmeta` VALUES (87,28148,'_et_footer_layout_enabled','1');
INSERT INTO `wp5_postmeta` VALUES (2618,28147,'_et_template','204960');
INSERT INTO `wp5_postmeta` VALUES (89,28149,'_et_autogenerated_title','1');
INSERT INTO `wp5_postmeta` VALUES (90,28149,'_et_default','0');
INSERT INTO `wp5_postmeta` VALUES (91,28149,'_et_enabled','1');
INSERT INTO `wp5_postmeta` VALUES (92,28149,'_et_header_layout_id','0');
INSERT INTO `wp5_postmeta` VALUES (93,28149,'_et_header_layout_enabled','1');
INSERT INTO `wp5_postmeta` VALUES (94,28149,'_et_body_layout_id','0');
INSERT INTO `wp5_postmeta` VALUES (95,28149,'_et_body_layout_enabled','1');
INSERT INTO `wp5_postmeta` VALUES (96,28149,'_et_footer_layout_id','0');
INSERT INTO `wp5_postmeta` VALUES (97,28149,'_et_footer_layout_enabled','1');
INSERT INTO `wp5_postmeta` VALUES (2577,28149,'_et_use_on','singular:post_type:post:all');
INSERT INTO `wp5_postmeta` VALUES (2619,28147,'_et_template','204992');
INSERT INTO `wp5_postmeta` VALUES (100,28146,'_et_pb_ab_subjects','');
INSERT INTO `wp5_postmeta` VALUES (101,28146,'_et_pb_ab_current_shortcode','[et_pb_split_track id="28146" /]');
INSERT INTO `wp5_postmeta` VALUES (102,28146,'_thumbnail_id','0');
INSERT INTO `wp5_postmeta` VALUES (1300,204388,'_shortpixel_status','2.3000');
INSERT INTO `wp5_postmeta` VALUES (122,28159,'_wp_attached_file','2020/10/Depositphotos_137744404_xl-2015-scaled.jpg');
INSERT INTO `wp5_postmeta` VALUES (123,28159,'_wp_attachment_metadata','a:8:{s:5:"width";i:2560;s:6:"height";i:1707;s:4:"file";s:50:"2020/10/Depositphotos_137744404_xl-2015-scaled.jpg";s:5:"sizes";a:16:{s:6:"medium";a:4:{s:4:"file";s:43:"Depositphotos_137744404_xl-2015-300x200.jpg";s:5:"width";i:300;s:6:"height";i:200;s:9:"mime-type";s:10:"image/jpeg";}s:5:"large";a:4:{s:4:"file";s:44:"Depositphotos_137744404_xl-2015-1024x683.jpg";s:5:"width";i:1024;s:6:"height";i:683;s:9:"mime-type";s:10:"image/jpeg";}s:9:"thumbnail";a:4:{s:4:"file";s:43:"Depositphotos_137744404_xl-2015-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:12:"medium_large";a:4:{s:4:"file";s:43:"Depositphotos_137744404_xl-2015-768x512.jpg";s:5:"width";i:768;s:6:"height";i:512;s:9:"mime-type";s:10:"image/jpeg";}s:9:"1536x1536";a:4:{s:4:"file";s:45:"Depositphotos_137744404_xl-2015-1536x1024.jpg";s:5:"width";i:1536;s:6:"height";i:1024;s:9:"mime-type";s:10:"image/jpeg";}s:9:"2048x2048";a:4:{s:4:"file";s:45:"Depositphotos_137744404_xl-2015-2048x1365.jpg";s:5:"width";i:2048;s:6:"height";i:1365;s:9:"mime-type";s:10:"image/jpeg";}s:21:"et-pb-post-main-image";a:4:{s:4:"file";s:43:"Depositphotos_137744404_xl-2015-400x250.jpg";s:5:"width";i:400;s:6:"height";i:250;s:9:"mime-type";s:10:"image/jpeg";}s:31:"et-pb-post-main-image-fullwidth";a:4:{s:4:"file";s:44:"Depositphotos_137744404_xl-2015-1080x675.jpg";s:5:"width";i:1080;s:6:"height";i:675;s:9:"mime-type";s:10:"image/jpeg";}s:21:"et-pb-portfolio-image";a:4:{s:4:"file";s:43:"Depositphotos_137744404_xl-2015-400x284.jpg";s:5:"width";i:400;s:6:"height";i:284;s:9:"mime-type";s:10:"image/jpeg";}s:28:"et-pb-portfolio-module-image";a:4:{s:4:"file";s:43:"Depositphotos_137744404_xl-2015-510x382.jpg";s:5:"width";i:510;s:6:"height";i:382;s:9:"mime-type";s:10:"image/jpeg";}s:28:"et-pb-portfolio-image-single";a:4:{s:4:"file";s:44:"Depositphotos_137744404_xl-2015-1080x720.jpg";s:5:"width";i:1080;s:6:"height";i:720;s:9:"mime-type";s:10:"image/jpeg";}s:35:"et-pb-gallery-module-image-portrait";a:4:{s:4:"file";s:43:"Depositphotos_137744404_xl-2015-400x516.jpg";s:5:"width";i:400;s:6:"height";i:516;s:9:"mime-type";s:10:"image/jpeg";}s:37:"et-pb-post-main-image-fullwidth-large";a:4:{s:4:"file";s:45:"Depositphotos_137744404_xl-2015-2880x1800.jpg";s:5:"width";i:2880;s:6:"height";i:1800;s:9:"mime-type";s:10:"image/jpeg";}s:32:"et-pb-image--responsive--desktop";a:4:{s:4:"file";s:44:"Depositphotos_137744404_xl-2015-1280x854.jpg";s:5:"width";i:1280;s:6:"height";i:854;s:9:"mime-type";s:10:"image/jpeg";}s:31:"et-pb-image--responsive--tablet";a:4:{s:4:"file";s:43:"Depositphotos_137744404_xl-2015-980x653.jpg";s:5:"width";i:980;s:6:"height";i:653;s:9:"mime-type";s:10:"image/jpeg";}s:30:"et-pb-image--responsive--phone";a:4:{s:4:"file";s:43:"Depositphotos_137744404_xl-2015-480x320.jpg";s:5:"width";i:480;s:6:"height";i:320;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:64:"man standing in abstract architecture city,illustration painting";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:64:"man standing in abstract architecture city,illustration painting";s:11:"orientation";s:1:"1";s:8:"keywords";a:25:{i:0;s:7:"acrylic";i:1;s:3:"art";i:2;s:8:"artistic";i:3;s:7:"artwork";i:4;s:12:"illustration";i:5;s:12:"oil painting";i:6;s:8:"painting";i:7;s:10:"watercolor";i:8;s:8:"abstract";i:9;s:12:"construction";i:10;s:12:"architecture";i:11;s:4:"city";i:12;s:7:"concept";i:13;s:9:"particles";i:14;s:15:"science fiction";i:15;s:6:"sci-fi";i:16;s:8:"building";i:17;s:10:"futuristic";i:18;s:3:"man";i:19;s:9:"dreamlike";i:20;s:5:"light";i:21;s:8:"collapse";i:22;s:9:"fragments";i:23;s:6:"ruined";i:24;s:9:"breakdown";}}s:14:"original_image";s:35:"Depositphotos_137744404_xl-2015.jpg";s:10:"ShortPixel";a:8:{s:4:"type";s:6:"glossy";s:8:"exifKept";s:1:"0";s:4:"date";s:19:"2020-10-20 19:13:48";s:9:"thumbsOpt";i:17;s:13:"thumbsOptList";a:17:{i:0;s:35:"Depositphotos_137744404_xl-2015.jpg";i:1;s:43:"Depositphotos_137744404_xl-2015-300x200.jpg";i:2;s:44:"Depositphotos_137744404_xl-2015-1024x683.jpg";i:3;s:43:"Depositphotos_137744404_xl-2015-150x150.jpg";i:4;s:43:"Depositphotos_137744404_xl-2015-768x512.jpg";i:5;s:45:"Depositphotos_137744404_xl-2015-1536x1024.jpg";i:6;s:45:"Depositphotos_137744404_xl-2015-2048x1365.jpg";i:7;s:43:"Depositphotos_137744404_xl-2015-400x250.jpg";i:8;s:44:"Depositphotos_137744404_xl-2015-1080x675.jpg";i:9;s:43:"Depositphotos_137744404_xl-2015-400x284.jpg";i:10;s:43:"Depositphotos_137744404_xl-2015-510x382.jpg";i:11;s:44:"Depositphotos_137744404_xl-2015-1080x720.jpg";i:12;s:43:"Depositphotos_137744404_xl-2015-400x516.jpg";i:13;s:45:"Depositphotos_137744404_xl-2015-2880x1800.jpg";i:14;s:44:"Depositphotos_137744404_xl-2015-1280x854.jpg";i:15;s:43:"Depositphotos_137744404_xl-2015-980x653.jpg";i:16;s:43:"Depositphotos_137744404_xl-2015-480x320.jpg";}s:12:"excludeSizes";a:0:{}s:10:"retinasOpt";i:0;s:8:"NoBackup";b:1;}s:21:"ShortPixelImprovement";s:5:"58.19";}');
INSERT INTO `wp5_postmeta` VALUES (141,28166,'_edit_last','1');
INSERT INTO `wp5_postmeta` VALUES (142,28166,'_wp_page_template','default');
INSERT INTO `wp5_postmeta` VALUES (143,28166,'_et_pb_post_hide_nav','default');
INSERT INTO `wp5_postmeta` VALUES (144,28166,'_et_pb_page_layout','et_right_sidebar');
INSERT INTO `wp5_postmeta` VALUES (145,28166,'_et_pb_side_nav','off');
INSERT INTO `wp5_postmeta` VALUES (146,28166,'_et_pb_use_builder','on');
INSERT INTO `wp5_postmeta` VALUES (147,28166,'_et_pb_first_image','');
INSERT INTO `wp5_postmeta` VALUES (148,28166,'_et_pb_truncate_post','<p><div class="et_pb_section et_pb_section_15 my-blog-title et_pb_with_background et_section_regular" >\n				\n				\n				\n				\n					<div class="et_pb_with_border et_pb_row et_pb_row_21 my-blog-row et_animated">\n				<div class="et_pb_column et_pb_column_4_4 et_pb_column_39  et_pb_css_mix_blend_mode_passthrough et-last-child">\n				\n				\n				<div class="et_pb_module et_pb_text et_pb_text_30  et_pb_text_align_left et_pb_bg_layout_dark">\n				\n				\n				<div class="et_pb_text_inner">My Blog</div>\n			</div> <!-- .et_pb_text -->\n			</div> <!-- .et_pb_column -->\n				\n				\n			</div> <!-- .et_pb_row -->\n				\n				\n			</div> <!-- .et_pb_section --><div class="et_pb_section et_pb_section_16 my-blog-posts et_pb_with_background et_section_regular" >\n				\n				\n				\n				\n					<div class="et_pb_row et_pb_row_22 et_pb_gutters2">\n				<div class="et_pb_column et_pb_column_4_4 et_pb_column_40  et_pb_css_mix_blend_mode_passthrough et-last-child">\n				\n				\n				<div class="et_pb_with_border et_pb_module et_pb_blog_0 my-blog-entry et_pb_blog_grid_wrapper">\n					<div class="et_pb_blog_grid clearfix ">\n					\n					\n					<div class="et_pb_ajax_pagination_container">\n						<div class="et_pb_salvattore_content" data-columns>\n			<article id="post-28183" class="et_pb_post clearfix et_pb_blog_item_0_0 post-28183 post type-post status-publish format-standard has-post-thumbnail hentry category-uncategorized">\n\n				<div class="et_pb_image_container"><a href="https://gibson.authorwebsiteinabox.com/demo-post-6/" class="entry-featured-image-url"><img loading="lazy" src="https://gibson.authorwebsiteinabox.com/wp-content/uploads/2020/10/Featured-Image-400x250.jpg" alt="Demo Post #6" class="" srcset="https://gibson.authorwebsiteinabox.com/wp-content/uploads/2020/10/Featured-Image.jpg 479w, https://gibson.authorwebsiteinabox.com/wp-content/uploads/2020/10/Featured-Image-400x250.jpg 480w " sizes="(max-width:479px) 479px, 100vw "  width="400" height="250" /></a></div> <!-- .et_pb_image_container -->\n														<h3 class="entry-title"><a href="https://gibson.authorwebsiteinabox.com/demo-post-6/">Demo Post #6</a></h3>\n				\n					<p class="post-meta"><span class="published">Oct 19, 2020</span></p><div class="post-content"><div class="post-content-inner"><p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent mattis quis odio sit amet iaculis. Pellentesque ut posuere quam, scelerisque fringilla ante. Cras facilisis scelerisque tortor, et porttitor nisi gravida at. Praesent vitae aliquam eros, sed aliquam...</p>\n</div></div>			\n			</article> <!-- .et_pb_post -->\n				\n			<article id="post-28184" class="et_pb_post clearfix et_pb_blog_item_0_1 post-28184 post type-post status-publish format-standard has-post-thumbnail hentry category-uncategorized">\n\n				<div class="et_pb_image_container"><a href="https://gibson.authorwebsiteinabox.com/demo-post-5/" class="entry-featured-image-url"><img loading="lazy" src="https://gibson.authorwebsiteinabox.com/wp-content/uploads/2020/10/Featured-Image-400x250.jpg" alt="Demo Post #5" class="" srcset="https://gibson.authorwebsiteinabox.com/wp-content/uploads/2020/10/Featured-Image.jpg 479w, https://gibson.authorwebsiteinabox.com/wp-content/uploads/2020/10/Featured-Image-400x250.jpg 480w " sizes="(max-width:479px) 479px, 100vw "  width="400" height="250" /></a></div> <!-- .et_pb_image_container -->\n														<h3 class="entry-title"><a href="https://gibson.authorwebsiteinabox.com/demo-post-5/">Demo Post #5</a></h3>\n				\n					<p class="post-meta"><span class="published">Oct 19, 2020</span></p><div class="post-content"><div class="post-content-inner"><p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent mattis quis odio sit amet iaculis. Pellentesque ut posuere quam, scelerisque fringilla ante. Cras facilisis scelerisque tortor, et porttitor nisi gravida at. Praesent vitae aliquam eros, sed aliquam...</p>\n</div></div>			\n			</article> <!-- .et_pb_post -->\n				\n			<article id="post-28178" class="et_pb_post clearfix et_pb_blog_item_0_2 post-28178 post type-post status-publish format-standard has-post-thumbnail hentry category-uncategorized">\n\n				<div class="et_pb_image_container"><a href="https://gibson.authorwebsiteinabox.com/demo-post-4/" class="entry-featured-image-url"><img loading="lazy" src="https://gibson.authorwebsiteinabox.com/wp-content/uploads/2020/10/Featured-Image-400x250.jpg" alt="Demo Post #4" class="" srcset="https://gibson.authorwebsiteinabox.com/wp-content/uploads/2020/10/Featured-Image.jpg 479w, https://gibson.authorwebsiteinabox.com/wp-content/uploads/2020/10/Featured-Image-400x250.jpg 480w " sizes="(max-width:479px) 479px, 100vw "  width="400" height="250" /></a></div> <!-- .et_pb_image_container -->\n														<h3 class="entry-title"><a href="https://gibson.authorwebsiteinabox.com/demo-post-4/">Demo Post #4</a></h3>\n				\n					<p class="post-meta"><span class="published">Oct 19, 2020</span></p><div class="post-content"><div class="post-content-inner"><p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent mattis quis odio sit amet iaculis. Pellentesque ut posuere quam, scelerisque fringilla ante. Cras facilisis scelerisque tortor, et porttitor nisi gravida at. Praesent vitae aliquam eros, sed aliquam...</p>\n</div></div>			\n			</article> <!-- .et_pb_post -->\n				\n			<article id="post-28175" class="et_pb_post clearfix et_pb_blog_item_0_3 post-28175 post type-post status-publish format-standard has-post-thumbnail hentry category-uncategorized">\n\n				<div class="et_pb_image_container"><a href="https://gibson.authorwebsiteinabox.com/demo-post-3/" class="entry-featured-image-url"><img loading="lazy" src="https://gibson.authorwebsiteinabox.com/wp-content/uploads/2020/10/Featured-Image-400x250.jpg" alt="Demo Post #3" class="" srcset="https://gibson.authorwebsiteinabox.com/wp-content/uploads/2020/10/Featured-Image.jpg 479w, https://gibson.authorwebsiteinabox.com/wp-content/uploads/2020/10/Featured-Image-400x250.jpg 480w " sizes="(max-width:479px) 479px, 100vw "  width="400" height="250" /></a></div> <!-- .et_pb_image_container -->\n														<h3 class="entry-title"><a href="https://gibson.authorwebsiteinabox.com/demo-post-3/">Demo Post #3</a></h3>\n				\n					<p class="post-meta"><span class="published">Oct 19, 2020</span></p><div class="post-content"><div class="post-content-inner"><p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent mattis quis odio sit amet iaculis. Pellentesque ut posuere quam, scelerisque fringilla ante. Cras facilisis scelerisque tortor, et porttitor nisi gravida at. Praesent vitae aliquam eros, sed aliquam...</p>\n</div></div>			\n			</article> <!-- .et_pb_post -->\n				\n			<article id="post-28173" class="et_pb_post clearfix et_pb_blog_item_0_4 post-28173 post type-post status-publish format-standard has-post-thumbnail hentry category-uncategorized">\n\n				<div class="et_pb_image_container"><a href="https://gibson.authorwebsiteinabox.com/demo-post-2/" class="entry-featured-image-url"><img loading="lazy" src="https://gibson.authorwebsiteinabox.com/wp-content/uploads/2020/10/Featured-Image-400x250.jpg" alt="Demo Post #2" class="" srcset="https://gibson.authorwebsiteinabox.com/wp-content/uploads/2020/10/Featured-Image.jpg 479w, https://gibson.authorwebsiteinabox.com/wp-content/uploads/2020/10/Featured-Image-400x250.jpg 480w " sizes="(max-width:479px) 479px, 100vw "  width="400" height="250" /></a></div> <!-- .et_pb_image_container -->\n														<h3 class="entry-title"><a href="https://gibson.authorwebsiteinabox.com/demo-post-2/">Demo Post #2</a></h3>\n				\n					<p class="post-meta"><span class="published">Oct 19, 2020</span></p><div class="post-content"><div class="post-content-inner"><p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent mattis quis odio sit amet iaculis. Pellentesque ut posuere quam, scelerisque fringilla ante. Cras facilisis scelerisque tortor, et porttitor nisi gravida at. Praesent vitae aliquam eros, sed aliquam...</p>\n</div></div>			\n			</article> <!-- .et_pb_post -->\n				\n			<article id="post-28169" class="et_pb_post clearfix et_pb_blog_item_0_5 post-28169 post type-post status-publish format-standard has-post-thumbnail hentry category-uncategorized">\n\n				<div class="et_pb_image_container"><a href="https://gibson.authorwebsiteinabox.com/demo-post/" class="entry-featured-image-url"><img loading="lazy" src="https://gibson.authorwebsiteinabox.com/wp-content/uploads/2020/10/Featured-Image-400x250.jpg" alt="Demo Post #1" class="" srcset="https://gibson.authorwebsiteinabox.com/wp-content/uploads/2020/10/Featured-Image.jpg 479w, https://gibson.authorwebsiteinabox.com/wp-content/uploads/2020/10/Featured-Image-400x250.jpg 480w " sizes="(max-width:479px) 479px, 100vw "  width="400" height="250" /></a></div> <!-- .et_pb_image_container -->\n														<h3 class="entry-title"><a href="https://gibson.authorwebsiteinabox.com/demo-post/">Demo Post #1</a></h3>\n				\n					<p class="post-meta"><span class="published">Oct 19, 2020</span></p><div class="post-content"><div class="post-content-inner"><p>Lorem Ipsum is filler text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent mattis quis odio sit amet iaculis. Pellentesque ut posuere quam, scelerisque fringilla ante. Cras facilisis scelerisque tortor, et porttitor nisi gravida at. Praesent vitae...</p>\n</div></div>			\n			</article> <!-- .et_pb_post -->\n				</div><!-- .et_pb_salvattore_content --><div><div class="pagination clearfix">\n	<div class="alignleft"></div>\n	<div class="alignright"></div>\n</div></div></div> <!-- .et_pb_posts -->\n					</div>\n					 \n				</div>\n			</div> <!-- .et_pb_column -->\n				\n				\n			</div> <!-- .et_pb_row -->\n				\n				\n			</div> <!-- .et_pb_section --></p>\n');
INSERT INTO `wp5_postmeta` VALUES (149,28166,'_et_pb_truncate_post_date','2021-12-05 17:50:37');
INSERT INTO `wp5_postmeta` VALUES (150,28166,'_et_pb_old_content','');
INSERT INTO `wp5_postmeta` VALUES (151,28166,'_edit_lock','1635355214:3');
INSERT INTO `wp5_postmeta` VALUES (152,28166,'_et_pb_built_for_post_type','page');
INSERT INTO `wp5_postmeta` VALUES (153,28166,'_et_pb_ab_subjects','');
INSERT INTO `wp5_postmeta` VALUES (154,28166,'_et_pb_enable_shortcode_tracking','');
INSERT INTO `wp5_postmeta` VALUES (155,28166,'_et_pb_ab_current_shortcode','[et_pb_split_track id="28166" /]');
INSERT INTO `wp5_postmeta` VALUES (156,28166,'_et_pb_custom_css','');
INSERT INTO `wp5_postmeta` VALUES (157,28166,'_et_pb_gutter_width','3');
INSERT INTO `wp5_postmeta` VALUES (250,28205,'_wp_attached_file','2020/10/arson-2858155.jpg');
INSERT INTO `wp5_postmeta` VALUES (159,28166,'_et_builder_version','VB|Divi|4.6.6');
INSERT INTO `wp5_postmeta` VALUES (160,28166,'_et_pb_show_page_creation','off');
INSERT INTO `wp5_postmeta` VALUES (161,28169,'_edit_last','3');
INSERT INTO `wp5_postmeta` VALUES (162,28169,'_edit_lock','1605363724:2');
INSERT INTO `wp5_postmeta` VALUES (163,28170,'_wp_attached_file','2020/10/Featured-Image.jpg');
INSERT INTO `wp5_postmeta` VALUES (164,28170,'_wp_attachment_metadata','a:7:{s:5:"width";i:1920;s:6:"height";i:1080;s:4:"file";s:26:"2020/10/Featured-Image.jpg";s:5:"sizes";a:14:{s:6:"medium";a:4:{s:4:"file";s:26:"Featured-Image-300x169.jpg";s:5:"width";i:300;s:6:"height";i:169;s:9:"mime-type";s:10:"image/jpeg";}s:5:"large";a:4:{s:4:"file";s:27:"Featured-Image-1024x576.jpg";s:5:"width";i:1024;s:6:"height";i:576;s:9:"mime-type";s:10:"image/jpeg";}s:9:"thumbnail";a:4:{s:4:"file";s:26:"Featured-Image-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:12:"medium_large";a:4:{s:4:"file";s:26:"Featured-Image-768x432.jpg";s:5:"width";i:768;s:6:"height";i:432;s:9:"mime-type";s:10:"image/jpeg";}s:9:"1536x1536";a:4:{s:4:"file";s:27:"Featured-Image-1536x864.jpg";s:5:"width";i:1536;s:6:"height";i:864;s:9:"mime-type";s:10:"image/jpeg";}s:21:"et-pb-post-main-image";a:4:{s:4:"file";s:26:"Featured-Image-400x250.jpg";s:5:"width";i:400;s:6:"height";i:250;s:9:"mime-type";s:10:"image/jpeg";}s:31:"et-pb-post-main-image-fullwidth";a:4:{s:4:"file";s:27:"Featured-Image-1080x675.jpg";s:5:"width";i:1080;s:6:"height";i:675;s:9:"mime-type";s:10:"image/jpeg";}s:21:"et-pb-portfolio-image";a:4:{s:4:"file";s:26:"Featured-Image-400x284.jpg";s:5:"width";i:400;s:6:"height";i:284;s:9:"mime-type";s:10:"image/jpeg";}s:28:"et-pb-portfolio-module-image";a:4:{s:4:"file";s:26:"Featured-Image-510x382.jpg";s:5:"width";i:510;s:6:"height";i:382;s:9:"mime-type";s:10:"image/jpeg";}s:28:"et-pb-portfolio-image-single";a:4:{s:4:"file";s:27:"Featured-Image-1080x608.jpg";s:5:"width";i:1080;s:6:"height";i:608;s:9:"mime-type";s:10:"image/jpeg";}s:35:"et-pb-gallery-module-image-portrait";a:4:{s:4:"file";s:26:"Featured-Image-400x516.jpg";s:5:"width";i:400;s:6:"height";i:516;s:9:"mime-type";s:10:"image/jpeg";}s:32:"et-pb-image--responsive--desktop";a:4:{s:4:"file";s:27:"Featured-Image-1280x720.jpg";s:5:"width";i:1280;s:6:"height";i:720;s:9:"mime-type";s:10:"image/jpeg";}s:31:"et-pb-image--responsive--tablet";a:4:{s:4:"file";s:26:"Featured-Image-980x551.jpg";s:5:"width";i:980;s:6:"height";i:551;s:9:"mime-type";s:10:"image/jpeg";}s:30:"et-pb-image--responsive--phone";a:4:{s:4:"file";s:26:"Featured-Image-480x270.jpg";s:5:"width";i:480;s:6:"height";i:270;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"1";s:8:"keywords";a:0:{}}s:10:"ShortPixel";a:8:{s:4:"type";s:6:"glossy";s:8:"exifKept";s:1:"0";s:4:"date";s:19:"2020-10-20 19:13:26";s:9:"thumbsOpt";i:14;s:13:"thumbsOptList";a:14:{i:0;s:26:"Featured-Image-300x169.jpg";i:1;s:27:"Featured-Image-1024x576.jpg";i:2;s:26:"Featured-Image-150x150.jpg";i:3;s:26:"Featured-Image-768x432.jpg";i:4;s:27:"Featured-Image-1536x864.jpg";i:5;s:26:"Featured-Image-400x250.jpg";i:6;s:27:"Featured-Image-1080x675.jpg";i:7;s:26:"Featured-Image-400x284.jpg";i:8;s:26:"Featured-Image-510x382.jpg";i:9;s:27:"Featured-Image-1080x608.jpg";i:10;s:26:"Featured-Image-400x516.jpg";i:11;s:27:"Featured-Image-1280x720.jpg";i:12;s:26:"Featured-Image-980x551.jpg";i:13;s:26:"Featured-Image-480x270.jpg";}s:12:"excludeSizes";a:0:{}s:10:"retinasOpt";i:0;s:8:"NoBackup";b:1;}s:21:"ShortPixelImprovement";s:5:"40.89";}');
INSERT INTO `wp5_postmeta` VALUES (165,28169,'_thumbnail_id','28170');
INSERT INTO `wp5_postmeta` VALUES (166,28169,'_et_post_bg_color','#ffffff');
INSERT INTO `wp5_postmeta` VALUES (167,28169,'_et_post_bg_layout','light');
INSERT INTO `wp5_postmeta` VALUES (168,28169,'_et_pb_show_title','on');
INSERT INTO `wp5_postmeta` VALUES (169,28169,'_et_pb_post_hide_nav','default');
INSERT INTO `wp5_postmeta` VALUES (170,28169,'_et_pb_page_layout','et_right_sidebar');
INSERT INTO `wp5_postmeta` VALUES (171,28169,'_et_pb_side_nav','off');
INSERT INTO `wp5_postmeta` VALUES (2474,204971,'_edit_lock','1693165815:3');
INSERT INTO `wp5_postmeta` VALUES (2475,204971,'_edit_last','3');
INSERT INTO `wp5_postmeta` VALUES (2476,204971,'_wp_page_template','default');
INSERT INTO `wp5_postmeta` VALUES (2477,204971,'_et_pb_post_hide_nav','default');
INSERT INTO `wp5_postmeta` VALUES (2478,204971,'_et_pb_page_layout','et_right_sidebar');
INSERT INTO `wp5_postmeta` VALUES (2479,204971,'_et_pb_side_nav','off');
INSERT INTO `wp5_postmeta` VALUES (2480,204971,'_et_pb_use_builder','on');
INSERT INTO `wp5_postmeta` VALUES (2481,204971,'_et_pb_first_image','');
INSERT INTO `wp5_postmeta` VALUES (2482,204971,'_et_pb_truncate_post','');
INSERT INTO `wp5_postmeta` VALUES (2483,204971,'_et_pb_truncate_post_date','');
INSERT INTO `wp5_postmeta` VALUES (2484,204971,'_et_pb_old_content','');
INSERT INTO `wp5_postmeta` VALUES (176,28173,'_thumbnail_id','28170');
INSERT INTO `wp5_postmeta` VALUES (175,28173,'_edit_last','3');
INSERT INTO `wp5_postmeta` VALUES (187,28175,'_edit_lock','1605410351:2');
INSERT INTO `wp5_postmeta` VALUES (186,28175,'_edit_last','3');
INSERT INTO `wp5_postmeta` VALUES (179,28173,'_et_post_bg_color','#ffffff');
INSERT INTO `wp5_postmeta` VALUES (180,28173,'_et_post_bg_layout','light');
INSERT INTO `wp5_postmeta` VALUES (181,28173,'_et_pb_show_title','on');
INSERT INTO `wp5_postmeta` VALUES (182,28173,'_et_pb_post_hide_nav','default');
INSERT INTO `wp5_postmeta` VALUES (183,28173,'_et_pb_page_layout','et_right_sidebar');
INSERT INTO `wp5_postmeta` VALUES (184,28173,'_et_pb_side_nav','off');
INSERT INTO `wp5_postmeta` VALUES (185,28173,'_edit_lock','1603073374:1');
INSERT INTO `wp5_postmeta` VALUES (188,28175,'_thumbnail_id','28170');
INSERT INTO `wp5_postmeta` VALUES (191,28175,'_et_post_bg_color','#ffffff');
INSERT INTO `wp5_postmeta` VALUES (192,28175,'_et_post_bg_layout','light');
INSERT INTO `wp5_postmeta` VALUES (193,28175,'_et_pb_show_title','on');
INSERT INTO `wp5_postmeta` VALUES (194,28175,'_et_pb_post_hide_nav','default');
INSERT INTO `wp5_postmeta` VALUES (195,28175,'_et_pb_page_layout','et_right_sidebar');
INSERT INTO `wp5_postmeta` VALUES (196,28175,'_et_pb_side_nav','off');
INSERT INTO `wp5_postmeta` VALUES (210,28178,'_edit_lock','1603073253:1');
INSERT INTO `wp5_postmeta` VALUES (209,28178,'_edit_last','3');
INSERT INTO `wp5_postmeta` VALUES (211,28178,'_thumbnail_id','28170');
INSERT INTO `wp5_postmeta` VALUES (221,28183,'_edit_lock','1605368440:2');
INSERT INTO `wp5_postmeta` VALUES (220,28183,'_edit_last','3');
INSERT INTO `wp5_postmeta` VALUES (214,28178,'_et_post_bg_color','#ffffff');
INSERT INTO `wp5_postmeta` VALUES (215,28178,'_et_post_bg_layout','light');
INSERT INTO `wp5_postmeta` VALUES (216,28178,'_et_pb_show_title','on');
INSERT INTO `wp5_postmeta` VALUES (217,28178,'_et_pb_post_hide_nav','default');
INSERT INTO `wp5_postmeta` VALUES (218,28178,'_et_pb_page_layout','et_right_sidebar');
INSERT INTO `wp5_postmeta` VALUES (219,28178,'_et_pb_side_nav','off');
INSERT INTO `wp5_postmeta` VALUES (222,28184,'_edit_last','3');
INSERT INTO `wp5_postmeta` VALUES (223,28184,'_thumbnail_id','28170');
INSERT INTO `wp5_postmeta` VALUES (233,28183,'_thumbnail_id','28170');
INSERT INTO `wp5_postmeta` VALUES (226,28184,'_et_post_bg_color','#ffffff');
INSERT INTO `wp5_postmeta` VALUES (227,28184,'_et_post_bg_layout','light');
INSERT INTO `wp5_postmeta` VALUES (228,28184,'_et_pb_show_title','on');
INSERT INTO `wp5_postmeta` VALUES (229,28184,'_et_pb_post_hide_nav','default');
INSERT INTO `wp5_postmeta` VALUES (230,28184,'_et_pb_page_layout','et_right_sidebar');
INSERT INTO `wp5_postmeta` VALUES (231,28184,'_et_pb_side_nav','off');
INSERT INTO `wp5_postmeta` VALUES (232,28184,'_edit_lock','1603073311:1');
INSERT INTO `wp5_postmeta` VALUES (236,28183,'_et_post_bg_color','#ffffff');
INSERT INTO `wp5_postmeta` VALUES (237,28183,'_et_post_bg_layout','light');
INSERT INTO `wp5_postmeta` VALUES (238,28183,'_et_pb_show_title','on');
INSERT INTO `wp5_postmeta` VALUES (239,28183,'_et_pb_post_hide_nav','default');
INSERT INTO `wp5_postmeta` VALUES (240,28183,'_et_pb_page_layout','et_right_sidebar');
INSERT INTO `wp5_postmeta` VALUES (241,28183,'_et_pb_side_nav','off');
INSERT INTO `wp5_postmeta` VALUES (248,28200,'_et_pb_built_for_post_type','page');
INSERT INTO `wp5_postmeta` VALUES (251,28205,'_wp_attachment_metadata','a:7:{s:5:"width";i:1930;s:6:"height";i:1285;s:4:"file";s:25:"2020/10/arson-2858155.jpg";s:5:"sizes";a:14:{s:6:"medium";a:4:{s:4:"file";s:25:"arson-2858155-300x200.jpg";s:5:"width";i:300;s:6:"height";i:200;s:9:"mime-type";s:10:"image/jpeg";}s:5:"large";a:4:{s:4:"file";s:26:"arson-2858155-1024x682.jpg";s:5:"width";i:1024;s:6:"height";i:682;s:9:"mime-type";s:10:"image/jpeg";}s:9:"thumbnail";a:4:{s:4:"file";s:25:"arson-2858155-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:12:"medium_large";a:4:{s:4:"file";s:25:"arson-2858155-768x511.jpg";s:5:"width";i:768;s:6:"height";i:511;s:9:"mime-type";s:10:"image/jpeg";}s:9:"1536x1536";a:4:{s:4:"file";s:27:"arson-2858155-1536x1023.jpg";s:5:"width";i:1536;s:6:"height";i:1023;s:9:"mime-type";s:10:"image/jpeg";}s:21:"et-pb-post-main-image";a:4:{s:4:"file";s:25:"arson-2858155-400x250.jpg";s:5:"width";i:400;s:6:"height";i:250;s:9:"mime-type";s:10:"image/jpeg";}s:31:"et-pb-post-main-image-fullwidth";a:4:{s:4:"file";s:26:"arson-2858155-1080x675.jpg";s:5:"width";i:1080;s:6:"height";i:675;s:9:"mime-type";s:10:"image/jpeg";}s:21:"et-pb-portfolio-image";a:4:{s:4:"file";s:25:"arson-2858155-400x284.jpg";s:5:"width";i:400;s:6:"height";i:284;s:9:"mime-type";s:10:"image/jpeg";}s:28:"et-pb-portfolio-module-image";a:4:{s:4:"file";s:25:"arson-2858155-510x382.jpg";s:5:"width";i:510;s:6:"height";i:382;s:9:"mime-type";s:10:"image/jpeg";}s:28:"et-pb-portfolio-image-single";a:4:{s:4:"file";s:26:"arson-2858155-1080x719.jpg";s:5:"width";i:1080;s:6:"height";i:719;s:9:"mime-type";s:10:"image/jpeg";}s:35:"et-pb-gallery-module-image-portrait";a:4:{s:4:"file";s:25:"arson-2858155-400x516.jpg";s:5:"width";i:400;s:6:"height";i:516;s:9:"mime-type";s:10:"image/jpeg";}s:32:"et-pb-image--responsive--desktop";a:4:{s:4:"file";s:26:"arson-2858155-1280x852.jpg";s:5:"width";i:1280;s:6:"height";i:852;s:9:"mime-type";s:10:"image/jpeg";}s:31:"et-pb-image--responsive--tablet";a:4:{s:4:"file";s:25:"arson-2858155-980x652.jpg";s:5:"width";i:980;s:6:"height";i:652;s:9:"mime-type";s:10:"image/jpeg";}s:30:"et-pb-image--responsive--phone";a:4:{s:4:"file";s:25:"arson-2858155-480x320.jpg";s:5:"width";i:480;s:6:"height";i:320;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}s:10:"ShortPixel";a:8:{s:4:"type";s:6:"glossy";s:8:"exifKept";s:1:"0";s:4:"date";s:19:"2020-10-20 19:13:06";s:9:"thumbsOpt";i:14;s:13:"thumbsOptList";a:14:{i:0;s:25:"arson-2858155-300x200.jpg";i:1;s:26:"arson-2858155-1024x682.jpg";i:2;s:25:"arson-2858155-150x150.jpg";i:3;s:25:"arson-2858155-768x511.jpg";i:4;s:27:"arson-2858155-1536x1023.jpg";i:5;s:25:"arson-2858155-400x250.jpg";i:6;s:26:"arson-2858155-1080x675.jpg";i:7;s:25:"arson-2858155-400x284.jpg";i:8;s:25:"arson-2858155-510x382.jpg";i:9;s:26:"arson-2858155-1080x719.jpg";i:10;s:25:"arson-2858155-400x516.jpg";i:11;s:26:"arson-2858155-1280x852.jpg";i:12;s:25:"arson-2858155-980x652.jpg";i:13;s:25:"arson-2858155-480x320.jpg";}s:12:"excludeSizes";a:0:{}s:10:"retinasOpt";i:0;s:8:"NoBackup";b:1;}s:21:"ShortPixelImprovement";s:5:"10.07";}');
INSERT INTO `wp5_postmeta` VALUES (1359,204451,'_wp_attached_file','2020/11/author_logo.png');
INSERT INTO `wp5_postmeta` VALUES (1360,204451,'_wp_attachment_metadata','a:7:{s:5:"width";i:1500;s:6:"height";i:300;s:4:"file";s:23:"2020/11/author_logo.png";s:5:"sizes";a:14:{s:6:"medium";a:4:{s:4:"file";s:22:"author_logo-300x60.png";s:5:"width";i:300;s:6:"height";i:60;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:24:"author_logo-1024x205.png";s:5:"width";i:1024;s:6:"height";i:205;s:9:"mime-type";s:9:"image/png";}s:9:"thumbnail";a:4:{s:4:"file";s:23:"author_logo-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:12:"medium_large";a:4:{s:4:"file";s:23:"author_logo-768x154.png";s:5:"width";i:768;s:6:"height";i:154;s:9:"mime-type";s:9:"image/png";}s:11:"bloom_image";a:4:{s:4:"file";s:23:"author_logo-610x122.png";s:5:"width";i:610;s:6:"height";i:122;s:9:"mime-type";s:9:"image/png";}s:21:"et-pb-post-main-image";a:4:{s:4:"file";s:23:"author_logo-400x250.png";s:5:"width";i:400;s:6:"height";i:250;s:9:"mime-type";s:9:"image/png";}s:31:"et-pb-post-main-image-fullwidth";a:4:{s:4:"file";s:24:"author_logo-1080x300.png";s:5:"width";i:1080;s:6:"height";i:300;s:9:"mime-type";s:9:"image/png";}s:21:"et-pb-portfolio-image";a:4:{s:4:"file";s:23:"author_logo-400x284.png";s:5:"width";i:400;s:6:"height";i:284;s:9:"mime-type";s:9:"image/png";}s:28:"et-pb-portfolio-module-image";a:4:{s:4:"file";s:23:"author_logo-510x300.png";s:5:"width";i:510;s:6:"height";i:300;s:9:"mime-type";s:9:"image/png";}s:28:"et-pb-portfolio-image-single";a:4:{s:4:"file";s:24:"author_logo-1080x216.png";s:5:"width";i:1080;s:6:"height";i:216;s:9:"mime-type";s:9:"image/png";}s:35:"et-pb-gallery-module-image-portrait";a:4:{s:4:"file";s:23:"author_logo-400x300.png";s:5:"width";i:400;s:6:"height";i:300;s:9:"mime-type";s:9:"image/png";}s:32:"et-pb-image--responsive--desktop";a:4:{s:4:"file";s:24:"author_logo-1280x256.png";s:5:"width";i:1280;s:6:"height";i:256;s:9:"mime-type";s:9:"image/png";}s:31:"et-pb-image--responsive--tablet";a:4:{s:4:"file";s:23:"author_logo-980x196.png";s:5:"width";i:980;s:6:"height";i:196;s:9:"mime-type";s:9:"image/png";}s:30:"et-pb-image--responsive--phone";a:4:{s:4:"file";s:22:"author_logo-480x96.png";s:5:"width";i:480;s:6:"height";i:96;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}s:10:"ShortPixel";a:8:{s:4:"type";s:6:"glossy";s:8:"exifKept";s:1:"0";s:4:"date";s:19:"2020-11-06 04:08:48";s:9:"thumbsOpt";i:14;s:13:"thumbsOptList";a:14:{i:0;s:22:"author_logo-300x60.png";i:1;s:24:"author_logo-1024x205.png";i:2;s:23:"author_logo-150x150.png";i:3;s:23:"author_logo-768x154.png";i:4;s:23:"author_logo-610x122.png";i:5;s:23:"author_logo-400x250.png";i:6;s:24:"author_logo-1080x300.png";i:7;s:23:"author_logo-400x284.png";i:8;s:23:"author_logo-510x300.png";i:9;s:24:"author_logo-1080x216.png";i:10;s:23:"author_logo-400x300.png";i:11;s:24:"author_logo-1280x256.png";i:12;s:23:"author_logo-980x196.png";i:13;s:22:"author_logo-480x96.png";}s:12:"excludeSizes";a:0:{}s:10:"retinasOpt";i:0;s:8:"NoBackup";b:1;}s:21:"ShortPixelImprovement";s:5:"78.69";}');
INSERT INTO `wp5_postmeta` VALUES (1048,203940,'_edit_lock','1603381837:1');
INSERT INTO `wp5_postmeta` VALUES (1009,204298,'_menu_item_type','post_type');
INSERT INTO `wp5_postmeta` VALUES (1010,204298,'_menu_item_menu_item_parent','0');
INSERT INTO `wp5_postmeta` VALUES (1011,204298,'_menu_item_object_id','204274');
INSERT INTO `wp5_postmeta` VALUES (1012,204298,'_menu_item_object','page');
INSERT INTO `wp5_postmeta` VALUES (1013,204298,'_menu_item_target','');
INSERT INTO `wp5_postmeta` VALUES (1014,204298,'_menu_item_classes','a:1:{i:0;s:0:"";}');
INSERT INTO `wp5_postmeta` VALUES (1015,204298,'_menu_item_xfn','');
INSERT INTO `wp5_postmeta` VALUES (1016,204298,'_menu_item_url','');
INSERT INTO `wp5_postmeta` VALUES (1027,204300,'_menu_item_type','post_type');
INSERT INTO `wp5_postmeta` VALUES (1028,204300,'_menu_item_menu_item_parent','0');
INSERT INTO `wp5_postmeta` VALUES (1029,204300,'_menu_item_object_id','28166');
INSERT INTO `wp5_postmeta` VALUES (1030,204300,'_menu_item_object','page');
INSERT INTO `wp5_postmeta` VALUES (1031,204300,'_menu_item_target','');
INSERT INTO `wp5_postmeta` VALUES (1032,204300,'_menu_item_classes','a:1:{i:0;s:0:"";}');
INSERT INTO `wp5_postmeta` VALUES (1033,204300,'_menu_item_xfn','');
INSERT INTO `wp5_postmeta` VALUES (1034,204300,'_menu_item_url','');
INSERT INTO `wp5_postmeta` VALUES (1007,204292,'_shortpixel_status','2.5600');
INSERT INTO `wp5_postmeta` VALUES (1006,204293,'_shortpixel_status','2.2600');
INSERT INTO `wp5_postmeta` VALUES (258,28209,'_wp_attached_file','2020/10/StockSnap_8QLS0HOYMM-scaled-1-1.jpg');
INSERT INTO `wp5_postmeta` VALUES (259,28209,'_wp_attachment_metadata','a:7:{s:5:"width";i:2560;s:6:"height";i:1708;s:4:"file";s:43:"2020/10/StockSnap_8QLS0HOYMM-scaled-1-1.jpg";s:5:"sizes";a:15:{s:6:"medium";a:4:{s:4:"file";s:43:"StockSnap_8QLS0HOYMM-scaled-1-1-300x200.jpg";s:5:"width";i:300;s:6:"height";i:200;s:9:"mime-type";s:10:"image/jpeg";}s:5:"large";a:4:{s:4:"file";s:44:"StockSnap_8QLS0HOYMM-scaled-1-1-1024x683.jpg";s:5:"width";i:1024;s:6:"height";i:683;s:9:"mime-type";s:10:"image/jpeg";}s:9:"thumbnail";a:4:{s:4:"file";s:43:"StockSnap_8QLS0HOYMM-scaled-1-1-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:12:"medium_large";a:4:{s:4:"file";s:43:"StockSnap_8QLS0HOYMM-scaled-1-1-768x512.jpg";s:5:"width";i:768;s:6:"height";i:512;s:9:"mime-type";s:10:"image/jpeg";}s:9:"1536x1536";a:4:{s:4:"file";s:45:"StockSnap_8QLS0HOYMM-scaled-1-1-1536x1025.jpg";s:5:"width";i:1536;s:6:"height";i:1025;s:9:"mime-type";s:10:"image/jpeg";}s:9:"2048x2048";a:4:{s:4:"file";s:45:"StockSnap_8QLS0HOYMM-scaled-1-1-2048x1366.jpg";s:5:"width";i:2048;s:6:"height";i:1366;s:9:"mime-type";s:10:"image/jpeg";}s:21:"et-pb-post-main-image";a:4:{s:4:"file";s:43:"StockSnap_8QLS0HOYMM-scaled-1-1-400x250.jpg";s:5:"width";i:400;s:6:"height";i:250;s:9:"mime-type";s:10:"image/jpeg";}s:31:"et-pb-post-main-image-fullwidth";a:4:{s:4:"file";s:44:"StockSnap_8QLS0HOYMM-scaled-1-1-1080x675.jpg";s:5:"width";i:1080;s:6:"height";i:675;s:9:"mime-type";s:10:"image/jpeg";}s:21:"et-pb-portfolio-image";a:4:{s:4:"file";s:43:"StockSnap_8QLS0HOYMM-scaled-1-1-400x284.jpg";s:5:"width";i:400;s:6:"height";i:284;s:9:"mime-type";s:10:"image/jpeg";}s:28:"et-pb-portfolio-module-image";a:4:{s:4:"file";s:43:"StockSnap_8QLS0HOYMM-scaled-1-1-510x382.jpg";s:5:"width";i:510;s:6:"height";i:382;s:9:"mime-type";s:10:"image/jpeg";}s:28:"et-pb-portfolio-image-single";a:4:{s:4:"file";s:44:"StockSnap_8QLS0HOYMM-scaled-1-1-1080x721.jpg";s:5:"width";i:1080;s:6:"height";i:721;s:9:"mime-type";s:10:"image/jpeg";}s:35:"et-pb-gallery-module-image-portrait";a:4:{s:4:"file";s:43:"StockSnap_8QLS0HOYMM-scaled-1-1-400x516.jpg";s:5:"width";i:400;s:6:"height";i:516;s:9:"mime-type";s:10:"image/jpeg";}s:32:"et-pb-image--responsive--desktop";a:4:{s:4:"file";s:44:"StockSnap_8QLS0HOYMM-scaled-1-1-1280x854.jpg";s:5:"width";i:1280;s:6:"height";i:854;s:9:"mime-type";s:10:"image/jpeg";}s:31:"et-pb-image--responsive--tablet";a:4:{s:4:"file";s:43:"StockSnap_8QLS0HOYMM-scaled-1-1-980x654.jpg";s:5:"width";i:980;s:6:"height";i:654;s:9:"mime-type";s:10:"image/jpeg";}s:30:"et-pb-image--responsive--phone";a:4:{s:4:"file";s:43:"StockSnap_8QLS0HOYMM-scaled-1-1-480x320.jpg";s:5:"width";i:480;s:6:"height";i:320;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}s:10:"ShortPixel";a:8:{s:4:"type";s:6:"glossy";s:8:"exifKept";s:1:"0";s:4:"date";s:19:"2020-10-20 19:11:14";s:9:"thumbsOpt";i:15;s:13:"thumbsOptList";a:15:{i:0;s:43:"StockSnap_8QLS0HOYMM-scaled-1-1-300x200.jpg";i:1;s:44:"StockSnap_8QLS0HOYMM-scaled-1-1-1024x683.jpg";i:2;s:43:"StockSnap_8QLS0HOYMM-scaled-1-1-150x150.jpg";i:3;s:43:"StockSnap_8QLS0HOYMM-scaled-1-1-768x512.jpg";i:4;s:45:"StockSnap_8QLS0HOYMM-scaled-1-1-1536x1025.jpg";i:5;s:45:"StockSnap_8QLS0HOYMM-scaled-1-1-2048x1366.jpg";i:6;s:43:"StockSnap_8QLS0HOYMM-scaled-1-1-400x250.jpg";i:7;s:44:"StockSnap_8QLS0HOYMM-scaled-1-1-1080x675.jpg";i:8;s:43:"StockSnap_8QLS0HOYMM-scaled-1-1-400x284.jpg";i:9;s:43:"StockSnap_8QLS0HOYMM-scaled-1-1-510x382.jpg";i:10;s:44:"StockSnap_8QLS0HOYMM-scaled-1-1-1080x721.jpg";i:11;s:43:"StockSnap_8QLS0HOYMM-scaled-1-1-400x516.jpg";i:12;s:44:"StockSnap_8QLS0HOYMM-scaled-1-1-1280x854.jpg";i:13;s:43:"StockSnap_8QLS0HOYMM-scaled-1-1-980x654.jpg";i:14;s:43:"StockSnap_8QLS0HOYMM-scaled-1-1-480x320.jpg";}s:12:"excludeSizes";a:0:{}s:10:"retinasOpt";i:0;s:8:"NoBackup";b:1;}s:21:"ShortPixelImprovement";s:5:"14.07";}');
INSERT INTO `wp5_postmeta` VALUES (1390,204484,'_wp_attached_file','2020/11/author_signature.png');
INSERT INTO `wp5_postmeta` VALUES (1375,204451,'_shortpixel_status','2.7800');
INSERT INTO `wp5_postmeta` VALUES (828,204238,'_shortpixel_status','2.1300');
INSERT INTO `wp5_postmeta` VALUES (716,21,'_shortpixel_status','2.0400');
INSERT INTO `wp5_postmeta` VALUES (718,16,'_shortpixel_status','2.0600');
INSERT INTO `wp5_postmeta` VALUES (720,8,'_shortpixel_status','2.1600');
INSERT INTO `wp5_postmeta` VALUES (721,204165,'_edit_lock','1603221890:1');
INSERT INTO `wp5_postmeta` VALUES (728,28139,'_thumbnail_id','0');
INSERT INTO `wp5_postmeta` VALUES (732,204183,'_wp_attached_file','2020/10/Depositphotos_29446435_xl-2015-scaled.jpg');
INSERT INTO `wp5_postmeta` VALUES (723,204165,'_wp_attachment_backup_sizes','a:17:{s:9:"full-orig";a:3:{s:5:"width";i:2560;s:6:"height";i:1440;s:4:"file";s:42:"Depositphotos_223512888_xl-2015-scaled.jpg";}s:14:"thumbnail-orig";a:4:{s:4:"file";s:43:"Depositphotos_223512888_xl-2015-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:11:"medium-orig";a:4:{s:4:"file";s:43:"Depositphotos_223512888_xl-2015-300x169.jpg";s:5:"width";i:300;s:6:"height";i:169;s:9:"mime-type";s:10:"image/jpeg";}s:17:"medium_large-orig";a:4:{s:4:"file";s:43:"Depositphotos_223512888_xl-2015-768x432.jpg";s:5:"width";i:768;s:6:"height";i:432;s:9:"mime-type";s:10:"image/jpeg";}s:10:"large-orig";a:4:{s:4:"file";s:44:"Depositphotos_223512888_xl-2015-1024x576.jpg";s:5:"width";i:1024;s:6:"height";i:576;s:9:"mime-type";s:10:"image/jpeg";}s:14:"1536x1536-orig";a:4:{s:4:"file";s:44:"Depositphotos_223512888_xl-2015-1536x864.jpg";s:5:"width";i:1536;s:6:"height";i:864;s:9:"mime-type";s:10:"image/jpeg";}s:14:"2048x2048-orig";a:4:{s:4:"file";s:45:"Depositphotos_223512888_xl-2015-2048x1152.jpg";s:5:"width";i:2048;s:6:"height";i:1152;s:9:"mime-type";s:10:"image/jpeg";}s:26:"et-pb-post-main-image-orig";a:4:{s:4:"file";s:43:"Depositphotos_223512888_xl-2015-400x250.jpg";s:5:"width";i:400;s:6:"height";i:250;s:9:"mime-type";s:10:"image/jpeg";}s:36:"et-pb-post-main-image-fullwidth-orig";a:4:{s:4:"file";s:44:"Depositphotos_223512888_xl-2015-1080x675.jpg";s:5:"width";i:1080;s:6:"height";i:675;s:9:"mime-type";s:10:"image/jpeg";}s:26:"et-pb-portfolio-image-orig";a:4:{s:4:"file";s:43:"Depositphotos_223512888_xl-2015-400x284.jpg";s:5:"width";i:400;s:6:"height";i:284;s:9:"mime-type";s:10:"image/jpeg";}s:33:"et-pb-portfolio-module-image-orig";a:4:{s:4:"file";s:43:"Depositphotos_223512888_xl-2015-510x382.jpg";s:5:"width";i:510;s:6:"height";i:382;s:9:"mime-type";s:10:"image/jpeg";}s:33:"et-pb-portfolio-image-single-orig";a:4:{s:4:"file";s:44:"Depositphotos_223512888_xl-2015-1080x608.jpg";s:5:"width";i:1080;s:6:"height";i:608;s:9:"mime-type";s:10:"image/jpeg";}s:40:"et-pb-gallery-module-image-portrait-orig";a:4:{s:4:"file";s:43:"Depositphotos_223512888_xl-2015-400x516.jpg";s:5:"width";i:400;s:6:"height";i:516;s:9:"mime-type";s:10:"image/jpeg";}s:42:"et-pb-post-main-image-fullwidth-large-orig";a:4:{s:4:"file";s:45:"Depositphotos_223512888_xl-2015-2880x1800.jpg";s:5:"width";i:2880;s:6:"height";i:1800;s:9:"mime-type";s:10:"image/jpeg";}s:37:"et-pb-image--responsive--desktop-orig";a:4:{s:4:"file";s:44:"Depositphotos_223512888_xl-2015-1280x720.jpg";s:5:"width";i:1280;s:6:"height";i:720;s:9:"mime-type";s:10:"image/jpeg";}s:36:"et-pb-image--responsive--tablet-orig";a:4:{s:4:"file";s:43:"Depositphotos_223512888_xl-2015-980x551.jpg";s:5:"width";i:980;s:6:"height";i:551;s:9:"mime-type";s:10:"image/jpeg";}s:35:"et-pb-image--responsive--phone-orig";a:4:{s:4:"file";s:43:"Depositphotos_223512888_xl-2015-480x270.jpg";s:5:"width";i:480;s:6:"height";i:270;s:9:"mime-type";s:10:"image/jpeg";}}');
INSERT INTO `wp5_postmeta` VALUES (827,204238,'_wp_attachment_metadata','a:7:{s:5:"width";i:2560;s:6:"height";i:1024;s:4:"file";s:52:"2020/10/Depositphotos_162576212_xl-2015-scaled-1.jpg";s:5:"sizes";a:15:{s:6:"medium";a:4:{s:4:"file";s:52:"Depositphotos_162576212_xl-2015-scaled-1-300x120.jpg";s:5:"width";i:300;s:6:"height";i:120;s:9:"mime-type";s:10:"image/jpeg";}s:5:"large";a:4:{s:4:"file";s:53:"Depositphotos_162576212_xl-2015-scaled-1-1024x410.jpg";s:5:"width";i:1024;s:6:"height";i:410;s:9:"mime-type";s:10:"image/jpeg";}s:9:"thumbnail";a:4:{s:4:"file";s:52:"Depositphotos_162576212_xl-2015-scaled-1-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:12:"medium_large";a:4:{s:4:"file";s:52:"Depositphotos_162576212_xl-2015-scaled-1-768x307.jpg";s:5:"width";i:768;s:6:"height";i:307;s:9:"mime-type";s:10:"image/jpeg";}s:9:"1536x1536";a:4:{s:4:"file";s:53:"Depositphotos_162576212_xl-2015-scaled-1-1536x614.jpg";s:5:"width";i:1536;s:6:"height";i:614;s:9:"mime-type";s:10:"image/jpeg";}s:9:"2048x2048";a:4:{s:4:"file";s:53:"Depositphotos_162576212_xl-2015-scaled-1-2048x819.jpg";s:5:"width";i:2048;s:6:"height";i:819;s:9:"mime-type";s:10:"image/jpeg";}s:21:"et-pb-post-main-image";a:4:{s:4:"file";s:52:"Depositphotos_162576212_xl-2015-scaled-1-400x250.jpg";s:5:"width";i:400;s:6:"height";i:250;s:9:"mime-type";s:10:"image/jpeg";}s:31:"et-pb-post-main-image-fullwidth";a:4:{s:4:"file";s:53:"Depositphotos_162576212_xl-2015-scaled-1-1080x675.jpg";s:5:"width";i:1080;s:6:"height";i:675;s:9:"mime-type";s:10:"image/jpeg";}s:21:"et-pb-portfolio-image";a:4:{s:4:"file";s:52:"Depositphotos_162576212_xl-2015-scaled-1-400x284.jpg";s:5:"width";i:400;s:6:"height";i:284;s:9:"mime-type";s:10:"image/jpeg";}s:28:"et-pb-portfolio-module-image";a:4:{s:4:"file";s:52:"Depositphotos_162576212_xl-2015-scaled-1-510x382.jpg";s:5:"width";i:510;s:6:"height";i:382;s:9:"mime-type";s:10:"image/jpeg";}s:28:"et-pb-portfolio-image-single";a:4:{s:4:"file";s:53:"Depositphotos_162576212_xl-2015-scaled-1-1080x432.jpg";s:5:"width";i:1080;s:6:"height";i:432;s:9:"mime-type";s:10:"image/jpeg";}s:35:"et-pb-gallery-module-image-portrait";a:4:{s:4:"file";s:52:"Depositphotos_162576212_xl-2015-scaled-1-400x516.jpg";s:5:"width";i:400;s:6:"height";i:516;s:9:"mime-type";s:10:"image/jpeg";}s:32:"et-pb-image--responsive--desktop";a:4:{s:4:"file";s:53:"Depositphotos_162576212_xl-2015-scaled-1-1280x512.jpg";s:5:"width";i:1280;s:6:"height";i:512;s:9:"mime-type";s:10:"image/jpeg";}s:31:"et-pb-image--responsive--tablet";a:4:{s:4:"file";s:52:"Depositphotos_162576212_xl-2015-scaled-1-980x392.jpg";s:5:"width";i:980;s:6:"height";i:392;s:9:"mime-type";s:10:"image/jpeg";}s:30:"et-pb-image--responsive--phone";a:4:{s:4:"file";s:52:"Depositphotos_162576212_xl-2015-scaled-1-480x192.jpg";s:5:"width";i:480;s:6:"height";i:192;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}s:10:"ShortPixel";a:8:{s:4:"type";s:6:"glossy";s:8:"exifKept";s:1:"0";s:4:"date";s:19:"2020-10-22 14:10:17";s:9:"thumbsOpt";i:15;s:13:"thumbsOptList";a:15:{i:0;s:52:"Depositphotos_162576212_xl-2015-scaled-1-300x120.jpg";i:1;s:53:"Depositphotos_162576212_xl-2015-scaled-1-1024x410.jpg";i:2;s:52:"Depositphotos_162576212_xl-2015-scaled-1-150x150.jpg";i:3;s:52:"Depositphotos_162576212_xl-2015-scaled-1-768x307.jpg";i:4;s:53:"Depositphotos_162576212_xl-2015-scaled-1-1536x614.jpg";i:5;s:53:"Depositphotos_162576212_xl-2015-scaled-1-2048x819.jpg";i:6;s:52:"Depositphotos_162576212_xl-2015-scaled-1-400x250.jpg";i:7;s:53:"Depositphotos_162576212_xl-2015-scaled-1-1080x675.jpg";i:8;s:52:"Depositphotos_162576212_xl-2015-scaled-1-400x284.jpg";i:9;s:52:"Depositphotos_162576212_xl-2015-scaled-1-510x382.jpg";i:10;s:53:"Depositphotos_162576212_xl-2015-scaled-1-1080x432.jpg";i:11;s:52:"Depositphotos_162576212_xl-2015-scaled-1-400x516.jpg";i:12;s:53:"Depositphotos_162576212_xl-2015-scaled-1-1280x512.jpg";i:13;s:52:"Depositphotos_162576212_xl-2015-scaled-1-980x392.jpg";i:14;s:52:"Depositphotos_162576212_xl-2015-scaled-1-480x192.jpg";}s:12:"excludeSizes";a:0:{}s:10:"retinasOpt";i:0;s:8:"NoBackup";b:1;}s:21:"ShortPixelImprovement";s:5:"13.73";}');
INSERT INTO `wp5_postmeta` VALUES (734,204184,'_wp_attached_file','2020/10/Depositphotos_138456694_xl-2015-scaled.jpg');
INSERT INTO `wp5_postmeta` VALUES (735,204184,'_wp_attachment_metadata','a:8:{s:5:"width";i:2560;s:6:"height";i:1707;s:4:"file";s:50:"2020/10/Depositphotos_138456694_xl-2015-scaled.jpg";s:5:"sizes";a:16:{s:6:"medium";a:4:{s:4:"file";s:43:"Depositphotos_138456694_xl-2015-300x200.jpg";s:5:"width";i:300;s:6:"height";i:200;s:9:"mime-type";s:10:"image/jpeg";}s:5:"large";a:4:{s:4:"file";s:44:"Depositphotos_138456694_xl-2015-1024x683.jpg";s:5:"width";i:1024;s:6:"height";i:683;s:9:"mime-type";s:10:"image/jpeg";}s:9:"thumbnail";a:4:{s:4:"file";s:43:"Depositphotos_138456694_xl-2015-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:12:"medium_large";a:4:{s:4:"file";s:43:"Depositphotos_138456694_xl-2015-768x512.jpg";s:5:"width";i:768;s:6:"height";i:512;s:9:"mime-type";s:10:"image/jpeg";}s:9:"1536x1536";a:4:{s:4:"file";s:45:"Depositphotos_138456694_xl-2015-1536x1024.jpg";s:5:"width";i:1536;s:6:"height";i:1024;s:9:"mime-type";s:10:"image/jpeg";}s:9:"2048x2048";a:4:{s:4:"file";s:45:"Depositphotos_138456694_xl-2015-2048x1365.jpg";s:5:"width";i:2048;s:6:"height";i:1365;s:9:"mime-type";s:10:"image/jpeg";}s:21:"et-pb-post-main-image";a:4:{s:4:"file";s:43:"Depositphotos_138456694_xl-2015-400x250.jpg";s:5:"width";i:400;s:6:"height";i:250;s:9:"mime-type";s:10:"image/jpeg";}s:31:"et-pb-post-main-image-fullwidth";a:4:{s:4:"file";s:44:"Depositphotos_138456694_xl-2015-1080x675.jpg";s:5:"width";i:1080;s:6:"height";i:675;s:9:"mime-type";s:10:"image/jpeg";}s:21:"et-pb-portfolio-image";a:4:{s:4:"file";s:43:"Depositphotos_138456694_xl-2015-400x284.jpg";s:5:"width";i:400;s:6:"height";i:284;s:9:"mime-type";s:10:"image/jpeg";}s:28:"et-pb-portfolio-module-image";a:4:{s:4:"file";s:43:"Depositphotos_138456694_xl-2015-510x382.jpg";s:5:"width";i:510;s:6:"height";i:382;s:9:"mime-type";s:10:"image/jpeg";}s:28:"et-pb-portfolio-image-single";a:4:{s:4:"file";s:44:"Depositphotos_138456694_xl-2015-1080x720.jpg";s:5:"width";i:1080;s:6:"height";i:720;s:9:"mime-type";s:10:"image/jpeg";}s:35:"et-pb-gallery-module-image-portrait";a:4:{s:4:"file";s:43:"Depositphotos_138456694_xl-2015-400x516.jpg";s:5:"width";i:400;s:6:"height";i:516;s:9:"mime-type";s:10:"image/jpeg";}s:37:"et-pb-post-main-image-fullwidth-large";a:4:{s:4:"file";s:45:"Depositphotos_138456694_xl-2015-2880x1800.jpg";s:5:"width";i:2880;s:6:"height";i:1800;s:9:"mime-type";s:10:"image/jpeg";}s:32:"et-pb-image--responsive--desktop";a:4:{s:4:"file";s:44:"Depositphotos_138456694_xl-2015-1280x854.jpg";s:5:"width";i:1280;s:6:"height";i:854;s:9:"mime-type";s:10:"image/jpeg";}s:31:"et-pb-image--responsive--tablet";a:4:{s:4:"file";s:43:"Depositphotos_138456694_xl-2015-980x653.jpg";s:5:"width";i:980;s:6:"height";i:653;s:9:"mime-type";s:10:"image/jpeg";}s:30:"et-pb-image--responsive--phone";a:4:{s:4:"file";s:43:"Depositphotos_138456694_xl-2015-480x320.jpg";s:5:"width";i:480;s:6:"height";i:320;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:81:"sci-fi scenery of futuristic city with industrial buildings,illustration painting";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"1";s:8:"keywords";a:26:{i:0;s:7:"acrylic";i:1;s:3:"art";i:2;s:8:"artistic";i:3;s:7:"artwork";i:4;s:12:"illustration";i:5;s:12:"oil painting";i:6;s:8:"painting";i:7;s:10:"watercolor";i:8;s:12:"architecture";i:9;s:8:"building";i:10;s:4:"city";i:11;s:9:"cityscape";i:12;s:5:"color";i:13;s:7:"concept";i:14;s:9:"cyberpunk";i:15;s:10:"futuristic";i:16;s:10:"industrial";i:17;s:7:"scenery";i:18;s:6:"sci fi";i:19;s:15:"science fiction";i:20;s:3:"sky";i:21;s:10:"skyscraper";i:22;s:9:"structure";i:23;s:5:"tower";i:24;s:8:"colorful";i:25;s:12:"light trails";}}s:14:"original_image";s:35:"Depositphotos_138456694_xl-2015.jpg";s:10:"ShortPixel";a:8:{s:4:"type";s:6:"glossy";s:8:"exifKept";s:1:"0";s:4:"date";s:19:"2020-10-20 20:58:55";s:9:"thumbsOpt";i:17;s:13:"thumbsOptList";a:17:{i:0;s:35:"Depositphotos_138456694_xl-2015.jpg";i:1;s:43:"Depositphotos_138456694_xl-2015-300x200.jpg";i:2;s:44:"Depositphotos_138456694_xl-2015-1024x683.jpg";i:3;s:43:"Depositphotos_138456694_xl-2015-150x150.jpg";i:4;s:43:"Depositphotos_138456694_xl-2015-768x512.jpg";i:5;s:45:"Depositphotos_138456694_xl-2015-1536x1024.jpg";i:6;s:45:"Depositphotos_138456694_xl-2015-2048x1365.jpg";i:7;s:43:"Depositphotos_138456694_xl-2015-400x250.jpg";i:8;s:44:"Depositphotos_138456694_xl-2015-1080x675.jpg";i:9;s:43:"Depositphotos_138456694_xl-2015-400x284.jpg";i:10;s:43:"Depositphotos_138456694_xl-2015-510x382.jpg";i:11;s:44:"Depositphotos_138456694_xl-2015-1080x720.jpg";i:12;s:43:"Depositphotos_138456694_xl-2015-400x516.jpg";i:13;s:45:"Depositphotos_138456694_xl-2015-2880x1800.jpg";i:14;s:44:"Depositphotos_138456694_xl-2015-1280x854.jpg";i:15;s:43:"Depositphotos_138456694_xl-2015-980x653.jpg";i:16;s:43:"Depositphotos_138456694_xl-2015-480x320.jpg";}s:12:"excludeSizes";a:0:{}s:10:"retinasOpt";i:0;s:8:"NoBackup";b:1;}s:21:"ShortPixelImprovement";s:5:"63.98";}');
INSERT INTO `wp5_postmeta` VALUES (286,28223,'_wp_attached_file','2020/10/makeup-artist-62.jpg');
INSERT INTO `wp5_postmeta` VALUES (287,28223,'_wp_attachment_metadata','a:7:{s:5:"width";i:800;s:6:"height";i:800;s:4:"file";s:28:"2020/10/makeup-artist-62.jpg";s:5:"sizes";a:9:{s:6:"medium";a:4:{s:4:"file";s:28:"makeup-artist-62-300x300.jpg";s:5:"width";i:300;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";}s:9:"thumbnail";a:4:{s:4:"file";s:28:"makeup-artist-62-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:12:"medium_large";a:4:{s:4:"file";s:28:"makeup-artist-62-768x768.jpg";s:5:"width";i:768;s:6:"height";i:768;s:9:"mime-type";s:10:"image/jpeg";}s:21:"et-pb-post-main-image";a:4:{s:4:"file";s:28:"makeup-artist-62-400x250.jpg";s:5:"width";i:400;s:6:"height";i:250;s:9:"mime-type";s:10:"image/jpeg";}s:31:"et-pb-post-main-image-fullwidth";a:4:{s:4:"file";s:28:"makeup-artist-62-800x675.jpg";s:5:"width";i:800;s:6:"height";i:675;s:9:"mime-type";s:10:"image/jpeg";}s:21:"et-pb-portfolio-image";a:4:{s:4:"file";s:28:"makeup-artist-62-400x284.jpg";s:5:"width";i:400;s:6:"height";i:284;s:9:"mime-type";s:10:"image/jpeg";}s:28:"et-pb-portfolio-module-image";a:4:{s:4:"file";s:28:"makeup-artist-62-510x382.jpg";s:5:"width";i:510;s:6:"height";i:382;s:9:"mime-type";s:10:"image/jpeg";}s:35:"et-pb-gallery-module-image-portrait";a:4:{s:4:"file";s:28:"makeup-artist-62-400x516.jpg";s:5:"width";i:400;s:6:"height";i:516;s:9:"mime-type";s:10:"image/jpeg";}s:30:"et-pb-image--responsive--phone";a:4:{s:4:"file";s:28:"makeup-artist-62-480x480.jpg";s:5:"width";i:480;s:6:"height";i:480;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}s:10:"ShortPixel";a:8:{s:4:"type";s:6:"glossy";s:8:"exifKept";s:1:"0";s:4:"date";s:19:"2020-10-20 19:06:54";s:9:"thumbsOpt";i:9;s:13:"thumbsOptList";a:9:{i:0;s:28:"makeup-artist-62-300x300.jpg";i:1;s:28:"makeup-artist-62-150x150.jpg";i:2;s:28:"makeup-artist-62-768x768.jpg";i:3;s:28:"makeup-artist-62-400x250.jpg";i:4;s:28:"makeup-artist-62-800x675.jpg";i:5;s:28:"makeup-artist-62-400x284.jpg";i:6;s:28:"makeup-artist-62-510x382.jpg";i:7;s:28:"makeup-artist-62-400x516.jpg";i:8;s:28:"makeup-artist-62-480x480.jpg";}s:12:"excludeSizes";a:0:{}s:10:"retinasOpt";i:0;s:8:"NoBackup";b:1;}s:21:"ShortPixelImprovement";s:5:"11.85";}');
INSERT INTO `wp5_postmeta` VALUES (288,28224,'_wp_attached_file','2020/10/ebook-03.png');
INSERT INTO `wp5_postmeta` VALUES (289,28224,'_wp_attachment_metadata','a:7:{s:5:"width";i:400;s:6:"height";i:1044;s:4:"file";s:20:"2020/10/ebook-03.png";s:5:"sizes";a:8:{s:6:"medium";a:4:{s:4:"file";s:20:"ebook-03-115x300.png";s:5:"width";i:115;s:6:"height";i:300;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:21:"ebook-03-392x1024.png";s:5:"width";i:392;s:6:"height";i:1024;s:9:"mime-type";s:9:"image/png";}s:9:"thumbnail";a:4:{s:4:"file";s:20:"ebook-03-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:21:"et-pb-post-main-image";a:4:{s:4:"file";s:20:"ebook-03-400x250.png";s:5:"width";i:400;s:6:"height";i:250;s:9:"mime-type";s:9:"image/png";}s:31:"et-pb-post-main-image-fullwidth";a:4:{s:4:"file";s:20:"ebook-03-400x675.png";s:5:"width";i:400;s:6:"height";i:675;s:9:"mime-type";s:9:"image/png";}s:21:"et-pb-portfolio-image";a:4:{s:4:"file";s:20:"ebook-03-400x284.png";s:5:"width";i:400;s:6:"height";i:284;s:9:"mime-type";s:9:"image/png";}s:28:"et-pb-portfolio-module-image";a:4:{s:4:"file";s:20:"ebook-03-400x382.png";s:5:"width";i:400;s:6:"height";i:382;s:9:"mime-type";s:9:"image/png";}s:35:"et-pb-gallery-module-image-portrait";a:4:{s:4:"file";s:20:"ebook-03-400x516.png";s:5:"width";i:400;s:6:"height";i:516;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}s:10:"ShortPixel";a:8:{s:4:"type";s:6:"glossy";s:8:"exifKept";s:1:"0";s:4:"date";s:19:"2020-10-20 19:06:37";s:9:"thumbsOpt";i:8;s:13:"thumbsOptList";a:8:{i:0;s:20:"ebook-03-115x300.png";i:1;s:21:"ebook-03-392x1024.png";i:2;s:20:"ebook-03-150x150.png";i:3;s:20:"ebook-03-400x250.png";i:4;s:20:"ebook-03-400x675.png";i:5;s:20:"ebook-03-400x284.png";i:6;s:20:"ebook-03-400x382.png";i:7;s:20:"ebook-03-400x516.png";}s:12:"excludeSizes";a:0:{}s:10:"retinasOpt";i:0;s:8:"NoBackup";b:1;}s:21:"ShortPixelImprovement";s:5:"81.93";}');
INSERT INTO `wp5_postmeta` VALUES (853,204248,'_et_pb_truncate_post','');
INSERT INTO `wp5_postmeta` VALUES (846,204248,'_et_pb_ab_subjects','');
INSERT INTO `wp5_postmeta` VALUES (847,204248,'_et_pb_enable_shortcode_tracking','');
INSERT INTO `wp5_postmeta` VALUES (848,204248,'_et_pb_ab_current_shortcode','[et_pb_split_track id="204248" /]');
INSERT INTO `wp5_postmeta` VALUES (849,204248,'_et_pb_custom_css','');
INSERT INTO `wp5_postmeta` VALUES (850,204248,'_et_pb_gutter_width','3');
INSERT INTO `wp5_postmeta` VALUES (858,204248,'_et_pb_use_builder','on');
INSERT INTO `wp5_postmeta` VALUES (852,204248,'_et_pb_first_image','');
INSERT INTO `wp5_postmeta` VALUES (294,28227,'_wp_attached_file','2020/10/ebook-40.png');
INSERT INTO `wp5_postmeta` VALUES (295,28227,'_wp_attachment_metadata','a:7:{s:5:"width";i:2998;s:6:"height";i:1499;s:4:"file";s:20:"2020/10/ebook-40.png";s:5:"sizes";a:16:{s:6:"medium";a:4:{s:4:"file";s:20:"ebook-40-300x150.png";s:5:"width";i:300;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:21:"ebook-40-1024x512.png";s:5:"width";i:1024;s:6:"height";i:512;s:9:"mime-type";s:9:"image/png";}s:9:"thumbnail";a:4:{s:4:"file";s:20:"ebook-40-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:12:"medium_large";a:4:{s:4:"file";s:20:"ebook-40-768x384.png";s:5:"width";i:768;s:6:"height";i:384;s:9:"mime-type";s:9:"image/png";}s:9:"1536x1536";a:4:{s:4:"file";s:21:"ebook-40-1536x768.png";s:5:"width";i:1536;s:6:"height";i:768;s:9:"mime-type";s:9:"image/png";}s:9:"2048x2048";a:4:{s:4:"file";s:22:"ebook-40-2048x1024.png";s:5:"width";i:2048;s:6:"height";i:1024;s:9:"mime-type";s:9:"image/png";}s:21:"et-pb-post-main-image";a:4:{s:4:"file";s:20:"ebook-40-400x250.png";s:5:"width";i:400;s:6:"height";i:250;s:9:"mime-type";s:9:"image/png";}s:31:"et-pb-post-main-image-fullwidth";a:4:{s:4:"file";s:21:"ebook-40-1080x675.png";s:5:"width";i:1080;s:6:"height";i:675;s:9:"mime-type";s:9:"image/png";}s:21:"et-pb-portfolio-image";a:4:{s:4:"file";s:20:"ebook-40-400x284.png";s:5:"width";i:400;s:6:"height";i:284;s:9:"mime-type";s:9:"image/png";}s:28:"et-pb-portfolio-module-image";a:4:{s:4:"file";s:20:"ebook-40-510x382.png";s:5:"width";i:510;s:6:"height";i:382;s:9:"mime-type";s:9:"image/png";}s:28:"et-pb-portfolio-image-single";a:4:{s:4:"file";s:21:"ebook-40-1080x540.png";s:5:"width";i:1080;s:6:"height";i:540;s:9:"mime-type";s:9:"image/png";}s:35:"et-pb-gallery-module-image-portrait";a:4:{s:4:"file";s:20:"ebook-40-400x516.png";s:5:"width";i:400;s:6:"height";i:516;s:9:"mime-type";s:9:"image/png";}s:37:"et-pb-post-main-image-fullwidth-large";a:4:{s:4:"file";s:22:"ebook-40-2880x1499.png";s:5:"width";i:2880;s:6:"height";i:1499;s:9:"mime-type";s:9:"image/png";}s:32:"et-pb-image--responsive--desktop";a:4:{s:4:"file";s:21:"ebook-40-1280x640.png";s:5:"width";i:1280;s:6:"height";i:640;s:9:"mime-type";s:9:"image/png";}s:31:"et-pb-image--responsive--tablet";a:4:{s:4:"file";s:20:"ebook-40-980x490.png";s:5:"width";i:980;s:6:"height";i:490;s:9:"mime-type";s:9:"image/png";}s:30:"et-pb-image--responsive--phone";a:4:{s:4:"file";s:20:"ebook-40-480x240.png";s:5:"width";i:480;s:6:"height";i:240;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}s:10:"ShortPixel";a:8:{s:4:"type";s:6:"glossy";s:8:"exifKept";s:1:"0";s:4:"date";s:19:"2020-10-20 19:05:53";s:9:"thumbsOpt";i:16;s:13:"thumbsOptList";a:16:{i:0;s:20:"ebook-40-300x150.png";i:1;s:21:"ebook-40-1024x512.png";i:2;s:20:"ebook-40-150x150.png";i:3;s:20:"ebook-40-768x384.png";i:4;s:21:"ebook-40-1536x768.png";i:5;s:22:"ebook-40-2048x1024.png";i:6;s:20:"ebook-40-400x250.png";i:7;s:21:"ebook-40-1080x675.png";i:8;s:20:"ebook-40-400x284.png";i:9;s:20:"ebook-40-510x382.png";i:10;s:21:"ebook-40-1080x540.png";i:11;s:20:"ebook-40-400x516.png";i:12;s:22:"ebook-40-2880x1499.png";i:13;s:21:"ebook-40-1280x640.png";i:14;s:20:"ebook-40-980x490.png";i:15;s:20:"ebook-40-480x240.png";}s:12:"excludeSizes";a:0:{}s:10:"retinasOpt";i:0;s:8:"NoBackup";b:1;}s:21:"ShortPixelImprovement";s:5:"80.67";}');
INSERT INTO `wp5_postmeta` VALUES (296,28228,'_wp_attached_file','2020/10/Depositphotos_50549765_ds-1-scaled-1.jpg');
INSERT INTO `wp5_postmeta` VALUES (297,28228,'_wp_attachment_metadata','a:7:{s:5:"width";i:2560;s:6:"height";i:1441;s:4:"file";s:48:"2020/10/Depositphotos_50549765_ds-1-scaled-1.jpg";s:5:"sizes";a:15:{s:6:"medium";a:4:{s:4:"file";s:48:"Depositphotos_50549765_ds-1-scaled-1-300x169.jpg";s:5:"width";i:300;s:6:"height";i:169;s:9:"mime-type";s:10:"image/jpeg";}s:5:"large";a:4:{s:4:"file";s:49:"Depositphotos_50549765_ds-1-scaled-1-1024x576.jpg";s:5:"width";i:1024;s:6:"height";i:576;s:9:"mime-type";s:10:"image/jpeg";}s:9:"thumbnail";a:4:{s:4:"file";s:48:"Depositphotos_50549765_ds-1-scaled-1-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:12:"medium_large";a:4:{s:4:"file";s:48:"Depositphotos_50549765_ds-1-scaled-1-768x432.jpg";s:5:"width";i:768;s:6:"height";i:432;s:9:"mime-type";s:10:"image/jpeg";}s:9:"1536x1536";a:4:{s:4:"file";s:49:"Depositphotos_50549765_ds-1-scaled-1-1536x865.jpg";s:5:"width";i:1536;s:6:"height";i:865;s:9:"mime-type";s:10:"image/jpeg";}s:9:"2048x2048";a:4:{s:4:"file";s:50:"Depositphotos_50549765_ds-1-scaled-1-2048x1153.jpg";s:5:"width";i:2048;s:6:"height";i:1153;s:9:"mime-type";s:10:"image/jpeg";}s:21:"et-pb-post-main-image";a:4:{s:4:"file";s:48:"Depositphotos_50549765_ds-1-scaled-1-400x250.jpg";s:5:"width";i:400;s:6:"height";i:250;s:9:"mime-type";s:10:"image/jpeg";}s:31:"et-pb-post-main-image-fullwidth";a:4:{s:4:"file";s:49:"Depositphotos_50549765_ds-1-scaled-1-1080x675.jpg";s:5:"width";i:1080;s:6:"height";i:675;s:9:"mime-type";s:10:"image/jpeg";}s:21:"et-pb-portfolio-image";a:4:{s:4:"file";s:48:"Depositphotos_50549765_ds-1-scaled-1-400x284.jpg";s:5:"width";i:400;s:6:"height";i:284;s:9:"mime-type";s:10:"image/jpeg";}s:28:"et-pb-portfolio-module-image";a:4:{s:4:"file";s:48:"Depositphotos_50549765_ds-1-scaled-1-510x382.jpg";s:5:"width";i:510;s:6:"height";i:382;s:9:"mime-type";s:10:"image/jpeg";}s:28:"et-pb-portfolio-image-single";a:4:{s:4:"file";s:49:"Depositphotos_50549765_ds-1-scaled-1-1080x608.jpg";s:5:"width";i:1080;s:6:"height";i:608;s:9:"mime-type";s:10:"image/jpeg";}s:35:"et-pb-gallery-module-image-portrait";a:4:{s:4:"file";s:48:"Depositphotos_50549765_ds-1-scaled-1-400x516.jpg";s:5:"width";i:400;s:6:"height";i:516;s:9:"mime-type";s:10:"image/jpeg";}s:32:"et-pb-image--responsive--desktop";a:4:{s:4:"file";s:49:"Depositphotos_50549765_ds-1-scaled-1-1280x721.jpg";s:5:"width";i:1280;s:6:"height";i:721;s:9:"mime-type";s:10:"image/jpeg";}s:31:"et-pb-image--responsive--tablet";a:4:{s:4:"file";s:48:"Depositphotos_50549765_ds-1-scaled-1-980x552.jpg";s:5:"width";i:980;s:6:"height";i:552;s:9:"mime-type";s:10:"image/jpeg";}s:30:"et-pb-image--responsive--phone";a:4:{s:4:"file";s:48:"Depositphotos_50549765_ds-1-scaled-1-480x270.jpg";s:5:"width";i:480;s:6:"height";i:270;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}s:10:"ShortPixel";a:8:{s:4:"type";s:6:"glossy";s:8:"exifKept";s:1:"0";s:4:"date";s:19:"2020-10-20 19:05:34";s:9:"thumbsOpt";i:15;s:13:"thumbsOptList";a:15:{i:0;s:48:"Depositphotos_50549765_ds-1-scaled-1-300x169.jpg";i:1;s:49:"Depositphotos_50549765_ds-1-scaled-1-1024x576.jpg";i:2;s:48:"Depositphotos_50549765_ds-1-scaled-1-150x150.jpg";i:3;s:48:"Depositphotos_50549765_ds-1-scaled-1-768x432.jpg";i:4;s:49:"Depositphotos_50549765_ds-1-scaled-1-1536x865.jpg";i:5;s:50:"Depositphotos_50549765_ds-1-scaled-1-2048x1153.jpg";i:6;s:48:"Depositphotos_50549765_ds-1-scaled-1-400x250.jpg";i:7;s:49:"Depositphotos_50549765_ds-1-scaled-1-1080x675.jpg";i:8;s:48:"Depositphotos_50549765_ds-1-scaled-1-400x284.jpg";i:9;s:48:"Depositphotos_50549765_ds-1-scaled-1-510x382.jpg";i:10;s:49:"Depositphotos_50549765_ds-1-scaled-1-1080x608.jpg";i:11;s:48:"Depositphotos_50549765_ds-1-scaled-1-400x516.jpg";i:12;s:49:"Depositphotos_50549765_ds-1-scaled-1-1280x721.jpg";i:13;s:48:"Depositphotos_50549765_ds-1-scaled-1-980x552.jpg";i:14;s:48:"Depositphotos_50549765_ds-1-scaled-1-480x270.jpg";}s:12:"excludeSizes";a:0:{}s:10:"retinasOpt";i:0;s:8:"NoBackup";b:1;}s:21:"ShortPixelImprovement";s:4:"16.5";}');
INSERT INTO `wp5_postmeta` VALUES (298,28229,'_wp_attached_file','2020/10/author_07.jpg');
INSERT INTO `wp5_postmeta` VALUES (299,28229,'_wp_attachment_metadata','a:7:{s:5:"width";i:1920;s:6:"height";i:1192;s:4:"file";s:21:"2020/10/author_07.jpg";s:5:"sizes";a:14:{s:6:"medium";a:4:{s:4:"file";s:21:"author_07-300x186.jpg";s:5:"width";i:300;s:6:"height";i:186;s:9:"mime-type";s:10:"image/jpeg";}s:5:"large";a:4:{s:4:"file";s:22:"author_07-1024x636.jpg";s:5:"width";i:1024;s:6:"height";i:636;s:9:"mime-type";s:10:"image/jpeg";}s:9:"thumbnail";a:4:{s:4:"file";s:21:"author_07-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:12:"medium_large";a:4:{s:4:"file";s:21:"author_07-768x477.jpg";s:5:"width";i:768;s:6:"height";i:477;s:9:"mime-type";s:10:"image/jpeg";}s:9:"1536x1536";a:4:{s:4:"file";s:22:"author_07-1536x954.jpg";s:5:"width";i:1536;s:6:"height";i:954;s:9:"mime-type";s:10:"image/jpeg";}s:21:"et-pb-post-main-image";a:4:{s:4:"file";s:21:"author_07-400x250.jpg";s:5:"width";i:400;s:6:"height";i:250;s:9:"mime-type";s:10:"image/jpeg";}s:31:"et-pb-post-main-image-fullwidth";a:4:{s:4:"file";s:22:"author_07-1080x675.jpg";s:5:"width";i:1080;s:6:"height";i:675;s:9:"mime-type";s:10:"image/jpeg";}s:21:"et-pb-portfolio-image";a:4:{s:4:"file";s:21:"author_07-400x284.jpg";s:5:"width";i:400;s:6:"height";i:284;s:9:"mime-type";s:10:"image/jpeg";}s:28:"et-pb-portfolio-module-image";a:4:{s:4:"file";s:21:"author_07-510x382.jpg";s:5:"width";i:510;s:6:"height";i:382;s:9:"mime-type";s:10:"image/jpeg";}s:28:"et-pb-portfolio-image-single";a:4:{s:4:"file";s:22:"author_07-1080x671.jpg";s:5:"width";i:1080;s:6:"height";i:671;s:9:"mime-type";s:10:"image/jpeg";}s:35:"et-pb-gallery-module-image-portrait";a:4:{s:4:"file";s:21:"author_07-400x516.jpg";s:5:"width";i:400;s:6:"height";i:516;s:9:"mime-type";s:10:"image/jpeg";}s:32:"et-pb-image--responsive--desktop";a:4:{s:4:"file";s:22:"author_07-1280x795.jpg";s:5:"width";i:1280;s:6:"height";i:795;s:9:"mime-type";s:10:"image/jpeg";}s:31:"et-pb-image--responsive--tablet";a:4:{s:4:"file";s:21:"author_07-980x608.jpg";s:5:"width";i:980;s:6:"height";i:608;s:9:"mime-type";s:10:"image/jpeg";}s:30:"et-pb-image--responsive--phone";a:4:{s:4:"file";s:21:"author_07-480x298.jpg";s:5:"width";i:480;s:6:"height";i:298;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}s:10:"ShortPixel";a:8:{s:4:"type";s:6:"glossy";s:8:"exifKept";s:1:"0";s:4:"date";s:19:"2020-10-20 19:05:11";s:9:"thumbsOpt";i:14;s:13:"thumbsOptList";a:14:{i:0;s:21:"author_07-300x186.jpg";i:1;s:22:"author_07-1024x636.jpg";i:2;s:21:"author_07-150x150.jpg";i:3;s:21:"author_07-768x477.jpg";i:4;s:22:"author_07-1536x954.jpg";i:5;s:21:"author_07-400x250.jpg";i:6;s:22:"author_07-1080x675.jpg";i:7;s:21:"author_07-400x284.jpg";i:8;s:21:"author_07-510x382.jpg";i:9;s:22:"author_07-1080x671.jpg";i:10;s:21:"author_07-400x516.jpg";i:11;s:22:"author_07-1280x795.jpg";i:12;s:21:"author_07-980x608.jpg";i:13;s:21:"author_07-480x298.jpg";}s:12:"excludeSizes";a:0:{}s:10:"retinasOpt";i:0;s:8:"NoBackup";b:1;}s:21:"ShortPixelImprovement";s:4:"9.94";}');
INSERT INTO `wp5_postmeta` VALUES (905,204268,'_et_pb_built_for_post_type','page');
INSERT INTO `wp5_postmeta` VALUES (906,204260,'_et_pb_built_for_post_type','page');
INSERT INTO `wp5_postmeta` VALUES (907,204260,'_et_pb_ab_subjects','');
INSERT INTO `wp5_postmeta` VALUES (908,204260,'_et_pb_enable_shortcode_tracking','');
INSERT INTO `wp5_postmeta` VALUES (909,204260,'_et_pb_ab_current_shortcode','[et_pb_split_track id="204260" /]');
INSERT INTO `wp5_postmeta` VALUES (910,204260,'_et_pb_custom_css','');
INSERT INTO `wp5_postmeta` VALUES (911,204260,'_et_pb_gutter_width','3');
INSERT INTO `wp5_postmeta` VALUES (915,204270,'_wp_attached_file','2020/10/Depositphotos_185209912_xl-2015-scaled.jpg');
INSERT INTO `wp5_postmeta` VALUES (913,204260,'_et_builder_version','VB|Divi|4.27.4');
INSERT INTO `wp5_postmeta` VALUES (914,204260,'_et_pb_show_page_creation','off');
INSERT INTO `wp5_postmeta` VALUES (916,204270,'_wp_attachment_metadata','a:8:{s:5:"width";i:2560;s:6:"height";i:1440;s:4:"file";s:50:"2020/10/Depositphotos_185209912_xl-2015-scaled.jpg";s:5:"sizes";a:16:{s:6:"medium";a:4:{s:4:"file";s:43:"Depositphotos_185209912_xl-2015-300x169.jpg";s:5:"width";i:300;s:6:"height";i:169;s:9:"mime-type";s:10:"image/jpeg";}s:5:"large";a:4:{s:4:"file";s:44:"Depositphotos_185209912_xl-2015-1024x576.jpg";s:5:"width";i:1024;s:6:"height";i:576;s:9:"mime-type";s:10:"image/jpeg";}s:9:"thumbnail";a:4:{s:4:"file";s:43:"Depositphotos_185209912_xl-2015-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:12:"medium_large";a:4:{s:4:"file";s:43:"Depositphotos_185209912_xl-2015-768x432.jpg";s:5:"width";i:768;s:6:"height";i:432;s:9:"mime-type";s:10:"image/jpeg";}s:9:"1536x1536";a:4:{s:4:"file";s:44:"Depositphotos_185209912_xl-2015-1536x864.jpg";s:5:"width";i:1536;s:6:"height";i:864;s:9:"mime-type";s:10:"image/jpeg";}s:9:"2048x2048";a:4:{s:4:"file";s:45:"Depositphotos_185209912_xl-2015-2048x1152.jpg";s:5:"width";i:2048;s:6:"height";i:1152;s:9:"mime-type";s:10:"image/jpeg";}s:21:"et-pb-post-main-image";a:4:{s:4:"file";s:43:"Depositphotos_185209912_xl-2015-400x250.jpg";s:5:"width";i:400;s:6:"height";i:250;s:9:"mime-type";s:10:"image/jpeg";}s:31:"et-pb-post-main-image-fullwidth";a:4:{s:4:"file";s:44:"Depositphotos_185209912_xl-2015-1080x675.jpg";s:5:"width";i:1080;s:6:"height";i:675;s:9:"mime-type";s:10:"image/jpeg";}s:21:"et-pb-portfolio-image";a:4:{s:4:"file";s:43:"Depositphotos_185209912_xl-2015-400x284.jpg";s:5:"width";i:400;s:6:"height";i:284;s:9:"mime-type";s:10:"image/jpeg";}s:28:"et-pb-portfolio-module-image";a:4:{s:4:"file";s:43:"Depositphotos_185209912_xl-2015-510x382.jpg";s:5:"width";i:510;s:6:"height";i:382;s:9:"mime-type";s:10:"image/jpeg";}s:28:"et-pb-portfolio-image-single";a:4:{s:4:"file";s:44:"Depositphotos_185209912_xl-2015-1080x608.jpg";s:5:"width";i:1080;s:6:"height";i:608;s:9:"mime-type";s:10:"image/jpeg";}s:35:"et-pb-gallery-module-image-portrait";a:4:{s:4:"file";s:43:"Depositphotos_185209912_xl-2015-400x516.jpg";s:5:"width";i:400;s:6:"height";i:516;s:9:"mime-type";s:10:"image/jpeg";}s:37:"et-pb-post-main-image-fullwidth-large";a:4:{s:4:"file";s:45:"Depositphotos_185209912_xl-2015-2880x1800.jpg";s:5:"width";i:2880;s:6:"height";i:1800;s:9:"mime-type";s:10:"image/jpeg";}s:32:"et-pb-image--responsive--desktop";a:4:{s:4:"file";s:44:"Depositphotos_185209912_xl-2015-1280x720.jpg";s:5:"width";i:1280;s:6:"height";i:720;s:9:"mime-type";s:10:"image/jpeg";}s:31:"et-pb-image--responsive--tablet";a:4:{s:4:"file";s:43:"Depositphotos_185209912_xl-2015-980x551.jpg";s:5:"width";i:980;s:6:"height";i:551;s:9:"mime-type";s:10:"image/jpeg";}s:30:"et-pb-image--responsive--phone";a:4:{s:4:"file";s:43:"Depositphotos_185209912_xl-2015-480x270.jpg";s:5:"width";i:480;s:6:"height";i:270;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:112:"man standing on balcony looking at futuristic city with colorful light, digital art style, illustration painting";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"1";s:8:"keywords";a:26:{i:0;s:12:"illustration";i:1;s:8:"painting";i:2;s:3:"art";i:3;s:11:"imagination";i:4;s:8:"artistic";i:5;s:7:"artwork";i:6;s:7:"acrylic";i:7;s:5:"scene";i:8;s:11:"neon lights";i:9;s:5:"urban";i:10;s:5:"light";i:11;s:12:"illumination";i:12;s:9:"cyberpunk";i:13;s:10:"futuristic";i:14;s:15:"science fiction";i:15;s:6:"sci-fi";i:16;s:7:"outdoor";i:17;s:9:"cityscape";i:18;s:3:"man";i:19;s:8:"standing";i:20;s:10:"skyscraper";i:21;s:9:"buildings";i:22;s:4:"city";i:23;s:7:"looking";i:24;s:7:"concept";i:25;s:4:"view";}}s:14:"original_image";s:35:"Depositphotos_185209912_xl-2015.jpg";s:10:"ShortPixel";a:8:{s:4:"type";s:6:"glossy";s:8:"exifKept";s:1:"0";s:4:"date";s:19:"2020-10-22 15:20:36";s:9:"thumbsOpt";i:17;s:13:"thumbsOptList";a:17:{i:0;s:35:"Depositphotos_185209912_xl-2015.jpg";i:1;s:43:"Depositphotos_185209912_xl-2015-300x169.jpg";i:2;s:44:"Depositphotos_185209912_xl-2015-1024x576.jpg";i:3;s:43:"Depositphotos_185209912_xl-2015-150x150.jpg";i:4;s:43:"Depositphotos_185209912_xl-2015-768x432.jpg";i:5;s:44:"Depositphotos_185209912_xl-2015-1536x864.jpg";i:6;s:45:"Depositphotos_185209912_xl-2015-2048x1152.jpg";i:7;s:43:"Depositphotos_185209912_xl-2015-400x250.jpg";i:8;s:44:"Depositphotos_185209912_xl-2015-1080x675.jpg";i:9;s:43:"Depositphotos_185209912_xl-2015-400x284.jpg";i:10;s:43:"Depositphotos_185209912_xl-2015-510x382.jpg";i:11;s:44:"Depositphotos_185209912_xl-2015-1080x608.jpg";i:12;s:43:"Depositphotos_185209912_xl-2015-400x516.jpg";i:13;s:45:"Depositphotos_185209912_xl-2015-2880x1800.jpg";i:14;s:44:"Depositphotos_185209912_xl-2015-1280x720.jpg";i:15;s:43:"Depositphotos_185209912_xl-2015-980x551.jpg";i:16;s:43:"Depositphotos_185209912_xl-2015-480x270.jpg";}s:12:"excludeSizes";a:0:{}s:10:"retinasOpt";i:0;s:8:"NoBackup";b:1;}s:21:"ShortPixelImprovement";s:5:"80.81";}');
INSERT INTO `wp5_postmeta` VALUES (302,28231,'_wp_attached_file','2020/10/author_04-1.jpg');
INSERT INTO `wp5_postmeta` VALUES (303,28231,'_wp_attachment_metadata','a:7:{s:5:"width";i:600;s:6:"height";i:850;s:4:"file";s:23:"2020/10/author_04-1.jpg";s:5:"sizes";a:8:{s:6:"medium";a:4:{s:4:"file";s:23:"author_04-1-212x300.jpg";s:5:"width";i:212;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";}s:9:"thumbnail";a:4:{s:4:"file";s:23:"author_04-1-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:21:"et-pb-post-main-image";a:4:{s:4:"file";s:23:"author_04-1-400x250.jpg";s:5:"width";i:400;s:6:"height";i:250;s:9:"mime-type";s:10:"image/jpeg";}s:31:"et-pb-post-main-image-fullwidth";a:4:{s:4:"file";s:23:"author_04-1-600x675.jpg";s:5:"width";i:600;s:6:"height";i:675;s:9:"mime-type";s:10:"image/jpeg";}s:21:"et-pb-portfolio-image";a:4:{s:4:"file";s:23:"author_04-1-400x284.jpg";s:5:"width";i:400;s:6:"height";i:284;s:9:"mime-type";s:10:"image/jpeg";}s:28:"et-pb-portfolio-module-image";a:4:{s:4:"file";s:23:"author_04-1-510x382.jpg";s:5:"width";i:510;s:6:"height";i:382;s:9:"mime-type";s:10:"image/jpeg";}s:35:"et-pb-gallery-module-image-portrait";a:4:{s:4:"file";s:23:"author_04-1-400x516.jpg";s:5:"width";i:400;s:6:"height";i:516;s:9:"mime-type";s:10:"image/jpeg";}s:30:"et-pb-image--responsive--phone";a:4:{s:4:"file";s:23:"author_04-1-480x680.jpg";s:5:"width";i:480;s:6:"height";i:680;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}s:10:"ShortPixel";a:8:{s:4:"type";s:6:"glossy";s:8:"exifKept";s:1:"0";s:4:"date";s:19:"2020-10-20 19:04:28";s:9:"thumbsOpt";i:8;s:13:"thumbsOptList";a:8:{i:0;s:23:"author_04-1-212x300.jpg";i:1;s:23:"author_04-1-150x150.jpg";i:2;s:23:"author_04-1-400x250.jpg";i:3;s:23:"author_04-1-600x675.jpg";i:4;s:23:"author_04-1-400x284.jpg";i:5;s:23:"author_04-1-510x382.jpg";i:6;s:23:"author_04-1-400x516.jpg";i:7;s:23:"author_04-1-480x680.jpg";}s:12:"excludeSizes";a:0:{}s:10:"retinasOpt";i:0;s:8:"NoBackup";b:1;}s:21:"ShortPixelImprovement";s:5:"12.02";}');
INSERT INTO `wp5_postmeta` VALUES (304,28232,'_wp_attached_file','2020/10/author_05-1.jpg');
INSERT INTO `wp5_postmeta` VALUES (305,28232,'_wp_attachment_metadata','a:7:{s:5:"width";i:600;s:6:"height";i:850;s:4:"file";s:23:"2020/10/author_05-1.jpg";s:5:"sizes";a:8:{s:6:"medium";a:4:{s:4:"file";s:23:"author_05-1-212x300.jpg";s:5:"width";i:212;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";}s:9:"thumbnail";a:4:{s:4:"file";s:23:"author_05-1-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:21:"et-pb-post-main-image";a:4:{s:4:"file";s:23:"author_05-1-400x250.jpg";s:5:"width";i:400;s:6:"height";i:250;s:9:"mime-type";s:10:"image/jpeg";}s:31:"et-pb-post-main-image-fullwidth";a:4:{s:4:"file";s:23:"author_05-1-600x675.jpg";s:5:"width";i:600;s:6:"height";i:675;s:9:"mime-type";s:10:"image/jpeg";}s:21:"et-pb-portfolio-image";a:4:{s:4:"file";s:23:"author_05-1-400x284.jpg";s:5:"width";i:400;s:6:"height";i:284;s:9:"mime-type";s:10:"image/jpeg";}s:28:"et-pb-portfolio-module-image";a:4:{s:4:"file";s:23:"author_05-1-510x382.jpg";s:5:"width";i:510;s:6:"height";i:382;s:9:"mime-type";s:10:"image/jpeg";}s:35:"et-pb-gallery-module-image-portrait";a:4:{s:4:"file";s:23:"author_05-1-400x516.jpg";s:5:"width";i:400;s:6:"height";i:516;s:9:"mime-type";s:10:"image/jpeg";}s:30:"et-pb-image--responsive--phone";a:4:{s:4:"file";s:23:"author_05-1-480x680.jpg";s:5:"width";i:480;s:6:"height";i:680;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}s:10:"ShortPixel";a:8:{s:4:"type";s:6:"glossy";s:8:"exifKept";s:1:"0";s:4:"date";s:19:"2020-10-20 19:04:13";s:9:"thumbsOpt";i:8;s:13:"thumbsOptList";a:8:{i:0;s:23:"author_05-1-212x300.jpg";i:1;s:23:"author_05-1-150x150.jpg";i:2;s:23:"author_05-1-400x250.jpg";i:3;s:23:"author_05-1-600x675.jpg";i:4;s:23:"author_05-1-400x284.jpg";i:5;s:23:"author_05-1-510x382.jpg";i:6;s:23:"author_05-1-400x516.jpg";i:7;s:23:"author_05-1-480x680.jpg";}s:12:"excludeSizes";a:0:{}s:10:"retinasOpt";i:0;s:8:"NoBackup";b:1;}s:21:"ShortPixelImprovement";s:5:"18.37";}');
INSERT INTO `wp5_postmeta` VALUES (306,28233,'_wp_attached_file','2020/10/paper.jpg');
INSERT INTO `wp5_postmeta` VALUES (307,28233,'_wp_attachment_metadata','a:7:{s:5:"width";i:1920;s:6:"height";i:1000;s:4:"file";s:17:"2020/10/paper.jpg";s:5:"sizes";a:14:{s:6:"medium";a:4:{s:4:"file";s:17:"paper-300x156.jpg";s:5:"width";i:300;s:6:"height";i:156;s:9:"mime-type";s:10:"image/jpeg";}s:5:"large";a:4:{s:4:"file";s:18:"paper-1024x533.jpg";s:5:"width";i:1024;s:6:"height";i:533;s:9:"mime-type";s:10:"image/jpeg";}s:9:"thumbnail";a:4:{s:4:"file";s:17:"paper-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:12:"medium_large";a:4:{s:4:"file";s:17:"paper-768x400.jpg";s:5:"width";i:768;s:6:"height";i:400;s:9:"mime-type";s:10:"image/jpeg";}s:9:"1536x1536";a:4:{s:4:"file";s:18:"paper-1536x800.jpg";s:5:"width";i:1536;s:6:"height";i:800;s:9:"mime-type";s:10:"image/jpeg";}s:21:"et-pb-post-main-image";a:4:{s:4:"file";s:17:"paper-400x250.jpg";s:5:"width";i:400;s:6:"height";i:250;s:9:"mime-type";s:10:"image/jpeg";}s:31:"et-pb-post-main-image-fullwidth";a:4:{s:4:"file";s:18:"paper-1080x675.jpg";s:5:"width";i:1080;s:6:"height";i:675;s:9:"mime-type";s:10:"image/jpeg";}s:21:"et-pb-portfolio-image";a:4:{s:4:"file";s:17:"paper-400x284.jpg";s:5:"width";i:400;s:6:"height";i:284;s:9:"mime-type";s:10:"image/jpeg";}s:28:"et-pb-portfolio-module-image";a:4:{s:4:"file";s:17:"paper-510x382.jpg";s:5:"width";i:510;s:6:"height";i:382;s:9:"mime-type";s:10:"image/jpeg";}s:28:"et-pb-portfolio-image-single";a:4:{s:4:"file";s:18:"paper-1080x563.jpg";s:5:"width";i:1080;s:6:"height";i:563;s:9:"mime-type";s:10:"image/jpeg";}s:35:"et-pb-gallery-module-image-portrait";a:4:{s:4:"file";s:17:"paper-400x516.jpg";s:5:"width";i:400;s:6:"height";i:516;s:9:"mime-type";s:10:"image/jpeg";}s:32:"et-pb-image--responsive--desktop";a:4:{s:4:"file";s:18:"paper-1280x667.jpg";s:5:"width";i:1280;s:6:"height";i:667;s:9:"mime-type";s:10:"image/jpeg";}s:31:"et-pb-image--responsive--tablet";a:4:{s:4:"file";s:17:"paper-980x510.jpg";s:5:"width";i:980;s:6:"height";i:510;s:9:"mime-type";s:10:"image/jpeg";}s:30:"et-pb-image--responsive--phone";a:4:{s:4:"file";s:17:"paper-480x250.jpg";s:5:"width";i:480;s:6:"height";i:250;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}s:10:"ShortPixel";a:8:{s:4:"type";s:6:"glossy";s:8:"exifKept";s:1:"0";s:4:"date";s:19:"2020-10-20 19:03:57";s:9:"thumbsOpt";i:14;s:13:"thumbsOptList";a:14:{i:0;s:17:"paper-300x156.jpg";i:1;s:18:"paper-1024x533.jpg";i:2;s:17:"paper-150x150.jpg";i:3;s:17:"paper-768x400.jpg";i:4;s:18:"paper-1536x800.jpg";i:5;s:17:"paper-400x250.jpg";i:6;s:18:"paper-1080x675.jpg";i:7;s:17:"paper-400x284.jpg";i:8;s:17:"paper-510x382.jpg";i:9;s:18:"paper-1080x563.jpg";i:10;s:17:"paper-400x516.jpg";i:11;s:18:"paper-1280x667.jpg";i:12;s:17:"paper-980x510.jpg";i:13;s:17:"paper-480x250.jpg";}s:12:"excludeSizes";a:0:{}s:10:"retinasOpt";i:0;s:8:"NoBackup";b:1;}s:21:"ShortPixelImprovement";s:5:"38.32";}');
INSERT INTO `wp5_postmeta` VALUES (709,28205,'_shortpixel_status','2.1000');
INSERT INTO `wp5_postmeta` VALUES (1053,203938,'_edit_lock','1603382075:1');
INSERT INTO `wp5_postmeta` VALUES (316,28238,'_wp_attached_file','2020/10/logo-001-1.png');
INSERT INTO `wp5_postmeta` VALUES (317,28238,'_wp_attachment_metadata','a:7:{s:5:"width";i:500;s:6:"height";i:125;s:4:"file";s:22:"2020/10/logo-001-1.png";s:5:"sizes";a:6:{s:6:"medium";a:4:{s:4:"file";s:21:"logo-001-1-300x75.png";s:5:"width";i:300;s:6:"height";i:75;s:9:"mime-type";s:9:"image/png";}s:9:"thumbnail";a:4:{s:4:"file";s:22:"logo-001-1-150x125.png";s:5:"width";i:150;s:6:"height";i:125;s:9:"mime-type";s:9:"image/png";}s:21:"et-pb-post-main-image";a:4:{s:4:"file";s:22:"logo-001-1-400x125.png";s:5:"width";i:400;s:6:"height";i:125;s:9:"mime-type";s:9:"image/png";}s:21:"et-pb-portfolio-image";a:4:{s:4:"file";s:22:"logo-001-1-400x125.png";s:5:"width";i:400;s:6:"height";i:125;s:9:"mime-type";s:9:"image/png";}s:35:"et-pb-gallery-module-image-portrait";a:4:{s:4:"file";s:22:"logo-001-1-400x125.png";s:5:"width";i:400;s:6:"height";i:125;s:9:"mime-type";s:9:"image/png";}s:30:"et-pb-image--responsive--phone";a:4:{s:4:"file";s:22:"logo-001-1-480x120.png";s:5:"width";i:480;s:6:"height";i:120;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}s:10:"ShortPixel";a:8:{s:4:"type";s:6:"glossy";s:8:"exifKept";s:1:"0";s:4:"date";s:19:"2020-10-20 19:02:55";s:9:"thumbsOpt";i:4;s:13:"thumbsOptList";a:4:{i:0;s:21:"logo-001-1-300x75.png";i:1;s:22:"logo-001-1-150x125.png";i:2;s:22:"logo-001-1-400x125.png";i:3;s:22:"logo-001-1-480x120.png";}s:12:"excludeSizes";a:0:{}s:10:"retinasOpt";i:0;s:8:"NoBackup";b:1;}s:21:"ShortPixelImprovement";s:5:"63.48";}');
INSERT INTO `wp5_postmeta` VALUES (318,28239,'_wp_attached_file','2020/10/logo-002-1.png');
INSERT INTO `wp5_postmeta` VALUES (319,28239,'_wp_attachment_metadata','a:7:{s:5:"width";i:500;s:6:"height";i:125;s:4:"file";s:22:"2020/10/logo-002-1.png";s:5:"sizes";a:6:{s:6:"medium";a:4:{s:4:"file";s:21:"logo-002-1-300x75.png";s:5:"width";i:300;s:6:"height";i:75;s:9:"mime-type";s:9:"image/png";}s:9:"thumbnail";a:4:{s:4:"file";s:22:"logo-002-1-150x125.png";s:5:"width";i:150;s:6:"height";i:125;s:9:"mime-type";s:9:"image/png";}s:21:"et-pb-post-main-image";a:4:{s:4:"file";s:22:"logo-002-1-400x125.png";s:5:"width";i:400;s:6:"height";i:125;s:9:"mime-type";s:9:"image/png";}s:21:"et-pb-portfolio-image";a:4:{s:4:"file";s:22:"logo-002-1-400x125.png";s:5:"width";i:400;s:6:"height";i:125;s:9:"mime-type";s:9:"image/png";}s:35:"et-pb-gallery-module-image-portrait";a:4:{s:4:"file";s:22:"logo-002-1-400x125.png";s:5:"width";i:400;s:6:"height";i:125;s:9:"mime-type";s:9:"image/png";}s:30:"et-pb-image--responsive--phone";a:4:{s:4:"file";s:22:"logo-002-1-480x120.png";s:5:"width";i:480;s:6:"height";i:120;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}s:10:"ShortPixel";a:8:{s:4:"type";s:6:"glossy";s:8:"exifKept";s:1:"0";s:4:"date";s:19:"2020-10-20 19:02:43";s:9:"thumbsOpt";i:4;s:13:"thumbsOptList";a:4:{i:0;s:21:"logo-002-1-300x75.png";i:1;s:22:"logo-002-1-150x125.png";i:2;s:22:"logo-002-1-400x125.png";i:3;s:22:"logo-002-1-480x120.png";}s:12:"excludeSizes";a:0:{}s:10:"retinasOpt";i:0;s:8:"NoBackup";b:1;}s:21:"ShortPixelImprovement";s:5:"49.44";}');
INSERT INTO `wp5_postmeta` VALUES (320,28240,'_wp_attached_file','2020/10/logo-004-1.png');
INSERT INTO `wp5_postmeta` VALUES (321,28240,'_wp_attachment_metadata','a:7:{s:5:"width";i:500;s:6:"height";i:125;s:4:"file";s:22:"2020/10/logo-004-1.png";s:5:"sizes";a:6:{s:6:"medium";a:4:{s:4:"file";s:21:"logo-004-1-300x75.png";s:5:"width";i:300;s:6:"height";i:75;s:9:"mime-type";s:9:"image/png";}s:9:"thumbnail";a:4:{s:4:"file";s:22:"logo-004-1-150x125.png";s:5:"width";i:150;s:6:"height";i:125;s:9:"mime-type";s:9:"image/png";}s:21:"et-pb-post-main-image";a:4:{s:4:"file";s:22:"logo-004-1-400x125.png";s:5:"width";i:400;s:6:"height";i:125;s:9:"mime-type";s:9:"image/png";}s:21:"et-pb-portfolio-image";a:4:{s:4:"file";s:22:"logo-004-1-400x125.png";s:5:"width";i:400;s:6:"height";i:125;s:9:"mime-type";s:9:"image/png";}s:35:"et-pb-gallery-module-image-portrait";a:4:{s:4:"file";s:22:"logo-004-1-400x125.png";s:5:"width";i:400;s:6:"height";i:125;s:9:"mime-type";s:9:"image/png";}s:30:"et-pb-image--responsive--phone";a:4:{s:4:"file";s:22:"logo-004-1-480x120.png";s:5:"width";i:480;s:6:"height";i:120;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}s:10:"ShortPixel";a:8:{s:4:"type";s:6:"glossy";s:8:"exifKept";s:1:"0";s:4:"date";s:19:"2020-10-20 19:02:31";s:9:"thumbsOpt";i:4;s:13:"thumbsOptList";a:4:{i:0;s:21:"logo-004-1-300x75.png";i:1;s:22:"logo-004-1-150x125.png";i:2;s:22:"logo-004-1-400x125.png";i:3;s:22:"logo-004-1-480x120.png";}s:12:"excludeSizes";a:0:{}s:10:"retinasOpt";i:0;s:8:"NoBackup";b:1;}s:21:"ShortPixelImprovement";s:5:"64.41";}');
INSERT INTO `wp5_postmeta` VALUES (711,28159,'_shortpixel_status','2.5800');
INSERT INTO `wp5_postmeta` VALUES (1271,204371,'_et_pb_built_for_post_type','page');
INSERT INTO `wp5_postmeta` VALUES (871,204256,'_shortpixel_status','2.3800');
INSERT INTO `wp5_postmeta` VALUES (872,204260,'_edit_last','3');
INSERT INTO `wp5_postmeta` VALUES (873,204260,'_edit_lock','1693165814:3');
INSERT INTO `wp5_postmeta` VALUES (874,204260,'_wp_page_template','default');
INSERT INTO `wp5_postmeta` VALUES (875,204260,'_et_pb_post_hide_nav','default');
INSERT INTO `wp5_postmeta` VALUES (876,204260,'_et_pb_page_layout','et_right_sidebar');
INSERT INTO `wp5_postmeta` VALUES (877,204260,'_et_pb_side_nav','off');
INSERT INTO `wp5_postmeta` VALUES (878,204260,'_et_pb_use_builder','on');
INSERT INTO `wp5_postmeta` VALUES (879,204260,'_et_pb_first_image','');
INSERT INTO `wp5_postmeta` VALUES (880,204260,'_et_pb_truncate_post','');
INSERT INTO `wp5_postmeta` VALUES (881,204260,'_et_pb_truncate_post_date','');
INSERT INTO `wp5_postmeta` VALUES (882,204260,'_et_pb_old_content','');
INSERT INTO `wp5_postmeta` VALUES (1779,204839,'_wp_old_date','2021-02-24');
INSERT INTO `wp5_postmeta` VALUES (866,204256,'_wp_attached_file','2020/10/Page-Header-2560-x-1024-2.jpg');
INSERT INTO `wp5_postmeta` VALUES (867,204256,'_wp_attachment_metadata','a:7:{s:5:"width";i:2560;s:6:"height";i:1024;s:4:"file";s:37:"2020/10/Page-Header-2560-x-1024-2.jpg";s:5:"sizes";a:15:{s:6:"medium";a:4:{s:4:"file";s:37:"Page-Header-2560-x-1024-2-300x120.jpg";s:5:"width";i:300;s:6:"height";i:120;s:9:"mime-type";s:10:"image/jpeg";}s:5:"large";a:4:{s:4:"file";s:38:"Page-Header-2560-x-1024-2-1024x410.jpg";s:5:"width";i:1024;s:6:"height";i:410;s:9:"mime-type";s:10:"image/jpeg";}s:9:"thumbnail";a:4:{s:4:"file";s:37:"Page-Header-2560-x-1024-2-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:12:"medium_large";a:4:{s:4:"file";s:37:"Page-Header-2560-x-1024-2-768x307.jpg";s:5:"width";i:768;s:6:"height";i:307;s:9:"mime-type";s:10:"image/jpeg";}s:9:"1536x1536";a:4:{s:4:"file";s:38:"Page-Header-2560-x-1024-2-1536x614.jpg";s:5:"width";i:1536;s:6:"height";i:614;s:9:"mime-type";s:10:"image/jpeg";}s:9:"2048x2048";a:4:{s:4:"file";s:38:"Page-Header-2560-x-1024-2-2048x819.jpg";s:5:"width";i:2048;s:6:"height";i:819;s:9:"mime-type";s:10:"image/jpeg";}s:21:"et-pb-post-main-image";a:4:{s:4:"file";s:37:"Page-Header-2560-x-1024-2-400x250.jpg";s:5:"width";i:400;s:6:"height";i:250;s:9:"mime-type";s:10:"image/jpeg";}s:31:"et-pb-post-main-image-fullwidth";a:4:{s:4:"file";s:38:"Page-Header-2560-x-1024-2-1080x675.jpg";s:5:"width";i:1080;s:6:"height";i:675;s:9:"mime-type";s:10:"image/jpeg";}s:21:"et-pb-portfolio-image";a:4:{s:4:"file";s:37:"Page-Header-2560-x-1024-2-400x284.jpg";s:5:"width";i:400;s:6:"height";i:284;s:9:"mime-type";s:10:"image/jpeg";}s:28:"et-pb-portfolio-module-image";a:4:{s:4:"file";s:37:"Page-Header-2560-x-1024-2-510x382.jpg";s:5:"width";i:510;s:6:"height";i:382;s:9:"mime-type";s:10:"image/jpeg";}s:28:"et-pb-portfolio-image-single";a:4:{s:4:"file";s:38:"Page-Header-2560-x-1024-2-1080x432.jpg";s:5:"width";i:1080;s:6:"height";i:432;s:9:"mime-type";s:10:"image/jpeg";}s:35:"et-pb-gallery-module-image-portrait";a:4:{s:4:"file";s:37:"Page-Header-2560-x-1024-2-400x516.jpg";s:5:"width";i:400;s:6:"height";i:516;s:9:"mime-type";s:10:"image/jpeg";}s:32:"et-pb-image--responsive--desktop";a:4:{s:4:"file";s:38:"Page-Header-2560-x-1024-2-1280x512.jpg";s:5:"width";i:1280;s:6:"height";i:512;s:9:"mime-type";s:10:"image/jpeg";}s:31:"et-pb-image--responsive--tablet";a:4:{s:4:"file";s:37:"Page-Header-2560-x-1024-2-980x392.jpg";s:5:"width";i:980;s:6:"height";i:392;s:9:"mime-type";s:10:"image/jpeg";}s:30:"et-pb-image--responsive--phone";a:4:{s:4:"file";s:37:"Page-Header-2560-x-1024-2-480x192.jpg";s:5:"width";i:480;s:6:"height";i:192;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"1";s:8:"keywords";a:0:{}}s:10:"ShortPixel";a:8:{s:4:"type";s:6:"glossy";s:8:"exifKept";s:1:"0";s:4:"date";s:19:"2020-10-22 15:06:38";s:9:"thumbsOpt";i:15;s:13:"thumbsOptList";a:15:{i:0;s:37:"Page-Header-2560-x-1024-2-300x120.jpg";i:1;s:38:"Page-Header-2560-x-1024-2-1024x410.jpg";i:2;s:37:"Page-Header-2560-x-1024-2-150x150.jpg";i:3;s:37:"Page-Header-2560-x-1024-2-768x307.jpg";i:4;s:38:"Page-Header-2560-x-1024-2-1536x614.jpg";i:5;s:38:"Page-Header-2560-x-1024-2-2048x819.jpg";i:6;s:37:"Page-Header-2560-x-1024-2-400x250.jpg";i:7;s:38:"Page-Header-2560-x-1024-2-1080x675.jpg";i:8;s:37:"Page-Header-2560-x-1024-2-400x284.jpg";i:9;s:37:"Page-Header-2560-x-1024-2-510x382.jpg";i:10;s:38:"Page-Header-2560-x-1024-2-1080x432.jpg";i:11;s:37:"Page-Header-2560-x-1024-2-400x516.jpg";i:12;s:38:"Page-Header-2560-x-1024-2-1280x512.jpg";i:13;s:37:"Page-Header-2560-x-1024-2-980x392.jpg";i:14;s:37:"Page-Header-2560-x-1024-2-480x192.jpg";}s:12:"excludeSizes";a:0:{}s:10:"retinasOpt";i:0;s:8:"NoBackup";b:1;}s:21:"ShortPixelImprovement";s:5:"38.18";}');
INSERT INTO `wp5_postmeta` VALUES (334,28247,'_wp_attached_file','2020/10/auteursfotoo.jpg');
INSERT INTO `wp5_postmeta` VALUES (335,28247,'_wp_attachment_metadata','a:7:{s:5:"width";i:1600;s:6:"height";i:1067;s:4:"file";s:24:"2020/10/auteursfotoo.jpg";s:5:"sizes";a:14:{s:6:"medium";a:4:{s:4:"file";s:24:"auteursfotoo-300x200.jpg";s:5:"width";i:300;s:6:"height";i:200;s:9:"mime-type";s:10:"image/jpeg";}s:5:"large";a:4:{s:4:"file";s:25:"auteursfotoo-1024x683.jpg";s:5:"width";i:1024;s:6:"height";i:683;s:9:"mime-type";s:10:"image/jpeg";}s:9:"thumbnail";a:4:{s:4:"file";s:24:"auteursfotoo-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:12:"medium_large";a:4:{s:4:"file";s:24:"auteursfotoo-768x512.jpg";s:5:"width";i:768;s:6:"height";i:512;s:9:"mime-type";s:10:"image/jpeg";}s:9:"1536x1536";a:4:{s:4:"file";s:26:"auteursfotoo-1536x1024.jpg";s:5:"width";i:1536;s:6:"height";i:1024;s:9:"mime-type";s:10:"image/jpeg";}s:21:"et-pb-post-main-image";a:4:{s:4:"file";s:24:"auteursfotoo-400x250.jpg";s:5:"width";i:400;s:6:"height";i:250;s:9:"mime-type";s:10:"image/jpeg";}s:31:"et-pb-post-main-image-fullwidth";a:4:{s:4:"file";s:25:"auteursfotoo-1080x675.jpg";s:5:"width";i:1080;s:6:"height";i:675;s:9:"mime-type";s:10:"image/jpeg";}s:21:"et-pb-portfolio-image";a:4:{s:4:"file";s:24:"auteursfotoo-400x284.jpg";s:5:"width";i:400;s:6:"height";i:284;s:9:"mime-type";s:10:"image/jpeg";}s:28:"et-pb-portfolio-module-image";a:4:{s:4:"file";s:24:"auteursfotoo-510x382.jpg";s:5:"width";i:510;s:6:"height";i:382;s:9:"mime-type";s:10:"image/jpeg";}s:28:"et-pb-portfolio-image-single";a:4:{s:4:"file";s:25:"auteursfotoo-1080x720.jpg";s:5:"width";i:1080;s:6:"height";i:720;s:9:"mime-type";s:10:"image/jpeg";}s:35:"et-pb-gallery-module-image-portrait";a:4:{s:4:"file";s:24:"auteursfotoo-400x516.jpg";s:5:"width";i:400;s:6:"height";i:516;s:9:"mime-type";s:10:"image/jpeg";}s:32:"et-pb-image--responsive--desktop";a:4:{s:4:"file";s:25:"auteursfotoo-1280x854.jpg";s:5:"width";i:1280;s:6:"height";i:854;s:9:"mime-type";s:10:"image/jpeg";}s:31:"et-pb-image--responsive--tablet";a:4:{s:4:"file";s:24:"auteursfotoo-980x654.jpg";s:5:"width";i:980;s:6:"height";i:654;s:9:"mime-type";s:10:"image/jpeg";}s:30:"et-pb-image--responsive--phone";a:4:{s:4:"file";s:24:"auteursfotoo-480x320.jpg";s:5:"width";i:480;s:6:"height";i:320;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}s:10:"ShortPixel";a:8:{s:4:"type";s:6:"glossy";s:8:"exifKept";s:1:"0";s:4:"date";s:19:"2020-10-20 19:01:03";s:9:"thumbsOpt";i:14;s:13:"thumbsOptList";a:14:{i:0;s:24:"auteursfotoo-300x200.jpg";i:1;s:25:"auteursfotoo-1024x683.jpg";i:2;s:24:"auteursfotoo-150x150.jpg";i:3;s:24:"auteursfotoo-768x512.jpg";i:4;s:26:"auteursfotoo-1536x1024.jpg";i:5;s:24:"auteursfotoo-400x250.jpg";i:6;s:25:"auteursfotoo-1080x675.jpg";i:7;s:24:"auteursfotoo-400x284.jpg";i:8;s:24:"auteursfotoo-510x382.jpg";i:9;s:25:"auteursfotoo-1080x720.jpg";i:10;s:24:"auteursfotoo-400x516.jpg";i:11;s:25:"auteursfotoo-1280x854.jpg";i:12;s:24:"auteursfotoo-980x654.jpg";i:13;s:24:"auteursfotoo-480x320.jpg";}s:12:"excludeSizes";a:0:{}s:10:"retinasOpt";i:0;s:8:"NoBackup";b:1;}s:21:"ShortPixelImprovement";s:5:"13.83";}');
INSERT INTO `wp5_postmeta` VALUES (336,28248,'_wp_attached_file','2020/10/authorrr.jpg');
INSERT INTO `wp5_postmeta` VALUES (337,28248,'_wp_attachment_metadata','a:7:{s:5:"width";i:1600;s:6:"height";i:1067;s:4:"file";s:20:"2020/10/authorrr.jpg";s:5:"sizes";a:14:{s:6:"medium";a:4:{s:4:"file";s:20:"authorrr-300x200.jpg";s:5:"width";i:300;s:6:"height";i:200;s:9:"mime-type";s:10:"image/jpeg";}s:5:"large";a:4:{s:4:"file";s:21:"authorrr-1024x683.jpg";s:5:"width";i:1024;s:6:"height";i:683;s:9:"mime-type";s:10:"image/jpeg";}s:9:"thumbnail";a:4:{s:4:"file";s:20:"authorrr-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:12:"medium_large";a:4:{s:4:"file";s:20:"authorrr-768x512.jpg";s:5:"width";i:768;s:6:"height";i:512;s:9:"mime-type";s:10:"image/jpeg";}s:9:"1536x1536";a:4:{s:4:"file";s:22:"authorrr-1536x1024.jpg";s:5:"width";i:1536;s:6:"height";i:1024;s:9:"mime-type";s:10:"image/jpeg";}s:21:"et-pb-post-main-image";a:4:{s:4:"file";s:20:"authorrr-400x250.jpg";s:5:"width";i:400;s:6:"height";i:250;s:9:"mime-type";s:10:"image/jpeg";}s:31:"et-pb-post-main-image-fullwidth";a:4:{s:4:"file";s:21:"authorrr-1080x675.jpg";s:5:"width";i:1080;s:6:"height";i:675;s:9:"mime-type";s:10:"image/jpeg";}s:21:"et-pb-portfolio-image";a:4:{s:4:"file";s:20:"authorrr-400x284.jpg";s:5:"width";i:400;s:6:"height";i:284;s:9:"mime-type";s:10:"image/jpeg";}s:28:"et-pb-portfolio-module-image";a:4:{s:4:"file";s:20:"authorrr-510x382.jpg";s:5:"width";i:510;s:6:"height";i:382;s:9:"mime-type";s:10:"image/jpeg";}s:28:"et-pb-portfolio-image-single";a:4:{s:4:"file";s:21:"authorrr-1080x720.jpg";s:5:"width";i:1080;s:6:"height";i:720;s:9:"mime-type";s:10:"image/jpeg";}s:35:"et-pb-gallery-module-image-portrait";a:4:{s:4:"file";s:20:"authorrr-400x516.jpg";s:5:"width";i:400;s:6:"height";i:516;s:9:"mime-type";s:10:"image/jpeg";}s:32:"et-pb-image--responsive--desktop";a:4:{s:4:"file";s:21:"authorrr-1280x854.jpg";s:5:"width";i:1280;s:6:"height";i:854;s:9:"mime-type";s:10:"image/jpeg";}s:31:"et-pb-image--responsive--tablet";a:4:{s:4:"file";s:20:"authorrr-980x654.jpg";s:5:"width";i:980;s:6:"height";i:654;s:9:"mime-type";s:10:"image/jpeg";}s:30:"et-pb-image--responsive--phone";a:4:{s:4:"file";s:20:"authorrr-480x320.jpg";s:5:"width";i:480;s:6:"height";i:320;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}s:10:"ShortPixel";a:8:{s:4:"type";s:6:"glossy";s:8:"exifKept";s:1:"0";s:4:"date";s:19:"2020-10-20 19:00:44";s:9:"thumbsOpt";i:14;s:13:"thumbsOptList";a:14:{i:0;s:20:"authorrr-300x200.jpg";i:1;s:21:"authorrr-1024x683.jpg";i:2;s:20:"authorrr-150x150.jpg";i:3;s:20:"authorrr-768x512.jpg";i:4;s:22:"authorrr-1536x1024.jpg";i:5;s:20:"authorrr-400x250.jpg";i:6;s:21:"authorrr-1080x675.jpg";i:7;s:20:"authorrr-400x284.jpg";i:8;s:20:"authorrr-510x382.jpg";i:9;s:21:"authorrr-1080x720.jpg";i:10;s:20:"authorrr-400x516.jpg";i:11;s:21:"authorrr-1280x854.jpg";i:12;s:20:"authorrr-980x654.jpg";i:13;s:20:"authorrr-480x320.jpg";}s:12:"excludeSizes";a:0:{}s:10:"retinasOpt";i:0;s:8:"NoBackup";b:1;}s:21:"ShortPixelImprovement";s:4:"6.81";}');
INSERT INTO `wp5_postmeta` VALUES (338,28249,'_wp_attached_file','2020/10/heyy.jpg');
INSERT INTO `wp5_postmeta` VALUES (339,28249,'_wp_attachment_metadata','a:7:{s:5:"width";i:1067;s:6:"height";i:1600;s:4:"file";s:16:"2020/10/heyy.jpg";s:5:"sizes";a:12:{s:6:"medium";a:4:{s:4:"file";s:16:"heyy-200x300.jpg";s:5:"width";i:200;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";}s:5:"large";a:4:{s:4:"file";s:17:"heyy-683x1024.jpg";s:5:"width";i:683;s:6:"height";i:1024;s:9:"mime-type";s:10:"image/jpeg";}s:9:"thumbnail";a:4:{s:4:"file";s:16:"heyy-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:12:"medium_large";a:4:{s:4:"file";s:17:"heyy-768x1152.jpg";s:5:"width";i:768;s:6:"height";i:1152;s:9:"mime-type";s:10:"image/jpeg";}s:9:"1536x1536";a:4:{s:4:"file";s:18:"heyy-1024x1536.jpg";s:5:"width";i:1024;s:6:"height";i:1536;s:9:"mime-type";s:10:"image/jpeg";}s:21:"et-pb-post-main-image";a:4:{s:4:"file";s:16:"heyy-400x250.jpg";s:5:"width";i:400;s:6:"height";i:250;s:9:"mime-type";s:10:"image/jpeg";}s:31:"et-pb-post-main-image-fullwidth";a:4:{s:4:"file";s:17:"heyy-1067x675.jpg";s:5:"width";i:1067;s:6:"height";i:675;s:9:"mime-type";s:10:"image/jpeg";}s:21:"et-pb-portfolio-image";a:4:{s:4:"file";s:16:"heyy-400x284.jpg";s:5:"width";i:400;s:6:"height";i:284;s:9:"mime-type";s:10:"image/jpeg";}s:28:"et-pb-portfolio-module-image";a:4:{s:4:"file";s:16:"heyy-510x382.jpg";s:5:"width";i:510;s:6:"height";i:382;s:9:"mime-type";s:10:"image/jpeg";}s:35:"et-pb-gallery-module-image-portrait";a:4:{s:4:"file";s:16:"heyy-400x516.jpg";s:5:"width";i:400;s:6:"height";i:516;s:9:"mime-type";s:10:"image/jpeg";}s:31:"et-pb-image--responsive--tablet";a:4:{s:4:"file";s:17:"heyy-980x1470.jpg";s:5:"width";i:980;s:6:"height";i:1470;s:9:"mime-type";s:10:"image/jpeg";}s:30:"et-pb-image--responsive--phone";a:4:{s:4:"file";s:16:"heyy-480x720.jpg";s:5:"width";i:480;s:6:"height";i:720;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}s:10:"ShortPixel";a:8:{s:4:"type";s:6:"glossy";s:8:"exifKept";s:1:"0";s:4:"date";s:19:"2020-10-20 19:00:24";s:9:"thumbsOpt";i:12;s:13:"thumbsOptList";a:12:{i:0;s:16:"heyy-200x300.jpg";i:1;s:17:"heyy-683x1024.jpg";i:2;s:16:"heyy-150x150.jpg";i:3;s:17:"heyy-768x1152.jpg";i:4;s:18:"heyy-1024x1536.jpg";i:5;s:16:"heyy-400x250.jpg";i:6;s:17:"heyy-1067x675.jpg";i:7;s:16:"heyy-400x284.jpg";i:8;s:16:"heyy-510x382.jpg";i:9;s:16:"heyy-400x516.jpg";i:10;s:17:"heyy-980x1470.jpg";i:11;s:16:"heyy-480x720.jpg";}s:12:"excludeSizes";a:0:{}s:10:"retinasOpt";i:0;s:8:"NoBackup";b:1;}s:21:"ShortPixelImprovement";s:5:"18.77";}');
INSERT INTO `wp5_postmeta` VALUES (921,204271,'_shortpixel_status','2.5400');
INSERT INTO `wp5_postmeta` VALUES (342,28251,'_wp_attached_file','2020/10/ZZZZZZbook.jpg');
INSERT INTO `wp5_postmeta` VALUES (343,28251,'_wp_attachment_metadata','a:7:{s:5:"width";i:377;s:6:"height";i:500;s:4:"file";s:22:"2020/10/ZZZZZZbook.jpg";s:5:"sizes";a:5:{s:6:"medium";a:4:{s:4:"file";s:22:"ZZZZZZbook-226x300.jpg";s:5:"width";i:226;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";}s:9:"thumbnail";a:4:{s:4:"file";s:22:"ZZZZZZbook-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:21:"et-pb-post-main-image";a:4:{s:4:"file";s:22:"ZZZZZZbook-377x250.jpg";s:5:"width";i:377;s:6:"height";i:250;s:9:"mime-type";s:10:"image/jpeg";}s:21:"et-pb-portfolio-image";a:4:{s:4:"file";s:22:"ZZZZZZbook-377x284.jpg";s:5:"width";i:377;s:6:"height";i:284;s:9:"mime-type";s:10:"image/jpeg";}s:28:"et-pb-portfolio-module-image";a:4:{s:4:"file";s:22:"ZZZZZZbook-377x382.jpg";s:5:"width";i:377;s:6:"height";i:382;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}s:10:"ShortPixel";a:8:{s:4:"type";s:6:"glossy";s:8:"exifKept";s:1:"0";s:4:"date";s:19:"2020-10-20 18:59:40";s:9:"thumbsOpt";i:5;s:13:"thumbsOptList";a:5:{i:0;s:22:"ZZZZZZbook-226x300.jpg";i:1;s:22:"ZZZZZZbook-150x150.jpg";i:2;s:22:"ZZZZZZbook-377x250.jpg";i:3;s:22:"ZZZZZZbook-377x284.jpg";i:4;s:22:"ZZZZZZbook-377x382.jpg";}s:12:"excludeSizes";a:0:{}s:10:"retinasOpt";i:0;s:8:"NoBackup";b:1;}s:21:"ShortPixelImprovement";s:4:"8.14";}');
INSERT INTO `wp5_postmeta` VALUES (344,204072,'_et_pb_built_for_post_type','page');
INSERT INTO `wp5_postmeta` VALUES (1690,204805,'_wp_attached_file','2021/02/apple-books-store-button.png');
INSERT INTO `wp5_postmeta` VALUES (1666,204781,'_name','Gary Petty');
INSERT INTO `wp5_postmeta` VALUES (348,28047,'_et_pb_built_for_post_type','page');
INSERT INTO `wp5_postmeta` VALUES (349,203951,'_et_pb_built_for_post_type','page');
INSERT INTO `wp5_postmeta` VALUES (352,235,'_et_pb_built_for_post_type','page');
INSERT INTO `wp5_postmeta` VALUES (354,220,'_et_pb_built_for_post_type','page');
INSERT INTO `wp5_postmeta` VALUES (359,316,'_et_pb_built_for_post_type','page');
INSERT INTO `wp5_postmeta` VALUES (362,141,'_et_pb_built_for_post_type','page');
INSERT INTO `wp5_postmeta` VALUES (364,203977,'_et_pb_built_for_post_type','page');
INSERT INTO `wp5_postmeta` VALUES (365,203978,'_et_pb_built_for_post_type','page');
INSERT INTO `wp5_postmeta` VALUES (379,27888,'_et_pb_built_for_post_type','page');
INSERT INTO `wp5_postmeta` VALUES (383,203940,'_et_pb_built_for_post_type','page');
INSERT INTO `wp5_postmeta` VALUES (385,203938,'_et_pb_built_for_post_type','page');
INSERT INTO `wp5_postmeta` VALUES (397,203944,'_et_pb_built_for_post_type','page');
INSERT INTO `wp5_postmeta` VALUES (398,203944,'_et_pb_use_builder','on');
INSERT INTO `wp5_postmeta` VALUES (1115,203944,'_et_pb_ab_current_shortcode','[et_pb_split_track id="203944" /]');
INSERT INTO `wp5_postmeta` VALUES (1114,203944,'_et_pb_ab_subjects','');
INSERT INTO `wp5_postmeta` VALUES (401,203944,'_et_pb_old_content','');
INSERT INTO `wp5_postmeta` VALUES (402,203944,'_et_pb_enable_shortcode_tracking','');
INSERT INTO `wp5_postmeta` VALUES (403,203944,'_et_pb_custom_css','');
INSERT INTO `wp5_postmeta` VALUES (1120,203944,'_et_pb_truncate_post_date','');
INSERT INTO `wp5_postmeta` VALUES (1119,203944,'_et_pb_truncate_post','');
INSERT INTO `wp5_postmeta` VALUES (1118,203944,'_et_pb_first_image','');
INSERT INTO `wp5_postmeta` VALUES (1677,204274,'_global_colors_info','{}');
INSERT INTO `wp5_postmeta` VALUES (1680,28166,'_global_colors_info','{}');
INSERT INTO `wp5_postmeta` VALUES (415,204084,'_wp_attached_file','2020/10/Author-Photo.jpg');
INSERT INTO `wp5_postmeta` VALUES (416,204084,'_wp_attachment_metadata','a:7:{s:5:"width";i:1500;s:6:"height";i:1500;s:4:"file";s:24:"2020/10/Author-Photo.jpg";s:5:"sizes";a:13:{s:6:"medium";a:4:{s:4:"file";s:24:"Author-Photo-300x300.jpg";s:5:"width";i:300;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";}s:5:"large";a:4:{s:4:"file";s:26:"Author-Photo-1024x1024.jpg";s:5:"width";i:1024;s:6:"height";i:1024;s:9:"mime-type";s:10:"image/jpeg";}s:9:"thumbnail";a:4:{s:4:"file";s:24:"Author-Photo-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:12:"medium_large";a:4:{s:4:"file";s:24:"Author-Photo-768x768.jpg";s:5:"width";i:768;s:6:"height";i:768;s:9:"mime-type";s:10:"image/jpeg";}s:21:"et-pb-post-main-image";a:4:{s:4:"file";s:24:"Author-Photo-400x250.jpg";s:5:"width";i:400;s:6:"height";i:250;s:9:"mime-type";s:10:"image/jpeg";}s:31:"et-pb-post-main-image-fullwidth";a:4:{s:4:"file";s:25:"Author-Photo-1080x675.jpg";s:5:"width";i:1080;s:6:"height";i:675;s:9:"mime-type";s:10:"image/jpeg";}s:21:"et-pb-portfolio-image";a:4:{s:4:"file";s:24:"Author-Photo-400x284.jpg";s:5:"width";i:400;s:6:"height";i:284;s:9:"mime-type";s:10:"image/jpeg";}s:28:"et-pb-portfolio-module-image";a:4:{s:4:"file";s:24:"Author-Photo-510x382.jpg";s:5:"width";i:510;s:6:"height";i:382;s:9:"mime-type";s:10:"image/jpeg";}s:28:"et-pb-portfolio-image-single";a:4:{s:4:"file";s:26:"Author-Photo-1080x1080.jpg";s:5:"width";i:1080;s:6:"height";i:1080;s:9:"mime-type";s:10:"image/jpeg";}s:35:"et-pb-gallery-module-image-portrait";a:4:{s:4:"file";s:24:"Author-Photo-400x516.jpg";s:5:"width";i:400;s:6:"height";i:516;s:9:"mime-type";s:10:"image/jpeg";}s:32:"et-pb-image--responsive--desktop";a:4:{s:4:"file";s:26:"Author-Photo-1280x1280.jpg";s:5:"width";i:1280;s:6:"height";i:1280;s:9:"mime-type";s:10:"image/jpeg";}s:31:"et-pb-image--responsive--tablet";a:4:{s:4:"file";s:24:"Author-Photo-980x980.jpg";s:5:"width";i:980;s:6:"height";i:980;s:9:"mime-type";s:10:"image/jpeg";}s:30:"et-pb-image--responsive--phone";a:4:{s:4:"file";s:24:"Author-Photo-480x480.jpg";s:5:"width";i:480;s:6:"height";i:480;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"1";s:8:"keywords";a:0:{}}s:10:"ShortPixel";a:8:{s:4:"type";s:6:"glossy";s:8:"exifKept";s:1:"0";s:4:"date";s:19:"2020-10-20 18:59:25";s:9:"thumbsOpt";i:13;s:13:"thumbsOptList";a:13:{i:0;s:24:"Author-Photo-300x300.jpg";i:1;s:26:"Author-Photo-1024x1024.jpg";i:2;s:24:"Author-Photo-150x150.jpg";i:3;s:24:"Author-Photo-768x768.jpg";i:4;s:24:"Author-Photo-400x250.jpg";i:5;s:25:"Author-Photo-1080x675.jpg";i:6;s:24:"Author-Photo-400x284.jpg";i:7;s:24:"Author-Photo-510x382.jpg";i:8;s:26:"Author-Photo-1080x1080.jpg";i:9;s:24:"Author-Photo-400x516.jpg";i:10;s:26:"Author-Photo-1280x1280.jpg";i:11;s:24:"Author-Photo-980x980.jpg";i:12;s:24:"Author-Photo-480x480.jpg";}s:12:"excludeSizes";a:0:{}s:10:"retinasOpt";i:0;s:8:"NoBackup";b:1;}s:21:"ShortPixelImprovement";s:5:"45.79";}');
INSERT INTO `wp5_postmeta` VALUES (417,204085,'_wp_attached_file','2020/10/Author-Signature.jpg');
INSERT INTO `wp5_postmeta` VALUES (418,204085,'_wp_attachment_metadata','a:7:{s:5:"width";i:2000;s:6:"height";i:200;s:4:"file";s:28:"2020/10/Author-Signature.jpg";s:5:"sizes";a:14:{s:6:"medium";a:4:{s:4:"file";s:27:"Author-Signature-300x30.jpg";s:5:"width";i:300;s:6:"height";i:30;s:9:"mime-type";s:10:"image/jpeg";}s:5:"large";a:4:{s:4:"file";s:29:"Author-Signature-1024x102.jpg";s:5:"width";i:1024;s:6:"height";i:102;s:9:"mime-type";s:10:"image/jpeg";}s:9:"thumbnail";a:4:{s:4:"file";s:28:"Author-Signature-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:12:"medium_large";a:4:{s:4:"file";s:27:"Author-Signature-768x77.jpg";s:5:"width";i:768;s:6:"height";i:77;s:9:"mime-type";s:10:"image/jpeg";}s:9:"1536x1536";a:4:{s:4:"file";s:29:"Author-Signature-1536x154.jpg";s:5:"width";i:1536;s:6:"height";i:154;s:9:"mime-type";s:10:"image/jpeg";}s:21:"et-pb-post-main-image";a:4:{s:4:"file";s:28:"Author-Signature-400x200.jpg";s:5:"width";i:400;s:6:"height";i:200;s:9:"mime-type";s:10:"image/jpeg";}s:31:"et-pb-post-main-image-fullwidth";a:4:{s:4:"file";s:29:"Author-Signature-1080x200.jpg";s:5:"width";i:1080;s:6:"height";i:200;s:9:"mime-type";s:10:"image/jpeg";}s:21:"et-pb-portfolio-image";a:4:{s:4:"file";s:28:"Author-Signature-400x200.jpg";s:5:"width";i:400;s:6:"height";i:200;s:9:"mime-type";s:10:"image/jpeg";}s:28:"et-pb-portfolio-module-image";a:4:{s:4:"file";s:28:"Author-Signature-510x200.jpg";s:5:"width";i:510;s:6:"height";i:200;s:9:"mime-type";s:10:"image/jpeg";}s:28:"et-pb-portfolio-image-single";a:4:{s:4:"file";s:29:"Author-Signature-1080x108.jpg";s:5:"width";i:1080;s:6:"height";i:108;s:9:"mime-type";s:10:"image/jpeg";}s:35:"et-pb-gallery-module-image-portrait";a:4:{s:4:"file";s:28:"Author-Signature-400x200.jpg";s:5:"width";i:400;s:6:"height";i:200;s:9:"mime-type";s:10:"image/jpeg";}s:32:"et-pb-image--responsive--desktop";a:4:{s:4:"file";s:29:"Author-Signature-1280x128.jpg";s:5:"width";i:1280;s:6:"height";i:128;s:9:"mime-type";s:10:"image/jpeg";}s:31:"et-pb-image--responsive--tablet";a:4:{s:4:"file";s:27:"Author-Signature-980x98.jpg";s:5:"width";i:980;s:6:"height";i:98;s:9:"mime-type";s:10:"image/jpeg";}s:30:"et-pb-image--responsive--phone";a:4:{s:4:"file";s:27:"Author-Signature-480x48.jpg";s:5:"width";i:480;s:6:"height";i:48;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"1";s:8:"keywords";a:0:{}}s:10:"ShortPixel";a:8:{s:4:"type";s:6:"glossy";s:8:"exifKept";s:1:"0";s:4:"date";s:19:"2020-10-20 18:59:07";s:9:"thumbsOpt";i:12;s:13:"thumbsOptList";a:12:{i:0;s:27:"Author-Signature-300x30.jpg";i:1;s:29:"Author-Signature-1024x102.jpg";i:2;s:28:"Author-Signature-150x150.jpg";i:3;s:27:"Author-Signature-768x77.jpg";i:4;s:29:"Author-Signature-1536x154.jpg";i:5;s:28:"Author-Signature-400x200.jpg";i:6;s:29:"Author-Signature-1080x200.jpg";i:7;s:28:"Author-Signature-510x200.jpg";i:8;s:29:"Author-Signature-1080x108.jpg";i:9;s:29:"Author-Signature-1280x128.jpg";i:10;s:27:"Author-Signature-980x98.jpg";i:11;s:27:"Author-Signature-480x48.jpg";}s:12:"excludeSizes";a:0:{}s:10:"retinasOpt";i:0;s:8:"NoBackup";b:1;}s:21:"ShortPixelImprovement";s:5:"29.85";}');
INSERT INTO `wp5_postmeta` VALUES (419,204086,'_wp_attached_file','2020/10/kobo-logo.png');
INSERT INTO `wp5_postmeta` VALUES (420,204086,'_wp_attachment_metadata','a:7:{s:5:"width";i:320;s:6:"height";i:86;s:4:"file";s:21:"2020/10/kobo-logo.png";s:5:"sizes";a:2:{s:6:"medium";a:4:{s:4:"file";s:20:"kobo-logo-300x81.png";s:5:"width";i:300;s:6:"height";i:81;s:9:"mime-type";s:9:"image/png";}s:9:"thumbnail";a:4:{s:4:"file";s:20:"kobo-logo-150x86.png";s:5:"width";i:150;s:6:"height";i:86;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}s:10:"ShortPixel";a:8:{s:4:"type";s:6:"glossy";s:8:"exifKept";s:1:"0";s:4:"date";s:19:"2020-10-20 18:58:50";s:9:"thumbsOpt";i:2;s:13:"thumbsOptList";a:2:{i:0;s:20:"kobo-logo-300x81.png";i:1;s:20:"kobo-logo-150x86.png";}s:12:"excludeSizes";a:0:{}s:10:"retinasOpt";i:0;s:8:"NoBackup";b:1;}s:21:"ShortPixelImprovement";s:5:"62.26";}');
INSERT INTO `wp5_postmeta` VALUES (422,28200,'_edit_lock','1603204210:1');
INSERT INTO `wp5_postmeta` VALUES (423,204091,'_wp_attached_file','2020/10/StockSnap_75TIS9MIMF-scaled.jpg');
INSERT INTO `wp5_postmeta` VALUES (424,204091,'_wp_attachment_metadata','a:8:{s:5:"width";i:2560;s:6:"height";i:1707;s:4:"file";s:39:"2020/10/StockSnap_75TIS9MIMF-scaled.jpg";s:5:"sizes";a:16:{s:6:"medium";a:4:{s:4:"file";s:32:"StockSnap_75TIS9MIMF-300x200.jpg";s:5:"width";i:300;s:6:"height";i:200;s:9:"mime-type";s:10:"image/jpeg";}s:5:"large";a:4:{s:4:"file";s:33:"StockSnap_75TIS9MIMF-1024x683.jpg";s:5:"width";i:1024;s:6:"height";i:683;s:9:"mime-type";s:10:"image/jpeg";}s:9:"thumbnail";a:4:{s:4:"file";s:32:"StockSnap_75TIS9MIMF-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:12:"medium_large";a:4:{s:4:"file";s:32:"StockSnap_75TIS9MIMF-768x512.jpg";s:5:"width";i:768;s:6:"height";i:512;s:9:"mime-type";s:10:"image/jpeg";}s:9:"1536x1536";a:4:{s:4:"file";s:34:"StockSnap_75TIS9MIMF-1536x1024.jpg";s:5:"width";i:1536;s:6:"height";i:1024;s:9:"mime-type";s:10:"image/jpeg";}s:9:"2048x2048";a:4:{s:4:"file";s:34:"StockSnap_75TIS9MIMF-2048x1366.jpg";s:5:"width";i:2048;s:6:"height";i:1366;s:9:"mime-type";s:10:"image/jpeg";}s:21:"et-pb-post-main-image";a:4:{s:4:"file";s:32:"StockSnap_75TIS9MIMF-400x250.jpg";s:5:"width";i:400;s:6:"height";i:250;s:9:"mime-type";s:10:"image/jpeg";}s:31:"et-pb-post-main-image-fullwidth";a:4:{s:4:"file";s:33:"StockSnap_75TIS9MIMF-1080x675.jpg";s:5:"width";i:1080;s:6:"height";i:675;s:9:"mime-type";s:10:"image/jpeg";}s:21:"et-pb-portfolio-image";a:4:{s:4:"file";s:32:"StockSnap_75TIS9MIMF-400x284.jpg";s:5:"width";i:400;s:6:"height";i:284;s:9:"mime-type";s:10:"image/jpeg";}s:28:"et-pb-portfolio-module-image";a:4:{s:4:"file";s:32:"StockSnap_75TIS9MIMF-510x382.jpg";s:5:"width";i:510;s:6:"height";i:382;s:9:"mime-type";s:10:"image/jpeg";}s:28:"et-pb-portfolio-image-single";a:4:{s:4:"file";s:33:"StockSnap_75TIS9MIMF-1080x720.jpg";s:5:"width";i:1080;s:6:"height";i:720;s:9:"mime-type";s:10:"image/jpeg";}s:35:"et-pb-gallery-module-image-portrait";a:4:{s:4:"file";s:32:"StockSnap_75TIS9MIMF-400x516.jpg";s:5:"width";i:400;s:6:"height";i:516;s:9:"mime-type";s:10:"image/jpeg";}s:37:"et-pb-post-main-image-fullwidth-large";a:4:{s:4:"file";s:34:"StockSnap_75TIS9MIMF-2880x1800.jpg";s:5:"width";i:2880;s:6:"height";i:1800;s:9:"mime-type";s:10:"image/jpeg";}s:32:"et-pb-image--responsive--desktop";a:4:{s:4:"file";s:33:"StockSnap_75TIS9MIMF-1280x854.jpg";s:5:"width";i:1280;s:6:"height";i:854;s:9:"mime-type";s:10:"image/jpeg";}s:31:"et-pb-image--responsive--tablet";a:4:{s:4:"file";s:32:"StockSnap_75TIS9MIMF-980x653.jpg";s:5:"width";i:980;s:6:"height";i:653;s:9:"mime-type";s:10:"image/jpeg";}s:30:"et-pb-image--responsive--phone";a:4:{s:4:"file";s:32:"StockSnap_75TIS9MIMF-480x320.jpg";s:5:"width";i:480;s:6:"height";i:320;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}s:14:"original_image";s:24:"StockSnap_75TIS9MIMF.jpg";s:10:"ShortPixel";a:8:{s:4:"type";s:6:"glossy";s:8:"exifKept";s:1:"0";s:4:"date";s:19:"2020-10-20 18:58:36";s:9:"thumbsOpt";i:17;s:13:"thumbsOptList";a:17:{i:0;s:24:"StockSnap_75TIS9MIMF.jpg";i:1;s:32:"StockSnap_75TIS9MIMF-300x200.jpg";i:2;s:33:"StockSnap_75TIS9MIMF-1024x683.jpg";i:3;s:32:"StockSnap_75TIS9MIMF-150x150.jpg";i:4;s:32:"StockSnap_75TIS9MIMF-768x512.jpg";i:5;s:34:"StockSnap_75TIS9MIMF-1536x1024.jpg";i:6;s:34:"StockSnap_75TIS9MIMF-2048x1366.jpg";i:7;s:32:"StockSnap_75TIS9MIMF-400x250.jpg";i:8;s:33:"StockSnap_75TIS9MIMF-1080x675.jpg";i:9;s:32:"StockSnap_75TIS9MIMF-400x284.jpg";i:10;s:32:"StockSnap_75TIS9MIMF-510x382.jpg";i:11;s:33:"StockSnap_75TIS9MIMF-1080x720.jpg";i:12;s:32:"StockSnap_75TIS9MIMF-400x516.jpg";i:13;s:34:"StockSnap_75TIS9MIMF-2880x1800.jpg";i:14;s:33:"StockSnap_75TIS9MIMF-1280x854.jpg";i:15;s:32:"StockSnap_75TIS9MIMF-980x653.jpg";i:16;s:32:"StockSnap_75TIS9MIMF-480x320.jpg";}s:12:"excludeSizes";a:0:{}s:10:"retinasOpt";i:0;s:8:"NoBackup";b:1;}s:21:"ShortPixelImprovement";s:5:"74.68";}');
INSERT INTO `wp5_postmeta` VALUES (425,204092,'_wp_attached_file','2020/10/StockSnap_RFPRHTKURW-scaled.jpg');
INSERT INTO `wp5_postmeta` VALUES (426,204092,'_wp_attachment_metadata','a:8:{s:5:"width";i:2560;s:6:"height";i:1511;s:4:"file";s:39:"2020/10/StockSnap_RFPRHTKURW-scaled.jpg";s:5:"sizes";a:16:{s:6:"medium";a:4:{s:4:"file";s:32:"StockSnap_RFPRHTKURW-300x177.jpg";s:5:"width";i:300;s:6:"height";i:177;s:9:"mime-type";s:10:"image/jpeg";}s:5:"large";a:4:{s:4:"file";s:33:"StockSnap_RFPRHTKURW-1024x604.jpg";s:5:"width";i:1024;s:6:"height";i:604;s:9:"mime-type";s:10:"image/jpeg";}s:9:"thumbnail";a:4:{s:4:"file";s:32:"StockSnap_RFPRHTKURW-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:12:"medium_large";a:4:{s:4:"file";s:32:"StockSnap_RFPRHTKURW-768x453.jpg";s:5:"width";i:768;s:6:"height";i:453;s:9:"mime-type";s:10:"image/jpeg";}s:9:"1536x1536";a:4:{s:4:"file";s:33:"StockSnap_RFPRHTKURW-1536x906.jpg";s:5:"width";i:1536;s:6:"height";i:906;s:9:"mime-type";s:10:"image/jpeg";}s:9:"2048x2048";a:4:{s:4:"file";s:34:"StockSnap_RFPRHTKURW-2048x1208.jpg";s:5:"width";i:2048;s:6:"height";i:1208;s:9:"mime-type";s:10:"image/jpeg";}s:21:"et-pb-post-main-image";a:4:{s:4:"file";s:32:"StockSnap_RFPRHTKURW-400x250.jpg";s:5:"width";i:400;s:6:"height";i:250;s:9:"mime-type";s:10:"image/jpeg";}s:31:"et-pb-post-main-image-fullwidth";a:4:{s:4:"file";s:33:"StockSnap_RFPRHTKURW-1080x675.jpg";s:5:"width";i:1080;s:6:"height";i:675;s:9:"mime-type";s:10:"image/jpeg";}s:21:"et-pb-portfolio-image";a:4:{s:4:"file";s:32:"StockSnap_RFPRHTKURW-400x284.jpg";s:5:"width";i:400;s:6:"height";i:284;s:9:"mime-type";s:10:"image/jpeg";}s:28:"et-pb-portfolio-module-image";a:4:{s:4:"file";s:32:"StockSnap_RFPRHTKURW-510x382.jpg";s:5:"width";i:510;s:6:"height";i:382;s:9:"mime-type";s:10:"image/jpeg";}s:28:"et-pb-portfolio-image-single";a:4:{s:4:"file";s:33:"StockSnap_RFPRHTKURW-1080x637.jpg";s:5:"width";i:1080;s:6:"height";i:637;s:9:"mime-type";s:10:"image/jpeg";}s:35:"et-pb-gallery-module-image-portrait";a:4:{s:4:"file";s:32:"StockSnap_RFPRHTKURW-400x516.jpg";s:5:"width";i:400;s:6:"height";i:516;s:9:"mime-type";s:10:"image/jpeg";}s:37:"et-pb-post-main-image-fullwidth-large";a:4:{s:4:"file";s:34:"StockSnap_RFPRHTKURW-2880x1800.jpg";s:5:"width";i:2880;s:6:"height";i:1800;s:9:"mime-type";s:10:"image/jpeg";}s:32:"et-pb-image--responsive--desktop";a:4:{s:4:"file";s:33:"StockSnap_RFPRHTKURW-1280x756.jpg";s:5:"width";i:1280;s:6:"height";i:756;s:9:"mime-type";s:10:"image/jpeg";}s:31:"et-pb-image--responsive--tablet";a:4:{s:4:"file";s:32:"StockSnap_RFPRHTKURW-980x578.jpg";s:5:"width";i:980;s:6:"height";i:578;s:9:"mime-type";s:10:"image/jpeg";}s:30:"et-pb-image--responsive--phone";a:4:{s:4:"file";s:32:"StockSnap_RFPRHTKURW-480x283.jpg";s:5:"width";i:480;s:6:"height";i:283;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}s:14:"original_image";s:24:"StockSnap_RFPRHTKURW.jpg";s:10:"ShortPixel";a:8:{s:4:"type";s:6:"glossy";s:8:"exifKept";s:1:"0";s:4:"date";s:19:"2020-10-20 18:58:06";s:9:"thumbsOpt";i:17;s:13:"thumbsOptList";a:17:{i:0;s:24:"StockSnap_RFPRHTKURW.jpg";i:1;s:32:"StockSnap_RFPRHTKURW-300x177.jpg";i:2;s:33:"StockSnap_RFPRHTKURW-1024x604.jpg";i:3;s:32:"StockSnap_RFPRHTKURW-150x150.jpg";i:4;s:32:"StockSnap_RFPRHTKURW-768x453.jpg";i:5;s:33:"StockSnap_RFPRHTKURW-1536x906.jpg";i:6;s:34:"StockSnap_RFPRHTKURW-2048x1208.jpg";i:7;s:32:"StockSnap_RFPRHTKURW-400x250.jpg";i:8;s:33:"StockSnap_RFPRHTKURW-1080x675.jpg";i:9;s:32:"StockSnap_RFPRHTKURW-400x284.jpg";i:10;s:32:"StockSnap_RFPRHTKURW-510x382.jpg";i:11;s:33:"StockSnap_RFPRHTKURW-1080x637.jpg";i:12;s:32:"StockSnap_RFPRHTKURW-400x516.jpg";i:13;s:34:"StockSnap_RFPRHTKURW-2880x1800.jpg";i:14;s:33:"StockSnap_RFPRHTKURW-1280x756.jpg";i:15;s:32:"StockSnap_RFPRHTKURW-980x578.jpg";i:16;s:32:"StockSnap_RFPRHTKURW-480x283.jpg";}s:12:"excludeSizes";a:0:{}s:10:"retinasOpt";i:0;s:8:"NoBackup";b:1;}s:21:"ShortPixelImprovement";s:5:"54.69";}');
INSERT INTO `wp5_postmeta` VALUES (427,204093,'_wp_attached_file','2020/10/StockSnap_IUJWYVKFMQ-scaled.jpg');
INSERT INTO `wp5_postmeta` VALUES (428,204093,'_wp_attachment_metadata','a:8:{s:5:"width";i:2560;s:6:"height";i:1700;s:4:"file";s:39:"2020/10/StockSnap_IUJWYVKFMQ-scaled.jpg";s:5:"sizes";a:16:{s:6:"medium";a:4:{s:4:"file";s:32:"StockSnap_IUJWYVKFMQ-300x199.jpg";s:5:"width";i:300;s:6:"height";i:199;s:9:"mime-type";s:10:"image/jpeg";}s:5:"large";a:4:{s:4:"file";s:33:"StockSnap_IUJWYVKFMQ-1024x680.jpg";s:5:"width";i:1024;s:6:"height";i:680;s:9:"mime-type";s:10:"image/jpeg";}s:9:"thumbnail";a:4:{s:4:"file";s:32:"StockSnap_IUJWYVKFMQ-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:12:"medium_large";a:4:{s:4:"file";s:32:"StockSnap_IUJWYVKFMQ-768x510.jpg";s:5:"width";i:768;s:6:"height";i:510;s:9:"mime-type";s:10:"image/jpeg";}s:9:"1536x1536";a:4:{s:4:"file";s:34:"StockSnap_IUJWYVKFMQ-1536x1020.jpg";s:5:"width";i:1536;s:6:"height";i:1020;s:9:"mime-type";s:10:"image/jpeg";}s:9:"2048x2048";a:4:{s:4:"file";s:34:"StockSnap_IUJWYVKFMQ-2048x1360.jpg";s:5:"width";i:2048;s:6:"height";i:1360;s:9:"mime-type";s:10:"image/jpeg";}s:21:"et-pb-post-main-image";a:4:{s:4:"file";s:32:"StockSnap_IUJWYVKFMQ-400x250.jpg";s:5:"width";i:400;s:6:"height";i:250;s:9:"mime-type";s:10:"image/jpeg";}s:31:"et-pb-post-main-image-fullwidth";a:4:{s:4:"file";s:33:"StockSnap_IUJWYVKFMQ-1080x675.jpg";s:5:"width";i:1080;s:6:"height";i:675;s:9:"mime-type";s:10:"image/jpeg";}s:21:"et-pb-portfolio-image";a:4:{s:4:"file";s:32:"StockSnap_IUJWYVKFMQ-400x284.jpg";s:5:"width";i:400;s:6:"height";i:284;s:9:"mime-type";s:10:"image/jpeg";}s:28:"et-pb-portfolio-module-image";a:4:{s:4:"file";s:32:"StockSnap_IUJWYVKFMQ-510x382.jpg";s:5:"width";i:510;s:6:"height";i:382;s:9:"mime-type";s:10:"image/jpeg";}s:28:"et-pb-portfolio-image-single";a:4:{s:4:"file";s:33:"StockSnap_IUJWYVKFMQ-1080x717.jpg";s:5:"width";i:1080;s:6:"height";i:717;s:9:"mime-type";s:10:"image/jpeg";}s:35:"et-pb-gallery-module-image-portrait";a:4:{s:4:"file";s:32:"StockSnap_IUJWYVKFMQ-400x516.jpg";s:5:"width";i:400;s:6:"height";i:516;s:9:"mime-type";s:10:"image/jpeg";}s:37:"et-pb-post-main-image-fullwidth-large";a:4:{s:4:"file";s:34:"StockSnap_IUJWYVKFMQ-2880x1800.jpg";s:5:"width";i:2880;s:6:"height";i:1800;s:9:"mime-type";s:10:"image/jpeg";}s:32:"et-pb-image--responsive--desktop";a:4:{s:4:"file";s:33:"StockSnap_IUJWYVKFMQ-1280x850.jpg";s:5:"width";i:1280;s:6:"height";i:850;s:9:"mime-type";s:10:"image/jpeg";}s:31:"et-pb-image--responsive--tablet";a:4:{s:4:"file";s:32:"StockSnap_IUJWYVKFMQ-980x651.jpg";s:5:"width";i:980;s:6:"height";i:651;s:9:"mime-type";s:10:"image/jpeg";}s:30:"et-pb-image--responsive--phone";a:4:{s:4:"file";s:32:"StockSnap_IUJWYVKFMQ-480x319.jpg";s:5:"width";i:480;s:6:"height";i:319;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}s:14:"original_image";s:24:"StockSnap_IUJWYVKFMQ.jpg";s:10:"ShortPixel";a:8:{s:4:"type";s:6:"glossy";s:8:"exifKept";s:1:"0";s:4:"date";s:19:"2020-10-20 18:57:36";s:9:"thumbsOpt";i:17;s:13:"thumbsOptList";a:17:{i:0;s:24:"StockSnap_IUJWYVKFMQ.jpg";i:1;s:32:"StockSnap_IUJWYVKFMQ-300x199.jpg";i:2;s:33:"StockSnap_IUJWYVKFMQ-1024x680.jpg";i:3;s:32:"StockSnap_IUJWYVKFMQ-150x150.jpg";i:4;s:32:"StockSnap_IUJWYVKFMQ-768x510.jpg";i:5;s:34:"StockSnap_IUJWYVKFMQ-1536x1020.jpg";i:6;s:34:"StockSnap_IUJWYVKFMQ-2048x1360.jpg";i:7;s:32:"StockSnap_IUJWYVKFMQ-400x250.jpg";i:8;s:33:"StockSnap_IUJWYVKFMQ-1080x675.jpg";i:9;s:32:"StockSnap_IUJWYVKFMQ-400x284.jpg";i:10;s:32:"StockSnap_IUJWYVKFMQ-510x382.jpg";i:11;s:33:"StockSnap_IUJWYVKFMQ-1080x717.jpg";i:12;s:32:"StockSnap_IUJWYVKFMQ-400x516.jpg";i:13;s:34:"StockSnap_IUJWYVKFMQ-2880x1800.jpg";i:14;s:33:"StockSnap_IUJWYVKFMQ-1280x850.jpg";i:15;s:32:"StockSnap_IUJWYVKFMQ-980x651.jpg";i:16;s:32:"StockSnap_IUJWYVKFMQ-480x319.jpg";}s:12:"excludeSizes";a:0:{}s:10:"retinasOpt";i:0;s:8:"NoBackup";b:1;}s:21:"ShortPixelImprovement";s:5:"70.07";}');
INSERT INTO `wp5_postmeta` VALUES (429,204094,'_wp_attached_file','2020/10/StockSnap_NN7QYFUPXT-scaled.jpg');
INSERT INTO `wp5_postmeta` VALUES (430,204094,'_wp_attachment_metadata','a:8:{s:5:"width";i:2560;s:6:"height";i:1707;s:4:"file";s:39:"2020/10/StockSnap_NN7QYFUPXT-scaled.jpg";s:5:"sizes";a:16:{s:6:"medium";a:4:{s:4:"file";s:32:"StockSnap_NN7QYFUPXT-300x200.jpg";s:5:"width";i:300;s:6:"height";i:200;s:9:"mime-type";s:10:"image/jpeg";}s:5:"large";a:4:{s:4:"file";s:33:"StockSnap_NN7QYFUPXT-1024x683.jpg";s:5:"width";i:1024;s:6:"height";i:683;s:9:"mime-type";s:10:"image/jpeg";}s:9:"thumbnail";a:4:{s:4:"file";s:32:"StockSnap_NN7QYFUPXT-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:12:"medium_large";a:4:{s:4:"file";s:32:"StockSnap_NN7QYFUPXT-768x512.jpg";s:5:"width";i:768;s:6:"height";i:512;s:9:"mime-type";s:10:"image/jpeg";}s:9:"1536x1536";a:4:{s:4:"file";s:34:"StockSnap_NN7QYFUPXT-1536x1024.jpg";s:5:"width";i:1536;s:6:"height";i:1024;s:9:"mime-type";s:10:"image/jpeg";}s:9:"2048x2048";a:4:{s:4:"file";s:34:"StockSnap_NN7QYFUPXT-2048x1365.jpg";s:5:"width";i:2048;s:6:"height";i:1365;s:9:"mime-type";s:10:"image/jpeg";}s:21:"et-pb-post-main-image";a:4:{s:4:"file";s:32:"StockSnap_NN7QYFUPXT-400x250.jpg";s:5:"width";i:400;s:6:"height";i:250;s:9:"mime-type";s:10:"image/jpeg";}s:31:"et-pb-post-main-image-fullwidth";a:4:{s:4:"file";s:33:"StockSnap_NN7QYFUPXT-1080x675.jpg";s:5:"width";i:1080;s:6:"height";i:675;s:9:"mime-type";s:10:"image/jpeg";}s:21:"et-pb-portfolio-image";a:4:{s:4:"file";s:32:"StockSnap_NN7QYFUPXT-400x284.jpg";s:5:"width";i:400;s:6:"height";i:284;s:9:"mime-type";s:10:"image/jpeg";}s:28:"et-pb-portfolio-module-image";a:4:{s:4:"file";s:32:"StockSnap_NN7QYFUPXT-510x382.jpg";s:5:"width";i:510;s:6:"height";i:382;s:9:"mime-type";s:10:"image/jpeg";}s:28:"et-pb-portfolio-image-single";a:4:{s:4:"file";s:33:"StockSnap_NN7QYFUPXT-1080x720.jpg";s:5:"width";i:1080;s:6:"height";i:720;s:9:"mime-type";s:10:"image/jpeg";}s:35:"et-pb-gallery-module-image-portrait";a:4:{s:4:"file";s:32:"StockSnap_NN7QYFUPXT-400x516.jpg";s:5:"width";i:400;s:6:"height";i:516;s:9:"mime-type";s:10:"image/jpeg";}s:37:"et-pb-post-main-image-fullwidth-large";a:4:{s:4:"file";s:34:"StockSnap_NN7QYFUPXT-2880x1800.jpg";s:5:"width";i:2880;s:6:"height";i:1800;s:9:"mime-type";s:10:"image/jpeg";}s:32:"et-pb-image--responsive--desktop";a:4:{s:4:"file";s:33:"StockSnap_NN7QYFUPXT-1280x854.jpg";s:5:"width";i:1280;s:6:"height";i:854;s:9:"mime-type";s:10:"image/jpeg";}s:31:"et-pb-image--responsive--tablet";a:4:{s:4:"file";s:32:"StockSnap_NN7QYFUPXT-980x653.jpg";s:5:"width";i:980;s:6:"height";i:653;s:9:"mime-type";s:10:"image/jpeg";}s:30:"et-pb-image--responsive--phone";a:4:{s:4:"file";s:32:"StockSnap_NN7QYFUPXT-480x320.jpg";s:5:"width";i:480;s:6:"height";i:320;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}s:14:"original_image";s:24:"StockSnap_NN7QYFUPXT.jpg";s:10:"ShortPixel";a:8:{s:4:"type";s:6:"glossy";s:8:"exifKept";s:1:"0";s:4:"date";s:19:"2020-10-20 18:56:59";s:9:"thumbsOpt";i:17;s:13:"thumbsOptList";a:17:{i:0;s:24:"StockSnap_NN7QYFUPXT.jpg";i:1;s:32:"StockSnap_NN7QYFUPXT-300x200.jpg";i:2;s:33:"StockSnap_NN7QYFUPXT-1024x683.jpg";i:3;s:32:"StockSnap_NN7QYFUPXT-150x150.jpg";i:4;s:32:"StockSnap_NN7QYFUPXT-768x512.jpg";i:5;s:34:"StockSnap_NN7QYFUPXT-1536x1024.jpg";i:6;s:34:"StockSnap_NN7QYFUPXT-2048x1365.jpg";i:7;s:32:"StockSnap_NN7QYFUPXT-400x250.jpg";i:8;s:33:"StockSnap_NN7QYFUPXT-1080x675.jpg";i:9;s:32:"StockSnap_NN7QYFUPXT-400x284.jpg";i:10;s:32:"StockSnap_NN7QYFUPXT-510x382.jpg";i:11;s:33:"StockSnap_NN7QYFUPXT-1080x720.jpg";i:12;s:32:"StockSnap_NN7QYFUPXT-400x516.jpg";i:13;s:34:"StockSnap_NN7QYFUPXT-2880x1800.jpg";i:14;s:33:"StockSnap_NN7QYFUPXT-1280x854.jpg";i:15;s:32:"StockSnap_NN7QYFUPXT-980x653.jpg";i:16;s:32:"StockSnap_NN7QYFUPXT-480x320.jpg";}s:12:"excludeSizes";a:0:{}s:10:"retinasOpt";i:0;s:8:"NoBackup";b:1;}s:21:"ShortPixelImprovement";s:5:"59.01";}');
INSERT INTO `wp5_postmeta` VALUES (431,204095,'_wp_attached_file','2020/10/StockSnap_6TOUOJV8MB-scaled.jpg');
INSERT INTO `wp5_postmeta` VALUES (432,204095,'_wp_attachment_metadata','a:8:{s:5:"width";i:2560;s:6:"height";i:1440;s:4:"file";s:39:"2020/10/StockSnap_6TOUOJV8MB-scaled.jpg";s:5:"sizes";a:16:{s:6:"medium";a:4:{s:4:"file";s:32:"StockSnap_6TOUOJV8MB-300x169.jpg";s:5:"width";i:300;s:6:"height";i:169;s:9:"mime-type";s:10:"image/jpeg";}s:5:"large";a:4:{s:4:"file";s:33:"StockSnap_6TOUOJV8MB-1024x576.jpg";s:5:"width";i:1024;s:6:"height";i:576;s:9:"mime-type";s:10:"image/jpeg";}s:9:"thumbnail";a:4:{s:4:"file";s:32:"StockSnap_6TOUOJV8MB-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:12:"medium_large";a:4:{s:4:"file";s:32:"StockSnap_6TOUOJV8MB-768x432.jpg";s:5:"width";i:768;s:6:"height";i:432;s:9:"mime-type";s:10:"image/jpeg";}s:9:"1536x1536";a:4:{s:4:"file";s:33:"StockSnap_6TOUOJV8MB-1536x864.jpg";s:5:"width";i:1536;s:6:"height";i:864;s:9:"mime-type";s:10:"image/jpeg";}s:9:"2048x2048";a:4:{s:4:"file";s:34:"StockSnap_6TOUOJV8MB-2048x1152.jpg";s:5:"width";i:2048;s:6:"height";i:1152;s:9:"mime-type";s:10:"image/jpeg";}s:21:"et-pb-post-main-image";a:4:{s:4:"file";s:32:"StockSnap_6TOUOJV8MB-400x250.jpg";s:5:"width";i:400;s:6:"height";i:250;s:9:"mime-type";s:10:"image/jpeg";}s:31:"et-pb-post-main-image-fullwidth";a:4:{s:4:"file";s:33:"StockSnap_6TOUOJV8MB-1080x675.jpg";s:5:"width";i:1080;s:6:"height";i:675;s:9:"mime-type";s:10:"image/jpeg";}s:21:"et-pb-portfolio-image";a:4:{s:4:"file";s:32:"StockSnap_6TOUOJV8MB-400x284.jpg";s:5:"width";i:400;s:6:"height";i:284;s:9:"mime-type";s:10:"image/jpeg";}s:28:"et-pb-portfolio-module-image";a:4:{s:4:"file";s:32:"StockSnap_6TOUOJV8MB-510x382.jpg";s:5:"width";i:510;s:6:"height";i:382;s:9:"mime-type";s:10:"image/jpeg";}s:28:"et-pb-portfolio-image-single";a:4:{s:4:"file";s:33:"StockSnap_6TOUOJV8MB-1080x608.jpg";s:5:"width";i:1080;s:6:"height";i:608;s:9:"mime-type";s:10:"image/jpeg";}s:35:"et-pb-gallery-module-image-portrait";a:4:{s:4:"file";s:32:"StockSnap_6TOUOJV8MB-400x516.jpg";s:5:"width";i:400;s:6:"height";i:516;s:9:"mime-type";s:10:"image/jpeg";}s:37:"et-pb-post-main-image-fullwidth-large";a:4:{s:4:"file";s:34:"StockSnap_6TOUOJV8MB-2880x1800.jpg";s:5:"width";i:2880;s:6:"height";i:1800;s:9:"mime-type";s:10:"image/jpeg";}s:32:"et-pb-image--responsive--desktop";a:4:{s:4:"file";s:33:"StockSnap_6TOUOJV8MB-1280x720.jpg";s:5:"width";i:1280;s:6:"height";i:720;s:9:"mime-type";s:10:"image/jpeg";}s:31:"et-pb-image--responsive--tablet";a:4:{s:4:"file";s:32:"StockSnap_6TOUOJV8MB-980x551.jpg";s:5:"width";i:980;s:6:"height";i:551;s:9:"mime-type";s:10:"image/jpeg";}s:30:"et-pb-image--responsive--phone";a:4:{s:4:"file";s:32:"StockSnap_6TOUOJV8MB-480x270.jpg";s:5:"width";i:480;s:6:"height";i:270;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}s:14:"original_image";s:24:"StockSnap_6TOUOJV8MB.jpg";s:10:"ShortPixel";a:8:{s:4:"type";s:6:"glossy";s:8:"exifKept";s:1:"0";s:4:"date";s:19:"2020-10-20 18:56:27";s:9:"thumbsOpt";i:17;s:13:"thumbsOptList";a:17:{i:0;s:24:"StockSnap_6TOUOJV8MB.jpg";i:1;s:32:"StockSnap_6TOUOJV8MB-300x169.jpg";i:2;s:33:"StockSnap_6TOUOJV8MB-1024x576.jpg";i:3;s:32:"StockSnap_6TOUOJV8MB-150x150.jpg";i:4;s:32:"StockSnap_6TOUOJV8MB-768x432.jpg";i:5;s:33:"StockSnap_6TOUOJV8MB-1536x864.jpg";i:6;s:34:"StockSnap_6TOUOJV8MB-2048x1152.jpg";i:7;s:32:"StockSnap_6TOUOJV8MB-400x250.jpg";i:8;s:33:"StockSnap_6TOUOJV8MB-1080x675.jpg";i:9;s:32:"StockSnap_6TOUOJV8MB-400x284.jpg";i:10;s:32:"StockSnap_6TOUOJV8MB-510x382.jpg";i:11;s:33:"StockSnap_6TOUOJV8MB-1080x608.jpg";i:12;s:32:"StockSnap_6TOUOJV8MB-400x516.jpg";i:13;s:34:"StockSnap_6TOUOJV8MB-2880x1800.jpg";i:14;s:33:"StockSnap_6TOUOJV8MB-1280x720.jpg";i:15;s:32:"StockSnap_6TOUOJV8MB-980x551.jpg";i:16;s:32:"StockSnap_6TOUOJV8MB-480x270.jpg";}s:12:"excludeSizes";a:0:{}s:10:"retinasOpt";i:0;s:8:"NoBackup";b:1;}s:21:"ShortPixelImprovement";s:4:"81.5";}');
INSERT INTO `wp5_postmeta` VALUES (433,204096,'_wp_attached_file','2020/10/StockSnap_3Q79ZWSUQS-scaled.jpg');
INSERT INTO `wp5_postmeta` VALUES (434,204096,'_wp_attachment_metadata','a:8:{s:5:"width";i:2560;s:6:"height";i:1706;s:4:"file";s:39:"2020/10/StockSnap_3Q79ZWSUQS-scaled.jpg";s:5:"sizes";a:16:{s:6:"medium";a:4:{s:4:"file";s:32:"StockSnap_3Q79ZWSUQS-300x200.jpg";s:5:"width";i:300;s:6:"height";i:200;s:9:"mime-type";s:10:"image/jpeg";}s:5:"large";a:4:{s:4:"file";s:33:"StockSnap_3Q79ZWSUQS-1024x683.jpg";s:5:"width";i:1024;s:6:"height";i:683;s:9:"mime-type";s:10:"image/jpeg";}s:9:"thumbnail";a:4:{s:4:"file";s:32:"StockSnap_3Q79ZWSUQS-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:12:"medium_large";a:4:{s:4:"file";s:32:"StockSnap_3Q79ZWSUQS-768x512.jpg";s:5:"width";i:768;s:6:"height";i:512;s:9:"mime-type";s:10:"image/jpeg";}s:9:"1536x1536";a:4:{s:4:"file";s:34:"StockSnap_3Q79ZWSUQS-1536x1024.jpg";s:5:"width";i:1536;s:6:"height";i:1024;s:9:"mime-type";s:10:"image/jpeg";}s:9:"2048x2048";a:4:{s:4:"file";s:34:"StockSnap_3Q79ZWSUQS-2048x1365.jpg";s:5:"width";i:2048;s:6:"height";i:1365;s:9:"mime-type";s:10:"image/jpeg";}s:21:"et-pb-post-main-image";a:4:{s:4:"file";s:32:"StockSnap_3Q79ZWSUQS-400x250.jpg";s:5:"width";i:400;s:6:"height";i:250;s:9:"mime-type";s:10:"image/jpeg";}s:31:"et-pb-post-main-image-fullwidth";a:4:{s:4:"file";s:33:"StockSnap_3Q79ZWSUQS-1080x675.jpg";s:5:"width";i:1080;s:6:"height";i:675;s:9:"mime-type";s:10:"image/jpeg";}s:21:"et-pb-portfolio-image";a:4:{s:4:"file";s:32:"StockSnap_3Q79ZWSUQS-400x284.jpg";s:5:"width";i:400;s:6:"height";i:284;s:9:"mime-type";s:10:"image/jpeg";}s:28:"et-pb-portfolio-module-image";a:4:{s:4:"file";s:32:"StockSnap_3Q79ZWSUQS-510x382.jpg";s:5:"width";i:510;s:6:"height";i:382;s:9:"mime-type";s:10:"image/jpeg";}s:28:"et-pb-portfolio-image-single";a:4:{s:4:"file";s:33:"StockSnap_3Q79ZWSUQS-1080x720.jpg";s:5:"width";i:1080;s:6:"height";i:720;s:9:"mime-type";s:10:"image/jpeg";}s:35:"et-pb-gallery-module-image-portrait";a:4:{s:4:"file";s:32:"StockSnap_3Q79ZWSUQS-400x516.jpg";s:5:"width";i:400;s:6:"height";i:516;s:9:"mime-type";s:10:"image/jpeg";}s:37:"et-pb-post-main-image-fullwidth-large";a:4:{s:4:"file";s:34:"StockSnap_3Q79ZWSUQS-2880x1800.jpg";s:5:"width";i:2880;s:6:"height";i:1800;s:9:"mime-type";s:10:"image/jpeg";}s:32:"et-pb-image--responsive--desktop";a:4:{s:4:"file";s:33:"StockSnap_3Q79ZWSUQS-1280x853.jpg";s:5:"width";i:1280;s:6:"height";i:853;s:9:"mime-type";s:10:"image/jpeg";}s:31:"et-pb-image--responsive--tablet";a:4:{s:4:"file";s:32:"StockSnap_3Q79ZWSUQS-980x653.jpg";s:5:"width";i:980;s:6:"height";i:653;s:9:"mime-type";s:10:"image/jpeg";}s:30:"et-pb-image--responsive--phone";a:4:{s:4:"file";s:32:"StockSnap_3Q79ZWSUQS-480x320.jpg";s:5:"width";i:480;s:6:"height";i:320;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}s:14:"original_image";s:24:"StockSnap_3Q79ZWSUQS.jpg";s:10:"ShortPixel";a:8:{s:4:"type";s:6:"glossy";s:8:"exifKept";s:1:"0";s:4:"date";s:19:"2020-10-20 18:55:28";s:9:"thumbsOpt";i:17;s:13:"thumbsOptList";a:17:{i:0;s:24:"StockSnap_3Q79ZWSUQS.jpg";i:1;s:32:"StockSnap_3Q79ZWSUQS-300x200.jpg";i:2;s:33:"StockSnap_3Q79ZWSUQS-1024x683.jpg";i:3;s:32:"StockSnap_3Q79ZWSUQS-150x150.jpg";i:4;s:32:"StockSnap_3Q79ZWSUQS-768x512.jpg";i:5;s:34:"StockSnap_3Q79ZWSUQS-1536x1024.jpg";i:6;s:34:"StockSnap_3Q79ZWSUQS-2048x1365.jpg";i:7;s:32:"StockSnap_3Q79ZWSUQS-400x250.jpg";i:8;s:33:"StockSnap_3Q79ZWSUQS-1080x675.jpg";i:9;s:32:"StockSnap_3Q79ZWSUQS-400x284.jpg";i:10;s:32:"StockSnap_3Q79ZWSUQS-510x382.jpg";i:11;s:33:"StockSnap_3Q79ZWSUQS-1080x720.jpg";i:12;s:32:"StockSnap_3Q79ZWSUQS-400x516.jpg";i:13;s:34:"StockSnap_3Q79ZWSUQS-2880x1800.jpg";i:14;s:33:"StockSnap_3Q79ZWSUQS-1280x853.jpg";i:15;s:32:"StockSnap_3Q79ZWSUQS-980x653.jpg";i:16;s:32:"StockSnap_3Q79ZWSUQS-480x320.jpg";}s:12:"excludeSizes";a:0:{}s:10:"retinasOpt";i:0;s:8:"NoBackup";b:1;}s:21:"ShortPixelImprovement";s:5:"62.02";}');
INSERT INTO `wp5_postmeta` VALUES (435,28200,'_et_pb_ab_subjects','');
INSERT INTO `wp5_postmeta` VALUES (436,28200,'_et_pb_enable_shortcode_tracking','');
INSERT INTO `wp5_postmeta` VALUES (437,28200,'_et_pb_ab_current_shortcode','[et_pb_split_track id="28200" /]');
INSERT INTO `wp5_postmeta` VALUES (438,28200,'_et_pb_custom_css','');
INSERT INTO `wp5_postmeta` VALUES (439,28200,'_et_pb_gutter_width','3');
INSERT INTO `wp5_postmeta` VALUES (447,28200,'_et_pb_use_builder','on');
INSERT INTO `wp5_postmeta` VALUES (441,28200,'_et_pb_first_image','');
INSERT INTO `wp5_postmeta` VALUES (442,28200,'_et_pb_truncate_post','');
INSERT INTO `wp5_postmeta` VALUES (443,28200,'_et_pb_truncate_post_date','');
INSERT INTO `wp5_postmeta` VALUES (444,28200,'_et_builder_version','VB|Divi|4.6.6');
INSERT INTO `wp5_postmeta` VALUES (445,28200,'_et_pb_show_page_creation','off');
INSERT INTO `wp5_postmeta` VALUES (446,28200,'_edit_last','1');
INSERT INTO `wp5_postmeta` VALUES (448,28200,'_et_pb_old_content','');
INSERT INTO `wp5_postmeta` VALUES (1665,204781,'_email','mercurial.ohearn@gmail.com');
INSERT INTO `wp5_postmeta` VALUES (456,203951,'_edit_lock','1603205466:1');
INSERT INTO `wp5_postmeta` VALUES (458,28047,'_edit_lock','1603382478:1');
INSERT INTO `wp5_postmeta` VALUES (500,203951,'_et_pb_ab_subjects','');
INSERT INTO `wp5_postmeta` VALUES (501,203951,'_et_pb_enable_shortcode_tracking','');
INSERT INTO `wp5_postmeta` VALUES (502,203951,'_et_pb_ab_current_shortcode','[et_pb_split_track id="203951" /]');
INSERT INTO `wp5_postmeta` VALUES (503,203951,'_et_pb_custom_css','');
INSERT INTO `wp5_postmeta` VALUES (504,203951,'_et_pb_gutter_width','3');
INSERT INTO `wp5_postmeta` VALUES (512,203951,'_et_pb_use_builder','on');
INSERT INTO `wp5_postmeta` VALUES (506,203951,'_et_pb_first_image','');
INSERT INTO `wp5_postmeta` VALUES (507,203951,'_et_pb_truncate_post','');
INSERT INTO `wp5_postmeta` VALUES (508,203951,'_et_pb_truncate_post_date','');
INSERT INTO `wp5_postmeta` VALUES (509,203951,'_et_builder_version','VB|Divi|4.6.6');
INSERT INTO `wp5_postmeta` VALUES (510,203951,'_et_pb_show_page_creation','off');
INSERT INTO `wp5_postmeta` VALUES (511,203951,'_edit_last','1');
INSERT INTO `wp5_postmeta` VALUES (513,203951,'_et_pb_old_content','');
INSERT INTO `wp5_postmeta` VALUES (523,235,'_edit_lock','1603382470:1');
INSERT INTO `wp5_postmeta` VALUES (525,220,'_edit_lock','1603382608:1');
INSERT INTO `wp5_postmeta` VALUES (2289,204955,'_et_footer_layout_id','0');
INSERT INTO `wp5_postmeta` VALUES (2290,204955,'_et_footer_layout_enabled','1');
INSERT INTO `wp5_postmeta` VALUES (2604,204955,'_et_use_on','archive:post_type:post');
INSERT INTO `wp5_postmeta` VALUES (2616,28147,'_et_template','28148');
INSERT INTO `wp5_postmeta` VALUES (2617,28147,'_et_template','204955');
INSERT INTO `wp5_postmeta` VALUES (1729,204820,'_wp_attached_file','2021/02/Author-Signature.jpg');
INSERT INTO `wp5_postmeta` VALUES (1695,204808,'_edit_last','1');
INSERT INTO `wp5_postmeta` VALUES (1696,204808,'_edit_lock','1682290377:3');
INSERT INTO `wp5_postmeta` VALUES (1697,204808,'_wp_page_template','default');
INSERT INTO `wp5_postmeta` VALUES (1698,204808,'_et_pb_post_hide_nav','default');
INSERT INTO `wp5_postmeta` VALUES (1699,204808,'_et_pb_page_layout','et_right_sidebar');
INSERT INTO `wp5_postmeta` VALUES (1700,204808,'_et_pb_side_nav','off');
INSERT INTO `wp5_postmeta` VALUES (1701,204808,'_et_pb_use_builder','on');
INSERT INTO `wp5_postmeta` VALUES (1702,204808,'_et_pb_first_image','');
INSERT INTO `wp5_postmeta` VALUES (1703,204808,'_et_pb_truncate_post','');
INSERT INTO `wp5_postmeta` VALUES (4438,204260,'_thumbnail_id','0');
INSERT INTO `wp5_postmeta` VALUES (4443,204971,'_thumbnail_id','0');
INSERT INTO `wp5_postmeta` VALUES (1704,204808,'_et_pb_truncate_post_date','');
INSERT INTO `wp5_postmeta` VALUES (1705,204808,'_et_pb_old_content','');
INSERT INTO `wp5_postmeta` VALUES (1707,204808,'_et_pb_built_for_post_type','page');
INSERT INTO `wp5_postmeta` VALUES (1708,204808,'_et_pb_ab_subjects','');
INSERT INTO `wp5_postmeta` VALUES (1709,204808,'_et_pb_enable_shortcode_tracking','');
INSERT INTO `wp5_postmeta` VALUES (1710,204808,'_et_pb_ab_current_shortcode','[et_pb_split_track id="204808" /]');
INSERT INTO `wp5_postmeta` VALUES (1711,204808,'_et_pb_custom_css','');
INSERT INTO `wp5_postmeta` VALUES (1712,204808,'_et_pb_gutter_width','3');
INSERT INTO `wp5_postmeta` VALUES (1720,204818,'_menu_item_type','post_type');
INSERT INTO `wp5_postmeta` VALUES (1714,204808,'_global_colors_info','{}');
INSERT INTO `wp5_postmeta` VALUES (1715,204808,'_et_builder_version','VB|Divi|4.27.4');
INSERT INTO `wp5_postmeta` VALUES (1716,204808,'_et_pb_show_page_creation','off');
INSERT INTO `wp5_postmeta` VALUES (1721,204818,'_menu_item_menu_item_parent','0');
INSERT INTO `wp5_postmeta` VALUES (1722,204818,'_menu_item_object_id','204808');
INSERT INTO `wp5_postmeta` VALUES (1723,204818,'_menu_item_object','page');
INSERT INTO `wp5_postmeta` VALUES (1724,204818,'_menu_item_target','');
INSERT INTO `wp5_postmeta` VALUES (1725,204818,'_menu_item_classes','a:1:{i:0;s:0:"";}');
INSERT INTO `wp5_postmeta` VALUES (1726,204818,'_menu_item_xfn','');
INSERT INTO `wp5_postmeta` VALUES (1727,204818,'_menu_item_url','');
INSERT INTO `wp5_postmeta` VALUES (1732,204820,'_shortpixel_status','2.2600');
INSERT INTO `wp5_postmeta` VALUES (1755,204842,'_et_pb_built_for_post_type','page');
INSERT INTO `wp5_postmeta` VALUES (1756,204842,'_edit_lock','1614907457:1');
INSERT INTO `wp5_postmeta` VALUES (1758,204842,'_et_pb_ab_subjects','');
INSERT INTO `wp5_postmeta` VALUES (1759,204842,'_et_pb_enable_shortcode_tracking','');
INSERT INTO `wp5_postmeta` VALUES (1760,204842,'_et_pb_ab_current_shortcode','[et_pb_split_track id="204842" /]');
INSERT INTO `wp5_postmeta` VALUES (1742,204839,'_email','nate.hoffelder@gmail.com');
INSERT INTO `wp5_postmeta` VALUES (1743,204839,'_name','new admin');
INSERT INTO `wp5_postmeta` VALUES (1744,204839,'_props','a:2:{s:10:"first_name";s:0:"";s:9:"last_name";s:0:"";}');
INSERT INTO `wp5_postmeta` VALUES (1745,204839,'_last_contacted','2021-05-23 21:21:13');
INSERT INTO `wp5_postmeta` VALUES (1746,204840,'_menu_item_type','custom');
INSERT INTO `wp5_postmeta` VALUES (1747,204840,'_menu_item_menu_item_parent','0');
INSERT INTO `wp5_postmeta` VALUES (1748,204840,'_menu_item_object_id','204840');
INSERT INTO `wp5_postmeta` VALUES (1749,204840,'_menu_item_object','custom');
INSERT INTO `wp5_postmeta` VALUES (1750,204840,'_menu_item_target','');
INSERT INTO `wp5_postmeta` VALUES (1751,204840,'_menu_item_classes','a:1:{i:0;s:0:"";}');
INSERT INTO `wp5_postmeta` VALUES (1752,204840,'_menu_item_xfn','');
INSERT INTO `wp5_postmeta` VALUES (1753,204840,'_menu_item_url','#');
INSERT INTO `wp5_postmeta` VALUES (1761,204842,'_et_pb_custom_css','');
INSERT INTO `wp5_postmeta` VALUES (1762,204842,'_et_pb_gutter_width','3');
INSERT INTO `wp5_postmeta` VALUES (1771,204842,'_et_pb_use_builder','on');
INSERT INTO `wp5_postmeta` VALUES (1764,204842,'_global_colors_info','{}');
INSERT INTO `wp5_postmeta` VALUES (1765,204842,'_et_pb_first_image','');
INSERT INTO `wp5_postmeta` VALUES (1766,204842,'_et_pb_truncate_post','');
INSERT INTO `wp5_postmeta` VALUES (1767,204842,'_et_pb_truncate_post_date','');
INSERT INTO `wp5_postmeta` VALUES (1768,204842,'_et_builder_version','VB|Divi|4.9.0');
INSERT INTO `wp5_postmeta` VALUES (1769,204842,'_et_pb_show_page_creation','off');
INSERT INTO `wp5_postmeta` VALUES (1770,204842,'_edit_last','1');
INSERT INTO `wp5_postmeta` VALUES (1772,204842,'_et_pb_old_content','');
INSERT INTO `wp5_postmeta` VALUES (1774,204293,'_edit_lock','1615847285:1');
INSERT INTO `wp5_postmeta` VALUES (1775,204292,'_edit_lock','1615847301:1');
INSERT INTO `wp5_postmeta` VALUES (1776,204270,'_edit_lock','1615847469:1');
INSERT INTO `wp5_postmeta` VALUES (1777,204238,'_edit_lock','1615847339:1');
INSERT INTO `wp5_postmeta` VALUES (1778,204184,'_edit_lock','1615847402:1');
INSERT INTO `wp5_postmeta` VALUES (624,204165,'_wp_attached_file','2020/10/Depositphotos_223512888_xl-2015-scaled-e1603221627987.jpg');
INSERT INTO `wp5_postmeta` VALUES (625,204165,'_wp_attachment_metadata','a:8:{s:5:"width";i:2560;s:6:"height";i:1440;s:4:"file";s:65:"2020/10/Depositphotos_223512888_xl-2015-scaled-e1603221627987.jpg";s:5:"sizes";a:16:{s:6:"medium";a:4:{s:4:"file";s:65:"Depositphotos_223512888_xl-2015-scaled-e1603221627987-300x169.jpg";s:5:"width";i:300;s:6:"height";i:169;s:9:"mime-type";s:10:"image/jpeg";}s:5:"large";a:4:{s:4:"file";s:66:"Depositphotos_223512888_xl-2015-scaled-e1603221627987-1024x576.jpg";s:5:"width";i:1024;s:6:"height";i:576;s:9:"mime-type";s:10:"image/jpeg";}s:9:"thumbnail";a:4:{s:4:"file";s:65:"Depositphotos_223512888_xl-2015-scaled-e1603221627987-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:12:"medium_large";a:4:{s:4:"file";s:65:"Depositphotos_223512888_xl-2015-scaled-e1603221627987-768x432.jpg";s:5:"width";i:768;s:6:"height";i:432;s:9:"mime-type";s:10:"image/jpeg";}s:9:"1536x1536";a:4:{s:4:"file";s:66:"Depositphotos_223512888_xl-2015-scaled-e1603221627987-1536x864.jpg";s:5:"width";i:1536;s:6:"height";i:864;s:9:"mime-type";s:10:"image/jpeg";}s:9:"2048x2048";a:4:{s:4:"file";s:67:"Depositphotos_223512888_xl-2015-scaled-e1603221627987-2048x1152.jpg";s:5:"width";i:2048;s:6:"height";i:1152;s:9:"mime-type";s:10:"image/jpeg";}s:21:"et-pb-post-main-image";a:4:{s:4:"file";s:65:"Depositphotos_223512888_xl-2015-scaled-e1603221627987-400x250.jpg";s:5:"width";i:400;s:6:"height";i:250;s:9:"mime-type";s:10:"image/jpeg";}s:31:"et-pb-post-main-image-fullwidth";a:4:{s:4:"file";s:66:"Depositphotos_223512888_xl-2015-scaled-e1603221627987-1080x675.jpg";s:5:"width";i:1080;s:6:"height";i:675;s:9:"mime-type";s:10:"image/jpeg";}s:21:"et-pb-portfolio-image";a:4:{s:4:"file";s:65:"Depositphotos_223512888_xl-2015-scaled-e1603221627987-400x284.jpg";s:5:"width";i:400;s:6:"height";i:284;s:9:"mime-type";s:10:"image/jpeg";}s:28:"et-pb-portfolio-module-image";a:4:{s:4:"file";s:65:"Depositphotos_223512888_xl-2015-scaled-e1603221627987-510x382.jpg";s:5:"width";i:510;s:6:"height";i:382;s:9:"mime-type";s:10:"image/jpeg";}s:28:"et-pb-portfolio-image-single";a:4:{s:4:"file";s:66:"Depositphotos_223512888_xl-2015-scaled-e1603221627987-1080x608.jpg";s:5:"width";i:1080;s:6:"height";i:608;s:9:"mime-type";s:10:"image/jpeg";}s:35:"et-pb-gallery-module-image-portrait";a:4:{s:4:"file";s:65:"Depositphotos_223512888_xl-2015-scaled-e1603221627987-400x516.jpg";s:5:"width";i:400;s:6:"height";i:516;s:9:"mime-type";s:10:"image/jpeg";}s:37:"et-pb-post-main-image-fullwidth-large";a:4:{s:4:"file";s:45:"Depositphotos_223512888_xl-2015-2880x1800.jpg";s:5:"width";i:2880;s:6:"height";i:1800;s:9:"mime-type";s:10:"image/jpeg";}s:32:"et-pb-image--responsive--desktop";a:4:{s:4:"file";s:66:"Depositphotos_223512888_xl-2015-scaled-e1603221627987-1280x720.jpg";s:5:"width";i:1280;s:6:"height";i:720;s:9:"mime-type";s:10:"image/jpeg";}s:31:"et-pb-image--responsive--tablet";a:4:{s:4:"file";s:65:"Depositphotos_223512888_xl-2015-scaled-e1603221627987-980x551.jpg";s:5:"width";i:980;s:6:"height";i:551;s:9:"mime-type";s:10:"image/jpeg";}s:30:"et-pb-image--responsive--phone";a:4:{s:4:"file";s:65:"Depositphotos_223512888_xl-2015-scaled-e1603221627987-480x270.jpg";s:5:"width";i:480;s:6:"height";i:270;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:111:"couple in the futuristic city at night with buildings and light beams, digital art style, illustration painting";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:39:"Creation Date\r08/30/2018 23:51:35 +0700";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"1";s:8:"keywords";a:30:{i:0;s:12:"illustration";i:1;s:8:"painting";i:2;s:3:"art";i:3;s:11:"imagination";i:4;s:7:"artwork";i:5;s:7:"acrylic";i:6;s:9:"buildings";i:7;s:9:"cyberpunk";i:8;s:9:"landscape";i:9;s:7:"scenery";i:10;s:9:"dystopian";i:11;s:7:"outdoor";i:12;s:10:"futuristic";i:13;s:15:"science fiction";i:14;s:6:"sci-fi";i:15;s:9:"cityscape";i:16;s:10:"technology";i:17;s:5:"night";i:18;s:5:"urban";i:19;s:7:"concept";i:20;s:11:"light beams";i:21;s:3:"man";i:22;s:4:"dark";i:23;s:8:"exterior";i:24;s:6:"stairs";i:25;s:5:"steps";i:26;s:5:"tower";i:27;s:8:"colorful";i:28;s:6:"people";i:29;s:6:"couple";}}s:14:"original_image";s:35:"Depositphotos_223512888_xl-2015.jpg";s:10:"ShortPixel";a:7:{s:4:"type";s:6:"glossy";s:4:"date";s:19:"2020-10-20 18:49:05";s:9:"thumbsOpt";i:17;s:13:"thumbsOptList";a:1:{i:0;s:45:"Depositphotos_223512888_xl-2015-2880x1800.jpg";}s:12:"excludeSizes";a:0:{}s:10:"retinasOpt";i:0;s:8:"NoBackup";b:1;}s:21:"ShortPixelImprovement";s:5:"82.06";}');
INSERT INTO `wp5_postmeta` VALUES (626,204166,'_wp_attached_file','2020/10/Depositphotos_162576212_xl-2015-scaled.jpg');
INSERT INTO `wp5_postmeta` VALUES (627,204166,'_wp_attachment_metadata','a:8:{s:5:"width";i:2560;s:6:"height";i:1440;s:4:"file";s:50:"2020/10/Depositphotos_162576212_xl-2015-scaled.jpg";s:5:"sizes";a:16:{s:6:"medium";a:4:{s:4:"file";s:43:"Depositphotos_162576212_xl-2015-300x169.jpg";s:5:"width";i:300;s:6:"height";i:169;s:9:"mime-type";s:10:"image/jpeg";}s:5:"large";a:4:{s:4:"file";s:44:"Depositphotos_162576212_xl-2015-1024x576.jpg";s:5:"width";i:1024;s:6:"height";i:576;s:9:"mime-type";s:10:"image/jpeg";}s:9:"thumbnail";a:4:{s:4:"file";s:43:"Depositphotos_162576212_xl-2015-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:12:"medium_large";a:4:{s:4:"file";s:43:"Depositphotos_162576212_xl-2015-768x432.jpg";s:5:"width";i:768;s:6:"height";i:432;s:9:"mime-type";s:10:"image/jpeg";}s:9:"1536x1536";a:4:{s:4:"file";s:44:"Depositphotos_162576212_xl-2015-1536x864.jpg";s:5:"width";i:1536;s:6:"height";i:864;s:9:"mime-type";s:10:"image/jpeg";}s:9:"2048x2048";a:4:{s:4:"file";s:45:"Depositphotos_162576212_xl-2015-2048x1152.jpg";s:5:"width";i:2048;s:6:"height";i:1152;s:9:"mime-type";s:10:"image/jpeg";}s:21:"et-pb-post-main-image";a:4:{s:4:"file";s:43:"Depositphotos_162576212_xl-2015-400x250.jpg";s:5:"width";i:400;s:6:"height";i:250;s:9:"mime-type";s:10:"image/jpeg";}s:31:"et-pb-post-main-image-fullwidth";a:4:{s:4:"file";s:44:"Depositphotos_162576212_xl-2015-1080x675.jpg";s:5:"width";i:1080;s:6:"height";i:675;s:9:"mime-type";s:10:"image/jpeg";}s:21:"et-pb-portfolio-image";a:4:{s:4:"file";s:43:"Depositphotos_162576212_xl-2015-400x284.jpg";s:5:"width";i:400;s:6:"height";i:284;s:9:"mime-type";s:10:"image/jpeg";}s:28:"et-pb-portfolio-module-image";a:4:{s:4:"file";s:43:"Depositphotos_162576212_xl-2015-510x382.jpg";s:5:"width";i:510;s:6:"height";i:382;s:9:"mime-type";s:10:"image/jpeg";}s:28:"et-pb-portfolio-image-single";a:4:{s:4:"file";s:44:"Depositphotos_162576212_xl-2015-1080x608.jpg";s:5:"width";i:1080;s:6:"height";i:608;s:9:"mime-type";s:10:"image/jpeg";}s:35:"et-pb-gallery-module-image-portrait";a:4:{s:4:"file";s:43:"Depositphotos_162576212_xl-2015-400x516.jpg";s:5:"width";i:400;s:6:"height";i:516;s:9:"mime-type";s:10:"image/jpeg";}s:37:"et-pb-post-main-image-fullwidth-large";a:4:{s:4:"file";s:45:"Depositphotos_162576212_xl-2015-2880x1800.jpg";s:5:"width";i:2880;s:6:"height";i:1800;s:9:"mime-type";s:10:"image/jpeg";}s:32:"et-pb-image--responsive--desktop";a:4:{s:4:"file";s:44:"Depositphotos_162576212_xl-2015-1280x720.jpg";s:5:"width";i:1280;s:6:"height";i:720;s:9:"mime-type";s:10:"image/jpeg";}s:31:"et-pb-image--responsive--tablet";a:4:{s:4:"file";s:43:"Depositphotos_162576212_xl-2015-980x551.jpg";s:5:"width";i:980;s:6:"height";i:551;s:9:"mime-type";s:10:"image/jpeg";}s:30:"et-pb-image--responsive--phone";a:4:{s:4:"file";s:43:"Depositphotos_162576212_xl-2015-480x270.jpg";s:5:"width";i:480;s:6:"height";i:270;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:100:"sci-fi scenery of cyberpunk city with futuristic buildings, digital art style, illustration painting";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"1";s:8:"keywords";a:24:{i:0;s:12:"illustration";i:1;s:8:"painting";i:2;s:3:"art";i:3;s:8:"artistic";i:4;s:11:"imagination";i:5;s:7:"artwork";i:6;s:7:"acrylic";i:7;s:10:"watercolor";i:8;s:9:"landscape";i:9;s:4:"city";i:10;s:9:"cyberpunk";i:11;s:8:"building";i:12;s:15:"science fiction";i:13;s:5:"light";i:14;s:10:"futuristic";i:15;s:12:"architecture";i:16;s:5:"urban";i:17;s:10:"industrial";i:18;s:6:"sci-fi";i:19;s:9:"cityscape";i:20;s:7:"scenery";i:21;s:7:"outdoor";i:22;s:9:"structure";i:23;s:7:"concept";}}s:14:"original_image";s:35:"Depositphotos_162576212_xl-2015.jpg";s:10:"ShortPixel";a:7:{s:4:"type";s:6:"glossy";s:4:"date";s:19:"2020-10-20 18:48:40";s:9:"thumbsOpt";i:17;s:13:"thumbsOptList";a:16:{i:0;s:43:"Depositphotos_162576212_xl-2015-300x169.jpg";i:1;s:44:"Depositphotos_162576212_xl-2015-1024x576.jpg";i:2;s:43:"Depositphotos_162576212_xl-2015-150x150.jpg";i:3;s:43:"Depositphotos_162576212_xl-2015-768x432.jpg";i:4;s:44:"Depositphotos_162576212_xl-2015-1536x864.jpg";i:5;s:45:"Depositphotos_162576212_xl-2015-2048x1152.jpg";i:6;s:43:"Depositphotos_162576212_xl-2015-400x250.jpg";i:7;s:44:"Depositphotos_162576212_xl-2015-1080x675.jpg";i:8;s:43:"Depositphotos_162576212_xl-2015-400x284.jpg";i:9;s:43:"Depositphotos_162576212_xl-2015-510x382.jpg";i:10;s:44:"Depositphotos_162576212_xl-2015-1080x608.jpg";i:11;s:43:"Depositphotos_162576212_xl-2015-400x516.jpg";i:12;s:45:"Depositphotos_162576212_xl-2015-2880x1800.jpg";i:13;s:44:"Depositphotos_162576212_xl-2015-1280x720.jpg";i:14;s:43:"Depositphotos_162576212_xl-2015-980x551.jpg";i:15;s:43:"Depositphotos_162576212_xl-2015-480x270.jpg";}s:12:"excludeSizes";a:0:{}s:10:"retinasOpt";i:0;s:8:"NoBackup";b:1;}s:21:"ShortPixelImprovement";s:5:"60.33";}');
INSERT INTO `wp5_postmeta` VALUES (826,204238,'_wp_attached_file','2020/10/Depositphotos_162576212_xl-2015-scaled-1.jpg');
INSERT INTO `wp5_postmeta` VALUES (629,204166,'_shortpixel_status','2.6000');
INSERT INTO `wp5_postmeta` VALUES (733,204183,'_wp_attachment_metadata','a:8:{s:5:"width";i:2560;s:6:"height";i:1280;s:4:"file";s:49:"2020/10/Depositphotos_29446435_xl-2015-scaled.jpg";s:5:"sizes";a:16:{s:6:"medium";a:4:{s:4:"file";s:42:"Depositphotos_29446435_xl-2015-300x150.jpg";s:5:"width";i:300;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:5:"large";a:4:{s:4:"file";s:43:"Depositphotos_29446435_xl-2015-1024x512.jpg";s:5:"width";i:1024;s:6:"height";i:512;s:9:"mime-type";s:10:"image/jpeg";}s:9:"thumbnail";a:4:{s:4:"file";s:42:"Depositphotos_29446435_xl-2015-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:12:"medium_large";a:4:{s:4:"file";s:42:"Depositphotos_29446435_xl-2015-768x384.jpg";s:5:"width";i:768;s:6:"height";i:384;s:9:"mime-type";s:10:"image/jpeg";}s:9:"1536x1536";a:4:{s:4:"file";s:43:"Depositphotos_29446435_xl-2015-1536x768.jpg";s:5:"width";i:1536;s:6:"height";i:768;s:9:"mime-type";s:10:"image/jpeg";}s:9:"2048x2048";a:4:{s:4:"file";s:44:"Depositphotos_29446435_xl-2015-2048x1024.jpg";s:5:"width";i:2048;s:6:"height";i:1024;s:9:"mime-type";s:10:"image/jpeg";}s:21:"et-pb-post-main-image";a:4:{s:4:"file";s:42:"Depositphotos_29446435_xl-2015-400x250.jpg";s:5:"width";i:400;s:6:"height";i:250;s:9:"mime-type";s:10:"image/jpeg";}s:31:"et-pb-post-main-image-fullwidth";a:4:{s:4:"file";s:43:"Depositphotos_29446435_xl-2015-1080x675.jpg";s:5:"width";i:1080;s:6:"height";i:675;s:9:"mime-type";s:10:"image/jpeg";}s:21:"et-pb-portfolio-image";a:4:{s:4:"file";s:42:"Depositphotos_29446435_xl-2015-400x284.jpg";s:5:"width";i:400;s:6:"height";i:284;s:9:"mime-type";s:10:"image/jpeg";}s:28:"et-pb-portfolio-module-image";a:4:{s:4:"file";s:42:"Depositphotos_29446435_xl-2015-510x382.jpg";s:5:"width";i:510;s:6:"height";i:382;s:9:"mime-type";s:10:"image/jpeg";}s:28:"et-pb-portfolio-image-single";a:4:{s:4:"file";s:43:"Depositphotos_29446435_xl-2015-1080x540.jpg";s:5:"width";i:1080;s:6:"height";i:540;s:9:"mime-type";s:10:"image/jpeg";}s:35:"et-pb-gallery-module-image-portrait";a:4:{s:4:"file";s:42:"Depositphotos_29446435_xl-2015-400x516.jpg";s:5:"width";i:400;s:6:"height";i:516;s:9:"mime-type";s:10:"image/jpeg";}s:37:"et-pb-post-main-image-fullwidth-large";a:4:{s:4:"file";s:44:"Depositphotos_29446435_xl-2015-2880x1800.jpg";s:5:"width";i:2880;s:6:"height";i:1800;s:9:"mime-type";s:10:"image/jpeg";}s:32:"et-pb-image--responsive--desktop";a:4:{s:4:"file";s:43:"Depositphotos_29446435_xl-2015-1280x640.jpg";s:5:"width";i:1280;s:6:"height";i:640;s:9:"mime-type";s:10:"image/jpeg";}s:31:"et-pb-image--responsive--tablet";a:4:{s:4:"file";s:42:"Depositphotos_29446435_xl-2015-980x490.jpg";s:5:"width";i:980;s:6:"height";i:490;s:9:"mime-type";s:10:"image/jpeg";}s:30:"et-pb-image--responsive--phone";a:4:{s:4:"file";s:42:"Depositphotos_29446435_xl-2015-480x240.jpg";s:5:"width";i:480;s:6:"height";i:240;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"1";s:8:"keywords";a:0:{}}s:14:"original_image";s:34:"Depositphotos_29446435_xl-2015.jpg";s:10:"ShortPixel";a:7:{s:4:"type";s:6:"glossy";s:4:"date";s:19:"2020-10-20 20:58:17";s:9:"thumbsOpt";i:17;s:13:"thumbsOptList";a:16:{i:0;s:42:"Depositphotos_29446435_xl-2015-300x150.jpg";i:1;s:43:"Depositphotos_29446435_xl-2015-1024x512.jpg";i:2;s:42:"Depositphotos_29446435_xl-2015-150x150.jpg";i:3;s:42:"Depositphotos_29446435_xl-2015-768x384.jpg";i:4;s:43:"Depositphotos_29446435_xl-2015-1536x768.jpg";i:5;s:44:"Depositphotos_29446435_xl-2015-2048x1024.jpg";i:6;s:42:"Depositphotos_29446435_xl-2015-400x250.jpg";i:7;s:43:"Depositphotos_29446435_xl-2015-1080x675.jpg";i:8;s:42:"Depositphotos_29446435_xl-2015-400x284.jpg";i:9;s:42:"Depositphotos_29446435_xl-2015-510x382.jpg";i:10;s:43:"Depositphotos_29446435_xl-2015-1080x540.jpg";i:11;s:42:"Depositphotos_29446435_xl-2015-400x516.jpg";i:12;s:44:"Depositphotos_29446435_xl-2015-2880x1800.jpg";i:13;s:43:"Depositphotos_29446435_xl-2015-1280x640.jpg";i:14;s:42:"Depositphotos_29446435_xl-2015-980x490.jpg";i:15;s:42:"Depositphotos_29446435_xl-2015-480x240.jpg";}s:12:"excludeSizes";a:0:{}s:10:"retinasOpt";i:0;s:8:"NoBackup";b:1;}s:21:"ShortPixelImprovement";s:5:"66.01";}');
INSERT INTO `wp5_postmeta` VALUES (722,204165,'_edit_last','1');
INSERT INTO `wp5_postmeta` VALUES (630,204165,'_shortpixel_status','2.8200');
INSERT INTO `wp5_postmeta` VALUES (650,204096,'_shortpixel_status','2.6200');
INSERT INTO `wp5_postmeta` VALUES (651,204095,'_shortpixel_status','2.8100');
INSERT INTO `wp5_postmeta` VALUES (652,204094,'_shortpixel_status','2.5900');
INSERT INTO `wp5_postmeta` VALUES (653,204093,'_shortpixel_status','2.7000');
INSERT INTO `wp5_postmeta` VALUES (654,204092,'_shortpixel_status','2.5400');
INSERT INTO `wp5_postmeta` VALUES (655,204091,'_shortpixel_status','2.7400');
INSERT INTO `wp5_postmeta` VALUES (656,204086,'_shortpixel_status','2.6200');
INSERT INTO `wp5_postmeta` VALUES (657,204085,'_shortpixel_status','2.2900');
INSERT INTO `wp5_postmeta` VALUES (658,204084,'_shortpixel_status','2.4500');
INSERT INTO `wp5_postmeta` VALUES (659,28251,'_shortpixel_status','2.0800');
INSERT INTO `wp5_postmeta` VALUES (661,28249,'_shortpixel_status','2.1800');
INSERT INTO `wp5_postmeta` VALUES (662,28248,'_shortpixel_status','2.0600');
INSERT INTO `wp5_postmeta` VALUES (663,28247,'_shortpixel_status','2.1300');
INSERT INTO `wp5_postmeta` VALUES (710,28170,'_shortpixel_status','2.4000');
INSERT INTO `wp5_postmeta` VALUES (670,28240,'_shortpixel_status','2.6400');
INSERT INTO `wp5_postmeta` VALUES (671,28239,'_shortpixel_status','2.4900');
INSERT INTO `wp5_postmeta` VALUES (672,28238,'_shortpixel_status','2.6300');
INSERT INTO `wp5_postmeta` VALUES (677,28233,'_shortpixel_status','2.3800');
INSERT INTO `wp5_postmeta` VALUES (678,28232,'_shortpixel_status','2.1800');
INSERT INTO `wp5_postmeta` VALUES (679,28231,'_shortpixel_status','2.1200');
INSERT INTO `wp5_postmeta` VALUES (855,204248,'_et_builder_version','VB|Divi|4.6.6');
INSERT INTO `wp5_postmeta` VALUES (856,204248,'_et_pb_show_page_creation','off');
INSERT INTO `wp5_postmeta` VALUES (857,204248,'_edit_last','1');
INSERT INTO `wp5_postmeta` VALUES (859,204248,'_et_pb_old_content','');
INSERT INTO `wp5_postmeta` VALUES (854,204248,'_et_pb_truncate_post_date','');
INSERT INTO `wp5_postmeta` VALUES (681,28229,'_shortpixel_status','2.0900');
INSERT INTO `wp5_postmeta` VALUES (682,28228,'_shortpixel_status','2.1600');
INSERT INTO `wp5_postmeta` VALUES (683,28227,'_shortpixel_status','2.8000');
INSERT INTO `wp5_postmeta` VALUES (686,28224,'_shortpixel_status','2.8100');
INSERT INTO `wp5_postmeta` VALUES (687,28223,'_shortpixel_status','2.1100');
INSERT INTO `wp5_postmeta` VALUES (844,204248,'_edit_lock','1604083250:1');
INSERT INTO `wp5_postmeta` VALUES (1673,204784,'_et_pb_row_layout','4_4');
INSERT INTO `wp5_postmeta` VALUES (1674,204784,'_et_pb_built_for_post_type','page');
INSERT INTO `wp5_postmeta` VALUES (1675,204785,'_et_pb_built_for_post_type','page');
INSERT INTO `wp5_postmeta` VALUES (1730,204820,'_wp_attachment_metadata','a:7:{s:5:"width";i:823;s:6:"height";i:200;s:4:"file";s:28:"2021/02/Author-Signature.jpg";s:5:"sizes";a:9:{s:6:"medium";a:4:{s:4:"file";s:27:"Author-Signature-300x73.jpg";s:5:"width";i:300;s:6:"height";i:73;s:9:"mime-type";s:10:"image/jpeg";}s:9:"thumbnail";a:4:{s:4:"file";s:28:"Author-Signature-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:12:"medium_large";a:4:{s:4:"file";s:28:"Author-Signature-768x187.jpg";s:5:"width";i:768;s:6:"height";i:187;s:9:"mime-type";s:10:"image/jpeg";}s:11:"bloom_image";a:4:{s:4:"file";s:28:"Author-Signature-610x148.jpg";s:5:"width";i:610;s:6:"height";i:148;s:9:"mime-type";s:10:"image/jpeg";}s:21:"et-pb-post-main-image";a:4:{s:4:"file";s:28:"Author-Signature-400x200.jpg";s:5:"width";i:400;s:6:"height";i:200;s:9:"mime-type";s:10:"image/jpeg";}s:21:"et-pb-portfolio-image";a:4:{s:4:"file";s:28:"Author-Signature-400x200.jpg";s:5:"width";i:400;s:6:"height";i:200;s:9:"mime-type";s:10:"image/jpeg";}s:28:"et-pb-portfolio-module-image";a:4:{s:4:"file";s:28:"Author-Signature-510x200.jpg";s:5:"width";i:510;s:6:"height";i:200;s:9:"mime-type";s:10:"image/jpeg";}s:35:"et-pb-gallery-module-image-portrait";a:4:{s:4:"file";s:28:"Author-Signature-400x200.jpg";s:5:"width";i:400;s:6:"height";i:200;s:9:"mime-type";s:10:"image/jpeg";}s:30:"et-pb-image--responsive--phone";a:4:{s:4:"file";s:28:"Author-Signature-480x117.jpg";s:5:"width";i:480;s:6:"height";i:117;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"1";s:8:"keywords";a:0:{}}s:10:"ShortPixel";a:8:{s:4:"type";s:6:"glossy";s:8:"exifKept";s:1:"0";s:4:"date";s:19:"2021-02-23 19:59:25";s:9:"thumbsOpt";i:7;s:13:"thumbsOptList";a:7:{i:0;s:27:"Author-Signature-300x73.jpg";i:1;s:28:"Author-Signature-150x150.jpg";i:2;s:28:"Author-Signature-768x187.jpg";i:3;s:28:"Author-Signature-610x148.jpg";i:4;s:28:"Author-Signature-400x200.jpg";i:5;s:28:"Author-Signature-510x200.jpg";i:6;s:28:"Author-Signature-480x117.jpg";}s:12:"excludeSizes";a:0:{}s:10:"retinasOpt";i:0;s:8:"NoBackup";b:1;}s:21:"ShortPixelImprovement";s:5:"26.04";}');
INSERT INTO `wp5_postmeta` VALUES (841,204248,'_et_pb_built_for_post_type','page');
INSERT INTO `wp5_postmeta` VALUES (1393,204484,'_shortpixel_status','2.8200');
INSERT INTO `wp5_postmeta` VALUES (1682,204351,'_global_colors_info','{}');
INSERT INTO `wp5_postmeta` VALUES (1684,204189,'_global_colors_info','{}');
INSERT INTO `wp5_postmeta` VALUES (1686,204260,'_global_colors_info','{}');
INSERT INTO `wp5_postmeta` VALUES (1691,204805,'_wp_attachment_metadata','a:7:{s:5:"width";i:1000;s:6:"height";i:284;s:4:"file";s:36:"2021/02/apple-books-store-button.png";s:5:"sizes";a:10:{s:6:"medium";a:4:{s:4:"file";s:35:"apple-books-store-button-300x85.png";s:5:"width";i:300;s:6:"height";i:85;s:9:"mime-type";s:9:"image/png";}s:9:"thumbnail";a:4:{s:4:"file";s:36:"apple-books-store-button-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:12:"medium_large";a:4:{s:4:"file";s:36:"apple-books-store-button-768x218.png";s:5:"width";i:768;s:6:"height";i:218;s:9:"mime-type";s:9:"image/png";}s:11:"bloom_image";a:4:{s:4:"file";s:36:"apple-books-store-button-610x173.png";s:5:"width";i:610;s:6:"height";i:173;s:9:"mime-type";s:9:"image/png";}s:21:"et-pb-post-main-image";a:4:{s:4:"file";s:36:"apple-books-store-button-400x250.png";s:5:"width";i:400;s:6:"height";i:250;s:9:"mime-type";s:9:"image/png";}s:21:"et-pb-portfolio-image";a:4:{s:4:"file";s:36:"apple-books-store-button-400x284.png";s:5:"width";i:400;s:6:"height";i:284;s:9:"mime-type";s:9:"image/png";}s:28:"et-pb-portfolio-module-image";a:4:{s:4:"file";s:36:"apple-books-store-button-510x284.png";s:5:"width";i:510;s:6:"height";i:284;s:9:"mime-type";s:9:"image/png";}s:35:"et-pb-gallery-module-image-portrait";a:4:{s:4:"file";s:36:"apple-books-store-button-400x284.png";s:5:"width";i:400;s:6:"height";i:284;s:9:"mime-type";s:9:"image/png";}s:31:"et-pb-image--responsive--tablet";a:4:{s:4:"file";s:36:"apple-books-store-button-980x278.png";s:5:"width";i:980;s:6:"height";i:278;s:9:"mime-type";s:9:"image/png";}s:30:"et-pb-image--responsive--phone";a:4:{s:4:"file";s:36:"apple-books-store-button-480x136.png";s:5:"width";i:480;s:6:"height";i:136;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}s:10:"ShortPixel";a:8:{s:4:"type";s:6:"glossy";s:8:"exifKept";s:1:"0";s:4:"date";s:19:"2021-02-23 19:38:33";s:9:"thumbsOpt";i:9;s:13:"thumbsOptList";a:9:{i:0;s:35:"apple-books-store-button-300x85.png";i:1;s:36:"apple-books-store-button-150x150.png";i:2;s:36:"apple-books-store-button-768x218.png";i:3;s:36:"apple-books-store-button-610x173.png";i:4;s:36:"apple-books-store-button-400x250.png";i:5;s:36:"apple-books-store-button-400x284.png";i:6;s:36:"apple-books-store-button-510x284.png";i:7;s:36:"apple-books-store-button-980x278.png";i:8;s:36:"apple-books-store-button-480x136.png";}s:12:"excludeSizes";a:0:{}s:10:"retinasOpt";i:0;s:8:"NoBackup";b:1;}s:21:"ShortPixelImprovement";s:4:"78.5";}');
INSERT INTO `wp5_postmeta` VALUES (944,204279,'_et_pb_built_for_post_type','page');
INSERT INTO `wp5_postmeta` VALUES (2227,204946,'_et_pb_use_builder','on');
INSERT INTO `wp5_postmeta` VALUES (2228,204946,'_et_pb_show_page_creation','off');
INSERT INTO `wp5_postmeta` VALUES (956,27888,'_edit_lock','1603381814:1');
INSERT INTO `wp5_postmeta` VALUES (960,235,'_et_pb_ab_subjects','');
INSERT INTO `wp5_postmeta` VALUES (961,235,'_et_pb_enable_shortcode_tracking','');
INSERT INTO `wp5_postmeta` VALUES (962,235,'_et_pb_ab_current_shortcode','[et_pb_split_track id="235" /]');
INSERT INTO `wp5_postmeta` VALUES (963,235,'_et_pb_custom_css','');
INSERT INTO `wp5_postmeta` VALUES (964,235,'_et_pb_gutter_width','3');
INSERT INTO `wp5_postmeta` VALUES (972,235,'_et_pb_use_builder','on');
INSERT INTO `wp5_postmeta` VALUES (966,235,'_et_pb_first_image','');
INSERT INTO `wp5_postmeta` VALUES (967,235,'_et_pb_truncate_post','');
INSERT INTO `wp5_postmeta` VALUES (968,235,'_et_pb_truncate_post_date','');
INSERT INTO `wp5_postmeta` VALUES (969,235,'_et_builder_version','VB|Divi|4.6.6');
INSERT INTO `wp5_postmeta` VALUES (970,235,'_et_pb_show_page_creation','off');
INSERT INTO `wp5_postmeta` VALUES (971,235,'_edit_last','1');
INSERT INTO `wp5_postmeta` VALUES (973,235,'_et_pb_old_content','');
INSERT INTO `wp5_postmeta` VALUES (992,204274,'_et_pb_built_for_post_type','page');
INSERT INTO `wp5_postmeta` VALUES (993,204274,'_et_pb_ab_subjects','');
INSERT INTO `wp5_postmeta` VALUES (994,204274,'_et_pb_enable_shortcode_tracking','');
INSERT INTO `wp5_postmeta` VALUES (995,204274,'_et_pb_ab_current_shortcode','[et_pb_split_track id="204274" /]');
INSERT INTO `wp5_postmeta` VALUES (996,204274,'_et_pb_custom_css','');
INSERT INTO `wp5_postmeta` VALUES (997,204274,'_et_pb_gutter_width','3');
INSERT INTO `wp5_postmeta` VALUES (1001,204292,'_wp_attached_file','2020/10/Depositphotos_118360110_xl-2015-scaled.jpg');
INSERT INTO `wp5_postmeta` VALUES (999,204274,'_et_builder_version','VB|Divi|4.17.6');
INSERT INTO `wp5_postmeta` VALUES (1000,204274,'_et_pb_show_page_creation','off');
INSERT INTO `wp5_postmeta` VALUES (1002,204292,'_wp_attachment_metadata','a:8:{s:5:"width";i:2560;s:6:"height";i:1810;s:4:"file";s:50:"2020/10/Depositphotos_118360110_xl-2015-scaled.jpg";s:5:"sizes";a:16:{s:6:"medium";a:4:{s:4:"file";s:43:"Depositphotos_118360110_xl-2015-300x212.jpg";s:5:"width";i:300;s:6:"height";i:212;s:9:"mime-type";s:10:"image/jpeg";}s:5:"large";a:4:{s:4:"file";s:44:"Depositphotos_118360110_xl-2015-1024x724.jpg";s:5:"width";i:1024;s:6:"height";i:724;s:9:"mime-type";s:10:"image/jpeg";}s:9:"thumbnail";a:4:{s:4:"file";s:43:"Depositphotos_118360110_xl-2015-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:12:"medium_large";a:4:{s:4:"file";s:43:"Depositphotos_118360110_xl-2015-768x543.jpg";s:5:"width";i:768;s:6:"height";i:543;s:9:"mime-type";s:10:"image/jpeg";}s:9:"1536x1536";a:4:{s:4:"file";s:45:"Depositphotos_118360110_xl-2015-1536x1086.jpg";s:5:"width";i:1536;s:6:"height";i:1086;s:9:"mime-type";s:10:"image/jpeg";}s:9:"2048x2048";a:4:{s:4:"file";s:45:"Depositphotos_118360110_xl-2015-2048x1448.jpg";s:5:"width";i:2048;s:6:"height";i:1448;s:9:"mime-type";s:10:"image/jpeg";}s:21:"et-pb-post-main-image";a:4:{s:4:"file";s:43:"Depositphotos_118360110_xl-2015-400x250.jpg";s:5:"width";i:400;s:6:"height";i:250;s:9:"mime-type";s:10:"image/jpeg";}s:31:"et-pb-post-main-image-fullwidth";a:4:{s:4:"file";s:44:"Depositphotos_118360110_xl-2015-1080x675.jpg";s:5:"width";i:1080;s:6:"height";i:675;s:9:"mime-type";s:10:"image/jpeg";}s:21:"et-pb-portfolio-image";a:4:{s:4:"file";s:43:"Depositphotos_118360110_xl-2015-400x284.jpg";s:5:"width";i:400;s:6:"height";i:284;s:9:"mime-type";s:10:"image/jpeg";}s:28:"et-pb-portfolio-module-image";a:4:{s:4:"file";s:43:"Depositphotos_118360110_xl-2015-510x382.jpg";s:5:"width";i:510;s:6:"height";i:382;s:9:"mime-type";s:10:"image/jpeg";}s:28:"et-pb-portfolio-image-single";a:4:{s:4:"file";s:44:"Depositphotos_118360110_xl-2015-1080x764.jpg";s:5:"width";i:1080;s:6:"height";i:764;s:9:"mime-type";s:10:"image/jpeg";}s:35:"et-pb-gallery-module-image-portrait";a:4:{s:4:"file";s:43:"Depositphotos_118360110_xl-2015-400x516.jpg";s:5:"width";i:400;s:6:"height";i:516;s:9:"mime-type";s:10:"image/jpeg";}s:37:"et-pb-post-main-image-fullwidth-large";a:4:{s:4:"file";s:45:"Depositphotos_118360110_xl-2015-2880x1800.jpg";s:5:"width";i:2880;s:6:"height";i:1800;s:9:"mime-type";s:10:"image/jpeg";}s:32:"et-pb-image--responsive--desktop";a:4:{s:4:"file";s:44:"Depositphotos_118360110_xl-2015-1280x905.jpg";s:5:"width";i:1280;s:6:"height";i:905;s:9:"mime-type";s:10:"image/jpeg";}s:31:"et-pb-image--responsive--tablet";a:4:{s:4:"file";s:43:"Depositphotos_118360110_xl-2015-980x693.jpg";s:5:"width";i:980;s:6:"height";i:693;s:9:"mime-type";s:10:"image/jpeg";}s:30:"et-pb-image--responsive--phone";a:4:{s:4:"file";s:43:"Depositphotos_118360110_xl-2015-480x339.jpg";s:5:"width";i:480;s:6:"height";i:339;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:55:"sci-fi creative workspace,digital painting,illustration";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:55:"sci-fi creative workspace,digital painting,illustration";s:11:"orientation";s:1:"1";s:8:"keywords";a:35:{i:0;s:7:"acrylic";i:1;s:3:"art";i:2;s:8:"artistic";i:3;s:7:"artwork";i:4;s:12:"illustration";i:5;s:12:"oil painting";i:6;s:8:"painting";i:7;s:10:"watercolor";i:8;s:5:"cyber";i:9;s:7:"fiction";i:10;s:4:"desk";i:11;s:4:"room";i:12;s:10:"decoration";i:13;s:5:"table";i:14;s:4:"hack";i:15;s:5:"light";i:16;s:10:"technology";i:17;s:8:"computer";i:18;s:4:"wall";i:19;s:4:"work";i:20;s:5:"chair";i:21;s:9:"corporate";i:22;s:5:"vivid";i:23;s:7:"concept";i:24;s:9:"workspace";i:25;s:6:"studio";i:26;s:5:"shelf";i:27;s:6:"modern";i:28;s:7:"monitor";i:29;s:7:"science";i:30;s:8:"interior";i:31;s:6:"office";i:32;s:13:"communication";i:33;s:6:"sci-fi";i:34;s:9:"cyberpunk";}}s:14:"original_image";s:35:"Depositphotos_118360110_xl-2015.jpg";s:10:"ShortPixel";a:8:{s:4:"type";s:6:"glossy";s:8:"exifKept";s:1:"0";s:4:"date";s:19:"2020-10-22 15:42:55";s:9:"thumbsOpt";i:17;s:13:"thumbsOptList";a:17:{i:0;s:35:"Depositphotos_118360110_xl-2015.jpg";i:1;s:43:"Depositphotos_118360110_xl-2015-300x212.jpg";i:2;s:44:"Depositphotos_118360110_xl-2015-1024x724.jpg";i:3;s:43:"Depositphotos_118360110_xl-2015-150x150.jpg";i:4;s:43:"Depositphotos_118360110_xl-2015-768x543.jpg";i:5;s:45:"Depositphotos_118360110_xl-2015-1536x1086.jpg";i:6;s:45:"Depositphotos_118360110_xl-2015-2048x1448.jpg";i:7;s:43:"Depositphotos_118360110_xl-2015-400x250.jpg";i:8;s:44:"Depositphotos_118360110_xl-2015-1080x675.jpg";i:9;s:43:"Depositphotos_118360110_xl-2015-400x284.jpg";i:10;s:43:"Depositphotos_118360110_xl-2015-510x382.jpg";i:11;s:44:"Depositphotos_118360110_xl-2015-1080x764.jpg";i:12;s:43:"Depositphotos_118360110_xl-2015-400x516.jpg";i:13;s:45:"Depositphotos_118360110_xl-2015-2880x1800.jpg";i:14;s:44:"Depositphotos_118360110_xl-2015-1280x905.jpg";i:15;s:43:"Depositphotos_118360110_xl-2015-980x693.jpg";i:16;s:43:"Depositphotos_118360110_xl-2015-480x339.jpg";}s:12:"excludeSizes";a:0:{}s:10:"retinasOpt";i:0;s:8:"NoBackup";b:1;}s:21:"ShortPixelImprovement";s:5:"56.23";}');
INSERT INTO `wp5_postmeta` VALUES (1003,204293,'_wp_attached_file','2020/10/Depositphotos_118360110_xl-2015-1-scaled.jpg');
INSERT INTO `wp5_postmeta` VALUES (1004,204293,'_wp_attachment_metadata','a:8:{s:5:"width";i:2560;s:6:"height";i:1024;s:4:"file";s:52:"2020/10/Depositphotos_118360110_xl-2015-1-scaled.jpg";s:5:"sizes";a:16:{s:6:"medium";a:4:{s:4:"file";s:45:"Depositphotos_118360110_xl-2015-1-300x120.jpg";s:5:"width";i:300;s:6:"height";i:120;s:9:"mime-type";s:10:"image/jpeg";}s:5:"large";a:4:{s:4:"file";s:46:"Depositphotos_118360110_xl-2015-1-1024x410.jpg";s:5:"width";i:1024;s:6:"height";i:410;s:9:"mime-type";s:10:"image/jpeg";}s:9:"thumbnail";a:4:{s:4:"file";s:45:"Depositphotos_118360110_xl-2015-1-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:12:"medium_large";a:4:{s:4:"file";s:45:"Depositphotos_118360110_xl-2015-1-768x307.jpg";s:5:"width";i:768;s:6:"height";i:307;s:9:"mime-type";s:10:"image/jpeg";}s:9:"1536x1536";a:4:{s:4:"file";s:46:"Depositphotos_118360110_xl-2015-1-1536x614.jpg";s:5:"width";i:1536;s:6:"height";i:614;s:9:"mime-type";s:10:"image/jpeg";}s:9:"2048x2048";a:4:{s:4:"file";s:46:"Depositphotos_118360110_xl-2015-1-2048x819.jpg";s:5:"width";i:2048;s:6:"height";i:819;s:9:"mime-type";s:10:"image/jpeg";}s:21:"et-pb-post-main-image";a:4:{s:4:"file";s:45:"Depositphotos_118360110_xl-2015-1-400x250.jpg";s:5:"width";i:400;s:6:"height";i:250;s:9:"mime-type";s:10:"image/jpeg";}s:31:"et-pb-post-main-image-fullwidth";a:4:{s:4:"file";s:46:"Depositphotos_118360110_xl-2015-1-1080x675.jpg";s:5:"width";i:1080;s:6:"height";i:675;s:9:"mime-type";s:10:"image/jpeg";}s:21:"et-pb-portfolio-image";a:4:{s:4:"file";s:45:"Depositphotos_118360110_xl-2015-1-400x284.jpg";s:5:"width";i:400;s:6:"height";i:284;s:9:"mime-type";s:10:"image/jpeg";}s:28:"et-pb-portfolio-module-image";a:4:{s:4:"file";s:45:"Depositphotos_118360110_xl-2015-1-510x382.jpg";s:5:"width";i:510;s:6:"height";i:382;s:9:"mime-type";s:10:"image/jpeg";}s:28:"et-pb-portfolio-image-single";a:4:{s:4:"file";s:46:"Depositphotos_118360110_xl-2015-1-1080x432.jpg";s:5:"width";i:1080;s:6:"height";i:432;s:9:"mime-type";s:10:"image/jpeg";}s:35:"et-pb-gallery-module-image-portrait";a:4:{s:4:"file";s:45:"Depositphotos_118360110_xl-2015-1-400x516.jpg";s:5:"width";i:400;s:6:"height";i:516;s:9:"mime-type";s:10:"image/jpeg";}s:37:"et-pb-post-main-image-fullwidth-large";a:4:{s:4:"file";s:47:"Depositphotos_118360110_xl-2015-1-2880x1600.jpg";s:5:"width";i:2880;s:6:"height";i:1600;s:9:"mime-type";s:10:"image/jpeg";}s:32:"et-pb-image--responsive--desktop";a:4:{s:4:"file";s:46:"Depositphotos_118360110_xl-2015-1-1280x512.jpg";s:5:"width";i:1280;s:6:"height";i:512;s:9:"mime-type";s:10:"image/jpeg";}s:31:"et-pb-image--responsive--tablet";a:4:{s:4:"file";s:45:"Depositphotos_118360110_xl-2015-1-980x392.jpg";s:5:"width";i:980;s:6:"height";i:392;s:9:"mime-type";s:10:"image/jpeg";}s:30:"et-pb-image--responsive--phone";a:4:{s:4:"file";s:45:"Depositphotos_118360110_xl-2015-1-480x192.jpg";s:5:"width";i:480;s:6:"height";i:192;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:55:"sci-fi creative workspace,digital painting,illustration";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:55:"sci-fi creative workspace,digital painting,illustration";s:11:"orientation";s:1:"1";s:8:"keywords";a:35:{i:0;s:7:"acrylic";i:1;s:3:"art";i:2;s:8:"artistic";i:3;s:7:"artwork";i:4;s:12:"illustration";i:5;s:12:"oil painting";i:6;s:8:"painting";i:7;s:10:"watercolor";i:8;s:5:"cyber";i:9;s:7:"fiction";i:10;s:4:"desk";i:11;s:4:"room";i:12;s:10:"decoration";i:13;s:5:"table";i:14;s:4:"hack";i:15;s:5:"light";i:16;s:10:"technology";i:17;s:8:"computer";i:18;s:4:"wall";i:19;s:4:"work";i:20;s:5:"chair";i:21;s:9:"corporate";i:22;s:5:"vivid";i:23;s:7:"concept";i:24;s:9:"workspace";i:25;s:6:"studio";i:26;s:5:"shelf";i:27;s:6:"modern";i:28;s:7:"monitor";i:29;s:7:"science";i:30;s:8:"interior";i:31;s:6:"office";i:32;s:13:"communication";i:33;s:6:"sci-fi";i:34;s:9:"cyberpunk";}}s:14:"original_image";s:37:"Depositphotos_118360110_xl-2015-1.jpg";s:10:"ShortPixel";a:8:{s:4:"type";s:6:"glossy";s:8:"exifKept";s:1:"0";s:4:"date";s:19:"2020-10-22 15:42:33";s:9:"thumbsOpt";i:17;s:13:"thumbsOptList";a:17:{i:0;s:37:"Depositphotos_118360110_xl-2015-1.jpg";i:1;s:45:"Depositphotos_118360110_xl-2015-1-300x120.jpg";i:2;s:46:"Depositphotos_118360110_xl-2015-1-1024x410.jpg";i:3;s:45:"Depositphotos_118360110_xl-2015-1-150x150.jpg";i:4;s:45:"Depositphotos_118360110_xl-2015-1-768x307.jpg";i:5;s:46:"Depositphotos_118360110_xl-2015-1-1536x614.jpg";i:6;s:46:"Depositphotos_118360110_xl-2015-1-2048x819.jpg";i:7;s:45:"Depositphotos_118360110_xl-2015-1-400x250.jpg";i:8;s:46:"Depositphotos_118360110_xl-2015-1-1080x675.jpg";i:9;s:45:"Depositphotos_118360110_xl-2015-1-400x284.jpg";i:10;s:45:"Depositphotos_118360110_xl-2015-1-510x382.jpg";i:11;s:46:"Depositphotos_118360110_xl-2015-1-1080x432.jpg";i:12;s:45:"Depositphotos_118360110_xl-2015-1-400x516.jpg";i:13;s:47:"Depositphotos_118360110_xl-2015-1-2880x1600.jpg";i:14;s:46:"Depositphotos_118360110_xl-2015-1-1280x512.jpg";i:15;s:45:"Depositphotos_118360110_xl-2015-1-980x392.jpg";i:16;s:45:"Depositphotos_118360110_xl-2015-1-480x192.jpg";}s:12:"excludeSizes";a:0:{}s:10:"retinasOpt";i:0;s:8:"NoBackup";b:1;}s:21:"ShortPixelImprovement";s:5:"26.83";}');
INSERT INTO `wp5_postmeta` VALUES (1057,203944,'_edit_lock','1603382056:1');
INSERT INTO `wp5_postmeta` VALUES (1072,27888,'_et_pb_ab_subjects','');
INSERT INTO `wp5_postmeta` VALUES (1073,27888,'_et_pb_enable_shortcode_tracking','');
INSERT INTO `wp5_postmeta` VALUES (1074,27888,'_et_pb_ab_current_shortcode','[et_pb_split_track id="27888" /]');
INSERT INTO `wp5_postmeta` VALUES (1075,27888,'_et_pb_custom_css','');
INSERT INTO `wp5_postmeta` VALUES (1076,27888,'_et_pb_gutter_width','3');
INSERT INTO `wp5_postmeta` VALUES (1083,27888,'_et_pb_use_builder','on');
INSERT INTO `wp5_postmeta` VALUES (1078,27888,'_et_pb_first_image','');
INSERT INTO `wp5_postmeta` VALUES (1079,27888,'_et_pb_truncate_post','');
INSERT INTO `wp5_postmeta` VALUES (1080,27888,'_et_pb_truncate_post_date','');
INSERT INTO `wp5_postmeta` VALUES (1081,27888,'_et_builder_version','VB|Divi|4.6.6');
INSERT INTO `wp5_postmeta` VALUES (1082,27888,'_edit_last','1');
INSERT INTO `wp5_postmeta` VALUES (1084,27888,'_et_pb_old_content','');
INSERT INTO `wp5_postmeta` VALUES (1097,203938,'_et_pb_ab_subjects','');
INSERT INTO `wp5_postmeta` VALUES (1098,203938,'_et_pb_enable_shortcode_tracking','');
INSERT INTO `wp5_postmeta` VALUES (1099,203938,'_et_pb_ab_current_shortcode','[et_pb_split_track id="203938" /]');
INSERT INTO `wp5_postmeta` VALUES (1100,203938,'_et_pb_custom_css','');
INSERT INTO `wp5_postmeta` VALUES (1101,203938,'_et_pb_gutter_width','3');
INSERT INTO `wp5_postmeta` VALUES (1109,203938,'_et_pb_use_builder','on');
INSERT INTO `wp5_postmeta` VALUES (1103,203938,'_et_pb_first_image','');
INSERT INTO `wp5_postmeta` VALUES (1104,203938,'_et_pb_truncate_post','');
INSERT INTO `wp5_postmeta` VALUES (1105,203938,'_et_pb_truncate_post_date','');
INSERT INTO `wp5_postmeta` VALUES (1106,203938,'_et_builder_version','VB|Divi|4.6.6');
INSERT INTO `wp5_postmeta` VALUES (1107,203938,'_et_pb_show_page_creation','off');
INSERT INTO `wp5_postmeta` VALUES (1108,203938,'_edit_last','1');
INSERT INTO `wp5_postmeta` VALUES (1110,203938,'_et_pb_old_content','');
INSERT INTO `wp5_postmeta` VALUES (1116,203944,'_et_pb_gutter_width','3');
INSERT INTO `wp5_postmeta` VALUES (1121,203944,'_et_builder_version','VB|Divi|4.6.6');
INSERT INTO `wp5_postmeta` VALUES (1122,203944,'_et_pb_show_page_creation','off');
INSERT INTO `wp5_postmeta` VALUES (1123,203944,'_edit_last','1');
INSERT INTO `wp5_postmeta` VALUES (1126,203978,'_edit_lock','1603382333:1');
INSERT INTO `wp5_postmeta` VALUES (1128,203977,'_edit_lock','1603382217:1');
INSERT INTO `wp5_postmeta` VALUES (1132,141,'_edit_lock','1603383019:1');
INSERT INTO `wp5_postmeta` VALUES (1133,316,'_edit_lock','1603382439:1');
INSERT INTO `wp5_postmeta` VALUES (1669,204782,'_email','natehoffelder@gmail.com');
INSERT INTO `wp5_postmeta` VALUES (1670,204782,'_name','Nate Hoffelder');
INSERT INTO `wp5_postmeta` VALUES (1671,204782,'_props','a:2:{s:10:"first_name";s:4:"Nate";s:9:"last_name";s:9:"Hoffelder";}');
INSERT INTO `wp5_postmeta` VALUES (1672,204782,'_last_contacted','2020-11-26 23:09:09');
INSERT INTO `wp5_postmeta` VALUES (1146,203978,'_et_pb_ab_subjects','');
INSERT INTO `wp5_postmeta` VALUES (1147,203978,'_et_pb_enable_shortcode_tracking','');
INSERT INTO `wp5_postmeta` VALUES (1148,203978,'_et_pb_ab_current_shortcode','[et_pb_split_track id="203978" /]');
INSERT INTO `wp5_postmeta` VALUES (1149,203978,'_et_pb_custom_css','');
INSERT INTO `wp5_postmeta` VALUES (1150,203978,'_et_pb_gutter_width','3');
INSERT INTO `wp5_postmeta` VALUES (1158,203978,'_et_pb_use_builder','on');
INSERT INTO `wp5_postmeta` VALUES (1152,203978,'_et_pb_first_image','');
INSERT INTO `wp5_postmeta` VALUES (1153,203978,'_et_pb_truncate_post','');
INSERT INTO `wp5_postmeta` VALUES (1154,203978,'_et_pb_truncate_post_date','');
INSERT INTO `wp5_postmeta` VALUES (1155,203978,'_et_builder_version','VB|Divi|4.6.6');
INSERT INTO `wp5_postmeta` VALUES (1156,203978,'_et_pb_show_page_creation','off');
INSERT INTO `wp5_postmeta` VALUES (1157,203978,'_edit_last','1');
INSERT INTO `wp5_postmeta` VALUES (1159,203978,'_et_pb_old_content','');
INSERT INTO `wp5_postmeta` VALUES (1160,203977,'_et_pb_ab_subjects','');
INSERT INTO `wp5_postmeta` VALUES (1161,203977,'_et_pb_enable_shortcode_tracking','');
INSERT INTO `wp5_postmeta` VALUES (1162,203977,'_et_pb_ab_current_shortcode','[et_pb_split_track id="203977" /]');
INSERT INTO `wp5_postmeta` VALUES (1163,203977,'_et_pb_custom_css','');
INSERT INTO `wp5_postmeta` VALUES (1164,203977,'_et_pb_gutter_width','3');
INSERT INTO `wp5_postmeta` VALUES (1172,203977,'_et_pb_use_builder','on');
INSERT INTO `wp5_postmeta` VALUES (1166,203977,'_et_pb_first_image','');
INSERT INTO `wp5_postmeta` VALUES (1167,203977,'_et_pb_truncate_post','');
INSERT INTO `wp5_postmeta` VALUES (1168,203977,'_et_pb_truncate_post_date','');
INSERT INTO `wp5_postmeta` VALUES (1169,203977,'_et_builder_version','VB|Divi|4.6.6');
INSERT INTO `wp5_postmeta` VALUES (1170,203977,'_et_pb_show_page_creation','off');
INSERT INTO `wp5_postmeta` VALUES (1171,203977,'_edit_last','1');
INSERT INTO `wp5_postmeta` VALUES (1173,203977,'_et_pb_old_content','');
INSERT INTO `wp5_postmeta` VALUES (1177,141,'_et_pb_ab_subjects','');
INSERT INTO `wp5_postmeta` VALUES (1178,141,'_et_pb_enable_shortcode_tracking','');
INSERT INTO `wp5_postmeta` VALUES (1179,141,'_et_pb_ab_current_shortcode','[et_pb_split_track id="141" /]');
INSERT INTO `wp5_postmeta` VALUES (1180,141,'_et_pb_custom_css','');
INSERT INTO `wp5_postmeta` VALUES (1181,141,'_et_pb_gutter_width','3');
INSERT INTO `wp5_postmeta` VALUES (1189,141,'_et_pb_use_builder','on');
INSERT INTO `wp5_postmeta` VALUES (1183,141,'_et_pb_first_image','');
INSERT INTO `wp5_postmeta` VALUES (1184,141,'_et_pb_truncate_post','');
INSERT INTO `wp5_postmeta` VALUES (1185,141,'_et_pb_truncate_post_date','');
INSERT INTO `wp5_postmeta` VALUES (1186,141,'_et_builder_version','VB|Divi|4.6.6');
INSERT INTO `wp5_postmeta` VALUES (1187,141,'_et_pb_show_page_creation','off');
INSERT INTO `wp5_postmeta` VALUES (1188,141,'_edit_last','1');
INSERT INTO `wp5_postmeta` VALUES (1190,141,'_et_pb_old_content','');
INSERT INTO `wp5_postmeta` VALUES (1668,204781,'_last_contacted','2020-11-26 23:09:09');
INSERT INTO `wp5_postmeta` VALUES (1195,220,'_et_pb_ab_subjects','');
INSERT INTO `wp5_postmeta` VALUES (1196,220,'_et_pb_enable_shortcode_tracking','');
INSERT INTO `wp5_postmeta` VALUES (1197,220,'_et_pb_ab_current_shortcode','[et_pb_split_track id="220" /]');
INSERT INTO `wp5_postmeta` VALUES (1198,220,'_et_pb_custom_css','');
INSERT INTO `wp5_postmeta` VALUES (1199,220,'_et_pb_gutter_width','3');
INSERT INTO `wp5_postmeta` VALUES (1206,220,'_et_pb_use_builder','on');
INSERT INTO `wp5_postmeta` VALUES (1201,220,'_et_pb_first_image','');
INSERT INTO `wp5_postmeta` VALUES (1202,220,'_et_pb_truncate_post','');
INSERT INTO `wp5_postmeta` VALUES (1203,220,'_et_pb_truncate_post_date','');
INSERT INTO `wp5_postmeta` VALUES (1204,220,'_et_builder_version','VB|Divi|4.6.6');
INSERT INTO `wp5_postmeta` VALUES (1205,220,'_edit_last','1');
INSERT INTO `wp5_postmeta` VALUES (1207,220,'_et_pb_old_content','');
INSERT INTO `wp5_postmeta` VALUES (1667,204781,'_props','a:2:{s:10:"first_name";s:4:"Gary";s:9:"last_name";s:5:"Petty";}');
INSERT INTO `wp5_postmeta` VALUES (1211,204334,'_wp_attached_file','2020/04/58825083e81acb96424ffabd.png');
INSERT INTO `wp5_postmeta` VALUES (1212,204334,'_wp_attachment_metadata','a:7:{s:5:"width";i:2000;s:6:"height";i:376;s:4:"file";s:36:"2020/04/58825083e81acb96424ffabd.png";s:5:"sizes";a:14:{s:6:"medium";a:4:{s:4:"file";s:35:"58825083e81acb96424ffabd-300x56.png";s:5:"width";i:300;s:6:"height";i:56;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:37:"58825083e81acb96424ffabd-1024x193.png";s:5:"width";i:1024;s:6:"height";i:193;s:9:"mime-type";s:9:"image/png";}s:9:"thumbnail";a:4:{s:4:"file";s:36:"58825083e81acb96424ffabd-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:12:"medium_large";a:4:{s:4:"file";s:36:"58825083e81acb96424ffabd-768x144.png";s:5:"width";i:768;s:6:"height";i:144;s:9:"mime-type";s:9:"image/png";}s:9:"1536x1536";a:4:{s:4:"file";s:37:"58825083e81acb96424ffabd-1536x289.png";s:5:"width";i:1536;s:6:"height";i:289;s:9:"mime-type";s:9:"image/png";}s:21:"et-pb-post-main-image";a:4:{s:4:"file";s:36:"58825083e81acb96424ffabd-400x250.png";s:5:"width";i:400;s:6:"height";i:250;s:9:"mime-type";s:9:"image/png";}s:31:"et-pb-post-main-image-fullwidth";a:4:{s:4:"file";s:37:"58825083e81acb96424ffabd-1080x376.png";s:5:"width";i:1080;s:6:"height";i:376;s:9:"mime-type";s:9:"image/png";}s:21:"et-pb-portfolio-image";a:4:{s:4:"file";s:36:"58825083e81acb96424ffabd-400x284.png";s:5:"width";i:400;s:6:"height";i:284;s:9:"mime-type";s:9:"image/png";}s:28:"et-pb-portfolio-module-image";a:4:{s:4:"file";s:36:"58825083e81acb96424ffabd-510x376.png";s:5:"width";i:510;s:6:"height";i:376;s:9:"mime-type";s:9:"image/png";}s:28:"et-pb-portfolio-image-single";a:4:{s:4:"file";s:37:"58825083e81acb96424ffabd-1080x203.png";s:5:"width";i:1080;s:6:"height";i:203;s:9:"mime-type";s:9:"image/png";}s:35:"et-pb-gallery-module-image-portrait";a:4:{s:4:"file";s:36:"58825083e81acb96424ffabd-400x376.png";s:5:"width";i:400;s:6:"height";i:376;s:9:"mime-type";s:9:"image/png";}s:32:"et-pb-image--responsive--desktop";a:4:{s:4:"file";s:37:"58825083e81acb96424ffabd-1280x241.png";s:5:"width";i:1280;s:6:"height";i:241;s:9:"mime-type";s:9:"image/png";}s:31:"et-pb-image--responsive--tablet";a:4:{s:4:"file";s:36:"58825083e81acb96424ffabd-980x184.png";s:5:"width";i:980;s:6:"height";i:184;s:9:"mime-type";s:9:"image/png";}s:30:"et-pb-image--responsive--phone";a:4:{s:4:"file";s:35:"58825083e81acb96424ffabd-480x90.png";s:5:"width";i:480;s:6:"height";i:90;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}s:10:"ShortPixel";a:8:{s:4:"type";s:6:"glossy";s:8:"exifKept";s:1:"0";s:4:"date";s:19:"2020-10-22 17:30:49";s:9:"thumbsOpt";i:14;s:13:"thumbsOptList";a:14:{i:0;s:35:"58825083e81acb96424ffabd-300x56.png";i:1;s:37:"58825083e81acb96424ffabd-1024x193.png";i:2;s:36:"58825083e81acb96424ffabd-150x150.png";i:3;s:36:"58825083e81acb96424ffabd-768x144.png";i:4;s:37:"58825083e81acb96424ffabd-1536x289.png";i:5;s:36:"58825083e81acb96424ffabd-400x250.png";i:6;s:37:"58825083e81acb96424ffabd-1080x376.png";i:7;s:36:"58825083e81acb96424ffabd-400x284.png";i:8;s:36:"58825083e81acb96424ffabd-510x376.png";i:9;s:37:"58825083e81acb96424ffabd-1080x203.png";i:10;s:36:"58825083e81acb96424ffabd-400x376.png";i:11;s:37:"58825083e81acb96424ffabd-1280x241.png";i:12;s:36:"58825083e81acb96424ffabd-980x184.png";i:13;s:35:"58825083e81acb96424ffabd-480x90.png";}s:12:"excludeSizes";a:0:{}s:10:"retinasOpt";i:0;s:8:"NoBackup";b:1;}s:21:"ShortPixelImprovement";s:5:"91.35";}');
INSERT INTO `wp5_postmeta` VALUES (1213,204335,'_wp_attached_file','2020/04/download.png');
INSERT INTO `wp5_postmeta` VALUES (1214,204335,'_wp_attachment_metadata','a:7:{s:5:"width";i:534;s:6:"height";i:94;s:4:"file";s:20:"2020/04/download.png";s:5:"sizes";a:7:{s:6:"medium";a:4:{s:4:"file";s:19:"download-300x53.png";s:5:"width";i:300;s:6:"height";i:53;s:9:"mime-type";s:9:"image/png";}s:9:"thumbnail";a:4:{s:4:"file";s:19:"download-150x94.png";s:5:"width";i:150;s:6:"height";i:94;s:9:"mime-type";s:9:"image/png";}s:21:"et-pb-post-main-image";a:4:{s:4:"file";s:19:"download-400x94.png";s:5:"width";i:400;s:6:"height";i:94;s:9:"mime-type";s:9:"image/png";}s:21:"et-pb-portfolio-image";a:4:{s:4:"file";s:19:"download-400x94.png";s:5:"width";i:400;s:6:"height";i:94;s:9:"mime-type";s:9:"image/png";}s:28:"et-pb-portfolio-module-image";a:4:{s:4:"file";s:19:"download-510x94.png";s:5:"width";i:510;s:6:"height";i:94;s:9:"mime-type";s:9:"image/png";}s:35:"et-pb-gallery-module-image-portrait";a:4:{s:4:"file";s:19:"download-400x94.png";s:5:"width";i:400;s:6:"height";i:94;s:9:"mime-type";s:9:"image/png";}s:30:"et-pb-image--responsive--phone";a:4:{s:4:"file";s:19:"download-480x84.png";s:5:"width";i:480;s:6:"height";i:84;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}s:10:"ShortPixel";a:8:{s:4:"type";s:6:"glossy";s:8:"exifKept";s:1:"0";s:4:"date";s:19:"2020-10-22 17:30:38";s:9:"thumbsOpt";i:5;s:13:"thumbsOptList";a:5:{i:0;s:19:"download-300x53.png";i:1;s:19:"download-150x94.png";i:2;s:19:"download-400x94.png";i:3;s:19:"download-510x94.png";i:4;s:19:"download-480x84.png";}s:12:"excludeSizes";a:0:{}s:10:"retinasOpt";i:0;s:8:"NoBackup";b:1;}s:21:"ShortPixelImprovement";s:5:"71.01";}');
INSERT INTO `wp5_postmeta` VALUES (1215,204336,'_wp_attached_file','2020/04/3f343ffc604a6c839e31d3f052b78abfa34ab588.png');
INSERT INTO `wp5_postmeta` VALUES (1216,204336,'_wp_attachment_metadata','a:7:{s:5:"width";i:1080;s:6:"height";i:159;s:4:"file";s:52:"2020/04/3f343ffc604a6c839e31d3f052b78abfa34ab588.png";s:5:"sizes";a:10:{s:6:"medium";a:4:{s:4:"file";s:51:"3f343ffc604a6c839e31d3f052b78abfa34ab588-300x44.png";s:5:"width";i:300;s:6:"height";i:44;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:53:"3f343ffc604a6c839e31d3f052b78abfa34ab588-1024x151.png";s:5:"width";i:1024;s:6:"height";i:151;s:9:"mime-type";s:9:"image/png";}s:9:"thumbnail";a:4:{s:4:"file";s:52:"3f343ffc604a6c839e31d3f052b78abfa34ab588-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:12:"medium_large";a:4:{s:4:"file";s:52:"3f343ffc604a6c839e31d3f052b78abfa34ab588-768x113.png";s:5:"width";i:768;s:6:"height";i:113;s:9:"mime-type";s:9:"image/png";}s:21:"et-pb-post-main-image";a:4:{s:4:"file";s:52:"3f343ffc604a6c839e31d3f052b78abfa34ab588-400x159.png";s:5:"width";i:400;s:6:"height";i:159;s:9:"mime-type";s:9:"image/png";}s:21:"et-pb-portfolio-image";a:4:{s:4:"file";s:52:"3f343ffc604a6c839e31d3f052b78abfa34ab588-400x159.png";s:5:"width";i:400;s:6:"height";i:159;s:9:"mime-type";s:9:"image/png";}s:28:"et-pb-portfolio-module-image";a:4:{s:4:"file";s:52:"3f343ffc604a6c839e31d3f052b78abfa34ab588-510x159.png";s:5:"width";i:510;s:6:"height";i:159;s:9:"mime-type";s:9:"image/png";}s:35:"et-pb-gallery-module-image-portrait";a:4:{s:4:"file";s:52:"3f343ffc604a6c839e31d3f052b78abfa34ab588-400x159.png";s:5:"width";i:400;s:6:"height";i:159;s:9:"mime-type";s:9:"image/png";}s:31:"et-pb-image--responsive--tablet";a:4:{s:4:"file";s:52:"3f343ffc604a6c839e31d3f052b78abfa34ab588-980x144.png";s:5:"width";i:980;s:6:"height";i:144;s:9:"mime-type";s:9:"image/png";}s:30:"et-pb-image--responsive--phone";a:4:{s:4:"file";s:51:"3f343ffc604a6c839e31d3f052b78abfa34ab588-480x71.png";s:5:"width";i:480;s:6:"height";i:71;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}s:10:"ShortPixel";a:8:{s:4:"type";s:6:"glossy";s:8:"exifKept";s:1:"0";s:4:"date";s:19:"2020-10-22 17:30:28";s:9:"thumbsOpt";i:8;s:13:"thumbsOptList";a:8:{i:0;s:51:"3f343ffc604a6c839e31d3f052b78abfa34ab588-300x44.png";i:1;s:53:"3f343ffc604a6c839e31d3f052b78abfa34ab588-1024x151.png";i:2;s:52:"3f343ffc604a6c839e31d3f052b78abfa34ab588-150x150.png";i:3;s:52:"3f343ffc604a6c839e31d3f052b78abfa34ab588-768x113.png";i:4;s:52:"3f343ffc604a6c839e31d3f052b78abfa34ab588-400x159.png";i:5;s:52:"3f343ffc604a6c839e31d3f052b78abfa34ab588-510x159.png";i:6;s:52:"3f343ffc604a6c839e31d3f052b78abfa34ab588-980x144.png";i:7;s:51:"3f343ffc604a6c839e31d3f052b78abfa34ab588-480x71.png";}s:12:"excludeSizes";a:0:{}s:10:"retinasOpt";i:0;s:8:"NoBackup";b:1;}s:21:"ShortPixelImprovement";s:5:"81.64";}');
INSERT INTO `wp5_postmeta` VALUES (1693,204805,'_shortpixel_status','2.7800');
INSERT INTO `wp5_postmeta` VALUES (1219,204338,'_wp_attached_file','2020/04/guardian.jpg');
INSERT INTO `wp5_postmeta` VALUES (1220,204338,'_wp_attachment_metadata','a:7:{s:5:"width";i:1772;s:6:"height";i:1772;s:4:"file";s:20:"2020/04/guardian.jpg";s:5:"sizes";a:14:{s:6:"medium";a:4:{s:4:"file";s:20:"guardian-300x300.jpg";s:5:"width";i:300;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";}s:5:"large";a:4:{s:4:"file";s:22:"guardian-1024x1024.jpg";s:5:"width";i:1024;s:6:"height";i:1024;s:9:"mime-type";s:10:"image/jpeg";}s:9:"thumbnail";a:4:{s:4:"file";s:20:"guardian-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:12:"medium_large";a:4:{s:4:"file";s:20:"guardian-768x768.jpg";s:5:"width";i:768;s:6:"height";i:768;s:9:"mime-type";s:10:"image/jpeg";}s:9:"1536x1536";a:4:{s:4:"file";s:22:"guardian-1536x1536.jpg";s:5:"width";i:1536;s:6:"height";i:1536;s:9:"mime-type";s:10:"image/jpeg";}s:21:"et-pb-post-main-image";a:4:{s:4:"file";s:20:"guardian-400x250.jpg";s:5:"width";i:400;s:6:"height";i:250;s:9:"mime-type";s:10:"image/jpeg";}s:31:"et-pb-post-main-image-fullwidth";a:4:{s:4:"file";s:21:"guardian-1080x675.jpg";s:5:"width";i:1080;s:6:"height";i:675;s:9:"mime-type";s:10:"image/jpeg";}s:21:"et-pb-portfolio-image";a:4:{s:4:"file";s:20:"guardian-400x284.jpg";s:5:"width";i:400;s:6:"height";i:284;s:9:"mime-type";s:10:"image/jpeg";}s:28:"et-pb-portfolio-module-image";a:4:{s:4:"file";s:20:"guardian-510x382.jpg";s:5:"width";i:510;s:6:"height";i:382;s:9:"mime-type";s:10:"image/jpeg";}s:28:"et-pb-portfolio-image-single";a:4:{s:4:"file";s:22:"guardian-1080x1080.jpg";s:5:"width";i:1080;s:6:"height";i:1080;s:9:"mime-type";s:10:"image/jpeg";}s:35:"et-pb-gallery-module-image-portrait";a:4:{s:4:"file";s:20:"guardian-400x516.jpg";s:5:"width";i:400;s:6:"height";i:516;s:9:"mime-type";s:10:"image/jpeg";}s:32:"et-pb-image--responsive--desktop";a:4:{s:4:"file";s:22:"guardian-1280x1280.jpg";s:5:"width";i:1280;s:6:"height";i:1280;s:9:"mime-type";s:10:"image/jpeg";}s:31:"et-pb-image--responsive--tablet";a:4:{s:4:"file";s:20:"guardian-980x980.jpg";s:5:"width";i:980;s:6:"height";i:980;s:9:"mime-type";s:10:"image/jpeg";}s:30:"et-pb-image--responsive--phone";a:4:{s:4:"file";s:20:"guardian-480x480.jpg";s:5:"width";i:480;s:6:"height";i:480;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"1";s:8:"keywords";a:0:{}}s:10:"ShortPixel";a:8:{s:4:"type";s:6:"glossy";s:8:"exifKept";s:1:"0";s:4:"date";s:19:"2020-10-22 17:30:04";s:9:"thumbsOpt";i:14;s:13:"thumbsOptList";a:14:{i:0;s:20:"guardian-300x300.jpg";i:1;s:22:"guardian-1024x1024.jpg";i:2;s:20:"guardian-150x150.jpg";i:3;s:20:"guardian-768x768.jpg";i:4;s:22:"guardian-1536x1536.jpg";i:5;s:20:"guardian-400x250.jpg";i:6;s:21:"guardian-1080x675.jpg";i:7;s:20:"guardian-400x284.jpg";i:8;s:20:"guardian-510x382.jpg";i:9;s:22:"guardian-1080x1080.jpg";i:10;s:20:"guardian-400x516.jpg";i:11;s:22:"guardian-1280x1280.jpg";i:12;s:20:"guardian-980x980.jpg";i:13;s:20:"guardian-480x480.jpg";}s:12:"excludeSizes";a:0:{}s:10:"retinasOpt";i:0;s:8:"NoBackup";b:1;}s:21:"ShortPixelImprovement";s:5:"59.52";}');
INSERT INTO `wp5_postmeta` VALUES (1296,204388,'_wp_attached_file','2020/10/Page-Header-2560-x-512-pixels.jpg');
INSERT INTO `wp5_postmeta` VALUES (1297,204388,'_wp_attachment_metadata','a:7:{s:5:"width";i:2560;s:6:"height";i:512;s:4:"file";s:41:"2020/10/Page-Header-2560-x-512-pixels.jpg";s:5:"sizes";a:16:{s:6:"medium";a:4:{s:4:"file";s:40:"Page-Header-2560-x-512-pixels-300x60.jpg";s:5:"width";i:300;s:6:"height";i:60;s:9:"mime-type";s:10:"image/jpeg";}s:5:"large";a:4:{s:4:"file";s:42:"Page-Header-2560-x-512-pixels-1024x205.jpg";s:5:"width";i:1024;s:6:"height";i:205;s:9:"mime-type";s:10:"image/jpeg";}s:9:"thumbnail";a:4:{s:4:"file";s:41:"Page-Header-2560-x-512-pixels-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:12:"medium_large";a:4:{s:4:"file";s:41:"Page-Header-2560-x-512-pixels-768x154.jpg";s:5:"width";i:768;s:6:"height";i:154;s:9:"mime-type";s:10:"image/jpeg";}s:9:"1536x1536";a:4:{s:4:"file";s:42:"Page-Header-2560-x-512-pixels-1536x307.jpg";s:5:"width";i:1536;s:6:"height";i:307;s:9:"mime-type";s:10:"image/jpeg";}s:9:"2048x2048";a:4:{s:4:"file";s:42:"Page-Header-2560-x-512-pixels-2048x410.jpg";s:5:"width";i:2048;s:6:"height";i:410;s:9:"mime-type";s:10:"image/jpeg";}s:11:"bloom_image";a:4:{s:4:"file";s:41:"Page-Header-2560-x-512-pixels-610x122.jpg";s:5:"width";i:610;s:6:"height";i:122;s:9:"mime-type";s:10:"image/jpeg";}s:21:"et-pb-post-main-image";a:4:{s:4:"file";s:41:"Page-Header-2560-x-512-pixels-400x250.jpg";s:5:"width";i:400;s:6:"height";i:250;s:9:"mime-type";s:10:"image/jpeg";}s:31:"et-pb-post-main-image-fullwidth";a:4:{s:4:"file";s:42:"Page-Header-2560-x-512-pixels-1080x512.jpg";s:5:"width";i:1080;s:6:"height";i:512;s:9:"mime-type";s:10:"image/jpeg";}s:21:"et-pb-portfolio-image";a:4:{s:4:"file";s:41:"Page-Header-2560-x-512-pixels-400x284.jpg";s:5:"width";i:400;s:6:"height";i:284;s:9:"mime-type";s:10:"image/jpeg";}s:28:"et-pb-portfolio-module-image";a:4:{s:4:"file";s:41:"Page-Header-2560-x-512-pixels-510x382.jpg";s:5:"width";i:510;s:6:"height";i:382;s:9:"mime-type";s:10:"image/jpeg";}s:28:"et-pb-portfolio-image-single";a:4:{s:4:"file";s:42:"Page-Header-2560-x-512-pixels-1080x216.jpg";s:5:"width";i:1080;s:6:"height";i:216;s:9:"mime-type";s:10:"image/jpeg";}s:35:"et-pb-gallery-module-image-portrait";a:4:{s:4:"file";s:41:"Page-Header-2560-x-512-pixels-400x512.jpg";s:5:"width";i:400;s:6:"height";i:512;s:9:"mime-type";s:10:"image/jpeg";}s:32:"et-pb-image--responsive--desktop";a:4:{s:4:"file";s:42:"Page-Header-2560-x-512-pixels-1280x256.jpg";s:5:"width";i:1280;s:6:"height";i:256;s:9:"mime-type";s:10:"image/jpeg";}s:31:"et-pb-image--responsive--tablet";a:4:{s:4:"file";s:41:"Page-Header-2560-x-512-pixels-980x196.jpg";s:5:"width";i:980;s:6:"height";i:196;s:9:"mime-type";s:10:"image/jpeg";}s:30:"et-pb-image--responsive--phone";a:4:{s:4:"file";s:40:"Page-Header-2560-x-512-pixels-480x96.jpg";s:5:"width";i:480;s:6:"height";i:96;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"1";s:8:"keywords";a:0:{}}s:10:"ShortPixel";a:8:{s:4:"type";s:6:"glossy";s:8:"exifKept";s:1:"0";s:4:"date";s:19:"2020-10-30 00:31:24";s:9:"thumbsOpt";i:16;s:13:"thumbsOptList";a:16:{i:0;s:40:"Page-Header-2560-x-512-pixels-300x60.jpg";i:1;s:42:"Page-Header-2560-x-512-pixels-1024x205.jpg";i:2;s:41:"Page-Header-2560-x-512-pixels-150x150.jpg";i:3;s:41:"Page-Header-2560-x-512-pixels-768x154.jpg";i:4;s:42:"Page-Header-2560-x-512-pixels-1536x307.jpg";i:5;s:42:"Page-Header-2560-x-512-pixels-2048x410.jpg";i:6;s:41:"Page-Header-2560-x-512-pixels-610x122.jpg";i:7;s:41:"Page-Header-2560-x-512-pixels-400x250.jpg";i:8;s:42:"Page-Header-2560-x-512-pixels-1080x512.jpg";i:9;s:41:"Page-Header-2560-x-512-pixels-400x284.jpg";i:10;s:41:"Page-Header-2560-x-512-pixels-510x382.jpg";i:11;s:42:"Page-Header-2560-x-512-pixels-1080x216.jpg";i:12;s:41:"Page-Header-2560-x-512-pixels-400x512.jpg";i:13;s:42:"Page-Header-2560-x-512-pixels-1280x256.jpg";i:14;s:41:"Page-Header-2560-x-512-pixels-980x196.jpg";i:15;s:40:"Page-Header-2560-x-512-pixels-480x96.jpg";}s:12:"excludeSizes";a:0:{}s:10:"retinasOpt";i:0;s:8:"NoBackup";b:1;}s:21:"ShortPixelImprovement";s:4:"30.3";}');
INSERT INTO `wp5_postmeta` VALUES (1263,204370,'_menu_item_menu_item_parent','204973');
INSERT INTO `wp5_postmeta` VALUES (1264,204370,'_menu_item_object_id','204351');
INSERT INTO `wp5_postmeta` VALUES (1265,204370,'_menu_item_object','page');
INSERT INTO `wp5_postmeta` VALUES (1266,204370,'_menu_item_target','');
INSERT INTO `wp5_postmeta` VALUES (1267,204370,'_menu_item_classes','a:1:{i:0;s:0:"";}');
INSERT INTO `wp5_postmeta` VALUES (1268,204370,'_menu_item_xfn','');
INSERT INTO `wp5_postmeta` VALUES (1269,204370,'_menu_item_url','');
INSERT INTO `wp5_postmeta` VALUES (1262,204370,'_menu_item_type','post_type');
INSERT INTO `wp5_postmeta` VALUES (1225,204336,'_shortpixel_status','2.8100');
INSERT INTO `wp5_postmeta` VALUES (1226,204335,'_shortpixel_status','2.7100');
INSERT INTO `wp5_postmeta` VALUES (1227,204334,'_shortpixel_status','2.9100');
INSERT INTO `wp5_postmeta` VALUES (1230,204350,'_wp_attached_file','2020/10/Gibson.jpg');
INSERT INTO `wp5_postmeta` VALUES (1231,204350,'_wp_attachment_metadata','a:7:{s:5:"width";i:1500;s:6:"height";i:300;s:4:"file";s:18:"2020/10/Gibson.jpg";s:5:"sizes";a:13:{s:6:"medium";a:4:{s:4:"file";s:17:"Gibson-300x60.jpg";s:5:"width";i:300;s:6:"height";i:60;s:9:"mime-type";s:10:"image/jpeg";}s:5:"large";a:4:{s:4:"file";s:19:"Gibson-1024x205.jpg";s:5:"width";i:1024;s:6:"height";i:205;s:9:"mime-type";s:10:"image/jpeg";}s:9:"thumbnail";a:4:{s:4:"file";s:18:"Gibson-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:12:"medium_large";a:4:{s:4:"file";s:18:"Gibson-768x154.jpg";s:5:"width";i:768;s:6:"height";i:154;s:9:"mime-type";s:10:"image/jpeg";}s:21:"et-pb-post-main-image";a:4:{s:4:"file";s:18:"Gibson-400x250.jpg";s:5:"width";i:400;s:6:"height";i:250;s:9:"mime-type";s:10:"image/jpeg";}s:31:"et-pb-post-main-image-fullwidth";a:4:{s:4:"file";s:19:"Gibson-1080x300.jpg";s:5:"width";i:1080;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";}s:21:"et-pb-portfolio-image";a:4:{s:4:"file";s:18:"Gibson-400x284.jpg";s:5:"width";i:400;s:6:"height";i:284;s:9:"mime-type";s:10:"image/jpeg";}s:28:"et-pb-portfolio-module-image";a:4:{s:4:"file";s:18:"Gibson-510x300.jpg";s:5:"width";i:510;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";}s:28:"et-pb-portfolio-image-single";a:4:{s:4:"file";s:19:"Gibson-1080x216.jpg";s:5:"width";i:1080;s:6:"height";i:216;s:9:"mime-type";s:10:"image/jpeg";}s:35:"et-pb-gallery-module-image-portrait";a:4:{s:4:"file";s:18:"Gibson-400x300.jpg";s:5:"width";i:400;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";}s:32:"et-pb-image--responsive--desktop";a:4:{s:4:"file";s:19:"Gibson-1280x256.jpg";s:5:"width";i:1280;s:6:"height";i:256;s:9:"mime-type";s:10:"image/jpeg";}s:31:"et-pb-image--responsive--tablet";a:4:{s:4:"file";s:18:"Gibson-980x196.jpg";s:5:"width";i:980;s:6:"height";i:196;s:9:"mime-type";s:10:"image/jpeg";}s:30:"et-pb-image--responsive--phone";a:4:{s:4:"file";s:17:"Gibson-480x96.jpg";s:5:"width";i:480;s:6:"height";i:96;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"1";s:8:"keywords";a:0:{}}s:10:"ShortPixel";a:8:{s:4:"type";s:6:"glossy";s:8:"exifKept";s:1:"0";s:4:"date";s:19:"2020-10-22 18:55:31";s:9:"thumbsOpt";i:13;s:13:"thumbsOptList";a:13:{i:0;s:17:"Gibson-300x60.jpg";i:1;s:19:"Gibson-1024x205.jpg";i:2;s:18:"Gibson-150x150.jpg";i:3;s:18:"Gibson-768x154.jpg";i:4;s:18:"Gibson-400x250.jpg";i:5;s:19:"Gibson-1080x300.jpg";i:6;s:18:"Gibson-400x284.jpg";i:7;s:18:"Gibson-510x300.jpg";i:8;s:19:"Gibson-1080x216.jpg";i:9;s:18:"Gibson-400x300.jpg";i:10;s:19:"Gibson-1280x256.jpg";i:11;s:18:"Gibson-980x196.jpg";i:12;s:17:"Gibson-480x96.jpg";}s:12:"excludeSizes";a:0:{}s:10:"retinasOpt";i:0;s:8:"NoBackup";b:1;}s:21:"ShortPixelImprovement";s:5:"29.66";}');
INSERT INTO `wp5_postmeta` VALUES (1232,204350,'_shortpixel_status','2.2900');
INSERT INTO `wp5_postmeta` VALUES (1233,204351,'_edit_last','3');
INSERT INTO `wp5_postmeta` VALUES (1234,204351,'_edit_lock','1693165816:3');
INSERT INTO `wp5_postmeta` VALUES (1235,204351,'_wp_page_template','default');
INSERT INTO `wp5_postmeta` VALUES (1236,204351,'_et_pb_post_hide_nav','default');
INSERT INTO `wp5_postmeta` VALUES (1237,204351,'_et_pb_page_layout','et_right_sidebar');
INSERT INTO `wp5_postmeta` VALUES (1238,204351,'_et_pb_side_nav','off');
INSERT INTO `wp5_postmeta` VALUES (1239,204351,'_et_pb_use_builder','on');
INSERT INTO `wp5_postmeta` VALUES (1240,204351,'_et_pb_first_image','');
INSERT INTO `wp5_postmeta` VALUES (1241,204351,'_et_pb_truncate_post','<p><div class="et_pb_section et_pb_section_3 book-page-title-section et_pb_with_background et_section_regular" >\n				\n				\n				\n				\n					<div class="et_pb_with_border et_pb_row et_pb_row_3 et_animated">\n				<div class="et_pb_column et_pb_column_4_4 et_pb_column_4  et_pb_css_mix_blend_mode_passthrough et-last-child">\n				\n				\n				<div class="et_pb_module et_pb_text et_pb_text_2 book-page-title  et_pb_text_align_left et_pb_bg_layout_dark">\n				\n				\n				<div class="et_pb_text_inner">A Book</div>\n			</div> <!-- .et_pb_text -->\n			</div> <!-- .et_pb_column -->\n				\n				\n			</div> <!-- .et_pb_row -->\n				\n				\n			</div> <!-- .et_pb_section --><div class="et_pb_section et_pb_section_4 book-page-content-section et_section_regular" >\n				\n				\n				\n				\n					<div class="et_pb_row et_pb_row_4">\n				<div class="et_pb_column et_pb_column_2_5 et_pb_column_5  et_pb_css_mix_blend_mode_passthrough">\n				\n				\n				<div class="et_pb_module et_pb_image et_pb_image_0 book-page-content-image">\n				\n				\n				<span class="et_pb_image_wrap "><img loading="lazy" src="https://gibson.authorwebsiteinabox.com/wp-content/uploads/2020/10/book-cover-generic-642x1024.jpg" alt="" title="book cover generic" height="auto" width="auto" class="wp-image-28142" /></span>\n			</div>\n			</div> <!-- .et_pb_column --><div class="et_pb_column et_pb_column_3_5 et_pb_column_6 pa-inline-buttons  et_pb_css_mix_blend_mode_passthrough et-last-child">\n				\n				\n				<div class="et_pb_module et_pb_text et_pb_text_3 book-page-content-text  et_pb_text_align_left et_pb_bg_layout_light">\n				\n				\n				<div class="et_pb_text_inner">A catchy first sentence, in bold.<br />\nThis is where you might put the blurb from your Amazon listing.</p>\n<p>Your content goes here. Edit or remove this text inline or in the module Content settings. You can also style every aspect of this content in the module Design settings and even apply custom CSS to this text in the module Advanced settings.</p>\n<p>Your content goes here. Edit or remove this text inline or in the module Content settings. You can also style every aspect of this content in the module Design settings and even apply custom CSS to this text in the module Advanced settings.</p>\n<p>Your content goes here. Edit or remove this text inline or in the module Content settings. You can also style every aspect of this content in the module Design settings and even apply custom CSS to this text in the module Advanced settings.</div>\n			</div> <!-- .et_pb_text --><div class="et_pb_button_module_wrapper et_pb_button_0_wrapper  et_pb_module ">\n				<a id="pa-inline-buttons" class="et_pb_button et_pb_button_0 pa-inline-buttons book-page-content-button et_pb_bg_layout_light" href="">bookstore 1</a>\n			</div><div class="et_pb_button_module_wrapper et_pb_button_1_wrapper  et_pb_module ">\n				<a id="pa-inline-buttons" class="et_pb_button et_pb_button_1 pa-inline-buttons book-page-content-button et_pb_bg_layout_light" href="">bookstore 2</a>\n			</div><div class="et_pb_button_module_wrapper et_pb_button_2_wrapper  et_pb_module ">\n				<a id="pa-inline-buttons" class="et_pb_button et_pb_button_2 pa-inline-buttons book-page-content-button et_pb_bg_layout_light" href="">bookstore 3</a>\n			</div><div class="et_pb_button_module_wrapper et_pb_button_3_wrapper  et_pb_module ">\n				<a id="pa-inline-buttons" class="et_pb_button et_pb_button_3 pa-inline-buttons book-page-content-button et_pb_bg_layout_light" href="">bookstore 4</a>\n			</div>\n			</div> <!-- .et_pb_column -->\n				\n				\n			</div> <!-- .et_pb_row -->\n				\n				\n			</div> <!-- .et_pb_section --><div class="et_pb_section et_pb_section_5 book-page-reviews-section et_section_regular" >\n				\n				\n				\n				\n					<div class="et_pb_row et_pb_row_5">\n				<div class="et_pb_column et_pb_column_4_4 et_pb_column_7  et_pb_css_mix_blend_mode_passthrough et-last-child">\n				\n				\n				<div class="et_pb_module et_pb_text et_pb_text_4 book-page-reviews-text  et_pb_text_align_left et_pb_bg_layout_light">\n				\n				\n				<div class="et_pb_text_inner">Reviews</div>\n			</div> <!-- .et_pb_text -->\n			</div> <!-- .et_pb_column -->\n				\n				\n			</div> <!-- .et_pb_row --><div class="et_pb_row et_pb_row_6">\n				<div class="et_pb_column et_pb_column_1_3 et_pb_column_8  et_pb_css_mix_blend_mode_passthrough">\n				\n				\n				<div class="et_pb_module et_pb_testimonial et_pb_testimonial_0 book-page-reviews-quote clearfix  et_pb_text_align_left et_pb_bg_layout_light et_pb_testimonial_no_image">\n				\n				\n				\n				<div class="et_pb_testimonial_description">\n					<div class="et_pb_testimonial_description_inner"><div class="et_pb_testimonial_content">Your content goes here. Edit or remove this text inline or in the module Content settings. You can also style every aspect of this content in the module Design settings and even apply custom CSS to this text in the module Advanced settings.</div></div> <!-- .et_pb_testimonial_description_inner -->\n					<span class="et_pb_testimonial_author">Name Goes Here</span>\n					<p class="et_pb_testimonial_meta"></p>\n				</div> <!-- .et_pb_testimonial_description -->\n			</div> <!-- .et_pb_testimonial -->\n			</div> <!-- .et_pb_column --><div class="et_pb_column et_pb_column_1_3 et_pb_column_9  et_pb_css_mix_blend_mode_passthrough">\n				\n				\n				<div class="et_pb_module et_pb_testimonial et_pb_testimonial_1 book-page-reviews-quote clearfix  et_pb_text_align_left et_pb_bg_layout_light et_pb_testimonial_no_image">\n				\n				\n				\n				<div class="et_pb_testimonial_description">\n					<div class="et_pb_testimonial_description_inner"><div class="et_pb_testimonial_content">Your content goes here. Edit or remove this text inline or in the module Content settings. You can also style every aspect of this content in the module Design settings and even apply custom CSS to this text in the module Advanced settings.</div></div> <!-- .et_pb_testimonial_description_inner -->\n					<span class="et_pb_testimonial_author">Name Goes Here</span>\n					<p class="et_pb_testimonial_meta"></p>\n				</div> <!-- .et_pb_testimonial_description -->\n			</div> <!-- .et_pb_testimonial -->\n			</div> <!-- .et_pb_column --><div class="et_pb_column et_pb_column_1_3 et_pb_column_10  et_pb_css_mix_blend_mode_passthrough et-last-child">\n				\n				\n				<div class="et_pb_module et_pb_testimonial et_pb_testimonial_2 book-page-reviews-quote clearfix  et_pb_text_align_left et_pb_bg_layout_light et_pb_testimonial_no_image">\n				\n				\n				\n				<div class="et_pb_testimonial_description">\n					<div class="et_pb_testimonial_description_inner"><div class="et_pb_testimonial_content">Your content goes here. Edit or remove this text inline or in the module Content settings. You can also style every aspect of this content in the module Design settings and even apply custom CSS to this text in the module Advanced settings.</div></div> <!-- .et_pb_testimonial_description_inner -->\n					<span class="et_pb_testimonial_author">Name Goes Here</span>\n					<p class="et_pb_testimonial_meta"></p>\n				</div> <!-- .et_pb_testimonial_description -->\n			</div> <!-- .et_pb_testimonial -->\n			</div> <!-- .et_pb_column -->\n				\n				\n			</div> <!-- .et_pb_row -->\n				\n				\n			</div> <!-- .et_pb_section --><div class="et_pb_section et_pb_section_6 book-page-other-section et_section_regular" >\n				\n				\n				\n				\n					<div class="et_pb_row et_pb_row_7">\n				<div class="et_pb_column et_pb_column_4_4 et_pb_column_11  et_pb_css_mix_blend_mode_passthrough et-last-child">\n				\n				\n				<div class="et_pb_module et_pb_text et_pb_text_5 book-page-other-text  et_pb_text_align_left et_pb_bg_layout_light">\n				\n				\n				<div class="et_pb_text_inner">Other Books in this series</div>\n			</div> <!-- .et_pb_text -->\n			</div> <!-- .et_pb_column -->\n				\n				\n			</div> <!-- .et_pb_row --><div class="et_pb_row et_pb_row_8">\n				<div class="et_pb_column et_pb_column_1_4 et_pb_column_12  et_pb_css_mix_blend_mode_passthrough">\n				\n				\n				<div class="et_pb_module et_pb_image et_pb_image_1 book-page-other-image et_animated et-waypoint">\n				\n				\n				<span class="et_pb_image_wrap has-box-shadow-overlay"><div class="box-shadow-overlay"></div><img loading="lazy" src="https://gibson.authorwebsiteinabox.com/wp-content/uploads/2020/10/book-cover-generic.jpg" alt="" title="book cover generic" height="auto" width="auto" srcset="https://gibson.authorwebsiteinabox.com/wp-content/uploads/2020/10/book-cover-generic.jpg 1410w, https://gibson.authorwebsiteinabox.com/wp-content/uploads/2020/10/book-cover-generic-1280x2043.jpg 1280w, https://gibson.authorwebsiteinabox.com/wp-content/uploads/2020/10/book-cover-generic-980x1564.jpg 980w, https://gibson.authorwebsiteinabox.com/wp-content/uploads/2020/10/book-cover-generic-480x766.jpg 480w" sizes="(min-width: 0px) and (max-width: 480px) 480px, (min-width: 481px) and (max-width: 980px) 980px, (min-width: 981px) and (max-width: 1280px) 1280px, (min-width: 1281px) 1410px, 100vw" class="wp-image-28142" /></span>\n			</div><div class="et_pb_module et_pb_text et_pb_text_6 book-page-other-text et_animated  et_pb_text_align_center et_pb_bg_layout_light">\n				\n				\n				<div class="et_pb_text_inner">Book title<br />\nbrief book blurb</div>\n			</div> <!-- .et_pb_text --><div class="et_pb_button_module_wrapper et_pb_button_4_wrapper et_pb_button_alignment_center et_pb_module ">\n				<a id="book-page-other-button" class="et_pb_button et_pb_button_4 book-page-other-button et_animated et_hover_enabled et_pb_bg_layout_light" href="">Read More</a>\n			</div>\n			</div> <!-- .et_pb_column --><div class="et_pb_column et_pb_column_1_4 et_pb_column_13  et_pb_css_mix_blend_mode_passthrough">\n				\n				\n				<div class="et_pb_module et_pb_image et_pb_image_2 book-page-other-image et_animated et-waypoint">\n				\n				\n				<span class="et_pb_image_wrap has-box-shadow-overlay"><div class="box-shadow-overlay"></div><img loading="lazy" src="https://gibson.authorwebsiteinabox.com/wp-content/uploads/2020/10/book-cover-generic.jpg" alt="" title="book cover generic" height="auto" width="auto" srcset="https://gibson.authorwebsiteinabox.com/wp-content/uploads/2020/10/book-cover-generic.jpg 1410w, https://gibson.authorwebsiteinabox.com/wp-content/uploads/2020/10/book-cover-generic-1280x2043.jpg 1280w, https://gibson.authorwebsiteinabox.com/wp-content/uploads/2020/10/book-cover-generic-980x1564.jpg 980w, https://gibson.authorwebsiteinabox.com/wp-content/uploads/2020/10/book-cover-generic-480x766.jpg 480w" sizes="(min-width: 0px) and (max-width: 480px) 480px, (min-width: 481px) and (max-width: 980px) 980px, (min-width: 981px) and (max-width: 1280px) 1280px, (min-width: 1281px) 1410px, 100vw" class="wp-image-28142" /></span>\n			</div><div class="et_pb_module et_pb_text et_pb_text_7 book-page-other-text et_animated  et_pb_text_align_center et_pb_bg_layout_light">\n				\n				\n				<div class="et_pb_text_inner">Book title<br />\nbrief book blurb</div>\n			</div> <!-- .et_pb_text --><div class="et_pb_button_module_wrapper et_pb_button_5_wrapper et_pb_button_alignment_center et_pb_module ">\n				<a id="book-page-other-button" class="et_pb_button et_pb_button_5 book-page-other-button et_animated et_hover_enabled et_pb_bg_layout_light" href="">Read More</a>\n			</div>\n			</div> <!-- .et_pb_column --><div class="et_pb_column et_pb_column_1_4 et_pb_column_14  et_pb_css_mix_blend_mode_passthrough">\n				\n				\n				<div class="et_pb_module et_pb_image et_pb_image_3 book-page-other-image et_animated et-waypoint">\n				\n				\n				<span class="et_pb_image_wrap has-box-shadow-overlay"><div class="box-shadow-overlay"></div><img loading="lazy" src="https://gibson.authorwebsiteinabox.com/wp-content/uploads/2020/10/book-cover-generic.jpg" alt="" title="book cover generic" height="auto" width="auto" srcset="https://gibson.authorwebsiteinabox.com/wp-content/uploads/2020/10/book-cover-generic.jpg 1410w, https://gibson.authorwebsiteinabox.com/wp-content/uploads/2020/10/book-cover-generic-1280x2043.jpg 1280w, https://gibson.authorwebsiteinabox.com/wp-content/uploads/2020/10/book-cover-generic-980x1564.jpg 980w, https://gibson.authorwebsiteinabox.com/wp-content/uploads/2020/10/book-cover-generic-480x766.jpg 480w" sizes="(min-width: 0px) and (max-width: 480px) 480px, (min-width: 481px) and (max-width: 980px) 980px, (min-width: 981px) and (max-width: 1280px) 1280px, (min-width: 1281px) 1410px, 100vw" class="wp-image-28142" /></span>\n			</div><div class="et_pb_module et_pb_text et_pb_text_8 book-page-other-text et_animated  et_pb_text_align_center et_pb_bg_layout_light">\n				\n				\n				<div class="et_pb_text_inner">Book title<br />\nbrief book blurb</div>\n			</div> <!-- .et_pb_text --><div class="et_pb_button_module_wrapper et_pb_button_6_wrapper et_pb_button_alignment_center et_pb_module ">\n				<a id="book-page-other-button" class="et_pb_button et_pb_button_6 book-page-other-button et_animated et_hover_enabled et_pb_bg_layout_light" href="">Read More</a>\n			</div>\n			</div> <!-- .et_pb_column --><div class="et_pb_column et_pb_column_1_4 et_pb_column_15  et_pb_css_mix_blend_mode_passthrough et-last-child">\n				\n				\n				<div class="et_pb_module et_pb_image et_pb_image_4 book-page-other-image et_animated et-waypoint">\n				\n				\n				<span class="et_pb_image_wrap has-box-shadow-overlay"><div class="box-shadow-overlay"></div><img loading="lazy" src="https://gibson.authorwebsiteinabox.com/wp-content/uploads/2020/10/book-cover-generic.jpg" alt="" title="book cover generic" height="auto" width="auto" srcset="https://gibson.authorwebsiteinabox.com/wp-content/uploads/2020/10/book-cover-generic.jpg 1410w, https://gibson.authorwebsiteinabox.com/wp-content/uploads/2020/10/book-cover-generic-1280x2043.jpg 1280w, https://gibson.authorwebsiteinabox.com/wp-content/uploads/2020/10/book-cover-generic-980x1564.jpg 980w, https://gibson.authorwebsiteinabox.com/wp-content/uploads/2020/10/book-cover-generic-480x766.jpg 480w" sizes="(min-width: 0px) and (max-width: 480px) 480px, (min-width: 481px) and (max-width: 980px) 980px, (min-width: 981px) and (max-width: 1280px) 1280px, (min-width: 1281px) 1410px, 100vw" class="wp-image-28142" /></span>\n			</div><div class="et_pb_module et_pb_text et_pb_text_9 book-page-other-text et_animated  et_pb_text_align_center et_pb_bg_layout_light">\n				\n				\n				<div class="et_pb_text_inner">Book title<br />\nbrief book blurb</div>\n			</div> <!-- .et_pb_text --><div class="et_pb_button_module_wrapper et_pb_button_7_wrapper et_pb_button_alignment_center et_pb_module ">\n				<a id="book-page-other-button" class="et_pb_button et_pb_button_7 book-page-other-button et_animated et_hover_enabled et_pb_bg_layout_light" href="">Read More</a>\n			</div>\n			</div> <!-- .et_pb_column -->\n				\n				\n			</div> <!-- .et_pb_row -->\n				\n				\n			</div> <!-- .et_pb_section --></p>\n');
INSERT INTO `wp5_postmeta` VALUES (1242,204351,'_et_pb_truncate_post_date','2021-12-05 17:50:37');
INSERT INTO `wp5_postmeta` VALUES (1243,204351,'_et_pb_old_content','');
INSERT INTO `wp5_postmeta` VALUES (1780,204839,'_wp_old_date','2021-03-22');
INSERT INTO `wp5_postmeta` VALUES (1789,204189,'_et_builder_dynamic_assets_loading_attr_threshold','5');
INSERT INTO `wp5_postmeta` VALUES (2627,204991,'_et_pb_ab_subjects','');
INSERT INTO `wp5_postmeta` VALUES (2628,204991,'_et_pb_ab_current_shortcode','[et_pb_split_track id="204991" /]');
INSERT INTO `wp5_postmeta` VALUES (2629,204991,'_thumbnail_id','0');
INSERT INTO `wp5_postmeta` VALUES (2630,204991,'_global_colors_info','{}');
INSERT INTO `wp5_postmeta` VALUES (2594,204991,'_et_pb_use_builder','on');
INSERT INTO `wp5_postmeta` VALUES (2595,204991,'_et_pb_show_page_creation','off');
INSERT INTO `wp5_postmeta` VALUES (2596,204991,'_et_pb_built_for_post_type','page');
INSERT INTO `wp5_postmeta` VALUES (2597,204991,'_et_pb_enable_shortcode_tracking','');
INSERT INTO `wp5_postmeta` VALUES (2598,204991,'_et_pb_custom_css','');
INSERT INTO `wp5_postmeta` VALUES (2599,204991,'_et_pb_gutter_width','3');
INSERT INTO `wp5_postmeta` VALUES (2600,204991,'_et_pb_first_image','');
INSERT INTO `wp5_postmeta` VALUES (2601,204991,'_et_pb_truncate_post','');
INSERT INTO `wp5_postmeta` VALUES (2602,204991,'_et_pb_truncate_post_date','');
INSERT INTO `wp5_postmeta` VALUES (2603,204991,'_et_builder_version','VB|Divi|4.17.6');
INSERT INTO `wp5_postmeta` VALUES (2606,204992,'_et_autogenerated_title','1');
INSERT INTO `wp5_postmeta` VALUES (2607,204992,'_et_default','0');
INSERT INTO `wp5_postmeta` VALUES (2608,204992,'_et_enabled','1');
INSERT INTO `wp5_postmeta` VALUES (2609,204992,'_et_header_layout_id','0');
INSERT INTO `wp5_postmeta` VALUES (2610,204992,'_et_header_layout_enabled','1');
INSERT INTO `wp5_postmeta` VALUES (2611,204992,'_et_body_layout_id','204991');
INSERT INTO `wp5_postmeta` VALUES (2612,204992,'_et_body_layout_enabled','1');
INSERT INTO `wp5_postmeta` VALUES (2613,204992,'_et_footer_layout_id','0');
INSERT INTO `wp5_postmeta` VALUES (2614,204992,'_et_footer_layout_enabled','1');
INSERT INTO `wp5_postmeta` VALUES (2615,204992,'_et_use_on','singular:post_type:post:all');
INSERT INTO `wp5_postmeta` VALUES (2620,28149,'_et_theme_builder_marked_as_unused','2022-07-22 20:06:23');
INSERT INTO `wp5_postmeta` VALUES (2621,204808,'_thumbnail_id','0');
INSERT INTO `wp5_postmeta` VALUES (2584,28146,'_et_theme_builder_marked_as_unused','2022-07-22 20:05:27');
INSERT INTO `wp5_postmeta` VALUES (2269,204946,'_et_pb_built_for_post_type','page');
INSERT INTO `wp5_postmeta` VALUES (2270,204946,'_et_pb_ab_subjects','');
INSERT INTO `wp5_postmeta` VALUES (2271,204946,'_et_pb_enable_shortcode_tracking','');
INSERT INTO `wp5_postmeta` VALUES (2272,204946,'_et_pb_ab_current_shortcode','[et_pb_split_track id="204946" /]');
INSERT INTO `wp5_postmeta` VALUES (2273,204946,'_et_pb_custom_css','');
INSERT INTO `wp5_postmeta` VALUES (2274,204946,'_et_pb_gutter_width','3');
INSERT INTO `wp5_postmeta` VALUES (2275,204946,'_thumbnail_id','0');
INSERT INTO `wp5_postmeta` VALUES (2276,204946,'_global_colors_info','{}');
INSERT INTO `wp5_postmeta` VALUES (2277,204946,'_et_pb_first_image','');
INSERT INTO `wp5_postmeta` VALUES (2278,204946,'_et_pb_truncate_post','');
INSERT INTO `wp5_postmeta` VALUES (2279,204946,'_et_pb_truncate_post_date','');
INSERT INTO `wp5_postmeta` VALUES (2280,204946,'_et_builder_version','VB|Divi|4.17.4');
INSERT INTO `wp5_postmeta` VALUES (2282,204955,'_et_autogenerated_title','1');
INSERT INTO `wp5_postmeta` VALUES (2283,204955,'_et_default','0');
INSERT INTO `wp5_postmeta` VALUES (2284,204955,'_et_enabled','1');
INSERT INTO `wp5_postmeta` VALUES (2285,204955,'_et_header_layout_id','0');
INSERT INTO `wp5_postmeta` VALUES (2286,204955,'_et_header_layout_enabled','1');
INSERT INTO `wp5_postmeta` VALUES (2287,204955,'_et_body_layout_id','204946');
INSERT INTO `wp5_postmeta` VALUES (2288,204955,'_et_body_layout_enabled','1');
INSERT INTO `wp5_postmeta` VALUES (1793,28183,'_et_builder_dynamic_assets_loading_attr_threshold','8');
INSERT INTO `wp5_postmeta` VALUES (1798,28169,'_et_builder_dynamic_assets_loading_attr_threshold','8');
INSERT INTO `wp5_postmeta` VALUES (2794,204996,'_et_pb_built_for_post_type','page');
INSERT INTO `wp5_postmeta` VALUES (2795,204997,'_et_pb_built_for_post_type','page');
INSERT INTO `wp5_postmeta` VALUES (2796,204998,'_et_pb_built_for_post_type','page');
INSERT INTO `wp5_postmeta` VALUES (3348,205003,'_et_pb_built_for_post_type','page');
INSERT INTO `wp5_postmeta` VALUES (3349,205004,'_et_pb_built_for_post_type','page');
INSERT INTO `wp5_postmeta` VALUES (3350,205005,'_et_pb_built_for_post_type','page');
INSERT INTO `wp5_postmeta` VALUES (1803,28173,'_et_builder_dynamic_assets_loading_attr_threshold','8');
INSERT INTO `wp5_postmeta` VALUES (1808,28184,'_et_builder_dynamic_assets_loading_attr_threshold','8');
INSERT INTO `wp5_postmeta` VALUES (1813,204808,'_et_builder_dynamic_assets_loading_attr_threshold','2');
INSERT INTO `wp5_postmeta` VALUES (2502,204971,'_et_pb_ab_subjects','');
INSERT INTO `wp5_postmeta` VALUES (2503,204971,'_et_pb_enable_shortcode_tracking','');
INSERT INTO `wp5_postmeta` VALUES (2504,204971,'_et_pb_ab_current_shortcode','[et_pb_split_track id="204971" /]');
INSERT INTO `wp5_postmeta` VALUES (2505,204971,'_et_pb_custom_css','');
INSERT INTO `wp5_postmeta` VALUES (2506,204971,'_et_pb_gutter_width','3');
INSERT INTO `wp5_postmeta` VALUES (2508,204971,'_global_colors_info','{}');
INSERT INTO `wp5_postmeta` VALUES (2486,204973,'_menu_item_type','post_type');
INSERT INTO `wp5_postmeta` VALUES (2487,204973,'_menu_item_menu_item_parent','204988');
INSERT INTO `wp5_postmeta` VALUES (2488,204973,'_menu_item_object_id','204260');
INSERT INTO `wp5_postmeta` VALUES (2489,204973,'_menu_item_object','page');
INSERT INTO `wp5_postmeta` VALUES (2490,204973,'_menu_item_target','');
INSERT INTO `wp5_postmeta` VALUES (2491,204973,'_menu_item_classes','a:1:{i:0;s:0:"";}');
INSERT INTO `wp5_postmeta` VALUES (2492,204973,'_menu_item_xfn','');
INSERT INTO `wp5_postmeta` VALUES (2493,204973,'_menu_item_url','');
INSERT INTO `wp5_postmeta` VALUES (2498,204370,'_wp_old_date','2020-10-22');
INSERT INTO `wp5_postmeta` VALUES (2495,204840,'_wp_old_date','2021-02-24');
INSERT INTO `wp5_postmeta` VALUES (2496,204298,'_wp_old_date','2020-10-22');
INSERT INTO `wp5_postmeta` VALUES (2499,204300,'_wp_old_date','2020-10-22');
INSERT INTO `wp5_postmeta` VALUES (2500,204818,'_wp_old_date','2021-02-23');
INSERT INTO `wp5_postmeta` VALUES (2501,204971,'_et_pb_built_for_post_type','page');
INSERT INTO `wp5_postmeta` VALUES (2509,204971,'_et_builder_version','VB|Divi|4.27.4');
INSERT INTO `wp5_postmeta` VALUES (2510,204971,'_et_pb_show_page_creation','off');
INSERT INTO `wp5_postmeta` VALUES (1818,28178,'_et_builder_dynamic_assets_loading_attr_threshold','8');
INSERT INTO `wp5_postmeta` VALUES (2327,204958,'_et_pb_built_for_post_type','page');
INSERT INTO `wp5_postmeta` VALUES (2335,204958,'_et_pb_first_image','');
INSERT INTO `wp5_postmeta` VALUES (2336,204958,'_et_pb_truncate_post','');
INSERT INTO `wp5_postmeta` VALUES (2337,204958,'_et_pb_truncate_post_date','');
INSERT INTO `wp5_postmeta` VALUES (2338,204958,'_et_builder_version','VB|Divi|4.17.4');
INSERT INTO `wp5_postmeta` VALUES (1823,28175,'_et_builder_dynamic_assets_loading_attr_threshold','8');
INSERT INTO `wp5_postmeta` VALUES (2571,204274,'_thumbnail_id','0');
INSERT INTO `wp5_postmeta` VALUES (2562,204988,'_menu_item_type','custom');
INSERT INTO `wp5_postmeta` VALUES (2563,204988,'_menu_item_menu_item_parent','0');
INSERT INTO `wp5_postmeta` VALUES (2564,204988,'_menu_item_object_id','204988');
INSERT INTO `wp5_postmeta` VALUES (2565,204988,'_menu_item_object','custom');
INSERT INTO `wp5_postmeta` VALUES (2566,204988,'_menu_item_target','');
INSERT INTO `wp5_postmeta` VALUES (2516,204976,'_menu_item_type','post_type');
INSERT INTO `wp5_postmeta` VALUES (2517,204976,'_menu_item_menu_item_parent','204988');
INSERT INTO `wp5_postmeta` VALUES (2518,204976,'_menu_item_object_id','204971');
INSERT INTO `wp5_postmeta` VALUES (2519,204976,'_menu_item_object','page');
INSERT INTO `wp5_postmeta` VALUES (2520,204976,'_menu_item_target','');
INSERT INTO `wp5_postmeta` VALUES (2521,204976,'_menu_item_classes','a:1:{i:0;s:0:"";}');
INSERT INTO `wp5_postmeta` VALUES (2522,204976,'_menu_item_xfn','');
INSERT INTO `wp5_postmeta` VALUES (2523,204976,'_menu_item_url','');
INSERT INTO `wp5_postmeta` VALUES (2526,204971,'_et_builder_dynamic_assets_loading_attr_threshold','4');
INSERT INTO `wp5_postmeta` VALUES (1828,204274,'_et_builder_dynamic_assets_loading_attr_threshold','15');
INSERT INTO `wp5_postmeta` VALUES (2301,204960,'_et_autogenerated_title','1');
INSERT INTO `wp5_postmeta` VALUES (2302,204960,'_et_default','0');
INSERT INTO `wp5_postmeta` VALUES (2303,204960,'_et_enabled','1');
INSERT INTO `wp5_postmeta` VALUES (2304,204960,'_et_header_layout_id','0');
INSERT INTO `wp5_postmeta` VALUES (2305,204960,'_et_header_layout_enabled','1');
INSERT INTO `wp5_postmeta` VALUES (2306,204960,'_et_body_layout_id','204958');
INSERT INTO `wp5_postmeta` VALUES (2307,204960,'_et_body_layout_enabled','1');
INSERT INTO `wp5_postmeta` VALUES (2297,204958,'_et_pb_use_builder','on');
INSERT INTO `wp5_postmeta` VALUES (2298,204958,'_et_pb_show_page_creation','off');
INSERT INTO `wp5_postmeta` VALUES (2308,204960,'_et_footer_layout_id','0');
INSERT INTO `wp5_postmeta` VALUES (2309,204960,'_et_footer_layout_enabled','1');
INSERT INTO `wp5_postmeta` VALUES (2605,204960,'_et_use_on','archive:taxonomy:category:all');
INSERT INTO `wp5_postmeta` VALUES (2328,204958,'_et_pb_ab_subjects','');
INSERT INTO `wp5_postmeta` VALUES (2329,204958,'_et_pb_enable_shortcode_tracking','');
INSERT INTO `wp5_postmeta` VALUES (2330,204958,'_et_pb_ab_current_shortcode','[et_pb_split_track id="204958" /]');
INSERT INTO `wp5_postmeta` VALUES (2331,204958,'_et_pb_custom_css','');
INSERT INTO `wp5_postmeta` VALUES (2332,204958,'_et_pb_gutter_width','3');
INSERT INTO `wp5_postmeta` VALUES (2333,204958,'_thumbnail_id','0');
INSERT INTO `wp5_postmeta` VALUES (2334,204958,'_global_colors_info','{}');
INSERT INTO `wp5_postmeta` VALUES (1834,204260,'_et_builder_dynamic_assets_loading_attr_threshold','9');
INSERT INTO `wp5_postmeta` VALUES (1839,204351,'_et_builder_dynamic_assets_loading_attr_threshold','6');
INSERT INTO `wp5_postmeta` VALUES (4414,205018,'_wp_attached_file','2025/06/author_14.jpg');
INSERT INTO `wp5_postmeta` VALUES (4415,205018,'_wp_attachment_metadata','a:6:{s:5:"width";i:1920;s:6:"height";i:600;s:4:"file";s:21:"2025/06/author_14.jpg";s:8:"filesize";i:137955;s:5:"sizes";a:15:{s:6:"medium";a:5:{s:4:"file";s:20:"author_14-300x94.jpg";s:5:"width";i:300;s:6:"height";i:94;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:6040;}s:5:"large";a:5:{s:4:"file";s:22:"author_14-1024x320.jpg";s:5:"width";i:1024;s:6:"height";i:320;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:46758;}s:9:"thumbnail";a:5:{s:4:"file";s:21:"author_14-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:4689;}s:12:"medium_large";a:5:{s:4:"file";s:21:"author_14-768x240.jpg";s:5:"width";i:768;s:6:"height";i:240;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:28269;}s:9:"1536x1536";a:5:{s:4:"file";s:22:"author_14-1536x480.jpg";s:5:"width";i:1536;s:6:"height";i:480;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:93852;}s:11:"bloom_image";a:5:{s:4:"file";s:21:"author_14-610x191.jpg";s:5:"width";i:610;s:6:"height";i:191;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:19375;}s:21:"et-pb-post-main-image";a:5:{s:4:"file";s:21:"author_14-400x250.jpg";s:5:"width";i:400;s:6:"height";i:250;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:16588;}s:31:"et-pb-post-main-image-fullwidth";a:5:{s:4:"file";s:22:"author_14-1080x600.jpg";s:5:"width";i:1080;s:6:"height";i:600;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:87964;}s:21:"et-pb-portfolio-image";a:5:{s:4:"file";s:21:"author_14-400x284.jpg";s:5:"width";i:400;s:6:"height";i:284;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:18475;}s:28:"et-pb-portfolio-module-image";a:5:{s:4:"file";s:21:"author_14-510x382.jpg";s:5:"width";i:510;s:6:"height";i:382;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:29718;}s:28:"et-pb-portfolio-image-single";a:5:{s:4:"file";s:22:"author_14-1080x338.jpg";s:5:"width";i:1080;s:6:"height";i:338;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:51718;}s:35:"et-pb-gallery-module-image-portrait";a:5:{s:4:"file";s:21:"author_14-400x516.jpg";s:5:"width";i:400;s:6:"height";i:516;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:31543;}s:32:"et-pb-image--responsive--desktop";a:5:{s:4:"file";s:22:"author_14-1280x400.jpg";s:5:"width";i:1280;s:6:"height";i:400;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:69014;}s:31:"et-pb-image--responsive--tablet";a:5:{s:4:"file";s:21:"author_14-980x306.jpg";s:5:"width";i:980;s:6:"height";i:306;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:43981;}s:30:"et-pb-image--responsive--phone";a:5:{s:4:"file";s:21:"author_14-480x150.jpg";s:5:"width";i:480;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";s:8:"filesize";i:13003;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}');
INSERT INTO `wp5_postmeta` VALUES (4416,205019,'_wp_attached_file','2025/06/pages-divider.png');
INSERT INTO `wp5_postmeta` VALUES (4417,205019,'_wp_attachment_metadata','a:6:{s:5:"width";i:1920;s:6:"height";i:78;s:4:"file";s:25:"2025/06/pages-divider.png";s:8:"filesize";i:19427;s:5:"sizes";a:15:{s:6:"medium";a:5:{s:4:"file";s:24:"pages-divider-300x12.png";s:5:"width";i:300;s:6:"height";i:12;s:9:"mime-type";s:9:"image/png";s:8:"filesize";i:606;}s:5:"large";a:5:{s:4:"file";s:25:"pages-divider-1024x42.png";s:5:"width";i:1024;s:6:"height";i:42;s:9:"mime-type";s:9:"image/png";s:8:"filesize";i:2295;}s:9:"thumbnail";a:5:{s:4:"file";s:24:"pages-divider-150x78.png";s:5:"width";i:150;s:6:"height";i:78;s:9:"mime-type";s:9:"image/png";s:8:"filesize";i:1078;}s:12:"medium_large";a:5:{s:4:"file";s:24:"pages-divider-768x31.png";s:5:"width";i:768;s:6:"height";i:31;s:9:"mime-type";s:9:"image/png";s:8:"filesize";i:1598;}s:9:"1536x1536";a:5:{s:4:"file";s:25:"pages-divider-1536x62.png";s:5:"width";i:1536;s:6:"height";i:62;s:9:"mime-type";s:9:"image/png";s:8:"filesize";i:5188;}s:11:"bloom_image";a:5:{s:4:"file";s:24:"pages-divider-610x25.png";s:5:"width";i:610;s:6:"height";i:25;s:9:"mime-type";s:9:"image/png";s:8:"filesize";i:1177;}s:21:"et-pb-post-main-image";a:5:{s:4:"file";s:24:"pages-divider-400x78.png";s:5:"width";i:400;s:6:"height";i:78;s:9:"mime-type";s:9:"image/png";s:8:"filesize";i:2139;}s:31:"et-pb-post-main-image-fullwidth";a:5:{s:4:"file";s:25:"pages-divider-1080x78.png";s:5:"width";i:1080;s:6:"height";i:78;s:9:"mime-type";s:9:"image/png";s:8:"filesize";i:5065;}s:21:"et-pb-portfolio-image";a:5:{s:4:"file";s:24:"pages-divider-400x78.png";s:5:"width";i:400;s:6:"height";i:78;s:9:"mime-type";s:9:"image/png";s:8:"filesize";i:2139;}s:28:"et-pb-portfolio-module-image";a:5:{s:4:"file";s:24:"pages-divider-510x78.png";s:5:"width";i:510;s:6:"height";i:78;s:9:"mime-type";s:9:"image/png";s:8:"filesize";i:2617;}s:28:"et-pb-portfolio-image-single";a:5:{s:4:"file";s:25:"pages-divider-1080x44.png";s:5:"width";i:1080;s:6:"height";i:44;s:9:"mime-type";s:9:"image/png";s:8:"filesize";i:2596;}s:35:"et-pb-gallery-module-image-portrait";a:5:{s:4:"file";s:24:"pages-divider-400x78.png";s:5:"width";i:400;s:6:"height";i:78;s:9:"mime-type";s:9:"image/png";s:8:"filesize";i:2139;}s:32:"et-pb-image--responsive--desktop";a:5:{s:4:"file";s:25:"pages-divider-1280x52.png";s:5:"width";i:1280;s:6:"height";i:52;s:9:"mime-type";s:9:"image/png";s:8:"filesize";i:3403;}s:31:"et-pb-image--responsive--tablet";a:5:{s:4:"file";s:24:"pages-divider-980x40.png";s:5:"width";i:980;s:6:"height";i:40;s:9:"mime-type";s:9:"image/png";s:8:"filesize";i:2289;}s:30:"et-pb-image--responsive--phone";a:5:{s:4:"file";s:24:"pages-divider-480x20.png";s:5:"width";i:480;s:6:"height";i:20;s:9:"mime-type";s:9:"image/png";s:8:"filesize";i:941;}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}');
INSERT INTO `wp5_postmeta` VALUES (2567,204988,'_menu_item_classes','a:1:{i:0;s:0:"";}');
INSERT INTO `wp5_postmeta` VALUES (2568,204988,'_menu_item_xfn','');
INSERT INTO `wp5_postmeta` VALUES (2569,204988,'_menu_item_url','#');
INSERT INTO `wp5_postmeta` VALUES (3351,205006,'_et_pb_built_for_post_type','page');
INSERT INTO `wp5_postmeta` VALUES (3155,205001,'_et_pb_built_for_post_type','page');
INSERT INTO `wp5_postmeta` VALUES (1899,204365,'_edit_lock','1647887697:3');
INSERT INTO `wp5_postmeta` VALUES (2060,204916,'_wp_attached_file','2022/03/Depositphotos_77572032_DS-scaled.jpg');
INSERT INTO `wp5_postmeta` VALUES (2061,204916,'_wp_attachment_metadata','a:6:{s:5:"width";i:2560;s:6:"height";i:1440;s:4:"file";s:44:"2022/03/Depositphotos_77572032_DS-scaled.jpg";s:5:"sizes";a:17:{s:6:"medium";a:4:{s:4:"file";s:37:"Depositphotos_77572032_DS-300x169.jpg";s:5:"width";i:300;s:6:"height";i:169;s:9:"mime-type";s:10:"image/jpeg";}s:5:"large";a:4:{s:4:"file";s:38:"Depositphotos_77572032_DS-1024x576.jpg";s:5:"width";i:1024;s:6:"height";i:576;s:9:"mime-type";s:10:"image/jpeg";}s:9:"thumbnail";a:4:{s:4:"file";s:37:"Depositphotos_77572032_DS-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:12:"medium_large";a:4:{s:4:"file";s:37:"Depositphotos_77572032_DS-768x432.jpg";s:5:"width";i:768;s:6:"height";i:432;s:9:"mime-type";s:10:"image/jpeg";}s:9:"1536x1536";a:4:{s:4:"file";s:38:"Depositphotos_77572032_DS-1536x864.jpg";s:5:"width";i:1536;s:6:"height";i:864;s:9:"mime-type";s:10:"image/jpeg";}s:9:"2048x2048";a:4:{s:4:"file";s:39:"Depositphotos_77572032_DS-2048x1152.jpg";s:5:"width";i:2048;s:6:"height";i:1152;s:9:"mime-type";s:10:"image/jpeg";}s:11:"bloom_image";a:4:{s:4:"file";s:37:"Depositphotos_77572032_DS-610x343.jpg";s:5:"width";i:610;s:6:"height";i:343;s:9:"mime-type";s:10:"image/jpeg";}s:21:"et-pb-post-main-image";a:4:{s:4:"file";s:37:"Depositphotos_77572032_DS-400x250.jpg";s:5:"width";i:400;s:6:"height";i:250;s:9:"mime-type";s:10:"image/jpeg";}s:31:"et-pb-post-main-image-fullwidth";a:4:{s:4:"file";s:38:"Depositphotos_77572032_DS-1080x675.jpg";s:5:"width";i:1080;s:6:"height";i:675;s:9:"mime-type";s:10:"image/jpeg";}s:21:"et-pb-portfolio-image";a:4:{s:4:"file";s:37:"Depositphotos_77572032_DS-400x284.jpg";s:5:"width";i:400;s:6:"height";i:284;s:9:"mime-type";s:10:"image/jpeg";}s:28:"et-pb-portfolio-module-image";a:4:{s:4:"file";s:37:"Depositphotos_77572032_DS-510x382.jpg";s:5:"width";i:510;s:6:"height";i:382;s:9:"mime-type";s:10:"image/jpeg";}s:28:"et-pb-portfolio-image-single";a:4:{s:4:"file";s:38:"Depositphotos_77572032_DS-1080x608.jpg";s:5:"width";i:1080;s:6:"height";i:608;s:9:"mime-type";s:10:"image/jpeg";}s:35:"et-pb-gallery-module-image-portrait";a:4:{s:4:"file";s:37:"Depositphotos_77572032_DS-400x516.jpg";s:5:"width";i:400;s:6:"height";i:516;s:9:"mime-type";s:10:"image/jpeg";}s:37:"et-pb-post-main-image-fullwidth-large";a:4:{s:4:"file";s:39:"Depositphotos_77572032_DS-2880x1800.jpg";s:5:"width";i:2880;s:6:"height";i:1800;s:9:"mime-type";s:10:"image/jpeg";}s:32:"et-pb-image--responsive--desktop";a:4:{s:4:"file";s:38:"Depositphotos_77572032_DS-1280x720.jpg";s:5:"width";i:1280;s:6:"height";i:720;s:9:"mime-type";s:10:"image/jpeg";}s:31:"et-pb-image--responsive--tablet";a:4:{s:4:"file";s:37:"Depositphotos_77572032_DS-980x551.jpg";s:5:"width";i:980;s:6:"height";i:551;s:9:"mime-type";s:10:"image/jpeg";}s:30:"et-pb-image--responsive--phone";a:4:{s:4:"file";s:37:"Depositphotos_77572032_DS-480x270.jpg";s:5:"width";i:480;s:6:"height";i:270;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:52:"View of the planet Earth from space during a sunrise";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:52:"View of the planet Earth from space during a sunrise";s:11:"orientation";s:1:"1";s:8:"keywords";a:0:{}}s:14:"original_image";s:29:"Depositphotos_77572032_DS.jpg";}');
INSERT INTO `wp5_postmeta` VALUES (2062,204917,'_wp_attached_file','2022/03/Depositphotos_257716220_DS-scaled.jpg');
INSERT INTO `wp5_postmeta` VALUES (2063,204917,'_wp_attachment_metadata','a:6:{s:5:"width";i:2560;s:6:"height";i:1440;s:4:"file";s:45:"2022/03/Depositphotos_257716220_DS-scaled.jpg";s:5:"sizes";a:17:{s:6:"medium";a:4:{s:4:"file";s:38:"Depositphotos_257716220_DS-300x169.jpg";s:5:"width";i:300;s:6:"height";i:169;s:9:"mime-type";s:10:"image/jpeg";}s:5:"large";a:4:{s:4:"file";s:39:"Depositphotos_257716220_DS-1024x576.jpg";s:5:"width";i:1024;s:6:"height";i:576;s:9:"mime-type";s:10:"image/jpeg";}s:9:"thumbnail";a:4:{s:4:"file";s:38:"Depositphotos_257716220_DS-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:12:"medium_large";a:4:{s:4:"file";s:38:"Depositphotos_257716220_DS-768x432.jpg";s:5:"width";i:768;s:6:"height";i:432;s:9:"mime-type";s:10:"image/jpeg";}s:9:"1536x1536";a:4:{s:4:"file";s:39:"Depositphotos_257716220_DS-1536x864.jpg";s:5:"width";i:1536;s:6:"height";i:864;s:9:"mime-type";s:10:"image/jpeg";}s:9:"2048x2048";a:4:{s:4:"file";s:40:"Depositphotos_257716220_DS-2048x1152.jpg";s:5:"width";i:2048;s:6:"height";i:1152;s:9:"mime-type";s:10:"image/jpeg";}s:11:"bloom_image";a:4:{s:4:"file";s:38:"Depositphotos_257716220_DS-610x343.jpg";s:5:"width";i:610;s:6:"height";i:343;s:9:"mime-type";s:10:"image/jpeg";}s:21:"et-pb-post-main-image";a:4:{s:4:"file";s:38:"Depositphotos_257716220_DS-400x250.jpg";s:5:"width";i:400;s:6:"height";i:250;s:9:"mime-type";s:10:"image/jpeg";}s:31:"et-pb-post-main-image-fullwidth";a:4:{s:4:"file";s:39:"Depositphotos_257716220_DS-1080x675.jpg";s:5:"width";i:1080;s:6:"height";i:675;s:9:"mime-type";s:10:"image/jpeg";}s:21:"et-pb-portfolio-image";a:4:{s:4:"file";s:38:"Depositphotos_257716220_DS-400x284.jpg";s:5:"width";i:400;s:6:"height";i:284;s:9:"mime-type";s:10:"image/jpeg";}s:28:"et-pb-portfolio-module-image";a:4:{s:4:"file";s:38:"Depositphotos_257716220_DS-510x382.jpg";s:5:"width";i:510;s:6:"height";i:382;s:9:"mime-type";s:10:"image/jpeg";}s:28:"et-pb-portfolio-image-single";a:4:{s:4:"file";s:39:"Depositphotos_257716220_DS-1080x607.jpg";s:5:"width";i:1080;s:6:"height";i:607;s:9:"mime-type";s:10:"image/jpeg";}s:35:"et-pb-gallery-module-image-portrait";a:4:{s:4:"file";s:38:"Depositphotos_257716220_DS-400x516.jpg";s:5:"width";i:400;s:6:"height";i:516;s:9:"mime-type";s:10:"image/jpeg";}s:37:"et-pb-post-main-image-fullwidth-large";a:4:{s:4:"file";s:40:"Depositphotos_257716220_DS-2880x1800.jpg";s:5:"width";i:2880;s:6:"height";i:1800;s:9:"mime-type";s:10:"image/jpeg";}s:32:"et-pb-image--responsive--desktop";a:4:{s:4:"file";s:39:"Depositphotos_257716220_DS-1280x720.jpg";s:5:"width";i:1280;s:6:"height";i:720;s:9:"mime-type";s:10:"image/jpeg";}s:31:"et-pb-image--responsive--tablet";a:4:{s:4:"file";s:38:"Depositphotos_257716220_DS-980x551.jpg";s:5:"width";i:980;s:6:"height";i:551;s:9:"mime-type";s:10:"image/jpeg";}s:30:"et-pb-image--responsive--phone";a:4:{s:4:"file";s:38:"Depositphotos_257716220_DS-480x270.jpg";s:5:"width";i:480;s:6:"height";i:270;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:17:"Chaloupka Lukáš";s:6:"camera";s:0:"";s:7:"caption";s:98:"Space scene. Coloful nebula with spaceship and asteroids. Elements furnished by NASA. 3D rendering";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"1";s:8:"keywords";a:0:{}}s:14:"original_image";s:30:"Depositphotos_257716220_DS.jpg";}');
INSERT INTO `wp5_postmeta` VALUES (2064,204918,'_wp_attached_file','2022/03/Depositphotos_77208985_DS-scaled.jpg');
INSERT INTO `wp5_postmeta` VALUES (2065,204918,'_wp_attachment_metadata','a:6:{s:5:"width";i:2560;s:6:"height";i:1440;s:4:"file";s:44:"2022/03/Depositphotos_77208985_DS-scaled.jpg";s:5:"sizes";a:17:{s:6:"medium";a:4:{s:4:"file";s:37:"Depositphotos_77208985_DS-300x169.jpg";s:5:"width";i:300;s:6:"height";i:169;s:9:"mime-type";s:10:"image/jpeg";}s:5:"large";a:4:{s:4:"file";s:38:"Depositphotos_77208985_DS-1024x576.jpg";s:5:"width";i:1024;s:6:"height";i:576;s:9:"mime-type";s:10:"image/jpeg";}s:9:"thumbnail";a:4:{s:4:"file";s:37:"Depositphotos_77208985_DS-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:12:"medium_large";a:4:{s:4:"file";s:37:"Depositphotos_77208985_DS-768x432.jpg";s:5:"width";i:768;s:6:"height";i:432;s:9:"mime-type";s:10:"image/jpeg";}s:9:"1536x1536";a:4:{s:4:"file";s:38:"Depositphotos_77208985_DS-1536x864.jpg";s:5:"width";i:1536;s:6:"height";i:864;s:9:"mime-type";s:10:"image/jpeg";}s:9:"2048x2048";a:4:{s:4:"file";s:39:"Depositphotos_77208985_DS-2048x1152.jpg";s:5:"width";i:2048;s:6:"height";i:1152;s:9:"mime-type";s:10:"image/jpeg";}s:11:"bloom_image";a:4:{s:4:"file";s:37:"Depositphotos_77208985_DS-610x343.jpg";s:5:"width";i:610;s:6:"height";i:343;s:9:"mime-type";s:10:"image/jpeg";}s:21:"et-pb-post-main-image";a:4:{s:4:"file";s:37:"Depositphotos_77208985_DS-400x250.jpg";s:5:"width";i:400;s:6:"height";i:250;s:9:"mime-type";s:10:"image/jpeg";}s:31:"et-pb-post-main-image-fullwidth";a:4:{s:4:"file";s:38:"Depositphotos_77208985_DS-1080x675.jpg";s:5:"width";i:1080;s:6:"height";i:675;s:9:"mime-type";s:10:"image/jpeg";}s:21:"et-pb-portfolio-image";a:4:{s:4:"file";s:37:"Depositphotos_77208985_DS-400x284.jpg";s:5:"width";i:400;s:6:"height";i:284;s:9:"mime-type";s:10:"image/jpeg";}s:28:"et-pb-portfolio-module-image";a:4:{s:4:"file";s:37:"Depositphotos_77208985_DS-510x382.jpg";s:5:"width";i:510;s:6:"height";i:382;s:9:"mime-type";s:10:"image/jpeg";}s:28:"et-pb-portfolio-image-single";a:4:{s:4:"file";s:38:"Depositphotos_77208985_DS-1080x608.jpg";s:5:"width";i:1080;s:6:"height";i:608;s:9:"mime-type";s:10:"image/jpeg";}s:35:"et-pb-gallery-module-image-portrait";a:4:{s:4:"file";s:37:"Depositphotos_77208985_DS-400x516.jpg";s:5:"width";i:400;s:6:"height";i:516;s:9:"mime-type";s:10:"image/jpeg";}s:37:"et-pb-post-main-image-fullwidth-large";a:4:{s:4:"file";s:39:"Depositphotos_77208985_DS-2880x1800.jpg";s:5:"width";i:2880;s:6:"height";i:1800;s:9:"mime-type";s:10:"image/jpeg";}s:32:"et-pb-image--responsive--desktop";a:4:{s:4:"file";s:38:"Depositphotos_77208985_DS-1280x720.jpg";s:5:"width";i:1280;s:6:"height";i:720;s:9:"mime-type";s:10:"image/jpeg";}s:31:"et-pb-image--responsive--tablet";a:4:{s:4:"file";s:37:"Depositphotos_77208985_DS-980x551.jpg";s:5:"width";i:980;s:6:"height";i:551;s:9:"mime-type";s:10:"image/jpeg";}s:30:"et-pb-image--responsive--phone";a:4:{s:4:"file";s:37:"Depositphotos_77208985_DS-480x270.jpg";s:5:"width";i:480;s:6:"height";i:270;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:52:"View of the planet Earth from space during a sunrise";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:52:"View of the planet Earth from space during a sunrise";s:11:"orientation";s:1:"1";s:8:"keywords";a:0:{}}s:14:"original_image";s:29:"Depositphotos_77208985_DS.jpg";}');
/*!40000 ALTER TABLE `wp5_postmeta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wp5_options`
--

DROP TABLE IF EXISTS `wp5_options`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `wp5_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) NOT NULL DEFAULT '',
  `option_value` longtext NOT NULL,
  `autoload` varchar(20) NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=MyISAM AUTO_INCREMENT=167437 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wp5_options`
--

LOCK TABLES `wp5_options` WRITE;
/*!40000 ALTER TABLE `wp5_options` DISABLE KEYS */;
INSERT INTO `wp5_options` VALUES (1,'siteurl','https://gibson.authorwebsiteinabox.com','yes');
INSERT INTO `wp5_options` VALUES (2,'home','https://gibson.authorwebsiteinabox.com','yes');
INSERT INTO `wp5_options` VALUES (3,'blogname','Author Website in a Box demo','yes');
INSERT INTO `wp5_options` VALUES (4,'blogdescription','','yes');
INSERT INTO `wp5_options` VALUES (5,'users_can_register','0','yes');
INSERT INTO `wp5_options` VALUES (6,'admin_email','natehoffelder@gmail.com','yes');
INSERT INTO `wp5_options` VALUES (7,'start_of_week','1','yes');
INSERT INTO `wp5_options` VALUES (8,'use_balanceTags','0','yes');
INSERT INTO `wp5_options` VALUES (9,'use_smilies','1','yes');
INSERT INTO `wp5_options` VALUES (10,'require_name_email','1','yes');
INSERT INTO `wp5_options` VALUES (11,'comments_notify','1','yes');
INSERT INTO `wp5_options` VALUES (12,'posts_per_rss','10','yes');
INSERT INTO `wp5_options` VALUES (13,'rss_use_excerpt','0','yes');
INSERT INTO `wp5_options` VALUES (14,'mailserver_url','mail.example.com','yes');
INSERT INTO `wp5_options` VALUES (15,'mailserver_login','login@example.com','yes');
INSERT INTO `wp5_options` VALUES (16,'mailserver_pass','password','yes');
INSERT INTO `wp5_options` VALUES (17,'mailserver_port','110','yes');
INSERT INTO `wp5_options` VALUES (18,'default_category','1','yes');
INSERT INTO `wp5_options` VALUES (19,'default_comment_status','','yes');
INSERT INTO `wp5_options` VALUES (20,'default_ping_status','','yes');
INSERT INTO `wp5_options` VALUES (21,'default_pingback_flag','1','yes');
INSERT INTO `wp5_options` VALUES (22,'posts_per_page','10','yes');
INSERT INTO `wp5_options` VALUES (23,'date_format','F j, Y','yes');
INSERT INTO `wp5_options` VALUES (24,'time_format','g:i a','yes');
INSERT INTO `wp5_options` VALUES (25,'links_updated_date_format','F j, Y g:i a','yes');
INSERT INTO `wp5_options` VALUES (26,'comment_moderation','','yes');
INSERT INTO `wp5_options` VALUES (27,'moderation_notify','1','yes');
INSERT INTO `wp5_options` VALUES (28,'permalink_structure','/%postname%/','yes');
INSERT INTO `wp5_options` VALUES (30,'hack_file','0','yes');
INSERT INTO `wp5_options` VALUES (31,'blog_charset','UTF-8','yes');
INSERT INTO `wp5_options` VALUES (32,'moderation_keys','','no');
INSERT INTO `wp5_options` VALUES (33,'active_plugins','a:7:{i:0;s:15:"worker/init.php";i:1;s:19:"akismet/akismet.php";i:2;s:51:"all-in-one-wp-migration/all-in-one-wp-migration.php";i:3;s:15:"bloom/bloom.php";i:4;s:26:"popups-for-divi/plugin.php";i:5;s:46:"under-construction-page/under-construction.php";i:6;s:47:"wpvivid-backuprestore/wpvivid-backuprestore.php";}','yes');
INSERT INTO `wp5_options` VALUES (34,'category_base','','yes');
INSERT INTO `wp5_options` VALUES (35,'ping_sites','https://rpc.pingomatic.com/','yes');
INSERT INTO `wp5_options` VALUES (36,'comment_max_links','2','yes');
INSERT INTO `wp5_options` VALUES (37,'gmt_offset','0','yes');
INSERT INTO `wp5_options` VALUES (38,'default_email_category','1','yes');
INSERT INTO `wp5_options` VALUES (39,'recently_edited','a:5:{i:0;s:87:"/home/authorwebsite/gibson.authorwebsiteinabox.com/wp-content/themes/Divi/functions.php";i:1;s:83:"/home/authorwebsite/gibson.authorwebsiteinabox.com/wp-content/themes/Divi/style.css";i:2;s:87:"/home/authorwebsite/gibson.authorwebsiteinabox.com/wp-content/themes/Divi/changelog.txt";i:3;s:114:"/home/authorwebsite/gibson.authorwebsiteinabox.com/wp-content/themes/Divi/css/theme-customizer-controls-styles.css";i:4;s:94:"/home/authorwebsite/gibson.authorwebsiteinabox.com/wp-content/themes/Divi/css/editor-style.css";}','no');
INSERT INTO `wp5_options` VALUES (40,'template','Divi','yes');
INSERT INTO `wp5_options` VALUES (41,'stylesheet','Divi','yes');
INSERT INTO `wp5_options` VALUES (137,'finished_updating_comment_type','1','yes');
INSERT INTO `wp5_options` VALUES (44,'comment_registration','','yes');
INSERT INTO `wp5_options` VALUES (45,'html_type','text/html','yes');
INSERT INTO `wp5_options` VALUES (46,'use_trackback','0','yes');
INSERT INTO `wp5_options` VALUES (47,'default_role','subscriber','yes');
INSERT INTO `wp5_options` VALUES (48,'db_version','60717','yes');
INSERT INTO `wp5_options` VALUES (49,'uploads_use_yearmonth_folders','1','yes');
INSERT INTO `wp5_options` VALUES (50,'upload_path','','yes');
INSERT INTO `wp5_options` VALUES (51,'blog_public','1','yes');
INSERT INTO `wp5_options` VALUES (52,'default_link_category','2','yes');
INSERT INTO `wp5_options` VALUES (53,'show_on_front','page','yes');
INSERT INTO `wp5_options` VALUES (54,'tag_base','','yes');
INSERT INTO `wp5_options` VALUES (55,'show_avatars','1','yes');
INSERT INTO `wp5_options` VALUES (56,'avatar_rating','G','yes');
INSERT INTO `wp5_options` VALUES (57,'upload_url_path','','yes');
INSERT INTO `wp5_options` VALUES (58,'thumbnail_size_w','150','yes');
INSERT INTO `wp5_options` VALUES (59,'thumbnail_size_h','150','yes');
INSERT INTO `wp5_options` VALUES (60,'thumbnail_crop','1','yes');
INSERT INTO `wp5_options` VALUES (61,'medium_size_w','300','yes');
INSERT INTO `wp5_options` VALUES (62,'medium_size_h','300','yes');
INSERT INTO `wp5_options` VALUES (63,'avatar_default','mystery','yes');
INSERT INTO `wp5_options` VALUES (64,'large_size_w','1024','yes');
INSERT INTO `wp5_options` VALUES (65,'large_size_h','1024','yes');
INSERT INTO `wp5_options` VALUES (66,'image_default_link_type','none','yes');
INSERT INTO `wp5_options` VALUES (67,'image_default_size','','yes');
INSERT INTO `wp5_options` VALUES (68,'image_default_align','','yes');
INSERT INTO `wp5_options` VALUES (69,'close_comments_for_old_posts','','yes');
INSERT INTO `wp5_options` VALUES (70,'close_comments_days_old','14','yes');
INSERT INTO `wp5_options` VALUES (71,'thread_comments','1','yes');
INSERT INTO `wp5_options` VALUES (72,'thread_comments_depth','5','yes');
INSERT INTO `wp5_options` VALUES (73,'page_comments','','yes');
INSERT INTO `wp5_options` VALUES (74,'comments_per_page','50','yes');
INSERT INTO `wp5_options` VALUES (75,'default_comments_page','newest','yes');
INSERT INTO `wp5_options` VALUES (76,'comment_order','asc','yes');
INSERT INTO `wp5_options` VALUES (77,'sticky_posts','a:0:{}','yes');
INSERT INTO `wp5_options` VALUES (78,'widget_categories','a:1:{s:12:"_multiwidget";i:1;}','yes');
INSERT INTO `wp5_options` VALUES (79,'widget_text','a:2:{i:1;a:0:{}s:12:"_multiwidget";i:1;}','yes');
INSERT INTO `wp5_options` VALUES (80,'widget_rss','a:2:{i:1;a:0:{}s:12:"_multiwidget";i:1;}','yes');
INSERT INTO `wp5_options` VALUES (81,'uninstall_plugins','a:4:{s:46:"under-construction-page/under-construction.php";a:2:{i:0;s:3:"UCP";i:1;s:9:"uninstall";}s:20:"worker/functions.php";s:13:"mwp_uninstall";s:44:"shortpixel-image-optimiser/wp-shortpixel.php";a:2:{i:0;s:28:"\\ShortPixel\\ShortPixelPlugin";i:1;s:15:"uninstallPlugin";}s:36:"contact-form-7-honeypot/honeypot.php";s:22:"honeypot4cf7_uninstall";}','no');
INSERT INTO `wp5_options` VALUES (82,'timezone_string','','yes');
INSERT INTO `wp5_options` VALUES (83,'page_for_posts','28166','yes');
INSERT INTO `wp5_options` VALUES (84,'page_on_front','204189','yes');
INSERT INTO `wp5_options` VALUES (85,'default_post_format','0','yes');
INSERT INTO `wp5_options` VALUES (86,'link_manager_enabled','0','yes');
INSERT INTO `wp5_options` VALUES (87,'finished_splitting_shared_terms','1','yes');
INSERT INTO `wp5_options` VALUES (88,'site_icon','0','yes');
INSERT INTO `wp5_options` VALUES (89,'medium_large_size_w','768','yes');
INSERT INTO `wp5_options` VALUES (90,'medium_large_size_h','0','yes');
INSERT INTO `wp5_options` VALUES (91,'wp_page_for_privacy_policy','3','yes');
INSERT INTO `wp5_options` VALUES (92,'show_comments_cookies_opt_in','1','yes');
INSERT INTO `wp5_options` VALUES (93,'admin_email_lifespan','1762121230','yes');
INSERT INTO `wp5_options` VALUES (94,'initial_db_version','47018','yes');
INSERT INTO `wp5_options` VALUES (95,'wp5_user_roles','a:5:{s:13:"administrator";a:2:{s:4:"name";s:13:"Administrator";s:12:"capabilities";a:67:{s:13:"switch_themes";b:1;s:11:"edit_themes";b:1;s:16:"activate_plugins";b:1;s:12:"edit_plugins";b:1;s:10:"edit_users";b:1;s:10:"edit_files";b:1;s:14:"manage_options";b:1;s:17:"moderate_comments";b:1;s:17:"manage_categories";b:1;s:12:"manage_links";b:1;s:12:"upload_files";b:1;s:6:"import";b:1;s:15:"unfiltered_html";b:1;s:10:"edit_posts";b:1;s:17:"edit_others_posts";b:1;s:20:"edit_published_posts";b:1;s:13:"publish_posts";b:1;s:10:"edit_pages";b:1;s:4:"read";b:1;s:8:"level_10";b:1;s:7:"level_9";b:1;s:7:"level_8";b:1;s:7:"level_7";b:1;s:7:"level_6";b:1;s:7:"level_5";b:1;s:7:"level_4";b:1;s:7:"level_3";b:1;s:7:"level_2";b:1;s:7:"level_1";b:1;s:7:"level_0";b:1;s:17:"edit_others_pages";b:1;s:20:"edit_published_pages";b:1;s:13:"publish_pages";b:1;s:12:"delete_pages";b:1;s:19:"delete_others_pages";b:1;s:22:"delete_published_pages";b:1;s:12:"delete_posts";b:1;s:19:"delete_others_posts";b:1;s:22:"delete_published_posts";b:1;s:20:"delete_private_posts";b:1;s:18:"edit_private_posts";b:1;s:18:"read_private_posts";b:1;s:20:"delete_private_pages";b:1;s:18:"edit_private_pages";b:1;s:18:"read_private_pages";b:1;s:12:"delete_users";b:1;s:12:"create_users";b:1;s:17:"unfiltered_upload";b:1;s:14:"edit_dashboard";b:1;s:14:"update_plugins";b:1;s:14:"delete_plugins";b:1;s:15:"install_plugins";b:1;s:13:"update_themes";b:1;s:14:"install_themes";b:1;s:11:"update_core";b:1;s:10:"list_users";b:1;s:12:"remove_users";b:1;s:13:"promote_users";b:1;s:18:"edit_theme_options";b:1;s:13:"delete_themes";b:1;s:6:"export";b:1;s:17:"et_support_center";b:1;s:24:"et_support_center_system";b:1;s:31:"et_support_center_remote_access";b:1;s:31:"et_support_center_documentation";b:1;s:27:"et_support_center_safe_mode";b:1;s:22:"et_support_center_logs";b:1;}}s:6:"editor";a:2:{s:4:"name";s:6:"Editor";s:12:"capabilities";a:34:{s:17:"moderate_comments";b:1;s:17:"manage_categories";b:1;s:12:"manage_links";b:1;s:12:"upload_files";b:1;s:15:"unfiltered_html";b:1;s:10:"edit_posts";b:1;s:17:"edit_others_posts";b:1;s:20:"edit_published_posts";b:1;s:13:"publish_posts";b:1;s:10:"edit_pages";b:1;s:4:"read";b:1;s:7:"level_7";b:1;s:7:"level_6";b:1;s:7:"level_5";b:1;s:7:"level_4";b:1;s:7:"level_3";b:1;s:7:"level_2";b:1;s:7:"level_1";b:1;s:7:"level_0";b:1;s:17:"edit_others_pages";b:1;s:20:"edit_published_pages";b:1;s:13:"publish_pages";b:1;s:12:"delete_pages";b:1;s:19:"delete_others_pages";b:1;s:22:"delete_published_pages";b:1;s:12:"delete_posts";b:1;s:19:"delete_others_posts";b:1;s:22:"delete_published_posts";b:1;s:20:"delete_private_posts";b:1;s:18:"edit_private_posts";b:1;s:18:"read_private_posts";b:1;s:20:"delete_private_pages";b:1;s:18:"edit_private_pages";b:1;s:18:"read_private_pages";b:1;}}s:6:"author";a:2:{s:4:"name";s:6:"Author";s:12:"capabilities";a:10:{s:12:"upload_files";b:1;s:10:"edit_posts";b:1;s:20:"edit_published_posts";b:1;s:13:"publish_posts";b:1;s:4:"read";b:1;s:7:"level_2";b:1;s:7:"level_1";b:1;s:7:"level_0";b:1;s:12:"delete_posts";b:1;s:22:"delete_published_posts";b:1;}}s:11:"contributor";a:2:{s:4:"name";s:11:"Contributor";s:12:"capabilities";a:5:{s:10:"edit_posts";b:1;s:4:"read";b:1;s:7:"level_1";b:1;s:7:"level_0";b:1;s:12:"delete_posts";b:1;}}s:10:"subscriber";a:2:{s:4:"name";s:10:"Subscriber";s:12:"capabilities";a:2:{s:4:"read";b:1;s:7:"level_0";b:1;}}}','yes');
INSERT INTO `wp5_options` VALUES (96,'fresh_site','0','off');
INSERT INTO `wp5_options` VALUES (97,'widget_search','a:2:{i:2;a:1:{s:5:"title";s:0:"";}s:12:"_multiwidget";i:1;}','yes');
INSERT INTO `wp5_options` VALUES (98,'widget_recent-posts','a:2:{i:2;a:2:{s:5:"title";s:0:"";s:6:"number";i:5;}s:12:"_multiwidget";i:1;}','yes');
INSERT INTO `wp5_options` VALUES (99,'widget_recent-comments','a:2:{i:2;a:2:{s:5:"title";s:0:"";s:6:"number";i:5;}s:12:"_multiwidget";i:1;}','yes');
INSERT INTO `wp5_options` VALUES (100,'widget_archives','a:1:{s:12:"_multiwidget";i:1;}','yes');
INSERT INTO `wp5_options` VALUES (101,'widget_meta','a:1:{s:12:"_multiwidget";i:1;}','yes');
INSERT INTO `wp5_options` VALUES (102,'sidebars_widgets','a:9:{s:19:"wp_inactive_widgets";a:0:{}s:9:"sidebar-1";a:3:{i:0;s:8:"search-2";i:1;s:14:"recent-posts-2";i:2;s:17:"recent-comments-2";}s:9:"sidebar-2";a:0:{}s:9:"sidebar-3";a:0:{}s:9:"sidebar-4";a:0:{}s:9:"sidebar-5";a:0:{}s:9:"sidebar-6";a:0:{}s:9:"sidebar-7";a:0:{}s:13:"array_version";i:3;}','yes');
INSERT INTO `wp5_options` VALUES (296,'rsssl_check_redirect_dismissed','1','yes');
INSERT INTO `wp5_options` VALUES (339,'et_pb_signup_64eec7f4f84c4dc5e8c5cdc4292ab469','off','yes');
INSERT INTO `wp5_options` VALUES (341,'et_pb_contact_form_78dc0020389eed0bef1e45af652485dc','off','yes');
INSERT INTO `wp5_options` VALUES (103,'cron','a:17:{i:1768146385;a:1:{s:33:"wpvivid_clean_backup_record_event";a:1:{s:32:"a8cf63fecab3eb3edf6760bc02f258a6";a:2:{s:8:"schedule";b:0;s:4:"args";a:1:{i:0;b:0;}}}}i:1768146446;a:1:{s:28:"wpvivid_task_monitor_event_2";a:1:{s:32:"05e9cad2a7e972f00154ac191a6bc8e6";a:2:{s:8:"schedule";b:0;s:4:"args";a:1:{i:0;s:21:"wpvivid-e22bf8f41b8f4";}}}}i:1768146635;a:1:{s:26:"dm_admin_cron_notice_check";a:1:{s:32:"dd4d6eb78a154fb59dc300ada4733b5a";a:3:{s:8:"schedule";s:5:"daily";s:4:"args";a:2:{i:0;s:3:"pfd";i:1;s:2:"dm";}s:8:"interval";i:86400;}}}i:1768148993;a:1:{s:34:"wp_privacy_delete_old_export_files";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:6:"hourly";s:4:"args";a:0:{}s:8:"interval";i:3600;}}}i:1768156625;a:1:{s:21:"wp_update_user_counts";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:10:"twicedaily";s:4:"args";a:0:{}s:8:"interval";i:43200;}}}i:1768159275;a:1:{s:22:"mwp_update_public_keys";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:5:"daily";s:4:"args";a:0:{}s:8:"interval";i:86400;}}}i:1768160105;a:1:{s:21:"ai1wm_storage_cleanup";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:5:"daily";s:4:"args";a:0:{}s:8:"interval";i:86400;}}}i:1768160897;a:1:{s:30:"wp_delete_temp_updater_backups";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:6:"weekly";s:4:"args";a:0:{}s:8:"interval";i:604800;}}}i:1768170593;a:2:{s:17:"wp_update_plugins";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:10:"twicedaily";s:4:"args";a:0:{}s:8:"interval";i:43200;}}s:16:"wp_update_themes";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:10:"twicedaily";s:4:"args";a:0:{}s:8:"interval";i:43200;}}}i:1768171148;a:3:{s:19:"wp_scheduled_delete";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:5:"daily";s:4:"args";a:0:{}s:8:"interval";i:86400;}}s:25:"delete_expired_transients";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:5:"daily";s:4:"args";a:0:{}s:8:"interval";i:86400;}}s:30:"wp_scheduled_auto_draft_delete";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:5:"daily";s:4:"args";a:0:{}s:8:"interval";i:86400;}}}i:1768172856;a:2:{s:13:"wpseo-reindex";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:5:"daily";s:4:"args";a:0:{}s:8:"interval";i:86400;}}s:31:"wpseo_permalink_structure_check";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:5:"daily";s:4:"args";a:0:{}s:8:"interval";i:86400;}}}i:1768174655;a:1:{s:32:"recovery_mode_clean_expired_keys";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:5:"daily";s:4:"args";a:0:{}s:8:"interval";i:86400;}}}i:1768222438;a:1:{s:24:"bloom_lists_auto_refresh";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:5:"daily";s:4:"args";a:0:{}s:8:"interval";i:86400;}}}i:1768256993;a:1:{s:30:"wp_site_health_scheduled_check";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:6:"weekly";s:4:"args";a:0:{}s:8:"interval";i:604800;}}}i:1768297828;a:1:{s:16:"wp_version_check";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:10:"twicedaily";s:4:"args";a:0:{}s:8:"interval";i:43200;}}}i:1768689603;a:1:{s:32:"et_core_page_resource_auto_clear";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:7:"monthly";s:4:"args";a:0:{}s:8:"interval";i:2678400;}}}s:7:"version";i:2;}','on');
INSERT INTO `wp5_options` VALUES (104,'widget_pages','a:1:{s:12:"_multiwidget";i:1;}','yes');
INSERT INTO `wp5_options` VALUES (105,'widget_calendar','a:1:{s:12:"_multiwidget";i:1;}','yes');
INSERT INTO `wp5_options` VALUES (106,'widget_media_audio','a:1:{s:12:"_multiwidget";i:1;}','yes');
INSERT INTO `wp5_options` VALUES (107,'widget_media_image','a:1:{s:12:"_multiwidget";i:1;}','yes');
INSERT INTO `wp5_options` VALUES (108,'widget_media_gallery','a:1:{s:12:"_multiwidget";i:1;}','yes');
INSERT INTO `wp5_options` VALUES (109,'widget_media_video','a:1:{s:12:"_multiwidget";i:1;}','yes');
INSERT INTO `wp5_options` VALUES (110,'widget_tag_cloud','a:1:{s:12:"_multiwidget";i:1;}','yes');
INSERT INTO `wp5_options` VALUES (111,'widget_nav_menu','a:1:{s:12:"_multiwidget";i:1;}','yes');
INSERT INTO `wp5_options` VALUES (112,'widget_custom_html','a:1:{s:12:"_multiwidget";i:1;}','yes');
INSERT INTO `wp5_options` VALUES (114,'theme_mods_twentytwenty','a:2:{s:18:"custom_css_post_id";i:-1;s:16:"sidebars_widgets";a:2:{s:4:"time";i:1603060802;s:4:"data";a:3:{s:19:"wp_inactive_widgets";a:0:{}s:9:"sidebar-1";a:3:{i:0;s:8:"search-2";i:1;s:14:"recent-posts-2";i:2;s:17:"recent-comments-2";}s:9:"sidebar-2";a:3:{i:0;s:10:"archives-2";i:1;s:12:"categories-2";i:2;s:6:"meta-2";}}}}','no');
INSERT INTO `wp5_options` VALUES (115,'recovery_keys','a:0:{}','off');
INSERT INTO `wp5_options` VALUES (134,'disallowed_keys','','no');
INSERT INTO `wp5_options` VALUES (135,'comment_previously_approved','1','yes');
INSERT INTO `wp5_options` VALUES (136,'auto_plugin_theme_update_emails','a:0:{}','no');
INSERT INTO `wp5_options` VALUES (138,'db_upgraded','','on');
INSERT INTO `wp5_options` VALUES (246,'rsssl_activation_timestamp','1603061152','yes');
INSERT INTO `wp5_options` VALUES (6444,'et_bloom_stats_optin_cache','a:1:{s:12:"optins_cache";a:1:{s:7:"optin_1";a:3:{s:3:"imp";i:59;s:3:"con";i:1;s:12:"last_updated";s:19:"2021-03-22 23:58:58";}}}','yes');
INSERT INTO `wp5_options` VALUES (198,'recently_activated','a:0:{}','off');
INSERT INTO `wp5_options` VALUES (137385,'mwp_recovering','','auto');
INSERT INTO `wp5_options` VALUES (137386,'mwp_core_autoupdate','','auto');
INSERT INTO `wp5_options` VALUES (137387,'mwp_container_parameters','a:0:{}','auto');
INSERT INTO `wp5_options` VALUES (137388,'mwp_container_site_parameters','a:0:{}','auto');
INSERT INTO `wp5_options` VALUES (137389,'mwp_maintenace_mode','a:0:{}','auto');
INSERT INTO `wp5_options` VALUES (137390,'_worker_nossl_key','','auto');
INSERT INTO `wp5_options` VALUES (137391,'_worker_public_key','LS0tLS1CRUdJTiBQVUJMSUMgS0VZLS0tLS0KTUlJQklqQU5CZ2txaGtpRzl3MEJBUUVGQUFPQ0FROEFNSUlCQ2dLQ0FRRUFyOTRFbFJOYUdzMHl3YjgrZUhURgp5VW5FNWptWDJqa1E3MWlKblJFS3RGb2lYeS9PeWwvSEFqMFFXY3FIK2RBY1RXbjBiTS8vU0NWdEpVM3hFeXVZCjhQZC8vNWtTOFRQbG1JWjB6Rks0cTZvRU83VG9KcWMyYWF1NDVBTE5FRVRZSitUYmk4U3laT3RaZ0JUU2pUSGwKNlB4dXJXR0ZTd2xqeU9FMGdRVHo0TnlvaU0xcVIwUzZ3ZEFuZHB1bjl3VktacE9VL0loeEkwdEdkakpVZ1ZKZApqeXh4TnpHOUlISWFGaUthVmUzSFZkd21iTHhNYloyby85RXZXeEFQckRHVmZodzNFS2pWc3VFOG45dEVya0E4Cm91SWdPRUkrVjhLcTkxT0owQTNZa0tMNUlJSU5sc051THFXL29Fc2ExMmFQYnlwU2NuRGlFZGFiTzAvczVhaWoKTVFJREFRQUIKLS0tLS1FTkQgUFVCTElDIEtFWS0tLS0tCg==','on');
INSERT INTO `wp5_options` VALUES (137392,'mwp_worker_configuration','a:9:{s:10:"master_url";s:21:"https://managewp.com/";s:15:"master_cron_url";s:75:"https://managewp.com/wp-content/plugins/master/mwp-notifications-handle.php";s:20:"noti_cache_life_time";s:5:"86400";s:27:"noti_treshold_spam_comments";s:2:"10";s:30:"noti_treshold_pending_comments";s:1:"0";s:31:"noti_treshold_approved_comments";s:1:"0";s:19:"noti_treshold_posts";s:1:"0";s:20:"noti_treshold_drafts";s:1:"0";s:8:"key_name";s:8:"managewp";}','auto');
INSERT INTO `wp5_options` VALUES (126,'auto_core_update_notified','a:4:{s:4:"type";s:7:"success";s:5:"email";s:23:"natehoffelder@gmail.com";s:7:"version";s:5:"6.5.2";s:9:"timestamp";i:1712703735;}','no');
INSERT INTO `wp5_options` VALUES (272,'category_children','a:0:{}','yes');
INSERT INTO `wp5_options` VALUES (171,'et_account_status','active','no');
INSERT INTO `wp5_options` VALUES (144,'current_theme','Divi','yes');
INSERT INTO `wp5_options` VALUES (145,'theme_mods_Divi','a:5:{i:0;b:0;s:18:"custom_css_post_id";i:6;s:16:"et_pb_css_synced";s:3:"yes";s:18:"nav_menu_locations";a:1:{s:12:"primary-menu";i:9;}s:39:"et_updated_layouts_built_for_post_types";s:3:"yes";}','yes');
INSERT INTO `wp5_options` VALUES (146,'theme_switched','','yes');
INSERT INTO `wp5_options` VALUES (147,'et_pb_cache_notice','a:1:{s:5:"4.6.3";s:6:"ignore";}','yes');
INSERT INTO `wp5_options` VALUES (152,'et_core_version','4.27.4','yes');
INSERT INTO `wp5_options` VALUES (154,'et_divi','a:185:{s:39:"static_css_custom_css_safety_check_done";b:1;s:23:"2_5_flush_rewrite_rules";s:4:"done";s:30:"et_flush_rewrite_rules_library";s:6:"4.27.4";s:31:"divi_previous_installed_version";s:6:"4.17.6";s:29:"divi_latest_installed_version";s:6:"4.27.4";s:27:"divi_skip_font_subset_force";b:1;s:27:"et_pb_clear_templates_cache";b:1;s:23:"builder_custom_defaults";O:8:"stdClass":0:{}s:33:"customizer_settings_migrated_flag";b:1;s:34:"builder_custom_defaults_unmigrated";b:0;s:40:"divi_email_provider_credentials_migrated";b:1;s:29:"custom_defaults_migrated_flag";b:1;s:15:"divi_1_3_images";s:7:"checked";s:21:"et_pb_layouts_updated";b:1;s:30:"library_removed_legacy_layouts";b:1;s:30:"divi_2_4_documentation_message";s:9:"triggered";s:9:"divi_logo";s:81:"https://gibson.authorwebsiteinabox.com/wp-content/uploads/2020/11/author_logo.png";s:14:"divi_fixed_nav";s:2:"on";s:26:"divi_gallery_layout_enable";s:5:"false";s:18:"divi_color_palette";s:63:"#000000|#ffffff|#e02b20|#e09900|#edf000|#7cda24|#0c71c3|#8300e9";s:15:"divi_grab_image";s:5:"false";s:15:"divi_blog_style";s:5:"false";s:12:"divi_sidebar";s:16:"et_right_sidebar";s:22:"divi_shop_page_sidebar";s:16:"et_right_sidebar";s:23:"divi_show_facebook_icon";s:2:"on";s:22:"divi_show_twitter_icon";s:2:"on";s:21:"divi_show_google_icon";s:5:"false";s:24:"divi_show_instagram_icon";s:2:"on";s:18:"divi_show_rss_icon";s:2:"on";s:17:"divi_facebook_url";s:1:"#";s:16:"divi_twitter_url";s:1:"#";s:15:"divi_google_url";s:1:"#";s:18:"divi_instagram_url";s:1:"#";s:12:"divi_rss_url";s:0:"";s:34:"divi_woocommerce_archive_num_posts";i:9;s:17:"divi_catnum_posts";i:6;s:21:"divi_archivenum_posts";i:5;s:20:"divi_searchnum_posts";i:5;s:17:"divi_tagnum_posts";i:5;s:16:"divi_date_format";s:6:"M j, Y";s:16:"divi_use_excerpt";s:2:"on";s:26:"divi_responsive_shortcodes";s:2:"on";s:33:"divi_gf_enable_all_character_sets";s:5:"false";s:16:"divi_back_to_top";s:2:"on";s:18:"divi_smooth_scroll";s:2:"on";s:25:"divi_disable_translations";s:5:"false";s:29:"divi_enable_responsive_images";s:2:"on";s:27:"divi_minify_combine_scripts";s:2:"on";s:26:"divi_minify_combine_styles";s:2:"on";s:15:"divi_custom_css";s:144:"/*place button modules next to each other in the same column*/\r\n.pa-inline-buttons .et_pb_button_module_wrapper {\r\n    display: inline-block;\r\n}";s:21:"divi_enable_dropdowns";s:2:"on";s:14:"divi_home_link";s:2:"on";s:15:"divi_sort_pages";s:10:"post_title";s:15:"divi_order_page";s:3:"asc";s:22:"divi_tiers_shown_pages";i:3;s:32:"divi_enable_dropdowns_categories";s:2:"on";s:21:"divi_categories_empty";s:2:"on";s:27:"divi_tiers_shown_categories";i:3;s:13:"divi_sort_cat";s:4:"name";s:14:"divi_order_cat";s:3:"asc";s:20:"divi_disable_toptier";s:5:"false";s:25:"divi_scroll_to_anchor_fix";s:5:"false";s:27:"et_pb_post_type_integration";a:3:{s:4:"post";s:3:"off";s:4:"page";s:2:"on";s:7:"project";s:2:"on";}s:21:"et_pb_static_css_file";s:2:"on";s:19:"et_pb_css_in_footer";s:3:"off";s:25:"et_pb_product_tour_global";s:2:"on";s:24:"et_enable_classic_editor";s:2:"on";s:14:"divi_postinfo2";a:3:{i:0;s:6:"author";i:1;s:10:"categories";i:2;s:8:"comments";}s:22:"divi_show_postcomments";s:2:"on";s:15:"divi_thumbnails";s:2:"on";s:20:"divi_page_thumbnails";s:5:"false";s:23:"divi_show_pagescomments";s:5:"false";s:14:"divi_postinfo1";a:3:{i:0;s:6:"author";i:1;s:10:"categories";i:2;s:8:"comments";}s:21:"divi_thumbnails_index";s:2:"on";s:19:"divi_seo_home_title";s:5:"false";s:25:"divi_seo_home_description";s:5:"false";s:22:"divi_seo_home_keywords";s:5:"false";s:23:"divi_seo_home_canonical";s:5:"false";s:23:"divi_seo_home_titletext";s:0:"";s:29:"divi_seo_home_descriptiontext";s:0:"";s:26:"divi_seo_home_keywordstext";s:0:"";s:18:"divi_seo_home_type";s:27:"BlogName | Blog description";s:22:"divi_seo_home_separate";s:3:" | ";s:21:"divi_seo_single_title";s:5:"false";s:27:"divi_seo_single_description";s:5:"false";s:24:"divi_seo_single_keywords";s:5:"false";s:25:"divi_seo_single_canonical";s:5:"false";s:27:"divi_seo_single_field_title";s:9:"seo_title";s:33:"divi_seo_single_field_description";s:15:"seo_description";s:30:"divi_seo_single_field_keywords";s:12:"seo_keywords";s:20:"divi_seo_single_type";s:21:"Post title | BlogName";s:24:"divi_seo_single_separate";s:3:" | ";s:24:"divi_seo_index_canonical";s:5:"false";s:26:"divi_seo_index_description";s:5:"false";s:19:"divi_seo_index_type";s:24:"Category name | BlogName";s:23:"divi_seo_index_separate";s:3:" | ";s:28:"divi_integrate_header_enable";s:2:"on";s:26:"divi_integrate_body_enable";s:2:"on";s:31:"divi_integrate_singletop_enable";s:2:"on";s:34:"divi_integrate_singlebottom_enable";s:2:"on";s:21:"divi_integration_head";s:0:"";s:21:"divi_integration_body";s:0:"";s:27:"divi_integration_single_top";s:0:"";s:30:"divi_integration_single_bottom";s:0:"";s:15:"divi_468_enable";s:5:"false";s:14:"divi_468_image";s:0:"";s:12:"divi_468_url";s:0:"";s:16:"divi_468_adsense";s:0:"";s:19:"product_tour_status";a:3:{i:1;s:3:"off";i:2;s:3:"off";i:3;s:3:"off";}s:32:"et_fb_pref_settings_bar_location";s:6:"bottom";s:28:"et_fb_pref_builder_animation";s:4:"true";s:41:"et_fb_pref_builder_display_modal_settings";s:5:"false";s:39:"et_fb_pref_builder_enable_dummy_content";s:4:"true";s:21:"et_fb_pref_event_mode";s:5:"hover";s:28:"et_fb_pref_limited_view_mode";s:9:"wireframe";s:32:"et_fb_pref_hide_disabled_modules";s:5:"false";s:28:"et_fb_pref_history_intervals";i:1;s:29:"et_fb_pref_page_creation_flow";s:7:"default";s:42:"et_fb_pref_quick_actions_always_start_with";s:7:"nothing";s:44:"et_fb_pref_quick_actions_show_recent_queries";s:3:"off";s:39:"et_fb_pref_quick_actions_recent_queries";s:0:"";s:40:"et_fb_pref_quick_actions_recent_category";s:0:"";s:35:"et_fb_pref_limited_modal_preference";s:7:"default";s:30:"et_fb_pref_modal_snap_location";s:0:"";s:21:"et_fb_pref_modal_snap";s:5:"false";s:27:"et_fb_pref_modal_fullscreen";s:5:"false";s:32:"et_fb_pref_modal_dimension_width";i:444;s:33:"et_fb_pref_modal_dimension_height";i:336;s:27:"et_fb_pref_modal_position_x";i:123;s:27:"et_fb_pref_modal_position_y";i:51;s:32:"et_fb_pref_limited_toolbar_click";s:5:"false";s:34:"et_fb_pref_limited_toolbar_desktop";s:4:"true";s:31:"et_fb_pref_limited_toolbar_grid";s:5:"false";s:32:"et_fb_pref_limited_toolbar_hover";s:5:"false";s:32:"et_fb_pref_limited_toolbar_phone";s:4:"true";s:33:"et_fb_pref_limited_toolbar_tablet";s:4:"true";s:36:"et_fb_pref_limited_toolbar_wireframe";s:4:"true";s:31:"et_fb_pref_limited_toolbar_zoom";s:4:"true";s:36:"et_fb_pref_lv_modal_dimension_height";i:0;s:35:"et_fb_pref_lv_modal_dimension_width";i:0;s:30:"et_fb_pref_lv_modal_position_x";i:0;s:30:"et_fb_pref_lv_modal_position_y";i:0;s:20:"et_fb_pref_view_mode";s:7:"desktop";s:27:"et_fb_pref_modal_preference";s:7:"default";s:24:"et_fb_pref_toolbar_click";s:5:"false";s:26:"et_fb_pref_toolbar_desktop";s:4:"true";s:23:"et_fb_pref_toolbar_grid";s:5:"false";s:24:"et_fb_pref_toolbar_hover";s:5:"false";s:24:"et_fb_pref_toolbar_phone";s:4:"true";s:25:"et_fb_pref_toolbar_tablet";s:4:"true";s:28:"et_fb_pref_toolbar_wireframe";s:4:"true";s:23:"et_fb_pref_toolbar_zoom";s:4:"true";s:24:"show_footer_social_icons";b:0;s:14:"footer_columns";s:1:"1";s:24:"footer_widget_text_color";s:7:"#ffffff";s:24:"footer_widget_link_color";s:7:"#ffffff";s:12:"heading_font";s:7:"Raleway";s:9:"body_font";s:6:"Oxygen";s:21:"custom_footer_credits";s:91:"© 2025 <a>Nate Hoffelder</a> | You can change this line in the Customizer &gt; Footer menu";s:34:"et_fb_pref_responsive_tablet_width";i:768;s:35:"et_fb_pref_responsive_tablet_height";i:0;s:33:"et_fb_pref_responsive_phone_width";i:400;s:34:"et_fb_pref_responsive_phone_height";i:0;s:35:"et_fb_pref_responsive_minimum_width";i:320;s:35:"et_fb_pref_responsive_maximum_width";i:980;s:46:"et_fb_pref_builder_enable_visual_theme_builder";s:4:"true";s:29:"divi_dynamic_module_framework";s:2:"on";s:16:"divi_dynamic_css";s:2:"on";s:18:"divi_dynamic_icons";s:5:"false";s:22:"divi_inline_stylesheet";s:2:"on";s:17:"divi_critical_css";s:2:"on";s:30:"divi_critical_threshold_height";s:6:"Medium";s:25:"divi_dynamic_js_libraries";s:2:"on";s:19:"divi_disable_emojis";s:2:"on";s:20:"divi_defer_block_css";s:2:"on";s:24:"divi_google_fonts_inline";s:2:"on";s:51:"divi_limit_google_fonts_support_for_legacy_browsers";s:2:"on";s:23:"divi_enable_jquery_body";s:2:"on";s:32:"divi_enable_jquery_compatibility";s:2:"on";s:29:"divi_enable_jquery_body_super";s:5:"false";s:14:"body_font_size";i:16;s:16:"body_header_size";i:48;s:19:"body_header_spacing";i:1;s:29:"presets_storage_migrated_flag";b:1;s:39:"builder_global_presets_history_migrated";b:1;}','on');
INSERT INTO `wp5_options` VALUES (155,'widget_aboutmewidget','a:1:{s:12:"_multiwidget";i:1;}','yes');
INSERT INTO `wp5_options` VALUES (156,'widget_adsensewidget','a:1:{s:12:"_multiwidget";i:1;}','yes');
INSERT INTO `wp5_options` VALUES (157,'widget_advwidget','a:1:{s:12:"_multiwidget";i:1;}','yes');
INSERT INTO `wp5_options` VALUES (158,'shop_catalog_image_size','a:3:{s:5:"width";s:3:"400";s:6:"height";s:3:"400";s:4:"crop";i:1;}','yes');
INSERT INTO `wp5_options` VALUES (159,'shop_single_image_size','a:3:{s:5:"width";s:3:"510";s:6:"height";s:4:"9999";s:4:"crop";i:0;}','yes');
INSERT INTO `wp5_options` VALUES (160,'shop_thumbnail_image_size','a:3:{s:5:"width";s:3:"157";s:6:"height";s:3:"157";s:4:"crop";i:1;}','yes');
INSERT INTO `wp5_options` VALUES (161,'et_support_site_id','v8sFQ#H7RKu$3rL)aGWT','yes');
INSERT INTO `wp5_options` VALUES (162,'et_safe_mode_plugins_allowlist','a:9:{i:0;s:15:"etdev/etdev.php";i:1;s:15:"bloom/bloom.php";i:2;s:19:"monarch/monarch.php";i:3;s:29:"divi-builder/divi-builder.php";i:4;s:23:"divi-dash/divi-dash.php";i:5;s:27:"ari-adminer/ari-adminer.php";i:6;s:31:"query-monitor/query-monitor.php";i:7;s:27:"woocommerce/woocommerce.php";i:8;s:47:"really-simple-ssl/rlrsssl-really-simple-ssl.php";}','yes');
INSERT INTO `wp5_options` VALUES (163,'et_support_center_installed','true','yes');
INSERT INTO `wp5_options` VALUES (164,'et_images_temp_folder','/home/authorwebsite/gibson.authorwebsiteinabox.com/wp-content/uploads/et_temp','yes');
INSERT INTO `wp5_options` VALUES (165,'et_schedule_clean_images_last_time','1768038598','yes');
INSERT INTO `wp5_options` VALUES (166,'et_bfb_settings','a:2:{s:10:"enable_bfb";s:2:"on";s:10:"toggle_bfb";s:2:"on";}','yes');
INSERT INTO `wp5_options` VALUES (168,'et_pb_builder_options','a:2:{i:0;b:0;s:35:"email_provider_credentials_migrated";b:1;}','yes');
INSERT INTO `wp5_options` VALUES (169,'et_support_center_setup_done','processed','yes');
INSERT INTO `wp5_options` VALUES (182,'et_google_api_settings','a:3:{s:7:"api_key";s:0:"";s:26:"enqueue_google_maps_script";s:2:"on";s:16:"use_google_fonts";s:2:"on";}','yes');
INSERT INTO `wp5_options` VALUES (183,'et_automatic_updates_options','a:2:{s:8:"username";s:7:"user666";s:7:"api_key";s:40:"063180df0013b22352d18d4bd5ff5cca8b83fc70";}','no');
INSERT INTO `wp5_options` VALUES (236,'action_scheduler_hybrid_store_demarkation','8','yes');
INSERT INTO `wp5_options` VALUES (237,'schema-ActionScheduler_StoreSchema','3.0.1603061121','yes');
INSERT INTO `wp5_options` VALUES (238,'schema-ActionScheduler_LoggerSchema','2.0.1603061121','yes');
INSERT INTO `wp5_options` VALUES (265,'et_pb_signup_e392a5e587ced011395041b6eec58210','off','yes');
INSERT INTO `wp5_options` VALUES (263,'et_pb_signup_ec2a922653300d892465e4274ce0de49','off','yes');
INSERT INTO `wp5_options` VALUES (264,'et_pb_contact_form_f020ec5b3b3ae1a13042cd00c92b991e','off','yes');
INSERT INTO `wp5_options` VALUES (266,'et_pb_contact_form_462f59b6bbe670388d67d5cc89e20f5a','off','yes');
INSERT INTO `wp5_options` VALUES (269,'et_pb_contact_form_2683c780946298e529e1d7b6244ff05e','off','yes');
INSERT INTO `wp5_options` VALUES (300,'layout_category_children','a:0:{}','yes');
INSERT INTO `wp5_options` VALUES (318,'_transient_health-check-site-status-result','{"good":16,"recommended":7,"critical":1}','yes');
INSERT INTO `wp5_options` VALUES (2904,'rsssl_upgraded_to_four','1','yes');
INSERT INTO `wp5_options` VALUES (2905,'rsssl_mixed_content_scan_dismissed','1','yes');
INSERT INTO `wp5_options` VALUES (2906,'rsssl_google_analytics_dismissed','1','yes');
INSERT INTO `wp5_options` VALUES (2911,'rsssl_remaining_tasks','1','yes');
INSERT INTO `wp5_options` VALUES (2882,'wpseo','a:42:{s:8:"tracking";b:0;s:22:"license_server_version";b:0;s:15:"ms_defaults_set";b:0;s:40:"ignore_search_engines_discouraged_notice";b:0;s:19:"indexing_first_time";b:1;s:16:"indexing_started";b:0;s:15:"indexing_reason";s:13:"first_install";s:29:"indexables_indexing_completed";b:0;s:7:"version";s:4:"15.3";s:16:"previous_version";s:6:"15.2.1";s:20:"disableadvanced_meta";b:1;s:30:"enable_headless_rest_endpoints";b:1;s:17:"ryte_indexability";b:1;s:11:"baiduverify";s:0:"";s:12:"googleverify";s:0:"";s:8:"msverify";s:0:"";s:12:"yandexverify";s:0:"";s:9:"site_type";s:0:"";s:20:"has_multiple_authors";s:0:"";s:16:"environment_type";s:0:"";s:23:"content_analysis_active";b:1;s:23:"keyword_analysis_active";b:1;s:21:"enable_admin_bar_menu";b:1;s:26:"enable_cornerstone_content";b:1;s:18:"enable_xml_sitemap";b:1;s:24:"enable_text_link_counter";b:1;s:22:"show_onboarding_notice";b:1;s:18:"first_activated_on";i:1606432056;s:13:"myyoast-oauth";b:0;s:26:"semrush_integration_active";b:1;s:14:"semrush_tokens";a:0:{}s:20:"semrush_country_code";s:2:"us";s:19:"permalink_structure";s:12:"/%postname%/";s:8:"home_url";s:38:"https://gibson.authorwebsiteinabox.com";s:18:"dynamic_permalinks";b:0;s:17:"category_base_url";s:0:"";s:12:"tag_base_url";s:0:"";s:21:"custom_taxonomy_slugs";a:0:{}s:29:"enable_enhanced_slack_sharing";b:1;s:25:"zapier_integration_active";b:1;s:19:"zapier_subscription";a:0:{}s:14:"zapier_api_key";s:0:"";}','yes');
INSERT INTO `wp5_options` VALUES (1910,'et_pb_signup_36cbfbd945286604502b91cde439685a','off','yes');
INSERT INTO `wp5_options` VALUES (1922,'et_pb_signup_1382876f47f1c4fb839179fd4c5f2560','off','yes');
INSERT INTO `wp5_options` VALUES (1928,'et_pb_signup_f800e2e3ca30c63f6bc82fde685ae3f3','off','yes');
INSERT INTO `wp5_options` VALUES (1963,'et_pb_contact_form_37daed8ad528dc05cd31e0a3971cece6','off','yes');
INSERT INTO `wp5_options` VALUES (1969,'et_pb_contact_form_9fe0d9cf713dd579c988b9dfabe12c14','off','yes');
INSERT INTO `wp5_options` VALUES (2924,'rewrite_rules','a:284:{s:10:"project/?$";s:27:"index.php?post_type=project";s:40:"project/feed/(feed|rdf|rss|rss2|atom)/?$";s:44:"index.php?post_type=project&feed=$matches[1]";s:35:"project/(feed|rdf|rss|rss2|atom)/?$";s:44:"index.php?post_type=project&feed=$matches[1]";s:27:"project/page/([0-9]{1,})/?$";s:45:"index.php?post_type=project&paged=$matches[1]";s:11:"^wp-json/?$";s:22:"index.php?rest_route=/";s:14:"^wp-json/(.*)?";s:33:"index.php?rest_route=/$matches[1]";s:21:"^index.php/wp-json/?$";s:22:"index.php?rest_route=/";s:24:"^index.php/wp-json/(.*)?";s:33:"index.php?rest_route=/$matches[1]";s:17:"^wp-sitemap\\.xml$";s:23:"index.php?sitemap=index";s:17:"^wp-sitemap\\.xsl$";s:36:"index.php?sitemap-stylesheet=sitemap";s:23:"^wp-sitemap-index\\.xsl$";s:34:"index.php?sitemap-stylesheet=index";s:48:"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$";s:75:"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]";s:34:"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$";s:47:"index.php?sitemap=$matches[1]&paged=$matches[2]";s:47:"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$";s:52:"index.php?category_name=$matches[1]&feed=$matches[2]";s:42:"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$";s:52:"index.php?category_name=$matches[1]&feed=$matches[2]";s:23:"category/(.+?)/embed/?$";s:46:"index.php?category_name=$matches[1]&embed=true";s:35:"category/(.+?)/page/?([0-9]{1,})/?$";s:53:"index.php?category_name=$matches[1]&paged=$matches[2]";s:17:"category/(.+?)/?$";s:35:"index.php?category_name=$matches[1]";s:44:"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:42:"index.php?tag=$matches[1]&feed=$matches[2]";s:39:"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:42:"index.php?tag=$matches[1]&feed=$matches[2]";s:20:"tag/([^/]+)/embed/?$";s:36:"index.php?tag=$matches[1]&embed=true";s:32:"tag/([^/]+)/page/?([0-9]{1,})/?$";s:43:"index.php?tag=$matches[1]&paged=$matches[2]";s:14:"tag/([^/]+)/?$";s:25:"index.php?tag=$matches[1]";s:45:"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:50:"index.php?post_format=$matches[1]&feed=$matches[2]";s:40:"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:50:"index.php?post_format=$matches[1]&feed=$matches[2]";s:21:"type/([^/]+)/embed/?$";s:44:"index.php?post_format=$matches[1]&embed=true";s:33:"type/([^/]+)/page/?([0-9]{1,})/?$";s:51:"index.php?post_format=$matches[1]&paged=$matches[2]";s:15:"type/([^/]+)/?$";s:33:"index.php?post_format=$matches[1]";s:56:"layout_category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:54:"index.php?layout_category=$matches[1]&feed=$matches[2]";s:51:"layout_category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:54:"index.php?layout_category=$matches[1]&feed=$matches[2]";s:32:"layout_category/([^/]+)/embed/?$";s:48:"index.php?layout_category=$matches[1]&embed=true";s:44:"layout_category/([^/]+)/page/?([0-9]{1,})/?$";s:55:"index.php?layout_category=$matches[1]&paged=$matches[2]";s:26:"layout_category/([^/]+)/?$";s:37:"index.php?layout_category=$matches[1]";s:51:"layout_tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?layout_tag=$matches[1]&feed=$matches[2]";s:46:"layout_tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?layout_tag=$matches[1]&feed=$matches[2]";s:27:"layout_tag/([^/]+)/embed/?$";s:43:"index.php?layout_tag=$matches[1]&embed=true";s:39:"layout_tag/([^/]+)/page/?([0-9]{1,})/?$";s:50:"index.php?layout_tag=$matches[1]&paged=$matches[2]";s:21:"layout_tag/([^/]+)/?$";s:32:"index.php?layout_tag=$matches[1]";s:56:"et_tb_item_type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:54:"index.php?et_tb_item_type=$matches[1]&feed=$matches[2]";s:51:"et_tb_item_type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:54:"index.php?et_tb_item_type=$matches[1]&feed=$matches[2]";s:32:"et_tb_item_type/([^/]+)/embed/?$";s:48:"index.php?et_tb_item_type=$matches[1]&embed=true";s:44:"et_tb_item_type/([^/]+)/page/?([0-9]{1,})/?$";s:55:"index.php?et_tb_item_type=$matches[1]&paged=$matches[2]";s:26:"et_tb_item_type/([^/]+)/?$";s:37:"index.php?et_tb_item_type=$matches[1]";s:38:"et_tb_item/[^/]+/attachment/([^/]+)/?$";s:32:"index.php?attachment=$matches[1]";s:48:"et_tb_item/[^/]+/attachment/([^/]+)/trackback/?$";s:37:"index.php?attachment=$matches[1]&tb=1";s:68:"et_tb_item/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:63:"et_tb_item/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:63:"et_tb_item/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$";s:50:"index.php?attachment=$matches[1]&cpage=$matches[2]";s:44:"et_tb_item/[^/]+/attachment/([^/]+)/embed/?$";s:43:"index.php?attachment=$matches[1]&embed=true";s:27:"et_tb_item/([^/]+)/embed/?$";s:58:"index.php?post_type=et_tb_item&name=$matches[1]&embed=true";s:31:"et_tb_item/([^/]+)/trackback/?$";s:52:"index.php?post_type=et_tb_item&name=$matches[1]&tb=1";s:39:"et_tb_item/([^/]+)/page/?([0-9]{1,})/?$";s:65:"index.php?post_type=et_tb_item&name=$matches[1]&paged=$matches[2]";s:46:"et_tb_item/([^/]+)/comment-page-([0-9]{1,})/?$";s:65:"index.php?post_type=et_tb_item&name=$matches[1]&cpage=$matches[2]";s:35:"et_tb_item/([^/]+)(?:/([0-9]+))?/?$";s:64:"index.php?post_type=et_tb_item&name=$matches[1]&page=$matches[2]";s:27:"et_tb_item/[^/]+/([^/]+)/?$";s:32:"index.php?attachment=$matches[1]";s:37:"et_tb_item/[^/]+/([^/]+)/trackback/?$";s:37:"index.php?attachment=$matches[1]&tb=1";s:57:"et_tb_item/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:52:"et_tb_item/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:52:"et_tb_item/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$";s:50:"index.php?attachment=$matches[1]&cpage=$matches[2]";s:33:"et_tb_item/[^/]+/([^/]+)/embed/?$";s:43:"index.php?attachment=$matches[1]&embed=true";s:35:"project/[^/]+/attachment/([^/]+)/?$";s:32:"index.php?attachment=$matches[1]";s:45:"project/[^/]+/attachment/([^/]+)/trackback/?$";s:37:"index.php?attachment=$matches[1]&tb=1";s:65:"project/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:60:"project/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:60:"project/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$";s:50:"index.php?attachment=$matches[1]&cpage=$matches[2]";s:41:"project/[^/]+/attachment/([^/]+)/embed/?$";s:43:"index.php?attachment=$matches[1]&embed=true";s:24:"project/([^/]+)/embed/?$";s:40:"index.php?project=$matches[1]&embed=true";s:28:"project/([^/]+)/trackback/?$";s:34:"index.php?project=$matches[1]&tb=1";s:48:"project/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:46:"index.php?project=$matches[1]&feed=$matches[2]";s:43:"project/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:46:"index.php?project=$matches[1]&feed=$matches[2]";s:36:"project/([^/]+)/page/?([0-9]{1,})/?$";s:47:"index.php?project=$matches[1]&paged=$matches[2]";s:43:"project/([^/]+)/comment-page-([0-9]{1,})/?$";s:47:"index.php?project=$matches[1]&cpage=$matches[2]";s:32:"project/([^/]+)(?:/([0-9]+))?/?$";s:46:"index.php?project=$matches[1]&page=$matches[2]";s:24:"project/[^/]+/([^/]+)/?$";s:32:"index.php?attachment=$matches[1]";s:34:"project/[^/]+/([^/]+)/trackback/?$";s:37:"index.php?attachment=$matches[1]&tb=1";s:54:"project/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:49:"project/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:49:"project/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$";s:50:"index.php?attachment=$matches[1]&cpage=$matches[2]";s:30:"project/[^/]+/([^/]+)/embed/?$";s:43:"index.php?attachment=$matches[1]&embed=true";s:57:"project_category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:55:"index.php?project_category=$matches[1]&feed=$matches[2]";s:52:"project_category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:55:"index.php?project_category=$matches[1]&feed=$matches[2]";s:33:"project_category/([^/]+)/embed/?$";s:49:"index.php?project_category=$matches[1]&embed=true";s:45:"project_category/([^/]+)/page/?([0-9]{1,})/?$";s:56:"index.php?project_category=$matches[1]&paged=$matches[2]";s:27:"project_category/([^/]+)/?$";s:38:"index.php?project_category=$matches[1]";s:52:"project_tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:50:"index.php?project_tag=$matches[1]&feed=$matches[2]";s:47:"project_tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:50:"index.php?project_tag=$matches[1]&feed=$matches[2]";s:28:"project_tag/([^/]+)/embed/?$";s:44:"index.php?project_tag=$matches[1]&embed=true";s:40:"project_tag/([^/]+)/page/?([0-9]{1,})/?$";s:51:"index.php?project_tag=$matches[1]&paged=$matches[2]";s:22:"project_tag/([^/]+)/?$";s:33:"index.php?project_tag=$matches[1]";s:44:"et_theme_options/[^/]+/attachment/([^/]+)/?$";s:32:"index.php?attachment=$matches[1]";s:54:"et_theme_options/[^/]+/attachment/([^/]+)/trackback/?$";s:37:"index.php?attachment=$matches[1]&tb=1";s:74:"et_theme_options/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:69:"et_theme_options/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:69:"et_theme_options/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$";s:50:"index.php?attachment=$matches[1]&cpage=$matches[2]";s:50:"et_theme_options/[^/]+/attachment/([^/]+)/embed/?$";s:43:"index.php?attachment=$matches[1]&embed=true";s:33:"et_theme_options/([^/]+)/embed/?$";s:64:"index.php?post_type=et_theme_options&name=$matches[1]&embed=true";s:37:"et_theme_options/([^/]+)/trackback/?$";s:58:"index.php?post_type=et_theme_options&name=$matches[1]&tb=1";s:45:"et_theme_options/([^/]+)/page/?([0-9]{1,})/?$";s:71:"index.php?post_type=et_theme_options&name=$matches[1]&paged=$matches[2]";s:52:"et_theme_options/([^/]+)/comment-page-([0-9]{1,})/?$";s:71:"index.php?post_type=et_theme_options&name=$matches[1]&cpage=$matches[2]";s:41:"et_theme_options/([^/]+)(?:/([0-9]+))?/?$";s:70:"index.php?post_type=et_theme_options&name=$matches[1]&page=$matches[2]";s:33:"et_theme_options/[^/]+/([^/]+)/?$";s:32:"index.php?attachment=$matches[1]";s:43:"et_theme_options/[^/]+/([^/]+)/trackback/?$";s:37:"index.php?attachment=$matches[1]&tb=1";s:63:"et_theme_options/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:58:"et_theme_options/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:58:"et_theme_options/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$";s:50:"index.php?attachment=$matches[1]&cpage=$matches[2]";s:39:"et_theme_options/[^/]+/([^/]+)/embed/?$";s:43:"index.php?attachment=$matches[1]&embed=true";s:61:"et_code_snippet_type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:59:"index.php?et_code_snippet_type=$matches[1]&feed=$matches[2]";s:56:"et_code_snippet_type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:59:"index.php?et_code_snippet_type=$matches[1]&feed=$matches[2]";s:37:"et_code_snippet_type/([^/]+)/embed/?$";s:53:"index.php?et_code_snippet_type=$matches[1]&embed=true";s:49:"et_code_snippet_type/([^/]+)/page/?([0-9]{1,})/?$";s:60:"index.php?et_code_snippet_type=$matches[1]&paged=$matches[2]";s:31:"et_code_snippet_type/([^/]+)/?$";s:42:"index.php?et_code_snippet_type=$matches[1]";s:43:"et_code_snippet/[^/]+/attachment/([^/]+)/?$";s:32:"index.php?attachment=$matches[1]";s:53:"et_code_snippet/[^/]+/attachment/([^/]+)/trackback/?$";s:37:"index.php?attachment=$matches[1]&tb=1";s:73:"et_code_snippet/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:68:"et_code_snippet/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:68:"et_code_snippet/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$";s:50:"index.php?attachment=$matches[1]&cpage=$matches[2]";s:49:"et_code_snippet/[^/]+/attachment/([^/]+)/embed/?$";s:43:"index.php?attachment=$matches[1]&embed=true";s:32:"et_code_snippet/([^/]+)/embed/?$";s:63:"index.php?post_type=et_code_snippet&name=$matches[1]&embed=true";s:36:"et_code_snippet/([^/]+)/trackback/?$";s:57:"index.php?post_type=et_code_snippet&name=$matches[1]&tb=1";s:44:"et_code_snippet/([^/]+)/page/?([0-9]{1,})/?$";s:70:"index.php?post_type=et_code_snippet&name=$matches[1]&paged=$matches[2]";s:51:"et_code_snippet/([^/]+)/comment-page-([0-9]{1,})/?$";s:70:"index.php?post_type=et_code_snippet&name=$matches[1]&cpage=$matches[2]";s:40:"et_code_snippet/([^/]+)(?:/([0-9]+))?/?$";s:69:"index.php?post_type=et_code_snippet&name=$matches[1]&page=$matches[2]";s:32:"et_code_snippet/[^/]+/([^/]+)/?$";s:32:"index.php?attachment=$matches[1]";s:42:"et_code_snippet/[^/]+/([^/]+)/trackback/?$";s:37:"index.php?attachment=$matches[1]&tb=1";s:62:"et_code_snippet/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:57:"et_code_snippet/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:57:"et_code_snippet/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$";s:50:"index.php?attachment=$matches[1]&cpage=$matches[2]";s:38:"et_code_snippet/[^/]+/([^/]+)/embed/?$";s:43:"index.php?attachment=$matches[1]&embed=true";s:44:"et_theme_builder/[^/]+/attachment/([^/]+)/?$";s:32:"index.php?attachment=$matches[1]";s:54:"et_theme_builder/[^/]+/attachment/([^/]+)/trackback/?$";s:37:"index.php?attachment=$matches[1]&tb=1";s:74:"et_theme_builder/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:69:"et_theme_builder/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:69:"et_theme_builder/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$";s:50:"index.php?attachment=$matches[1]&cpage=$matches[2]";s:50:"et_theme_builder/[^/]+/attachment/([^/]+)/embed/?$";s:43:"index.php?attachment=$matches[1]&embed=true";s:33:"et_theme_builder/([^/]+)/embed/?$";s:64:"index.php?post_type=et_theme_builder&name=$matches[1]&embed=true";s:37:"et_theme_builder/([^/]+)/trackback/?$";s:58:"index.php?post_type=et_theme_builder&name=$matches[1]&tb=1";s:45:"et_theme_builder/([^/]+)/page/?([0-9]{1,})/?$";s:71:"index.php?post_type=et_theme_builder&name=$matches[1]&paged=$matches[2]";s:52:"et_theme_builder/([^/]+)/comment-page-([0-9]{1,})/?$";s:71:"index.php?post_type=et_theme_builder&name=$matches[1]&cpage=$matches[2]";s:41:"et_theme_builder/([^/]+)(?:/([0-9]+))?/?$";s:70:"index.php?post_type=et_theme_builder&name=$matches[1]&page=$matches[2]";s:33:"et_theme_builder/[^/]+/([^/]+)/?$";s:32:"index.php?attachment=$matches[1]";s:43:"et_theme_builder/[^/]+/([^/]+)/trackback/?$";s:37:"index.php?attachment=$matches[1]&tb=1";s:63:"et_theme_builder/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:58:"et_theme_builder/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:58:"et_theme_builder/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$";s:50:"index.php?attachment=$matches[1]&cpage=$matches[2]";s:39:"et_theme_builder/[^/]+/([^/]+)/embed/?$";s:43:"index.php?attachment=$matches[1]&embed=true";s:39:"et_template/[^/]+/attachment/([^/]+)/?$";s:32:"index.php?attachment=$matches[1]";s:49:"et_template/[^/]+/attachment/([^/]+)/trackback/?$";s:37:"index.php?attachment=$matches[1]&tb=1";s:69:"et_template/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:64:"et_template/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:64:"et_template/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$";s:50:"index.php?attachment=$matches[1]&cpage=$matches[2]";s:45:"et_template/[^/]+/attachment/([^/]+)/embed/?$";s:43:"index.php?attachment=$matches[1]&embed=true";s:28:"et_template/([^/]+)/embed/?$";s:59:"index.php?post_type=et_template&name=$matches[1]&embed=true";s:32:"et_template/([^/]+)/trackback/?$";s:53:"index.php?post_type=et_template&name=$matches[1]&tb=1";s:40:"et_template/([^/]+)/page/?([0-9]{1,})/?$";s:66:"index.php?post_type=et_template&name=$matches[1]&paged=$matches[2]";s:47:"et_template/([^/]+)/comment-page-([0-9]{1,})/?$";s:66:"index.php?post_type=et_template&name=$matches[1]&cpage=$matches[2]";s:36:"et_template/([^/]+)(?:/([0-9]+))?/?$";s:65:"index.php?post_type=et_template&name=$matches[1]&page=$matches[2]";s:28:"et_template/[^/]+/([^/]+)/?$";s:32:"index.php?attachment=$matches[1]";s:38:"et_template/[^/]+/([^/]+)/trackback/?$";s:37:"index.php?attachment=$matches[1]&tb=1";s:58:"et_template/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:53:"et_template/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:53:"et_template/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$";s:50:"index.php?attachment=$matches[1]&cpage=$matches[2]";s:34:"et_template/[^/]+/([^/]+)/embed/?$";s:43:"index.php?attachment=$matches[1]&embed=true";s:44:"et_header_layout/[^/]+/attachment/([^/]+)/?$";s:32:"index.php?attachment=$matches[1]";s:54:"et_header_layout/[^/]+/attachment/([^/]+)/trackback/?$";s:37:"index.php?attachment=$matches[1]&tb=1";s:74:"et_header_layout/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:69:"et_header_layout/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:69:"et_header_layout/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$";s:50:"index.php?attachment=$matches[1]&cpage=$matches[2]";s:50:"et_header_layout/[^/]+/attachment/([^/]+)/embed/?$";s:43:"index.php?attachment=$matches[1]&embed=true";s:33:"et_header_layout/([^/]+)/embed/?$";s:64:"index.php?post_type=et_header_layout&name=$matches[1]&embed=true";s:37:"et_header_layout/([^/]+)/trackback/?$";s:58:"index.php?post_type=et_header_layout&name=$matches[1]&tb=1";s:45:"et_header_layout/([^/]+)/page/?([0-9]{1,})/?$";s:71:"index.php?post_type=et_header_layout&name=$matches[1]&paged=$matches[2]";s:52:"et_header_layout/([^/]+)/comment-page-([0-9]{1,})/?$";s:71:"index.php?post_type=et_header_layout&name=$matches[1]&cpage=$matches[2]";s:41:"et_header_layout/([^/]+)(?:/([0-9]+))?/?$";s:70:"index.php?post_type=et_header_layout&name=$matches[1]&page=$matches[2]";s:33:"et_header_layout/[^/]+/([^/]+)/?$";s:32:"index.php?attachment=$matches[1]";s:43:"et_header_layout/[^/]+/([^/]+)/trackback/?$";s:37:"index.php?attachment=$matches[1]&tb=1";s:63:"et_header_layout/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:58:"et_header_layout/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:58:"et_header_layout/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$";s:50:"index.php?attachment=$matches[1]&cpage=$matches[2]";s:39:"et_header_layout/[^/]+/([^/]+)/embed/?$";s:43:"index.php?attachment=$matches[1]&embed=true";s:42:"et_body_layout/[^/]+/attachment/([^/]+)/?$";s:32:"index.php?attachment=$matches[1]";s:52:"et_body_layout/[^/]+/attachment/([^/]+)/trackback/?$";s:37:"index.php?attachment=$matches[1]&tb=1";s:72:"et_body_layout/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:67:"et_body_layout/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:67:"et_body_layout/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$";s:50:"index.php?attachment=$matches[1]&cpage=$matches[2]";s:48:"et_body_layout/[^/]+/attachment/([^/]+)/embed/?$";s:43:"index.php?attachment=$matches[1]&embed=true";s:31:"et_body_layout/([^/]+)/embed/?$";s:62:"index.php?post_type=et_body_layout&name=$matches[1]&embed=true";s:35:"et_body_layout/([^/]+)/trackback/?$";s:56:"index.php?post_type=et_body_layout&name=$matches[1]&tb=1";s:43:"et_body_layout/([^/]+)/page/?([0-9]{1,})/?$";s:69:"index.php?post_type=et_body_layout&name=$matches[1]&paged=$matches[2]";s:50:"et_body_layout/([^/]+)/comment-page-([0-9]{1,})/?$";s:69:"index.php?post_type=et_body_layout&name=$matches[1]&cpage=$matches[2]";s:39:"et_body_layout/([^/]+)(?:/([0-9]+))?/?$";s:68:"index.php?post_type=et_body_layout&name=$matches[1]&page=$matches[2]";s:31:"et_body_layout/[^/]+/([^/]+)/?$";s:32:"index.php?attachment=$matches[1]";s:41:"et_body_layout/[^/]+/([^/]+)/trackback/?$";s:37:"index.php?attachment=$matches[1]&tb=1";s:61:"et_body_layout/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:56:"et_body_layout/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:56:"et_body_layout/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$";s:50:"index.php?attachment=$matches[1]&cpage=$matches[2]";s:37:"et_body_layout/[^/]+/([^/]+)/embed/?$";s:43:"index.php?attachment=$matches[1]&embed=true";s:44:"et_footer_layout/[^/]+/attachment/([^/]+)/?$";s:32:"index.php?attachment=$matches[1]";s:54:"et_footer_layout/[^/]+/attachment/([^/]+)/trackback/?$";s:37:"index.php?attachment=$matches[1]&tb=1";s:74:"et_footer_layout/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:69:"et_footer_layout/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:69:"et_footer_layout/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$";s:50:"index.php?attachment=$matches[1]&cpage=$matches[2]";s:50:"et_footer_layout/[^/]+/attachment/([^/]+)/embed/?$";s:43:"index.php?attachment=$matches[1]&embed=true";s:33:"et_footer_layout/([^/]+)/embed/?$";s:64:"index.php?post_type=et_footer_layout&name=$matches[1]&embed=true";s:37:"et_footer_layout/([^/]+)/trackback/?$";s:58:"index.php?post_type=et_footer_layout&name=$matches[1]&tb=1";s:45:"et_footer_layout/([^/]+)/page/?([0-9]{1,})/?$";s:71:"index.php?post_type=et_footer_layout&name=$matches[1]&paged=$matches[2]";s:52:"et_footer_layout/([^/]+)/comment-page-([0-9]{1,})/?$";s:71:"index.php?post_type=et_footer_layout&name=$matches[1]&cpage=$matches[2]";s:41:"et_footer_layout/([^/]+)(?:/([0-9]+))?/?$";s:70:"index.php?post_type=et_footer_layout&name=$matches[1]&page=$matches[2]";s:33:"et_footer_layout/[^/]+/([^/]+)/?$";s:32:"index.php?attachment=$matches[1]";s:43:"et_footer_layout/[^/]+/([^/]+)/trackback/?$";s:37:"index.php?attachment=$matches[1]&tb=1";s:63:"et_footer_layout/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:58:"et_footer_layout/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:58:"et_footer_layout/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$";s:50:"index.php?attachment=$matches[1]&cpage=$matches[2]";s:39:"et_footer_layout/[^/]+/([^/]+)/embed/?$";s:43:"index.php?attachment=$matches[1]&embed=true";s:12:"robots\\.txt$";s:18:"index.php?robots=1";s:13:"favicon\\.ico$";s:19:"index.php?favicon=1";s:12:"sitemap\\.xml";s:23:"index.php?sitemap=index";s:48:".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$";s:18:"index.php?feed=old";s:20:".*wp-app\\.php(/.*)?$";s:19:"index.php?error=403";s:18:".*wp-register.php$";s:23:"index.php?register=true";s:32:"feed/(feed|rdf|rss|rss2|atom)/?$";s:27:"index.php?&feed=$matches[1]";s:27:"(feed|rdf|rss|rss2|atom)/?$";s:27:"index.php?&feed=$matches[1]";s:8:"embed/?$";s:21:"index.php?&embed=true";s:20:"page/?([0-9]{1,})/?$";s:28:"index.php?&paged=$matches[1]";s:27:"comment-page-([0-9]{1,})/?$";s:43:"index.php?&page_id=204189&cpage=$matches[1]";s:41:"comments/feed/(feed|rdf|rss|rss2|atom)/?$";s:42:"index.php?&feed=$matches[1]&withcomments=1";s:36:"comments/(feed|rdf|rss|rss2|atom)/?$";s:42:"index.php?&feed=$matches[1]&withcomments=1";s:17:"comments/embed/?$";s:21:"index.php?&embed=true";s:44:"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:40:"index.php?s=$matches[1]&feed=$matches[2]";s:39:"search/(.+)/(feed|rdf|rss|rss2|atom)/?$";s:40:"index.php?s=$matches[1]&feed=$matches[2]";s:20:"search/(.+)/embed/?$";s:34:"index.php?s=$matches[1]&embed=true";s:32:"search/(.+)/page/?([0-9]{1,})/?$";s:41:"index.php?s=$matches[1]&paged=$matches[2]";s:14:"search/(.+)/?$";s:23:"index.php?s=$matches[1]";s:47:"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:50:"index.php?author_name=$matches[1]&feed=$matches[2]";s:42:"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:50:"index.php?author_name=$matches[1]&feed=$matches[2]";s:23:"author/([^/]+)/embed/?$";s:44:"index.php?author_name=$matches[1]&embed=true";s:35:"author/([^/]+)/page/?([0-9]{1,})/?$";s:51:"index.php?author_name=$matches[1]&paged=$matches[2]";s:17:"author/([^/]+)/?$";s:33:"index.php?author_name=$matches[1]";s:69:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$";s:80:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]";s:64:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$";s:80:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]";s:45:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$";s:74:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true";s:57:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$";s:81:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]";s:39:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$";s:63:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]";s:56:"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$";s:64:"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]";s:51:"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$";s:64:"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]";s:32:"([0-9]{4})/([0-9]{1,2})/embed/?$";s:58:"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true";s:44:"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$";s:65:"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]";s:26:"([0-9]{4})/([0-9]{1,2})/?$";s:47:"index.php?year=$matches[1]&monthnum=$matches[2]";s:43:"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$";s:43:"index.php?year=$matches[1]&feed=$matches[2]";s:38:"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$";s:43:"index.php?year=$matches[1]&feed=$matches[2]";s:19:"([0-9]{4})/embed/?$";s:37:"index.php?year=$matches[1]&embed=true";s:31:"([0-9]{4})/page/?([0-9]{1,})/?$";s:44:"index.php?year=$matches[1]&paged=$matches[2]";s:13:"([0-9]{4})/?$";s:26:"index.php?year=$matches[1]";s:27:".?.+?/attachment/([^/]+)/?$";s:32:"index.php?attachment=$matches[1]";s:37:".?.+?/attachment/([^/]+)/trackback/?$";s:37:"index.php?attachment=$matches[1]&tb=1";s:57:".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:52:".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:52:".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$";s:50:"index.php?attachment=$matches[1]&cpage=$matches[2]";s:33:".?.+?/attachment/([^/]+)/embed/?$";s:43:"index.php?attachment=$matches[1]&embed=true";s:16:"(.?.+?)/embed/?$";s:41:"index.php?pagename=$matches[1]&embed=true";s:20:"(.?.+?)/trackback/?$";s:35:"index.php?pagename=$matches[1]&tb=1";s:40:"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$";s:47:"index.php?pagename=$matches[1]&feed=$matches[2]";s:35:"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$";s:47:"index.php?pagename=$matches[1]&feed=$matches[2]";s:28:"(.?.+?)/page/?([0-9]{1,})/?$";s:48:"index.php?pagename=$matches[1]&paged=$matches[2]";s:35:"(.?.+?)/comment-page-([0-9]{1,})/?$";s:48:"index.php?pagename=$matches[1]&cpage=$matches[2]";s:24:"(.?.+?)(?:/([0-9]+))?/?$";s:47:"index.php?pagename=$matches[1]&page=$matches[2]";s:27:"[^/]+/attachment/([^/]+)/?$";s:32:"index.php?attachment=$matches[1]";s:37:"[^/]+/attachment/([^/]+)/trackback/?$";s:37:"index.php?attachment=$matches[1]&tb=1";s:57:"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:52:"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:52:"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$";s:50:"index.php?attachment=$matches[1]&cpage=$matches[2]";s:33:"[^/]+/attachment/([^/]+)/embed/?$";s:43:"index.php?attachment=$matches[1]&embed=true";s:16:"([^/]+)/embed/?$";s:37:"index.php?name=$matches[1]&embed=true";s:20:"([^/]+)/trackback/?$";s:31:"index.php?name=$matches[1]&tb=1";s:40:"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:43:"index.php?name=$matches[1]&feed=$matches[2]";s:35:"([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:43:"index.php?name=$matches[1]&feed=$matches[2]";s:28:"([^/]+)/page/?([0-9]{1,})/?$";s:44:"index.php?name=$matches[1]&paged=$matches[2]";s:35:"([^/]+)/comment-page-([0-9]{1,})/?$";s:44:"index.php?name=$matches[1]&cpage=$matches[2]";s:24:"([^/]+)(?:/([0-9]+))?/?$";s:43:"index.php?name=$matches[1]&page=$matches[2]";s:16:"[^/]+/([^/]+)/?$";s:32:"index.php?attachment=$matches[1]";s:26:"[^/]+/([^/]+)/trackback/?$";s:37:"index.php?attachment=$matches[1]&tb=1";s:46:"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:41:"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:41:"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$";s:50:"index.php?attachment=$matches[1]&cpage=$matches[2]";s:22:"[^/]+/([^/]+)/embed/?$";s:43:"index.php?attachment=$matches[1]&embed=true";}','yes');
INSERT INTO `wp5_options` VALUES (137366,'et_divi_builder_global_presets_ng','O:8:"stdClass":0:{}','off');
INSERT INTO `wp5_options` VALUES (5464,'et_pb_contact_form_34cc352e42e3f1501614b94e2b43091b','off','yes');
INSERT INTO `wp5_options` VALUES (2951,'fs_active_plugins','O:8:"stdClass":0:{}','yes');
INSERT INTO `wp5_options` VALUES (2952,'fs_debug_mode','','yes');
INSERT INTO `wp5_options` VALUES (2953,'fs_accounts','a:6:{s:21:"id_slug_type_path_map";a:1:{i:6220;a:2:{s:4:"slug";s:19:"cf7-styler-for-divi";s:4:"type";s:6:"plugin";}}s:11:"plugin_data";a:1:{s:19:"cf7-styler-for-divi";a:15:{s:16:"plugin_main_file";O:8:"stdClass":1:{s:9:"prev_path";s:34:"cf7-styler-for-divi/cf7-styler.php";}s:20:"is_network_activated";b:0;s:17:"install_timestamp";i:1606432149;s:17:"was_plugin_loaded";b:1;s:21:"is_plugin_new_install";b:0;s:16:"sdk_last_version";s:5:"2.3.2";s:11:"sdk_version";s:5:"2.4.3";s:16:"sdk_upgrade_mode";b:1;s:18:"sdk_downgrade_mode";b:0;s:19:"plugin_last_version";s:5:"1.2.6";s:14:"plugin_version";s:5:"1.3.0";s:19:"plugin_upgrade_mode";b:1;s:21:"plugin_downgrade_mode";b:0;s:17:"connectivity_test";a:6:{s:12:"is_connected";b:1;s:4:"host";s:30:"gibson.authorwebsiteinabox.com";s:9:"server_ip";s:37:"2601:144:202:41f0:b905:2977:928a:35af";s:9:"is_active";b:1;s:9:"timestamp";i:1606432149;s:7:"version";s:5:"1.1.8";}s:15:"prev_is_premium";b:0;}}s:13:"file_slug_map";a:1:{s:34:"cf7-styler-for-divi/cf7-styler.php";s:19:"cf7-styler-for-divi";}s:7:"plugins";a:1:{s:19:"cf7-styler-for-divi";O:9:"FS_Plugin":23:{s:16:"parent_plugin_id";N;s:5:"title";s:19:"Divi Contact Form 7";s:4:"slug";s:19:"cf7-styler-for-divi";s:12:"premium_slug";s:27:"cf7-styler-for-divi-premium";s:4:"type";s:6:"plugin";s:20:"affiliate_moderation";b:0;s:19:"is_wp_org_compliant";b:1;s:22:"premium_releases_count";N;s:4:"file";s:34:"cf7-styler-for-divi/cf7-styler.php";s:7:"version";s:5:"1.3.0";s:11:"auto_update";N;s:4:"info";N;s:10:"is_premium";b:1;s:14:"premium_suffix";s:9:"(Premium)";s:7:"is_live";b:1;s:9:"bundle_id";N;s:17:"bundle_public_key";N;s:10:"public_key";s:32:"pk_5ed03b8670d0cfbf345aa03dc6c80";s:10:"secret_key";N;s:2:"id";s:4:"6220";s:7:"updated";N;s:7:"created";N;s:22:"\0FS_Entity\0_is_updated";b:0;}}s:9:"unique_id";s:32:"d11e50ffcedb2a9c95a1bc052816a707";s:13:"admin_notices";a:1:{s:19:"cf7-styler-for-divi";a:0:{}}}','yes');
INSERT INTO `wp5_options` VALUES (2954,'fs_gdpr','a:1:{s:2:"u1";a:1:{s:8:"required";b:0;}}','yes');
INSERT INTO `wp5_options` VALUES (2955,'fs_api_cache','a:0:{}','no');
INSERT INTO `wp5_options` VALUES (2958,'dipe_version','1.1.8','yes');
INSERT INTO `wp5_options` VALUES (2964,'_dipe_cf7_installed_time','1606432150','yes');
INSERT INTO `wp5_options` VALUES (5002,'auto_update_core_major','enabled','yes');
INSERT INTO `wp5_options` VALUES (5433,'et_pb_signup_15d9cc34d78d6994c3f95af9fccde19b','off','yes');
INSERT INTO `wp5_options` VALUES (1512,'et_bloom_options','a:3:{s:14:"schema_version";i:1;s:10:"db_version";s:3:"1.2";s:7:"optin_1";a:78:{s:10:"optin_type";s:6:"pop_up";s:12:"optin_status";s:8:"inactive";s:11:"test_status";s:0:"";s:8:"child_of";s:0:"";s:12:"child_optins";a:0:{}s:10:"next_optin";s:2:"-1";s:10:"optin_name";s:6:"pop-up";s:14:"email_provider";s:5:"empty";s:12:"account_name";s:5:"empty";s:10:"email_list";s:5:"empty";s:11:"custom_html";s:0:"";s:10:"ip_address";s:4:"true";s:16:"enable_dbl_optin";b:0;s:10:"message_id";s:0:"";s:11:"optin_title";s:48:"&lt;h2&gt;Subscribe To Our Newsletter&lt;/h2&gt;";s:13:"optin_message";s:94:"&lt;p&gt;Join our mailing list to receive the latest news and updates from our team.&lt;/p&gt;";s:17:"image_orientation";s:4:"left";s:24:"image_orientation_widget";s:5:"above";s:9:"image_url";a:2:{s:3:"url";s:91:"https://gibson.authorwebsiteinabox.com/wp-content/plugins/bloom/images/premade-image-03.png";s:2:"id";s:0:"";}s:15:"image_animation";s:7:"slideup";s:11:"hide_mobile";b:0;s:15:"header_bg_color";s:7:"#ffffff";s:11:"header_font";s:9:"Open Sans";s:9:"body_font";s:9:"Open Sans";s:17:"header_text_color";s:4:"dark";s:12:"corner_style";s:7:"squared";s:18:"border_orientation";s:9:"no_border";s:12:"border_color";s:7:"#424242";s:12:"border_style";s:5:"solid";s:16:"form_orientation";s:6:"bottom";s:12:"display_name";b:0;s:11:"name_fields";s:7:"no_name";s:9:"name_text";s:0:"";s:16:"single_name_text";s:0:"";s:14:"name_fullwidth";s:0:"";s:9:"last_name";s:0:"";s:19:"last_name_fullwidth";s:0:"";s:10:"email_text";s:0:"";s:15:"email_fullwidth";s:0:"";s:11:"button_text";s:0:"";s:17:"use_custom_fields";s:3:"off";s:13:"custom_fields";s:0:"";s:17:"field_orientation";s:6:"inline";s:12:"field_corner";s:7:"rounded";s:10:"text_color";s:4:"dark";s:13:"form_bg_color";s:7:"#ededed";s:17:"form_button_color";s:7:"#a153e0";s:17:"button_text_color";s:5:"light";s:10:"edge_style";s:10:"basic_edge";s:11:"footer_text";s:0:"";s:15:"success_message";s:0:"";s:10:"custom_css";s:0:"";s:17:"flyin_orientation";s:5:"right";s:14:"load_animation";s:6:"fadein";s:12:"trigger_auto";b:0;s:10:"load_delay";i:20;s:12:"trigger_idle";s:1:"1";s:12:"idle_timeout";i:15;s:11:"post_bottom";b:0;s:15:"comment_trigger";b:0;s:14:"trigger_scroll";b:0;s:10:"scroll_pos";i:50;s:16:"purchase_trigger";b:0;s:13:"trigger_click";s:1:"1";s:22:"trigger_click_selector";s:15:"a.trigger_popup";s:7:"session";s:1:"1";s:16:"session_duration";i:30;s:17:"hide_mobile_optin";b:0;s:10:"auto_close";s:1:"1";s:10:"display_on";a:1:{i:0;s:10:"everything";}s:10:"post_types";a:1:{i:0;s:4:"post";}s:15:"post_categories";a:3:{i:0;s:1:"1";s:11:"auto_select";s:1:"1";s:16:"previously_saved";s:1:"1";}s:13:"pages_include";s:0:"";s:13:"pages_exclude";s:0:"";s:13:"posts_exclude";s:0:"";s:13:"posts_include";s:0:"";s:19:"success_action_type";s:7:"default";s:19:"success_action_info";s:0:"";}}','yes');
INSERT INTO `wp5_options` VALUES (1513,'et_core_api_email_options','a:2:{i:0;b:0;s:8:"accounts";a:2:{s:9:"mailchimp";a:1:{s:7:"SlavaET";a:0:{}}s:10:"mailerlite";a:0:{}}}','yes');
INSERT INTO `wp5_options` VALUES (1514,'widget_bloomwidget','a:1:{s:12:"_multiwidget";i:1;}','yes');
INSERT INTO `wp5_options` VALUES (2881,'widget_akismet_widget','a:1:{s:12:"_multiwidget";i:1;}','yes');
INSERT INTO `wp5_options` VALUES (2883,'yoast_migrations_free','a:1:{s:7:"version";s:4:"15.3";}','yes');
INSERT INTO `wp5_options` VALUES (2884,'wpseo_titles','a:94:{s:17:"forcerewritetitle";b:0;s:9:"separator";s:7:"sc-dash";s:16:"title-home-wpseo";s:42:"%%sitename%% %%page%% %%sep%% %%sitedesc%%";s:18:"title-author-wpseo";s:41:"%%name%%, Author at %%sitename%% %%page%%";s:19:"title-archive-wpseo";s:38:"%%date%% %%page%% %%sep%% %%sitename%%";s:18:"title-search-wpseo";s:63:"You searched for %%searchphrase%% %%page%% %%sep%% %%sitename%%";s:15:"title-404-wpseo";s:35:"Page not found %%sep%% %%sitename%%";s:19:"metadesc-home-wpseo";s:0:"";s:21:"metadesc-author-wpseo";s:0:"";s:22:"metadesc-archive-wpseo";s:0:"";s:9:"rssbefore";s:0:"";s:8:"rssafter";s:53:"The post %%POSTLINK%% appeared first on %%BLOGLINK%%.";s:20:"noindex-author-wpseo";b:0;s:28:"noindex-author-noposts-wpseo";b:1;s:21:"noindex-archive-wpseo";b:1;s:14:"disable-author";b:0;s:12:"disable-date";b:0;s:19:"disable-post_format";b:0;s:18:"disable-attachment";b:1;s:23:"is-media-purge-relevant";b:0;s:20:"breadcrumbs-404crumb";s:25:"Error 404: Page not found";s:29:"breadcrumbs-display-blog-page";b:1;s:20:"breadcrumbs-boldlast";b:0;s:25:"breadcrumbs-archiveprefix";s:12:"Archives for";s:18:"breadcrumbs-enable";b:0;s:16:"breadcrumbs-home";s:4:"Home";s:18:"breadcrumbs-prefix";s:0:"";s:24:"breadcrumbs-searchprefix";s:16:"You searched for";s:15:"breadcrumbs-sep";s:7:"&raquo;";s:12:"website_name";s:0:"";s:11:"person_name";s:0:"";s:11:"person_logo";s:0:"";s:14:"person_logo_id";i:0;s:22:"alternate_website_name";s:0:"";s:12:"company_logo";s:0:"";s:15:"company_logo_id";i:0;s:12:"company_name";s:0:"";s:17:"company_or_person";s:7:"company";s:25:"company_or_person_user_id";b:0;s:17:"stripcategorybase";b:0;s:10:"title-post";s:39:"%%title%% %%page%% %%sep%% %%sitename%%";s:13:"metadesc-post";s:0:"";s:12:"noindex-post";b:0;s:23:"display-metabox-pt-post";b:1;s:23:"post_types-post-maintax";i:0;s:21:"schema-page-type-post";s:7:"WebPage";s:24:"schema-article-type-post";s:7:"Article";s:10:"title-page";s:39:"%%title%% %%page%% %%sep%% %%sitename%%";s:13:"metadesc-page";s:0:"";s:12:"noindex-page";b:0;s:23:"display-metabox-pt-page";b:1;s:23:"post_types-page-maintax";i:0;s:21:"schema-page-type-page";s:7:"WebPage";s:24:"schema-article-type-page";s:4:"None";s:16:"title-attachment";s:39:"%%title%% %%page%% %%sep%% %%sitename%%";s:19:"metadesc-attachment";s:0:"";s:18:"noindex-attachment";b:0;s:29:"display-metabox-pt-attachment";b:1;s:29:"post_types-attachment-maintax";i:0;s:27:"schema-page-type-attachment";s:7:"WebPage";s:30:"schema-article-type-attachment";s:4:"None";s:13:"title-project";s:39:"%%title%% %%page%% %%sep%% %%sitename%%";s:16:"metadesc-project";s:0:"";s:15:"noindex-project";b:0;s:26:"display-metabox-pt-project";b:1;s:26:"post_types-project-maintax";i:0;s:24:"schema-page-type-project";s:7:"WebPage";s:27:"schema-article-type-project";s:4:"None";s:23:"title-ptarchive-project";s:51:"%%pt_plural%% Archive %%page%% %%sep%% %%sitename%%";s:26:"metadesc-ptarchive-project";s:0:"";s:25:"bctitle-ptarchive-project";s:0:"";s:25:"noindex-ptarchive-project";b:0;s:18:"title-tax-category";s:53:"%%term_title%% Archives %%page%% %%sep%% %%sitename%%";s:21:"metadesc-tax-category";s:0:"";s:28:"display-metabox-tax-category";b:1;s:20:"noindex-tax-category";b:0;s:18:"title-tax-post_tag";s:53:"%%term_title%% Archives %%page%% %%sep%% %%sitename%%";s:21:"metadesc-tax-post_tag";s:0:"";s:28:"display-metabox-tax-post_tag";b:1;s:20:"noindex-tax-post_tag";b:0;s:21:"title-tax-post_format";s:53:"%%term_title%% Archives %%page%% %%sep%% %%sitename%%";s:24:"metadesc-tax-post_format";s:0:"";s:31:"display-metabox-tax-post_format";b:1;s:23:"noindex-tax-post_format";b:1;s:26:"title-tax-project_category";s:53:"%%term_title%% Archives %%page%% %%sep%% %%sitename%%";s:29:"metadesc-tax-project_category";s:0:"";s:36:"display-metabox-tax-project_category";b:1;s:28:"noindex-tax-project_category";b:0;s:34:"taxonomy-project_category-ptparent";i:0;s:21:"title-tax-project_tag";s:53:"%%term_title%% Archives %%page%% %%sep%% %%sitename%%";s:24:"metadesc-tax-project_tag";s:0:"";s:31:"display-metabox-tax-project_tag";b:1;s:23:"noindex-tax-project_tag";b:0;s:29:"taxonomy-project_tag-ptparent";i:0;}','yes');
INSERT INTO `wp5_options` VALUES (5000,'auto_update_core_dev','enabled','yes');
INSERT INTO `wp5_options` VALUES (5001,'auto_update_core_minor','enabled','yes');
INSERT INTO `wp5_options` VALUES (5328,'mwp_service_key','4ec70081-0f8f-4a3e-836b-709e90b58d75','yes');
INSERT INTO `wp5_options` VALUES (137404,'mmb_stats_filter','a:1:{s:7:"plugins";a:1:{s:7:"cleanup";a:1:{s:9:"revisions";a:1:{s:11:"num_to_keep";i:5;}}}}','auto');
INSERT INTO `wp5_options` VALUES (5331,'mwp_openssl_parameters','a:2:{s:4:"time";i:1768125017;s:7:"working";b:1;}','on');
INSERT INTO `wp5_options` VALUES (5332,'mwp_incremental_update_active','','yes');
INSERT INTO `wp5_options` VALUES (5339,'worker_migration_version','2','yes');
INSERT INTO `wp5_options` VALUES (5348,'mwp_public_keys_refresh_time','1768073080','on');
INSERT INTO `wp5_options` VALUES (5349,'mwp_public_keys','a:13:{i:0;a:6:{s:2:"id";s:19:"managewp_1764381901";s:7:"service";s:8:"managewp";s:9:"validFrom";s:19:"2025-12-14 01:26:15";s:7:"validTo";s:19:"2026-01-15 01:26:15";s:9:"publicKey";s:451:"-----BEGIN PUBLIC KEY-----\nMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEApZOG5rCLu1IzkRJv9Klq\nggPAByaTgPN1ccNcexQkIgbbADmzJFr3fTYB/YW1PoJuM9/Fky3vYzMpQcZT6dUk\nbK5gjWBpXywNyxHBc/P+4M6BfP2hZcQAu3BpleHOAX/nTTSa1LHZgdlBeDNeuwpI\nuKKhyPGXPsA1U4yRqBvZRedAyAF5rm5J2vT1rTf67MWaZZ4siwHXjOwEBQIf/nMt\nnGQe6jnx4peifsSXhX/BOXK9bVlTjxIvpcIm+8LIbnoJnJZ/sB6USaNcJrn4RVdP\n8S+qFBcorVlg3KUAeB1W052BGZ5gdQjjqC6SSsF0OBMfup+JtpykDqrpJgmQnp5w\nmwIDAQAB\n-----END PUBLIC KEY-----\n";s:13:"useServiceKey";b:0;}i:1;a:6:{s:2:"id";s:19:"managewp_1766973902";s:7:"service";s:8:"managewp";s:9:"validFrom";s:19:"2026-01-13 01:26:15";s:7:"validTo";s:19:"2026-02-14 01:26:15";s:9:"publicKey";s:451:"-----BEGIN PUBLIC KEY-----\nMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA1Hj9fe6y2gDzKhPiQ+yQ\nLXJ7SYHR2sTbiTDGvoC4m9VdpE8CNTiaK3PKnVWYg+qnk+nzen1ZE+ubxE0f99gl\nYQ0+I25CUiQDtLnsuArTVqyU1tpHYthhA1Ru4Akqf1jpAnu6H/Kr9ZLc2BvQ8yo+\nefQ2lurACEJBp+61sWcnD9nRiGKUlyRHnhxsLMCoQgX1doQ+zceXqRMzj/Yq0Bca\nZMteRUwvndYuvJYtm4KSP9Sz9aHdx289Bg9tmBJSRpGXCNguXJQLYvspX6Lkjx3V\n6jZHbUz96pK/L8mg9SfC5p0cFHZ/TvqmwVVDPoZYkIZmDXGIn1JERzcuUblCWhC/\nzwIDAQAB\n-----END PUBLIC KEY-----\n";s:13:"useServiceKey";b:0;}i:2;a:6:{s:2:"id";s:23:"managewp_dev_1764381901";s:7:"service";s:12:"managewp_dev";s:9:"validFrom";s:19:"2025-12-14 01:26:15";s:7:"validTo";s:19:"2026-01-15 01:26:15";s:9:"publicKey";s:451:"-----BEGIN PUBLIC KEY-----\nMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAtiGYLUKhnAu/q1qFp/70\nx5NnrxbaApKLMeLMdBrWVYyKh+7jzCMmA2IAAq+eOvxN/7T5/ELhFzTM6N2GrDdq\nv5gHgM63bcqy9U6CxQ810oJ1t4hpoP11LRX1UhsWo/DPwxCScmryMki2SLrv2umP\n1tTz/JS+ntqdd7uVIW1Z30NKxv+Cmc0SsplPPaKa5iB1OKJqiLISnn/uIUogLLv8\nj+u8Ti1x3DuwoYEelcHZNXfJLubYMwKat9uBJEIMVUaTkX+eSeRmScP80tjkZhvt\ni+3kftXuYsPop+XwVOfXaN6P+yX+ewfRYxnCBZxODeCnFKfAQ97Xodtp4EQzp8pg\n+wIDAQAB\n-----END PUBLIC KEY-----\n";s:13:"useServiceKey";b:0;}i:3;a:6:{s:2:"id";s:23:"managewp_dev_1766973902";s:7:"service";s:12:"managewp_dev";s:9:"validFrom";s:19:"2026-01-13 01:26:15";s:7:"validTo";s:19:"2026-02-14 01:26:15";s:9:"publicKey";s:451:"-----BEGIN PUBLIC KEY-----\nMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAwMuExqzRd5P3fj+yvOYX\np/sm19CbRMtw7rL6aGJG2yrtx2dyKBB8EvdMWjLSJRAslzeTDQ6FNCVc4VrF8Ssl\n3VaQRsKMRo+1hDFWx8FNPJYJBTyvJYLuM5z7rwLk/aG1ZQVyWiNOfHq49aAoXVwJ\n5aYr6kEhhYrpBKpMjf1g1KfwDB/65iIb0FuG69eLBP57KbNtGojcDQrgb4SKBeUy\n1JZc3eGosW3IqhnzqeaOjH1JEBTuBrL0yPMh2w51U5M8KxWxO0EI1SnADuXglczL\n+o5c96he7AetW4up1gmosNjEvRFxHz+kuWynk9QoJ6KGKMwEO7uHP0TGQPRTJfSn\nXQIDAQAB\n-----END PUBLIC KEY-----\n";s:13:"useServiceKey";b:0;}i:4;a:6:{s:2:"id";s:16:"mwp20_1764381901";s:7:"service";s:5:"mwp20";s:9:"validFrom";s:19:"2025-12-14 01:26:15";s:7:"validTo";s:19:"2026-01-15 01:26:15";s:9:"publicKey";s:451:"-----BEGIN PUBLIC KEY-----\nMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA8v/gbBMOVxnVk/F3D7pg\n/NyCrijtG2ZDcLb9mk5WDO6FKA6QbLe8r9Khuj9fF0x0P59HxDJMbm0rKNh8v29g\nQ0TJ3FYICSSmtI7nGojZDpFHI0eLHFTvzBGkRiq/+C5lVTD+qSmfy4xgpcr5tbbo\nvyEh3lSzp+gR3h1zY/tzMauWrMVp5Sk6WFrsodNBhwFJpoWRSTNoAMuH9D5s8Rer\n9Aj5JQyhp6KxO3dZ8n2Z95AX11iDlAiDleSgRiwzzd3AAXhPT2UneZTd32/YWsKx\nZwc+GojnHIRz8ZjUKk2bYzbqyGZR8udhnQtDOvhH8d/5PRDHD9vyNgynErvQfXyR\ntwIDAQAB\n-----END PUBLIC KEY-----\n";s:13:"useServiceKey";b:1;}i:5;a:6:{s:2:"id";s:16:"mwp20_1766973902";s:7:"service";s:5:"mwp20";s:9:"validFrom";s:19:"2026-01-13 01:26:15";s:7:"validTo";s:19:"2026-02-14 01:26:15";s:9:"publicKey";s:451:"-----BEGIN PUBLIC KEY-----\nMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA0G1J15oJbCyXPpV/EZGe\n7KqWgqcHGEb7Jtg3TG4m3MPenmEKieuzUgi3PPg7+1Ai2dy6N7z7mwz2FW7N/NtH\n7qOqqUM87ndlQBesRpzVkZHIhVGmuyoakDp/qg5K8aJUalECoonRrzHPqVK2AOWr\naiGYIauUp8H9Cemsr3SACoXlOEFBtUt6D4HNTxaFZZSP0naBF4lbuPwZLlrP3tKV\n299T6uuFvB6rwcXbkmIXA+GB6wjupqhIsqTFmzy8d5eQmSK1KKmz+gl/I2uh6LiT\nQNo+tqx1vV4LlRLZknUrkqE0AouwM6G9N48cvmwyRxC3oSF1fzhcwxql4N6Qzfm8\nQQIDAQAB\n-----END PUBLIC KEY-----\n";s:13:"useServiceKey";b:1;}i:6;a:6:{s:2:"id";s:15:"wpps_1766581502";s:7:"service";s:4:"wpps";s:9:"validFrom";s:19:"2026-01-08 13:05:01";s:7:"validTo";s:19:"2026-02-09 13:05:01";s:9:"publicKey";s:451:"-----BEGIN PUBLIC KEY-----\nMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAiudlbQbBSwfM/JRnpp8P\nVhgjA25HX0u16i3RUgiFy5YBgfz11tow16eJQXqLHClcbydjTyEZiJYLy7b9wpGg\nnnV6zhDJ3dibdljqh6iLFsCRIilIXRUeDzF8cSSpb7+TkyDpMSAn23krnYLDq+cb\nd2i4d6mCuwwtz4IkkqJVr9VIAECrjxyBQ6joBxlptVTHZYSsseZa1F/0UcjIQYWf\nunrH4DeuAVnVXlXV1OKGJS/mk5Tv3jP35Diza7eePAIyUQKgkztMKNlp0buIYkjv\nrrxv8StVZOaeppJZ5IWfqNFm4pbPqmpPf5D8MuDfHOTiMjHpMTzkYcU54qqndPh0\nXwIDAQAB\n-----END PUBLIC KEY-----\n";s:13:"useServiceKey";b:1;}i:7;a:6:{s:2:"id";s:25:"cookie_service_1765213501";s:7:"service";s:14:"cookie_service";s:9:"validFrom";s:19:"2025-12-23 16:27:25";s:7:"validTo";s:19:"2026-01-24 16:27:25";s:9:"publicKey";s:451:"-----BEGIN PUBLIC KEY-----\nMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAwocxMdKYgY9FUlxMLSsP\nhbDSYMAFC0CFqPzVFc2p/p1o8qgNppXS08PGYXa+bZbPXZ0gRzDAsvdbW7N36evg\nB6NwWLoMtIr0lVwyVs27b6aTirafVyHVITOVEdcIY77/9z5GWXCwR8597usQs82Y\nYenUR/ceKt32GDsd48DelXylEEgOLcVfvClsIbwR6/i58YBhHFLhROIxucRNju5i\nGLSaZMat+iTECD4oVUyDW6/U0FbJl5YgK/e6XQtuE2oDoUzO2Jl031qYDLIU47qt\njypcIpK2OEvs0hN+OrSd5QDuZlP7nK6xFOd/ZXbmLKLGnZYpPSQ2Xcb8TzUn60Yr\nuwIDAQAB\n-----END PUBLIC KEY-----\n";s:13:"useServiceKey";b:1;}i:8;a:6:{s:2:"id";s:25:"cookie_service_1767805501";s:7:"service";s:14:"cookie_service";s:9:"validFrom";s:19:"2026-01-22 16:27:25";s:7:"validTo";s:19:"2026-02-23 16:27:25";s:9:"publicKey";s:451:"-----BEGIN PUBLIC KEY-----\nMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAuYy0onNSkbOHwb8Jawxm\nNolUoXk59OthwYNMH0iHQ0BsJKreg6MHmYX0qrIPnVe844nW4aRNZvceUmpk5sGp\nUi0rezIJGXND+OysucD5FZyg3m0dHXYcvbHx8/imk6Qa6CoPhDzvlXqO1n7/2Dv6\nWfsOoV+f7CQFcB+zgUdghdPAQwfnh/iAA3UePS5x1Gy2hPv2q5fffrswZf3a8JM5\n235VbaUx40YWS2RJAsBZsDqOTb2sSOgyTr5A5Gg2TIQpYR+ruaZaZVzV7AX/+ALU\n6R9WTMLzbme7+BPejJnux2ZkfbxeaqemxJ3v4kB1GKzv9rNT+WxOKjDgOurNO2mt\nCQIDAQAB\n-----END PUBLIC KEY-----\n";s:13:"useServiceKey";b:1;}i:9;a:6:{s:2:"id";s:15:"mwp1_1764079502";s:7:"service";s:4:"mwp1";s:9:"validFrom";s:19:"2025-12-10 14:05:01";s:7:"validTo";s:19:"2026-01-11 14:05:01";s:9:"publicKey";s:451:"-----BEGIN PUBLIC KEY-----\nMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAyhygc+ewn34bjDBws0os\nLEdQ1tP/Qq2SV6XHju6GW7f6WmeMYfGg2dqYp5kt42uKYeYANubnN/OgHGMwrOGN\nOawII56hYh3bx8FkaoE2PPyM4Yo3k0LRfNDHRrOiF25Llq1wYhWlpF4J0W+66DpI\nwufy1wU2UlG2YYCxCB9kwHbsLaxaEiOvFEFF9DmN2FzsWs1pK185/YuMcHSJT5hz\nor27GyPhfS32/I2d6YDKGV1LY+J4js4nG8c0uuzpcd1iVPAFPDsWiif1B+1+BKQD\nb14DF7OV98viUQ/xDAg1u/irgdS4Ka89+e9fvxo2dqMrbIu/1pInb7uz95kfc0ta\nFwIDAQAB\n-----END PUBLIC KEY-----\n";s:13:"useServiceKey";b:1;}i:10;a:6:{s:2:"id";s:15:"mwp1_1766671502";s:7:"service";s:4:"mwp1";s:9:"validFrom";s:19:"2026-01-09 14:05:01";s:7:"validTo";s:19:"2026-02-10 14:05:01";s:9:"publicKey";s:451:"-----BEGIN PUBLIC KEY-----\nMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA54M76iGjuNl2Q2XsipX3\nJLLfzeA0g0cgYasDV1FGUcNSEcvKVitgzj7dyNE6MpZEyMEfZaQt97uPWrHzA8XY\n8VubT1je0Vmfs0ZFCi/D0X+c/0rDGC1TDbsN1oZI6xAKEzkSUXvxAAihOQL7+l9O\nqjabzDaxCxNNoBWreV1wU2goiPDudHMoTfiBDc+Fd3ARc/p3f2UctRv3VInLhN7a\nLbTDR7QQ3p1yG73gC0r/1FvI58huRP1Vu8xZE0XSAFvYQMyJrwBlNN66IuhCadf0\n6pxZ19sn1O6BkVs6Lqa4op/gICIwDoijnN/eVkLTO7NURZVgYCWHzHXrZQi3jACR\nSQIDAQAB\n-----END PUBLIC KEY-----\n";s:13:"useServiceKey";b:1;}i:11;a:6:{s:2:"id";s:20:"migration_1764335102";s:7:"service";s:9:"migration";s:9:"validFrom";s:19:"2025-12-13 13:05:02";s:7:"validTo";s:19:"2026-01-14 13:05:02";s:9:"publicKey";s:451:"-----BEGIN PUBLIC KEY-----\nMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAyFANcwHfuBS1ZKMOhmJN\nvOkM1J/qQIS0tllTfeRTSCUb3fUudQD2arw8pX8J8bvzxGvWzWydo4IlQHJUV+Wu\nz+CmaX5SQanqE3Eyt7YSv3fwLbjbIhM6AS/xb+dhe6eUlrE4C+WCOW8fYDIlXptL\nXmR9y1AIEVVEHJYqQBC7P7iN/NOmeNuIaTRgQWUI+c3FefNDe9vYK7fTPAGrZOlA\niekJpi+wpdAWrrEQ+plh5wha03B8ZJM0oe6zSpZQKTbfA+2IbAjloy/+qL5QTa4m\nXxprJ0CUr5xSAAzrcN4o2dHTwhlTZjy8l4AOuMLocFYnntdAuWbLLCWABE/yIqvh\nSwIDAQAB\n-----END PUBLIC KEY-----\n";s:13:"useServiceKey";b:1;}i:12;a:6:{s:2:"id";s:20:"migration_1766927102";s:7:"service";s:9:"migration";s:9:"validFrom";s:19:"2026-01-12 13:05:02";s:7:"validTo";s:19:"2026-02-13 13:05:02";s:9:"publicKey";s:451:"-----BEGIN PUBLIC KEY-----\nMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAynO/6Ny6iFzL8KpgyELb\n3bf4o1Bh5hRWQaIcVYkaMjY6q/qJTtTGVrtyFAts07Ol+toehkdpnqF+yKKn2oB9\nE4M07EjSS9oMr/zuKz9P6ODFGXgGRp6bzc8s2pW2BwNCEthp3TTtbBCz+UpHIhAI\nJcanLlS0B25yd9wpt+04e5I616oRPQGDmZQQ3rILLCuBDJJ7LdmXorh439MVJlqe\nrxh4XYgkapHUl1O2Au+ZBBWXsoywV2zj8PbUwWFENAoCOcXeViocNNzVureIduQP\nFyVldkQVUk/UdZPczTjrOhW5z5enqtKMyd3l3ULTp4QHp0P8RdyBsGnN77y3Gknh\nowIDAQAB\n-----END PUBLIC KEY-----\n";s:13:"useServiceKey";b:1;}}','on');
INSERT INTO `wp5_options` VALUES (6147,'https_detection_errors','a:0:{}','off');
INSERT INTO `wp5_options` VALUES (8373,'_site_transient_ai1wm_last_check_for_updates','1768124954','off');
INSERT INTO `wp5_options` VALUES (15061,'et_pb_signup_7c82f0a0ab4ea3f89c022cb452107efc','off','yes');
INSERT INTO `wp5_options` VALUES (5427,'wp-short-pixel-bulk-last-status','a:14:{s:6:"Status";i:1;s:7:"Message";s:42:"Success: No pixels remained unsqueezed :-)";s:18:"PercentImprovement";s:5:"26.04";s:7:"ImageID";s:6:"204820";s:8:"Filename";s:20:"Author-Signature.jpg";s:4:"Type";s:6:"glossy";s:11:"ThumbsTotal";i:7;s:11:"ThumbsCount";i:7;s:12:"RetinasCount";i:0;s:13:"BackupEnabled";b:0;s:11:"TsOptimized";s:12:"1 second ago";s:18:"AverageCompression";d:60.72999999999999687361196265555918216705322265625;s:5:"Thumb";s:93:"https://gibson.authorwebsiteinabox.com/wp-content/uploads/2021/02/Author-Signature-300x73.jpg";s:7:"BkThumb";s:0:"";}','yes');
INSERT INTO `wp5_options` VALUES (5401,'et_pb_signup_9dada6390f91eac6a8e0746ad98e7ff7','off','yes');
INSERT INTO `wp5_options` VALUES (5402,'et_pb_contact_form_90006da07b50757c538a423d8cf15f73','off','yes');
INSERT INTO `wp5_options` VALUES (5410,'et_pb_contact_form_b2a2c6357cda957e9ece043f163ace79','off','yes');
INSERT INTO `wp5_options` VALUES (5414,'et_pb_contact_form_0a18e09a4101c5bd9cdc1da18f99df08','off','yes');
INSERT INTO `wp5_options` VALUES (5448,'et_pb_contact_form_309a36fe783a902a750afdb6541be159','off','yes');
INSERT INTO `wp5_options` VALUES (5449,'et_pb_signup_565fd77e6d16ced78476920c073fb22e','off','yes');
INSERT INTO `wp5_options` VALUES (2885,'wpseo_social','a:19:{s:13:"facebook_site";s:0:"";s:13:"instagram_url";s:0:"";s:12:"linkedin_url";s:0:"";s:11:"myspace_url";s:0:"";s:16:"og_default_image";s:0:"";s:19:"og_default_image_id";s:0:"";s:18:"og_frontpage_title";s:0:"";s:17:"og_frontpage_desc";s:0:"";s:18:"og_frontpage_image";s:0:"";s:21:"og_frontpage_image_id";s:0:"";s:9:"opengraph";b:1;s:13:"pinterest_url";s:0:"";s:15:"pinterestverify";s:0:"";s:7:"twitter";b:1;s:12:"twitter_site";s:0:"";s:17:"twitter_card_type";s:19:"summary_large_image";s:11:"youtube_url";s:0:"";s:13:"wikipedia_url";s:0:"";s:10:"fbadminapp";s:0:"";}','yes');
INSERT INTO `wp5_options` VALUES (2886,'wpseo_flush_rewrite','1','yes');
INSERT INTO `wp5_options` VALUES (1420,'ai1wm_updater','a:0:{}','yes');
INSERT INTO `wp5_options` VALUES (1421,'ucp_pointers','a:1:{s:15:"getting_started";a:4:{s:6:"target";s:29:".ucp-main-tab li:nth-child(2)";s:4:"edge";s:3:"top";s:5:"align";s:4:"left";s:7:"content";s:414:"Watch the short <a href="https://www.youtube.com/watch?v=RN4XABhK7_w" target="_blank">getting started video</a> to get you up to speed with UCP in no time. If that doesn\'t answer your questions watch the longer <a href="https://www.youtube.com/watch?v=K3DF-NP6Fog" target="_blank">in-depth video walktrough</a>.<br>If you need the videos later, links are in the <a href="#" class="change_tab" data-tab="4">FAQ</a>.";}}','yes');
INSERT INTO `wp5_options` VALUES (1426,'ucp_meta','a:3:{s:13:"first_version";s:4:"3.82";s:13:"first_install";i:1603395795;s:11:"options_ver";s:4:"4.03";}','yes');
INSERT INTO `wp5_options` VALUES (4979,'_dipe_cf7_notice','a:1:{s:16:"rate_us_feedback";s:4:"true";}','yes');
INSERT INTO `wp5_options` VALUES (5528,'wp-short-pixel-flag-id','0','no');
INSERT INTO `wp5_options` VALUES (5529,'bulkProcessingStatus','','no');
INSERT INTO `wp5_options` VALUES (5518,'wp-short-pixel-activation-notice','','no');
INSERT INTO `wp5_options` VALUES (5519,'wp-short-pixel-bulk-type','','no');
INSERT INTO `wp5_options` VALUES (5520,'wp-short-pixel-bulk-count','0','no');
INSERT INTO `wp5_options` VALUES (5521,'wp-short-pixel-bulk-previous-percent','0','no');
INSERT INTO `wp5_options` VALUES (5522,'wp-short-pixel-bulk-processed-items','0','no');
INSERT INTO `wp5_options` VALUES (5523,'wp-short-pixel-bulk-done-count','0','no');
INSERT INTO `wp5_options` VALUES (5524,'wp-short-pixel-last-bulk-start-time','0','no');
INSERT INTO `wp5_options` VALUES (5525,'wp-short-pixel-last-bulk-success-time','0','no');
INSERT INTO `wp5_options` VALUES (5526,'wp-short-pixel-bulk-running-time','0','no');
INSERT INTO `wp5_options` VALUES (5527,'wp-short-pixel-cancel-pointer','0','no');
INSERT INTO `wp5_options` VALUES (1237,'nav_menu_options','a:2:{i:0;b:0;s:8:"auto_add";a:0:{}}','off');
INSERT INTO `wp5_options` VALUES (1381,'ai1wm_secret_key','oVVmDvm1M1se','yes');
INSERT INTO `wp5_options` VALUES (1386,'ai1wm_status','a:2:{s:4:"type";s:8:"download";s:7:"message";s:424:"<a href="https://gibson.authorwebsiteinabox.com/wp-content/ai1wm-backups/gibson-authorwebsiteinabox-com-20250627-000749-npzyelsvfmoe.wpress" class="ai1wm-button-green ai1wm-emphasize ai1wm-button-download" title="gibson.authorwebsiteinabox.com" download="gibson-authorwebsiteinabox-com-20250627-000749-npzyelsvfmoe.wpress">\n							<span>Download gibson.authorwebsiteinabox.com</span>\n							<em>Size: 325 MB</em>\n							</a>";}','yes');
INSERT INTO `wp5_options` VALUES (399,'wp-short-pixel_cmyk2rgb','1','yes');
INSERT INTO `wp5_options` VALUES (400,'wp-short-backup_images','0','yes');
INSERT INTO `wp5_options` VALUES (401,'wp-short-pixel-resize-images','0','yes');
INSERT INTO `wp5_options` VALUES (396,'wp-short-pixel-apiKey','WacFVdgAPK4nSk5HPQqG','no');
INSERT INTO `wp5_options` VALUES (397,'wp-short-pixel-compression','2','yes');
INSERT INTO `wp5_options` VALUES (398,'wp-short-process_thumbnails','1','yes');
INSERT INTO `wp5_options` VALUES (5466,'et_pb_signup_e886d79eddacba6b56f674d33c58f5e8','off','yes');
INSERT INTO `wp5_options` VALUES (390,'wp-short-pixel-query-id-stop','204834','yes');
INSERT INTO `wp5_options` VALUES (971,'wp-short-pixel-query-id-start','204834','yes');
INSERT INTO `wp5_options` VALUES (392,'wp-short-pixel-create-webp-markup','0','yes');
INSERT INTO `wp5_options` VALUES (393,'wp-short-pixel-verifiedKey','1','no');
INSERT INTO `wp5_options` VALUES (395,'wp-short-pixel-activation-date','1603219611','no');
INSERT INTO `wp5_options` VALUES (402,'wp-short-pixel-resize-width','','yes');
INSERT INTO `wp5_options` VALUES (403,'wp-short-pixel-resize-height','','yes');
INSERT INTO `wp5_options` VALUES (404,'wp-short-pixel-front-bootstrap','0','yes');
INSERT INTO `wp5_options` VALUES (405,'wp-short-pixel-last-back-action','','no');
INSERT INTO `wp5_options` VALUES (406,'wp-short-pixel-keep-exif','0','yes');
INSERT INTO `wp5_options` VALUES (407,'wp-short-create-webp','0','yes');
INSERT INTO `wp5_options` VALUES (408,'wp-short-pixel-optimize-retina','1','yes');
INSERT INTO `wp5_options` VALUES (409,'wp-short-pixel-optimize-unlisted','1','yes');
INSERT INTO `wp5_options` VALUES (410,'wp-short-pixel-resize-type','outer','yes');
INSERT INTO `wp5_options` VALUES (411,'wp-short-pixel-site-auth-user','','no');
INSERT INTO `wp5_options` VALUES (412,'wp-short-pixel-site-auth-pass','','no');
INSERT INTO `wp5_options` VALUES (413,'wp-short-pixel-auto-media-library','1','yes');
INSERT INTO `wp5_options` VALUES (414,'wp-short-pixel-optimize-pdfs','0','yes');
INSERT INTO `wp5_options` VALUES (415,'wp-short-pixel-exclude-patterns','a:0:{}','no');
INSERT INTO `wp5_options` VALUES (416,'wp-short-pixel-png2jpg','1','yes');
INSERT INTO `wp5_options` VALUES (417,'wp-short-pixel-excludeSizes','a:0:{}','no');
INSERT INTO `wp5_options` VALUES (418,'wp-short-pixel-cloudflareAPIEmail','','no');
INSERT INTO `wp5_options` VALUES (419,'wp-short-pixel-cloudflareAuthKey','','no');
INSERT INTO `wp5_options` VALUES (420,'wp-short-pixel-cloudflareAPIZoneID','','no');
INSERT INTO `wp5_options` VALUES (421,'wp-short-pixel-cloudflareToken','','no');
INSERT INTO `wp5_options` VALUES (422,'wp-short-pixel-include-next-gen','0','yes');
INSERT INTO `wp5_options` VALUES (423,'wp-short-pixel-has-custom-folders','','no');
INSERT INTO `wp5_options` VALUES (424,'wp-short-pixel-custom-bulk-paused','0','yes');
INSERT INTO `wp5_options` VALUES (425,'wp-short-pixel-remove-settings-on-delete-plugin','','no');
INSERT INTO `wp5_options` VALUES (426,'wp-short-pixel-current-total-files','a:44:{s:11:"APIKeyValid";b:1;s:12:"APICallsMade";s:10:"862 images";s:13:"APICallsQuota";s:13:"29,100 images";s:19:"APICallsMadeOneTime";s:8:"0 images";s:20:"APICallsQuotaOneTime";s:8:"0 images";s:19:"APICallsMadeNumeric";s:3:"862";s:20:"APICallsQuotaNumeric";i:29100;s:26:"APICallsMadeOneTimeNumeric";s:1:"0";s:27:"APICallsQuotaOneTimeNumeric";s:1:"0";s:17:"APICallsRemaining";i:28238;s:18:"APILastRenewalDate";s:19:"2020-10-17 00:11:29";s:11:"DomainCheck";s:10:"Accessible";s:4:"time";i:1614108193;s:12:"optimizePdfs";s:1:"0";s:10:"totalFiles";i:702;s:9:"mainFiles";i:51;s:19:"totalProcessedFiles";i:717;s:18:"mainProcessedFiles";i:51;s:19:"totalProcLossyFiles";i:0;s:18:"mainProcLossyFiles";i:0;s:20:"totalProcGlossyFiles";i:717;s:19:"mainProcGlossyFiles";i:51;s:22:"totalProcLosslessFiles";i:0;s:21:"mainProcLosslessFiles";i:0;s:12:"totalMlFiles";i:702;s:11:"mainMlFiles";i:51;s:21:"totalProcessedMlFiles";i:717;s:20:"mainProcessedMlFiles";i:51;s:21:"totalProcLossyMlFiles";i:0;s:20:"mainProcLossyMlFiles";i:0;s:22:"totalProcGlossyMlFiles";i:717;s:21:"mainProcGlossyMlFiles";i:51;s:24:"totalProcLosslessMlFiles";i:0;s:23:"mainProcLosslessMlFiles";i:0;s:21:"totalProcUndefMlFiles";i:0;s:20:"mainProcUndefMlFiles";i:0;s:21:"mainUnprocessedThumbs";i:0;s:7:"totalM1";i:0;s:7:"totalM2";i:0;s:7:"totalM3";i:0;s:7:"totalM4";i:46;s:15:"filesWithErrors";a:0:{}s:19:"moreFilesWithErrors";i:0;s:19:"foundUnlistedThumbs";b:0;}','yes');
INSERT INTO `wp5_options` VALUES (968,'wp-short-pixel-fileCount','1219','yes');
INSERT INTO `wp5_options` VALUES (942,'wp-short-pixel-thumbnail-count','1112','yes');
INSERT INTO `wp5_options` VALUES (848,'wp-short-pixel-files-under-5-percent','96','yes');
INSERT INTO `wp5_options` VALUES (815,'wp-short-pixel-api-retries','0','yes');
INSERT INTO `wp5_options` VALUES (434,'wp-short-pixel-quota-exceeded','0','yes');
INSERT INTO `wp5_options` VALUES (435,'wp-short-pixel-protocol','https','no');
INSERT INTO `wp5_options` VALUES (436,'wp-short-pixel-download-protocol','http','yes');
INSERT INTO `wp5_options` VALUES (437,'wp-short-pixel-download-archive','6','yes');
INSERT INTO `wp5_options` VALUES (438,'wp-short-pixel-media-alert','','no');
INSERT INTO `wp5_options` VALUES (439,'wp-short-pixel-dismissed-notices','a:0:{}','no');
INSERT INTO `wp5_options` VALUES (440,'wp-short-pixel-view-mode','','no');
INSERT INTO `wp5_options` VALUES (441,'wp-short-pixel-redirected-settings','1','no');
INSERT INTO `wp5_options` VALUES (442,'wp-short-pixel-converted-png2jpg','a:0:{}','no');
INSERT INTO `wp5_options` VALUES (443,'wp-short-pixel-helpscout-optin','0','yes');
INSERT INTO `wp5_options` VALUES (454,'wp-short-pixel-skip-to-custom','','no');
INSERT INTO `wp5_options` VALUES (455,'wp-short-pixel-bulk-ever-ran','1','yes');
INSERT INTO `wp5_options` VALUES (457,'wp-short-pixel-failed-imgs','','yes');
INSERT INTO `wp5_options` VALUES (977,'wp-short-pixel-prioritySkip','','no');
INSERT INTO `wp5_options` VALUES (464,'wp-short-pixel-apiKeyTried','','yes');
INSERT INTO `wp5_options` VALUES (1887,'et_pb_signup_c300e8801b5912669fd07486f67cd08b','off','yes');
INSERT INTO `wp5_options` VALUES (1892,'et_pb_signup_dd0b2018e64380ebb8dfe6bf982a288d','off','yes');
INSERT INTO `wp5_options` VALUES (1154,'et_pb_signup_bffe5ab3db204227245ab3096e513dd8','off','yes');
INSERT INTO `wp5_options` VALUES (967,'wp-short-pixel-savedSpace','143577369','yes');
INSERT INTO `wp5_options` VALUES (1918,'et_pb_signup_3f7d3550b16a55fd2b6749d6d8db5597','off','yes');
INSERT INTO `wp5_options` VALUES (1004,'et_pb_signup_264471b869c399842517c279347614b6','off','yes');
INSERT INTO `wp5_options` VALUES (1010,'et_pb_signup_d74c87a9be0785e5a1680fe9ad864e06','off','yes');
INSERT INTO `wp5_options` VALUES (1011,'et_pb_contact_form_44a1a3cfad8fb8f9f711bbd88e042d9f','off','yes');
INSERT INTO `wp5_options` VALUES (1395,'ai1wm_backups_labels','a:0:{}','yes');
INSERT INTO `wp5_options` VALUES (970,'wp-short-pixel-total-optimized','92852962','yes');
INSERT INTO `wp5_options` VALUES (969,'wp-short-pixel-total-original','236430331','yes');
INSERT INTO `wp5_options` VALUES (10628,'wp_force_deactivated_plugins','a:0:{}','off');
INSERT INTO `wp5_options` VALUES (10621,'widget_block','a:1:{s:12:"_multiwidget";i:1;}','yes');
INSERT INTO `wp5_options` VALUES (137367,'et_divi_builder_presets_history_meta','a:2:{s:5:"index";i:-1;s:4:"size";i:0;}','off');
INSERT INTO `wp5_options` VALUES (8366,'_transient_et_updated_plugins_data','O:8:"stdClass":1:{s:12:"last_checked";i:1768146237;}','yes');
INSERT INTO `wp5_options` VALUES (101699,'auto_update_plugins','a:13:{i:0;s:19:"akismet/akismet.php";i:1;s:51:"all-in-one-wp-migration/all-in-one-wp-migration.php";i:2;s:51:"all-in-one-wp-security-and-firewall/wp-security.php";i:3;s:15:"bloom/bloom.php";i:4;s:36:"contact-form-7/wp-contact-form-7.php";i:5;s:34:"cf7-styler-for-divi/cf7-styler.php";i:6;s:21:"flamingo/flamingo.php";i:7;s:36:"contact-form-7-honeypot/honeypot.php";i:8;s:19:"jetpack/jetpack.php";i:9;s:15:"worker/init.php";i:10;s:26:"popups-for-divi/plugin.php";i:11;s:46:"under-construction-page/under-construction.php";i:12;s:24:"wordpress-seo/wp-seo.php";}','no');
INSERT INTO `wp5_options` VALUES (10636,'dm_pfd_data','a:1:{s:12:"active_since";i:1627916181;}','yes');
INSERT INTO `wp5_options` VALUES (10637,'dm_core_notices','a:1:{s:5:"queue";a:6:{i:122864;a:3:{s:4:"inst";s:3:"pfd";s:4:"type";s:4:"info";s:4:"html";s:432:"<p><strong>🥳 Divimode Summer Sale</strong>: Get the best deal when upgrading to <strong><a href="https://divimode.com/divi-areas-pro/" target="_blank">Divi Areas Pro</a></strong> today! <a href="#dismiss" class="notice-dismiss">Dismiss (I do not want to save money)</a> <span style="padding-left:20px"><a href="https://divimode.com/join/?sale=summer23" target="_blank" class="button-primary cta-link">Get the Deal!</a></span></p>";}i:128070;a:3:{s:4:"inst";s:3:"pfd";s:4:"type";s:4:"info";s:4:"html";s:590:"<p><strong>🎃 Popups for Divi Halloween Sale</strong>: Save 40% when upgrading to <strong><a href="https://divimode.com/divi-areas-pro/" target="_blank">Divi Areas Pro</a></strong> today! 👻 <br></br>Divi Areas Pro (the premium version of Popups for Divi) allows you to create advanced popups, mega menus, fly-ins, conditional content & more! 🔥 <a href="#dismiss" class="notice-dismiss">Dismiss (I don\'t want to save money)</a> <span style="padding-left:20px"><a href="https://divimode.com/divi-areas-pro/" target="_blank" class="button-primary cta-link">Get the Deal!</a></span></p>";}i:128191;a:3:{s:4:"inst";s:3:"pfd";s:4:"type";s:4:"info";s:4:"html";s:650:"<p><strong>🔥 Popups for Divi Cyber Sale</strong>: Save 50% when upgrading to <strong><a href="https://divimode.com/divi-areas-pro/" target="_blank">Divi Areas Pro</a></strong> today! 💪 <br></br>Divi Areas Pro (the premium version of Popups for Divi) allows you to create advanced popups, mega menus, fly-ins, conditional content, layout injection & more! 🥳 <span style="padding-left:20px"></span></p><p><strong>Want more? </strong> Get the Divi Agency Bundle with <u>hundreds of Divi products</u> for an insane deal! <a href="https://divimode.com/join/" target="_blank" class="button-primary cta-link">Get the Limited Time Deal! 🚀</a></p>";}i:127867;a:3:{s:4:"inst";s:3:"pfd";s:4:"type";s:4:"info";s:4:"html";s:587:"<p><strong>🥳 Popups for Divi Summer Sale</strong>: Save 50% when upgrading to <strong><a href="https://divimode.com/divi-areas-pro/" target="_blank">Divi Areas Pro</a></strong> today! 🌞 <br></br>Divi Areas Pro (the premium version of Popups for Divi) allows you to create advanced popups, mega menus, fly-ins, conditional content & more! 🔥 <a href="#dismiss" class="notice-dismiss">Dismiss (I don\'t want to save money)</a> <span style="padding-left:20px"><a href="https://divimode.com/divi-areas-pro/" target="_blank" class="button-primary cta-link">Get the Deal!</a></span></p>";}i:128360;a:3:{s:4:"inst";s:3:"pfd";s:4:"type";s:4:"info";s:4:"html";s:767:"<p><strong>Thanks for using Popups for Divi!</strong> We appreciate your continued support. 🙏</p><p>As a thank you, <strong>we\'d love to give you another free Divi plugin! 🎁 </strong></p><p>Uses by tens of thousands of Divi users, <strong>Divi Coming Soon</strong> is the easiest way to create a gorgeous & professional maintenance mode, under construction, or coming soon page powered entirely by Divi.</p><p>Divi Coming Soon is: <strong>✅ super lightweight</strong>, (won\'t slow down your site), <strong>✅ extremely easy to use</strong>, and <strong>✅ completely FREE!</strong></p><p><a href="https://divilife.com/downloads/divi-coming-soon/ref/637/?campaign=popups-for-divi-wp" target="_blank" class="button-primary">Yes, I want the Free Plugin</a></p>";}i:108636;a:3:{s:4:"inst";s:3:"pfd";s:4:"type";s:4:"info";s:4:"html";s:858:"<p><strong>You\'re using Popups for Divi</strong> for a while now, thanks! If you require any assistance, please <a href="https://wordpress.org/support/plugin/popups-for-divi/#new-post" target="_blank">reach out via support</a>, and we\'ll get back to you asap. <p>Meanwhile, you can do us a <strong>huge favor</strong> and leave an <a href="https://wordpress.org/support/plugin/popups-for-divi/reviews/#new-post" target="_blank"><strong>honest (5-star) rating</strong> on WordPress</a> - it only takes 30 seconds, and helps other users to find our plugin, and it enables us to spend more time developing and improving this free plugin for you. <em>- Thanks, Philipp from divimode.com</em> 👍 <br /><br><br><a href="https://wordpress.org/support/plugin/popups-for-divi/reviews/#new-post" target="_blank" class="button-primary">Sure, I\'d love to help!</a></p>";}}}','on');
INSERT INTO `wp5_options` VALUES (39881,'et_pb_contact_form_6994f5e869a0789811362abd3dac179c','off','yes');
INSERT INTO `wp5_options` VALUES (39882,'et_pb_signup_8a1d33fa29eca1d1994a808d8de03abd','off','yes');
INSERT INTO `wp5_options` VALUES (38297,'user_count','2','no');
INSERT INTO `wp5_options` VALUES (14929,'et_pb_signup_f647318d79125941c23df39d58ef6a59','off','yes');
INSERT INTO `wp5_options` VALUES (39867,'et_pb_signup_eb800efc3d027be31a41512deb05f7aa','off','yes');
INSERT INTO `wp5_options` VALUES (24353,'et_pb_contact_form_bdb70ff04baf578d80ad86206407e827','off','yes');
INSERT INTO `wp5_options` VALUES (137354,'_site_transient_et_update_all_plugins','O:8:"stdClass":4:{s:7:"checked";a:12:{s:19:"akismet/akismet.php";s:5:"5.3.7";s:51:"all-in-one-wp-migration/all-in-one-wp-migration.php";s:4:"7.93";s:15:"bloom/bloom.php";s:6:"1.3.12";s:36:"contact-form-7/wp-contact-form-7.php";s:5:"6.0.6";s:34:"cf7-styler-for-divi/cf7-styler.php";s:5:"2.3.3";s:21:"flamingo/flamingo.php";s:3:"2.5";s:36:"contact-form-7-honeypot/honeypot.php";s:5:"2.1.7";s:19:"jetpack/jetpack.php";s:4:"14.6";s:15:"worker/init.php";s:6:"4.9.23";s:26:"popups-for-divi/plugin.php";s:5:"3.0.9";s:46:"under-construction-page/under-construction.php";s:4:"4.02";s:24:"wordpress-seo/wp-seo.php";s:4:"25.0";}s:8:"response";a:0:{}s:9:"no_update";a:1:{s:15:"bloom/bloom.php";O:8:"stdClass":12:{s:11:"new_version";s:6:"1.3.12";s:6:"plugin";s:15:"bloom/bloom.php";s:4:"slug";s:5:"bloom";s:6:"tested";s:5:"5.3.2";s:5:"icons";a:2:{s:2:"2x";s:57:"https://www.elegantthemes.com/images/plugins/2x/bloom.png";s:2:"1x";s:57:"https://www.elegantthemes.com/images/plugins/1x/bloom.png";}s:3:"url";s:53:"https://www.elegantthemes.com/api/changelog/bloom.txt";s:7:"package";s:142:"https://www.elegantthemes.com/api/api_downloads.php?api_update=1&theme=bloom&api_key=063180df0013b22352d18d4bd5ff5cca8b83fc70&username=user666";s:2:"id";s:15:"bloom/bloom.php";s:7:"banners";a:0:{}s:11:"banners_rtl";a:0:{}s:12:"requires_php";s:0:"";s:13:"compatibility";O:8:"stdClass":0:{}}}s:12:"last_checked";i:1746569245;}','off');
INSERT INTO `wp5_options` VALUES (137360,'_site_transient_et_update_themes','O:8:"stdClass":3:{s:7:"checked";a:6:{s:4:"Divi";s:6:"4.27.4";s:16:"twentytwentyfive";s:3:"1.4";s:16:"twentytwentyfour";s:3:"1.4";s:15:"twentytwentyone";s:3:"2.7";s:17:"twentytwentythree";s:3:"1.6";s:15:"twentytwentytwo";s:3:"2.1";}s:8:"response";a:1:{s:4:"Divi";a:3:{s:11:"new_version";s:6:"4.27.5";s:5:"theme";s:4:"Divi";s:3:"url";s:52:"https://www.elegantthemes.com/api/changelog/divi.txt";}}s:12:"last_checked";i:1768146238;}','off');
INSERT INTO `wp5_options` VALUES (137397,'user_hit_count','a:60:{s:10:"2025-10-20";i:317;s:10:"2025-10-21";i:518;s:10:"2025-10-22";i:548;s:10:"2025-10-23";i:478;s:10:"2025-10-24";i:644;s:10:"2025-10-25";i:396;s:10:"2025-10-26";i:325;s:10:"2025-10-27";i:488;s:10:"2025-10-28";i:250;s:10:"2025-10-29";i:69;s:10:"2025-10-30";i:396;s:10:"2025-10-31";i:394;s:10:"2025-11-01";i:357;s:10:"2025-11-02";i:356;s:10:"2025-11-03";i:503;s:10:"2025-11-04";i:618;s:10:"2025-11-05";i:240;s:10:"2025-11-06";i:386;s:10:"2025-11-07";i:366;s:10:"2025-11-08";i:610;s:10:"2025-11-09";i:251;s:10:"2025-11-10";i:341;s:10:"2025-11-11";i:444;s:10:"2025-11-12";i:191;s:10:"2025-11-13";i:246;s:10:"2025-11-14";i:565;s:10:"2025-11-15";i:207;s:10:"2025-11-16";i:121;s:10:"2025-11-17";i:271;s:10:"2025-11-18";i:194;s:10:"2025-11-19";i:112;s:10:"2025-11-20";i:244;s:10:"2025-11-21";i:143;s:10:"2025-11-22";i:328;s:10:"2025-11-23";i:240;s:10:"2025-11-24";i:627;s:10:"2025-11-25";i:179;s:10:"2025-11-26";i:162;s:10:"2025-11-27";i:112;s:10:"2025-11-28";i:291;s:10:"2025-11-29";i:845;s:10:"2025-11-30";i:181;s:10:"2025-12-01";i:823;s:10:"2025-12-02";i:109;s:10:"2025-12-03";i:537;s:10:"2025-12-04";i:169;s:10:"2025-12-05";i:354;s:10:"2025-12-06";i:423;s:10:"2025-12-07";i:534;s:10:"2025-12-08";i:146;s:10:"2025-12-09";i:247;s:10:"2025-12-10";i:204;s:10:"2025-12-11";i:528;s:10:"2025-12-12";i:327;s:10:"2025-12-13";i:592;s:10:"2025-12-14";i:377;s:10:"2025-12-15";i:156;s:10:"2025-12-16";i:892;s:10:"2025-12-17";i:389;s:10:"2025-12-18";i:618;}','on');
INSERT INTO `wp5_options` VALUES (122640,'_transient_wp_styles_for_blocks','a:2:{s:4:"hash";s:32:"1c21f17420776538dd66fe798dc988fa";s:6:"blocks";a:6:{s:11:"core/button";s:0:"";s:14:"core/site-logo";s:0:"";s:18:"core/post-template";s:120:":where(.wp-block-post-template.is-layout-flex){gap: 1.25em;}:where(.wp-block-post-template.is-layout-grid){gap: 1.25em;}";s:18:"core/term-template";s:120:":where(.wp-block-term-template.is-layout-flex){gap: 1.25em;}:where(.wp-block-term-template.is-layout-grid){gap: 1.25em;}";s:12:"core/columns";s:102:":where(.wp-block-columns.is-layout-flex){gap: 2em;}:where(.wp-block-columns.is-layout-grid){gap: 2em;}";s:14:"core/pullquote";s:69:":root :where(.wp-block-pullquote){font-size: 1.5em;line-height: 1.6;}";}}','on');
INSERT INTO `wp5_options` VALUES (137410,'_site_transient_et_update_plugins','O:8:"stdClass":4:{s:7:"checked";a:9:{s:19:"akismet/akismet.php";s:3:"5.6";s:51:"all-in-one-wp-migration/all-in-one-wp-migration.php";s:5:"7.101";s:15:"bloom/bloom.php";s:6:"1.3.12";s:19:"jetpack/jetpack.php";s:4:"15.4";s:15:"worker/init.php";s:6:"4.9.26";s:26:"popups-for-divi/plugin.php";s:5:"3.2.3";s:46:"under-construction-page/under-construction.php";s:4:"4.03";s:47:"wpvivid-backuprestore/wpvivid-backuprestore.php";s:7:"0.9.122";s:24:"wordpress-seo/wp-seo.php";s:4:"26.7";}s:8:"response";a:0:{}s:9:"no_update";a:1:{s:15:"bloom/bloom.php";O:8:"stdClass":11:{s:11:"new_version";s:6:"1.3.12";s:6:"plugin";s:15:"bloom/bloom.php";s:4:"slug";s:5:"bloom";s:6:"tested";s:5:"5.3.2";s:5:"icons";a:2:{s:2:"2x";s:57:"https://www.elegantthemes.com/images/plugins/2x/bloom.png";s:2:"1x";s:57:"https://www.elegantthemes.com/images/plugins/1x/bloom.png";}s:3:"url";s:53:"https://www.elegantthemes.com/api/changelog/bloom.txt";s:2:"id";s:15:"bloom/bloom.php";s:7:"banners";a:0:{}s:11:"banners_rtl";a:0:{}s:12:"requires_php";s:0:"";s:13:"compatibility";O:8:"stdClass":0:{}}}s:12:"last_checked";i:1768146237;}','off');
INSERT INTO `wp5_options` VALUES (137384,'_site_transient_wp_plugin_dependencies_plugin_data','a:0:{}','off');
INSERT INTO `wp5_options` VALUES (143390,'et_account_api_key_status','deactivated','off');
INSERT INTO `wp5_options` VALUES (137402,'mwp_communication_keys','a:1:{i:18745743;a:2:{s:3:"key";s:36:"107c7e61-8e6e-489a-a77d-1f033013d9e3";s:5:"added";i:1746569537;}}','on');
INSERT INTO `wp5_options` VALUES (137403,'mwp_key_last_used_107c7e61-8e6e-489a-a77d-1f033013d9e3','1746569537','on');
INSERT INTO `wp5_options` VALUES (137405,'mwp_potential_key','e9f29cb2-c100-4445-97cf-554844407db3','on');
INSERT INTO `wp5_options` VALUES (137406,'mwp_potential_key_time','1768125017','on');
INSERT INTO `wp5_options` VALUES (137407,'mwp_key_last_used_18745743','1768146239','on');
INSERT INTO `wp5_options` VALUES (137408,'mwp_new_communication_established','1','on');
INSERT INTO `wp5_options` VALUES (97918,'et_pb_signup_59d98e9b2454e930eba0b6fb8f9715f6','off','yes');
INSERT INTO `wp5_options` VALUES (101782,'wp_attachment_pages_enabled','1','yes');
INSERT INTO `wp5_options` VALUES (143334,'et_pb_contact_form_062399f2047e6ca1c33912b97dd9df4f','off','auto');
INSERT INTO `wp5_options` VALUES (143336,'et_pb_contact_form_fdcf1b014fc437c7e77d312365185878','off','auto');
INSERT INTO `wp5_options` VALUES (143337,'et_pb_signup_1fc8df82957e64ddcaf68761f3f63d63','off','auto');
INSERT INTO `wp5_options` VALUES (167428,'_transient_timeout_et_core_path','1768232699','off');
INSERT INTO `wp5_options` VALUES (167429,'_transient_et_core_path','/home/authorwebsite/gibson.authorwebsiteinabox.com/wp-content/themes/Divi/core','off');
INSERT INTO `wp5_options` VALUES (167430,'_transient_timeout_et_core_version','1768232699','off');
INSERT INTO `wp5_options` VALUES (167431,'_transient_et_core_version','4.27.4','off');
INSERT INTO `wp5_options` VALUES (167433,'wpvivid_need_review','not','off');
INSERT INTO `wp5_options` VALUES (167435,'clean_task','a:1:{i:0;b:0;}','off');
INSERT INTO `wp5_options` VALUES (167185,'_transient_timeout_et_check_mod_pagespeed','1768171718','off');
INSERT INTO `wp5_options` VALUES (167186,'_transient_et_check_mod_pagespeed','','off');
INSERT INTO `wp5_options` VALUES (166565,'_site_transient_timeout_php_check_e1575808cef126e0bfb4325cceefee7d','1768259992','off');
INSERT INTO `wp5_options` VALUES (166566,'_site_transient_php_check_e1575808cef126e0bfb4325cceefee7d','a:5:{s:19:"recommended_version";s:3:"8.3";s:15:"minimum_version";s:6:"7.2.24";s:12:"is_supported";b:0;s:9:"is_secure";b:1;s:13:"is_acceptable";b:1;}','off');
INSERT INTO `wp5_options` VALUES (161938,'wp_notes_notify','1','on');
INSERT INTO `wp5_options` VALUES (161945,'_transient_wp_core_block_css_files','a:2:{s:7:"version";s:3:"6.9";s:5:"files";a:584:{i:0;s:31:"accordion-heading/style-rtl.css";i:1;s:35:"accordion-heading/style-rtl.min.css";i:2;s:27:"accordion-heading/style.css";i:3;s:31:"accordion-heading/style.min.css";i:4;s:28:"accordion-item/style-rtl.css";i:5;s:32:"accordion-item/style-rtl.min.css";i:6;s:24:"accordion-item/style.css";i:7;s:28:"accordion-item/style.min.css";i:8;s:29:"accordion-panel/style-rtl.css";i:9;s:33:"accordion-panel/style-rtl.min.css";i:10;s:25:"accordion-panel/style.css";i:11;s:29:"accordion-panel/style.min.css";i:12;s:23:"accordion/style-rtl.css";i:13;s:27:"accordion/style-rtl.min.css";i:14;s:19:"accordion/style.css";i:15;s:23:"accordion/style.min.css";i:16;s:23:"archives/editor-rtl.css";i:17;s:27:"archives/editor-rtl.min.css";i:18;s:19:"archives/editor.css";i:19;s:23:"archives/editor.min.css";i:20;s:22:"archives/style-rtl.css";i:21;s:26:"archives/style-rtl.min.css";i:22;s:18:"archives/style.css";i:23;s:22:"archives/style.min.css";i:24;s:20:"audio/editor-rtl.css";i:25;s:24:"audio/editor-rtl.min.css";i:26;s:16:"audio/editor.css";i:27;s:20:"audio/editor.min.css";i:28;s:19:"audio/style-rtl.css";i:29;s:23:"audio/style-rtl.min.css";i:30;s:15:"audio/style.css";i:31;s:19:"audio/style.min.css";i:32;s:19:"audio/theme-rtl.css";i:33;s:23:"audio/theme-rtl.min.css";i:34;s:15:"audio/theme.css";i:35;s:19:"audio/theme.min.css";i:36;s:21:"avatar/editor-rtl.css";i:37;s:25:"avatar/editor-rtl.min.css";i:38;s:17:"avatar/editor.css";i:39;s:21:"avatar/editor.min.css";i:40;s:20:"avatar/style-rtl.css";i:41;s:24:"avatar/style-rtl.min.css";i:42;s:16:"avatar/style.css";i:43;s:20:"avatar/style.min.css";i:44;s:21:"button/editor-rtl.css";i:45;s:25:"button/editor-rtl.min.css";i:46;s:17:"button/editor.css";i:47;s:21:"button/editor.min.css";i:48;s:20:"button/style-rtl.css";i:49;s:24:"button/style-rtl.min.css";i:50;s:16:"button/style.css";i:51;s:20:"button/style.min.css";i:52;s:22:"buttons/editor-rtl.css";i:53;s:26:"buttons/editor-rtl.min.css";i:54;s:18:"buttons/editor.css";i:55;s:22:"buttons/editor.min.css";i:56;s:21:"buttons/style-rtl.css";i:57;s:25:"buttons/style-rtl.min.css";i:58;s:17:"buttons/style.css";i:59;s:21:"buttons/style.min.css";i:60;s:22:"calendar/style-rtl.css";i:61;s:26:"calendar/style-rtl.min.css";i:62;s:18:"calendar/style.css";i:63;s:22:"calendar/style.min.css";i:64;s:25:"categories/editor-rtl.css";i:65;s:29:"categories/editor-rtl.min.css";i:66;s:21:"categories/editor.css";i:67;s:25:"categories/editor.min.css";i:68;s:24:"categories/style-rtl.css";i:69;s:28:"categories/style-rtl.min.css";i:70;s:20:"categories/style.css";i:71;s:24:"categories/style.min.css";i:72;s:19:"code/editor-rtl.css";i:73;s:23:"code/editor-rtl.min.css";i:74;s:15:"code/editor.css";i:75;s:19:"code/editor.min.css";i:76;s:18:"code/style-rtl.css";i:77;s:22:"code/style-rtl.min.css";i:78;s:14:"code/style.css";i:79;s:18:"code/style.min.css";i:80;s:18:"code/theme-rtl.css";i:81;s:22:"code/theme-rtl.min.css";i:82;s:14:"code/theme.css";i:83;s:18:"code/theme.min.css";i:84;s:22:"columns/editor-rtl.css";i:85;s:26:"columns/editor-rtl.min.css";i:86;s:18:"columns/editor.css";i:87;s:22:"columns/editor.min.css";i:88;s:21:"columns/style-rtl.css";i:89;s:25:"columns/style-rtl.min.css";i:90;s:17:"columns/style.css";i:91;s:21:"columns/style.min.css";i:92;s:33:"comment-author-name/style-rtl.css";i:93;s:37:"comment-author-name/style-rtl.min.css";i:94;s:29:"comment-author-name/style.css";i:95;s:33:"comment-author-name/style.min.css";i:96;s:29:"comment-content/style-rtl.css";i:97;s:33:"comment-content/style-rtl.min.css";i:98;s:25:"comment-content/style.css";i:99;s:29:"comment-content/style.min.css";i:100;s:26:"comment-date/style-rtl.css";i:101;s:30:"comment-date/style-rtl.min.css";i:102;s:22:"comment-date/style.css";i:103;s:26:"comment-date/style.min.css";i:104;s:31:"comment-edit-link/style-rtl.css";i:105;s:35:"comment-edit-link/style-rtl.min.css";i:106;s:27:"comment-edit-link/style.css";i:107;s:31:"comment-edit-link/style.min.css";i:108;s:32:"comment-reply-link/style-rtl.css";i:109;s:36:"comment-reply-link/style-rtl.min.css";i:110;s:28:"comment-reply-link/style.css";i:111;s:32:"comment-reply-link/style.min.css";i:112;s:30:"comment-template/style-rtl.css";i:113;s:34:"comment-template/style-rtl.min.css";i:114;s:26:"comment-template/style.css";i:115;s:30:"comment-template/style.min.css";i:116;s:42:"comments-pagination-numbers/editor-rtl.css";i:117;s:46:"comments-pagination-numbers/editor-rtl.min.css";i:118;s:38:"comments-pagination-numbers/editor.css";i:119;s:42:"comments-pagination-numbers/editor.min.css";i:120;s:34:"comments-pagination/editor-rtl.css";i:121;s:38:"comments-pagination/editor-rtl.min.css";i:122;s:30:"comments-pagination/editor.css";i:123;s:34:"comments-pagination/editor.min.css";i:124;s:33:"comments-pagination/style-rtl.css";i:125;s:37:"comments-pagination/style-rtl.min.css";i:126;s:29:"comments-pagination/style.css";i:127;s:33:"comments-pagination/style.min.css";i:128;s:29:"comments-title/editor-rtl.css";i:129;s:33:"comments-title/editor-rtl.min.css";i:130;s:25:"comments-title/editor.css";i:131;s:29:"comments-title/editor.min.css";i:132;s:23:"comments/editor-rtl.css";i:133;s:27:"comments/editor-rtl.min.css";i:134;s:19:"comments/editor.css";i:135;s:23:"comments/editor.min.css";i:136;s:22:"comments/style-rtl.css";i:137;s:26:"comments/style-rtl.min.css";i:138;s:18:"comments/style.css";i:139;s:22:"comments/style.min.css";i:140;s:20:"cover/editor-rtl.css";i:141;s:24:"cover/editor-rtl.min.css";i:142;s:16:"cover/editor.css";i:143;s:20:"cover/editor.min.css";i:144;s:19:"cover/style-rtl.css";i:145;s:23:"cover/style-rtl.min.css";i:146;s:15:"cover/style.css";i:147;s:19:"cover/style.min.css";i:148;s:22:"details/editor-rtl.css";i:149;s:26:"details/editor-rtl.min.css";i:150;s:18:"details/editor.css";i:151;s:22:"details/editor.min.css";i:152;s:21:"details/style-rtl.css";i:153;s:25:"details/style-rtl.min.css";i:154;s:17:"details/style.css";i:155;s:21:"details/style.min.css";i:156;s:20:"embed/editor-rtl.css";i:157;s:24:"embed/editor-rtl.min.css";i:158;s:16:"embed/editor.css";i:159;s:20:"embed/editor.min.css";i:160;s:19:"embed/style-rtl.css";i:161;s:23:"embed/style-rtl.min.css";i:162;s:15:"embed/style.css";i:163;s:19:"embed/style.min.css";i:164;s:19:"embed/theme-rtl.css";i:165;s:23:"embed/theme-rtl.min.css";i:166;s:15:"embed/theme.css";i:167;s:19:"embed/theme.min.css";i:168;s:19:"file/editor-rtl.css";i:169;s:23:"file/editor-rtl.min.css";i:170;s:15:"file/editor.css";i:171;s:19:"file/editor.min.css";i:172;s:18:"file/style-rtl.css";i:173;s:22:"file/style-rtl.min.css";i:174;s:14:"file/style.css";i:175;s:18:"file/style.min.css";i:176;s:23:"footnotes/style-rtl.css";i:177;s:27:"footnotes/style-rtl.min.css";i:178;s:19:"footnotes/style.css";i:179;s:23:"footnotes/style.min.css";i:180;s:23:"freeform/editor-rtl.css";i:181;s:27:"freeform/editor-rtl.min.css";i:182;s:19:"freeform/editor.css";i:183;s:23:"freeform/editor.min.css";i:184;s:22:"gallery/editor-rtl.css";i:185;s:26:"gallery/editor-rtl.min.css";i:186;s:18:"gallery/editor.css";i:187;s:22:"gallery/editor.min.css";i:188;s:21:"gallery/style-rtl.css";i:189;s:25:"gallery/style-rtl.min.css";i:190;s:17:"gallery/style.css";i:191;s:21:"gallery/style.min.css";i:192;s:21:"gallery/theme-rtl.css";i:193;s:25:"gallery/theme-rtl.min.css";i:194;s:17:"gallery/theme.css";i:195;s:21:"gallery/theme.min.css";i:196;s:20:"group/editor-rtl.css";i:197;s:24:"group/editor-rtl.min.css";i:198;s:16:"group/editor.css";i:199;s:20:"group/editor.min.css";i:200;s:19:"group/style-rtl.css";i:201;s:23:"group/style-rtl.min.css";i:202;s:15:"group/style.css";i:203;s:19:"group/style.min.css";i:204;s:19:"group/theme-rtl.css";i:205;s:23:"group/theme-rtl.min.css";i:206;s:15:"group/theme.css";i:207;s:19:"group/theme.min.css";i:208;s:21:"heading/style-rtl.css";i:209;s:25:"heading/style-rtl.min.css";i:210;s:17:"heading/style.css";i:211;s:21:"heading/style.min.css";i:212;s:19:"html/editor-rtl.css";i:213;s:23:"html/editor-rtl.min.css";i:214;s:15:"html/editor.css";i:215;s:19:"html/editor.min.css";i:216;s:20:"image/editor-rtl.css";i:217;s:24:"image/editor-rtl.min.css";i:218;s:16:"image/editor.css";i:219;s:20:"image/editor.min.css";i:220;s:19:"image/style-rtl.css";i:221;s:23:"image/style-rtl.min.css";i:222;s:15:"image/style.css";i:223;s:19:"image/style.min.css";i:224;s:19:"image/theme-rtl.css";i:225;s:23:"image/theme-rtl.min.css";i:226;s:15:"image/theme.css";i:227;s:19:"image/theme.min.css";i:228;s:29:"latest-comments/style-rtl.css";i:229;s:33:"latest-comments/style-rtl.min.css";i:230;s:25:"latest-comments/style.css";i:231;s:29:"latest-comments/style.min.css";i:232;s:27:"latest-posts/editor-rtl.css";i:233;s:31:"latest-posts/editor-rtl.min.css";i:234;s:23:"latest-posts/editor.css";i:235;s:27:"latest-posts/editor.min.css";i:236;s:26:"latest-posts/style-rtl.css";i:237;s:30:"latest-posts/style-rtl.min.css";i:238;s:22:"latest-posts/style.css";i:239;s:26:"latest-posts/style.min.css";i:240;s:18:"list/style-rtl.css";i:241;s:22:"list/style-rtl.min.css";i:242;s:14:"list/style.css";i:243;s:18:"list/style.min.css";i:244;s:22:"loginout/style-rtl.css";i:245;s:26:"loginout/style-rtl.min.css";i:246;s:18:"loginout/style.css";i:247;s:22:"loginout/style.min.css";i:248;s:19:"math/editor-rtl.css";i:249;s:23:"math/editor-rtl.min.css";i:250;s:15:"math/editor.css";i:251;s:19:"math/editor.min.css";i:252;s:18:"math/style-rtl.css";i:253;s:22:"math/style-rtl.min.css";i:254;s:14:"math/style.css";i:255;s:18:"math/style.min.css";i:256;s:25:"media-text/editor-rtl.css";i:257;s:29:"media-text/editor-rtl.min.css";i:258;s:21:"media-text/editor.css";i:259;s:25:"media-text/editor.min.css";i:260;s:24:"media-text/style-rtl.css";i:261;s:28:"media-text/style-rtl.min.css";i:262;s:20:"media-text/style.css";i:263;s:24:"media-text/style.min.css";i:264;s:19:"more/editor-rtl.css";i:265;s:23:"more/editor-rtl.min.css";i:266;s:15:"more/editor.css";i:267;s:19:"more/editor.min.css";i:268;s:30:"navigation-link/editor-rtl.css";i:269;s:34:"navigation-link/editor-rtl.min.css";i:270;s:26:"navigation-link/editor.css";i:271;s:30:"navigation-link/editor.min.css";i:272;s:29:"navigation-link/style-rtl.css";i:273;s:33:"navigation-link/style-rtl.min.css";i:274;s:25:"navigation-link/style.css";i:275;s:29:"navigation-link/style.min.css";i:276;s:33:"navigation-submenu/editor-rtl.css";i:277;s:37:"navigation-submenu/editor-rtl.min.css";i:278;s:29:"navigation-submenu/editor.css";i:279;s:33:"navigation-submenu/editor.min.css";i:280;s:25:"navigation/editor-rtl.css";i:281;s:29:"navigation/editor-rtl.min.css";i:282;s:21:"navigation/editor.css";i:283;s:25:"navigation/editor.min.css";i:284;s:24:"navigation/style-rtl.css";i:285;s:28:"navigation/style-rtl.min.css";i:286;s:20:"navigation/style.css";i:287;s:24:"navigation/style.min.css";i:288;s:23:"nextpage/editor-rtl.css";i:289;s:27:"nextpage/editor-rtl.min.css";i:290;s:19:"nextpage/editor.css";i:291;s:23:"nextpage/editor.min.css";i:292;s:24:"page-list/editor-rtl.css";i:293;s:28:"page-list/editor-rtl.min.css";i:294;s:20:"page-list/editor.css";i:295;s:24:"page-list/editor.min.css";i:296;s:23:"page-list/style-rtl.css";i:297;s:27:"page-list/style-rtl.min.css";i:298;s:19:"page-list/style.css";i:299;s:23:"page-list/style.min.css";i:300;s:24:"paragraph/editor-rtl.css";i:301;s:28:"paragraph/editor-rtl.min.css";i:302;s:20:"paragraph/editor.css";i:303;s:24:"paragraph/editor.min.css";i:304;s:23:"paragraph/style-rtl.css";i:305;s:27:"paragraph/style-rtl.min.css";i:306;s:19:"paragraph/style.css";i:307;s:23:"paragraph/style.min.css";i:308;s:35:"post-author-biography/style-rtl.css";i:309;s:39:"post-author-biography/style-rtl.min.css";i:310;s:31:"post-author-biography/style.css";i:311;s:35:"post-author-biography/style.min.css";i:312;s:30:"post-author-name/style-rtl.css";i:313;s:34:"post-author-name/style-rtl.min.css";i:314;s:26:"post-author-name/style.css";i:315;s:30:"post-author-name/style.min.css";i:316;s:25:"post-author/style-rtl.css";i:317;s:29:"post-author/style-rtl.min.css";i:318;s:21:"post-author/style.css";i:319;s:25:"post-author/style.min.css";i:320;s:33:"post-comments-count/style-rtl.css";i:321;s:37:"post-comments-count/style-rtl.min.css";i:322;s:29:"post-comments-count/style.css";i:323;s:33:"post-comments-count/style.min.css";i:324;s:33:"post-comments-form/editor-rtl.css";i:325;s:37:"post-comments-form/editor-rtl.min.css";i:326;s:29:"post-comments-form/editor.css";i:327;s:33:"post-comments-form/editor.min.css";i:328;s:32:"post-comments-form/style-rtl.css";i:329;s:36:"post-comments-form/style-rtl.min.css";i:330;s:28:"post-comments-form/style.css";i:331;s:32:"post-comments-form/style.min.css";i:332;s:32:"post-comments-link/style-rtl.css";i:333;s:36:"post-comments-link/style-rtl.min.css";i:334;s:28:"post-comments-link/style.css";i:335;s:32:"post-comments-link/style.min.css";i:336;s:26:"post-content/style-rtl.css";i:337;s:30:"post-content/style-rtl.min.css";i:338;s:22:"post-content/style.css";i:339;s:26:"post-content/style.min.css";i:340;s:23:"post-date/style-rtl.css";i:341;s:27:"post-date/style-rtl.min.css";i:342;s:19:"post-date/style.css";i:343;s:23:"post-date/style.min.css";i:344;s:27:"post-excerpt/editor-rtl.css";i:345;s:31:"post-excerpt/editor-rtl.min.css";i:346;s:23:"post-excerpt/editor.css";i:347;s:27:"post-excerpt/editor.min.css";i:348;s:26:"post-excerpt/style-rtl.css";i:349;s:30:"post-excerpt/style-rtl.min.css";i:350;s:22:"post-excerpt/style.css";i:351;s:26:"post-excerpt/style.min.css";i:352;s:34:"post-featured-image/editor-rtl.css";i:353;s:38:"post-featured-image/editor-rtl.min.css";i:354;s:30:"post-featured-image/editor.css";i:355;s:34:"post-featured-image/editor.min.css";i:356;s:33:"post-featured-image/style-rtl.css";i:357;s:37:"post-featured-image/style-rtl.min.css";i:358;s:29:"post-featured-image/style.css";i:359;s:33:"post-featured-image/style.min.css";i:360;s:34:"post-navigation-link/style-rtl.css";i:361;s:38:"post-navigation-link/style-rtl.min.css";i:362;s:30:"post-navigation-link/style.css";i:363;s:34:"post-navigation-link/style.min.css";i:364;s:27:"post-template/style-rtl.css";i:365;s:31:"post-template/style-rtl.min.css";i:366;s:23:"post-template/style.css";i:367;s:27:"post-template/style.min.css";i:368;s:24:"post-terms/style-rtl.css";i:369;s:28:"post-terms/style-rtl.min.css";i:370;s:20:"post-terms/style.css";i:371;s:24:"post-terms/style.min.css";i:372;s:31:"post-time-to-read/style-rtl.css";i:373;s:35:"post-time-to-read/style-rtl.min.css";i:374;s:27:"post-time-to-read/style.css";i:375;s:31:"post-time-to-read/style.min.css";i:376;s:24:"post-title/style-rtl.css";i:377;s:28:"post-title/style-rtl.min.css";i:378;s:20:"post-title/style.css";i:379;s:24:"post-title/style.min.css";i:380;s:26:"preformatted/style-rtl.css";i:381;s:30:"preformatted/style-rtl.min.css";i:382;s:22:"preformatted/style.css";i:383;s:26:"preformatted/style.min.css";i:384;s:24:"pullquote/editor-rtl.css";i:385;s:28:"pullquote/editor-rtl.min.css";i:386;s:20:"pullquote/editor.css";i:387;s:24:"pullquote/editor.min.css";i:388;s:23:"pullquote/style-rtl.css";i:389;s:27:"pullquote/style-rtl.min.css";i:390;s:19:"pullquote/style.css";i:391;s:23:"pullquote/style.min.css";i:392;s:23:"pullquote/theme-rtl.css";i:393;s:27:"pullquote/theme-rtl.min.css";i:394;s:19:"pullquote/theme.css";i:395;s:23:"pullquote/theme.min.css";i:396;s:39:"query-pagination-numbers/editor-rtl.css";i:397;s:43:"query-pagination-numbers/editor-rtl.min.css";i:398;s:35:"query-pagination-numbers/editor.css";i:399;s:39:"query-pagination-numbers/editor.min.css";i:400;s:31:"query-pagination/editor-rtl.css";i:401;s:35:"query-pagination/editor-rtl.min.css";i:402;s:27:"query-pagination/editor.css";i:403;s:31:"query-pagination/editor.min.css";i:404;s:30:"query-pagination/style-rtl.css";i:405;s:34:"query-pagination/style-rtl.min.css";i:406;s:26:"query-pagination/style.css";i:407;s:30:"query-pagination/style.min.css";i:408;s:25:"query-title/style-rtl.css";i:409;s:29:"query-title/style-rtl.min.css";i:410;s:21:"query-title/style.css";i:411;s:25:"query-title/style.min.css";i:412;s:25:"query-total/style-rtl.css";i:413;s:29:"query-total/style-rtl.min.css";i:414;s:21:"query-total/style.css";i:415;s:25:"query-total/style.min.css";i:416;s:20:"query/editor-rtl.css";i:417;s:24:"query/editor-rtl.min.css";i:418;s:16:"query/editor.css";i:419;s:20:"query/editor.min.css";i:420;s:19:"quote/style-rtl.css";i:421;s:23:"quote/style-rtl.min.css";i:422;s:15:"quote/style.css";i:423;s:19:"quote/style.min.css";i:424;s:19:"quote/theme-rtl.css";i:425;s:23:"quote/theme-rtl.min.css";i:426;s:15:"quote/theme.css";i:427;s:19:"quote/theme.min.css";i:428;s:23:"read-more/style-rtl.css";i:429;s:27:"read-more/style-rtl.min.css";i:430;s:19:"read-more/style.css";i:431;s:23:"read-more/style.min.css";i:432;s:18:"rss/editor-rtl.css";i:433;s:22:"rss/editor-rtl.min.css";i:434;s:14:"rss/editor.css";i:435;s:18:"rss/editor.min.css";i:436;s:17:"rss/style-rtl.css";i:437;s:21:"rss/style-rtl.min.css";i:438;s:13:"rss/style.css";i:439;s:17:"rss/style.min.css";i:440;s:21:"search/editor-rtl.css";i:441;s:25:"search/editor-rtl.min.css";i:442;s:17:"search/editor.css";i:443;s:21:"search/editor.min.css";i:444;s:20:"search/style-rtl.css";i:445;s:24:"search/style-rtl.min.css";i:446;s:16:"search/style.css";i:447;s:20:"search/style.min.css";i:448;s:20:"search/theme-rtl.css";i:449;s:24:"search/theme-rtl.min.css";i:450;s:16:"search/theme.css";i:451;s:20:"search/theme.min.css";i:452;s:24:"separator/editor-rtl.css";i:453;s:28:"separator/editor-rtl.min.css";i:454;s:20:"separator/editor.css";i:455;s:24:"separator/editor.min.css";i:456;s:23:"separator/style-rtl.css";i:457;s:27:"separator/style-rtl.min.css";i:458;s:19:"separator/style.css";i:459;s:23:"separator/style.min.css";i:460;s:23:"separator/theme-rtl.css";i:461;s:27:"separator/theme-rtl.min.css";i:462;s:19:"separator/theme.css";i:463;s:23:"separator/theme.min.css";i:464;s:24:"shortcode/editor-rtl.css";i:465;s:28:"shortcode/editor-rtl.min.css";i:466;s:20:"shortcode/editor.css";i:467;s:24:"shortcode/editor.min.css";i:468;s:24:"site-logo/editor-rtl.css";i:469;s:28:"site-logo/editor-rtl.min.css";i:470;s:20:"site-logo/editor.css";i:471;s:24:"site-logo/editor.min.css";i:472;s:23:"site-logo/style-rtl.css";i:473;s:27:"site-logo/style-rtl.min.css";i:474;s:19:"site-logo/style.css";i:475;s:23:"site-logo/style.min.css";i:476;s:27:"site-tagline/editor-rtl.css";i:477;s:31:"site-tagline/editor-rtl.min.css";i:478;s:23:"site-tagline/editor.css";i:479;s:27:"site-tagline/editor.min.css";i:480;s:26:"site-tagline/style-rtl.css";i:481;s:30:"site-tagline/style-rtl.min.css";i:482;s:22:"site-tagline/style.css";i:483;s:26:"site-tagline/style.min.css";i:484;s:25:"site-title/editor-rtl.css";i:485;s:29:"site-title/editor-rtl.min.css";i:486;s:21:"site-title/editor.css";i:487;s:25:"site-title/editor.min.css";i:488;s:24:"site-title/style-rtl.css";i:489;s:28:"site-title/style-rtl.min.css";i:490;s:20:"site-title/style.css";i:491;s:24:"site-title/style.min.css";i:492;s:26:"social-link/editor-rtl.css";i:493;s:30:"social-link/editor-rtl.min.css";i:494;s:22:"social-link/editor.css";i:495;s:26:"social-link/editor.min.css";i:496;s:27:"social-links/editor-rtl.css";i:497;s:31:"social-links/editor-rtl.min.css";i:498;s:23:"social-links/editor.css";i:499;s:27:"social-links/editor.min.css";i:500;s:26:"social-links/style-rtl.css";i:501;s:30:"social-links/style-rtl.min.css";i:502;s:22:"social-links/style.css";i:503;s:26:"social-links/style.min.css";i:504;s:21:"spacer/editor-rtl.css";i:505;s:25:"spacer/editor-rtl.min.css";i:506;s:17:"spacer/editor.css";i:507;s:21:"spacer/editor.min.css";i:508;s:20:"spacer/style-rtl.css";i:509;s:24:"spacer/style-rtl.min.css";i:510;s:16:"spacer/style.css";i:511;s:20:"spacer/style.min.css";i:512;s:20:"table/editor-rtl.css";i:513;s:24:"table/editor-rtl.min.css";i:514;s:16:"table/editor.css";i:515;s:20:"table/editor.min.css";i:516;s:19:"table/style-rtl.css";i:517;s:23:"table/style-rtl.min.css";i:518;s:15:"table/style.css";i:519;s:19:"table/style.min.css";i:520;s:19:"table/theme-rtl.css";i:521;s:23:"table/theme-rtl.min.css";i:522;s:15:"table/theme.css";i:523;s:19:"table/theme.min.css";i:524;s:24:"tag-cloud/editor-rtl.css";i:525;s:28:"tag-cloud/editor-rtl.min.css";i:526;s:20:"tag-cloud/editor.css";i:527;s:24:"tag-cloud/editor.min.css";i:528;s:23:"tag-cloud/style-rtl.css";i:529;s:27:"tag-cloud/style-rtl.min.css";i:530;s:19:"tag-cloud/style.css";i:531;s:23:"tag-cloud/style.min.css";i:532;s:28:"template-part/editor-rtl.css";i:533;s:32:"template-part/editor-rtl.min.css";i:534;s:24:"template-part/editor.css";i:535;s:28:"template-part/editor.min.css";i:536;s:27:"template-part/theme-rtl.css";i:537;s:31:"template-part/theme-rtl.min.css";i:538;s:23:"template-part/theme.css";i:539;s:27:"template-part/theme.min.css";i:540;s:24:"term-count/style-rtl.css";i:541;s:28:"term-count/style-rtl.min.css";i:542;s:20:"term-count/style.css";i:543;s:24:"term-count/style.min.css";i:544;s:30:"term-description/style-rtl.css";i:545;s:34:"term-description/style-rtl.min.css";i:546;s:26:"term-description/style.css";i:547;s:30:"term-description/style.min.css";i:548;s:23:"term-name/style-rtl.css";i:549;s:27:"term-name/style-rtl.min.css";i:550;s:19:"term-name/style.css";i:551;s:23:"term-name/style.min.css";i:552;s:28:"term-template/editor-rtl.css";i:553;s:32:"term-template/editor-rtl.min.css";i:554;s:24:"term-template/editor.css";i:555;s:28:"term-template/editor.min.css";i:556;s:27:"term-template/style-rtl.css";i:557;s:31:"term-template/style-rtl.min.css";i:558;s:23:"term-template/style.css";i:559;s:27:"term-template/style.min.css";i:560;s:27:"text-columns/editor-rtl.css";i:561;s:31:"text-columns/editor-rtl.min.css";i:562;s:23:"text-columns/editor.css";i:563;s:27:"text-columns/editor.min.css";i:564;s:26:"text-columns/style-rtl.css";i:565;s:30:"text-columns/style-rtl.min.css";i:566;s:22:"text-columns/style.css";i:567;s:26:"text-columns/style.min.css";i:568;s:19:"verse/style-rtl.css";i:569;s:23:"verse/style-rtl.min.css";i:570;s:15:"verse/style.css";i:571;s:19:"verse/style.min.css";i:572;s:20:"video/editor-rtl.css";i:573;s:24:"video/editor-rtl.min.css";i:574;s:16:"video/editor.css";i:575;s:20:"video/editor.min.css";i:576;s:19:"video/style-rtl.css";i:577;s:23:"video/style-rtl.min.css";i:578;s:15:"video/style.css";i:579;s:19:"video/style.min.css";i:580;s:19:"video/theme-rtl.css";i:581;s:23:"video/theme-rtl.min.css";i:582;s:15:"video/theme.css";i:583;s:19:"video/theme.min.css";}}','on');
INSERT INTO `wp5_options` VALUES (167408,'_site_transient_timeout_theme_roots','1768148037','off');
INSERT INTO `wp5_options` VALUES (167409,'_site_transient_theme_roots','a:6:{s:4:"Divi";s:7:"/themes";s:16:"twentytwentyfive";s:7:"/themes";s:16:"twentytwentyfour";s:7:"/themes";s:15:"twentytwentyone";s:7:"/themes";s:17:"twentytwentythree";s:7:"/themes";s:15:"twentytwentytwo";s:7:"/themes";}','off');
INSERT INTO `wp5_options` VALUES (167193,'_site_transient_timeout_n_6db6858c1df77968307a556cb41a70c47e9c62','1768171722','off');
INSERT INTO `wp5_options` VALUES (167194,'_site_transient_n_6db6858c1df77968307a556cb41a70c47e9c62','1768085319','off');
INSERT INTO `wp5_options` VALUES (167159,'_site_transient_timeout_n_73238281b9b5627487725e55e5db0dce49c1f9','1768167214','off');
INSERT INTO `wp5_options` VALUES (167160,'_site_transient_n_73238281b9b5627487725e55e5db0dce49c1f9','1768080812','off');
INSERT INTO `wp5_options` VALUES (167168,'_site_transient_timeout_n_43e0f872943360e0fae2bff8674cefd1de2934','1768167215','off');
INSERT INTO `wp5_options` VALUES (167169,'_site_transient_n_43e0f872943360e0fae2bff8674cefd1de2934','1768080797','off');
INSERT INTO `wp5_options` VALUES (167170,'_site_transient_timeout_n_0886de06f71a891e3e78b1cd8edd057a68c5ef','1768167219','off');
INSERT INTO `wp5_options` VALUES (167171,'_site_transient_n_0886de06f71a891e3e78b1cd8edd057a68c5ef','1768080815','off');
INSERT INTO `wp5_options` VALUES (167118,'_transient_timeout__et_builder_gf_feature_cache','1768149048','off');
INSERT INTO `wp5_options` VALUES (167119,'_transient__et_builder_gf_feature_cache','1','off');
INSERT INTO `wp5_options` VALUES (167244,'_site_transient_timeout_n_970c9678dcf42e608f4a28eadd90c52d0ad47e','1768180511','off');
INSERT INTO `wp5_options` VALUES (167205,'_site_transient_timeout_n_d0b2ebe4f883f2588583a7d075e34b511bb394','1768172883','off');
INSERT INTO `wp5_options` VALUES (167206,'_site_transient_n_d0b2ebe4f883f2588583a7d075e34b511bb394','1768086481','off');
INSERT INTO `wp5_options` VALUES (167207,'_site_transient_timeout_n_8082370173445d09b787860e0460f7aa19905d','1768172884','off');
INSERT INTO `wp5_options` VALUES (167208,'_site_transient_n_8082370173445d09b787860e0460f7aa19905d','1768086484','off');
INSERT INTO `wp5_options` VALUES (167286,'_site_transient_n_9d361464213b5232661c4625bcb62983f4eb77','1768103852','off');
INSERT INTO `wp5_options` VALUES (167261,'_site_transient_timeout_n_d6144240ff735e49e2646ef4f001ce4f0a7fbb','1768188808','off');
INSERT INTO `wp5_options` VALUES (167262,'_site_transient_n_d6144240ff735e49e2646ef4f001ce4f0a7fbb','1768102406','off');
INSERT INTO `wp5_options` VALUES (167263,'_site_transient_timeout_n_b05878c1a1e63484878202b9f1c9dc1f775398','1768188809','off');
INSERT INTO `wp5_options` VALUES (167264,'_site_transient_n_b05878c1a1e63484878202b9f1c9dc1f775398','1768102409','off');
INSERT INTO `wp5_options` VALUES (167224,'_site_transient_timeout_n_f8edd8480112bd6129bd3eaca652af91043e66','1768173315','off');
INSERT INTO `wp5_options` VALUES (167225,'_site_transient_n_f8edd8480112bd6129bd3eaca652af91043e66','1768086914','off');
INSERT INTO `wp5_options` VALUES (167283,'_site_transient_timeout_n_4a088b36ea42293b1c778d422d797d6e91a468','1768190251','off');
INSERT INTO `wp5_options` VALUES (167284,'_site_transient_n_4a088b36ea42293b1c778d422d797d6e91a468','1768103850','off');
INSERT INTO `wp5_options` VALUES (167285,'_site_transient_timeout_n_9d361464213b5232661c4625bcb62983f4eb77','1768190253','off');
INSERT INTO `wp5_options` VALUES (167175,'_site_transient_timeout_n_470d32bf66e6eb23faafaf2bee39ce7313df0b','1768167282','off');
INSERT INTO `wp5_options` VALUES (167176,'_site_transient_n_470d32bf66e6eb23faafaf2bee39ce7313df0b','1768080880','off');
INSERT INTO `wp5_options` VALUES (167150,'_site_transient_timeout_n_af3ed452c491eec80777e4902714eae2174850','1768167135','off');
INSERT INTO `wp5_options` VALUES (167151,'_site_transient_n_af3ed452c491eec80777e4902714eae2174850','1768080733','off');
INSERT INTO `wp5_options` VALUES (167152,'_site_transient_timeout_n_c15139ff9b699d72d412eba721f3f6ebb0b41b','1768167137','off');
INSERT INTO `wp5_options` VALUES (167153,'_site_transient_n_c15139ff9b699d72d412eba721f3f6ebb0b41b','1768080737','off');
INSERT INTO `wp5_options` VALUES (167177,'_site_transient_timeout_n_4c6983f5dc44ffaa6ef304cd18c42286e3891c','1768167286','off');
INSERT INTO `wp5_options` VALUES (167178,'_site_transient_n_4c6983f5dc44ffaa6ef304cd18c42286e3891c','1768080885','off');
INSERT INTO `wp5_options` VALUES (167179,'_site_transient_timeout_n_725320086d65bf4811e72496bbea26bd1b6726','1768167350','off');
INSERT INTO `wp5_options` VALUES (167180,'_site_transient_n_725320086d65bf4811e72496bbea26bd1b6726','1768080949','off');
INSERT INTO `wp5_options` VALUES (167214,'_site_transient_timeout_n_df4e02aa6beea2c1d028c3e84f4269df7c879f','1768173100','off');
INSERT INTO `wp5_options` VALUES (167215,'_site_transient_n_df4e02aa6beea2c1d028c3e84f4269df7c879f','1768086699','off');
INSERT INTO `wp5_options` VALUES (167216,'_site_transient_timeout_n_01192ae39519d52c2aef407d9fae6f55a20b66','1768173102','off');
INSERT INTO `wp5_options` VALUES (167217,'_site_transient_n_01192ae39519d52c2aef407d9fae6f55a20b66','1768086701','off');
INSERT INTO `wp5_options` VALUES (167245,'_site_transient_n_970c9678dcf42e608f4a28eadd90c52d0ad47e','1768094109','off');
INSERT INTO `wp5_options` VALUES (167246,'_site_transient_timeout_n_4c274f8ba464db3a25c73593e4128d86d184aa','1768180513','off');
INSERT INTO `wp5_options` VALUES (167247,'_site_transient_n_4c274f8ba464db3a25c73593e4128d86d184aa','1768094113','off');
INSERT INTO `wp5_options` VALUES (167271,'_site_transient_timeout_n_95ae361848993711714769ab0b5b2a9b924047','1768189994','off');
INSERT INTO `wp5_options` VALUES (167272,'_site_transient_n_95ae361848993711714769ab0b5b2a9b924047','1768103592','off');
INSERT INTO `wp5_options` VALUES (167410,'_site_transient_update_plugins','O:8:"stdClass":5:{s:12:"last_checked";i:1768146237;s:8:"response";a:0:{}s:12:"translations";a:0:{}s:9:"no_update";a:10:{s:19:"akismet/akismet.php";O:8:"stdClass":10:{s:2:"id";s:21:"w.org/plugins/akismet";s:4:"slug";s:7:"akismet";s:6:"plugin";s:19:"akismet/akismet.php";s:11:"new_version";s:3:"5.6";s:3:"url";s:38:"https://wordpress.org/plugins/akismet/";s:7:"package";s:54:"https://downloads.wordpress.org/plugin/akismet.5.6.zip";s:5:"icons";a:2:{s:2:"2x";s:60:"https://ps.w.org/akismet/assets/icon-256x256.png?rev=2818463";s:2:"1x";s:60:"https://ps.w.org/akismet/assets/icon-128x128.png?rev=2818463";}s:7:"banners";a:2:{s:2:"2x";s:63:"https://ps.w.org/akismet/assets/banner-1544x500.png?rev=2900731";s:2:"1x";s:62:"https://ps.w.org/akismet/assets/banner-772x250.png?rev=2900731";}s:11:"banners_rtl";a:0:{}s:8:"requires";s:3:"5.8";}s:51:"all-in-one-wp-security-and-firewall/wp-security.php";O:8:"stdClass":10:{s:2:"id";s:49:"w.org/plugins/all-in-one-wp-security-and-firewall";s:4:"slug";s:35:"all-in-one-wp-security-and-firewall";s:6:"plugin";s:51:"all-in-one-wp-security-and-firewall/wp-security.php";s:11:"new_version";s:5:"5.4.4";s:3:"url";s:66:"https://wordpress.org/plugins/all-in-one-wp-security-and-firewall/";s:7:"package";s:84:"https://downloads.wordpress.org/plugin/all-in-one-wp-security-and-firewall.5.4.4.zip";s:5:"icons";a:2:{s:2:"2x";s:88:"https://ps.w.org/all-in-one-wp-security-and-firewall/assets/icon-256x256.png?rev=2798307";s:2:"1x";s:88:"https://ps.w.org/all-in-one-wp-security-and-firewall/assets/icon-128x128.png?rev=2798307";}s:7:"banners";a:2:{s:2:"2x";s:91:"https://ps.w.org/all-in-one-wp-security-and-firewall/assets/banner-1544x500.png?rev=2798307";s:2:"1x";s:90:"https://ps.w.org/all-in-one-wp-security-and-firewall/assets/banner-772x250.png?rev=2798307";}s:11:"banners_rtl";a:0:{}s:8:"requires";s:3:"5.0";}s:51:"all-in-one-wp-migration/all-in-one-wp-migration.php";O:8:"stdClass":10:{s:2:"id";s:37:"w.org/plugins/all-in-one-wp-migration";s:4:"slug";s:23:"all-in-one-wp-migration";s:6:"plugin";s:51:"all-in-one-wp-migration/all-in-one-wp-migration.php";s:11:"new_version";s:5:"7.101";s:3:"url";s:54:"https://wordpress.org/plugins/all-in-one-wp-migration/";s:7:"package";s:72:"https://downloads.wordpress.org/plugin/all-in-one-wp-migration.7.101.zip";s:5:"icons";a:2:{s:2:"2x";s:76:"https://ps.w.org/all-in-one-wp-migration/assets/icon-256x256.png?rev=2458334";s:2:"1x";s:76:"https://ps.w.org/all-in-one-wp-migration/assets/icon-128x128.png?rev=2458334";}s:7:"banners";a:2:{s:2:"2x";s:79:"https://ps.w.org/all-in-one-wp-migration/assets/banner-1544x500.png?rev=3427096";s:2:"1x";s:78:"https://ps.w.org/all-in-one-wp-migration/assets/banner-772x250.png?rev=3427096";}s:11:"banners_rtl";a:0:{}s:8:"requires";s:3:"3.3";}s:19:"jetpack/jetpack.php";O:8:"stdClass":10:{s:2:"id";s:21:"w.org/plugins/jetpack";s:4:"slug";s:7:"jetpack";s:6:"plugin";s:19:"jetpack/jetpack.php";s:11:"new_version";s:4:"15.4";s:3:"url";s:38:"https://wordpress.org/plugins/jetpack/";s:7:"package";s:55:"https://downloads.wordpress.org/plugin/jetpack.15.4.zip";s:5:"icons";a:2:{s:2:"1x";s:52:"https://ps.w.org/jetpack/assets/icon.svg?rev=2819237";s:3:"svg";s:52:"https://ps.w.org/jetpack/assets/icon.svg?rev=2819237";}s:7:"banners";a:2:{s:2:"2x";s:63:"https://ps.w.org/jetpack/assets/banner-1544x500.png?rev=2653649";s:2:"1x";s:62:"https://ps.w.org/jetpack/assets/banner-772x250.png?rev=2653649";}s:11:"banners_rtl";a:0:{}s:8:"requires";s:3:"6.7";}s:15:"worker/init.php";O:8:"stdClass":10:{s:2:"id";s:20:"w.org/plugins/worker";s:4:"slug";s:6:"worker";s:6:"plugin";s:15:"worker/init.php";s:11:"new_version";s:6:"4.9.26";s:3:"url";s:37:"https://wordpress.org/plugins/worker/";s:7:"package";s:56:"https://downloads.wordpress.org/plugin/worker.4.9.26.zip";s:5:"icons";a:2:{s:2:"1x";s:51:"https://ps.w.org/worker/assets/icon.svg?rev=1015191";s:3:"svg";s:51:"https://ps.w.org/worker/assets/icon.svg?rev=1015191";}s:7:"banners";a:2:{s:2:"2x";s:62:"https://ps.w.org/worker/assets/banner-1544x500.jpg?rev=2035974";s:2:"1x";s:61:"https://ps.w.org/worker/assets/banner-772x250.jpg?rev=2035974";}s:11:"banners_rtl";a:0:{}s:8:"requires";s:3:"3.1";}s:26:"popups-for-divi/plugin.php";O:8:"stdClass":10:{s:2:"id";s:29:"w.org/plugins/popups-for-divi";s:4:"slug";s:15:"popups-for-divi";s:6:"plugin";s:26:"popups-for-divi/plugin.php";s:11:"new_version";s:5:"3.2.3";s:3:"url";s:46:"https://wordpress.org/plugins/popups-for-divi/";s:7:"package";s:64:"https://downloads.wordpress.org/plugin/popups-for-divi.3.2.3.zip";s:5:"icons";a:2:{s:2:"2x";s:68:"https://ps.w.org/popups-for-divi/assets/icon-256x256.jpg?rev=2553226";s:2:"1x";s:68:"https://ps.w.org/popups-for-divi/assets/icon-128x128.jpg?rev=2553226";}s:7:"banners";a:2:{s:2:"2x";s:71:"https://ps.w.org/popups-for-divi/assets/banner-1544x500.jpg?rev=2553226";s:2:"1x";s:70:"https://ps.w.org/popups-for-divi/assets/banner-772x250.jpg?rev=2553226";}s:11:"banners_rtl";a:0:{}s:8:"requires";s:5:"4.0.0";}s:46:"under-construction-page/under-construction.php";O:8:"stdClass":10:{s:2:"id";s:37:"w.org/plugins/under-construction-page";s:4:"slug";s:23:"under-construction-page";s:6:"plugin";s:46:"under-construction-page/under-construction.php";s:11:"new_version";s:4:"4.03";s:3:"url";s:54:"https://wordpress.org/plugins/under-construction-page/";s:7:"package";s:71:"https://downloads.wordpress.org/plugin/under-construction-page.4.03.zip";s:5:"icons";a:2:{s:2:"2x";s:76:"https://ps.w.org/under-construction-page/assets/icon-256x256.gif?rev=2284849";s:2:"1x";s:76:"https://ps.w.org/under-construction-page/assets/icon-128x128.gif?rev=2284852";}s:7:"banners";a:2:{s:2:"2x";s:79:"https://ps.w.org/under-construction-page/assets/banner-1544x500.png?rev=1628376";s:2:"1x";s:78:"https://ps.w.org/under-construction-page/assets/banner-772x250.png?rev=1575797";}s:11:"banners_rtl";a:0:{}s:8:"requires";s:3:"4.0";}s:47:"wpvivid-backuprestore/wpvivid-backuprestore.php";O:8:"stdClass":10:{s:2:"id";s:35:"w.org/plugins/wpvivid-backuprestore";s:4:"slug";s:21:"wpvivid-backuprestore";s:6:"plugin";s:47:"wpvivid-backuprestore/wpvivid-backuprestore.php";s:11:"new_version";s:7:"0.9.122";s:3:"url";s:52:"https://wordpress.org/plugins/wpvivid-backuprestore/";s:7:"package";s:72:"https://downloads.wordpress.org/plugin/wpvivid-backuprestore.0.9.122.zip";s:5:"icons";a:2:{s:2:"2x";s:74:"https://ps.w.org/wpvivid-backuprestore/assets/icon-256x256.png?rev=2899202";s:2:"1x";s:74:"https://ps.w.org/wpvivid-backuprestore/assets/icon-128x128.png?rev=2899202";}s:7:"banners";a:2:{s:2:"2x";s:77:"https://ps.w.org/wpvivid-backuprestore/assets/banner-1544x500.png?rev=2899202";s:2:"1x";s:76:"https://ps.w.org/wpvivid-backuprestore/assets/banner-772x250.png?rev=2899202";}s:11:"banners_rtl";a:0:{}s:8:"requires";s:3:"4.5";}s:24:"wordpress-seo/wp-seo.php";O:8:"stdClass":10:{s:2:"id";s:27:"w.org/plugins/wordpress-seo";s:4:"slug";s:13:"wordpress-seo";s:6:"plugin";s:24:"wordpress-seo/wp-seo.php";s:11:"new_version";s:4:"26.7";s:3:"url";s:44:"https://wordpress.org/plugins/wordpress-seo/";s:7:"package";s:61:"https://downloads.wordpress.org/plugin/wordpress-seo.26.7.zip";s:5:"icons";a:2:{s:2:"2x";s:66:"https://ps.w.org/wordpress-seo/assets/icon-256x256.gif?rev=3419908";s:2:"1x";s:66:"https://ps.w.org/wordpress-seo/assets/icon-128x128.gif?rev=3419908";}s:7:"banners";a:2:{s:2:"2x";s:69:"https://ps.w.org/wordpress-seo/assets/banner-1544x500.png?rev=3257862";s:2:"1x";s:68:"https://ps.w.org/wordpress-seo/assets/banner-772x250.png?rev=3257862";}s:11:"banners_rtl";a:2:{s:2:"2x";s:73:"https://ps.w.org/wordpress-seo/assets/banner-1544x500-rtl.png?rev=3257862";s:2:"1x";s:72:"https://ps.w.org/wordpress-seo/assets/banner-772x250-rtl.png?rev=3257862";}s:8:"requires";s:3:"6.7";}s:15:"bloom/bloom.php";O:8:"stdClass":11:{s:11:"new_version";s:6:"1.3.12";s:6:"plugin";s:15:"bloom/bloom.php";s:4:"slug";s:5:"bloom";s:6:"tested";s:5:"5.3.2";s:5:"icons";a:2:{s:2:"2x";s:57:"https://www.elegantthemes.com/images/plugins/2x/bloom.png";s:2:"1x";s:57:"https://www.elegantthemes.com/images/plugins/1x/bloom.png";}s:3:"url";s:53:"https://www.elegantthemes.com/api/changelog/bloom.txt";s:2:"id";s:15:"bloom/bloom.php";s:7:"banners";a:0:{}s:11:"banners_rtl";a:0:{}s:12:"requires_php";s:0:"";s:13:"compatibility";O:8:"stdClass":0:{}}}s:7:"checked";a:10:{s:19:"akismet/akismet.php";s:3:"5.6";s:51:"all-in-one-wp-security-and-firewall/wp-security.php";s:5:"5.4.4";s:51:"all-in-one-wp-migration/all-in-one-wp-migration.php";s:5:"7.101";s:15:"bloom/bloom.php";s:6:"1.3.12";s:19:"jetpack/jetpack.php";s:4:"15.4";s:15:"worker/init.php";s:6:"4.9.26";s:26:"popups-for-divi/plugin.php";s:5:"3.2.3";s:46:"under-construction-page/under-construction.php";s:4:"4.03";s:47:"wpvivid-backuprestore/wpvivid-backuprestore.php";s:7:"0.9.122";s:24:"wordpress-seo/wp-seo.php";s:4:"26.7";}}','off');
INSERT INTO `wp5_options` VALUES (167360,'_site_transient_timeout_n_71b44827d1605cb0552a1ce1d89341fe9c50d9','1768221912','off');
INSERT INTO `wp5_options` VALUES (167361,'_site_transient_n_71b44827d1605cb0552a1ce1d89341fe9c50d9','1768135511','off');
INSERT INTO `wp5_options` VALUES (167362,'_site_transient_timeout_n_36e1ad4ed5d5b3bee4f13a7b59b79fae857d7f','1768221914','off');
INSERT INTO `wp5_options` VALUES (167363,'_site_transient_n_36e1ad4ed5d5b3bee4f13a7b59b79fae857d7f','1768135513','off');
INSERT INTO `wp5_options` VALUES (167332,'_site_transient_timeout_n_a14c4eae77aa2fac0df0e9c8ffb96d19c06185','1768220634','off');
INSERT INTO `wp5_options` VALUES (167411,'_site_transient_update_themes','O:8:"stdClass":5:{s:12:"last_checked";i:1768146237;s:7:"checked";a:6:{s:4:"Divi";s:6:"4.27.4";s:16:"twentytwentyfive";s:3:"1.4";s:16:"twentytwentyfour";s:3:"1.4";s:15:"twentytwentyone";s:3:"2.7";s:17:"twentytwentythree";s:3:"1.6";s:15:"twentytwentytwo";s:3:"2.1";}s:8:"response";a:1:{s:4:"Divi";a:3:{s:11:"new_version";s:6:"4.27.5";s:5:"theme";s:4:"Divi";s:3:"url";s:52:"https://www.elegantthemes.com/api/changelog/divi.txt";}}s:9:"no_update";a:5:{s:16:"twentytwentyfive";a:6:{s:5:"theme";s:16:"twentytwentyfive";s:11:"new_version";s:3:"1.4";s:3:"url";s:46:"https://wordpress.org/themes/twentytwentyfive/";s:7:"package";s:62:"https://downloads.wordpress.org/theme/twentytwentyfive.1.4.zip";s:8:"requires";s:3:"6.7";s:12:"requires_php";s:3:"7.2";}s:16:"twentytwentyfour";a:6:{s:5:"theme";s:16:"twentytwentyfour";s:11:"new_version";s:3:"1.4";s:3:"url";s:46:"https://wordpress.org/themes/twentytwentyfour/";s:7:"package";s:62:"https://downloads.wordpress.org/theme/twentytwentyfour.1.4.zip";s:8:"requires";s:3:"6.4";s:12:"requires_php";s:3:"7.0";}s:15:"twentytwentyone";a:6:{s:5:"theme";s:15:"twentytwentyone";s:11:"new_version";s:3:"2.7";s:3:"url";s:45:"https://wordpress.org/themes/twentytwentyone/";s:7:"package";s:61:"https://downloads.wordpress.org/theme/twentytwentyone.2.7.zip";s:8:"requires";s:3:"5.3";s:12:"requires_php";s:3:"5.6";}s:17:"twentytwentythree";a:6:{s:5:"theme";s:17:"twentytwentythree";s:11:"new_version";s:3:"1.6";s:3:"url";s:47:"https://wordpress.org/themes/twentytwentythree/";s:7:"package";s:63:"https://downloads.wordpress.org/theme/twentytwentythree.1.6.zip";s:8:"requires";s:3:"6.1";s:12:"requires_php";s:3:"5.6";}s:15:"twentytwentytwo";a:6:{s:5:"theme";s:15:"twentytwentytwo";s:11:"new_version";s:3:"2.1";s:3:"url";s:45:"https://wordpress.org/themes/twentytwentytwo/";s:7:"package";s:61:"https://downloads.wordpress.org/theme/twentytwentytwo.2.1.zip";s:8:"requires";s:3:"5.9";s:12:"requires_php";s:3:"5.6";}}s:12:"translations";a:0:{}}','off');
INSERT INTO `wp5_options` VALUES (167333,'_site_transient_n_a14c4eae77aa2fac0df0e9c8ffb96d19c06185','1768134232','off');
INSERT INTO `wp5_options` VALUES (167334,'_site_transient_timeout_n_9c8def3e82024c9861db6c64796b7861bcf07a','1768220645','off');
INSERT INTO `wp5_options` VALUES (167335,'_site_transient_n_9c8def3e82024c9861db6c64796b7861bcf07a','1768134244','off');
INSERT INTO `wp5_options` VALUES (167373,'_site_transient_timeout_n_420a6ef2d57a249a419a35ebe26ec38afe74e5','1768230598','off');
INSERT INTO `wp5_options` VALUES (167339,'_site_transient_timeout_n_9322d8023a76187c459a9e56f3b59ce7d0e0f6','1768221049','off');
INSERT INTO `wp5_options` VALUES (167340,'_site_transient_n_9322d8023a76187c459a9e56f3b59ce7d0e0f6','1768134648','off');
INSERT INTO `wp5_options` VALUES (167341,'_site_transient_timeout_n_481594a229303d2c6519379f9a54e6d85a933e','1768221049','off');
INSERT INTO `wp5_options` VALUES (167342,'_site_transient_n_481594a229303d2c6519379f9a54e6d85a933e','1768134649','off');
INSERT INTO `wp5_options` VALUES (167343,'_site_transient_timeout_n_9d808de6e44092e788b0411cbb92f0de4304a4','1768221050','off');
INSERT INTO `wp5_options` VALUES (167344,'_site_transient_n_9d808de6e44092e788b0411cbb92f0de4304a4','1768134650','off');
INSERT INTO `wp5_options` VALUES (167412,'_site_transient_update_core','O:8:"stdClass":4:{s:7:"updates";a:1:{i:0;O:8:"stdClass":10:{s:8:"response";s:6:"latest";s:8:"download";s:57:"https://downloads.wordpress.org/release/wordpress-6.9.zip";s:6:"locale";s:5:"en_US";s:8:"packages";O:8:"stdClass":5:{s:4:"full";s:57:"https://downloads.wordpress.org/release/wordpress-6.9.zip";s:10:"no_content";s:68:"https://downloads.wordpress.org/release/wordpress-6.9-no-content.zip";s:11:"new_bundled";s:69:"https://downloads.wordpress.org/release/wordpress-6.9-new-bundled.zip";s:7:"partial";s:0:"";s:8:"rollback";s:0:"";}s:7:"current";s:3:"6.9";s:7:"version";s:3:"6.9";s:11:"php_version";s:6:"7.2.24";s:13:"mysql_version";s:5:"5.5.5";s:11:"new_bundled";s:3:"6.7";s:15:"partial_version";s:0:"";}}s:12:"last_checked";i:1768146238;s:15:"version_checked";s:3:"6.9";s:12:"translations";a:0:{}}','off');
INSERT INTO `wp5_options` VALUES (167348,'_site_transient_timeout_n_abced7b0ebd462deb24b905741538198c0db9c','1768221071','off');
INSERT INTO `wp5_options` VALUES (167349,'_site_transient_n_abced7b0ebd462deb24b905741538198c0db9c','1768134669','off');
INSERT INTO `wp5_options` VALUES (167374,'_site_transient_n_420a6ef2d57a249a419a35ebe26ec38afe74e5','1768144192','off');
INSERT INTO `wp5_options` VALUES (167377,'_site_transient_timeout_n_1a7f8d3f86fbd90f93ab5af27b37d66ae1d6ed','1768230610','off');
INSERT INTO `wp5_options` VALUES (167378,'_site_transient_n_1a7f8d3f86fbd90f93ab5af27b37d66ae1d6ed','1768144205','off');
INSERT INTO `wp5_options` VALUES (167379,'_site_transient_mwp_sessions','a:1:{i:1;a:1:{i:0;s:43:"S4kGXsvFP6eB6jHDMeztaUSJRXIp2WvSL96HhllNkRj";}}','off');
INSERT INTO `wp5_options` VALUES (167380,'_site_transient_timeout_browser_3c9fc7ddec9b58823c1c96756dbd45d8','1768749011','off');
INSERT INTO `wp5_options` VALUES (167381,'_site_transient_browser_3c9fc7ddec9b58823c1c96756dbd45d8','a:10:{s:4:"name";s:6:"Chrome";s:7:"version";s:9:"142.0.0.0";s:8:"platform";s:7:"Windows";s:10:"update_url";s:29:"https://www.google.com/chrome";s:7:"img_src";s:43:"http://s.w.org/images/browsers/chrome.png?1";s:11:"img_src_ssl";s:44:"https://s.w.org/images/browsers/chrome.png?1";s:15:"current_version";s:2:"18";s:7:"upgrade";b:0;s:8:"insecure";b:0;s:6:"mobile";b:0;}','off');
INSERT INTO `wp5_options` VALUES (167382,'_site_transient_timeout_community-events-fba40bb93531d35f34c2500f5812902b','1768187419','off');
INSERT INTO `wp5_options` VALUES (167383,'_site_transient_community-events-fba40bb93531d35f34c2500f5812902b','a:4:{s:9:"sandboxed";b:0;s:5:"error";N;s:8:"location";a:1:{s:2:"ip";s:20:"2601:140:8e80:4f30::";}s:6:"events";a:4:{i:0;a:10:{s:4:"type";s:6:"meetup";s:5:"title";s:47:"WordPress Casual Discussion and Troubleshooting";s:3:"url";s:60:"https://www.meetup.com/wordpress-frederick/events/311963004/";s:6:"meetup";s:19:"WordPress Frederick";s:10:"meetup_url";s:43:"https://www.meetup.com/wordpress-frederick/";s:4:"date";s:19:"2026-01-10 10:00:00";s:8:"end_date";s:19:"2026-01-10 12:00:00";s:20:"start_unix_timestamp";i:1768057200;s:18:"end_unix_timestamp";i:1768064400;s:8:"location";a:4:{s:8:"location";s:18:"Frederick, MD, USA";s:7:"country";s:2:"US";s:8:"latitude";d:39.39195600000000041518433135934174060821533203125;s:9:"longitude";d:-77.40940000000000509317032992839813232421875;}}i:1;a:10:{s:4:"type";s:6:"meetup";s:5:"title";s:48:"Web Accessibility in 2026: What you need to know";s:3:"url";s:70:"https://www.meetup.com/the-baltimore-wordpress-group/events/312266224/";s:6:"meetup";s:29:"The Baltimore WordPress Group";s:10:"meetup_url";s:53:"https://www.meetup.com/the-baltimore-wordpress-group/";s:4:"date";s:19:"2026-01-14 11:00:00";s:8:"end_date";s:19:"2026-01-14 12:00:00";s:20:"start_unix_timestamp";i:1768406400;s:18:"end_unix_timestamp";i:1768410000;s:8:"location";a:4:{s:8:"location";s:6:"Online";s:7:"country";s:2:"US";s:8:"latitude";d:39.31000000000000227373675443232059478759765625;s:9:"longitude";d:-76.5799999999999982946974341757595539093017578125;}}i:2;a:10:{s:4:"type";s:6:"meetup";s:5:"title";s:45:"All Levels: Online Ask Me Anything WordPress!";s:3:"url";s:70:"https://www.meetup.com/the-baltimore-wordpress-group/events/312265914/";s:6:"meetup";s:29:"The Baltimore WordPress Group";s:10:"meetup_url";s:53:"https://www.meetup.com/the-baltimore-wordpress-group/";s:4:"date";s:19:"2026-02-11 11:00:00";s:8:"end_date";s:19:"2026-02-11 12:00:00";s:20:"start_unix_timestamp";i:1770825600;s:18:"end_unix_timestamp";i:1770829200;s:8:"location";a:4:{s:8:"location";s:6:"Online";s:7:"country";s:2:"US";s:8:"latitude";d:39.31000000000000227373675443232059478759765625;s:9:"longitude";d:-76.5799999999999982946974341757595539093017578125;}}i:3;a:10:{s:4:"type";s:6:"meetup";s:5:"title";s:47:"WordPress Casual Discussion and Troubleshooting";s:3:"url";s:60:"https://www.meetup.com/wordpress-frederick/events/311963047/";s:6:"meetup";s:19:"WordPress Frederick";s:10:"meetup_url";s:43:"https://www.meetup.com/wordpress-frederick/";s:4:"date";s:19:"2026-03-14 10:00:00";s:8:"end_date";s:19:"2026-03-14 12:00:00";s:20:"start_unix_timestamp";i:1773496800;s:18:"end_unix_timestamp";i:1773504000;s:8:"location";a:4:{s:8:"location";s:18:"Frederick, MD, USA";s:7:"country";s:2:"US";s:8:"latitude";d:39.39195600000000041518433135934174060821533203125;s:9:"longitude";d:-77.40940000000000509317032992839813232421875;}}}}','off');
INSERT INTO `wp5_options` VALUES (167384,'_site_transient_timeout_feed_9bbd59226dc36b9b26cd43f15694c5c3','1768187419','off');
INSERT INTO `wp5_options` VALUES (167385,'_site_transient_feed_9bbd59226dc36b9b26cd43f15694c5c3','a:6:{s:5:"child";a:1:{s:0:"";a:1:{s:3:"rss";a:1:{i:0;a:6:{s:4:"data";s:3:"\n\n\n";s:7:"attribs";a:1:{s:0:"";a:1:{s:7:"version";s:3:"2.0";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:1:{s:0:"";a:1:{s:7:"channel";a:1:{i:0;a:6:{s:4:"data";s:52:"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\n \n	\n		\n		\n		\n		\n		\n		\n		\n		\n		\n	";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:4:{s:0:"";a:8:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:14:"WordPress News";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:26:"https://wordpress.org/news";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:59:"The latest news about WordPress and the WordPress community";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:13:"lastBuildDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Wed, 10 Dec 2025 17:16:49 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"language";a:1:{i:0;a:5:{s:4:"data";s:5:"en-US";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:9:"generator";a:1:{i:0;a:5:{s:4:"data";s:40:"https://wordpress.org/?v=7.0-alpha-61437";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:5:"image";a:1:{i:0;a:6:{s:4:"data";s:11:"\n	\n	\n	\n	\n	\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:1:{s:0:"";a:5:{s:3:"url";a:1:{i:0;a:5:{s:4:"data";s:29:"https://s.w.org/favicon.ico?2";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:14:"WordPress News";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:26:"https://wordpress.org/news";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:5:"width";a:1:{i:0;a:5:{s:4:"data";s:2:"32";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:6:"height";a:1:{i:0;a:5:{s:4:"data";s:2:"32";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}}s:4:"item";a:10:{i:0;a:6:{s:4:"data";s:60:"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n			";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:4:{s:0:"";a:6:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:40:"2026 Global Partner Program Announcement";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:63:"https://wordpress.org/news/2025/12/2026-global-partner-program/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Wed, 10 Dec 2025 17:16:48 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:2:{i:0;a:5:{s:4:"data";s:9:"Community";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:1;a:5:{s:4:"data";s:6:"Events";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:35:"https://wordpress.org/news/?p=19534";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:412:"Become a driving force behind WordPress innovation by joining the Global Community Sponsorship Program: a comprehensive initiative that supports the events and people powering our open source mission. As a Global Sponsor, your organization gains meaningful visibility across the international WordPress ecosystem while helping to fund events that foster growth, collaboration, and community. Why Choose [&#8230;]";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:12:"Harmony Romo";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:11388:"\n<p>Become a driving force behind WordPress innovation by joining the Global Community Sponsorship Program: a comprehensive initiative that supports the events and people powering our open source mission. As a Global Sponsor, your organization gains meaningful visibility across the international WordPress ecosystem while helping to fund events that foster growth, collaboration, and community.</p>\n\n\n\n<figure class="wp-block-image size-large"><img data-recalc-dims="1" fetchpriority="high" decoding="async" width="1024" height="576" src="https://i0.wp.com/wordpress.org/news/files/2025/12/WordPress-Global-Partners-Program-2026-.jpg?resize=1024%2C576&#038;ssl=1" alt="" class="wp-image-19617" srcset="https://i0.wp.com/wordpress.org/news/files/2025/12/WordPress-Global-Partners-Program-2026-.jpg?resize=1024%2C576&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/12/WordPress-Global-Partners-Program-2026-.jpg?resize=300%2C169&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/12/WordPress-Global-Partners-Program-2026-.jpg?resize=768%2C432&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/12/WordPress-Global-Partners-Program-2026-.jpg?resize=1536%2C864&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/12/WordPress-Global-Partners-Program-2026-.jpg?w=1600&amp;ssl=1 1600w" sizes="(max-width: 1000px) 100vw, 1000px" /></figure>\n\n\n\n<h2 class="wp-block-heading">Why Choose Global Sponsorship?</h2>\n\n\n\n<p>Instead of managing multiple individual sponsorships, this streamlined program consolidates your efforts into one efficient and impactful partnership.</p>\n\n\n\n<h3 class="wp-block-heading">Efficiency and Simplified Administration</h3>\n\n\n\n<p>Skip the complexity of coordinating invoice payments with numerous volunteer teams. Our centralized approach saves time and resources. In 2026, sponsors will benefit from:</p>\n\n\n\n<ul class="wp-block-list">\n<li>A dedicated Slack channel for direct communication with the WordPress Community Support team and Community Program Managers</li>\n\n\n\n<li>Monthly updates listing upcoming WordPress events, their current planning stages, and scheduled dates</li>\n</ul>\n\n\n\n<h3 class="wp-block-heading">Expanded Reach and Impact</h3>\n\n\n\n<p>Your sponsorship amplifies your presence worldwide, ensuring consistent visibility across global WordPress community events.</p>\n\n\n\n<h3 class="wp-block-heading">Stability and Reliability</h3>\n\n\n\n<p>Your commitment strengthens locally organized events by providing predictable funding that supports venues, logistics, and growth.</p>\n\n\n\n<h3 class="wp-block-heading">Flexible Branding Options</h3>\n\n\n\n<p>Adapt across your portfolio—Global Sponsors can represent different brands at different events (subject to approval and advance notice).</p>\n\n\n\n<h3 class="wp-block-heading">Program Benefits</h3>\n\n\n\n<figure class="wp-block-table"><table class="has-fixed-layout"><tbody><tr><td class="has-text-align-left" data-align="left"></td><td class="has-text-align-center" data-align="center"><strong>Global&nbsp;Leader</strong></td><td class="has-text-align-center" data-align="center"><strong>Regional Powerhouse</strong></td><td class="has-text-align-center" data-align="center"><strong>Community Builder</strong></td></tr><tr><td class="has-text-align-left" data-align="left"><br><br><br><br><strong>Best for:<br></strong></td><td class="has-text-align-center" data-align="center">Established brands seeking global reach and year-round visibility.</td><td class="has-text-align-center" data-align="center">Companies aiming for regional dominance and strong brand recognition.</td><td class="has-text-align-center" data-align="center">Organizations supporting the next generation of WordPress education.</td></tr><tr><td class="has-text-align-left" data-align="left">Sponsorship payable in full or through quarterly installments</td><td class="has-text-align-center" data-align="center">$180,000</td><td class="has-text-align-center" data-align="center">$110,000</td><td class="has-text-align-center" data-align="center">$60,000</td></tr><tr><td class="has-text-align-left" data-align="left">Top tier sponsorship benefits at all local <a href="https://central.wordcamp.org/">WordCamp</a> events (excludes flagships) with priority access to claim a sponsor table at in-person <a href="https://events.wordpress.org/">WordPress events</a></td><td class="has-text-align-center" data-align="center"><img src="https://s.w.org/images/core/emoji/17.0.2/72x72/2714.png" alt="✔" class="wp-smiley" style="height: 1em; max-height: 1em;" /></td><td class="has-text-align-center" data-align="center"></td><td class="has-text-align-center" data-align="center"></td></tr><tr><td class="has-text-align-left" data-align="left">Option to feature multiple brands across events</td><td class="has-text-align-center" data-align="center"><img src="https://s.w.org/images/core/emoji/17.0.2/72x72/2714.png" alt="✔" class="wp-smiley" style="height: 1em; max-height: 1em;" /></td><td class="has-text-align-center" data-align="center"></td><td class="has-text-align-center" data-align="center"></td></tr><tr><td class="has-text-align-left" data-align="left">Dedicated sponsor landing page</td><td class="has-text-align-center" data-align="center"><img src="https://s.w.org/images/core/emoji/17.0.2/72x72/2714.png" alt="✔" class="wp-smiley" style="height: 1em; max-height: 1em;" /></td><td class="has-text-align-center" data-align="center"><img src="https://s.w.org/images/core/emoji/17.0.2/72x72/2714.png" alt="✔" class="wp-smiley" style="height: 1em; max-height: 1em;" /></td><td class="has-text-align-center" data-align="center"></td></tr><tr><td class="has-text-align-left" data-align="left">Complimentary WordPress event tickets for your team</td><td class="has-text-align-center" data-align="center"><img src="https://s.w.org/images/core/emoji/17.0.2/72x72/2714.png" alt="✔" class="wp-smiley" style="height: 1em; max-height: 1em;" /></td><td class="has-text-align-center" data-align="center"><img src="https://s.w.org/images/core/emoji/17.0.2/72x72/2714.png" alt="✔" class="wp-smiley" style="height: 1em; max-height: 1em;" /></td><td class="has-text-align-center" data-align="center"></td></tr><tr><td class="has-text-align-left" data-align="left">Recognition across all <a href="https://events.wordpress.org/">WordPress events</a></td><td class="has-text-align-center" data-align="center"><img src="https://s.w.org/images/core/emoji/17.0.2/72x72/2714.png" alt="✔" class="wp-smiley" style="height: 1em; max-height: 1em;" /></td><td class="has-text-align-center" data-align="center"><img src="https://s.w.org/images/core/emoji/17.0.2/72x72/2714.png" alt="✔" class="wp-smiley" style="height: 1em; max-height: 1em;" /></td><td class="has-text-align-center" data-align="center"></td></tr><tr><td class="has-text-align-left" data-align="left">Sponsor Spotlight post on WordPress.org/news featuring highlights from recent <a href="https://central.wordcamp.org/">WordCamps</a></td><td class="has-text-align-center" data-align="center">Quarterly</td><td class="has-text-align-center" data-align="center">Annually</td><td class="has-text-align-center" data-align="center"></td></tr><tr><td class="has-text-align-left" data-align="left">Inclusion of your company logo in signage and materials for <a href="https://events.wordpress.org/campusconnect/">WordPress Campus Connect</a> events</td><td class="has-text-align-center" data-align="center">All signage &amp; materials for the year (digital and printed)</td><td class="has-text-align-center" data-align="center">Signage &amp; materials for 5 events per year (printed only)</td><td class="has-text-align-center" data-align="center">All signage &amp; materials for the year (digital and printed)</td></tr><tr><td class="has-text-align-left" data-align="left">Opportunity to be featured in an exclusive digital binder for <a href="https://events.wordpress.org/campusconnect/">WordPress Campus Connect</a> event organizers</td><td class="has-text-align-center" data-align="center">Priority placement (logos &amp; text)</td><td class="has-text-align-center" data-align="center">Feature listing (text only)</td><td class="has-text-align-center" data-align="center">Feature listing (text only)</td></tr><tr><td class="has-text-align-left" data-align="left">Regular recognition in <a href="https://make.wordpress.org/community/2025/11/03/monthly-education-buzz-report-october-2025/">monthly education buzz report</a></td><td class="has-text-align-center" data-align="center"></td><td class="has-text-align-center" data-align="center"></td><td class="has-text-align-center" data-align="center"><img src="https://s.w.org/images/core/emoji/17.0.2/72x72/2714.png" alt="✔" class="wp-smiley" style="height: 1em; max-height: 1em;" /></td></tr></tbody></table></figure>\n\n\n\n<h2 class="wp-block-heading">How Sponsorship Funds Are Used</h2>\n\n\n\n<p>Global Sponsorship funds directly support:</p>\n\n\n\n<ul class="wp-block-list">\n<li>Local WordPress events worldwide (venue rental, catering, A/V, and more)</li>\n\n\n\n<li>Meetup.com license fees for over 671 WordPress Meetup groups globally</li>\n\n\n\n<li>Administrative costs like insurance, banking, and annual financial audits that ensure transparent operations</li>\n</ul>\n\n\n\n<p>Your partnership helps sustain the community that powers more than 43% of the web. Together, we can keep the WordPress project thriving and expanding for years to come.</p>\n\n\n\n<div class="wp-block-group has-off-white-2-background-color has-background is-layout-constrained wp-container-core-group-is-layout-d1b48064 wp-block-group-is-layout-constrained" style="padding-top:var(--wp--preset--spacing--edge-space);padding-right:var(--wp--preset--spacing--edge-space);padding-bottom:var(--wp--preset--spacing--edge-space);padding-left:var(--wp--preset--spacing--edge-space)">\n<p class="has-text-align-center"><strong><strong>If your company is interested in joining the Global Sponsorship program or you would like to know more, please reach out</strong></strong>.</p>\n\n\n\n<div class="wp-block-buttons is-content-justification-center is-layout-flex wp-container-core-buttons-is-layout-a89b3969 wp-block-buttons-is-layout-flex">\n<div class="wp-block-button"><a class="wp-block-button__link wp-element-button" href="mailto:support@wordcamp.org">Contact WordPress Community Support</a></div>\n</div>\n\n\n\n<div style="height:25px" aria-hidden="true" class="wp-block-spacer"></div>\n\n\n\n<p><em>Please see&nbsp;<a href="https://make.wordpress.org/community/handbook/wordcamp-organizer/planning-details/fundraising/global-community-sponsorship-for-event-organizers/#rules-for-sponsor-materials">Rules for Sponsor Materials</a>&nbsp;for more details about terms of sponsorship. Please also see our&nbsp;<a href="https://make.wordpress.org/community/files/2024/12/Draft-of-2025-WordPress-Global-Community-Sponsorship-Agreement-Template-Google-Docs.pdf" target="_blank" rel="noreferrer noopener">sample sponsorship agreement</a>.</em></p>\n</div>\n\n\n\n<p>If you’d like to go one step further, please consider <a href="https://wordpressfoundation.org/donate/">donating directly to the WordPress Foundation</a>. We operate lean—every dollar goes toward keeping WordPress free, supporting education, and funding the community that makes the web a better place. In short, your donation helps us keep the lights on and the mission alive.</p>\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:30:"com-wordpress:feed-additions:1";a:1:{s:7:"post-id";a:1:{i:0;a:5:{s:4:"data";s:5:"19534";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:1;a:6:{s:4:"data";s:65:"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n\n					\n										\n					\n		\n		\n\n\n			";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:4:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:54:"State of the Word 2025: Innovation Shaped by Community";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:45:"https://wordpress.org/news/2025/12/sotw-2025/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Wed, 03 Dec 2025 18:26:05 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:3:{i:0;a:5:{s:4:"data";s:9:"Community";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:1;a:5:{s:4:"data";s:6:"Events";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:2;a:5:{s:4:"data";s:17:"state of the word";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:35:"https://wordpress.org/news/?p=19447";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:354:"State of the Word 2025 brought the WordPress community together for an afternoon that felt both reflective and forward-moving, blending stories of global growth with technical milestones and glimpses of the future. This year also marked the twentieth State of the Word since the first address in 2006, a milestone noted in the WordPress history [&#8230;]";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:9:"enclosure";a:2:{i:0;a:5:{s:4:"data";s:0:"";s:7:"attribs";a:1:{s:0:"";a:3:{s:3:"url";s:59:"https://wordpress.org/news/files/2025/12/Telex-demo-776.mp4";s:6:"length";s:8:"29136831";s:4:"type";s:9:"video/mp4";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:1;a:5:{s:4:"data";s:0:"";s:7:"attribs";a:1:{s:0:"";a:3:{s:3:"url";s:53:"https://wordpress.org/news/files/2025/12/wapu-513.mp4";s:6:"length";s:9:"102323371";s:4:"type";s:9:"video/mp4";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:17:"Nicholas Garofalo";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:36376:"\n<figure class="wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio"><div class="wp-block-embed__wrapper">\n<iframe title="State of the Word 2025" width="500" height="281" src="https://www.youtube.com/embed/U_DF4-23C8Q?feature=oembed" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" referrerpolicy="strict-origin-when-cross-origin" allowfullscreen></iframe>\n</div></figure>\n\n\n\n<p>State of the Word 2025 brought the WordPress community together for an afternoon that felt both reflective and forward-moving, blending stories of global growth with technical milestones and glimpses of the future. This year also marked the twentieth State of the Word since the first address in 2006, a milestone noted in the WordPress history book <a href="https://wordpress.org/book/2015/11/wordcamp-2006/"><em>Milestones: The Story of WordPress</em></a> as the beginning of a tradition that has helped the project tell its own story.</p>\n\n\n\n<p>From the outset, the keynote carried a sense of momentum shaped by thousands of contributors, educators, students, and creators whose steady participation continues to define the open web. It was a reminder that WordPress is more than software. It is a community writing its future together.</p>\n\n\n\n<blockquote class="wp-block-quote is-layout-flow wp-block-quote-is-layout-flow">\n<p>What we have is more than code. It’s momentum, it’s culture, and it’s a system that lets people learn by doing and lead by showing up.  — <a href="https://profiles.wordpress.org/4thhubbard/">Mary Hubbard</a>, WordPress Executive Director</p>\n</blockquote>\n\n\n\n<p>Mary opened the evening by reflecting on her first full year as Executive Director, a year spent listening deeply and seeing firsthand how people across regions learn, contribute, and lead. Her remarks grounded the keynote in the lived reality of a community that grows because people invest in one another, teach openly, and build trust through contribution.</p>\n\n\n\n<blockquote class="wp-block-quote is-layout-flow wp-block-quote-is-layout-flow">\n<p>I’ve met people using WordPress to unlock new careers. I’ve met contributors who started a single translation or forum post and are now leading major pieces of the project. In LatAm, Europe, and the States, I’ve seen students get access to WordPress tools and start building faster than we could have ever imagined. I’ve watched communities build in public, resolve disagreements in the open, and collaborate across languages and time zones.</p>\n</blockquote>\n\n\n\n<p>That reflection offered a clear reminder of what makes WordPress resilient through change: a culture of showing up, learning by doing, and supporting others along the way. The project moves forward because people choose to participate in ways both large and small, strengthening the foundation that has carried WordPress for more than two decades.</p>\n\n\n\n<p>With that foundation in place, the keynote moved through a series of stories and demonstrations that highlighted where WordPress stands today and where it is headed next — from a historic live release of WordPress 6.9 to expanding global education pathways, emerging AI capabilities, and deeper collaboration across the entire ecosystem.</p>\n\n\n\n<h2 class="wp-block-heading">WordPress by the Numbers</h2>\n\n\n\n<p>Project Cofounder <a href="https://profiles.wordpress.org/matt/">Matt Mullenweg</a> began with a wide-angle view of the project’s growth. WordPress powers over 43% of the web, with 60.5% of the CMS market. Shopify, its nearest competitor, holds 6.8%. Among the top 1,000 websites, WordPress’s share climbed to 49.4%, up 2.3% from the previous year.</p>\n\n\n\n<figure class="wp-block-image size-large"><img data-recalc-dims="1" decoding="async" width="1024" height="576" src="https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-43.jpg?resize=1024%2C576&#038;ssl=1" alt="Globe graphic noting 43% of websites and 60.5% CMS market share" class="wp-image-19500" srcset="https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-43-scaled.jpg?resize=1024%2C576&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-43-scaled.jpg?resize=300%2C169&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-43-scaled.jpg?resize=768%2C432&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-43-scaled.jpg?resize=1536%2C864&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-43-scaled.jpg?resize=2048%2C1152&amp;ssl=1 2048w" sizes="(max-width: 1000px) 100vw, 1000px" /></figure>\n\n\n\n<p>Multilingual usage continued its strong rise. Over 56% of WordPress sites now run in languages other than English. Japan stood out, with WordPress powering 58.5% of all Japanese websites and 83% of the CMS market. Japanese became the second most-used language on WordPress at 5.82%. Spanish followed, then German, French, and Brazilian Portuguese.</p>\n\n\n\n<p>The plugin ecosystem saw explosive growth. The directory surpassed 60,000 plugins, and plugin downloads were on pace to reach 2.1 billion by year-end. Over 1,500 themes have been released this year as well.</p>\n\n\n\n<p>Contributors also hit new highs. The 6.8 release included 921 contributors, the largest group yet. WordPress 6.8 saw 79.5 million downloads, up 13%, and WordPress 6.9 included contributions from 230 first-time contributors and more than 340 enhancements and fixes.</p>\n\n\n\n<h2 class="wp-block-heading">A Release Moment to Remember</h2>\n\n\n\n<p>This year’s keynote delivered something WordPress had never attempted before: a live on-stage release of <a href="https://wordpress.org/download/releases/6-9/">WordPress 6.9</a>.</p>\n\n\n\n<figure class="wp-block-image size-large"><img data-recalc-dims="1" loading="lazy" decoding="async" width="1024" height="576" src="https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-gene.jpg?resize=1024%2C576&#038;ssl=1" alt="WordPress 6.9 Gene album cover art" class="wp-image-19511" srcset="https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-gene-scaled.jpg?resize=1024%2C576&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-gene-scaled.jpg?resize=300%2C169&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-gene-scaled.jpg?resize=768%2C432&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-gene-scaled.jpg?resize=1536%2C864&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-gene-scaled.jpg?resize=2048%2C1152&amp;ssl=1 2048w" sizes="auto, (max-width: 1000px) 100vw, 1000px" /></figure>\n\n\n\n<p>Mary set the moment up earlier in the program, calling WordPress 6.9 “fast, polished, and built for collaboration.” She explained that it reflected a year of intentional iteration, improved workflows, and deeper cross-team participation.&nbsp;</p>\n\n\n\n<p>Matt took the stage with some of the release leads, the release button in hand. The room counted down, and then WordPress 6.9 shipped live, instantly updating millions of sites around the world. It was both a celebration and a testament to the reliability and trust the WordPress community has built into its release processes. Shipping a major version of WordPress in real time, on stage, without drama, is something the early contributors could hardly have imagined.</p>\n\n\n\n<figure class="wp-block-image size-large"><img data-recalc-dims="1" loading="lazy" decoding="async" width="1024" height="576" src="https://i0.wp.com/wordpress.org/news/files/2025/12/release-leads.jpg?resize=1024%2C576&#038;ssl=1" alt="Photo of WordPress release leads pressing the button to release 6.9" class="wp-image-19457" srcset="https://i0.wp.com/wordpress.org/news/files/2025/12/release-leads-scaled.jpg?resize=1024%2C576&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/12/release-leads-scaled.jpg?resize=300%2C169&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/12/release-leads-scaled.jpg?resize=768%2C432&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/12/release-leads-scaled.jpg?resize=1536%2C864&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/12/release-leads-scaled.jpg?resize=2048%2C1152&amp;ssl=1 2048w" sizes="auto, (max-width: 1000px) 100vw, 1000px" /></figure>\n\n\n\n<p>That reflection connected back to WordPress’s origin story. Matt talked about discovering the <a href="https://en.wikipedia.org/wiki/WordPress#History">B2</a> forums, asking questions, and eventually reaching the point where he could answer someone else’s. That transition from learner to contributor remains at the heart of the project today. Two decades later, WordPress has grown from those early interactions into a platform that can ship a major release in front of the world, powered by thousands of contributors building together.</p>\n\n\n\n<h2 class="wp-block-heading">WordPress and the Future of AI</h2>\n\n\n\n<p>As the keynote shifted toward the future, Matt acknowledged what has become an essential truth of the moment: it would be impossible to talk about the next chapter of WordPress without talking about AI. He reminded the audience that in 2022, long before ChatGPT entered global conversation, he encouraged the community to “learn AI deeply.” The speed of change since then, he said, has exceeded every expectation, and WordPress has been preparing for it in ways both visible and behind the scenes.</p>\n\n\n\n<figure class="wp-block-image size-large"><img data-recalc-dims="1" loading="lazy" decoding="async" width="1024" height="576" src="https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-AI.jpg?resize=1024%2C576&#038;ssl=1" alt="Timeline of AI: 2022 ChatGPT launches, 2023 GPT-4 and Claude launches, 2024 Multimodel and video generation, 2025 AI everywhere" class="wp-image-19510" srcset="https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-AI-scaled.jpg?resize=1024%2C576&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-AI-scaled.jpg?resize=300%2C169&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-AI-scaled.jpg?resize=768%2C432&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-AI-scaled.jpg?resize=1536%2C864&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-AI-scaled.jpg?resize=2048%2C1152&amp;ssl=1 2048w" sizes="auto, (max-width: 1000px) 100vw, 1000px" /></figure>\n\n\n\n<p>Matt introduced one of the most important architectural developments of the year: the Abilities API and the MCP adapter. The Abilities API defines what WordPress can do in a structured way that AI systems can interpret, while the MCP adapter exposes those abilities through a shared protocol. This means AI agents — whether built by individuals, companies, or larger platforms — can understand and interact with WordPress safely and predictably. Instead of relying on one-off integrations or brittle interfaces, WordPress now participates in a broader ecosystem of tools that can query its capabilities and perform tasks using a standard, governed approach.</p>\n\n\n\n<p>Matt then highlighted how developers are already using AI in their everyday work through tools like Cursor, Claude Code, and next-generation CLIs. These tools can explore entire codebases, generate documentation, produce tests, refactor large components, and even coordinate sequences of WP-CLI commands. For many developers, they expand what a single person can accomplish in an afternoon. They don’t eliminate the need for human judgment — they amplify it.</p>\n\n\n\n<p>With that foundation laid, Matt turned the audience’s attention to <a href="https://telex.automattic.ai/">Telex</a>, the experimental environment designed to turn natural-language prompts into Gutenberg Blocks. Telex has already moved beyond experimentation and into real use. Matt showed examples from community creator Nick Hamze, who uses Telex to power micro-business tools that represent practical, revenue-generating workflows that previously required custom engineering.</p>\n\n\n\n<figure class="wp-block-video"><video height="2160" style="aspect-ratio: 3840 / 2160;" width="3840" controls src="https://wordpress.org/news/files/2025/12/Telex-demo-776.mp4"></video></figure>\n\n\n\n<p>Matt then widened the lens to show what companies across the ecosystem are building with AI. Hostinger’s Kodee can generate a complete WordPress site from a single description. Elementor AI demonstrated similarly rapid creation inside its own editor, producing full sections and layouts in seconds. WordPress.com showcased how its AI tools help users draft, rewrite, and refine content while keeping language aligned with the site’s voice. Yoast demonstrated how AI can support SEO workflows by generating structured suggestions and improving readability. Together, these examples illustrated that AI is not arriving in one place — it is arriving everywhere.</p>\n\n\n\n<p>Experimental browsers can navigate WP Admin autonomously, performing tasks such as clicking buttons, opening menus, changing settings, and performing multi-step tasks without requiring any custom plugins or APIs. This raised a key question that Matt encouraged the community to consider: Which AI capabilities should live inside WordPress itself, and which should remain external, operating through the browser or operating system?</p>\n\n\n\n<p>Matt closed the section by discussing WordPress-specific AI benchmarks and evaluation suites. These shared tests will measure how well AI systems understand and execute WordPress tasks, from enabling plugins to navigating WP Admin to modifying content and settings. The goal is to create a foundation where future AI tools behave predictably and responsibly across the entire ecosystem, giving creators confidence that intelligent tools understand the platform deeply.</p>\n\n\n\n<h2 class="wp-block-heading">A Global Community Growing Together</h2>\n\n\n\n<p>Mary then returned to the stage to celebrate the ecosystem that supports WordPress&#8217;s growth. Across continents, diverse groups of people have hosted WordPress events, training new contributors and welcoming newcomers into the project. WordCamp growth in 2025 reflected that: more than 81 WordCamps across 39 countries, powered by over 5,000 volunteers and attended by nearly 100,000 people, with sixteen more events still underway.</p>\n\n\n\n<figure class="wp-block-image size-large"><img data-recalc-dims="1" loading="lazy" decoding="async" width="1024" height="576" src="https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-wordcamps.jpg?resize=1024%2C576&#038;ssl=1" alt="" class="wp-image-19503" srcset="https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-wordcamps-scaled.jpg?resize=1024%2C576&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-wordcamps-scaled.jpg?resize=300%2C169&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-wordcamps-scaled.jpg?resize=768%2C432&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-wordcamps-scaled.jpg?resize=1536%2C864&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-wordcamps-scaled.jpg?resize=2048%2C1152&amp;ssl=1 2048w" sizes="auto, (max-width: 1000px) 100vw, 1000px" /></figure>\n\n\n\n<p>Education played a major role in this community expansion. Learn.WordPress.org served over 1.5 million learners this year, with clearer pathways into more structured programs like <a href="https://wordpress.org/education/campus-connect/">Campus Connect</a> and <a href="https://wordpress.org/education/credits/">WordPress Credits</a>. This bridging was deliberate. Many learners arrive through tutorials or workshops but need clearer guidance on how to deepen their skills. By reshaping navigation and improving wayfinding across WordPress.org, the project began closing that gap.</p>\n\n\n\n<p>She spotlighted <a href="https://make.wordpress.org/community/2025/09/29/wordpress-and-higher-education-an-alliance-that-transforms/">Costa Rica’s Universidad Fidélitas</a>, where WordPress moved beyond extracurricular interest into formal academic integration. Long before signing an agreement with the WordPress Foundation, their students were hosting WordCamp San José, forming student clubs, and treating WordPress as a crucial part of digital literacy and professional development.</p>\n\n\n\n<figure class="wp-block-image size-large"><img data-recalc-dims="1" loading="lazy" decoding="async" width="1024" height="576" src="https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-photo.jpg?resize=1024%2C576&#038;ssl=1" alt="" class="wp-image-19505" srcset="https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-photo-scaled.jpg?resize=1024%2C576&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-photo-scaled.jpg?resize=300%2C169&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-photo-scaled.jpg?resize=768%2C432&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-photo-scaled.jpg?resize=1536%2C864&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-photo-scaled.jpg?resize=2048%2C1152&amp;ssl=1 2048w" sizes="auto, (max-width: 1000px) 100vw, 1000px" /><figcaption class="wp-element-caption">Students of the WordPress Fidélitas Club</figcaption></figure>\n\n\n\n<p>Wapuu appeared across events as a familiar companion and a cultural thread running through contributor tools and community projects. Its presence was a reminder that creativity and playfulness are as essential to open source as documentation or code.</p>\n\n\n\n<figure class="wp-block-image size-large"><img data-recalc-dims="1" loading="lazy" decoding="async" width="1024" height="576" src="https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-wapuu.jpg?resize=1024%2C576&#038;ssl=1" alt="Various Wapuu artwork examples" class="wp-image-19506" srcset="https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-wapuu-scaled.jpg?resize=1024%2C576&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-wapuu-scaled.jpg?resize=300%2C169&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-wapuu-scaled.jpg?resize=768%2C432&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-wapuu-scaled.jpg?resize=1536%2C864&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-wapuu-scaled.jpg?resize=2048%2C1152&amp;ssl=1 2048w" sizes="auto, (max-width: 1000px) 100vw, 1000px" /></figure>\n\n\n\n<p>Matt highlighted the story of <a href="https://events.wordpress.org/managua/2025/wordpress-youth-day/">Youth Day in Managua, Nicaragua</a>. Seventy-five young people spent a full day building their first WordPress sites. Sessions were taught by teenagers, for teenagers. They learned to pick themes, customize layouts, create contact forms, and publish content. Contribution often starts with a simple moment of confidence, and those early sparks can shape entire careers.</p>\n\n\n\n<figure class="wp-block-video"><video height="2160" style="aspect-ratio: 3840 / 2160;" width="3840" controls src="https://wordpress.org/news/files/2025/12/wapu-513.mp4"></video></figure>\n\n\n\n<p>Together, these moments illustrated a project expanding not just in numbers, but in depth, diversity, and global reach. WordPress is growing because communities are finding their own ways to embrace it.</p>\n\n\n\n<h2 class="wp-block-heading">What’s New in WordPress 6.9</h2>\n\n\n\n<p>Joining virtually, WordPress Lead Architect, <a href="https://profiles.wordpress.org/matveb/">Matías Ventura</a>, shifted the keynote from vision to practice. Matías offered a detailed walkthrough of what makes WordPress 6.9 one of the most refined, collaborative, and forward-looking releases the project has shipped in years. He returned to the four familiar lenses of creation — writing, designing, building, and developing — and showed how each evolved in this release cycle.</p>\n\n\n\n<p>He began with notes in the Block Editor, one of the most anticipated features. Notes allow collaborators to comment directly on individual blocks in a post or page. When a note is selected, the surrounding content subtly fades, helping contributors stay focused on context. Because notes are built on WordPress’s native comment system, they integrate seamlessly with existing communication workflows, including email notifications. Matías highlighted that notes development exemplified collaboration at its best, with contributors from various companies working together to bring the feature to life.</p>\n\n\n\n<figure class="wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio"><div class="wp-block-embed__wrapper">\n<iframe loading="lazy" title="WordPress 6.9 Feature Demo" width="500" height="281" src="https://www.youtube.com/embed/vkYulcN0lbc?feature=oembed" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" referrerpolicy="strict-origin-when-cross-origin" allowfullscreen></iframe>\n</div></figure>\n\n\n\n<p>From there, he turned to refinements across the writing and design experience. Editor interactions feel smoother and more consistent. Patterns behave more predictably. Spacing and typography controls are clearer, more organized, and more intuitive. Together these capabilioties make the experience of writing and designing inside WordPress calmer, more reliable, and more empowering.</p>\n\n\n\n<p>Block bindings now provide a more intuitive, visual way to connect blocks to dynamic data sources. Users can switch or remove bindings with a single click, and developers can register additional sources to support custom workflows. This work lays the foundation for a future where dynamic data flows more naturally through blocks, enabling site creators to build richer interfaces without writing code.</p>\n\n\n\n<p>On the developer front, Matías focused on three foundational upgrades that represent major steps forward in how WordPress will evolve over the coming years.</p>\n\n\n\n<ul class="wp-block-list">\n<li>The first was the <strong>Abilities API</strong>, a unified registry that describes what WordPress can do — across PHP, REST endpoints, the command palette, and future AI-driven interactions.</li>\n\n\n\n<li>The <strong>HTML API</strong> introduces new ways of working with and modifying HTML server-side. The API ensures safer, more reliable handling, lowering the barrier for theme and block developers who work with dynamic or structured markup.</li>\n\n\n\n<li>The <strong>Interactivity API</strong> delivers smoother, faster interactions without requiring heavy JavaScript frameworks. Improved routing, better state management, and clearer conventions help developers create rich, modern interfaces without leaving the WordPress philosophy of simplicity and flexibility.</li>\n</ul>\n\n\n\n<p>After Matías wrapped his presentation, Matt stepped back in to highlight several developments that build on the foundations of 6.9 and strengthen the overall WordPress ecosystem. He pointed first to the <a href="https://wordpress.org/plugins/plugin-check/">Plugin Check Plugin</a>, a tool designed to help developers align with current WordPress standards and catch common issues early, making plugins more reliable for users and easier to maintain over time. Matt then spoke about ongoing progress in <a href="https://wordpress.org/data-liberation/">Data Liberation</a>, noting improvements to the <a href="https://wordpress.org/plugins/wordpress-importer/">WordPress importer</a> that make it easier for people to bring their content into WordPress without disruption or loss, an important step toward ensuring the open web remains portable and resilient. He also highlighted advances across the <a href="https://playground.wordpress.net/">Playground</a> ecosystem, including <a href="https://developer.wordpress.com/studio/">WordPress Studio</a>, the Playground CLI, and an expanding set of Blueprints. These allow developers and learners to spin up complete WordPress environments in seconds, test ideas, and experiment without servers or configuration. Matt closed this portion by emphasizing work on safer updates, which help WordPress avoid partial installs and ensure that updates complete smoothly even in less predictable hosting conditions, reinforcing WordPress’s commitment to stability as the platform continues to grow.</p>\n\n\n\n<p>Matt emphasized that WordPress 6.9 is not defined by any single headline feature, but by a broad spectrum of refinements across the entire experience. It is a release that deepens reliability, expands capability, and sets the stage for future innovation.</p>\n\n\n\n<h2 class="wp-block-heading">Insights from the AI Panel</h2>\n\n\n\n<p>The keynote transitioned into a live AI panel moderated by Mary Hubbard. The panel brought together four perspectives from across the ecosystem: <a href="https://profiles.wordpress.org/isotropic/">James LePage</a> (Automattic), <a href="https://profiles.wordpress.org/flixos90/">Felix Arntz</a> (Google), and <a href="https://profiles.wordpress.org/jeffpaul/">Jeff Paul</a> (Fueled, FKA 10up), and Matt Mullenweg. Their conversation touched on the philosophy, practice, and future of AI inside WordPress — not as a distant trend, but as an active part of the project’s evolution.</p>\n\n\n\n<p>A central theme was AI’s ability to amplify human creativity. James LePage put it plainly:</p>\n\n\n\n<blockquote class="wp-block-quote is-layout-flow wp-block-quote-is-layout-flow">\n<p>It’s not that we’re going to just add sparkle buttons everywhere. We’re going to do some crazy stuff here — things we’re going to build into the way you interact with creating content, with expressing yourself digitally. We want to give you more power, more control, and make you more effective at creating.</p>\n</blockquote>\n\n\n\n<p>Jeff Paul echoed this sentiment, emphasizing that AI should make developers more productive by handling repetitive work and freeing them to focus on higher-level decisions. Felix Arntz expanded the idea further, describing how Google sees AI as a way to make the web more accessible and intuitive, especially for new creators who may not have formal technical training.</p>\n\n\n\n<figure class="wp-block-image size-large"><img data-recalc-dims="1" loading="lazy" decoding="async" width="1024" height="572" src="https://i0.wp.com/wordpress.org/news/files/2025/12/panel.jpg?resize=1024%2C572&#038;ssl=1" alt="" class="wp-image-19462" srcset="https://i0.wp.com/wordpress.org/news/files/2025/12/panel-scaled.jpg?resize=1024%2C572&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/12/panel-scaled.jpg?resize=300%2C168&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/12/panel-scaled.jpg?resize=768%2C429&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/12/panel-scaled.jpg?resize=1536%2C858&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/12/panel-scaled.jpg?resize=2048%2C1144&amp;ssl=1 2048w" sizes="auto, (max-width: 1000px) 100vw, 1000px" /><figcaption class="wp-element-caption">From left to right: Mary Hubbard, Matt Mullenweg, Jeff Paul, Felix Arntz, James LePage</figcaption></figure>\n\n\n\n<p>Looking ahead, the panelists predicted deeper contextual integrations, AI-assisted debugging and scaffolding for developers, and workflows where agents can take on sequences of tasks while remaining directed by human decisions. They also highlighted the importance of standards, shared protocols, and privacy-focused design as essential components of WordPress’s long-term approach.</p>\n\n\n\n<blockquote class="wp-block-quote is-layout-flow wp-block-quote-is-layout-flow">\n<p>The next 20 years looks like WordPress remaining what it is today, which is the center of the open web.</p>\n</blockquote>\n\n\n\n<p>The panel closed on a forward-looking but steady note. AI is accelerating, but WordPress is designing its foundations with flexibility and values that endure. The tools may change, but the commitment to openness, agency, and creative freedom remains the compass.</p>\n\n\n\n<h2 class="wp-block-heading">Questions That Push Us Forward</h2>\n\n\n\n<p>Matt introduced the Q&amp;A as one of his favorite parts of State of the Word because it reveals what people are imagining, struggling with, or eager to build.</p>\n\n\n\n<figure class="wp-block-image size-large"><img data-recalc-dims="1" loading="lazy" decoding="async" width="1024" height="576" src="https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-QandA.jpg?resize=1024%2C576&#038;ssl=1" alt="Q&amp;A" class="wp-image-19512" srcset="https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-QandA-scaled.jpg?resize=1024%2C576&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-QandA-scaled.jpg?resize=300%2C169&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-QandA-scaled.jpg?resize=768%2C432&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-QandA-scaled.jpg?resize=1536%2C864&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-QandA-scaled.jpg?resize=2048%2C1152&amp;ssl=1 2048w" sizes="auto, (max-width: 1000px) 100vw, 1000px" /></figure>\n\n\n\n<p>The first question addressed the growing interconnectedness of today’s web. What happens, a participant asked, when a major provider like Cloudflare goes down? As tools and agents rely more heavily on external services, failures can cascade. Matt acknowledged that outages are increasingly visible, but also argued that each one strengthens the system.</p>\n\n\n\n<blockquote class="wp-block-quote is-layout-flow wp-block-quote-is-layout-flow">\n<p>&#8220;Every failure, every edge case, everything that you never imagined is just another opportunity to find that new edge case,” he said. Resilience is not avoidance of failure, but the ability to grow stronger after it.</p>\n</blockquote>\n\n\n\n<p>Another question focused on the longevity of web content. With platforms shutting down or links breaking over time, how can creators ensure their work endures? Matt pointed to the Internet Archive as one of the great stabilizers of the open web. He highlighted a <a href="https://wordpress.org/plugins/internet-archive-wayback-machine-link-fixer/">new plugin</a> that automatically scans posts and replaces dead links with archived versions, helping preserve the historical fabric of the web even as individual services come and go.</p>\n\n\n\n<p>The next question turned to real-time collaboration inside WordPress. A participant asked how co-editing fits into the future of WordPress and how these tools might help creators work more confidently. Matt talked about how collaboration tools can support people who are just starting their creative journeys — whether they are entrepreneurs, students, or first-time site builders. He described real-time editing as part of a broader vision of WordPress “just doing the work for you” in high-pressure or early-stage creative moments.</p>\n\n\n\n<p>The final question considered long-term decision-making. Matt noted that predicting what will change is difficult, but identifying what will remain the same is much easier. For WordPress, he said, the invariant is clear: people will always want agency, openness, and the ability to publish on their own terms. These values guide decisions not only in the present, but across decades of future evolution.</p>\n\n\n\n<h2 class="wp-block-heading">TBPN Podcast Appearance</h2>\n\n\n\n<figure class="wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio"><div class="wp-block-embed__wrapper">\n<iframe loading="lazy" title="&#x1f534; CODE RED &#x1f534;, Dell Donates Size, Bun Acquired, AWS CEO Joins, Tae Kim Tells All" width="500" height="281" src="https://www.youtube.com/embed/eBQh57HuJzk?start=10036&#038;feature=oembed" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" referrerpolicy="strict-origin-when-cross-origin" allowfullscreen></iframe>\n</div></figure>\n\n\n\n<p>After the Q&amp;A, the keynote shifted gears with a live crossover segment featuring TBPN (the Technology Business Programming Network), a tech-focused podcast. The segment introduced a lively, unscripted energy into the room.</p>\n\n\n\n<p>The hosts kicked things off by asking Matt what the “word of the year” should be. He chose “freedom”, connecting it directly to the core philosophy of open source. He described open source licenses as a kind of “bill of rights for software,” giving users inalienable rights that no company can revoke. In a world increasingly shaped by software platforms and digital ecosystems, these freedoms form the heart of what keeps the web open and accessible.</p>\n\n\n\n<p>Conversation then moved to <a href="https://www.beeper.com/">Beeper</a>, the multi-network messaging client. Asked whether Beeper aims to “tear down walled gardens,” Matt rejected that framing. Instead, he offered a more collaborative metaphor: bringing gardens together. Most people have friends and colleagues scattered across WhatsApp, Instagram, LinkedIn, Messenger, and SMS. Beeper doesn’t replace those apps — it brings messages together into a unified interface..</p>\n\n\n\n<p>The conversation eventually returned to publishing. Matt referenced the same principle he noted earlier: the importance of identifying what won’t change. For WordPress, he said, that means doubling down on freedom, agency, and the ability to publish without gatekeepers. Even as AI evolves, even as platforms shift, even as new tools emerge, these are the values that will guide the project forward.</p>\n\n\n\n<h2 class="wp-block-heading">Building the Web We Believe In</h2>\n\n\n\n<p>As the keynote drew to a close, Matt returned to a message that had threaded through every section of the evening. The future of WordPress is not arriving from outside forces — it is being crafted, questioned, tested, and expanded by the people who show up. Contributors, students, educators, community organizers, designers, developers, business owners, and first-time site builders all play a role in shaping the platform.</p>\n\n\n\n<p>He spoke about the opportunities ahead: new tools that expand what creators can build, collaborative features that make teamwork feel natural, and AI systems that enhance creativity rather than diminish it. Across continents, generations, and skill levels, people are discovering WordPress as a path to learning, empowerment, and expression.</p>\n\n\n\n<p>The values that brought the project this far remain the ones that will carry it forward: freedom, participation, learning, and community. These aren’t abstract principles. They are lived every day in the decisions contributors make, the ideas they pursue, and the care they bring to the work.</p>\n\n\n\n<h3 class="wp-block-heading">Future Events</h3>\n\n\n\n<p>If you’re feeling inspired to revisit past moments from the project’s annual address, the <a href="https://www.youtube.com/playlist?list=PL1pJFUVKQ7ES1piZxljCvMTJCYpVBnwYU">State of the Word YouTube playlist</a> offers a look back at years of community milestones and product progress. The excitement continues into 2026, with major WordPress events already on the horizon: <a href="https://asia.wordcamp.org/2026/">WordCamp Asia</a> in Mumbai, India,<a href="https://europe.wordcamp.org/2026/">WordCamp Europe</a> in Kraków, Poland, and <a href="https://us.wordcamp.org/2026/">WordCamp US</a> in Phoenix. We hope to see you there as the community continues building what comes next.</p>\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:30:"com-wordpress:feed-additions:1";a:1:{s:7:"post-id";a:1:{i:0;a:5:{s:4:"data";s:5:"19447";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:2;a:6:{s:4:"data";s:66:"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n\n					\n										\n					\n		\n		\n			";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:4:{s:0:"";a:6:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:24:"WordPress 6.9 “Gene”";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:40:"https://wordpress.org/news/2025/12/gene/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Tue, 02 Dec 2025 20:12:21 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:4:{i:0;a:5:{s:4:"data";s:7:"General";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:1;a:5:{s:4:"data";s:8:"Releases";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:2;a:5:{s:4:"data";s:3:"6.9";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:3;a:5:{s:4:"data";s:8:"releases";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:35:"https://wordpress.org/news/?p=19398";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:495:"WordPress 6.9, code-named "Gene," brings major upgrades to how teams collaborate and create. The Notes feature introduces block-level commenting to streamline reviewing and polishing content, navigating across the entire dashboard with the Command Palette is now faster for power users, and the new Abilities API provides a standardized way to open the door for AI-powered and automated workflows. Combined with all the performance and accessibility improvements, 6.9 is one to write home about.";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:14:"Matt Mullenweg";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:79691:"\n<figure class="wp-block-image size-large"><img data-recalc-dims="1" loading="lazy" decoding="async" width="1024" height="535" src="https://i0.wp.com/wordpress.org/news/files/2025/12/Release-Edition-Featured-Image-6.9.png?resize=1024%2C535&#038;ssl=1" alt="WordPress 6.9 Release Edition Featured Image" class="wp-image-19404" srcset="https://i0.wp.com/wordpress.org/news/files/2025/12/Release-Edition-Featured-Image-6.9-scaled.png?resize=1024%2C535&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/12/Release-Edition-Featured-Image-6.9-scaled.png?resize=300%2C157&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/12/Release-Edition-Featured-Image-6.9-scaled.png?resize=768%2C401&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/12/Release-Edition-Featured-Image-6.9-scaled.png?resize=1536%2C802&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/12/Release-Edition-Featured-Image-6.9-scaled.png?resize=2048%2C1070&amp;ssl=1 2048w" sizes="auto, (max-width: 1000px) 100vw, 1000px" /></figure>\n\n\n\n<p>Each WordPress release celebrates an artist who has made an indelible mark on the world of music. WordPress 6.9, code-named “Gene,” honors the American Jazz pianist Gene Harris.&nbsp;</p>\n\n\n\n<p>A piano veteran, self taught at the age of six, Harris infused mainstream jazz with elements of soul, blues, and gospel, creating a warm, signature sound that is both elegant and iconic. Harris’ bluesy jazz lived at the intersection of worlds, weaving a rich landscape of texture and mood, with a thread of soulfulness that ignited listeners.</p>\n\n\n\n<h2 class="wp-block-heading">Welcome to WordPress 6.9</h2>\n\n\n\n<p>WordPress 6.9 brings major upgrades to how teams collaborate and create. The new Notes feature introduces block-level commenting when writing posts and pages that streamlines reviews, while the expanded Command Palette makes it faster for power users to navigate and operate across the entire dashboard. The new Abilities API provides a standardized, machine-readable permissions system that opens the door for next generation AI-powered and automated workflows. This release also delivers notable performance improvements for faster page loads and adds several practical new blocks alongside a more visual drag and drop to help creators build richer, more dynamic content.</p>\n\n\n\n<p><a href="https://wordpress.org/wordpress-6.9.zip">Download WordPress 6.9 &#8220;Gene&#8221;</a></p>\n\n\n\n<h2 class="wp-block-heading">Introducing Notes: Seamless, Block-Level Collaboration</h2>\n\n\n\n<p><strong>Collaborate Smarter</strong> : Leave Feedback Right Where You&#8217;re Working</p>\n\n\n\n<p>With notes attached directly to blocks in the post editor, your team can stay aligned, track changes, and turn feedback into action all in one place. Whether you&#8217;re working on copy or refining design in your posts or pages, collaboration happens seamlessly on the canvas itself.</p>\n\n\n\n<figure class="wp-block-image size-full"><img data-recalc-dims="1" loading="lazy" decoding="async" width="1360" height="840" src="https://i0.wp.com/wordpress.org/news/files/2025/12/post-notes.png?resize=1360%2C840&#038;ssl=1" alt="View of people interacting with notes in a post." class="wp-image-19428" srcset="https://i0.wp.com/wordpress.org/news/files/2025/12/post-notes.png?w=1360&amp;ssl=1 1360w, https://i0.wp.com/wordpress.org/news/files/2025/12/post-notes.png?resize=300%2C185&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/12/post-notes.png?resize=1024%2C632&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/12/post-notes.png?resize=768%2C474&amp;ssl=1 768w" sizes="auto, (max-width: 1000px) 100vw, 1000px" /></figure>\n\n\n\n<h2 class="wp-block-heading">Command Palette Throughout the Dashboard</h2>\n\n\n\n<p><strong>Your tools are always at hand.</strong></p>\n\n\n\n<p>Access the Command Palette from any part of the dashboard, whether you&#8217;re writing your latest post, deep in design in the Site Editor, or browsing your plugins. Everything you need, just a few keystrokes away.</p>\n\n\n\n<figure class="wp-block-image size-full"><img data-recalc-dims="1" loading="lazy" decoding="async" width="1360" height="840" src="https://i0.wp.com/wordpress.org/news/files/2025/12/post-command-palette.png?resize=1360%2C840&#038;ssl=1" alt="Command palette showing the ability to navigate across different parts of the site, including templates, Settings, and all posts." class="wp-image-19430" srcset="https://i0.wp.com/wordpress.org/news/files/2025/12/post-command-palette.png?w=1360&amp;ssl=1 1360w, https://i0.wp.com/wordpress.org/news/files/2025/12/post-command-palette.png?resize=300%2C185&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/12/post-command-palette.png?resize=1024%2C632&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/12/post-command-palette.png?resize=768%2C474&amp;ssl=1 768w" sizes="auto, (max-width: 1000px) 100vw, 1000px" /></figure>\n\n\n\n<h2 class="wp-block-heading">Fit text to container</h2>\n\n\n\n<p><strong>Content that adapts.</strong></p>\n\n\n\n<p>There&#8217;s a new typography option for text-based blocks that&#8217;s been added to the Paragraph and Heading blocks. This new option automatically adjusts font size to fill its container perfectly, making it ideal for banners, callouts, and standout moments in your design.</p>\n\n\n\n<figure class="wp-block-image size-full"><img data-recalc-dims="1" loading="lazy" decoding="async" width="1360" height="840" src="https://i0.wp.com/wordpress.org/news/files/2025/12/post-fit-text.png?resize=1360%2C840&#038;ssl=1" alt="&quot;Novem&quot; text selected and stretching across the interface." class="wp-image-19431" srcset="https://i0.wp.com/wordpress.org/news/files/2025/12/post-fit-text.png?w=1360&amp;ssl=1 1360w, https://i0.wp.com/wordpress.org/news/files/2025/12/post-fit-text.png?resize=300%2C185&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/12/post-fit-text.png?resize=1024%2C632&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/12/post-fit-text.png?resize=768%2C474&amp;ssl=1 768w" sizes="auto, (max-width: 1000px) 100vw, 1000px" /></figure>\n\n\n\n<h2 class="wp-block-heading">The Abilities API</h2>\n\n\n\n<p><strong>Unlocking the next generation of site interactions.</strong></p>\n\n\n\n<p>WordPress 6.9 lays the groundwork for the future of automation with the unified Abilities API. By creating a standardized registry for site functionality, developers can now register, validate, and execute actions consistently across any context—from PHP and REST endpoints to AI agents—paving the way for smarter, more connected WordPress experiences.</p>\n\n\n\n<figure class="wp-block-image size-large"><img data-recalc-dims="1" loading="lazy" decoding="async" width="1024" height="632" src="https://i0.wp.com/wordpress.org/news/files/2025/12/abilities-api.png?resize=1024%2C632&#038;ssl=1" alt="Abstract view of circles around a plugin icon with sparkles, indicating AI functionality." class="wp-image-19432" srcset="https://i0.wp.com/wordpress.org/news/files/2025/12/abilities-api.png?resize=1024%2C632&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/12/abilities-api.png?resize=300%2C185&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/12/abilities-api.png?resize=768%2C474&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/12/abilities-api.png?w=1360&amp;ssl=1 1360w" sizes="auto, (max-width: 1000px) 100vw, 1000px" /></figure>\n\n\n\n<h2 class="wp-block-heading">Accessibility Improvements</h2>\n\n\n\n<p>More than 30 accessibility fixes sharpen the core WordPress experience. These updates improve screen reader announcements, hide unnecessary CSS-generated content from assistive tech, fix cursor placement issues, and make sure typing focus stays put even when users click an autocomplete suggestion.</p>\n\n\n\n<h2 class="wp-block-heading">Performance enhancements</h2>\n\n\n\n<p>WordPress 6.9 delivers significant frontend performance enhancements, optimizing the site loading experience for visitors. 6.9 boasts an improved LCP (Largest Contentful Paint) through on-demand block styles for classic themes, minifying block theme styles, and increasing the limit for inline styles &#8211; removing blockages to page rendering and clearing the rendering path by deprioritizing non-critical scripts. This release comes with many more performance boosts, including optimized database queries, refined caching, improved spawning of WP Cron, and a new template enhancement output buffer that opens the door for more future optimizations.</p>\n\n\n\n<h3 class="wp-block-heading">And much more</h3>\n\n\n\n<p>For a comprehensive overview of all the new features and enhancements in WordPress 6.9, please visit the feature-showcase website.</p>\n\n\n\n<p><a href="https://wordpress.org/download/releases/6-9">Check out What&#8217;s New</a></p>\n\n\n\n<h2 class="wp-block-heading">Learn more about WordPress 6.9</h2>\n\n\n\n<p><a href="https://learn.wordpress.org/">Learn WordPress</a> is a free resource for new and experienced WordPress users. Learn is stocked with how-to videos on using various features in WordPress, <a href="https://learn.wordpress.org/social-learning/">interactive workshops</a> for exploring topics in-depth, and lesson plans for diving deep into specific areas of WordPress.</p>\n\n\n\n<p>Read the <a href="https://wordpress.org/documentation/wordpress-version/version-6.9">WordPress 6.9 Release Notes</a> for information on installation, enhancements, fixed issues, release contributors, learning resources, and the list of file changes.</p>\n\n\n\n<p>Explore the <a href="https://make.wordpress.org/core/wordpress-6-9-field-guide/">WordPress 6.9 Field Guide</a>. Learn about the changes in this release with detailed developer notes to help you build with WordPress.</p>\n\n\n\n<h2 class="wp-block-heading">The 6.9 release squad</h2>\n\n\n\n<p>Every release comes to you from a dedicated team of enthusiastic contributors who help keep things on track and moving smoothly. The team that has led 6.9 is a cross-functional group of contributors who are always ready to champion ideas, remove blockers, and resolve issues.</p>\n\n\n\n<ul class="wp-block-list">\n<li>Release Lead: <a href="https://profiles.wordpress.org/matt/">Matt Mullenweg</a></li>\n\n\n\n<li>Release Coordination: <a href="https://profiles.wordpress.org/akshayar/">Akshaya Rane</a>, <a href="https://profiles.wordpress.org/amykamala/">Amy Kamala</a></li>\n\n\n\n<li>Tech Leads: <a href="https://profiles.wordpress.org/davidbaumwald/">David Baumwald</a>, <a href="https://profiles.wordpress.org/ellatrix/">Ella van Durpe</a>, <a href="https://profiles.wordpress.org/priethor/">Héctor Prieto</a></li>\n\n\n\n<li>Design Lead: <a href="https://profiles.wordpress.org/fcoveram/">Francisco Vera</a></li>\n\n\n\n<li>Triage Leads: <a href="https://profiles.wordpress.org/wildworks/">Aki Hamano</a>, <a href="https://profiles.wordpress.org/welcher/">Ryan Welcher</a></li>\n\n\n\n<li>Test Leads: <a href="https://profiles.wordpress.org/psykro/">Jonathan Bossenger</a>, <a href="https://profiles.wordpress.org/krupajnanda/">Krupa Nanda</a></li>\n</ul>\n\n\n\n<h2 class="wp-block-heading">Thank you, contributors</h2>\n\n\n\n<p>The mission of WordPress is to <a href="https://wordpress.org/about/">democratize publishing</a> and embody the <a href="https://opensource.org/osd-annotated">freedoms that come with open source</a>. A global and diverse community of people collaborating to strengthen the software supports this effort.</p>\n\n\n\n<p>WordPress 6.9 reflects the tireless efforts and passion of more than 900+ contributors in countries all over the world. This release also welcomed over 279 first-time contributors!</p>\n\n\n\n<p>Their collaboration delivered more than 340 enhancements and fixes, ensuring a stable release for all &#8211; a testament to the power and capability of the WordPress open source community.</p>\n\n\n\n<p class="has-small-font-size"><a href="https://profiles.wordpress.org/o-o/">2046</a> · <a href="https://profiles.wordpress.org/aakashverma1/">Aakash Verma</a> · <a href="https://profiles.wordpress.org/jorbin/">Aaron Jorbin</a> · <a href="https://profiles.wordpress.org/aaronrobertshaw/">Aaron Robertshaw</a> · <a href="https://profiles.wordpress.org/aarti1318/">Aarti Chauhan</a> · <a href="https://profiles.wordpress.org/thehercules/">Aashish Sharma</a> · <a href="https://profiles.wordpress.org/aatospaja/">aatospaja</a> · <a href="https://profiles.wordpress.org/abduremon/">Abdur Rahman Emon</a> · <a href="https://profiles.wordpress.org/hurayraiit/">Abu Hurayra</a> · <a href="https://profiles.wordpress.org/kawauso/">Adam Harley (Kawauso)</a> · <a href="https://profiles.wordpress.org/adamsilverstein/">Adam Silverstein</a> · <a href="https://profiles.wordpress.org/zieladam/">Adam Zieliński</a> · <a href="https://profiles.wordpress.org/adityab98/">Aditya Bansode</a> · <a href="https://profiles.wordpress.org/b1ink0/">Aditya Dhade</a> · <a href="https://profiles.wordpress.org/adityashah2411/">aditya shah</a> · <a href="https://profiles.wordpress.org/iamadisingh/">Aditya Singh</a> · <a href="https://profiles.wordpress.org/aduth/">aduth</a> · <a href="https://profiles.wordpress.org/agulbra/">agulbra</a> · <a href="https://profiles.wordpress.org/elazzabi/">Ahmed</a> · <a href="https://profiles.wordpress.org/chaion07/">Ahmed Kabir Chaion</a> · <a href="https://profiles.wordpress.org/ajaxstardust/">ajaxStardust</a> · <a href="https://profiles.wordpress.org/ajitbohra/">Ajit Bohra</a> · <a href="https://profiles.wordpress.org/akanshusingh/">Akanshu Singh</a> · <a href="https://profiles.wordpress.org/akeda/">Akeda Bagus</a> · <a href="https://profiles.wordpress.org/wildworks/">Aki Hamano</a> · <a href="https://profiles.wordpress.org/atachibana/">Akira Tachibana</a> · <a href="https://profiles.wordpress.org/wpfy/">Akramul Hasan</a> · <a href="https://profiles.wordpress.org/akshat2802/">Akshat Kakkad</a> · <a href="https://profiles.wordpress.org/akshaydhere/">Akshay Dhere</a> · <a href="https://profiles.wordpress.org/akshayar/">Akshaya Rane</a> · <a href="https://profiles.wordpress.org/aljullu/">Albert Juh&#233; Lluveras</a> · <a href="https://profiles.wordpress.org/alejandrogonzalvo/">alejandrogonzalvo</a> · <a href="https://profiles.wordpress.org/alexcu21/">Alex Cuadra</a> · <a href="https://profiles.wordpress.org/ajlende/">Alex Lende</a> · <a href="https://profiles.wordpress.org/alexclassroom/">Alex Lion (阿力獅)</a> · <a href="https://profiles.wordpress.org/alexstine/">Alex Stine</a> · <a href="https://profiles.wordpress.org/alexandrebuffet/">Alexandre Buffet</a> · <a href="https://profiles.wordpress.org/alexus450/">Alexei Samarschi</a> · <a href="https://profiles.wordpress.org/alexius08/">Alexis Pandaan</a> · <a href="https://profiles.wordpress.org/alordiel/">alordiel</a> · <a href="https://profiles.wordpress.org/mrfoxtalbot/">Alvaro G&#243;mez</a> · <a href="https://profiles.wordpress.org/alh0319/">Amber Hinds</a> · <a href="https://profiles.wordpress.org/amin7/">Amin</a> · <a href="https://profiles.wordpress.org/theaminuldev/">Aminul Islam</a> · <a href="https://profiles.wordpress.org/aialvi/">Aminul Islam Alvi</a> · <a href="https://profiles.wordpress.org/amitbhosale/">Amit Bhosale</a> · <a href="https://profiles.wordpress.org/amykamala/">Amy Kamala</a> · <a href="https://profiles.wordpress.org/anatolbroder/">Anatol Broder</a> · <a href="https://profiles.wordpress.org/anlino/">Anders Nor&#233;n</a> · <a href="https://profiles.wordpress.org/afercia/">Andrea Fercia</a> · <a href="https://profiles.wordpress.org/awetz583/">Andrea Roenning</a> · <a href="https://profiles.wordpress.org/andraganescu/">Andrei Draganescu</a> · <a href="https://profiles.wordpress.org/andrewhoyer/">Andrew Hoyer</a> · <a href="https://profiles.wordpress.org/nacin/">Andrew Nacin</a> · <a href="https://profiles.wordpress.org/azaozz/">Andrew Ozz</a> · <a href="https://profiles.wordpress.org/andrewserong/">Andrew Serong</a> · <a href="https://profiles.wordpress.org/oandregal/">André Maneiro</a> · <a href="https://profiles.wordpress.org/afragen/">Andy Fragen</a> · <a href="https://profiles.wordpress.org/mymothersdaughter/">Anita C</a> · <a href="https://profiles.wordpress.org/ankit-k-gupta/">Ankit K Gupta</a> · <a href="https://profiles.wordpress.org/ankitkumarshah/">Ankit Kumar Shah</a> · <a href="https://profiles.wordpress.org/ankitmaru/">Ankit Panchal</a> · <a href="https://profiles.wordpress.org/annezazu/">Anne McCarthy</a> · <a href="https://profiles.wordpress.org/annebovelett/">Anne-Mieke Bovelett</a> · <a href="https://profiles.wordpress.org/antonvlasenko/">Anton Vlasenko</a> · <a href="https://profiles.wordpress.org/antoniosejas/">Antonio Sejas</a> · <a href="https://profiles.wordpress.org/anujrathore24/">Anuj Singh</a> · <a href="https://profiles.wordpress.org/anveshika/">Anveshika Srivastava</a> · <a href="https://profiles.wordpress.org/apmeyer/">apmeyer</a> · <a href="https://profiles.wordpress.org/aristath/">Ari Stathopoulos</a> · <a href="https://profiles.wordpress.org/fliespl/">Arkadiusz Rzadkowolski</a> · <a href="https://profiles.wordpress.org/armandovias/">Armando</a> · <a href="https://profiles.wordpress.org/artemiosans/">Artemio Morales</a> · <a href="https://profiles.wordpress.org/arthur791004/">Arthur Chu</a> · <a href="https://profiles.wordpress.org/artpi/">Artur Piszek</a> · <a href="https://profiles.wordpress.org/artz91/">ArtZ91</a> · <a href="https://profiles.wordpress.org/asafm7/">asafm7</a> · <a href="https://profiles.wordpress.org/asdofindia/">asdofindia</a> · <a href="https://profiles.wordpress.org/ashfame/">Ashish Kumar (Ashfame)</a> · <a href="https://profiles.wordpress.org/akashdev/">Ashraful Haque Akash</a> · <a href="https://profiles.wordpress.org/askapache/">askapache</a> · <a href="https://profiles.wordpress.org/aslamdoctor/">Aslam Doctor</a> · <a href="https://profiles.wordpress.org/aurooba/">Aurooba Ahmed</a> · <a href="https://profiles.wordpress.org/aut0poietic/">aut0poietic</a> · <a href="https://profiles.wordpress.org/aksl95/">Axel DUCORON</a> · <a href="https://profiles.wordpress.org/ayeshrajans/">Ayesh Karunaratne</a> · <a href="https://profiles.wordpress.org/azharderaiya/">Azhar Deraiya</a> · <a href="https://profiles.wordpress.org/beryldlg/">B&#233;ryl de La Grandi&#232;re</a> · <a href="https://profiles.wordpress.org/bartnv/">bartnv</a> · <a href="https://profiles.wordpress.org/bchecketts/">bchecketts</a> · <a href="https://profiles.wordpress.org/beee/">Beee</a> · <a href="https://profiles.wordpress.org/scruffian/">Ben Dwyer</a> · <a href="https://profiles.wordpress.org/benazeer/">Benazeer</a> · <a href="https://profiles.wordpress.org/rainbowgeek/">Benjamin Denis</a> · <a href="https://profiles.wordpress.org/benjamin_zekavica/">Benjamin Zekavica</a> · <a href="https://profiles.wordpress.org/bvl/">Benny</a> · <a href="https://profiles.wordpress.org/benoitchantre/">Benoit Chantre</a> · <a href="https://profiles.wordpress.org/kau-boy/">Bernhard Kau</a> · <a href="https://profiles.wordpress.org/bernhard reiter/">Bernhard Reiter</a> · <a href="https://profiles.wordpress.org/bernhard-reiter/">Bernie Reiter</a> · <a href="https://profiles.wordpress.org/bgermann/">bgermann</a> · <a href="https://profiles.wordpress.org/bhattaganesh/">bhattaganesh</a> · <a href="https://profiles.wordpress.org/bhaveshdesai/">Bhavesh Desai</a> · <a href="https://profiles.wordpress.org/bidbmak/">BiDbMAK</a> · <a href="https://profiles.wordpress.org/mbigul/">Bigul Malayi</a> · <a href="https://profiles.wordpress.org/birgire/">Birgir Erlendsson (birgire)</a> · <a href="https://profiles.wordpress.org/bph/">Birgit Pauli-Haack</a> · <a href="https://profiles.wordpress.org/rainynewt/">Bishal Shrestha</a> · <a href="https://profiles.wordpress.org/bobbyleenoblestudios/">bobbyleenoblestudios</a> · <a href="https://profiles.wordpress.org/bogdanungureanu/">BogdanUngureanu</a> · <a href="https://profiles.wordpress.org/gitlost/">bonger</a> · <a href="https://profiles.wordpress.org/bor0/">Boro Sitnikovski</a> · <a href="https://profiles.wordpress.org/burlesonbrad/">Brad Griffin</a> · <a href="https://profiles.wordpress.org/bradley2083/">brad hogan</a> · <a href="https://profiles.wordpress.org/bjorsch/">Brad Jorsch</a> · <a href="https://profiles.wordpress.org/bradshawtm/">bradshawtm</a> · <a href="https://profiles.wordpress.org/bhubbard/">Brandon Hubbard</a> · <a href="https://profiles.wordpress.org/kraftbj/">Brandon Kraft</a> · <a href="https://profiles.wordpress.org/heybran/">Brandon Zhang</a> · <a href="https://profiles.wordpress.org/bgoewert/">Brennan Goewert</a> · <a href="https://profiles.wordpress.org/brhodes/">brhodes</a> · <a href="https://profiles.wordpress.org/ironprogrammer/">Brian Alexander</a> · <a href="https://profiles.wordpress.org/bacoords/">Brian Coords</a> · <a href="https://profiles.wordpress.org/bgardner/">Brian Gardner</a> · <a href="https://profiles.wordpress.org/masteradhoc/">Brian Haas</a> · <a href="https://profiles.wordpress.org/brumack/">brumack</a> · <a href="https://profiles.wordpress.org/bschneidewind/">Bryan Schneidewind</a> · <a href="https://profiles.wordpress.org/bshuchter/">bshuchter</a> · <a href="https://profiles.wordpress.org/burnuser/">burnuser</a> · <a href="https://profiles.wordpress.org/byteninjaa0/">byteninjaa0</a> · <a href="https://profiles.wordpress.org/cedche99/">C&#233;dric Chevillard</a> · <a href="https://profiles.wordpress.org/callumbw95/">Callum Bridgford-Whittick</a> · <a href="https://profiles.wordpress.org/snicco/">Calvin Alkan</a> · <a href="https://profiles.wordpress.org/karl94/">Carlo Cannas</a> · <a href="https://profiles.wordpress.org/cbravobernal/">Carlos Bravo</a> · <a href="https://profiles.wordpress.org/carlosgprim/">Carlos G. P.</a> · <a href="https://profiles.wordpress.org/carlsteffen/">CarlSteffen</a> · <a href="https://profiles.wordpress.org/poena/">Carolina Nymark</a> · <a href="https://profiles.wordpress.org/corazondejaguar/">Carolina Romo</a> · <a href="https://profiles.wordpress.org/ciobanucatalin/">Catalin Ciobanu</a> · <a href="https://profiles.wordpress.org/catgofire/">catgofire</a> · <a href="https://profiles.wordpress.org/cbirdsong/">cbirdsong</a> · <a href="https://profiles.wordpress.org/ccharel/">ccharel</a> · <a href="https://profiles.wordpress.org/cbutlerjr/">Chad Butler</a> · <a href="https://profiles.wordpress.org/shireling/">Chad Chadbourne</a> · <a href="https://profiles.wordpress.org/cherrygot/">Chakrapani Gautam</a> · <a href="https://profiles.wordpress.org/chihsuan/">Chi-Hsuan Huang</a> · <a href="https://profiles.wordpress.org/chillifish/">Chillifish</a> · <a href="https://profiles.wordpress.org/chloed/">ChloeD</a> · <a href="https://profiles.wordpress.org/chouby/">Chouby</a> · <a href="https://profiles.wordpress.org/czarate/">Chris Zarate</a> · <a href="https://profiles.wordpress.org/chriscct7/">chriscct7</a> · <a href="https://profiles.wordpress.org/chrisdotdotdot/">chrisdotdotdot</a> · <a href="https://profiles.wordpress.org/chrismattix/">chrismattix</a> · <a href="https://profiles.wordpress.org/christinecooper/">christinecooper</a> · <a href="https://profiles.wordpress.org/apermo/">Christoph Daum</a> · <a href="https://profiles.wordpress.org/nyiriland/">Christy Nyiri</a> · <a href="https://profiles.wordpress.org/cikrimcin/">cikrimcin</a> · <a href="https://profiles.wordpress.org/butterflymedia/">Ciprian Popescu</a> · <a href="https://profiles.wordpress.org/chrisvendiadvertisingcom/">cjhaas</a> · <a href="https://profiles.wordpress.org/ckoerner/">ckoerner</a> · <a href="https://profiles.wordpress.org/claimableperch/">claimableperch</a> · <a href="https://profiles.wordpress.org/codeamp/">Code Amp</a> · <a href="https://profiles.wordpress.org/codebuddy/">codebuddy</a> · <a href="https://profiles.wordpress.org/coleatkinson1/">coleatkinson1</a> · <a href="https://profiles.wordpress.org/costdev/">Colin Stewart</a> · <a href="https://profiles.wordpress.org/colind/">ColinD</a> · <a href="https://profiles.wordpress.org/ogrecooper/">Cooper Dalrymple</a> · <a href="https://profiles.wordpress.org/coralietixeront/">Coralie Tixeront</a> · <a href="https://profiles.wordpress.org/salzano/">Corey Salzano</a> · <a href="https://profiles.wordpress.org/coreyw/">Corey Worrell</a> · <a href="https://profiles.wordpress.org/cornwell/">Cornwell</a> · <a href="https://profiles.wordpress.org/cr0ybot/">Cory Hughart</a> · <a href="https://profiles.wordpress.org/courane01/">Courtney Robertson</a> · <a href="https://profiles.wordpress.org/cucocreative/">cucocreative</a> · <a href="https://profiles.wordpress.org/cwhitmore/">Cullen Whitmore</a> · <a href="https://profiles.wordpress.org/cyrille37/">Cyrille37</a> · <a href="https://profiles.wordpress.org/daanvandenbergh/">Daan van den Bergh</a> · <a href="https://profiles.wordpress.org/acketon/">Dakota Chichester</a> · <a href="https://profiles.wordpress.org/damchtlv/">damchtlv</a> · <a href="https://profiles.wordpress.org/damir-webthemer/">Damir</a> · <a href="https://profiles.wordpress.org/colorful-tones/">Damon Cook</a> · <a href="https://profiles.wordpress.org/dancameron/">Dan Cameron</a> · <a href="https://profiles.wordpress.org/danielpw/">Dan Waldschmidt</a> · <a href="https://profiles.wordpress.org/danielbachhuber/">Daniel Bachhuber</a> · <a href="https://profiles.wordpress.org/danieliser/">Daniel Iser</a> · <a href="https://profiles.wordpress.org/talldanwp/">Daniel Richards</a> · <a href="https://profiles.wordpress.org/mte90/">Daniele Scasciafratte</a> · <a href="https://profiles.wordpress.org/daniellacatus/">daniellacatus</a> · <a href="https://profiles.wordpress.org/danielmorell/">danielmorell</a> · <a href="https://profiles.wordpress.org/dscqbus/">Danny Schmarsel</a> · <a href="https://profiles.wordpress.org/dannyreaktiv/">dannyreaktiv</a> · <a href="https://profiles.wordpress.org/nerrad/">Darren Ethier (nerrad)</a> · <a href="https://profiles.wordpress.org/darshitrajyaguru97/">Darshit Rajyaguru</a> · <a href="https://profiles.wordpress.org/dryanpress/">Dave Ryan</a> · <a href="https://profiles.wordpress.org/daveguitaruno/">daveguitaruno</a> · <a href="https://profiles.wordpress.org/davilera/">David Aguilera</a> · <a href="https://profiles.wordpress.org/darerodz/">David Arenas</a> · <a href="https://profiles.wordpress.org/dartiss/">David Artiss</a> · <a href="https://profiles.wordpress.org/davidbaumwald/">David Baumwald</a> · <a href="https://profiles.wordpress.org/dpcalhoun/">David Calhoun</a> · <a href="https://profiles.wordpress.org/dlh/">David Herrera</a> · <a href="https://profiles.wordpress.org/justlevine/">David Levine</a> · <a href="https://profiles.wordpress.org/davidperez/">David Perez</a> · <a href="https://profiles.wordpress.org/djivad/">David Riviera</a> · <a href="https://profiles.wordpress.org/get_dave/">David Smith</a> · <a href="https://profiles.wordpress.org/davidb/">DavidB</a> · <a href="https://profiles.wordpress.org/dawidadach/">dawidadach</a> · <a href="https://profiles.wordpress.org/dsas/">Dean Sas</a> · <a href="https://profiles.wordpress.org/dkarfa/">Debabrata Karfa</a> · <a href="https://profiles.wordpress.org/debarghyabanerjee/">DEBARGHYA BANERJEE</a> · <a href="https://profiles.wordpress.org/denis-de-bernardy/">Denis de Bernardy</a> · <a href="https://profiles.wordpress.org/dingo_d/">Denis Žoljom</a> · <a href="https://profiles.wordpress.org/realloc/">Dennis Ploetner</a> · <a href="https://profiles.wordpress.org/dmsnell/">Dennis Snell</a> · <a href="https://profiles.wordpress.org/dennysdionigi/">Dennys Dionigi</a> · <a href="https://profiles.wordpress.org/densinakum/">Densi Nakum</a> · <a href="https://profiles.wordpress.org/derekherman/">derekherman</a> · <a href="https://profiles.wordpress.org/devasheeshkaul/">Devasheesh Kaul</a> · <a href="https://profiles.wordpress.org/dhananjaykuber/">Dhananjay Kuber</a> · <a href="https://profiles.wordpress.org/dhrumilk/">Dhrumil Kumbhani</a> · <a href="https://profiles.wordpress.org/dhruval04/">Dhruval Shah</a> · <a href="https://profiles.wordpress.org/dhruvang21/">Dhruvang21</a> · <a href="https://profiles.wordpress.org/dhruvik18/">Dhruvik Malaviya</a> · <a href="https://profiles.wordpress.org/diebombe/">diebombe</a> · <a href="https://profiles.wordpress.org/dilipbheda/">Dilip Bheda</a> · <a href="https://profiles.wordpress.org/dilip2615/">Dilip Modhavadiya</a> · <a href="https://profiles.wordpress.org/dd32/">Dion Hulse</a> · <a href="https://profiles.wordpress.org/divinenephron/">divinenephron</a> · <a href="https://profiles.wordpress.org/djcowan/">dj.cowan</a> · <a href="https://profiles.wordpress.org/ocean90/">Dominik Schilling</a> · <a href="https://profiles.wordpress.org/dominiquepijnenburg/">dominiquepijnenburg</a> · <a href="https://profiles.wordpress.org/donalirl/">donalirl</a> · <a href="https://profiles.wordpress.org/doughamlin/">doughamlin</a> · <a href="https://profiles.wordpress.org/dougmelvin/">DougMelvin</a> · <a href="https://profiles.wordpress.org/drawcard/">drawcard</a> · <a href="https://profiles.wordpress.org/dretzlaff/">dretzlaff</a> · <a href="https://profiles.wordpress.org/drewapicture/">Drew Jaynes</a> · <a href="https://profiles.wordpress.org/drivingralle/">Drivingralle</a> · <a href="https://profiles.wordpress.org/dsawyers/">dsawyers</a> · <a href="https://profiles.wordpress.org/dustintechsmith/">dustintechsmith</a> · <a href="https://profiles.wordpress.org/eclev91/">eclev91</a> · <a href="https://profiles.wordpress.org/eduwass/">eduwass</a> · <a href="https://profiles.wordpress.org/ehti/">Ehti</a> · <a href="https://profiles.wordpress.org/elialum/">elialum</a> · <a href="https://profiles.wordpress.org/eliezerspp/">Eliezer Pe&#241;a</a> · <a href="https://profiles.wordpress.org/ellatrix/">Ella van Durpe</a> · <a href="https://profiles.wordpress.org/elvismdev/">Elvis Morales</a> · <a href="https://profiles.wordpress.org/emaildano/">emaildano</a> · <a href="https://profiles.wordpress.org/codex-m/">Emerson Maningo</a> · <a href="https://profiles.wordpress.org/emlebrun/">Emilie LEBRUN</a> · <a href="https://profiles.wordpress.org/emranahmed/">Emran Ahmed</a> · <a href="https://profiles.wordpress.org/enaanfarhan/">Enaan Farhan</a> · <a href="https://profiles.wordpress.org/lopo/">Enrico Battocchi</a> · <a href="https://profiles.wordpress.org/nrqsnchz/">Enrique S&#225;nchez</a> · <a href="https://profiles.wordpress.org/epeicher/">epeicher</a> · <a href="https://profiles.wordpress.org/ekazda/">Eric</a> · <a href="https://profiles.wordpress.org/ericlewis/">Eric Andrew Lewis</a> · <a href="https://profiles.wordpress.org/ethitter/">Erick Hitter</a> · <a href="https://profiles.wordpress.org/kebbet/">Erik</a> · <a href="https://profiles.wordpress.org/ejoling/">Erik Joling</a> · <a href="https://profiles.wordpress.org/im3dabasia1/">Eshaan Dabasiya</a> · <a href="https://profiles.wordpress.org/ethanscorey/">ethanscorey</a> · <a href="https://profiles.wordpress.org/circlecube/">Evan Mullins</a> · <a href="https://profiles.wordpress.org/etobiesen/">Even Tobiesen</a> · <a href="https://profiles.wordpress.org/fabiankaegy/">Fabian Kägy</a> · <a href="https://profiles.wordpress.org/gaambo/">Fabian Todt</a> · <a href="https://profiles.wordpress.org/faisalahammad/">Faisal Ahammad</a> · <a href="https://profiles.wordpress.org/faisal03/">Faisal Alvi</a> · <a href="https://profiles.wordpress.org/fakhriaz/">fakhriaz</a> · <a href="https://profiles.wordpress.org/falgunihdesai/">Falguni Desai</a> · <a href="https://profiles.wordpress.org/flixos90/">Felix Arntz</a> · <a href="https://profiles.wordpress.org/ffffelix/">Felix Renicks</a> · <a href="https://profiles.wordpress.org/fellyph/">Fellyph Cintra</a> · <a href="https://profiles.wordpress.org/mista-flo/">Florian TIAR</a> · <a href="https://profiles.wordpress.org/frantorres/">Francisco Torres</a> · <a href="https://profiles.wordpress.org/fcoveram/">Francisco Vera</a> · <a href="https://profiles.wordpress.org/frogdesk/">FrogDesk Strategy</a> · <a href="https://profiles.wordpress.org/takahashi_fumiki/">Fumiki Takahashi</a> · <a href="https://profiles.wordpress.org/gaeldenysiak/">Gael Denysiak</a> · <a href="https://profiles.wordpress.org/gajendrasingh/">Gajendra Singh</a> · <a href="https://profiles.wordpress.org/ecgan/">Gan Eng Chin</a> · <a href="https://profiles.wordpress.org/garrett-eclipse/">Garrett Hyder</a> · <a href="https://profiles.wordpress.org/garyj/">Gary Jones</a> · <a href="https://profiles.wordpress.org/pento/">Gary Pendergast</a> · <a href="https://profiles.wordpress.org/guddu1315/">Gaurang Dabhi</a> · <a href="https://profiles.wordpress.org/gautam23/">Gautam Mehta</a> · <a href="https://profiles.wordpress.org/soulseekah/">Gennady Kovshenin</a> · <a href="https://profiles.wordpress.org/mamaduka/">George Mamadashvili</a> · <a href="https://profiles.wordpress.org/georgestephanis/">George Stephanis</a> · <a href="https://profiles.wordpress.org/stoyanovgs/">Georgi Stoyanov</a> · <a href="https://profiles.wordpress.org/gernberg/">gernberg</a> · <a href="https://profiles.wordpress.org/giuliorubelli/">giuliorubelli</a> · <a href="https://profiles.wordpress.org/glendaviesnz/">Glen Davies</a> · <a href="https://profiles.wordpress.org/ingeniumed/">Gopal Krishnan</a> · <a href="https://profiles.wordpress.org/grantmkin/">Grant M. Kinney</a> · <a href="https://profiles.wordpress.org/gziolo/">Greg Ziółkowski</a> · <a href="https://profiles.wordpress.org/guido07111975/">Guido</a> · <a href="https://profiles.wordpress.org/wido/">Guido Scialfa</a> · <a href="https://profiles.wordpress.org/guillaumeturpin/">Guillaume TURPIN</a> · <a href="https://profiles.wordpress.org/gulamdastgir04/">Gulamdastgir Momin</a> · <a href="https://profiles.wordpress.org/adrock42/">H. Adam Lenz</a> · <a href="https://profiles.wordpress.org/kabir93/">H. Kabir</a> · <a href="https://profiles.wordpress.org/hanimbarek/">hanimbarek</a> · <a href="https://profiles.wordpress.org/hanneslsm/">hanneslsm</a> · <a href="https://profiles.wordpress.org/hage/">Hans-Gerd Gerhards</a> · <a href="https://profiles.wordpress.org/hardik2221/">Hardik Raval</a> · <a href="https://profiles.wordpress.org/hareesh-pillai/">Hareesh S</a> · <a href="https://profiles.wordpress.org/harshgajipara/">Harsh Gajipara</a> · <a href="https://profiles.wordpress.org/harshalkadu/">Harshal Kadu</a> · <a href="https://profiles.wordpress.org/harshbhonsle08/">harshbhonsle08</a> · <a href="https://profiles.wordpress.org/harshdeepgill/">harshdeepgill</a> · <a href="https://profiles.wordpress.org/haruncpi/">Harun</a> · <a href="https://profiles.wordpress.org/helen/">Helen Hou-Sandi</a> · <a href="https://profiles.wordpress.org/helgatheviking/">HelgaTheViking</a> · <a href="https://profiles.wordpress.org/hideishi/">Hidenori ISHIKAWA</a> · <a href="https://profiles.wordpress.org/hilayt24/">Hilay Trivedi</a> · <a href="https://profiles.wordpress.org/panchalhimani711/">Himani Panchal</a> · <a href="https://profiles.wordpress.org/abcd95/">Himanshu Pathak</a> · <a href="https://profiles.wordpress.org/hiroshisato/">Hiroshi Sato</a> · <a href="https://profiles.wordpress.org/hbhalodia/">Hit Bhalodia</a> · <a href="https://profiles.wordpress.org/hitendra-chopda/">Hitendra Chopda</a> · <a href="https://profiles.wordpress.org/hiteshtalpada/">Hitesh Talpada</a> · <a href="https://profiles.wordpress.org/hozefasmile/">Hozefa Saleh</a> · <a href="https://profiles.wordpress.org/hrohh/">Hrohh</a> · <a href="https://profiles.wordpress.org/hugod/">hugod</a> · <a href="https://profiles.wordpress.org/hugosolar/">hugosolar</a> · <a href="https://profiles.wordpress.org/humanify/">humanify</a> · <a href="https://profiles.wordpress.org/huubl/">huubl</a> · <a href="https://profiles.wordpress.org/huzaifaalmesbah/">Huzaifa Al Mesbah</a> · <a href="https://profiles.wordpress.org/priethor/">Héctor Prieto</a> · <a href="https://profiles.wordpress.org/iandunn/">Ian Dunn</a> · <a href="https://profiles.wordpress.org/ignatiusjeroe/">ignatiusjeroe</a> · <a href="https://profiles.wordpress.org/igorradovanov/">Igor Radovanov</a> · <a href="https://profiles.wordpress.org/ikriv/">ikriv</a> · <a href="https://profiles.wordpress.org/imokweb/">imokweb</a> · <a href="https://profiles.wordpress.org/imranhasanraaz/">Imran</a> · <a href="https://profiles.wordpress.org/indirabiswas27/">Indira Biswas</a> · <a href="https://profiles.wordpress.org/ipstenu/">Ipstenu (Mika Epstein)</a> · <a href="https://profiles.wordpress.org/iqbal1hossain/">Iqbal Hossain</a> · <a href="https://profiles.wordpress.org/isabel_brison/">Isabel Brison</a> · <a href="https://profiles.wordpress.org/ishikaatxecurify/">Ishika Bansal</a> · <a href="https://profiles.wordpress.org/ivanottinger/">Ivan Ottinger</a> · <a href="https://profiles.wordpress.org/jabe/">Jabe</a> · <a href="https://profiles.wordpress.org/jacobcassidy/">Jacob Cassidy</a> · <a href="https://profiles.wordpress.org/jagirbahesh/">Jagir Bahesh</a> · <a href="https://profiles.wordpress.org/jaiminp/">Jaimin Prajapati</a> · <a href="https://profiles.wordpress.org/jakariaistauk/">Jakaria Istauk</a> · <a href="https://profiles.wordpress.org/whyisjake/">Jake Spurlock</a> · <a href="https://profiles.wordpress.org/jakeparis/">jakeparis</a> · <a href="https://profiles.wordpress.org/jameskoster/">James Koster</a> · <a href="https://profiles.wordpress.org/isotropic/">James LePage</a> · <a href="https://profiles.wordpress.org/jhmonroe/">James Monroe</a> · <a href="https://profiles.wordpress.org/q0rban/">James Sansbury</a> · <a href="https://profiles.wordpress.org/jamestitus299/">James Titus</a> · <a href="https://profiles.wordpress.org/codente/">Jamie</a> · <a href="https://profiles.wordpress.org/jamieburchell/">Jamie Burchell</a> · <a href="https://profiles.wordpress.org/jamesmarsland/">Jamie Marsland</a> · <a href="https://profiles.wordpress.org/janthiel/">janthiel</a> · <a href="https://profiles.wordpress.org/jsnajdr/">Jarda Snajdr</a> · <a href="https://profiles.wordpress.org/jarekmorawski/">jarekmorawski</a> · <a href="https://profiles.wordpress.org/jasalt/">Jarkko Saltiola</a> · <a href="https://profiles.wordpress.org/jason_the_adams/">Jason Adams</a> · <a href="https://profiles.wordpress.org/madtownlems/">Jason LeMahieu (MadtownLems)</a> · <a href="https://profiles.wordpress.org/jasonsa19/">Jason Sauerwald</a> · <a href="https://profiles.wordpress.org/javiercasares/">Javier Casares</a> · <a href="https://profiles.wordpress.org/jonmcpartland/">Jay McPartland</a> · <a href="https://profiles.wordpress.org/shovan_jaya/">Jayaram</a> · <a href="https://profiles.wordpress.org/jdahir0789/">Jaydip</a> · <a href="https://profiles.wordpress.org/audrasjb/">Jean-Baptiste Audras</a> · <a href="https://profiles.wordpress.org/krokodok/">Jeff Chi</a> · <a href="https://profiles.wordpress.org/jeffmatson/">Jeff Matson</a> · <a href="https://profiles.wordpress.org/jffng/">Jeff Ong</a> · <a href="https://profiles.wordpress.org/jeffpaul/">Jeff Paul</a> · <a href="https://profiles.wordpress.org/cheffheid/">Jeffrey de Wit</a> · <a href="https://profiles.wordpress.org/jeffr0/">Jeffro</a> · <a href="https://profiles.wordpress.org/jeflopodev/">jeflopo</a> · <a href="https://profiles.wordpress.org/jdy68/">Jenny Dupuy</a> · <a href="https://profiles.wordpress.org/jeremiahbratton/">Jeremiah Bratton</a> · <a href="https://profiles.wordpress.org/jeremyfelt/">Jeremy Felt</a> · <a href="https://profiles.wordpress.org/jkmassel/">Jeremy Massel</a> · <a href="https://profiles.wordpress.org/slimndap/">Jeroen Schmit</a> · <a href="https://profiles.wordpress.org/jeryj/">jeryj</a> · <a href="https://profiles.wordpress.org/jesin/">Jesin A</a> · <a href="https://profiles.wordpress.org/jessedyck/">jessedyck</a> · <a href="https://profiles.wordpress.org/luminuu/">Jessica Lyschik</a> · <a href="https://profiles.wordpress.org/jigar-bhanushali/">Jigar Bhanushali</a> · <a href="https://profiles.wordpress.org/jigar9998/">Jigar Panchal</a> · <a href="https://profiles.wordpress.org/jikamens/">jikamens</a> · <a href="https://profiles.wordpress.org/jnweaver/">jnweaver</a> · <a href="https://profiles.wordpress.org/jojo256/">Joan Namunina</a> · <a href="https://profiles.wordpress.org/jobata/">JoAnne Obata</a> · <a href="https://profiles.wordpress.org/jochent/">JochenT</a> · <a href="https://profiles.wordpress.org/jodamo5/">jodamo5</a> · <a href="https://profiles.wordpress.org/joedolson/">Joe Dolson</a> · <a href="https://profiles.wordpress.org/joehoyle/">Joe Hoyle</a> · <a href="https://profiles.wordpress.org/joemcgill/">Joe McGill</a> · <a href="https://profiles.wordpress.org/joen/">Joen Asmussen</a> · <a href="https://profiles.wordpress.org/timse201/">Johannes J&#252;lg</a> · <a href="https://profiles.wordpress.org/johnbillion/">John Blackbourn</a> · <a href="https://profiles.wordpress.org/brandbrilliance/">John Brand</a> · <a href="https://profiles.wordpress.org/johnny5/">John Godley</a> · <a href="https://profiles.wordpress.org/johnjamesjacoby/">John James Jacoby</a> · <a href="https://profiles.wordpress.org/mindctrl/">John Parris</a> · <a href="https://profiles.wordpress.org/johnregan3/">John Regan</a> · <a href="https://profiles.wordpress.org/johnvieth/">JohnVieth</a> · <a href="https://profiles.wordpress.org/jonsurrell/">Jon Surrell</a> · <a href="https://profiles.wordpress.org/psykro/">Jonathan Bossenger</a> · <a href="https://profiles.wordpress.org/jrchamp/">Jonathan Champ</a> · <a href="https://profiles.wordpress.org/desrosj/">Jonathan Desrosiers</a> · <a href="https://profiles.wordpress.org/n2erjo00/">Joni Erkkil&#228;</a> · <a href="https://profiles.wordpress.org/spacedmonkey/">Jonny Harris</a> · <a href="https://profiles.wordpress.org/jonoaldersonwp/">Jono Alderson</a> · <a href="https://profiles.wordpress.org/jordesign/">jordesign</a> · <a href="https://profiles.wordpress.org/jorgefilipecosta/">Jorge Costa</a> · <a href="https://profiles.wordpress.org/josvelasco/">Jos Velasco</a> · <a href="https://profiles.wordpress.org/josephscott/">Joseph Scott</a> · <a href="https://profiles.wordpress.org/jhabdas/">Josh Habdas</a> · <a href="https://profiles.wordpress.org/verygoode/">Joshua Goode</a> · <a href="https://profiles.wordpress.org/jrmd/">jrmd</a> · <a href="https://profiles.wordpress.org/juanfra/">Juan Aldasoro</a> · <a href="https://profiles.wordpress.org/juampick/">Juan Cook</a> · <a href="https://profiles.wordpress.org/juanmaguitar/">JuanMa Garrido</a> · <a href="https://profiles.wordpress.org/juliengardair/">juliengardair</a> · <a href="https://profiles.wordpress.org/jrf/">Juliette Reinders Folmer</a> · <a href="https://profiles.wordpress.org/justinahinon/">Justin Ahinon</a> · <a href="https://profiles.wordpress.org/greenshady/">Justin Tadlock</a> · <a href="https://profiles.wordpress.org/itsroy69/">Jyotirmoy Roy</a> · <a href="https://profiles.wordpress.org/kadamwhite/">K. Adam White</a> · <a href="https://profiles.wordpress.org/kevin940726/">Kai Hao</a> · <a href="https://profiles.wordpress.org/trepmal/">Kailey (trepmal)</a> · <a href="https://profiles.wordpress.org/kaitohm/">Kaito Hanamori</a> · <a href="https://profiles.wordpress.org/kakomap/">Kakoma</a> · <a href="https://profiles.wordpress.org/kalpeshh/">Kalpesh</a> · <a href="https://profiles.wordpress.org/karinchristen/">Karin Christen</a> · <a href="https://profiles.wordpress.org/karolmanijak/">Karol Manijak</a> · <a href="https://profiles.wordpress.org/karthickmurugan/">Karthick Murugan</a> · <a href="https://profiles.wordpress.org/karthikeya01/">Karthikeya Bethu</a> · <a href="https://profiles.wordpress.org/kasparsd/">Kaspars</a> · <a href="https://profiles.wordpress.org/codebykat/">Kat Hagan</a> · <a href="https://profiles.wordpress.org/katinthehatsite/">Kateryna K. a11n</a> · <a href="https://profiles.wordpress.org/zoonini/">Kathryn Presner</a> · <a href="https://profiles.wordpress.org/katrinadtl/">Katrina Massey</a> · <a href="https://profiles.wordpress.org/kausaralm/">Kausar Alam</a> · <a href="https://profiles.wordpress.org/khushdoms/">Kaushik Domadiya</a> · <a href="https://profiles.wordpress.org/onlykawshar/">Kawshar Ahmed</a> · <a href="https://profiles.wordpress.org/kaygee79/">kaygee79</a> · <a href="https://profiles.wordpress.org/mt8biz/">Kazuto Takeshita</a> · <a href="https://profiles.wordpress.org/ryelle/">Kelly Choyce-Dwan</a> · <a href="https://profiles.wordpress.org/kellychoffman/">Kelly Hoffman</a> · <a href="https://profiles.wordpress.org/tinypixel/">Kelly Mears</a> · <a href="https://profiles.wordpress.org/kgagne/">Ken Gagne</a> · <a href="https://profiles.wordpress.org/kerfred/">Kerfred</a> · <a href="https://profiles.wordpress.org/gwwar/">Kerry Liu</a> · <a href="https://profiles.wordpress.org/kesselb/">kesselb</a> · <a href="https://profiles.wordpress.org/kevinlearynet/">Kevin Leary</a> · <a href="https://profiles.wordpress.org/khoipro/">Khoi Pro</a> · <a href="https://profiles.wordpress.org/khushipatel15/">Khushi Patel</a> · <a href="https://profiles.wordpress.org/killerbishop/">killerbishop</a> · <a href="https://profiles.wordpress.org/iamkingsleyf/">Kingsley Felix</a> · <a href="https://profiles.wordpress.org/kirasong/">Kira Schroder</a> · <a href="https://profiles.wordpress.org/kishanjasani/">Kishan Jasani</a> · <a href="https://profiles.wordpress.org/kitchin/">kitchin</a> · <a href="https://profiles.wordpress.org/kjellr/">Kjell Reigstad</a> · <a href="https://profiles.wordpress.org/kkmuffme/">kkmuffme</a> · <a href="https://profiles.wordpress.org/kleor/">Kleor</a> · <a href="https://profiles.wordpress.org/knutsp/">Knut Sparhell</a> · <a href="https://profiles.wordpress.org/obenland/">Konstantin Obenland</a> · <a href="https://profiles.wordpress.org/xkon/">Konstantinos Xenos</a> · <a href="https://profiles.wordpress.org/kpapazov/">kpapazov</a> · <a href="https://profiles.wordpress.org/kprocyszyn/">kprocyszyn</a> · <a href="https://profiles.wordpress.org/krishaamer/">krishaamer</a> · <a href="https://profiles.wordpress.org/krunal265/">Krunal Bhimajiyani</a> · <a href="https://profiles.wordpress.org/krupajnanda/">Krupa Nanda</a> · <a href="https://profiles.wordpress.org/kshaner/">kshaner</a> · <a href="https://profiles.wordpress.org/kub1x/">kub1x</a> · <a href="https://profiles.wordpress.org/kubiq/">kubiq</a> · <a href="https://profiles.wordpress.org/kunalpuri123/">kunalpuri123</a> · <a href="https://profiles.wordpress.org/kushsharma/">Kush Sharma</a> · <a href="https://profiles.wordpress.org/kush123/">Kushagra Goyal</a> · <a href="https://profiles.wordpress.org/lgadzhev/">Lachezar Gadzhev</a> · <a href="https://profiles.wordpress.org/lakrisgubben/">lakrisgubben</a> · <a href="https://profiles.wordpress.org/lakshyajeet/">Lakshyajeet Singh Goyal</a> · <a href="https://profiles.wordpress.org/lalitkumawat/">Lalit Kumawat</a> · <a href="https://profiles.wordpress.org/lancewillett/">Lance Willett</a> · <a href="https://profiles.wordpress.org/newyorkerlaura/">Laura Byrne</a> · <a href="https://profiles.wordpress.org/laurisaarni/">Lauri Saarni</a> · <a href="https://profiles.wordpress.org/ldanielgiuliani/">ldanielgiuliani</a> · <a href="https://profiles.wordpress.org/leewillis77/">Lee Willis</a> · <a href="https://profiles.wordpress.org/leedxw/">leedxw</a> · <a href="https://profiles.wordpress.org/leemon/">leemon</a> · <a href="https://profiles.wordpress.org/0mirka00/">Lena Morita</a> · <a href="https://profiles.wordpress.org/leonidasmilossis/">Leonidas Milosis</a> · <a href="https://profiles.wordpress.org/levinbaria/">Levin Baria</a> · <a href="https://profiles.wordpress.org/lgseo/">lgseo</a> · <a href="https://profiles.wordpress.org/lilgames/">LilGames</a> · <a href="https://profiles.wordpress.org/liviopv/">liviopv</a> · <a href="https://profiles.wordpress.org/logiclink/">logiclink</a> · <a href="https://profiles.wordpress.org/logicrays/">LogicRays Technologies</a> · <a href="https://profiles.wordpress.org/lordandy1984/">lordandy1984</a> · <a href="https://profiles.wordpress.org/lovor/">Lovro Hrust</a> · <a href="https://profiles.wordpress.org/lucasms/">Lucas Martins</a> · <a href="https://profiles.wordpress.org/gigitux/">Luigi Teschio</a> · <a href="https://profiles.wordpress.org/luisherranz/">luisherranz</a> · <a href="https://profiles.wordpress.org/lukasfritzedev/">LukasFritzeDev</a> · <a href="https://profiles.wordpress.org/wpfed/">Lukasz</a> · <a href="https://profiles.wordpress.org/lukecavanagh/">Luke Cavanagh</a> · <a href="https://profiles.wordpress.org/maccyd/">maccyd</a> · <a href="https://profiles.wordpress.org/madhavishah01/">Madhavi Shah</a> · <a href="https://profiles.wordpress.org/madhudollu/">Madhu Dollu</a> · <a href="https://profiles.wordpress.org/onemaggie/">Maggie Cabrera</a> · <a href="https://profiles.wordpress.org/maikuolan/">Maikuolan</a> · <a href="https://profiles.wordpress.org/manfcarlo/">manfcarlo</a> · <a href="https://profiles.wordpress.org/manhatthien98/">manhatthien98</a> · <a href="https://profiles.wordpress.org/sirlouen/">Manuel Camargo</a> · <a href="https://profiles.wordpress.org/manzoorwanijk/">Manzoor Wani</a> · <a href="https://profiles.wordpress.org/maorb/">maorb</a> · <a href="https://profiles.wordpress.org/mdxfr/">Marc</a> · <a href="https://profiles.wordpress.org/marc4/">Marc Armengou</a> · <a href="https://profiles.wordpress.org/pagelab/">Marcio Duarte</a> · <a href="https://profiles.wordpress.org/mciampini/">Marco Ciampini</a> · <a href="https://profiles.wordpress.org/leadclown/">Marcus</a> · <a href="https://profiles.wordpress.org/mkaz/">Marcus Kazmierczak</a> · <a href="https://profiles.wordpress.org/marian1/">marian1</a> · <a href="https://profiles.wordpress.org/plari/">Marie</a> · <a href="https://profiles.wordpress.org/tyxla/">Marin Atanasov</a> · <a href="https://profiles.wordpress.org/santosguillamot/">Mario Santos</a> · <a href="https://profiles.wordpress.org/mariohamann/">mariohamann</a> · <a href="https://profiles.wordpress.org/marius84/">mariushosting</a> · <a href="https://profiles.wordpress.org/bozzmedia/">Marty</a> · <a href="https://profiles.wordpress.org/martythornley/">MartyThornley</a> · <a href="https://profiles.wordpress.org/marybaum/">Mary Baum</a> · <a href="https://profiles.wordpress.org/4thhubbard/">Mary Hubbard</a> · <a href="https://profiles.wordpress.org/mat-lipe/">Mat Lipe</a> · <a href="https://profiles.wordpress.org/mathiscode/">mathiscode</a> · <a href="https://profiles.wordpress.org/mmaattiiaass/">Matias Benedetto</a> · <a href="https://profiles.wordpress.org/matveb/">Matias Ventura</a> · <a href="https://profiles.wordpress.org/matt/">Matt Mullenweg</a> · <a href="https://profiles.wordpress.org/mattyrob/">Matt Robinson</a> · <a href="https://profiles.wordpress.org/mattwest/">Matt West</a> · <a href="https://profiles.wordpress.org/matteoenna/">Matteo Enna</a> · <a href="https://profiles.wordpress.org/pfefferle/">Matthias Pfefferle</a> · <a href="https://profiles.wordpress.org/mattryanwalker/">mattryanwalker</a> · <a href="https://profiles.wordpress.org/maxschmeling/">Max Schmeling</a> · <a href="https://profiles.wordpress.org/maxpertici/">Maxime Pertici</a> · <a href="https://profiles.wordpress.org/mayanktripathi32/">Mayank Tripathi</a> · <a href="https://profiles.wordpress.org/mayur8991/">Mayur Prajapati</a> · <a href="https://profiles.wordpress.org/faithcoder/">Md Abdullah Al Arif</a> · <a href="https://profiles.wordpress.org/mabfahad/">Md Abdullah Al Fahad</a> · <a href="https://profiles.wordpress.org/hmbashar/">Md Abul Bashar</a> · <a href="https://profiles.wordpress.org/ismail0071/">MD ISMAIL</a> · <a href="https://profiles.wordpress.org/kawsar007/">MD Kawsar Chowdhury</a> · <a href="https://profiles.wordpress.org/masummollaalhaz/">Md Masum Molla Alhaz</a> · <a href="https://profiles.wordpress.org/obiplabon/">Md Obidullah (obiPlabon)</a> · <a href="https://profiles.wordpress.org/wprashed/">Md Rashed Hossain</a> · <a href="https://profiles.wordpress.org/sabbir20/">Md Sabbir Hossain</a> · <a href="https://profiles.wordpress.org/najmulsaju/">Md. Najmul Islam</a> · <a href="https://profiles.wordpress.org/mehedi_csit/">Md.Mehedi Hasan</a> · <a href="https://profiles.wordpress.org/mdmoreau/">mdmoreau</a> · <a href="https://profiles.wordpress.org/mdviralsampat/">mdviralsampat</a> · <a href="https://profiles.wordpress.org/immeet94/">Meet Makadia</a> · <a href="https://profiles.wordpress.org/megane9988/">megane9988</a> · <a href="https://profiles.wordpress.org/meher/">Meher Bala</a> · <a href="https://profiles.wordpress.org/melchoyce/">Mel Choyce-Dwan</a> · <a href="https://profiles.wordpress.org/mfgmicha/">Micha Krapp</a> · <a href="https://profiles.wordpress.org/mburridge/">Michael Burridge</a> · <a href="https://profiles.wordpress.org/michaelkeck/">Michael Keck</a> · <a href="https://profiles.wordpress.org/mnelson4/">Michael Nelson</a> · <a href="https://profiles.wordpress.org/xmic/">Michael Sumner</a> · <a href="https://profiles.wordpress.org/michaelreetz/">michaelreetz</a> · <a href="https://profiles.wordpress.org/czapla/">Michal Czaplinski</a> · <a href="https://profiles.wordpress.org/marktimemedia/">Michelle Schulp Hunt</a> · <a href="https://profiles.wordpress.org/mcsf/">Miguel Fonseca</a> · <a href="https://profiles.wordpress.org/migueluy/">Miguel Lezama</a> · <a href="https://profiles.wordpress.org/simison/">Mikael Korpela</a> · <a href="https://profiles.wordpress.org/mobius5150/">Mike</a> · <a href="https://profiles.wordpress.org/mikefitzman/">Mike Fitzpatrick</a> · <a href="https://profiles.wordpress.org/mikehansenme/">Mike Hansen</a> · <a href="https://profiles.wordpress.org/mikejolley/">Mike Jolley</a> · <a href="https://profiles.wordpress.org/mmcalister/">Mike McAlister</a> · <a href="https://profiles.wordpress.org/ritterml/">Mike Ritter</a> · <a href="https://profiles.wordpress.org/mikinc860/">Mikin Chauhan</a> · <a href="https://profiles.wordpress.org/firestar300/">Milan Ricoul</a> · <a href="https://profiles.wordpress.org/multidots1896/">Minal Diwan</a> · <a href="https://profiles.wordpress.org/369work/">Miroku</a> · <a href="https://profiles.wordpress.org/missveronicatv/">missveronica</a> · <a href="https://profiles.wordpress.org/presstoke/">Mitchell Austin</a> · <a href="https://profiles.wordpress.org/mkeck/">mkeck</a> · <a href="https://profiles.wordpress.org/mlaetitia1986/">mlaetitia1986</a> · <a href="https://profiles.wordpress.org/mleray/">mleray</a> · <a href="https://profiles.wordpress.org/mleraygp/">mleraygp</a> · <a href="https://profiles.wordpress.org/mobarak/">Mobarak Ali</a> · <a href="https://profiles.wordpress.org/opurockey/">Mohammad Rockeybul Alam</a> · <a href="https://profiles.wordpress.org/mohkatz/">Mohammed Kateregga</a> · <a href="https://profiles.wordpress.org/mosescursor/">Moses Cursor Ssebunya</a> · <a href="https://profiles.wordpress.org/mrwweb/">mrwweb</a> · <a href="https://profiles.wordpress.org/mtg169/">mtg169</a> · <a href="https://profiles.wordpress.org/mujuonly/">mujuonly</a> · <a href="https://profiles.wordpress.org/mukesh27/">Mukesh Panchal</a> · <a href="https://profiles.wordpress.org/mukulsingh27/">Mukul Singh</a> · <a href="https://profiles.wordpress.org/faguni22/">Mumtahina Faguni</a> · <a href="https://profiles.wordpress.org/sedmikrasky/">N&#250;ria Nadal i Rovira</a> · <a href="https://profiles.wordpress.org/vyasnaman/">Naman Vyas</a> · <a href="https://profiles.wordpress.org/nanisamireddy/">NANI SAMIREDDY</a> · <a href="https://profiles.wordpress.org/narenin/">Narendra Sishodiya</a> · <a href="https://profiles.wordpress.org/nareshbheda/">Naresh Bheda</a> · <a href="https://profiles.wordpress.org/muddassirnasim/">Nasim Miah</a> · <a href="https://profiles.wordpress.org/n8finch/">Nate Finch</a> · <a href="https://profiles.wordpress.org/naveendwivedi/">Naveen Dwivedi</a> · <a href="https://profiles.wordpress.org/navi161/">Navneet Kaur</a> · <a href="https://profiles.wordpress.org/bugnumber9/">Nazar Hotsa</a> · <a href="https://profiles.wordpress.org/nazmul111/">Nazmul Hosen</a> · <a href="https://profiles.wordpress.org/greatislander/">Ned Zimmerman</a> · <a href="https://profiles.wordpress.org/nexbridge/">nexbridge</a> · <a href="https://profiles.wordpress.org/nextendweb/">Nextendweb</a> · <a href="https://profiles.wordpress.org/neychok/">Neycho Kalaydzhiev</a> · <a href="https://profiles.wordpress.org/nickchomey/">Nick</a> · <a href="https://profiles.wordpress.org/nickstarkloff/">Nick</a> · <a href="https://profiles.wordpress.org/ndiego/">Nick Diego</a> · <a href="https://profiles.wordpress.org/celloexpressions/">Nick Halsey</a> · <a href="https://profiles.wordpress.org/nickbrazilian/">nickbrazilian</a> · <a href="https://profiles.wordpress.org/nickjbedford/">nickjbedford</a> · <a href="https://profiles.wordpress.org/nickpagz/">nickpagz</a> · <a href="https://profiles.wordpress.org/nickwilmot/">nickwilmot</a> · <a href="https://profiles.wordpress.org/nico23/">Nico</a> · <a href="https://profiles.wordpress.org/nidhidhandhukiya/">nidhidhandhukiya</a> · <a href="https://profiles.wordpress.org/nielslange/">Niels Lange</a> · <a href="https://profiles.wordpress.org/nigelnelles/">nigelnelles</a> · <a href="https://profiles.wordpress.org/ntsekouras/">Nik Tsekouras</a> · <a href="https://profiles.wordpress.org/smushytaco/">Nikan Radan</a> · <a href="https://profiles.wordpress.org/nikunj8866/">Nikunj Hatkar</a> · <a href="https://profiles.wordpress.org/nimeshatxecurify/">Nimesh</a> · <a href="https://profiles.wordpress.org/ninomiho/">Nino Mihovilic</a> · <a href="https://profiles.wordpress.org/ninos-ego/">Ninos</a> · <a href="https://profiles.wordpress.org/noahtallen/">Noah Allen</a> · <a href="https://profiles.wordpress.org/othernoel/">Noel Santos</a> · <a href="https://profiles.wordpress.org/noruzzaman/">Noruzzaman</a> · <a href="https://profiles.wordpress.org/nosilver4u/">nosilver4u</a> · <a href="https://profiles.wordpress.org/oceantober/">oceantober</a> · <a href="https://profiles.wordpress.org/oferlaor/">oferlaor</a> · <a href="https://profiles.wordpress.org/okat/">okat</a> · <a href="https://profiles.wordpress.org/yasunocco/">Okawa Yasuno</a> · <a href="https://profiles.wordpress.org/oglekler/">Olga Gleckler</a> · <a href="https://profiles.wordpress.org/domainsupport/">Oliver Campion</a> · <a href="https://profiles.wordpress.org/alshakero/">Omar Alshaker</a> · <a href="https://profiles.wordpress.org/gabertronic/">Ophelia Rose</a> · <a href="https://profiles.wordpress.org/optimizingmatters/">Optimizing Matters</a> · <a href="https://profiles.wordpress.org/owi/">owi</a> · <a href="https://profiles.wordpress.org/paaljoachim/">Paal Joachim Romdahl</a> · <a href="https://profiles.wordpress.org/pablohoneyhoney/">Pablo Honey</a> · <a href="https://profiles.wordpress.org/palak678/">Palak Patel</a> · <a href="https://profiles.wordpress.org/paragoninitiativeenterprises/">Paragon Initiative Enterprises</a> · <a href="https://profiles.wordpress.org/parinpanjari/">Parin Panjari</a> · <a href="https://profiles.wordpress.org/parthvataliya/">Parth vataliya</a> · <a href="https://profiles.wordpress.org/techpartho/">Partho Hore</a> · <a href="https://profiles.wordpress.org/swissspidy/">Pascal Birchler</a> · <a href="https://profiles.wordpress.org/pateljaymin/">Patel Jaymin</a> · <a href="https://profiles.wordpress.org/patricia70/">Patricia BT</a> · <a href="https://profiles.wordpress.org/lumiblog/">Patrick Lumumba</a> · <a href="https://profiles.wordpress.org/patpiwo/">Patrick Piwowarczyk</a> · <a href="https://profiles.wordpress.org/pryley/">Paul</a> · <a href="https://profiles.wordpress.org/pbearne/">Paul Bearne</a> · <a href="https://profiles.wordpress.org/pbiron/">Paul Biron</a> · <a href="https://profiles.wordpress.org/paulbonneau/">Paul Bonneau</a> · <a href="https://profiles.wordpress.org/paulkevan/">Paul Kevan</a> · <a href="https://profiles.wordpress.org/paulopmt1/">Paulo Trentin</a> · <a href="https://profiles.wordpress.org/paulstanos/">paulstanos</a> · <a href="https://profiles.wordpress.org/pcarvalho/">pcarvalho</a> · <a href="https://profiles.wordpress.org/pedrofigueroa1989/">Pedro Figueroa</a> · <a href="https://profiles.wordpress.org/peroks/">Per Egil Roksvaag</a> · <a href="https://profiles.wordpress.org/peteringersoll/">Peter Ingersoll</a> · <a href="https://profiles.wordpress.org/westi/">Peter Westwood</a> · <a href="https://profiles.wordpress.org/peterwilsoncc/">Peter Wilson</a> · <a href="https://profiles.wordpress.org/petitphp/">petitphp</a> · <a href="https://profiles.wordpress.org/philipjohn/">Philip John</a> · <a href="https://profiles.wordpress.org/philsola/">Philip Sola</a> · <a href="https://profiles.wordpress.org/tyrannous/">Philipp Bammes</a> · <a href="https://profiles.wordpress.org/phillsav/">Phill</a> · <a href="https://profiles.wordpress.org/piskvorky/">piskvorky</a> · <a href="https://profiles.wordpress.org/poojabhimani/">Pooja Bhimani</a> · <a href="https://profiles.wordpress.org/poojapadamad/">poojapadamad</a> · <a href="https://profiles.wordpress.org/porg/">porg</a> · <a href="https://profiles.wordpress.org/prab18hat/">Prabhat Mishra</a> · <a href="https://profiles.wordpress.org/praful2111/">Praful Patel</a> · <a href="https://profiles.wordpress.org/pranjalpratapsingh/">Pranjal Pratap Singh</a> · <a href="https://profiles.wordpress.org/prasadkarmalkar/">Prasad Karmalkar</a> · <a href="https://profiles.wordpress.org/prasadgupte/">prasadgupte</a> · <a href="https://profiles.wordpress.org/pmbaldha/">Prashant Baldha</a> · <a href="https://profiles.wordpress.org/pratiklondhe/">Pratik Londhe</a> · <a href="https://profiles.wordpress.org/presskopp/">Presskopp</a> · <a href="https://profiles.wordpress.org/prettyboymp/">prettyboymp</a> · <a href="https://profiles.wordpress.org/puggan/">puggan</a> · <a href="https://profiles.wordpress.org/quentinr64600/">quentinr64600</a> · <a href="https://profiles.wordpress.org/rachelbaker/">Rachel Baker</a> · <a href="https://profiles.wordpress.org/rafiq91/">Rafiqul Islam</a> · <a href="https://profiles.wordpress.org/ralucastn/">Raluca</a> · <a href="https://profiles.wordpress.org/superpoincare/">Ramanan</a> · <a href="https://profiles.wordpress.org/ramiy/">Rami Yushuvaev</a> · <a href="https://profiles.wordpress.org/rahmohn/">Ramon Ahnert</a> · <a href="https://profiles.wordpress.org/rcorrales/">Ramon Corrales</a> · <a href="https://profiles.wordpress.org/ramonopoly/">Ramon James</a> · <a href="https://profiles.wordpress.org/ravichudasama01/">Ravi Chudasama</a> · <a href="https://profiles.wordpress.org/ravigadhiyawp/">Ravi Gadhiya</a> · <a href="https://profiles.wordpress.org/rcrdortiz/">rcrdortiz</a> · <a href="https://profiles.wordpress.org/rehanali/">Rehan Ali</a> · <a href="https://profiles.wordpress.org/rejaulalomkhan/">Rejaul Alom Khan</a> · <a href="https://profiles.wordpress.org/tabrisrp/">Remy Perona</a> · <a href="https://profiles.wordpress.org/espellcaste/">Renato Alves</a> · <a href="https://profiles.wordpress.org/renishsurani/">renishsurani</a> · <a href="https://profiles.wordpress.org/retrofox/">retrofox</a> · <a href="https://profiles.wordpress.org/rezwanshiblu1952/">Rezwan Shiblu</a> · <a href="https://profiles.wordpress.org/youknowriad/">Riad Benguella</a> · <a href="https://profiles.wordpress.org/riadev/">riadev</a> · <a href="https://profiles.wordpress.org/richtabor/">Rich Tabor</a> · <a href="https://profiles.wordpress.org/rockfire/">Richard Korthuis</a> · <a href="https://profiles.wordpress.org/riddhidave/">Riddhi Dave</a> · <a href="https://profiles.wordpress.org/rinatkhaziev/">Rinat</a> · <a href="https://profiles.wordpress.org/rinkalpagdar/">Rinkal Pagdar</a> · <a href="https://profiles.wordpress.org/rishabhwp/">Rishabh Gupta</a> · <a href="https://profiles.wordpress.org/rishavdutta/">Rishav Dutta</a> · <a href="https://profiles.wordpress.org/rishit30g/">Rishit Gupta</a> · <a href="https://profiles.wordpress.org/ristojovanovic/">Risto Jovanovic</a> · <a href="https://profiles.wordpress.org/devrito/">Ritoban</a> · <a href="https://profiles.wordpress.org/noisysocks/">Robert Anderson</a> · <a href="https://profiles.wordpress.org/miqrogroove/">Robert Chapin</a> · <a href="https://profiles.wordpress.org/robertghetau/">Robert Ghetau</a> · <a href="https://profiles.wordpress.org/sanchothefat/">Robert O\'Rourke</a> · <a href="https://profiles.wordpress.org/robmcclel/">Robmcclel</a> · <a href="https://profiles.wordpress.org/rodrigosprimo/">Rodrigo Primo</a> · <a href="https://profiles.wordpress.org/roelof/">roelof</a> · <a href="https://profiles.wordpress.org/rollybueno/">Rolly Bueno</a> · <a href="https://profiles.wordpress.org/ronak44/">Ronak prajapati</a> · <a href="https://profiles.wordpress.org/room34/">Room 34 Creative Services, LLC</a> · <a href="https://profiles.wordpress.org/costasovo/">Rostislav Woln&#253;</a> · <a href="https://profiles.wordpress.org/rotemg/">Rotem Gelbart</a> · <a href="https://profiles.wordpress.org/rayhatron/">Rufaro Madamombe</a> · <a href="https://profiles.wordpress.org/rutvikbhambhi2004/">Rutvik Bhambhi</a> · <a href="https://profiles.wordpress.org/rmccue/">Ryan McCue</a> · <a href="https://profiles.wordpress.org/welcher/">Ryan Welcher</a> · <a href="https://profiles.wordpress.org/skierpage/">S Page</a> · <a href="https://profiles.wordpress.org/soean/">S&#246;ren W&#252;nsch</a> · <a href="https://profiles.wordpress.org/sabbir1991/">Sabbir Ahmed</a> · <a href="https://profiles.wordpress.org/devsabbirahmed/">Sabbir Sam</a> · <a href="https://profiles.wordpress.org/sachinrajcp123/">SACHINRAJ CP</a> · <a href="https://profiles.wordpress.org/sahiljadhav1617/">Sahil Jadhav</a> · <a href="https://profiles.wordpress.org/sainathpoojary/">Sainath Poojary</a> · <a href="https://profiles.wordpress.org/sajjad67/">Sajjad Hossain Sagor</a> · <a href="https://profiles.wordpress.org/sakibmoon/">sakibmoon</a> · <a href="https://profiles.wordpress.org/samueljseay/">Sam</a> · <a href="https://profiles.wordpress.org/sam_a/">sam_a</a> · <a href="https://profiles.wordpress.org/samirmalpande/">Samir Malpande</a> · <a href="https://profiles.wordpress.org/viralsampat/">Sampat Viral</a> · <a href="https://profiles.wordpress.org/sjapaget/">Samuel Paget</a> · <a href="https://profiles.wordpress.org/otto42/">Samuel Wood (Otto)</a> · <a href="https://profiles.wordpress.org/sandeepdahiya/">Sandeep Dahiya</a> · <a href="https://profiles.wordpress.org/sandipsinh007/">Sandip Sinh</a> · <a href="https://profiles.wordpress.org/ourvalley/">Sandy McFadden</a> · <a href="https://profiles.wordpress.org/mikachan/">Sarah Norris</a> · <a href="https://profiles.wordpress.org/tinkerbelly/">sarah semark</a> · <a href="https://profiles.wordpress.org/sarthaknagoshe2002/">Sarthak Nagoshe</a> · <a href="https://profiles.wordpress.org/satishprajapati/">Satish Prajapati</a> · <a href="https://profiles.wordpress.org/saurabhdhariwal/">saurabh.dhariwal</a> · <a href="https://profiles.wordpress.org/saxonafletcher/">Saxon Fletcher</a> · <a href="https://profiles.wordpress.org/scholdstrom/">scholdstrom</a> · <a href="https://profiles.wordpress.org/swb1192/">Scott Buscemi</a> · <a href="https://profiles.wordpress.org/sc0ttkclark/">Scott Kingsley Clark</a> · <a href="https://profiles.wordpress.org/coffee2code/">Scott Reilly</a> · <a href="https://profiles.wordpress.org/wonderboymusic/">Scott Taylor</a> · <a href="https://profiles.wordpress.org/scribu/">scribu</a> · <a href="https://profiles.wordpress.org/sebastianpisula/">Sebastian Pisula</a> · <a href="https://profiles.wordpress.org/seifradwane/">Seif Radwane</a> · <a href="https://profiles.wordpress.org/sergeybiryukov/">Sergey Biryukov</a> · <a href="https://profiles.wordpress.org/smrubenstein/">Seth Rubenstein</a> · <a href="https://profiles.wordpress.org/shsajalchowdhury/">SH Sajal Chowdhury</a> · <a href="https://profiles.wordpress.org/shadialaghbari/">Shadi G شادي جـ</a> · <a href="https://profiles.wordpress.org/shailu25/">Shail Mehta</a> · <a href="https://profiles.wordpress.org/sh4lin/">Shalin Shah</a> · <a href="https://profiles.wordpress.org/shanemuir/">Shane Muirhead</a> · <a href="https://profiles.wordpress.org/iamshashank/">Shashank Jain</a> · <a href="https://profiles.wordpress.org/shekh0109/">Shashank Shekhar</a> · <a href="https://profiles.wordpress.org/sajib1223/">Shazzad Hossain Khan</a> · <a href="https://profiles.wordpress.org/designsimply/">Sheri Grey</a> · <a href="https://profiles.wordpress.org/shiponkarmakar/">Shipon Karmakar</a> · <a href="https://profiles.wordpress.org/shreya0shrivastava/">Shreya Shrivastava</a> · <a href="https://profiles.wordpress.org/iamshubhamsp/">Shubham Patil</a> · <a href="https://profiles.wordpress.org/shyamgadde/">Shyamsundar Gadde</a> · <a href="https://profiles.wordpress.org/sidharthpandita/">sidharthpandita</a> · <a href="https://profiles.wordpress.org/siliconforks/">siliconforks</a> · <a href="https://profiles.wordpress.org/shilpaashokan94/">Silpa TA</a> · <a href="https://profiles.wordpress.org/simonefontana/">simonefontana</a> · <a href="https://profiles.wordpress.org/slaffik/">Slava Abakumov</a> · <a href="https://profiles.wordpress.org/smerriman/">smerriman</a> · <a href="https://profiles.wordpress.org/snehapatil02/">Sneha Patil</a> · <a href="https://profiles.wordpress.org/maia12345/">Sophie Dimitrov</a> · <a href="https://profiles.wordpress.org/sourabhjain/">Sourabh Jain</a> · <a href="https://profiles.wordpress.org/sourav08/">Sourav Pahwa</a> · <a href="https://profiles.wordpress.org/soyebsalar01/">Soyeb Salar</a> · <a href="https://profiles.wordpress.org/spenserhale/">Spenser Hale</a> · <a href="https://profiles.wordpress.org/spstrap/">spstrap</a> · <a href="https://profiles.wordpress.org/srikat/">Sridhar Katakam</a> · <a href="https://profiles.wordpress.org/stankea/">stankea</a> · <a href="https://profiles.wordpress.org/metodiew/">Stanko Metodiev</a> · <a href="https://profiles.wordpress.org/staurand/">staurand</a> · <a href="https://profiles.wordpress.org/hubersen/">Stefan Pasch</a> · <a href="https://profiles.wordpress.org/stefanvelthuys/">Stefan Velthuys</a> · <a href="https://profiles.wordpress.org/sabernhardt/">Stephen Bernhardt</a> · <a href="https://profiles.wordpress.org/stephenharris/">Stephen Harris</a> · <a href="https://profiles.wordpress.org/dufresnesteven/">Steve Dufresne</a> · <a href="https://profiles.wordpress.org/strarsis/">strarsis</a> · <a href="https://profiles.wordpress.org/subrataemfluence/">Subrata Sarkar</a> · <a href="https://profiles.wordpress.org/sudipatel007/">Sudip Dadhaniya</a> · <a href="https://profiles.wordpress.org/sujansarkar/">Sujan Sarkar</a> · <a href="https://profiles.wordpress.org/sukhendu2002/">Sukhendu Sekhar Guria</a> · <a href="https://profiles.wordpress.org/sumitbagthariya16/">Sumit Bagthariya</a> · <a href="https://profiles.wordpress.org/sunil25393/">SunilPrajapati</a> · <a href="https://profiles.wordpress.org/sunnykasera/">sunnykasera</a> · <a href="https://profiles.wordpress.org/sunyatasattva/">sunyatasattva (a11n)</a> · <a href="https://profiles.wordpress.org/supernovia/">supernovia</a> · <a href="https://profiles.wordpress.org/suzukube/">SuzuKube</a> · <a href="https://profiles.wordpress.org/svedish/">svedish</a> · <a href="https://profiles.wordpress.org/lordspace/">Svetoslav Marinov</a> · <a href="https://profiles.wordpress.org/cybr/">Sybre Waaijer</a> · <a href="https://profiles.wordpress.org/syhussaini/">syhussaini</a> · <a href="https://profiles.wordpress.org/schwipps/">T4ng</a> · <a href="https://profiles.wordpress.org/tacoverdo/">Taco Verdonschot</a> · <a href="https://profiles.wordpress.org/iamtakashi/">Takashi Irie</a> · <a href="https://profiles.wordpress.org/takuword/">Takuro</a> · <a href="https://profiles.wordpress.org/karmatosed/">Tammie Lister</a> · <a href="https://profiles.wordpress.org/tatof/">tatof</a> · <a href="https://profiles.wordpress.org/tecnogaming/">tecnogaming</a> · <a href="https://profiles.wordpress.org/mecaota/">Tetsuro Higuchi</a> · <a href="https://profiles.wordpress.org/tharsheblows/">tharsheblows</a> · <a href="https://profiles.wordpress.org/thelmachido/">thelmachido a11n</a> · <a href="https://profiles.wordpress.org/tsquez/">ThemeAWESOME</a> · <a href="https://profiles.wordpress.org/themiked/">theMikeD</a> · <a href="https://profiles.wordpress.org/kraftner/">Thomas Kr&#228;ftner</a> · <a href="https://profiles.wordpress.org/tfrommen/">Thorsten Frommen</a> · <a href="https://profiles.wordpress.org/tillkruess/">Till Kr&#252;ss</a> · <a href="https://profiles.wordpress.org/timhavinga/">Tim Havinga</a> · <a href="https://profiles.wordpress.org/dontfeedthecode/">Tim Sheehan</a> · <a href="https://profiles.wordpress.org/timotijhof/">Timo Tijhof</a> · <a href="https://profiles.wordpress.org/spaceshipone/">Timoth&#233;e Brosille</a> · <a href="https://profiles.wordpress.org/timotheemoulin/">Timoth&#233;e Moulin</a> · <a href="https://profiles.wordpress.org/timothyblynjacobs/">Timothy Jacobs</a> · <a href="https://profiles.wordpress.org/tjarrett/">TJarrett</a> · <a href="https://profiles.wordpress.org/tobiasbg/">Tobias B&#228;thge</a> · <a href="https://profiles.wordpress.org/tz-media/">Tobias Zimpel</a> · <a href="https://profiles.wordpress.org/tobifjellner/">tobifjellner (Tor-Bjorn &#8220;Tobi&#8221; Fjellner)</a> · <a href="https://profiles.wordpress.org/tomdevisser/">Tom de Visser</a> · <a href="https://profiles.wordpress.org/tjnowell/">Tom J Nowell</a> · <a href="https://profiles.wordpress.org/shimotomoki/">Tomoki Shimomura</a> · <a href="https://profiles.wordpress.org/skithund/">Toni Viemer&#246;</a> · <a href="https://profiles.wordpress.org/hellofromtonya/">Tonya Mork</a> · <a href="https://profiles.wordpress.org/toro_unit/">Toro_Unit (Hiroshi Urabe)</a> · <a href="https://profiles.wordpress.org/zodiac1978/">Torsten Landsiedel</a> · <a href="https://profiles.wordpress.org/wpsmith/">Travis Smith</a> · <a href="https://profiles.wordpress.org/traxus/">traxus</a> · <a href="https://profiles.wordpress.org/sllimrovert/">Trevor Mills</a> · <a href="https://profiles.wordpress.org/tristanleboss/">tristanleboss</a> · <a href="https://profiles.wordpress.org/areziaal/">Troy Chaplin</a> · <a href="https://profiles.wordpress.org/truptikanzariya/">Trupti Kanzariya</a> · <a href="https://profiles.wordpress.org/tsteel/">tsteel</a> · <a href="https://profiles.wordpress.org/dinhtungdu/">Tung Du</a> · <a href="https://profiles.wordpress.org/tusharbharti/">Tushar Bharti</a> · <a href="https://profiles.wordpress.org/tusharaddweb/">Tushar Patel</a> · <a href="https://profiles.wordpress.org/tussendoor/">Tussendoor B.V.</a> · <a href="https://profiles.wordpress.org/ugyensupport/">Ugyen Dorji</a> · <a href="https://profiles.wordpress.org/umeshnevase/">Umesh Nevase</a> · <a href="https://profiles.wordpress.org/umeshsinghin/">Umesh Singh</a> · <a href="https://profiles.wordpress.org/unsalkorkmaz/">Unsal Korkmaz</a> · <a href="https://profiles.wordpress.org/upadalavipul/">upadalavipul</a> · <a href="https://profiles.wordpress.org/utsavladani/">Utsav Ladani</a> · <a href="https://profiles.wordpress.org/utsav72640/">Utsav tilava</a> · <a href="https://profiles.wordpress.org/valentingrenier/">Valentin Grenier</a> · <a href="https://profiles.wordpress.org/tsimshatsui/">Vape tsimshatsui</a> · <a href="https://profiles.wordpress.org/vbbp/">vbbp</a> · <a href="https://profiles.wordpress.org/sheldorofazeroth/">Vedansh Mishra</a> · <a href="https://profiles.wordpress.org/vevas/">Vegard S.</a> · <a href="https://profiles.wordpress.org/vgnavada/">vgnavada</a> · <a href="https://profiles.wordpress.org/vcanales/">Vicente Canales</a> · <a href="https://profiles.wordpress.org/vidugupta/">vidugupta</a> · <a href="https://profiles.wordpress.org/vijendrajat/">Vijendra Jat</a> · <a href="https://profiles.wordpress.org/szepeviktor/">Viktor Sz&#233;pe</a> · <a href="https://profiles.wordpress.org/vineet2003/">Vinit</a> · <a href="https://profiles.wordpress.org/ghorivipul97/">Vipul Ghori</a> · <a href="https://profiles.wordpress.org/vipulgupta003/">Vipul Gupta</a> · <a href="https://profiles.wordpress.org/vipulpatil/">Vipul Patil</a> · <a href="https://profiles.wordpress.org/vishitshah/">Vishit Shah</a> · <a href="https://profiles.wordpress.org/vladimiraus/">vladimiraus</a> · <a href="https://profiles.wordpress.org/vortfu/">vortfu</a> · <a href="https://profiles.wordpress.org/vrishabhsk/">Vrishabh Jasani</a> · <a href="https://profiles.wordpress.org/walterebert/">Walter Ebert</a> · <a href="https://profiles.wordpress.org/webmandesign/">WebMan Design &#124; Oliver Juhas</a> · <a href="https://profiles.wordpress.org/websupporter/">websupporter</a> · <a href="https://profiles.wordpress.org/webwrotter/">webwrotter</a> · <a href="https://profiles.wordpress.org/westonruter/">Weston Ruter</a> · <a href="https://profiles.wordpress.org/whaze/">whaze</a> · <a href="https://profiles.wordpress.org/widhy980/">widhy980</a> · <a href="https://profiles.wordpress.org/skorasaurus/">Will Skora</a> · <a href="https://profiles.wordpress.org/wplmillet/">wplmillet</a> · <a href="https://profiles.wordpress.org/xate/">xate</a> · <a href="https://profiles.wordpress.org/xavilc/">xavilc</a> · <a href="https://profiles.wordpress.org/xerpa43/">xerpa43</a> · <a href="https://profiles.wordpress.org/xipasduarte/">xipasduarte</a> · <a href="https://profiles.wordpress.org/yagniksangani/">Yagnik Sangani</a> · <a href="https://profiles.wordpress.org/yashyadav247/">Yash</a> · <a href="https://profiles.wordpress.org/getsyash/">Yash B</a> · <a href="https://profiles.wordpress.org/yashjawale/">Yash Jawale</a> · <a href="https://profiles.wordpress.org/yogeshbhutkar/">Yogesh Bhutkar</a> · <a href="https://profiles.wordpress.org/yogieanamcara/">YogieAnamCara</a> · <a href="https://profiles.wordpress.org/fierevere/">Yui</a> · <a href="https://profiles.wordpress.org/zebulan/">Zebulan Stanphill</a> · <a href="https://profiles.wordpress.org/zeelthakkar/">Zeel Thakkar</a> · <a href="https://profiles.wordpress.org/zunaid321/">Zunaid Amin</a> · <a href="https://profiles.wordpress.org/lstraczynski/">Łukasz Strączyński</a> · <a href="https://profiles.wordpress.org/haozi/">耗子</a></p>\n\n\n\n<p>More than <a href="https://translate.wordpress.org/stats/">71 locales have fully translated</a> WordPress 6.9 into their language. Community translators are working hard to ensure more translations are on their way. Thank you to everyone who helps make WordPress available in 200+ languages.</p>\n\n\n\n<p>Last but not least, thanks to the volunteers who contribute to the <a href="https://wordpress.org/support/forums/">support forums</a> by answering questions from WordPress users worldwide.</p>\n\n\n\n<h2 class="wp-block-heading"><strong>Get involved</strong></h2>\n\n\n\n<p>Participation in WordPress goes far beyond coding. And learning more and getting involved is easy.&nbsp; Discover the teams that come together to <a href="https://make.wordpress.org/">Make WordPress</a> and use <a href="https://make.wordpress.org/contribute/">this interactive tool</a> to help you decide which is right for you.</p>\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:30:"com-wordpress:feed-additions:1";a:1:{s:7:"post-id";a:1:{i:0;a:5:{s:4:"data";s:5:"19398";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:3;a:6:{s:4:"data";s:75:"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n		\n		\n		\n\n					\n										\n					\n		\n		\n			";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:4:{s:0:"";a:6:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:33:"WordPress 6.9 Release Candidate 3";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:69:"https://wordpress.org/news/2025/11/wordpress-6-9-release-candidate-3/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Tue, 25 Nov 2025 15:33:10 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:7:{i:0;a:5:{s:4:"data";s:11:"Development";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:1;a:5:{s:4:"data";s:7:"General";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:2;a:5:{s:4:"data";s:8:"Releases";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:3;a:5:{s:4:"data";s:3:"6.9";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:4;a:5:{s:4:"data";s:11:"development";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:5;a:5:{s:4:"data";s:18:"release candidates";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:6;a:5:{s:4:"data";s:8:"releases";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:35:"https://wordpress.org/news/?p=19373";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:366:"The third Release Candidate (“RC3”) for WordPress 6.9 is ready for download and testing! This version of the WordPress software is under development. Please do not install, run, or test this version of WordPress on production or mission-critical websites. Instead, it’s recommended that you evaluate RC3 on a test server and site. Reaching this phase [&#8230;]";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:10:"Amy Kamala";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:8039:"\n<p>The third Release Candidate (“RC3”) for WordPress 6.9 is ready for download and testing!</p>\n\n\n\n<p><strong>This version of the WordPress software is under development</strong>. <strong>Please do not install, run, or test this version of WordPress on production or mission-critical websites.</strong> Instead, it’s recommended that you evaluate RC3 on a test server and site.</p>\n\n\n\n<p>Reaching this phase of the release cycle is an important milestone. While release candidates are considered ready for release, testing remains crucial to ensure that everything in WordPress 6.9 is the highest quality possible.</p>\n\n\n\n<p>You can test WordPress 6.9 RC3 in four ways:</p>\n\n\n\n<figure class="wp-block-table"><table class="has-fixed-layout"><tbody><tr><td><strong>Plugin</strong></td><td>Install and activate the <a href="https://wordpress.org/plugins/wordpress-beta-tester/"></a><a href="https://wordpress.org/plugins/wordpress-beta-tester/">WordPress Beta Tester</a> plugin on a WordPress install. (Select the “Bleeding edge” channel and “Beta/RC Only” stream.)</td></tr><tr><td><strong>Direct Download</strong></td><td>Download the <a href="https://wordpress.org/wordpress-6.9-beta2.zip"></a><a href="https://wordpress.org/wordpress-6.9-RC3.zip">RC3 version (zip)</a>. and install it on a WordPress website.</td></tr><tr><td><strong>Command Line</strong></td><td>Use this <a href="https://make.wordpress.org/cli/">WP-CLI</a> command: <br><code>wp core update --version=6.9-RC3</code></td></tr><tr><td><strong>WordPress Playground</strong></td><td>Use the <a href="https://playground.wordpress.net/?php=8.0&amp;wp=beta&amp;networking=no&amp;language=&amp;multisite=no&amp;random=y4q1rn85xn">6.9 WordPress Playground instance</a> to test the software directly in your browser.&nbsp; No setup is required – just click and go!&nbsp;</td></tr></tbody></table></figure>\n\n\n\n<p>The scheduled final release date for WordPress 6.9 is <strong>December 2, 2025</strong>. The full <a href="https://make.wordpress.org/core/6-9/">release schedule can be found here</a>. Your help testing RC versions is vital to making this release as stable and powerful as possible.</p>\n\n\n\n<p>Please continue checking the <a href="https://make.wordpress.org/core/">Make WordPress Core blog</a> for <a href="https://make.wordpress.org/core/tag/6-9/">6.9-related posts</a> in the coming weeks for more information.</p>\n\n\n\n<h2 class="wp-block-heading">What’s in WordPress 6.9 RC3?</h2>\n\n\n\n<p>Want to look deeper into the details and technical notes for this release? Take a look at the <a href="https://make.wordpress.org/core/2025/11/25/wordpress-6-9-field-guide">WordPress 6.9 Field Guide</a>. For technical information related to issues addressed since <a href="https://wordpress.org/news/2025/11/wordpress-6-9-release-candidate-2">RC2</a>, you can browse the following links:</p>\n\n\n\n<ul class="wp-block-list">\n<li><a href="https://github.com/WordPress/gutenberg/commits/wp/6.9?since=2025-11-18&amp;until=2025-11-25">Gutenberg commits for 6.9</a> since November 18</li>\n\n\n\n<li><a href="https://core.trac.wordpress.org/query?status=closed&amp;changetime=11%2F18%2F2025..11%2F24%2F2025&amp;milestone=6.9&amp;group=component&amp;col=id&amp;col=summary&amp;col=milestone&amp;col=changetime&amp;col=type&amp;order=id">Closed WordPress Core Trac tickets</a> since November 18</li>\n</ul>\n\n\n\n<h2 class="wp-block-heading">How you can contribute</h2>\n\n\n\n<p>WordPress is open source software made possible by a passionate community of people collaborating on and contributing to its development. The resources below outline various ways you can get involved with the world’s most popular open source web platform, regardless of your technical expertise.</p>\n\n\n\n<h3 class="wp-block-heading">Get involved in testing</h3>\n\n\n\n<p>Testing for issues is crucial to the development of any software. It’s also a meaningful way for anyone to contribute.&nbsp;</p>\n\n\n\n<p>Your help testing the WordPress 6.9 RC3 prerelease is key to ensuring that the final release is the best it can be. While testing the upgrade process is essential, trying out new features is equally important. This <a href="https://make.wordpress.org/test/2025/10/21/help-test-wordpress-6-9/">detailed guide</a> will walk you through testing features in WordPress 6.9. For those new to testing, follow <a href="https://make.wordpress.org/test/handbook/get-setup-for-testing/">this general testing guide</a> for more details on getting set up.</p>\n\n\n\n<p>If you encounter an issue, please report it to the <a href="https://wordpress.org/support/forum/alphabeta/">Alpha/Beta/RC area</a> of the support forums or directly to <a href="https://core.trac.wordpress.org/newticket">WordPress Trac</a> if you are comfortable writing a reproducible bug report. You can also check your issue against a list of <a href="https://core.trac.wordpress.org/tickets/major">known bugs</a>.</p>\n\n\n\n<p>Curious about testing releases in general?&nbsp; Follow along with the <a href="https://make.wordpress.org/test/">testing initiatives in Make Core</a> and join the <a href="https://wordpress.slack.com/messages/core-test/">#core-test channel</a> on <a href="https://wordpress.slack.com/"></a><a href="https://make.wordpress.org/chat/">Making WordPress Slack</a>..</p>\n\n\n\n<h3 class="wp-block-heading">Update your theme or plugin</h3>\n\n\n\n<p>For plugin and theme authors, your products play an integral role in extending the functionality and value of WordPress for all users.</p>\n\n\n\n<p>Thanks for continuing to test your themes and plugins with the WordPress 6.9 prereleases. If you haven’t yet, please conclude your testing and update the <em>“Tested up to”</em> version in your theme and plugin <a href="https://developer.wordpress.org/plugins/wordpress-org/how-your-readme-txt-works/">readme files</a> to <code>6.9</code>.</p>\n\n\n\n<p>If you find compatibility issues, please post detailed information in the <a href="https://wordpress.org/support/forum/alphabeta/">support forum</a>.</p>\n\n\n\n<h3 class="wp-block-heading">Test on your hosting platforms</h3>\n\n\n\n<p>Web hosts provide vital infrastructure for supporting WordPress and its users. Testing on hosting systems helps inform the development process while ensuring that WordPress and hosting platforms are fully compatible, free of errors, optimized for the best possible user experience, and that updates roll out to customer sites without issue.</p>\n\n\n\n<p>Want to test WordPress on your hosting system? <a href="https://make.wordpress.org/hosting/test-results-getting-started/">Get started with configuring distributed hosting tests here</a>.&nbsp;</p>\n\n\n\n<h3 class="wp-block-heading">Help translate WordPress</h3>\n\n\n\n<p>Do you speak a language other than English? ¿Español? Français? Русский? 日本語? हिन्दी? বাংলা? मराठी? ಕನ್ನಡ?&nbsp;You can <a href="https://translate.wordpress.org/projects/wp/dev/">help translate WordPress into more than 100 languages</a>.</p>\n\n\n\n<h2 class="wp-block-heading">An RC3 haiku</h2>\n\n\n\n<p><em>Some folks make money,</em></p>\n\n\n\n<p><em>some folks make time to travel,</em></p>\n\n\n\n<p><em>and we Make WordPress.</em></p>\n\n\n\n<p class="has-text-align-right"><em>Props to </em><a href=\'https://profiles.wordpress.org/akshayar/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>akshayar</a>, <a href=\'https://profiles.wordpress.org/davidbaumwald/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>davidbaumwald</a>, <a href=\'https://profiles.wordpress.org/westonruter/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>westonruter</a>, <a href=\'https://profiles.wordpress.org/ellatrix/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>ellatrix</a>, <a href=\'https://profiles.wordpress.org/mobarak/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>mobarak</a> <em>and</em> <a href=\'https://profiles.wordpress.org/tacoverdo/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>tacoverdo</a> <em>for proofreading and review.</em></p>\n\n\n\n<p></p>\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:30:"com-wordpress:feed-additions:1";a:1:{s:7:"post-id";a:1:{i:0;a:5:{s:4:"data";s:5:"19373";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:4;a:6:{s:4:"data";s:69:"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n		\n\n					\n										\n					\n		\n		\n			";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:4:{s:0:"";a:6:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:33:"WordPress 6.9 Release Candidate 2";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:69:"https://wordpress.org/news/2025/11/wordpress-6-9-release-candidate-2/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Tue, 18 Nov 2025 15:26:53 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:5:{i:0;a:5:{s:4:"data";s:11:"Development";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:1;a:5:{s:4:"data";s:7:"General";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:2;a:5:{s:4:"data";s:8:"Releases";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:3;a:5:{s:4:"data";s:3:"6.9";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:4;a:5:{s:4:"data";s:7:"release";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:35:"https://wordpress.org/news/?p=19350";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:367:"The second Release Candidate (“RC2”) for WordPress 6.9 is ready for download and testing! This version of the WordPress software is under development. Please do not install, run, or test this version of WordPress on production or mission-critical websites. Instead, it’s recommended that you evaluate RC2 on a test server and site. Reaching this phase [&#8230;]";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:12:"Akshaya Rane";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:10595:"\n<p>The second Release Candidate (“RC2”) for WordPress 6.9 is ready for download and testing!</p>\n\n\n\n<p><strong>This version of the WordPress software is under development</strong>.<strong> Please do not install, run, or test this version of WordPress on production or mission-critical websites.</strong> Instead, it’s recommended that you evaluate RC2 on a test server and site.</p>\n\n\n\n<p>Reaching this phase of the release cycle is an important milestone. While release candidates are considered ready for release, testing remains crucial to ensure that everything in WordPress 6.9 is the best it can be.</p>\n\n\n\n<p>You can test WordPress 6.9 RC2 in four ways:</p>\n\n\n\n<figure class="wp-block-table"><table class="has-fixed-layout"><tbody><tr><td><strong>Plugin</strong></td><td>Install and activate the <a href="https://wordpress.org/plugins/wordpress-beta-tester/">WordPress Beta Tester</a> plugin on a WordPress install. (Select the “Bleeding edge” channel and “Beta/RC Only” stream).</td></tr><tr><td><strong>Direct Download</strong></td><td>Download the <a href="https://wordpress.org/wordpress-6.9-RC2.zip">RC2 version (zip)</a> and install it on a WordPress website.</td></tr><tr><td><strong>Command Line</strong></td><td>Use the following <a href="https://make.wordpress.org/cli/">WP-CLI</a> command:<br><code>wp core update --version=6.9-RC2</code></td></tr><tr><td><strong>WordPress Playground</strong></td><td>Use the <a href="https://playground.wordpress.net/?php=8.0&amp;wp=beta&amp;networking=no&amp;language=&amp;multisite=no&amp;random=y4q1rn85xn">6.9 RC2 WordPress Playground instance</a> to test the software directly in your browser without the need for a separate site or setup.</td></tr></tbody></table></figure>\n\n\n\n<p>The scheduled final release date for WordPress 6.9 is <strong>December 2, 2025</strong>. The full <a href="https://make.wordpress.org/core/6-9/">release schedule can be found here</a>. Your help testing RC versions is vital to making this release as stable and powerful as possible.</p>\n\n\n\n<p>Please continue checking the <a href="https://make.wordpress.org/core/">Make WordPress Core blog</a> for <a href="https://make.wordpress.org/core/tag/6-9/">6.9-related posts</a> in the coming weeks for more information.</p>\n\n\n\n<h2 class="wp-block-heading">What’s in WordPress 6.9 RC2?</h2>\n\n\n\n<p>Get a recap of WordPress 6.9’s highlighted features in the <a href="https://make.wordpress.org/core/2025/10/21/wordpress-6-9-beta-1/">Beta 1 announcement</a>. For more technical information related to issues addressed since RC1, you can browse the following links:</p>\n\n\n\n<ul class="wp-block-list">\n<li><a href="https://github.com/WordPress/gutenberg/commits/wp/6.9?since=2025-11-11&amp;until=2025-11-18">GitHub commits for 6.9</a> since November 11</li>\n\n\n\n<li><a href="https://core.trac.wordpress.org/query?status=closed&amp;changetime=11%2F11%2F2025..11%2F18%2F2025&amp;milestone=6.9&amp;group=component&amp;col=id&amp;col=summary&amp;col=milestone&amp;col=changetime&amp;col=type&amp;order=id">Closed Trac tickets</a> since November 11</li>\n</ul>\n\n\n\n<p>Want to look deeper into the details and technical notes for this release? These recent posts cover some of the latest updates:</p>\n\n\n\n<ul class="wp-block-list">\n<li><a href="https://make.wordpress.org/core/2025/11/15/notes-feature-in-wordpress-6-9/" target="_blank" rel="noreferrer noopener">Notes Feature in 6.9</a></li>\n\n\n\n<li><a href="https://make.wordpress.org/core/2025/11/10/abilities-api-in-wordpress-6-9/" target="_blank" rel="noreferrer noopener">Abilities API in WordPress 6.9</a></li>\n\n\n\n<li><a href="https://make.wordpress.org/core/2025/11/18/wordpress-6-9-frontend-performance-field-guide/">WordPress 6.9 Frontend Performance Field Guide</a></li>\n\n\n\n<li><a href="https://make.wordpress.org/core/2025/11/12/interactivity-apis-client-navigation-improvements-in-wordpress-6-9/" target="_blank" rel="noreferrer noopener">Interactivity API’s client navigation improvements in WordPress 6.9</a></li>\n\n\n\n<li><a href="https://make.wordpress.org/core/2025/11/12/block-bindings-improvements-in-wordpress-6-9/" target="_blank" rel="noreferrer noopener">Block Bindings improvements in WordPress 6.9</a></li>\n\n\n\n<li><a href="https://make.wordpress.org/core/2025/11/12/changes-to-the-interactivity-api-in-wordpress-6-9/" target="_blank" rel="noreferrer noopener">Changes to the Interactivity API in WordPress 6.9</a></li>\n\n\n\n<li><a href="https://make.wordpress.org/core/2025/11/17/consistent-cache-keys-for-query-groups-in-wordpress-6-9/">Consistent Cache Keys for Query Groups in WordPress 6.9</a></li>\n\n\n\n<li><a href="https://make.wordpress.org/core/2025/11/11/dataviews-dataform-et-al-in-wordpress-6-9/" target="_blank" rel="noreferrer noopener">DataViews, DataForm, et al. in WordPress 6.9</a></li>\n\n\n\n<li><a href="https://make.wordpress.org/core/2025/11/12/preparing-the-post-editor-for-full-iframe-integration/" target="_blank" rel="noreferrer noopener">Preparing the Post Editor for Full iframe Integration</a></li>\n\n\n\n<li><a href="https://make.wordpress.org/core/2025/11/12/theme-json-border-radius-presets-support-in-wordpress-6-9/" target="_blank" rel="noreferrer noopener">Theme.json Border Radius Presets Support in WordPress 6.9</a></li>\n\n\n\n<li><a href="https://make.wordpress.org/core/2025/11/12/heading-block-css-specificity-fix-in-wordpress-6-9/" target="_blank" rel="noreferrer noopener">Heading Block CSS Specificity Fix in WordPress 6.9</a></li>\n\n\n\n<li><a href="https://make.wordpress.org/core/2025/11/17/miscellaneous-developer-focused-changes-in-6-9/">Miscellaneous Developer-focused Changes in 6.9</a></li>\n\n\n\n<li><a href="https://make.wordpress.org/core/2025/11/18/modernizing-utf-8-support-in-wordpress-6-9/" data-type="link" data-id="https://make.wordpress.org/core/2025/11/18/modernizing-utf-8-support-in-wordpress-6-9/">Modernizing UTF-8 support in WordPress 6.9</a></li>\n</ul>\n\n\n\n<h2 class="wp-block-heading">How you can contribute</h2>\n\n\n\n<p>WordPress is open source software made possible by a passionate community of people collaborating on and contributing to its development. The resources below outline various ways you can help the world’s most popular open source web platform, regardless of your technical expertise.</p>\n\n\n\n<h2 class="wp-block-heading">Get involved in testing</h2>\n\n\n\n<p>Testing for issues is crucial to the development of any software. It’s also a meaningful way for anyone to contribute.&nbsp;</p>\n\n\n\n<p>Your help testing the WordPress 6.9 RC2 version is key to ensuring that the final release is the best it can be. While testing the upgrade process is essential, trying out new features is equally important. This <a href="https://make.wordpress.org/test/2025/10/21/help-test-wordpress-6-9/">detailed guide</a> will walk you through testing features in WordPress 6.9. For those new to testing, follow <a href="https://make.wordpress.org/test/handbook/get-setup-for-testing/">this general testing guide</a> for more details on getting set up.</p>\n\n\n\n<p>If you encounter an issue, please report it to the <a href="https://wordpress.org/support/forum/alphabeta/">Alpha/Beta area</a> of the support forums or directly to <a href="https://core.trac.wordpress.org/newticket">WordPress Trac</a> if you are comfortable writing a reproducible bug report.&nbsp; You can also check your issue against a list of <a href="https://core.trac.wordpress.org/tickets/major">known bugs</a>.&nbsp;</p>\n\n\n\n<p>Curious about testing releases in general?&nbsp; Follow along with the <a href="https://make.wordpress.org/test/">testing initiatives in Make Core</a> and join the<a href="https://wordpress.slack.com/messages/core-test/">#core-test channel</a> on <a href="https://wordpress.slack.com/">Making WordPress Slack</a>.</p>\n\n\n\n<h2 class="wp-block-heading">Update your theme or plugin</h2>\n\n\n\n<p>For plugin and theme authors, your products play an integral role in extending the functionality and value of WordPress for all users.</p>\n\n\n\n<p>Thanks for continuing to test your themes and plugins with the WordPress 6.9 beta releases. If you haven’t yet, make sure to conclude your testing and update the <em>“Tested up to”</em> version in your <a href="https://developer.wordpress.org/plugins/wordpress-org/how-your-readme-txt-works/">plugin’s readme file</a> to 6.9.</p>\n\n\n\n<p>If you find compatibility issues, please post detailed information to the <a href="https://wordpress.org/support/forum/alphabeta/">support forum</a>.</p>\n\n\n\n<h2 class="wp-block-heading">Test on your hosting platforms</h2>\n\n\n\n<p>Web hosts provide vital infrastructure for supporting WordPress and its users. Testing on hosting systems helps inform the development process while ensuring that WordPress and hosting platforms are fully compatible, free of errors, optimized for the best possible user experience, and that updates roll out to customer sites without issue.</p>\n\n\n\n<p>Want to test WordPress on your hosting system? <a href="https://make.wordpress.org/hosting/test-results-getting-started/">Get started with configuring distributed hosting tests here</a>.</p>\n\n\n\n<h2 class="wp-block-heading">Help translate WordPress</h2>\n\n\n\n<p>Do you speak a language other than English? ¿Español? Français? Русский? 日本語? हिन्दी? বাংলা? मराठी? ಕನ್ನಡ?&nbsp; You can<a href="https://translate.wordpress.org/projects/wp/dev/"> help translate WordPress into more than 100 languages</a>. This release milestone (RC2) also marks the<a href="https://make.wordpress.org/polyglots/handbook/glossary/#hard-freeze"> hard string freeze</a> point of the <a href="https://make.wordpress.org/core/2025/11/11/wordpress-6-9-release-candidate-phase/">6.9 release cycle</a>.</p>\n\n\n\n<h2 class="wp-block-heading">An RC2 haiku</h2>\n\n\n\n<p>A calm hillside sighs,<br>Work of many now complete —<br>RC2 stays true.</p>\n\n\n\n<p class="has-text-align-right"><em>Props to <a href=\'https://profiles.wordpress.org/amykamala/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>amykamala</a>, <a href=\'https://profiles.wordpress.org/annezazu/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>annezazu</a>, <a href=\'https://profiles.wordpress.org/davidbaumwald/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>davidbaumwald</a>, <a href=\'https://profiles.wordpress.org/westonruter/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>westonruter</a> and <a href=\'https://profiles.wordpress.org/joedolson/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>joedolson</a> for proofreading and review.</em></p>\n\n\n\n<p></p>\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:30:"com-wordpress:feed-additions:1";a:1:{s:7:"post-id";a:1:{i:0;a:5:{s:4:"data";s:5:"19350";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:5;a:6:{s:4:"data";s:75:"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n		\n		\n		\n\n					\n										\n					\n		\n		\n			";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:4:{s:0:"";a:6:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:33:"WordPress 6.9 Release Candidate 1";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:69:"https://wordpress.org/news/2025/11/wordpress-6-9-release-candidate-1/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Tue, 11 Nov 2025 15:34:48 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:7:{i:0;a:5:{s:4:"data";s:11:"Development";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:1;a:5:{s:4:"data";s:7:"General";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:2;a:5:{s:4:"data";s:8:"Releases";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:3;a:5:{s:4:"data";s:3:"6.9";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:4;a:5:{s:4:"data";s:11:"development";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:5;a:5:{s:4:"data";s:18:"release candidates";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:6;a:5:{s:4:"data";s:8:"releases";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:35:"https://wordpress.org/news/?p=19317";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:364:"The first Release Candidate (“RC1”) for WordPress 6.9 is ready for download and testing! This version of the WordPress software is still under development. Please do not install, run, or test this version of WordPress on production or mission-critical websites. Instead, it’s recommended to evaluate RC1 on a test server and site. WordPress 6.9 RC1 [&#8230;]";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:10:"Amy Kamala";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:9479:"\n<p>The first Release Candidate (“RC1”) for WordPress 6.9 is ready for download and testing!</p>\n\n\n\n<p><strong>This version of the WordPress software is still under development</strong>. Please do not install, run, or test this version of WordPress on production or mission-critical websites. Instead, it’s recommended to evaluate RC1 on a test server and site.</p>\n\n\n\n<p>WordPress 6.9 RC1 can be tested using any of the following methods:</p>\n\n\n\n<figure class="wp-block-table"><table class="has-fixed-layout"><tbody><tr><td><strong>Plugin</strong></td><td>Install and activate the <a href="https://wordpress.org/plugins/wordpress-beta-tester/">WordPress Beta Tester</a> plugin on a WordPress install. (Select the “Bleeding edge” channel and “Beta/RC Only” stream.)</td></tr><tr><td><strong>Direct Download</strong></td><td>Download the <a href="https://wordpress.org/wordpress-6.9-RC1.zip">RC1 version (zip)</a> and install it on a WordPress website.</td></tr><tr><td><strong>Command Line</strong></td><td>Use this <a href="https://make.wordpress.org/cli/">WP-CLI</a> command: <br><code>wp core update --version=6.9-RC1</code></td></tr><tr><td><strong>WordPress Playground</strong></td><td>Use the <a href="https://playground.wordpress.net/?php=8.3&amp;wp=beta&amp;networking=no&amp;language=&amp;multisite=no&amp;random=y4q1rn88xn" data-type="link" data-id="https://playground.wordpress.net/?php=8.3&amp;wp=rc&amp;networking=no&amp;language=&amp;multisite=no&amp;random=y4q1rn88xn">6.9 RC1 WordPress Playground instance</a> to test the software directly in your browser. No setup is required &#8211; just click and go! </td></tr></tbody></table></figure>\n\n\n\n<p>The scheduled final release date for WordPress 6.9 is <strong>December 2, 2025</strong>. The full <a href="https://make.wordpress.org/core/6-9/">release schedule can be found here</a>. Your help testing Beta and RC versions is vital to making this release as stable and powerful as possible.</p>\n\n\n\n<p>Please continue checking the <a href="https://make.wordpress.org/core/">Make WordPress Core blog</a> for <a href="https://make.wordpress.org/core/tag/6-9/">6.9-related posts</a> in the coming weeks for more information.</p>\n\n\n\n<h2 class="wp-block-heading">What’s in WordPress 6.9 RC1?</h2>\n\n\n\n<p>Check out the <a href="https://make.wordpress.org/core/2025/10/21/wordpress-6-9-beta-1/">Beta 1 announcement</a> for details on WordPress 6.9.</p>\n\n\n\n<p>You can browse the technical details for all issues addressed since Beta 4 using these links:</p>\n\n\n\n<ul class="wp-block-list">\n<li><a href="https://github.com/WordPress/gutenberg/commits/wp/6.9?since=2025-11-07&amp;until=2025-11-11">Gutenberg commits for 6.9</a> since November 7, 2025</li>\n\n\n\n<li><a href="https://core.trac.wordpress.org/log/?revs=61183-61203">Core commits for 6.9</a> since November 7, 2025</li>\n\n\n\n<li><a href="https://core.trac.wordpress.org/query?status=closed&amp;changetime=11%2F07%2F2025..11%2F11%2F2025&amp;milestone=6.9&amp;group=component&amp;col=id&amp;col=summary&amp;col=milestone&amp;col=changetime&amp;col=type&amp;order=id">Closed Trac tickets</a> since November 7, 2025</li>\n</ul>\n\n\n\n<p>Want to know more about this release? Here are some highlights:</p>\n\n\n\n<ul class="wp-block-list">\n<li>Site Editor improvements and Refined content creation\n<ul class="wp-block-list">\n<li>Ability to hide blocks</li>\n\n\n\n<li>New blocks </li>\n\n\n\n<li>Notes on blocks</li>\n\n\n\n<li>Universal command palette in wp-admin</li>\n</ul>\n</li>\n\n\n\n<li>Developer updates\n<ul class="wp-block-list">\n<li>Updates to dataviews and dataforms components</li>\n\n\n\n<li>New abilities API</li>\n\n\n\n<li>Updates to interactivity API </li>\n\n\n\n<li>Updates to block binding API</li>\n</ul>\n</li>\n\n\n\n<li>Performance Improvements\n<ul class="wp-block-list">\n<li>Improved script and style handling</li>\n\n\n\n<li>Optimized queries and caching</li>\n\n\n\n<li>Added ability to handle “fetchpriority” in ES Modules and Import Maps</li>\n\n\n\n<li>Standardizing output buffering</li>\n</ul>\n</li>\n</ul>\n\n\n\n<p>The final release is on track for December 2nd. As always, a successful release depends on your confirmation during testing. So please download and test!</p>\n\n\n\n<h2 class="wp-block-heading">How you can contribute</h2>\n\n\n\n<p>WordPress is open source software made possible by a passionate community of people collaborating on and contributing to its development. The resources below outline various ways you can help the world’s most popular open source web platform, regardless of your technical expertise.</p>\n\n\n\n<h3 class="wp-block-heading">Get involved in testing</h3>\n\n\n\n<p>Testing for issues is crucial to the development of any software. It’s also a meaningful way for anyone to contribute. </p>\n\n\n\n<p>Your help testing the WordPress 6.9 RC1 version is key to ensuring that the final release is the best it can be. While testing the upgrade process is essential, trying out new features is equally important. This <a href="https://make.wordpress.org/test/2025/10/21/help-test-wordpress-6-9/">detailed guide</a> will walk you through testing features in WordPress 6.9.</p>\n\n\n\n<h4 class="wp-block-heading">Calls for testing</h4>\n\n\n\n<p>Thank you to everyone who helps test the following enhancements and bug fixes:</p>\n\n\n\n<ul class="wp-block-list">\n<li><a href="https://make.wordpress.org/test/2025/10/06/call-for-testing-accordion-block/">Accordion Block</a></li>\n\n\n\n<li><a href="https://make.wordpress.org/test/2025/10/04/call-for-testing-ability-to-hide-blocks/">Ability to Hide Blocks</a></li>\n\n\n\n<li><a href="https://core.trac.wordpress.org/ticket/64099">Classic themes loading block styles on demand</a></li>\n\n\n\n<li><a href="https://core.trac.wordpress.org/ticket/64204">Modified notes notifications</a></li>\n\n\n\n<li><a href="https://make.wordpress.org/core/2025/11/10/abilities-api-in-wordpress-6-9/">Abilities API</a></li>\n</ul>\n\n\n\n<p>If you encounter an issue, please report it to the <a href="https://wordpress.org/support/forum/alphabeta/">Alpha/Beta area</a> of the support forums, or directly to <a href="https://core.trac.wordpress.org/newticket">WordPress Trac</a> if you are comfortable writing a reproducible bug report. You can also check your issue against a list of <a href="https://core.trac.wordpress.org/tickets/major">known bugs</a>.</p>\n\n\n\n<p>Thank you to everyone who helps with testing!</p>\n\n\n\n<h3 class="wp-block-heading">Update your theme or plugin</h3>\n\n\n\n<p>For plugin and theme authors, your products play an integral role in extending the functionality and value of WordPress for all users.</p>\n\n\n\n<p>Thanks for continuing to test your themes and plugins with the WordPress 6.9 beta releases. With RC1, you’ll want to conclude your testing and update the <em>“Tested up to”</em> version in your <a href="https://developer.wordpress.org/plugins/wordpress-org/how-your-readme-txt-works/">plugin’s readme file</a> to 6.9. </p>\n\n\n\n<p>If you find compatibility issues, please post detailed information to the <a href="https://wordpress.org/support/forum/alphabeta/">support forum</a>.</p>\n\n\n\n<h3 class="wp-block-heading">Test on your hosting platforms</h3>\n\n\n\n<p>Web hosts provide vital infrastructure for supporting WordPress and its users. Testing on hosting systems helps inform the development process while ensuring that WordPress and hosting platforms are fully compatible, free of errors, optimized for the best possible user experience, and that updates roll out to customer sites without issue.</p>\n\n\n\n<p>Want to test WordPress on your hosting system? <a href="https://make.wordpress.org/hosting/test-results-getting-started/">Get started with configuring distributed hosting tests here</a>. Thank you to all <a href="https://make.wordpress.org/hosting/test-results/">web hosts who help test WordPress</a>!</p>\n\n\n\n<p>Curious about testing releases in general? Follow along with the <a href="https://make.wordpress.org/test/">testing initiatives in Make Core</a> and join the <a href="https://wordpress.slack.com/messages/core-test/">#core-test channel</a> on <a href="https://wordpress.slack.com/">Making WordPress Slack</a>.</p>\n\n\n\n<h2 class="wp-block-heading">An RC1 haiku</h2>\n\n\n\n<p><em>As the sun rises</em>,</p>\n\n\n\n<p><em>RC1 breaks its cocoon</em></p>\n\n\n\n<p><em>and emerges strong</em>.</p>\n\n\n\n<p class="has-text-align-right"><em>Props to </em><a href=\'https://profiles.wordpress.org/akshayar/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>akshayar</a><em>, </em><a href=\'https://profiles.wordpress.org/davidbaumwald/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>davidbaumwald</a>, <a href=\'https://profiles.wordpress.org/jeffpaul/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>jeffpaul</a>, <a href=\'https://profiles.wordpress.org/desrosj/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>desrosj</a>, <a href=\'https://profiles.wordpress.org/westonruter/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>westonruter</a>, <a href=\'https://profiles.wordpress.org/ellatrix/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>ellatrix</a>, <a href=\'https://profiles.wordpress.org/priethor/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>priethor</a>, <a href=\'https://profiles.wordpress.org/krupajnanda/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>krupajnanda</a> <em>and</em> <a href=\'https://profiles.wordpress.org/cbravobernal/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>cbravobernal</a> <em>for proofreading and review.</em></p>\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:30:"com-wordpress:feed-additions:1";a:1:{s:7:"post-id";a:1:{i:0;a:5:{s:4:"data";s:5:"19317";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:6;a:6:{s:4:"data";s:72:"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n		\n		\n\n					\n										\n					\n		\n		\n			";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:4:{s:0:"";a:6:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:20:"WordPress 6.9 Beta 3";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:56:"https://wordpress.org/news/2025/11/wordpress-6-9-beta-3/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Tue, 04 Nov 2025 15:34:27 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:6:{i:0;a:5:{s:4:"data";s:11:"Development";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:1;a:5:{s:4:"data";s:7:"General";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:2;a:5:{s:4:"data";s:8:"Releases";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:3;a:5:{s:4:"data";s:3:"6.9";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:4;a:5:{s:4:"data";s:11:"development";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:5;a:5:{s:4:"data";s:7:"release";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:35:"https://wordpress.org/news/?p=19263";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:347:"WordPress 6.9 Beta 3 is available for download and testing! This beta version of the WordPress software is still under development. Please don&#8217;t install, run, or test this version of WordPress on production or mission-critical websites. Instead, you can evaluate Beta 3 on a test server and site. WordPress 6.9 Beta 3 can be tested [&#8230;]";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:10:"Amy Kamala";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:5454:"\n<p>WordPress 6.9 Beta 3 is available for download and testing!</p>\n\n\n\n<p><strong>This beta version of the WordPress software is still under development</strong>. Please don&#8217;t install, run, or test this version of WordPress on production or mission-critical websites. Instead, you can evaluate Beta 3 on a test server and site.</p>\n\n\n\n<p>WordPress 6.9 Beta 3 can be tested using any of the following methods:</p>\n\n\n\n<figure class="wp-block-table"><table class="has-fixed-layout"><tbody><tr><td><strong>Plugin</strong></td><td>Install and activate the<a href="https://wordpress.org/plugins/wordpress-beta-tester/"> WordPress Beta Tester</a> plugin on a WordPress install. (Select the “Bleeding edge” channel and “Beta/RC Only” stream.)</td></tr><tr><td><strong>Direct Download</strong></td><td>Download the <a href="https://wordpress.org/wordpress-6.9-beta3.zip">Beta 3 version (zip)</a> and install it on a WordPress website.</td></tr><tr><td><strong>Command Line</strong></td><td>Use this<a href="https://make.wordpress.org/cli/"> WP-CLI</a> command: <br><code>wp core update --version=6.9-beta3</code></td></tr><tr><td><strong>WordPress Playground</strong></td><td>Use the <a href="https://playground.wordpress.net/?php=8.0&amp;wp=beta&amp;networking=no&amp;language=&amp;multisite=no&amp;random=y4q1rn88xn">6.9 Beta 3 WordPress Playground instance</a> to test the software directly in your browser.&nbsp; No setup is required – just click and go!&nbsp;</td></tr></tbody></table></figure>\n\n\n\n<p></p>\n\n\n\n<p>The final release of WordPress 6.9 is scheduled for <strong>December 2, 2025</strong>, and the <a href="https://make.wordpress.org/core/6-9/">release schedule can be found here</a>. Your help testing Beta and RC versions is vital to making this release as stable and powerful as possible. Thank you to everyone who helps with testing!</p>\n\n\n\n<p>Please continue checking the <a href="https://make.wordpress.org/core/">Make WordPress Core blog</a> for <a href="https://make.wordpress.org/core/tag/6-9/">6.9-related posts</a> in the coming weeks for more information.</p>\n\n\n\n<p><strong>Find out what’s new in WordPress 6.9</strong>: Read the <a href="https://make.wordpress.org/core/2025/10/21/wordpress-6-9-beta-1/">Beta 1 announcement</a> for details and highlights.</p>\n\n\n\n<h2 class="wp-block-heading">How to test this release</h2>\n\n\n\n<p>Your help testing the WordPress 6.9 Beta 3 version is key to ensuring that everything in the release is the best it can be. While testing the upgrade process is essential, trying out new features is equally as important. This <a href="https://make.wordpress.org/test/2025/10/21/help-test-wordpress-6-9/">detailed guide</a> provides a walk through on testing features in WordPress 6.9.</p>\n\n\n\n<p>If you encounter an issue, please report it to the <a href="https://wordpress.org/support/forum/alphabeta/">Alpha/Beta area</a> of the support forums, or directly to <a href="https://core.trac.wordpress.org/newticket">WordPress Trac</a> if you are comfortable writing a reproducible bug report. You can also check your issue against a list of <a href="https://core.trac.wordpress.org/tickets/major">known bugs</a>.</p>\n\n\n\n<p>Curious about testing releases in general? Follow along with the <a href="https://make.wordpress.org/test/">testing initiatives in Make Core</a> and join the<a href="https://wordpress.slack.com/messages/core-test/"> #core-test channel</a> on<a href="https://wordpress.slack.com/"> Making WordPress Slack</a>.</p>\n\n\n\n<h2 class="wp-block-heading">Beta 3 updates and highlights</h2>\n\n\n\n<p>WordPress 6.9 Beta 3 contains more than 80 updates and fixes since the Beta 2 release.</p>\n\n\n\n<p>Each beta cycle focuses on bug fixes, and more are on the way with your testing! You can browse the technical details for all issues addressed since Beta 2 using these links:</p>\n\n\n\n<ul class="wp-block-list">\n<li><a href="https://github.com/WordPress/gutenberg/commits/wp/6.9?since=2025-10-28&amp;until=2025-11-04">Gutenberg commits for 6.9</a> since October 28, 2025</li>\n\n\n\n<li><a href="https://core.trac.wordpress.org/query?status=closed&amp;changetime=10%2F28%2F2025..11%2F04%2F2025&amp;milestone=6.9&amp;col=id&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=id">Closed Core Trac tickets for 6.9</a> since October 28, 2025</li>\n\n\n\n<li><a href="https://github.com/WordPress/wordpress-develop/compare/7dcb09c26a1d97c20dcceb866abbd0f3c128388b...81f755846c2d66ce7d21b01623f8163a9f7c6ef6">Comparing commit changes in Core for 6.9</a> since October 28, 2025</li>\n</ul>\n\n\n\n<h2 class="wp-block-heading">A Beta 3 haiku</h2>\n\n\n\n<p><em>Code is poetry,</em></p>\n\n\n\n<p><em>and poetry is magic.</em></p>\n\n\n\n<p><em>So code is magic.</em></p>\n\n\n\n<p class="has-text-align-right"><em>Props to </em><a href=\'https://profiles.wordpress.org/akshayar/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>akshayar</a> <em>, </em><a href=\'https://profiles.wordpress.org/jeffpaul/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>jeffpaul</a>, <a href=\'https://profiles.wordpress.org/krupajnanda/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>krupajnanda</a>, <a href=\'https://profiles.wordpress.org/mosescursor/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>mosescursor</a>,  <em>and</em> <a href=\'https://profiles.wordpress.org/westonruter/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>westonruter</a> <em>for proofreading and review.</em></p>\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:30:"com-wordpress:feed-additions:1";a:1:{s:7:"post-id";a:1:{i:0;a:5:{s:4:"data";s:5:"19263";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:7;a:6:{s:4:"data";s:69:"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n		\n\n					\n										\n					\n		\n		\n			";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:4:{s:0:"";a:6:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:20:"WordPress 6.9 Beta 2";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:56:"https://wordpress.org/news/2025/10/wordpress-6-9-beta-2/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Tue, 28 Oct 2025 15:23:27 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:5:{i:0;a:5:{s:4:"data";s:11:"Development";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:1;a:5:{s:4:"data";s:8:"Releases";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:2;a:5:{s:4:"data";s:3:"6-9";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:3;a:5:{s:4:"data";s:11:"development";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:4;a:5:{s:4:"data";s:7:"release";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:35:"https://wordpress.org/news/?p=19253";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:334:"WordPress 6.9 Beta 2 is now ready for testing! This beta version of the WordPress software is under development. Please do not install, run, or test this version of WordPress on production or mission-critical websites.&#160; Instead, you should evaluate Beta 2 on a test server and site. You can test WordPress 6.9 Beta 2 in [&#8230;]";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:12:"Akshaya Rane";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:5125:"\n<p>WordPress 6.9 Beta 2 is now ready for testing!</p>\n\n\n\n<p><strong>This beta version of the WordPress software is under development</strong>. Please do not install, run, or test this version of WordPress on production or mission-critical websites.&nbsp; Instead, you should evaluate Beta 2 on a test server and site.</p>\n\n\n\n<p>You can test WordPress 6.9 Beta 2 in any of the following ways:<br></p>\n\n\n\n<figure class="wp-block-table"><table class="has-fixed-layout"><tbody><tr><td><strong>Plugin</strong></td><td>Install and activate the<a href="https://wordpress.org/plugins/wordpress-beta-tester/"> WordPress Beta Tester</a> plugin on a WordPress install. (Select the “Bleeding edge” channel and “Beta/RC Only” stream.)</td></tr><tr><td><strong>Direct Download</strong></td><td>Download the <a href="https://wordpress.org/wordpress-6.9-beta2.zip">Beta 2 version (zip)</a> and install it on a WordPress website.</td></tr><tr><td><strong>Command Line</strong></td><td>Use this<a href="https://make.wordpress.org/cli/"> WP-CLI</a> command: <br><code>wp core update --version=6.9-beta2</code></td></tr><tr><td><strong>WordPress Playground</strong></td><td>Use the <a href="https://playground.wordpress.net/?php=8.0&amp;wp=beta&amp;networking=no&amp;language=&amp;multisite=no&amp;random=y4q1rn88xn">6.9 Beta 2 WordPress Playground instance</a> to test the software directly in your browser.&nbsp; No setup is required–just click and go!&nbsp;</td></tr></tbody></table></figure>\n\n\n\n<p>The scheduled final release date for WordPress 6.9 is <strong>December 2, 2025</strong>. &nbsp;The full <a href="https://make.wordpress.org/core/6-9/">release schedule can be found here</a>. Your help testing Beta and RC versions is vital to making this release as stable and powerful as possible. Do check the<a href="https://make.wordpress.org/core/"> Make WordPress Core blog</a> for <a href="https://make.wordpress.org/core/tag/6-9/">6.9-related posts</a> in the coming weeks for more information. Thank you to everyone who contributes by testing!&nbsp;</p>\n\n\n\n<p><strong>Catch up on what’s new in WordPress 6.9</strong>: Read the <a href="https://make.wordpress.org/core/2025/10/21/wordpress-6-9-beta-1/">Beta 1 announcement</a> for details and highlights.</p>\n\n\n\n<h2 class="wp-block-heading">How to test this release</h2>\n\n\n\n<p>Your help testing the WordPress 6.9 Beta 2 version is key to ensuring everything in the release is the best it can be. While testing the upgrade process is essential, trying out new features is equally important.&nbsp; This <a href="https://make.wordpress.org/test/2025/10/21/help-test-wordpress-6-9/">detailed guide</a> will walk you through testing features in WordPress 6.9.</p>\n\n\n\n<p>If you encounter an issue, please report it to the<a href="https://wordpress.org/support/forum/alphabeta/"> Alpha/Beta area</a> of the support forums or directly to<a href="https://core.trac.wordpress.org/newticket"> WordPress Trac</a> if you are comfortable writing a reproducible bug report. You can also check your issue against a list of<a href="https://core.trac.wordpress.org/tickets/major"> known bugs</a>.</p>\n\n\n\n<p>Curious about testing releases in general? Follow along with the<a href="https://make.wordpress.org/test/"> testing initiatives in Make Core</a> and join the<a href="https://wordpress.slack.com/messages/core-test/"> #core-test channel</a> on<a href="https://wordpress.slack.com/"> Making WordPress Slack</a>.</p>\n\n\n\n<h2 class="wp-block-heading">Beta 2 updates and highlights</h2>\n\n\n\n<p>WordPress 6.9 Beta 2 contains more than 33 Editor updates and fixes since the Beta 1 release, including 28 tickets for WordPress core.</p>\n\n\n\n<p>Each beta cycle focuses on bug fixes; more are on the way with your help through testing. You can browse the technical details for all issues addressed since Beta 1 using these links:</p>\n\n\n\n<ul class="wp-block-list">\n<li><a href="https://github.com/WordPress/gutenberg/commits/wp/6.9?since=2025-10-22&amp;until=2025-10-28">GitHub commits for 6.9</a> since October 21, 2025</li>\n\n\n\n<li><a href="https://core.trac.wordpress.org/query?status=closed&amp;changetime=10%2F22%2F2025..10%2F28%2F2025&amp;milestone=6.9&amp;col=id&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=id">Closed Trac tickets</a> since October 21, 2025</li>\n</ul>\n\n\n\n<h2 class="wp-block-heading">A Beta 2 haiku</h2>\n\n\n\n<p><em>Morning dew returns,</em></p>\n\n\n\n<p><em>Small fixes bloom in silence—</em></p>\n\n\n\n<p><em>Code finds its balance.</em></p>\n\n\n\n<p class="has-text-align-right"><em>Props to <a href=\'https://profiles.wordpress.org/davidbaumwald/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>davidbaumwald</a>, <a href=\'https://profiles.wordpress.org/wildworks/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>wildworks</a> , <a href=\'https://profiles.wordpress.org/krupajnanda/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>krupajnanda</a> &amp; <a href=\'https://profiles.wordpress.org/mosescursor/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>mosescursor</a></em> <em>for proofreading and review.</em></p>\n\n\n\n<p></p>\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:30:"com-wordpress:feed-additions:1";a:1:{s:7:"post-id";a:1:{i:0;a:5:{s:4:"data";s:5:"19253";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:8;a:6:{s:4:"data";s:63:"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n\n					\n										\n					\n		\n		\n			";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:4:{s:0:"";a:6:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:23:"WordPress 6.8.3 Release";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:59:"https://wordpress.org/news/2025/09/wordpress-6-8-3-release/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Tue, 30 Sep 2025 19:31:04 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:3:{i:0;a:5:{s:4:"data";s:8:"Releases";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:1;a:5:{s:4:"data";s:14:"minor-releases";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:2;a:5:{s:4:"data";s:8:"releases";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:35:"https://wordpress.org/news/?p=19204";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:372:"WordPress 6.8.3 is now available! This is a security release that features two fixes. Because this is a security release, it is recommended that you update your sites immediately. You can download WordPress 6.8.3 from WordPress.org, or visit your WordPress Dashboard, click “Updates”, and then click “Update Now”. If you have sites that support automatic [&#8230;]";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:15:"John Blackbourn";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:4937:"\n<p><strong>WordPress 6.8.3 is now available!</strong></p>\n\n\n\n<p>This is a security release that features two fixes.</p>\n\n\n\n<p>Because this is a security release,<strong> it is recommended that you update your sites immediately</strong>.</p>\n\n\n\n<p>You can <a href="https://wordpress.org/wordpress-6.8.3.zip">download WordPress 6.8.3 from WordPress.org</a>, or visit your WordPress Dashboard, click “Updates”, and then click “Update Now”. If you have sites that support automatic background updates, the update process will begin automatically.</p>\n\n\n\n<p>The next major release will be <a href="https://make.wordpress.org/core/6-9/">version 6.9</a>, which is planned for December 2nd, 2025.<br>For more information on WordPress 6.8.3, please visit the <a href="https://wordpress.org/documentation/wordpress-version/version-6-8-3/">version page on the HelpHub site</a>.</p>\n\n\n\n<h2 class="wp-block-heading">Security updates included in this release</h2>\n\n\n\n<p>The security team would like to thank the following people for <a href="https://hackerone.com/wordpress?type=team">responsibly reporting vulnerabilities</a>, and allowing them to be fixed in this release:</p>\n\n\n\n<ul class="wp-block-list">\n<li>A data exposure issue where authenticated users could access some restricted content. Independently reported by <a href="https://hackerone.com/mnelson4">Mike Nelson</a>, <a href="https://hackerone.com/hurayraiit">Abu Hurayra</a>, <a href="https://profiles.wordpress.org/timothyblynjacobs/">Timothy Jacobs</a>, and <a href="https://profiles.wordpress.org/peterwilsoncc/">Peter Wilson</a>.</li>\n\n\n\n<li>A cross-site scripting (XSS) vulnerability requiring an authenticated user role that affects the nav menus. Reported by <a href="https://x.com/Savphill">Phill Savage</a>.</li>\n</ul>\n\n\n\n<p>As a courtesy, these fixes have also been made available to all branches eligible to receive security fixes (currently through 4.7). As a reminder, <strong>only the most recent version of WordPress is actively supported</strong>.</p>\n\n\n\n<h2 class="wp-block-heading">Thank you to these WordPress contributors</h2>\n\n\n\n<p>This release was led by <a href="https://profiles.wordpress.org/johnbillion/">John Blackbourn</a>.</p>\n\n\n\n<p>In addition to the security researchers and release squad members mentioned above, WordPress 6.8.3 would not have been possible without the contributions of the following people:</p>\n\n\n\n<p><a href="https://profiles.wordpress.org/jorbin">Aaron Jorbin</a>, <a href="https://profiles.wordpress.org/hurayraiit">Abu Hurayra</a>, <a href="https://profiles.wordpress.org/zieladam">Adam Zieliński</a>, <a href="https://profiles.wordpress.org/xknown">Alex Concha</a>, <a href="https://profiles.wordpress.org/andraganescu%20">Andrei Draganescu</a>, <a href="https://profiles.wordpress.org/davidbaumwald/">David Baumwald</a>, <a href="https://profiles.wordpress.org/ehtis">Ehtisham Siddiqui</a>, <a href="https://profiles.wordpress.org/iandunn">Ian Dunn</a>, <a href="https://profiles.wordpress.org/whyisjake">Jake Spurlock</a>, <a href="https://profiles.wordpress.org/audrasjb">Jb Audras</a>, <a href="https://profiles.wordpress.org/joehoyle">Joe Hoyle</a>, <a href="https://profiles.wordpress.org/johnbillion">John Blackbourn</a>, <a href="https://profiles.wordpress.org/jonsurrell">Jon Surrell</a>, <a href="https://profiles.wordpress.org/desrosj">Jonathan Desrosiers</a>, <a href="https://profiles.wordpress.org/mnelson4">Michael Nelson</a>, <a href="https://profiles.wordpress.org/peterwilsoncc">Peter Wilson</a>, <a href="https://profiles.wordpress.org/phillsav">Phill</a>, <a href="https://profiles.wordpress.org/noisysocks">Robert Anderson</a>, <a href="https://profiles.wordpress.org/rmccue">Ryan McCue</a>, <a href="https://profiles.wordpress.org/coffee2code/">Scott Reilly</a>, <a href="https://profiles.wordpress.org/timothyblynjacobs">Timothy Jacobs</a>, <a href="https://profiles.wordpress.org/vortfu">vortfu</a>, <a href="https://profiles.wordpress.org/westonruter">Weston Ruter</a></p>\n\n\n\n<h2 class="wp-block-heading">How to contribute</h2>\n\n\n\n<p>To get involved in WordPress core development, head over to Trac, <a href="https://core.trac.wordpress.org/report/6">pick a ticket</a>, and join the conversation in the <a href="https://app.slack.com/client/T024MFP4J/C02RQBWTW">#core</a> Slack channel. Need help? Check out the <a href="https://make.wordpress.org/core/handbook/tutorials/faq-for-new-contributors/">Core Contributor Handbook</a>.</p>\n\n\n\n<p>Props to <a href="https://profiles.wordpress.org/ehtis/">Ehtisham Siddiqui</a>, <a href="https://profiles.wordpress.org/johnbillion/">John Blackbourn</a>, <a href="https://profiles.wordpress.org/paulkevan/">Paul Kevan</a>, <a href="https://profiles.wordpress.org/desrosj/">Jonathan Desrosiers</a>, <a href="https://profiles.wordpress.org/jorbin/">Aaron Jorbin</a>, <a href="https://profiles.wordpress.org/westonruter">Weston Ruter</a> for reviewing.</p>\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:30:"com-wordpress:feed-additions:1";a:1:{s:7:"post-id";a:1:{i:0;a:5:{s:4:"data";s:5:"19204";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:9;a:6:{s:4:"data";s:63:"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n\n					\n										\n					\n		\n		\n			";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:4:{s:0:"";a:6:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:57:"Portland Welcomes WordCamp US 2025: A Community Gathering";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:63:"https://wordpress.org/news/2025/08/portland-welcomes-wcus-2025/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Sat, 30 Aug 2025 03:03:52 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:3:{i:0;a:5:{s:4:"data";s:6:"Events";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:1;a:5:{s:4:"data";s:7:"General";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:2;a:5:{s:4:"data";s:8:"WordCamp";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:35:"https://wordpress.org/news/?p=19074";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:405:"A full house of attendees gathered in Portland, Oregon, for WordCamp US 2025, with thousands more tuning in online. Over four days, the flagship WordPress event brought together contributors, innovators, and community members for collaboration, inspiration, and discovery. WordPress is so unique because we&#8217;re not just a product; we&#8217;re a movement. Matt Mullenweg, WordPress Cofounder [&#8230;]";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:14:"Brett McSherry";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:69049:"\n\n\n<p>A full house of attendees gathered in Portland, Oregon, for WordCamp US 2025, with thousands more tuning in online. Over four days, the flagship WordPress event brought together contributors, innovators, and community members for collaboration, inspiration, and discovery.</p>\n\n\n\n<div class="wp-block-group is-nowrap is-layout-flex wp-container-core-group-is-layout-6c531013 wp-block-group-is-layout-flex">\n<figure class="wp-block-pullquote"><blockquote><p>WordPress is so unique because we&#8217;re not just a product; we&#8217;re a movement.</p><cite>Matt Mullenweg, WordPress Cofounder</cite></blockquote></figure>\n</div>\n\n\n\n<p>The WordPress event began with a dedicated Contributor Day and continued with a Showcase Day and two days of sessions filled with talks, panels, workshops, and community celebrations. WordPress Cofounder Matt Mullenweg joined a diverse lineup of speakers, panelists, and workshop leaders who brought fresh perspectives to the open web from across the globe.</p>\n\n\n\n<p>Set against the vibrant backdrop of Portland — with its iconic bridges, coffee culture, and creative energy — the Sponsor Hall buzzed as companies across the WordPress ecosystem demoed new products, shared insights, and connected with attendees. Each day offered opportunities to refuel with local flavors and international favorites, turning mealtimes into lively hubs of networking and idea-sharing.</p>\n\n\n\n<h2 class="wp-block-heading">A Global Gathering in Portland</h2>\n\n\n\n<p>WordCamp US is the annual gathering point for the WordPress community — where collaboration, creativity, and innovation intersect. This year in Portland, the event delivered an expansive program that reached every corner of the ecosystem.</p>\n\n\n\n<p>Here’s what attendees experienced:</p>\n\n\n\n<ul class="wp-block-list">\n<li><strong>Engaging Sessions Across Tracks</strong> – Keynotes, presentations, and discussions explored the evolving web and the role of open source in shaping it.</li>\n\n\n\n<li><strong>A Global Speaker Lineup</strong> – Voices from across continents brought local stories and global visions to the stage.</li>\n\n\n\n<li><strong>Wide-Ranging Topics</strong> – From AI in WordPress development to accessibility, design systems, content strategy, education, and case studies of WordPress at scale.</li>\n\n\n\n<li><strong>Hands-On Learning Opportunities</strong> – Workshops provided practical takeaways, empowering attendees to apply new skills immediately.</li>\n\n\n\n<li><strong>A Community Built on Collaboration</strong> – Whether contributing code, exploring business strategies, or sharing creative projects, attendees found space to learn, grow, and celebrate open source together.</li>\n</ul>\n\n\n\n<p>New contributors took their first steps into open source, seasoned developers explored cutting-edge AI integrations, and agencies and product teams shared strategies for scaling WordPress to meet modern needs. Beyond the technical, conversations around inclusivity, sustainability, and education underscored WordPress’s role as a tool for empowerment and positive change.</p>\n\n\n\n<p>In hallways, coffee lines, and evening meetups, attendees found the “hallway track” alive and well, spontaneous moments of connection that often became the most memorable part of the experience. Whether reconnecting with longtime collaborators or meeting someone new, these small interactions reinforced the heart of WordCamp US: a community that thrives on openness, generosity, and shared purpose.</p>\n\n\n\n<h2 class="wp-block-heading">Contributor Day: Collaboration at the Core</h2>\n\n\n\n<p>The conference opened on Tuesday, August 26, with a vibrant Contributor Day. Nearly 300 contributors filled the space, including more than 120 first-time participants who were onboarded across 19 teams. Developers, designers, translators, marketers, and community organizers worked side by side, representing WordPress expertise.</p>\n\n\n\n<p>Throughout the day, contributors tackled everything from improving accessibility and performance to refining documentation to enhancing translation tools. Beyond technical contributions, teams like Marketing and Community focused on outreach, mentoring, and shaping future-facing initiatives. Remote participants joined via dedicated channels, reinforcing the inclusive nature of WordPress’s global community. By day’s end, the collective energy was clear: WordPress continues to be built by and for everyone.</p>\n\n\n\n<figure class="wp-block-gallery has-nested-images columns-default is-cropped has-black-background-color has-background wp-block-gallery-1 is-layout-flex wp-block-gallery-is-layout-flex" style="border-width:20px;border-radius:2px">\n<figure data-wp-context="{&quot;imageId&quot;:&quot;6963ba349c1ed&quot;}" data-wp-interactive="core/image" data-wp-key="6963ba349c1ed" class="wp-block-image size-large wp-lightbox-container"><img data-recalc-dims="1" loading="lazy" decoding="async" width="1024" height="683" data-wp-class--hide="state.isContentHidden" data-wp-class--show="state.isContentVisible" data-wp-init="callbacks.setButtonStyles" data-wp-on--click="actions.showLightbox" data-wp-on--load="callbacks.setButtonStyles" data-wp-on--pointerdown="actions.preloadImage" data-wp-on--pointerenter="actions.preloadImageWithDelay" data-wp-on--pointerleave="actions.cancelPreload" data-wp-on-window--resize="callbacks.setButtonStyles" data-id="19080" src="https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5641.jpg?resize=1024%2C683&#038;ssl=1" alt="" class="wp-image-19080" srcset="https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5641-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5641-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5641-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5641-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5641-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w" sizes="auto, (max-width: 1000px) 100vw, 1000px" /><button\n			class="lightbox-trigger"\n			type="button"\n			aria-haspopup="dialog"\n			aria-label="Enlarge"\n			data-wp-init="callbacks.initTriggerButton"\n			data-wp-on--click="actions.showLightbox"\n			data-wp-style--right="state.imageButtonRight"\n			data-wp-style--top="state.imageButtonTop"\n		>\n			<svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" fill="none" viewBox="0 0 12 12">\n				<path fill="#fff" d="M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context="{&quot;imageId&quot;:&quot;6963ba349c7a0&quot;}" data-wp-interactive="core/image" data-wp-key="6963ba349c7a0" class="wp-block-image size-large wp-lightbox-container"><img data-recalc-dims="1" loading="lazy" decoding="async" width="1024" height="683" data-wp-class--hide="state.isContentHidden" data-wp-class--show="state.isContentVisible" data-wp-init="callbacks.setButtonStyles" data-wp-on--click="actions.showLightbox" data-wp-on--load="callbacks.setButtonStyles" data-wp-on--pointerdown="actions.preloadImage" data-wp-on--pointerenter="actions.preloadImageWithDelay" data-wp-on--pointerleave="actions.cancelPreload" data-wp-on-window--resize="callbacks.setButtonStyles" data-id="19081" src="https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5630.jpg?resize=1024%2C683&#038;ssl=1" alt="" class="wp-image-19081" srcset="https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5630-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5630-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5630-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5630-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5630-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w" sizes="auto, (max-width: 1000px) 100vw, 1000px" /><button\n			class="lightbox-trigger"\n			type="button"\n			aria-haspopup="dialog"\n			aria-label="Enlarge"\n			data-wp-init="callbacks.initTriggerButton"\n			data-wp-on--click="actions.showLightbox"\n			data-wp-style--right="state.imageButtonRight"\n			data-wp-style--top="state.imageButtonTop"\n		>\n			<svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" fill="none" viewBox="0 0 12 12">\n				<path fill="#fff" d="M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context="{&quot;imageId&quot;:&quot;6963ba349cd00&quot;}" data-wp-interactive="core/image" data-wp-key="6963ba349cd00" class="wp-block-image size-large wp-lightbox-container"><img loading="lazy" decoding="async" width="1707" height="2560" data-wp-class--hide="state.isContentHidden" data-wp-class--show="state.isContentVisible" data-wp-init="callbacks.setButtonStyles" data-wp-on--click="actions.showLightbox" data-wp-on--load="callbacks.setButtonStyles" data-wp-on--pointerdown="actions.preloadImage" data-wp-on--pointerenter="actions.preloadImageWithDelay" data-wp-on--pointerleave="actions.cancelPreload" data-wp-on-window--resize="callbacks.setButtonStyles" data-id="19087" src="https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8717-2-scaled.jpg?fit=683%2C1024&amp;ssl=1" alt="" class="wp-image-19087" srcset="https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8717-2-scaled.jpg?w=1707&amp;ssl=1 1707w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8717-2-scaled.jpg?resize=200%2C300&amp;ssl=1 200w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8717-2-scaled.jpg?resize=683%2C1024&amp;ssl=1 683w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8717-2-scaled.jpg?resize=768%2C1152&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8717-2-scaled.jpg?resize=1024%2C1536&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8717-2-scaled.jpg?resize=1365%2C2048&amp;ssl=1 1365w" sizes="auto, (max-width: 1000px) 100vw, 1000px" /><button\n			class="lightbox-trigger"\n			type="button"\n			aria-haspopup="dialog"\n			aria-label="Enlarge"\n			data-wp-init="callbacks.initTriggerButton"\n			data-wp-on--click="actions.showLightbox"\n			data-wp-style--right="state.imageButtonRight"\n			data-wp-style--top="state.imageButtonTop"\n		>\n			<svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" fill="none" viewBox="0 0 12 12">\n				<path fill="#fff" d="M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context="{&quot;imageId&quot;:&quot;6963ba349d271&quot;}" data-wp-interactive="core/image" data-wp-key="6963ba349d271" class="wp-block-image size-large wp-lightbox-container"><img data-recalc-dims="1" loading="lazy" decoding="async" width="1024" height="683" data-wp-class--hide="state.isContentHidden" data-wp-class--show="state.isContentVisible" data-wp-init="callbacks.setButtonStyles" data-wp-on--click="actions.showLightbox" data-wp-on--load="callbacks.setButtonStyles" data-wp-on--pointerdown="actions.preloadImage" data-wp-on--pointerenter="actions.preloadImageWithDelay" data-wp-on--pointerleave="actions.cancelPreload" data-wp-on-window--resize="callbacks.setButtonStyles" data-id="19084" src="https://i0.wp.com/wordpress.org/news/files/2025/08/Z633022.jpg?resize=1024%2C683&#038;ssl=1" alt="" class="wp-image-19084" srcset="https://i0.wp.com/wordpress.org/news/files/2025/08/Z633022-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z633022-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z633022-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z633022-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z633022-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w" sizes="auto, (max-width: 1000px) 100vw, 1000px" /><button\n			class="lightbox-trigger"\n			type="button"\n			aria-haspopup="dialog"\n			aria-label="Enlarge"\n			data-wp-init="callbacks.initTriggerButton"\n			data-wp-on--click="actions.showLightbox"\n			data-wp-style--right="state.imageButtonRight"\n			data-wp-style--top="state.imageButtonTop"\n		>\n			<svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" fill="none" viewBox="0 0 12 12">\n				<path fill="#fff" d="M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context="{&quot;imageId&quot;:&quot;6963ba349d7a9&quot;}" data-wp-interactive="core/image" data-wp-key="6963ba349d7a9" class="wp-block-image size-large wp-lightbox-container"><img data-recalc-dims="1" loading="lazy" decoding="async" width="1024" height="683" data-wp-class--hide="state.isContentHidden" data-wp-class--show="state.isContentVisible" data-wp-init="callbacks.setButtonStyles" data-wp-on--click="actions.showLightbox" data-wp-on--load="callbacks.setButtonStyles" data-wp-on--pointerdown="actions.preloadImage" data-wp-on--pointerenter="actions.preloadImageWithDelay" data-wp-on--pointerleave="actions.cancelPreload" data-wp-on-window--resize="callbacks.setButtonStyles" data-id="19082" src="https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5634.jpg?resize=1024%2C683&#038;ssl=1" alt="" class="wp-image-19082" srcset="https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5634-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5634-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5634-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5634-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5634-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w" sizes="auto, (max-width: 1000px) 100vw, 1000px" /><button\n			class="lightbox-trigger"\n			type="button"\n			aria-haspopup="dialog"\n			aria-label="Enlarge"\n			data-wp-init="callbacks.initTriggerButton"\n			data-wp-on--click="actions.showLightbox"\n			data-wp-style--right="state.imageButtonRight"\n			data-wp-style--top="state.imageButtonTop"\n		>\n			<svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" fill="none" viewBox="0 0 12 12">\n				<path fill="#fff" d="M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context="{&quot;imageId&quot;:&quot;6963ba349dd02&quot;}" data-wp-interactive="core/image" data-wp-key="6963ba349dd02" class="wp-block-image size-large wp-lightbox-container"><img data-recalc-dims="1" loading="lazy" decoding="async" width="1024" height="683" data-wp-class--hide="state.isContentHidden" data-wp-class--show="state.isContentVisible" data-wp-init="callbacks.setButtonStyles" data-wp-on--click="actions.showLightbox" data-wp-on--load="callbacks.setButtonStyles" data-wp-on--pointerdown="actions.preloadImage" data-wp-on--pointerenter="actions.preloadImageWithDelay" data-wp-on--pointerleave="actions.cancelPreload" data-wp-on-window--resize="callbacks.setButtonStyles" data-id="19085" src="https://i0.wp.com/wordpress.org/news/files/2025/08/Z632926.jpg?resize=1024%2C683&#038;ssl=1" alt="" class="wp-image-19085" srcset="https://i0.wp.com/wordpress.org/news/files/2025/08/Z632926-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z632926-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z632926-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z632926-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z632926-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w" sizes="auto, (max-width: 1000px) 100vw, 1000px" /><button\n			class="lightbox-trigger"\n			type="button"\n			aria-haspopup="dialog"\n			aria-label="Enlarge"\n			data-wp-init="callbacks.initTriggerButton"\n			data-wp-on--click="actions.showLightbox"\n			data-wp-style--right="state.imageButtonRight"\n			data-wp-style--top="state.imageButtonTop"\n		>\n			<svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" fill="none" viewBox="0 0 12 12">\n				<path fill="#fff" d="M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context="{&quot;imageId&quot;:&quot;6963ba349e248&quot;}" data-wp-interactive="core/image" data-wp-key="6963ba349e248" class="wp-block-image size-large wp-lightbox-container"><img data-recalc-dims="1" loading="lazy" decoding="async" width="1024" height="683" data-wp-class--hide="state.isContentHidden" data-wp-class--show="state.isContentVisible" data-wp-init="callbacks.setButtonStyles" data-wp-on--click="actions.showLightbox" data-wp-on--load="callbacks.setButtonStyles" data-wp-on--pointerdown="actions.preloadImage" data-wp-on--pointerenter="actions.preloadImageWithDelay" data-wp-on--pointerleave="actions.cancelPreload" data-wp-on-window--resize="callbacks.setButtonStyles" data-id="19086" src="https://i0.wp.com/wordpress.org/news/files/2025/08/Z633226-1.jpg?resize=1024%2C683&#038;ssl=1" alt="" class="wp-image-19086" srcset="https://i0.wp.com/wordpress.org/news/files/2025/08/Z633226-1-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z633226-1-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z633226-1-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z633226-1-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z633226-1-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w" sizes="auto, (max-width: 1000px) 100vw, 1000px" /><button\n			class="lightbox-trigger"\n			type="button"\n			aria-haspopup="dialog"\n			aria-label="Enlarge"\n			data-wp-init="callbacks.initTriggerButton"\n			data-wp-on--click="actions.showLightbox"\n			data-wp-style--right="state.imageButtonRight"\n			data-wp-style--top="state.imageButtonTop"\n		>\n			<svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" fill="none" viewBox="0 0 12 12">\n				<path fill="#fff" d="M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context="{&quot;imageId&quot;:&quot;6963ba349eb01&quot;}" data-wp-interactive="core/image" data-wp-key="6963ba349eb01" class="wp-block-image size-large wp-lightbox-container"><img data-recalc-dims="1" loading="lazy" decoding="async" width="1024" height="683" data-wp-class--hide="state.isContentHidden" data-wp-class--show="state.isContentVisible" data-wp-init="callbacks.setButtonStyles" data-wp-on--click="actions.showLightbox" data-wp-on--load="callbacks.setButtonStyles" data-wp-on--pointerdown="actions.preloadImage" data-wp-on--pointerenter="actions.preloadImageWithDelay" data-wp-on--pointerleave="actions.cancelPreload" data-wp-on-window--resize="callbacks.setButtonStyles" data-id="19090" src="https://i0.wp.com/wordpress.org/news/files/2025/08/Z633121.jpg?resize=1024%2C683&#038;ssl=1" alt="" class="wp-image-19090" srcset="https://i0.wp.com/wordpress.org/news/files/2025/08/Z633121-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z633121-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z633121-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z633121-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z633121-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w" sizes="auto, (max-width: 1000px) 100vw, 1000px" /><button\n			class="lightbox-trigger"\n			type="button"\n			aria-haspopup="dialog"\n			aria-label="Enlarge"\n			data-wp-init="callbacks.initTriggerButton"\n			data-wp-on--click="actions.showLightbox"\n			data-wp-style--right="state.imageButtonRight"\n			data-wp-style--top="state.imageButtonTop"\n		>\n			<svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" fill="none" viewBox="0 0 12 12">\n				<path fill="#fff" d="M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context="{&quot;imageId&quot;:&quot;6963ba349f0cb&quot;}" data-wp-interactive="core/image" data-wp-key="6963ba349f0cb" class="wp-block-image size-large wp-lightbox-container"><img loading="lazy" decoding="async" width="2560" height="1707" data-wp-class--hide="state.isContentHidden" data-wp-class--show="state.isContentVisible" data-wp-init="callbacks.setButtonStyles" data-wp-on--click="actions.showLightbox" data-wp-on--load="callbacks.setButtonStyles" data-wp-on--pointerdown="actions.preloadImage" data-wp-on--pointerenter="actions.preloadImageWithDelay" data-wp-on--pointerleave="actions.cancelPreload" data-wp-on-window--resize="callbacks.setButtonStyles" data-id="19089" src="https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8723-scaled.jpg?fit=1024%2C683&amp;ssl=1" alt="" class="wp-image-19089" srcset="https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8723-scaled.jpg?w=2560&amp;ssl=1 2560w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8723-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8723-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8723-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8723-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8723-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w" sizes="auto, (max-width: 1000px) 100vw, 1000px" /><button\n			class="lightbox-trigger"\n			type="button"\n			aria-haspopup="dialog"\n			aria-label="Enlarge"\n			data-wp-init="callbacks.initTriggerButton"\n			data-wp-on--click="actions.showLightbox"\n			data-wp-style--right="state.imageButtonRight"\n			data-wp-style--top="state.imageButtonTop"\n		>\n			<svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" fill="none" viewBox="0 0 12 12">\n				<path fill="#fff" d="M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context="{&quot;imageId&quot;:&quot;6963ba349f664&quot;}" data-wp-interactive="core/image" data-wp-key="6963ba349f664" class="wp-block-image size-large wp-lightbox-container"><img data-recalc-dims="1" loading="lazy" decoding="async" width="1024" height="683" data-wp-class--hide="state.isContentHidden" data-wp-class--show="state.isContentVisible" data-wp-init="callbacks.setButtonStyles" data-wp-on--click="actions.showLightbox" data-wp-on--load="callbacks.setButtonStyles" data-wp-on--pointerdown="actions.preloadImage" data-wp-on--pointerenter="actions.preloadImageWithDelay" data-wp-on--pointerleave="actions.cancelPreload" data-wp-on-window--resize="callbacks.setButtonStyles" data-id="19092" src="https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8841.jpg?resize=1024%2C683&#038;ssl=1" alt="" class="wp-image-19092" srcset="https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8841-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8841-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8841-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8841-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8841-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w" sizes="auto, (max-width: 1000px) 100vw, 1000px" /><button\n			class="lightbox-trigger"\n			type="button"\n			aria-haspopup="dialog"\n			aria-label="Enlarge"\n			data-wp-init="callbacks.initTriggerButton"\n			data-wp-on--click="actions.showLightbox"\n			data-wp-style--right="state.imageButtonRight"\n			data-wp-style--top="state.imageButtonTop"\n		>\n			<svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" fill="none" viewBox="0 0 12 12">\n				<path fill="#fff" d="M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context="{&quot;imageId&quot;:&quot;6963ba349fc3c&quot;}" data-wp-interactive="core/image" data-wp-key="6963ba349fc3c" class="wp-block-image size-large wp-lightbox-container"><img loading="lazy" decoding="async" width="2560" height="1707" data-wp-class--hide="state.isContentHidden" data-wp-class--show="state.isContentVisible" data-wp-init="callbacks.setButtonStyles" data-wp-on--click="actions.showLightbox" data-wp-on--load="callbacks.setButtonStyles" data-wp-on--pointerdown="actions.preloadImage" data-wp-on--pointerenter="actions.preloadImageWithDelay" data-wp-on--pointerleave="actions.cancelPreload" data-wp-on-window--resize="callbacks.setButtonStyles" data-id="19088" src="https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8753-1-scaled.jpg?fit=1024%2C683&amp;ssl=1" alt="" class="wp-image-19088" srcset="https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8753-1-scaled.jpg?w=2560&amp;ssl=1 2560w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8753-1-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8753-1-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8753-1-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8753-1-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8753-1-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w" sizes="auto, (max-width: 1000px) 100vw, 1000px" /><button\n			class="lightbox-trigger"\n			type="button"\n			aria-haspopup="dialog"\n			aria-label="Enlarge"\n			data-wp-init="callbacks.initTriggerButton"\n			data-wp-on--click="actions.showLightbox"\n			data-wp-style--right="state.imageButtonRight"\n			data-wp-style--top="state.imageButtonTop"\n		>\n			<svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" fill="none" viewBox="0 0 12 12">\n				<path fill="#fff" d="M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context="{&quot;imageId&quot;:&quot;6963ba34a018b&quot;}" data-wp-interactive="core/image" data-wp-key="6963ba34a018b" class="wp-block-image size-large wp-lightbox-container"><img data-recalc-dims="1" loading="lazy" decoding="async" width="1024" height="683" data-wp-class--hide="state.isContentHidden" data-wp-class--show="state.isContentVisible" data-wp-init="callbacks.setButtonStyles" data-wp-on--click="actions.showLightbox" data-wp-on--load="callbacks.setButtonStyles" data-wp-on--pointerdown="actions.preloadImage" data-wp-on--pointerenter="actions.preloadImageWithDelay" data-wp-on--pointerleave="actions.cancelPreload" data-wp-on-window--resize="callbacks.setButtonStyles" data-id="19091" src="https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8827.jpg?resize=1024%2C683&#038;ssl=1" alt="" class="wp-image-19091" srcset="https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8827-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8827-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8827-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8827-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8827-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w" sizes="auto, (max-width: 1000px) 100vw, 1000px" /><button\n			class="lightbox-trigger"\n			type="button"\n			aria-haspopup="dialog"\n			aria-label="Enlarge"\n			data-wp-init="callbacks.initTriggerButton"\n			data-wp-on--click="actions.showLightbox"\n			data-wp-style--right="state.imageButtonRight"\n			data-wp-style--top="state.imageButtonTop"\n		>\n			<svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" fill="none" viewBox="0 0 12 12">\n				<path fill="#fff" d="M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context="{&quot;imageId&quot;:&quot;6963ba34a06eb&quot;}" data-wp-interactive="core/image" data-wp-key="6963ba34a06eb" class="wp-block-image size-large wp-lightbox-container"><img data-recalc-dims="1" loading="lazy" decoding="async" width="1024" height="683" data-wp-class--hide="state.isContentHidden" data-wp-class--show="state.isContentVisible" data-wp-init="callbacks.setButtonStyles" data-wp-on--click="actions.showLightbox" data-wp-on--load="callbacks.setButtonStyles" data-wp-on--pointerdown="actions.preloadImage" data-wp-on--pointerenter="actions.preloadImageWithDelay" data-wp-on--pointerleave="actions.cancelPreload" data-wp-on-window--resize="callbacks.setButtonStyles" data-id="19083" src="https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8887-2.jpg?resize=1024%2C683&#038;ssl=1" alt="" class="wp-image-19083" srcset="https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8887-2-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8887-2-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8887-2-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8887-2-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8887-2-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w" sizes="auto, (max-width: 1000px) 100vw, 1000px" /><button\n			class="lightbox-trigger"\n			type="button"\n			aria-haspopup="dialog"\n			aria-label="Enlarge"\n			data-wp-init="callbacks.initTriggerButton"\n			data-wp-on--click="actions.showLightbox"\n			data-wp-style--right="state.imageButtonRight"\n			data-wp-style--top="state.imageButtonTop"\n		>\n			<svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" fill="none" viewBox="0 0 12 12">\n				<path fill="#fff" d="M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z" />\n			</svg>\n		</button></figure>\n</figure>\n\n\n\n<p>The mix of experience in the room made this year especially notable. First-time contributors were paired with seasoned table leads who guided them through their first steps into open source contribution. Longtime contributors reconnected with their teams and advanced ongoing initiatives, while new voices added fresh perspectives and momentum. The spirit of mentorship was woven throughout, ensuring that Contributor Day was productive and welcoming.</p>\n\n\n\n<p>The results spoke for themselves:</p>\n\n\n\n<ul class="wp-block-list">\n<li><strong>Polyglots</strong> translated more than 12,000 strings, expanding WordPress’s accessibility worldwide.</li>\n\n\n\n<li>The <strong>Community team</strong> celebrated the approval of two brand-new local meetups.</li>\n\n\n\n<li>The <strong>Training team</strong> achieved its objective of updating outdated course thumbnails.</li>\n\n\n\n<li>The <strong>Core team</strong> worked through a live bug scrub, with 9 committers and 16 contributors collaborating on improvements.</li>\n\n\n\n<li>The <strong>Documentation team</strong> completed numerous content updates to keep resources fresh and reliable.</li>\n</ul>\n\n\n\n<p>Momentum carried through every table, with participants reporting measurable progress and a renewed sense of shared purpose. Contributor Day once again highlighted the unique power of collaboration in shaping the open web, proving that every contribution matters through code, translations, training, or community building.</p>\n\n\n\n<h2 class="wp-block-heading">Showcase Day: WordPress in Action</h2>\n\n\n\n<p>Wednesday, August 27, was the popular Showcase Day, spotlighting real-world innovation in WordPress. Initially expected to draw about 250 participants, Showcase Day welcomed more than 800 attendees — a powerful sign of how much energy and curiosity the community brought to Portland. The sessions demonstrated how WordPress powers meaningful work across industries from nonprofits to newsrooms, agencies to global enterprises, while staying true to open source values.</p>\n\n\n\n<p>The day opened with a keynote by Amy Sample Ward: <em>The Tech That Comes Next</em>. Drawing from their co-authored book with Afua Bruce, Amy highlighted the inequities embedded in today’s technologies — from dataset bias to accessibility gaps — and challenged attendees to rethink how tools are funded, built, and deployed. Their talk invited technologists, funders, and community leaders to imagine a more equitable digital future, rooted in collaboration and shared responsibility.</p>\n\n\n\n<figure class="wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio"><div class="wp-block-embed__wrapper">\n<iframe loading="lazy" title="WordCamp US 2025 - Amy Sample Ward &quot;The Tech That Comes Next&quot;" width="500" height="281" src="https://www.youtube.com/embed/RKnM75GFZxw?feature=oembed" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" referrerpolicy="strict-origin-when-cross-origin" allowfullscreen></iframe>\n</div></figure>\n\n\n\n<p>From there, <a href="https://youtu.be/PGvh7fCOUk0">Joeleen Kennedy</a> of Human Made shared how Full Site Editing (FSE) shapes the refresh of Wikimedia’s ongoing user experience. Her session <em>Modernizing at Scale</em> detailed how FSE is simplifying workflows, improving accessibility, and making the multilingual platform more sustainable for the long term. Attendees gained a behind-the-scenes look at how one of the world’s largest open knowledge platforms is leveraging WordPress innovation.</p>\n\n\n\n<p><a href="https://youtu.be/F4NEPcwGRCI">Josh Bryant</a> took the stage to explore what happens when Gutenberg leaves the WP-Admin dashboard. His talk, <em>Reimagining WordPress Editing</em>, walked through embedding the block editor into a standalone React application to support Dow Jones’s newsroom workflows. From decoupling Gutenberg to managing custom data stores, the session showcased advanced techniques for scaling editorial tools while maintaining the flexibility of the WordPress ecosystem.</p>\n\n\n\n<p>Hands-on learning was a hallmark of Showcase Day, with Jamie Marsland’s workshop leading participants through building and launching their own professional portfolio sites — no coding required. Attendees left with a fully functioning site, demonstrating WordPress’s continued ability to empower anyone, anywhere, to publish online.</p>\n\n\n\n<p>In the afternoon, Jeffrey Paul’s session <em>Scalable, Ethical AI</em> addressed one of the most pressing topics in today’s digital world: how to integrate AI without sacrificing ownership, privacy, or open standards. Walking participants through practical use cases with ClassifAI and local LLMs, Paul emphasized how WordPress can help content creators harness AI while maintaining autonomy over their data.</p>\n\n\n\n<p>The day closed with a forward-looking community highlight: <a href="https://events.wordpress.org/campusconnect/">WordPress Campus Connect</a>. Panelists <a href="https://youtu.be/ARqM9U0ESvo">Destiny Kanno, Andrés Parra, Javier Montes de Blas, Mauricio Barrantes, and Elineth Morera Campos</a> shared how this initiative brings WordPress into classrooms and universities worldwide. Student Andrés Parra received a scholarship to attend WordCamp. During the panel, Elineth also announced that Fidélitas University will begin offering its students a <a href="https://wordpress.org/news/2025/07/introducing-wordpress-credits-a-new-contribution-internship-program-for-university-students/">WordPress Credits</a> program starting in October 2025, making it a mandatory addition sometime in 2026, enabling them to contribute directly to WordPress as part of their studies.</p>\n\n\n\n<p>By connecting students and educators with the open web, Campus Connect is building the next generation of contributors and innovators, ensuring that WordPress remains both a learning tool and a pathway to opportunity.</p>\n\n\n\n<p>Taken together, Showcase Day affirmed that WordPress is more than just a CMS — it is a platform for equitable technology, global collaboration, cutting-edge enterprise solutions, and the future of digital education. WordPress has the power to be both a platform and a community tool for education, equity, and innovation.</p>\n\n\n\n<h2 class="wp-block-heading">Presentation Days: Learning, Inspiration, and Connection</h2>\n\n\n\n<p>The first full day of sessions at WordCamp US 2025 opened with warm remarks from the organizing team, who reminded attendees: <em>“The most important thanks goes to all of you. The mix of new energy and veteran experience is what makes WordCamp so special, so thank you for being here.”</em> That spirit of gratitude and community carried throughout the event.</p>\n\n\n\n<p>The Sponsor Hall became a hub of activity, complete with raffles, the return of Career Corner, and even a Voodoo Donut Truck parked outside. Attendees lined up to test their luck at a claw machine stuffed with plush Wapuus, while others sought guidance at the Happiness Bar — a hands-on help desk for WordPress questions big and small. Between these activities, the steady buzz of conversations made it clear: the “hallway track” remained one of WordCamp’s most valuable experiences.</p>\n\n\n\n<figure class="wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio"><div class="wp-block-embed__wrapper">\n<iframe loading="lazy" title="WordCamp US - Danny Sullivan &quot;How (and why!) Google Search Keeps Evolving&quot;" width="500" height="281" src="https://www.youtube.com/embed/ZF_sxLdfTbY?feature=oembed" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" referrerpolicy="strict-origin-when-cross-origin" allowfullscreen></iframe>\n</div></figure>\n\n\n\n<p>The program itself set a high bar. Danny Sullivan’s keynote shed light on how search has evolved to meet the needs of new generations, from 24/7 demand and mobile expectations to short-form video and AI. His session gave attendees a deeper understanding of how search intersects with publishing today and sparked conversations about how WordPress can continue adapting in an era where AI shapes discovery and content.</p>\n\n\n\n<p>From there, the schedule unfolded across multiple tracks. The Core AI panel — featuring <a href="https://youtu.be/v_0O6dQ4Q4E">James LePage, Felix Arntz, and Jeffrey Paul</a> — offered a look into how AI tools are woven into WordPress core. Emphasizing ethics, transparency, and user empowerment, the panel painted a roadmap for how WordPress can adopt new technologies without compromising its open-source values.</p>\n\n\n\n<figure class="wp-block-image size-large"><img data-recalc-dims="1" loading="lazy" decoding="async" width="1024" height="576" src="https://i0.wp.com/wordpress.org/news/files/2025/08/Programming-Day-1-2.jpg?resize=1024%2C576&#038;ssl=1" alt="" class="wp-image-19103" srcset="https://i0.wp.com/wordpress.org/news/files/2025/08/Programming-Day-1-2.jpg?resize=1024%2C576&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/Programming-Day-1-2.jpg?resize=300%2C169&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/Programming-Day-1-2.jpg?resize=768%2C432&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/Programming-Day-1-2.jpg?resize=1536%2C864&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/Programming-Day-1-2.jpg?w=1600&amp;ssl=1 1600w" sizes="auto, (max-width: 1000px) 100vw, 1000px" /></figure>\n\n\n\n<p>Hands-on learning played a significant role throughout the conference. Ryan Welcher’s interactive <em>Block Developer Cookbook</em> drew a packed room as participants worked through community-selected code recipes built on the latest WordPress APIs. By the end, attendees left with working examples and practical strategies they could bring back to their projects.</p>\n\n\n\n<p>The program also highlighted diverse technical perspectives. <a href="https://youtu.be/vBjNqdacbh4">Jemima Abu’s</a> session, <em>A PHP Developer’s Guide to ReactJS</em>, bridged the gap between classic and modern web development. At the same time, Adam Gazzaley’s keynote, <em>A New Era of Experiential Medicine – AI and the Brain</em>, invited attendees to consider the human side of technology, exploring how digital tools can advance health and well-being.</p>\n\n\n\n<p>The second day of presentations, Friday, August 29, opened with creativity and imagination. <a href="https://youtu.be/O7FPiFpRI3o">John Maeda’s</a> keynote, <em>Cozy AI Cooking: WordCamp Edition</em>, used the metaphor of a kitchen to demystify AI, blending storytelling with technical insight to show how curiosity and care can guide builders in integrating AI into their work.</p>\n\n\n\n<p>Later in the day, <a href="https://youtu.be/ORnJTpjA-4w">Tammie Lister’s</a> <em>The System is the Strategy</em> illustrated how design systems provide structure and scalability for growing WordPress projects. At the same time, Adam Silverstein’s Unlock Developer Superpowers with AI showcased new ways developers can use emerging tools to speed up workflows and problem-solving.</p>\n\n\n\n<p>Community stories also took center stage. In Creators around a Campfire, Anne McCarthy, Jamie Marsland, Christian Taylor, Mark Szymanski, and Michael Cunningham reflected on how YouTubers and content creators shape the WordPress ecosystem. Their session highlighted the role of storytelling and education in expanding WordPress’s reach to new audiences worldwide.</p>\n\n\n\n<p>The Sponsor Hall remained lively between sessions — with attendees meeting companies, testing demos, and swapping ideas that extended far beyond the conference halls. They also shared moments together at the arcade built for the event and added smiles, hugs, and laughter, which underscored the atmosphere: WordCamp US was as much about connection as code.</p>\n\n\n\n<h2 class="wp-block-heading">Together Into the Future</h2>\n\n\n\n<p>As the event drew to a close, WordPress Cofounder Matt Mullenweg took the stage to share the current state of WordPress and a vision for its future. He highlighted the growth in social media for WordPress with 124,726 new followers since last WCUS — and the WordPress.org website growing over 10% in users along with almost 20% in new users. </p>\n\n\n\n<p>Matt also spotlighted community initiatives shaping the future of open source education and diversity: WordPress Campus Connect, which has already reached 570 students across 11 events. Combined with the growth in overall events (77) which is a 32.76% increase over 2024. Each effort reinforced the message that WordPress is more than software; it is a global movement driven by people.</p>\n\n\n\n<figure class="wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio"><div class="wp-block-embed__wrapper">\n<iframe loading="lazy" title="WordCamp US 2025 - Ma.tt Mullenweg &quot;Keynote Address &amp; Q&amp;A&quot;" width="500" height="281" src="https://www.youtube.com/embed/45HRzzc0waU?feature=oembed" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" referrerpolicy="strict-origin-when-cross-origin" allowfullscreen></iframe>\n</div></figure>\n\n\n\n<p>He concluded with a live Q&amp;A, fielding questions from the audience on the direction of WordPress, its role in an AI-driven web, and the importance of keeping the project open, inclusive, and adaptable. The final notes of the keynote carried into a closing party in downtown Portland, where attendees capped off the week with music, conversation, and the unmistakable joy of a community coming together.</p>\n\n\n\n<h2 class="wp-block-heading">Closing</h2>\n\n\n\n<p>WordCamp US 2025 once again demonstrated what makes the WordPress ecosystem extraordinary: a community committed to building tools, resources, and opportunities that empower people everywhere.</p>\n\n\n\n<p>This year also marked the debut of the <a href="https://airtable.com/appWF6hdXuEOFQMvV/shrV5RZIv0aJjjU00">Open Horizons Scholarship</a>, which funded six recipients — two organizers, three volunteers, and one speaker — from five countries. A total of $14,670 supported their journeys to WCUS. The scholarship, which also supports participation at WordCamp Asia and WordCamp Europe, is designed to make flagship events more accessible to contributors worldwide.</p>\n\n\n\n<p>A heartfelt thank you goes to the organizers, volunteers, sponsors, and speakers who brought the Portland edition to life — and to every attendee who joined us in person or followed along online. We hope you leave with fresh ideas, meaningful connections, and renewed energy to help shape the future of the open web.</p>\n\n\n\n<figure class="wp-block-gallery has-nested-images columns-default is-cropped has-black-background-color has-background wp-block-gallery-2 is-layout-flex wp-block-gallery-is-layout-flex" style="border-width:20px">\n<figure data-wp-context="{&quot;imageId&quot;:&quot;6963ba34a1645&quot;}" data-wp-interactive="core/image" data-wp-key="6963ba34a1645" class="wp-block-image size-large wp-lightbox-container"><img data-recalc-dims="1" loading="lazy" decoding="async" width="1024" height="577" data-wp-class--hide="state.isContentHidden" data-wp-class--show="state.isContentVisible" data-wp-init="callbacks.setButtonStyles" data-wp-on--click="actions.showLightbox" data-wp-on--load="callbacks.setButtonStyles" data-wp-on--pointerdown="actions.preloadImage" data-wp-on--pointerenter="actions.preloadImageWithDelay" data-wp-on--pointerleave="actions.cancelPreload" data-wp-on-window--resize="callbacks.setButtonStyles" data-id="19112" src="https://i0.wp.com/wordpress.org/news/files/2025/08/20250826_215948.jpg?resize=1024%2C577&#038;ssl=1" alt="" class="wp-image-19112" srcset="https://i0.wp.com/wordpress.org/news/files/2025/08/20250826_215948-scaled.jpg?resize=1024%2C577&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/20250826_215948-scaled.jpg?resize=300%2C169&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/20250826_215948-scaled.jpg?resize=768%2C432&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/20250826_215948-scaled.jpg?resize=1536%2C865&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/20250826_215948-scaled.jpg?resize=2048%2C1153&amp;ssl=1 2048w" sizes="auto, (max-width: 1000px) 100vw, 1000px" /><button\n			class="lightbox-trigger"\n			type="button"\n			aria-haspopup="dialog"\n			aria-label="Enlarge"\n			data-wp-init="callbacks.initTriggerButton"\n			data-wp-on--click="actions.showLightbox"\n			data-wp-style--right="state.imageButtonRight"\n			data-wp-style--top="state.imageButtonTop"\n		>\n			<svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" fill="none" viewBox="0 0 12 12">\n				<path fill="#fff" d="M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z" />\n			</svg>\n		</button><figcaption class="wp-element-caption">Gale Wallace</figcaption></figure>\n\n\n\n<figure data-wp-context="{&quot;imageId&quot;:&quot;6963ba34a1b8e&quot;}" data-wp-interactive="core/image" data-wp-key="6963ba34a1b8e" class="wp-block-image size-large wp-lightbox-container"><img data-recalc-dims="1" loading="lazy" decoding="async" width="1024" height="576" data-wp-class--hide="state.isContentHidden" data-wp-class--show="state.isContentVisible" data-wp-init="callbacks.setButtonStyles" data-wp-on--click="actions.showLightbox" data-wp-on--load="callbacks.setButtonStyles" data-wp-on--pointerdown="actions.preloadImage" data-wp-on--pointerenter="actions.preloadImageWithDelay" data-wp-on--pointerleave="actions.cancelPreload" data-wp-on-window--resize="callbacks.setButtonStyles" data-id="19124" src="https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6997.jpeg?resize=1024%2C576&#038;ssl=1" alt="" class="wp-image-19124" srcset="https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6997-scaled.jpeg?resize=1024%2C576&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6997-scaled.jpeg?resize=300%2C169&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6997-scaled.jpeg?resize=768%2C432&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6997-scaled.jpeg?resize=1536%2C864&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6997-scaled.jpeg?resize=2048%2C1152&amp;ssl=1 2048w" sizes="auto, (max-width: 1000px) 100vw, 1000px" /><button\n			class="lightbox-trigger"\n			type="button"\n			aria-haspopup="dialog"\n			aria-label="Enlarge"\n			data-wp-init="callbacks.initTriggerButton"\n			data-wp-on--click="actions.showLightbox"\n			data-wp-style--right="state.imageButtonRight"\n			data-wp-style--top="state.imageButtonTop"\n		>\n			<svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" fill="none" viewBox="0 0 12 12">\n				<path fill="#fff" d="M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z" />\n			</svg>\n		</button><figcaption class="wp-element-caption">Topher DeRosia</figcaption></figure>\n\n\n\n<figure data-wp-context="{&quot;imageId&quot;:&quot;6963ba34a20e5&quot;}" data-wp-interactive="core/image" data-wp-key="6963ba34a20e5" class="wp-block-image size-large wp-lightbox-container"><img data-recalc-dims="1" loading="lazy" decoding="async" width="1024" height="576" data-wp-class--hide="state.isContentHidden" data-wp-class--show="state.isContentVisible" data-wp-init="callbacks.setButtonStyles" data-wp-on--click="actions.showLightbox" data-wp-on--load="callbacks.setButtonStyles" data-wp-on--pointerdown="actions.preloadImage" data-wp-on--pointerenter="actions.preloadImageWithDelay" data-wp-on--pointerleave="actions.cancelPreload" data-wp-on-window--resize="callbacks.setButtonStyles" data-id="19122" src="https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_7014.jpeg?resize=1024%2C576&#038;ssl=1" alt="" class="wp-image-19122" srcset="https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_7014-scaled.jpeg?resize=1024%2C576&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_7014-scaled.jpeg?resize=300%2C169&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_7014-scaled.jpeg?resize=768%2C432&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_7014-scaled.jpeg?resize=1536%2C864&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_7014-scaled.jpeg?resize=2048%2C1152&amp;ssl=1 2048w" sizes="auto, (max-width: 1000px) 100vw, 1000px" /><button\n			class="lightbox-trigger"\n			type="button"\n			aria-haspopup="dialog"\n			aria-label="Enlarge"\n			data-wp-init="callbacks.initTriggerButton"\n			data-wp-on--click="actions.showLightbox"\n			data-wp-style--right="state.imageButtonRight"\n			data-wp-style--top="state.imageButtonTop"\n		>\n			<svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" fill="none" viewBox="0 0 12 12">\n				<path fill="#fff" d="M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z" />\n			</svg>\n		</button><figcaption class="wp-element-caption">Topher DeRosia</figcaption></figure>\n\n\n\n<figure data-wp-context="{&quot;imageId&quot;:&quot;6963ba34a2647&quot;}" data-wp-interactive="core/image" data-wp-key="6963ba34a2647" class="wp-block-image size-large wp-lightbox-container"><img data-recalc-dims="1" loading="lazy" decoding="async" width="1024" height="577" data-wp-class--hide="state.isContentHidden" data-wp-class--show="state.isContentVisible" data-wp-init="callbacks.setButtonStyles" data-wp-on--click="actions.showLightbox" data-wp-on--load="callbacks.setButtonStyles" data-wp-on--pointerdown="actions.preloadImage" data-wp-on--pointerenter="actions.preloadImageWithDelay" data-wp-on--pointerleave="actions.cancelPreload" data-wp-on-window--resize="callbacks.setButtonStyles" data-id="19107" src="https://i0.wp.com/wordpress.org/news/files/2025/08/20250826_101752.jpg?resize=1024%2C577&#038;ssl=1" alt="" class="wp-image-19107" srcset="https://i0.wp.com/wordpress.org/news/files/2025/08/20250826_101752-scaled.jpg?resize=1024%2C577&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/20250826_101752-scaled.jpg?resize=300%2C169&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/20250826_101752-scaled.jpg?resize=768%2C432&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/20250826_101752-scaled.jpg?resize=1536%2C865&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/20250826_101752-scaled.jpg?resize=2048%2C1153&amp;ssl=1 2048w" sizes="auto, (max-width: 1000px) 100vw, 1000px" /><button\n			class="lightbox-trigger"\n			type="button"\n			aria-haspopup="dialog"\n			aria-label="Enlarge"\n			data-wp-init="callbacks.initTriggerButton"\n			data-wp-on--click="actions.showLightbox"\n			data-wp-style--right="state.imageButtonRight"\n			data-wp-style--top="state.imageButtonTop"\n		>\n			<svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" fill="none" viewBox="0 0 12 12">\n				<path fill="#fff" d="M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z" />\n			</svg>\n		</button><figcaption class="wp-element-caption">Gale Wallace</figcaption></figure>\n\n\n\n<figure data-wp-context="{&quot;imageId&quot;:&quot;6963ba34a2b4f&quot;}" data-wp-interactive="core/image" data-wp-key="6963ba34a2b4f" class="wp-block-image size-large wp-lightbox-container"><img data-recalc-dims="1" loading="lazy" decoding="async" width="1024" height="675" data-wp-class--hide="state.isContentHidden" data-wp-class--show="state.isContentVisible" data-wp-init="callbacks.setButtonStyles" data-wp-on--click="actions.showLightbox" data-wp-on--load="callbacks.setButtonStyles" data-wp-on--pointerdown="actions.preloadImage" data-wp-on--pointerenter="actions.preloadImageWithDelay" data-wp-on--pointerleave="actions.cancelPreload" data-wp-on-window--resize="callbacks.setButtonStyles" data-id="19108" src="https://i0.wp.com/wordpress.org/news/files/2025/08/20250825_113602.jpg?resize=1024%2C675&#038;ssl=1" alt="" class="wp-image-19108" srcset="https://i0.wp.com/wordpress.org/news/files/2025/08/20250825_113602.jpg?resize=1024%2C675&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/20250825_113602.jpg?resize=300%2C198&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/20250825_113602.jpg?resize=768%2C506&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/20250825_113602.jpg?resize=1536%2C1012&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/20250825_113602.jpg?w=1764&amp;ssl=1 1764w" sizes="auto, (max-width: 1000px) 100vw, 1000px" /><button\n			class="lightbox-trigger"\n			type="button"\n			aria-haspopup="dialog"\n			aria-label="Enlarge"\n			data-wp-init="callbacks.initTriggerButton"\n			data-wp-on--click="actions.showLightbox"\n			data-wp-style--right="state.imageButtonRight"\n			data-wp-style--top="state.imageButtonTop"\n		>\n			<svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" fill="none" viewBox="0 0 12 12">\n				<path fill="#fff" d="M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z" />\n			</svg>\n		</button><figcaption class="wp-element-caption">Gale Wallace</figcaption></figure>\n\n\n\n<figure data-wp-context="{&quot;imageId&quot;:&quot;6963ba34a309e&quot;}" data-wp-interactive="core/image" data-wp-key="6963ba34a309e" class="wp-block-image size-large wp-lightbox-container"><img data-recalc-dims="1" loading="lazy" decoding="async" width="1024" height="683" data-wp-class--hide="state.isContentHidden" data-wp-class--show="state.isContentVisible" data-wp-init="callbacks.setButtonStyles" data-wp-on--click="actions.showLightbox" data-wp-on--load="callbacks.setButtonStyles" data-wp-on--pointerdown="actions.preloadImage" data-wp-on--pointerenter="actions.preloadImageWithDelay" data-wp-on--pointerleave="actions.cancelPreload" data-wp-on-window--resize="callbacks.setButtonStyles" data-id="19113" src="https://i0.wp.com/wordpress.org/news/files/2025/08/DSC9076.jpeg?resize=1024%2C683&#038;ssl=1" alt="" class="wp-image-19113" srcset="https://i0.wp.com/wordpress.org/news/files/2025/08/DSC9076-scaled.jpeg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC9076-scaled.jpeg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC9076-scaled.jpeg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC9076-scaled.jpeg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC9076-scaled.jpeg?resize=2048%2C1365&amp;ssl=1 2048w" sizes="auto, (max-width: 1000px) 100vw, 1000px" /><button\n			class="lightbox-trigger"\n			type="button"\n			aria-haspopup="dialog"\n			aria-label="Enlarge"\n			data-wp-init="callbacks.initTriggerButton"\n			data-wp-on--click="actions.showLightbox"\n			data-wp-style--right="state.imageButtonRight"\n			data-wp-style--top="state.imageButtonTop"\n		>\n			<svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" fill="none" viewBox="0 0 12 12">\n				<path fill="#fff" d="M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context="{&quot;imageId&quot;:&quot;6963ba34a35db&quot;}" data-wp-interactive="core/image" data-wp-key="6963ba34a35db" class="wp-block-image size-large wp-lightbox-container"><img data-recalc-dims="1" loading="lazy" decoding="async" width="1024" height="433" data-wp-class--hide="state.isContentHidden" data-wp-class--show="state.isContentVisible" data-wp-init="callbacks.setButtonStyles" data-wp-on--click="actions.showLightbox" data-wp-on--load="callbacks.setButtonStyles" data-wp-on--pointerdown="actions.preloadImage" data-wp-on--pointerenter="actions.preloadImageWithDelay" data-wp-on--pointerleave="actions.cancelPreload" data-wp-on-window--resize="callbacks.setButtonStyles" data-id="19106" src="https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6809.jpeg?resize=1024%2C433&#038;ssl=1" alt="" class="wp-image-19106" srcset="https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6809-scaled.jpeg?resize=1024%2C433&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6809-scaled.jpeg?resize=300%2C127&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6809-scaled.jpeg?resize=768%2C325&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6809-scaled.jpeg?resize=1536%2C650&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6809-scaled.jpeg?resize=2048%2C866&amp;ssl=1 2048w" sizes="auto, (max-width: 1000px) 100vw, 1000px" /><button\n			class="lightbox-trigger"\n			type="button"\n			aria-haspopup="dialog"\n			aria-label="Enlarge"\n			data-wp-init="callbacks.initTriggerButton"\n			data-wp-on--click="actions.showLightbox"\n			data-wp-style--right="state.imageButtonRight"\n			data-wp-style--top="state.imageButtonTop"\n		>\n			<svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" fill="none" viewBox="0 0 12 12">\n				<path fill="#fff" d="M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z" />\n			</svg>\n		</button><figcaption class="wp-element-caption">Topher DeRosia</figcaption></figure>\n\n\n\n<figure data-wp-context="{&quot;imageId&quot;:&quot;6963ba34a3ace&quot;}" data-wp-interactive="core/image" data-wp-key="6963ba34a3ace" class="wp-block-image size-large wp-lightbox-container"><img data-recalc-dims="1" loading="lazy" decoding="async" width="1024" height="683" data-wp-class--hide="state.isContentHidden" data-wp-class--show="state.isContentVisible" data-wp-init="callbacks.setButtonStyles" data-wp-on--click="actions.showLightbox" data-wp-on--load="callbacks.setButtonStyles" data-wp-on--pointerdown="actions.preloadImage" data-wp-on--pointerenter="actions.preloadImageWithDelay" data-wp-on--pointerleave="actions.cancelPreload" data-wp-on-window--resize="callbacks.setButtonStyles" data-id="19110" src="https://i0.wp.com/wordpress.org/news/files/2025/08/DSC04553.jpg?resize=1024%2C683&#038;ssl=1" alt="" class="wp-image-19110" srcset="https://i0.wp.com/wordpress.org/news/files/2025/08/DSC04553.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC04553.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC04553.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC04553.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC04553.jpg?w=2048&amp;ssl=1 2048w" sizes="auto, (max-width: 1000px) 100vw, 1000px" /><button\n			class="lightbox-trigger"\n			type="button"\n			aria-haspopup="dialog"\n			aria-label="Enlarge"\n			data-wp-init="callbacks.initTriggerButton"\n			data-wp-on--click="actions.showLightbox"\n			data-wp-style--right="state.imageButtonRight"\n			data-wp-style--top="state.imageButtonTop"\n		>\n			<svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" fill="none" viewBox="0 0 12 12">\n				<path fill="#fff" d="M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context="{&quot;imageId&quot;:&quot;6963ba34a3fff&quot;}" data-wp-interactive="core/image" data-wp-key="6963ba34a3fff" class="wp-block-image size-large wp-lightbox-container"><img data-recalc-dims="1" loading="lazy" decoding="async" width="1024" height="576" data-wp-class--hide="state.isContentHidden" data-wp-class--show="state.isContentVisible" data-wp-init="callbacks.setButtonStyles" data-wp-on--click="actions.showLightbox" data-wp-on--load="callbacks.setButtonStyles" data-wp-on--pointerdown="actions.preloadImage" data-wp-on--pointerenter="actions.preloadImageWithDelay" data-wp-on--pointerleave="actions.cancelPreload" data-wp-on-window--resize="callbacks.setButtonStyles" data-id="19119" src="https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6827.jpeg?resize=1024%2C576&#038;ssl=1" alt="" class="wp-image-19119" srcset="https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6827-scaled.jpeg?resize=1024%2C576&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6827-scaled.jpeg?resize=300%2C169&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6827-scaled.jpeg?resize=768%2C432&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6827-scaled.jpeg?resize=1536%2C864&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6827-scaled.jpeg?resize=2048%2C1152&amp;ssl=1 2048w" sizes="auto, (max-width: 1000px) 100vw, 1000px" /><button\n			class="lightbox-trigger"\n			type="button"\n			aria-haspopup="dialog"\n			aria-label="Enlarge"\n			data-wp-init="callbacks.initTriggerButton"\n			data-wp-on--click="actions.showLightbox"\n			data-wp-style--right="state.imageButtonRight"\n			data-wp-style--top="state.imageButtonTop"\n		>\n			<svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" fill="none" viewBox="0 0 12 12">\n				<path fill="#fff" d="M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z" />\n			</svg>\n		</button><figcaption class="wp-element-caption">Topher DeRosia</figcaption></figure>\n\n\n\n<figure data-wp-context="{&quot;imageId&quot;:&quot;6963ba34a4576&quot;}" data-wp-interactive="core/image" data-wp-key="6963ba34a4576" class="wp-block-image size-large wp-lightbox-container"><img data-recalc-dims="1" loading="lazy" decoding="async" width="1024" height="576" data-wp-class--hide="state.isContentHidden" data-wp-class--show="state.isContentVisible" data-wp-init="callbacks.setButtonStyles" data-wp-on--click="actions.showLightbox" data-wp-on--load="callbacks.setButtonStyles" data-wp-on--pointerdown="actions.preloadImage" data-wp-on--pointerenter="actions.preloadImageWithDelay" data-wp-on--pointerleave="actions.cancelPreload" data-wp-on-window--resize="callbacks.setButtonStyles" data-id="19133" src="https://i0.wp.com/wordpress.org/news/files/2025/08/IMG-20250829-WA0024.jpg?resize=1024%2C576&#038;ssl=1" alt="" class="wp-image-19133" srcset="https://i0.wp.com/wordpress.org/news/files/2025/08/IMG-20250829-WA0024.jpg?resize=1024%2C576&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG-20250829-WA0024.jpg?resize=300%2C169&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG-20250829-WA0024.jpg?resize=768%2C432&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG-20250829-WA0024.jpg?resize=1536%2C864&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG-20250829-WA0024.jpg?w=2048&amp;ssl=1 2048w" sizes="auto, (max-width: 1000px) 100vw, 1000px" /><button\n			class="lightbox-trigger"\n			type="button"\n			aria-haspopup="dialog"\n			aria-label="Enlarge"\n			data-wp-init="callbacks.initTriggerButton"\n			data-wp-on--click="actions.showLightbox"\n			data-wp-style--right="state.imageButtonRight"\n			data-wp-style--top="state.imageButtonTop"\n		>\n			<svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" fill="none" viewBox="0 0 12 12">\n				<path fill="#fff" d="M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z" />\n			</svg>\n		</button></figure>\n</figure>\n\n\n\n<p>Be sure to mark your calendars for the next global gatherings: <a href="https://asia.wordcamp.org/2026/">WordCamp Asia 2026</a>&nbsp; in Mumbai, India, <a href="https://europe.wordcamp.org/2026/">WordCamp Europe 2026</a>&nbsp; in Kraków, Poland, and WordCamp US 2026 in Phoenix, Arizona. We can’t wait to see you at the next chapter of the WordPress story.</p>\n\n\n\n<p></p>\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:30:"com-wordpress:feed-additions:1";a:1:{s:7:"post-id";a:1:{i:0;a:5:{s:4:"data";s:5:"19074";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}}}s:27:"http://www.w3.org/2005/Atom";a:1:{s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:0:"";s:7:"attribs";a:1:{s:0:"";a:3:{s:4:"href";s:32:"https://wordpress.org/news/feed/";s:3:"rel";s:4:"self";s:4:"type";s:19:"application/rss+xml";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:44:"http://purl.org/rss/1.0/modules/syndication/";a:2:{s:12:"updatePeriod";a:1:{i:0;a:5:{s:4:"data";s:9:"\n	hourly	";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:15:"updateFrequency";a:1:{i:0;a:5:{s:4:"data";s:4:"\n	1	";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:30:"com-wordpress:feed-additions:1";a:1:{s:4:"site";a:1:{i:0;a:5:{s:4:"data";s:8:"14607090";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}}}}}}}}s:4:"type";i:128;s:7:"headers";a:12:{s:6:"server";s:5:"nginx";s:4:"date";s:29:"Sun, 11 Jan 2026 15:10:19 GMT";s:12:"content-type";s:34:"application/rss+xml; charset=UTF-8";s:4:"vary";s:37:"Accept-Encoding, accept, content-type";s:25:"strict-transport-security";s:12:"max-age=3600";s:6:"x-olaf";s:3:"⛄";s:13:"last-modified";s:29:"Wed, 10 Dec 2025 17:16:49 GMT";s:4:"link";s:63:"<https://wordpress.org/news/wp-json/>; rel="https://api.w.org/"";s:15:"x-frame-options";s:10:"SAMEORIGIN";s:16:"content-encoding";s:2:"br";s:7:"alt-svc";s:19:"h3=":443"; ma=86400";s:4:"x-nc";s:9:"HIT ord 1";}s:5:"build";i:1764722296;s:21:"cache_expiration_time";i:1768187419;s:23:"__cache_expiration_time";i:1768187419;}','off');
INSERT INTO `wp5_options` VALUES (167386,'_site_transient_timeout_feed_mod_9bbd59226dc36b9b26cd43f15694c5c3','1768187419','off');
INSERT INTO `wp5_options` VALUES (167387,'_site_transient_feed_mod_9bbd59226dc36b9b26cd43f15694c5c3','1768144219','off');
INSERT INTO `wp5_options` VALUES (167388,'_site_transient_timeout_feed_d117b5738fbd35bd8c0391cda1f2b5d9','1768187420','off');
INSERT INTO `wp5_options` VALUES (167389,'_site_transient_feed_d117b5738fbd35bd8c0391cda1f2b5d9','a:6:{s:5:"child";a:1:{s:0:"";a:1:{s:3:"rss";a:1:{i:0;a:6:{s:4:"data";s:3:"\n\n\n";s:7:"attribs";a:1:{s:0:"";a:1:{s:7:"version";s:3:"2.0";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:1:{s:0:"";a:1:{s:7:"channel";a:1:{i:0;a:6:{s:4:"data";s:112:"\n	\n	\n	\n	\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:1:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:16:"WordPress Planet";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:28:"http://planet.wordpress.org/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"language";a:1:{i:0;a:5:{s:4:"data";s:2:"en";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:47:"WordPress Planet - http://planet.wordpress.org/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"item";a:50:{i:0;a:6:{s:4:"data";s:21:"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:25:"Matt: Classical Accordian";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:23:"https://ma.tt/?p=151049";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:42:"https://ma.tt/2026/01/classical-accordian/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:1384:"<p>So my new obsession is a Ukrainian-born musician, <a href="http://www.hrustevich.com/en/">Alexander Hrustevich</a>, who plays a type of chromatic Russian accordion <a href="https://en.wikipedia.org/wiki/Bayan_(accordion)">called a Bayan</a>. He plays incredible transcriptions of classical pieces, replicating the parts of an entire orchestra with just two hands. If you&#8217;re familiar with Vivaldi&#8217;s Four Seasons, you know the Presto for Summer is one of the most challenging parts. Listen to this, it&#8217;s just a bit under three minutes.</p>\n\n\n\n<figure class="wp-block-embed alignwide is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio"><div class="wp-block-embed__wrapper">\n\n</div></figure>\n\n\n\n<p><a href="https://www.youtube.com/watch?v=9SE222v1eyM">Here&#8217;s the 14 minute version</a> which is beautiful to hear the dynamic range that&#8217;s possible. </p>\n\n\n\n<p>I&#8217;ve always loved the sound of a big pipe organ and the resonance and feel of the bayan. It is really quite remarkable, and it&#8217;s been very enjoyable having a playlist of Alexander&#8217;s music in the background as I work. This <a href="https://www.youtube.com/watch?v=jDXkixRjYOg">Bach-Fantasia and Fugue in G minor BWV 542 is also quite good</a>.</p>\n\n\n\n<p>My 42<sup>nd</sup> birthday is tomorrow! Working on a post for y&#8217;all.</p>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Sun, 11 Jan 2026 04:20:36 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:4:"Matt";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:1;a:6:{s:4:"data";s:21:"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:14:"Matt: Mad Ones";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:23:"https://ma.tt/?p=151045";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:31:"https://ma.tt/2026/01/mad-ones/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:433:"<blockquote class="wp-block-quote is-layout-flow wp-block-quote-is-layout-flow">\n<p>The only people for me are the mad ones. The ones who are mad to live, mad to talk, mad to be saved, desirous of everything at the same time, the ones who never yawn or say a commonplace thing, but burn, burn, burn, like fabulous yellow roman candles exploding like spiders across the stars.</p>\n</blockquote>\n\n\n\n<p>— Jack Kerouac, On the Road</p>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Sat, 10 Jan 2026 07:57:28 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:4:"Matt";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:2;a:6:{s:4:"data";s:21:"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:15:"Matt: Small Hit";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:23:"https://ma.tt/?p=151039";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:32:"https://ma.tt/2026/01/small-hit/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:1065:"<p>The NY Times has a <a href="https://www.nytimes.com/2026/01/08/technology/apple-ceo-tim-cook-john-ternus.html?unlocked_article_code=1.DFA.Qm0v.SxztBxvFrAF-&amp;smid=url-share">profile of John Ternus as a possible successor to Tim Cook</a> that has a number of ridiculous lines; it&#8217;s quite bad, but this is one of my favorites:</p>\n\n\n\n<blockquote class="wp-block-quote is-layout-flow wp-block-quote-is-layout-flow">\n<p>Apple has had many small hits under Mr. Cook and continues to be one of the most profitable companies in the world. </p>\n</blockquote>\n\n\n\n<p>Goodness! I would love to have a hit someday as the small as the ones Apple has had under Cook. <a href="https://www.theverge.com/2020/2/5/21125565/apple-watch-sales-2019-swiss-watch-market-estimates-outsold">Apple Watch sells more than the entire Swiss watch industry</a>. Airpods are the most popular headphones in the world. <a href="https://finance.yahoo.com/news/apple-richer-4-countries-164523140.html">Their market cap is bigger than the GDP of all but four countries in the world</a>.</p>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Fri, 09 Jan 2026 05:45:44 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:4:"Matt";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:3;a:6:{s:4:"data";s:21:"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:60:"Open Channels FM: Eight Years and 1.53 Million Seconds Later";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:33:"https://openchannels.fm/?p=113805";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:67:"https://openchannels.fm/eight-years-and-1-53-million-seconds-later/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:137:"With enough words spoken to fill the Harry Potter series three times over, BobWP shares some fun numbers on this 8th year of the podcast.";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Thu, 08 Jan 2026 14:00:00 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:5:"BobWP";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:4;a:6:{s:4:"data";s:21:"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:30:"Matt: Beeper &amp;amp; Day One";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:23:"https://ma.tt/?p=151033";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:37:"https://ma.tt/2026/01/beeper-day-one/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:420:"<p>Pankil Shah writes <a href="https://www.makeuseof.com/use-beeper-all-in-one-messaging-app/">I replaced WhatsApp, Telegram, and Messenger with this one app</a>. (It&#8217;s <a href="https://www.beeper.com/">Beeper</a>.) And <a href="https://www.nytimes.com/wirecutter/reviews/best-journaling-apps/">Wirecutter picks the 3 best journaling apps of 2026</a>. (It&#8217;s <a href="https://dayoneapp.com/">Day One</a>.)</p>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Thu, 08 Jan 2026 05:37:01 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:4:"Matt";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:5;a:6:{s:4:"data";s:21:"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:111:"WPTavern: #199 – Brian Coords on WooCommerce’s Challenges and Innovations in a Changing WordPress Landscape";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:48:"https://wptavern.com/?post_type=podcast&p=202139";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:122:"https://wptavern.com/podcast/199-brian-coords-on-woocommerces-challenges-and-innovations-in-a-changing-wordpress-landscape";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:55972:"<details>Transcript<div>\n<p>[00:00:19] <strong>Nathan Wrigley:</strong> Welcome to the Jukebox Podcast from WP Tavern. My name is Nathan Wrigley.</p>\n\n\n\n<p>Jukebox is a podcast which is dedicated to all things WordPress, the people, the events, the plugins, the blocks, the themes, and in this case, WooCommerce&#8217;s challenges and innovations in a changing WordPress landscape.</p>\n\n\n\n<p>If you&#8217;d like to subscribe to the podcast, you can do that by searching for WP Tavern in your podcast player of choice, or by going to wptavern.com/feed/podcast, and you can copy that URL into most podcast players.</p>\n\n\n\n<p>If you have a topic that you&#8217;d like us to feature on the podcast, I&#8217;m keen to hear from you and hopefully get you, or your idea, featured on the show. Head to wptavern.com/contact/jukebox, and use the form there.</p>\n\n\n\n<p>So on the podcast today, we have Brian Coords.</p>\n\n\n\n<p>Brian has been active in the WordPress space for over a decade, starting out in agencies, building and managing websites, and is now a developer advocate at WooCommerce, bridging the gap between woo&#8217;s internal engineers and the wider developer community. His journey includes being a high school teacher, working for nonprofits, and writing for the WP Tavern before landing his role at Automatic.</p>\n\n\n\n<p>If you&#8217;re interested in where WooCommerce and WordPress itself are headed, this episode will help as Brian shares insights on WordPress&#8217;s evolving focus, the importance of embracing AI, and how a slower pace of change can be a strength in any open source ecosystem.</p>\n\n\n\n<p>He talks about the massive rebrand at WooCommerce, the challenges and opportunities in competing with SaaS giants, and the unique developer relations role that balances his technical experience with communication skills.</p>\n\n\n\n<p>We get into how the team Brian works with supports developers and agencies with documentation, office hours, and feedback loops, and how WooCommerce&#8217;s global Reach makes for a complex but thriving ecosystem.</p>\n\n\n\n<p>There&#8217;s discussion about recent marketing efforts, the realities of open source support, and the surprising diversity of WooCommerce users worldwide.</p>\n\n\n\n<p>Towards the end, we look ahead to what&#8217;s coming for WooCommerce, which is greater integration with block based editing in WordPress Core, major investments in AI to streamline store management, and the future landscape of online shopping.</p>\n\n\n\n<p>If you want to hear how WooCommerce and WordPress are responding to a rapidly changing tech environment, this episode is for you.</p>\n\n\n\n<p>If you&#8217;re interested in finding out more, you can find all of the links in the show notes by heading to wptavern.com/podcast, where you&#8217;ll find all the other episodes as well.</p>\n\n\n\n<p>And so without further delay, I bring you Brian Coords.</p>\n\n\n\n<p>I am joined on the podcast by Brian Cords. Hello Brian.</p>\n\n\n\n<p>[00:03:09] <strong>Brian Coords:</strong> Hey, thank you for having me.</p>\n\n\n\n<p>[00:03:11] <strong>Nathan Wrigley:</strong> You&#8217;re very welcome. I have a lot of respect for Brian. I&#8217;m hoping that by the end of this podcast you also have a lot of respect for Brian.</p>\n\n\n\n<p>Brian has been kind of part of my browsing on the internet and WordPress journey, I want to say, for five or six years, something along those lines, I&#8217;ve known about you and followed your stuff. Pretty much everything that you&#8217;ve done. I&#8217;m really pleased that you&#8217;ve come on the podcast to talk to me today about WooCommerce.</p>\n\n\n\n<p>Those people that don&#8217;t know Brian, I&#8217;m going to give you an opportunity just to introduce yourself. So would you mind, I know it&#8217;s a banal question, but little potted bio, couple of minutes about your WordPress journey, or you can talk about the guitars in the background if you prefer.</p>\n\n\n\n<p>[00:03:47] <strong>Brian Coords:</strong> Yeah, nobody wants to hear me talk about or play a guitar.</p>\n\n\n\n<p>Yeah, so I&#8217;m Brian. I&#8217;m a developer advocate at WooCommerce, so I work on sort of the community side, bridging the gap between the community of developers that build on top of WooCommerce or build stores with WooCommerce, and then our internal engineers and make sure that communication channel stays open.</p>\n\n\n\n<p>But before that, I spent probably 10 years working at a WordPress agency. So building sites, managing team of developers, doing all the kind of work that a WordPress agency does and sort of lived through that time from early page builders all the way until the last few years in the rise of the block editor. So I kind of have that personal experience of what it&#8217;s like just selling WordPress websites for a living.</p>\n\n\n\n<p>And before that, my career went through a whole bunch of different places. Was a high school teacher, worked at nonprofit, all sorts of different things. So happy to be at Automattic, where I get to sort of teach, sort of build websites and just hang out with people.</p>\n\n\n\n<p>[00:04:44] <strong>Nathan Wrigley:</strong> I had no idea that you were a high school teacher. I have enormous respect for anybody who takes on a role in public education. So that&#8217;s interesting.</p>\n\n\n\n<p>So I&#8217;m going to segue a little bit. This question&#8217;s just occurred to me from everything that you&#8217;ve just said, given that you&#8217;ve been in the space of WordPress for the last 10 years, more.</p>\n\n\n\n<p>So it&#8217;s a bit of a peculiar one, but are you as excited about it as a project as you were, let&#8217;s say, 10 years ago? Do you still think that it&#8217;s got the future that you probably thought it had a decade ago?</p>\n\n\n\n<p>[00:05:13] <strong>Brian Coords:</strong> Yeah, I mean that&#8217;s a good question. I would say overall, yes, I am excited about it. I think that if there&#8217;s any concerns about WordPress or things to be not excited or scared about, it has nothing to do with WordPress and has everything to do with the internet as we know it, and AI and everything changing and economics and all these other sorts of things.</p>\n\n\n\n<p>The project itself, it seems to, I would say over the last year, really narrowed its focus on what it thinks its role is. And I think it&#8217;s adopted the AI change really well, and that&#8217;s made me very excited. I think it understands, you know, I think some of the things about WordPress is sometimes the day to day, you feel like the decisions are a little confusing, but if you look at it over the long term, it&#8217;s half the internet. So clearly the decisions tend to work out in the long run. So I think I still have faith in the project.</p>\n\n\n\n<p>[00:06:01] <strong>Nathan Wrigley:</strong> I find that the slow pace of change is actually one of its greatest strengths, but it takes an awful lot of mulling it over and sitting down and being calm with yourself to think, why hasn&#8217;t it got all these features? Why is it not keeping track of this, that, and the other thing that&#8217;s going on on the internet? But broadly, when you look back at any 2, 3, 4, 5 year period, I think usually that was the right decision, although it feels like it might not have been the right decision when that moment is passing.</p>\n\n\n\n<p>[00:06:32] <strong>Brian Coords:</strong> Yeah, there&#8217;s a lot of people who look at a lot of decisions, like say the block editor and they say, well, why didn&#8217;t they just take Elementor and stick that in Core and stuff, you know? Regardless of the fact that Elementor is a successful business that probably doesn&#8217;t want their software stolen and taken into Core. But I think if you look at it now you, a lot of those decisions would&#8217;ve seemed a little crazy.</p>\n\n\n\n<p>And the fact that it doesn&#8217;t throw everything and that it just throws the kind of basic foundational layer, and then it allows something like Elementor or any of these other page builders to be successful businesses and do their thing. The fact that it empowers that to exist, or it empowers all the other builders to exist, or it empowers WooCommerce or all these other plugins to exist, is a testament to the fact that it didn&#8217;t try to be everything to everyone, and it just kind of stayed in its lane as a foundational layer. And so I think it&#8217;s, it doesn&#8217;t feel like it&#8217;s doing that much, but it&#8217;s working out well for everyone in the ecosystem.</p>\n\n\n\n<p>[00:07:24] <strong>Nathan Wrigley:</strong> We don&#8217;t want to get into this, in fact, I&#8217;m going to insist that we don&#8217;t get into this. But I think it is a really interesting time with the tsunami of things that are going on with AI to see how a CMS can cope with the future with AI as a possible tool to do everything. To do every single thing that would be required in building a website. It&#8217;ll be interesting to see how the project goes.</p>\n\n\n\n<p>And, you know, there&#8217;s a lot going on there, and I think this is one of those moments where we have to just sort of sit down and be calm and see what the teams are doing and just have faith. I think at least that&#8217;s my position anyway. So you don&#8217;t have to respond to that if you don&#8217;t want to.</p>\n\n\n\n<p>[00:08:00] <strong>Brian Coords:</strong> Yeah, I&#8217;m just overwhelmed by AI sometimes on my day-to-day work. And so I do have to remind myself the only thing you can do is sit and go slow and just see what happens, because I don&#8217;t think we can predict it.</p>\n\n\n\n<p>[00:08:11] <strong>Nathan Wrigley:</strong> No, I think you would be right. So when you joined Automattic, how long ago was that now? Roughly.</p>\n\n\n\n<p>[00:08:16] <strong>Brian Coords:</strong> Almost a year. Early this year.</p>\n\n\n\n<p>[00:08:18] <strong>Nathan Wrigley:</strong> Yeah. Did you have intuitions at that point that WooCommerce was where you were going to end up? Was that where you were heading or is that just sort of serendipity?</p>\n\n\n\n<p>[00:08:26] <strong>Brian Coords:</strong> No, well, not really. When I first started, I kind of was all over the place. I was here at WP Tavern for a few weeks as part of that trial writing project. I did some work with wordpress.com and kind of got to see behind the scenes of that, and I had friends at all different parts of the company.</p>\n\n\n\n<p>What I knew that I wanted to do was developer advocacy or what some people call developer relations. I knew that that&#8217;s where the role that I wanted, but I don&#8217;t think I would&#8217;ve thought of Woo. But then when the opportunity came up, there was a lot that I really liked about WooCommerce that I thought it had such a strong idea of what the product is, who the customers are. They had just done that rebrand where they had the new logo and the new colours and the new design. It felt like the whole company was kind of just doing really cool things.</p>\n\n\n\n<p>So once the opportunity came up, I&#8217;ll be honest, I didn&#8217;t build a lot of WooCommerce stores before I joined. So other than being kind of afraid of learning all of this stuff it was, definitely it made sense once the opportunity came up.</p>\n\n\n\n<p>[00:09:22] <strong>Nathan Wrigley:</strong> Yeah. With the sort of WooCommerce side of things, are you happy with that move? You know, you&#8217;ve got your feet onto the table now and you feel that&#8217;s where you&#8217;re going to stay, I guess, for the near future.</p>\n\n\n\n<p>[00:09:32] <strong>Brian Coords:</strong> Yeah, definitely. What&#8217;s interesting about Automattic is over the last year, since I joined it&#8217;s been kind of a turbulent year at the company, but one of the things they&#8217;ve been really trying to do is centralise things and be more consistent.</p>\n\n\n\n<p>So in WooCommerce, there&#8217;s a lot of stuff that WooCommerce would go off and do, and it would be kind of different from say, Core WordPress or wordpress.com or WordPress VIP, or all these different kind of parts of WordPress inside of Automattic.</p>\n\n\n\n<p>And over the last year, they&#8217;ve tried to kind of centralise and say, why do we have three different plugins that are doing similar things. Or why can&#8217;t we streamline all of this or have everybody working on the same stuff. So WooCommerce has been doing a lot of work really towards Core WordPress, and making the Core WordPress experience better so that WooCommerce can use those tools instead of doing it.</p>\n\n\n\n<p>So in a weird way, I&#8217;ve actually gotten to collaborate a lot more with some of the other sides of the company and people who do this job but are not in WooCommerce. There&#8217;s a whole team that has people like, let&#8217;s see, Ryan Welcher, Justin Tadlock, Jonathan Bossenger, that whole group. So it&#8217;s kind of nice. We&#8217;re in our little Woo bubble too, but then I get to work with them and learn from them, and work on Core WordPress too. So it&#8217;s kind of, it&#8217;s been nice. We&#8217;ve kind of brought everyone a little closer, I think.</p>\n\n\n\n<p>[00:10:42] <strong>Nathan Wrigley:</strong> It is kind of interesting over the last 18 months or so, having spoken to quite a few Automatticians, it does feel like the landscape inside the company has changed. I don&#8217;t think we need to go into that, but it is interesting you saying that, because feels there was some realignment and moving around, and decisions about which teams were going to collaborate more with which teams. And that seems like what you are saying as well, so there we go.</p>\n\n\n\n<p>So on the WooCommerce side of things, you mentioned that you are a developer, well, you said developer advocate, developer relations, kind of the same term really. For anybody listening to this who doesn&#8217;t know what that is, basically, what is the job contract that you&#8217;ve got there? What is your role?</p>\n\n\n\n<p>[00:11:19] <strong>Brian Coords:</strong> Yeah, so we cover a few different things. From a high level, it really is, we&#8217;re there to help developers inside the company know what developers outside the company are doing and vice versa. So if you&#8217;re building stores with WooCommerce or you&#8217;re building extensions to sell in the marketplace, you know, like plugins that add-on to WooCommerce, or you&#8217;re working at one of our partner companies like Stripe and Google and Snapchat and Reddit and all these companies that integrate with WooCommerce, our job is to make sure that you have access to good documentation and good examples.</p>\n\n\n\n<p>We make sure that when a new version of WooCommerce comes out, which is every five weeks, that we publish all the release notes, and make sure that that information is, you know what&#8217;s coming, what&#8217;s changing, what&#8217;s different. We do some video content, we do some office hours hangouts in a community Slack, we keep an eye on the repo for community contributions. So it&#8217;s a lot of different things, but it&#8217;s really just, at the end of the day like, hey, does this help developers on either side of the wall move forward basically?</p>\n\n\n\n<p>[00:12:19] <strong>Nathan Wrigley:</strong> Do you have to be technical in order to carry out your role, or would there be any scope for somebody in your position to be non-technical? Let&#8217;s say, you&#8217;re a marketing person or something like that. Is there any aspect of that to it? Or is everybody doing your kind of role a technical person with a background in coding and what have you?</p>\n\n\n\n<p>[00:12:37] <strong>Brian Coords:</strong> It&#8217;s a unique role and it&#8217;s kind of a long debate inside of the developer relations community is, does this team go in an engineering department or does it go in the marketing department?</p>\n\n\n\n<p>So for example, at Automattic there is another developer relations team that handles a lot of that WordPress Core stuff that I was talking about, and they&#8217;re kind of a little more attached to engineering.</p>\n\n\n\n<p>For our team, we&#8217;re part of the WooCommerce marketing department. So of course that&#8217;s going to change a little bit of what we work on, how our decisions are made, that sort of stuff. I don&#8217;t think it changes that much, and in some ways it gives us access to a lot of cool stuff like their design team, which is really nice to have.</p>\n\n\n\n<p>So it goes both ways, but you really have to be a unique person where you have to be a good communicator, and you have to have some amount of technical experience. You kind of really need both, because at the end of the day we look at a new version of WooCommerce and it&#8217;s, oh, we changed this API and it&#8217;s going to affect developers in this way. It&#8217;s like, I need to be able to communicate that. I need to be able to understand it. I need to be able to know what the implications of that are. So it&#8217;s kind of both.</p>\n\n\n\n<p>[00:13:35] <strong>Nathan Wrigley:</strong> Do you produce this content in multiple languages or is it kind of English first and then it gets translated in some other department, or indeed does it get translated into another language, do you know?</p>\n\n\n\n<p>[00:13:45] <strong>Brian Coords:</strong> No, I think pretty much English first. There is a lot of stuff that is translated for, I would say on the, what we call like the merchant side, sort of like the user side. So if you&#8217;re looking for extensions in the marketplace, that&#8217;s available in a lot of different languages. The software itself is translated, but the developer stuff is pretty much English only. Because we&#8217;re a really small team. Like when we look at, there&#8217;s only, at any time, three or four of us working on this for software that&#8217;s on whatever, 8% of the internet, so English only for now.</p>\n\n\n\n<p>[00:14:13] <strong>Nathan Wrigley:</strong> Yeah, the reason I ask, maybe you were present at State of the Word where Matt went through a bunch of statistics. And it was curious to see, for the first time, so WordPress more broadly, not WooCommerce specifically, but WordPress more broadly is now used on non-English websites more than it is on English websites. And so if we&#8217;d have had this interview a week ago, that question probably would not have arisen.</p>\n\n\n\n<p>But I&#8217;m guessing that WooCommerce goes along for the ride there. I&#8217;m guessing it&#8217;s not just on English speaking websites, I&#8217;m guessing WooCommerce is just literally in more or less every part of the world, in every locale and every jurisdiction. There are people who are using your code, but probably not speaking English.</p>\n\n\n\n<p>[00:14:52] <strong>Brian Coords:</strong> That&#8217;s definitely the case. So we have a free Slack, that&#8217;s the WooCommerce Community Slack, and it&#8217;s more than 30,000 people in there. It&#8217;s all over. You can definitely tell that people are coming from all over the world.</p>\n\n\n\n<p>One of the weird things about e-commerce is it&#8217;s very geographically based because the currency matters. The payment provider that handles the payments matters. The shipping options matter. So there are certain places where you can only use WooCommerce because you want to use the custom bank payment provider that&#8217;s only in this one country, that sort of stuff.</p>\n\n\n\n<p>So because of how diverse the types of integrations you would need, yeah, WooCommerce is very global. That was one of the things that really surprised me was finding out that, oh yeah, there&#8217;s payment providers you&#8217;ve never heard of, and banks you&#8217;ve never heard of, and shipping companies you&#8217;ve never heard of and they need to integrate.</p>\n\n\n\n<p>[00:15:40] <strong>Nathan Wrigley:</strong> And tax. So much tax, I&#8217;m sure.</p>\n\n\n\n<p>[00:15:43] <strong>Brian Coords:</strong> Oh my, yeah.</p>\n\n\n\n<p>[00:15:45] <strong>Nathan Wrigley:</strong> I&#8217;m sure it gets brutal. I don&#8217;t know exactly when the time was, but it feels like about, I&#8217;m going to say 18 months or something, when Woo underwent a fairly significant rebranding. So from a marketing point of view, the logo changed, the colour palette changed, the website changed.</p>\n\n\n\n<p>I didn&#8217;t really notice until that moment when it did change that it needed to have changed, if you know what I mean? It just always looked fine to me. But the moment it changed, I kind of got a sense that, oh, okay, this is real now. We&#8217;ve kind of identified that there are these SaaS players, so you know, we don&#8217;t need to name them, we all know who they are, where you pay your monthly fee and you get a shop and yada, yada, yada. But I don&#8217;t know if that&#8217;s a part of the roadmap.</p>\n\n\n\n<p>And summing it up as more serious, obviously that&#8217;s trivial and a bit, really not the right term, but do you know what I mean? It feels like WooCommerce has, I don&#8217;t know, grown up a little bit over the last 18 months and realises the, I don&#8217;t want to use the word fight, but I&#8217;m going to, the fight that it&#8217;s in with the SaaS players.</p>\n\n\n\n<p>[00:16:41] <strong>Brian Coords:</strong> Yeah, I think that was the intention of that rebrand. So I think the goal was to go from saying, hey, we&#8217;re a WordPress plugin that lets you sell things. To saying, we&#8217;re an e-commerce solution, and we happen to run on WordPress. It&#8217;s kind of just a different framing.</p>\n\n\n\n<p>But one of the big things is a huge investment in marketing. And so the marketing team has gotten really big. We have a pretty killer CMO. There&#8217;s a ton of investment into different types of ads and demand generation and leads and all this stuff that I kind of don&#8217;t understand, a lot of like acronyms that are thrown around that I don&#8217;t fully track. But it&#8217;s a huge investment to basically reposition WooCommerce as something that feels a bit more modern and, not a SaaS, but kind of can sit there next to the SaaS. So when a company is looking at the options and they&#8217;re saying, oh, do we want to use Magento or BigCommerce or Shopify or WooCommerce, we look like we belong there, and it looks like it&#8217;s an option.</p>\n\n\n\n<p>[00:17:36] <strong>Nathan Wrigley:</strong> Yeah, it&#8217;s kind of curious that there&#8217;s, real money has to be spent on this endeavor because, I was in London just a few weeks ago and I walked onto the Tube, you know, the underground train network. And the platform that I was on, the first thing that I saw when I walked onto the platform was this huge ad for Shopify. And then I looked left and I looked right and it was Shopify ads all the way down. They&#8217;d obviously, I mean I can only imagine how expensive that real estate is.</p>\n\n\n\n<p>But the same thing would be true on radio, on TV, online, on print. These companies have gigantic, I mean truly eye watering budgets. And I don&#8217;t know if the WooCommerce side has to be a bit more guerrilla or if you also have a fairly gigantic budget. I don&#8217;t know if you&#8217;re able to peel any of that back. It sounds like marketing&#8217;s not really your thing, but maybe there&#8217;s bit of interest there.</p>\n\n\n\n<p>[00:18:25] <strong>Brian Coords:</strong> Yeah, I mean since we&#8217;re in the team, we see a lot of it. We did an event earlier this year where our marketing team walked through some of this stuff, so I can maybe give you a link to put in the show notes. We kind of wrote it, did a write up about that very concept. Because we get asked that a lot, why am I seeing Squarespace and Shopify ads everywhere? And it&#8217;s, you know, obviously if you look at the size of the companies, it&#8217;s a fact, like a whole factor difference, like we&#8217;re not anywhere near the size of those companies.</p>\n\n\n\n<p>And part of the issue is that you don&#8217;t just go to woocommerce.com and hand us money, you know? The Core plugin is free so the way we monetise is a lot different. You can run it anywhere. You can, a lot of people that run WooCommerce, they&#8217;re not paying us in any way because they&#8217;re using their own payment providers and those sorts of things.</p>\n\n\n\n<p>So it is definitely more of a challenge. But this past year, that&#8217;s why the rebrand started, that&#8217;s why they&#8217;ve been investing in it. And it&#8217;s been kind of cool. There&#8217;s a lot of podcast ads that we&#8217;ve been running and LinkedIn ads and all these sorts of things. And part of the issue too is that our target market is just much more narrowly defined, and so WooCommerce is much more customisable. It&#8217;s extensible. You can do whatever you want with it. And that&#8217;s just a different value proposition then you would say to somebody who just wants the easy SaaS solution.</p>\n\n\n\n<p>So it&#8217;s a lot of things, but it&#8217;s kind of just knowing who we want and targeting directly to them. And so you probably won&#8217;t see ads on the Tube at any time, but for certain areas you&#8217;re going to start seeing really targeted ads for people at the places that would actually really benefit from having WooCommerce.</p>\n\n\n\n<p>[00:19:51] <strong>Nathan Wrigley:</strong> That was the thought that I had about seeing the Shopify, in this case, ad on the London underground was just how much the audience, the eyeballs that were actually staring at that had no interest in it at all. And so almost like the bottomless pit of money that they must have to throw at these things. And obviously it sounds like you are targeting people.</p>\n\n\n\n<p>Are you kind of like riding on the coattails of WordPress in general? In other words, are you targeting existing WordPress users in the hope that they&#8217;ll think, okay, yeah, we&#8217;ve got a WordPress site, now it&#8217;s time to upgrade to WooCommerce, or is it a bit more scatter gone, you need a website, you need e-commerce, we&#8217;re your solution?</p>\n\n\n\n<p>[00:20:26] <strong>Brian Coords:</strong> Yeah, I mean that&#8217;s an interesting question because I think when WordPress was growing, it was a lot easier to target inside of WordPress, and I think now we&#8217;re seeing all the big companies reevaluate that. So I would say the ads that I see a lot are, you know, Hostinger, Elementor, wordpress.com. And I think a lot of them are realising now, you know, we need to target outside.</p>\n\n\n\n<p>So for example, WooCommerce this year, we go to all the WordCamps, but we started going to e-commerce expos that are trade shows that are not anything to do with WordPress. It&#8217;s just for people in the commerce industry and partnering with companies that are in the marketing and commerce side. And so, yeah, it really is about branching out and finding those new areas.</p>\n\n\n\n<p>I think all WordPress companies are going to kind of have to start facing that as well because WordPress is 43% of the web. It&#8217;s like, how much bigger realistically can you get, once we pass 50%? I mean that&#8217;s, it&#8217;s pretty hard to grow at that point.</p>\n\n\n\n<p>[00:21:19] <strong>Nathan Wrigley:</strong> Did you attend any of those events? The sort of expos for e-commerce more generally?</p>\n\n\n\n<p>[00:21:23] <strong>Brian Coords:</strong> No.</p>\n\n\n\n<p>[00:21:24] <strong>Nathan Wrigley:</strong> Yeah, I was going to follow up with a question about whether or not there was brand recognition. At those events, if you&#8217;ve got a WooCommerce stall, I was curious as to know what proportion of the public would walk past a WooCommerce sign and go, yeah, yeah, I know what that is, I&#8217;ve got complete familiarity with it. I feel like some of the SaaS ones, maybe they&#8217;ve done that job so well that that brand recognition is there, but maybe that work still needs to be done on the Woo side, I&#8217;m not sure.</p>\n\n\n\n<p>[00:21:49] <strong>Brian Coords:</strong> There&#8217;s definitely not going to be the same level of brand awareness. I think, like you said, like guerrilla marketing is definitely part of it. One of the things they do at these is they&#8217;ll find a local store that uses Woo and use them for swag. So they&#8217;ll get really good swag. They did like homemade, like embroidery things and all this sort of stuff. And so they end up getting very popular because of how cool the swag is, and how meaningful it is, and it supports a local merchant. But yeah, it&#8217;s a big battle, you know, to raise that brand awareness.</p>\n\n\n\n<p>[00:22:18] <strong>Nathan Wrigley:</strong> Okay, let&#8217;s just turn a bit more to your Dev Rel stuff. And you were saying that, well, I don&#8217;t need to repeat what you said. You said a little while ago, who it is that you are interfacing with out in the real world.</p>\n\n\n\n<p>How does that work? Like, do you just sort of put content out there and tutorials out there and videos out there and change logs out there, and kind of hope that the people that need it get to see it somehow? Or is there more of an endeavor of, I don&#8217;t know, providing the bat phone, for want of a better word, to agencies and people so that they can communicate directly with you? How does that whole thing work?</p>\n\n\n\n<p>[00:22:48] <strong>Brian Coords:</strong> Yeah, so it&#8217;s interesting because there&#8217;s definitely different audiences that we have. So we have developers who are building extensions and are, you know, they&#8217;re selling WooCommerce plugins basically. And so we have them that we need to communicate with. And then we have the agencies and the agencies are building WooCommerce stores for people. So they&#8217;re setting up WooCommerce.</p>\n\n\n\n<p>And those two audiences, they both need some of the same information, but they also need a lot of different information. And so we&#8217;ve kind of seen a lot of change over the last year.</p>\n\n\n\n<p>Automattic has launched a program called Automattic for Agencies. I&#8217;m not sure if you&#8217;ve seen this. It&#8217;s kind of like an agency program where you sign up and you get access to extensions, you can get affiliate fees, you can get kickbacks on payments, volume, all that sort of stuff.</p>\n\n\n\n<p>So that side has really, sort of owned the agency space. And so what&#8217;s nice is we can go to them with any new information. We could say, hey, just pass this along to your audience in your next newsletter, that sort of thing. But really, if we want to have the conversations, I would say the Slack is the most common and we never lack for feedback. We get plenty of feedback. We do a monthly office hours in Slack or sometimes on Zoom, where developers will come and share their questions, that sort of thing. So we get tons of feedback. But yeah, it&#8217;s really just about being present there, being present on Twitter. We&#8217;re ramping up YouTube, because YouTube&#8217;s really important right now. And we&#8217;re just, like I said, small team and trying to hit all of those different content areas.</p>\n\n\n\n<p>[00:24:13] <strong>Nathan Wrigley:</strong> My sort of follow up question there really was going to be something about shouting into the void and I wondered if that, it was in fact what was happening. But it sounds from what you are saying is if, no, there is an actual loop there. You put stuff out and you get feedback. I mean I&#8217;m guessing, from the sounds of it, there&#8217;s maybe more feedback than you can actually cope with, which is intriguing. I had an intuition that would be the other way around.</p>\n\n\n\n<p>[00:24:32] <strong>Brian Coords:</strong> Yeah, I mean it definitely depends on, sometimes you get feedback that&#8217;s kind of the same. We know what people want, and we&#8217;re trying to work as fast as we can to make the changes that developers and the community want. And sometimes you put out a feature and it doesn&#8217;t resonate.</p>\n\n\n\n<p>But generally when we do calls for testing of a new feature we&#8217;ll post, all right, we have a new feature coming, it&#8217;s in experimental mode, here&#8217;s how to turn it on and then let us know if it&#8217;s working for you, if it&#8217;s working with your plugin and stuff. We definitely have a pretty healthy group that will take the time to contribute back, let us know if things are working. I mean it&#8217;s an open source project. We get community pull requests. We get people, they need a feature, they build it and submit it and, you know, hopefully we merge it. And so the feedback loop is definitely there.</p>\n\n\n\n<p>But if you&#8217;re, the thing that I&#8217;ve learned about WordPress is that I think it&#8217;s like an iceberg and like 90% of the WordPress community, they&#8217;re not really listening to WordPress content, and they&#8217;re not listening, they&#8217;re not even tracking WordPress in general. And so I think there&#8217;s probably a much broader community that we&#8217;re not getting access to, and they&#8217;re just living their daily lives and just building stores and stuff. And so I would love to find more of those groups. I think Facebook is probably a place that we haven&#8217;t even touched yet, and I&#8217;m sure a lot of them are there. There&#8217;s definitely work to be done there.</p>\n\n\n\n<p>[00:25:46] <strong>Nathan Wrigley:</strong> Yeah, I think that was maybe the piece that I was thinking. Is that Woo is the biggest solution out there. If memory serves, Woo is the biggest e-commerce platform out there. It kind of dwarfs all the others. I don&#8217;t even know if WooCommerce is bigger than the rest of them combined but, you know, it&#8217;s on that kind of level.</p>\n\n\n\n<p>And yet, if you were to have a, I don&#8217;t know, a Shopify store or something, there is probably like a little submit feedback button in the UI somewhere, and you can talk to the support representatives, and they&#8217;ll have the answer specifically because they know exactly what the platform does.</p>\n\n\n\n<p>But the jigsaw puzzle over on the Woo side is, yeah, it must be much more messy, much more kind of difficult to wrangle everything. You know, you&#8217;ve got people, end users who are using WooCommerce. You&#8217;ve got developers who are building plugins. You&#8217;ve got agencies who are building on behalf of clients. You&#8217;ve got people who are building rival things so you&#8217;re in direct competition with people in the plugin space who are building rivals to WooCommerce. It&#8217;s just, well, messy. But that&#8217;s open source, right?</p>\n\n\n\n<p>[00:26:44] <strong>Brian Coords:</strong> I mean that&#8217;s exactly what it is. You know, we have, you have WooCommerce support, right? And our support team is really great. Every time I go to a conference and one of our support engineers is there, I&#8217;m always pointing to them to answer all the questions because they know the product so deeply.</p>\n\n\n\n<p>But if you imagine the, you know, most WooCommerce stores will come to us for support, but there&#8217;s no financial relationship. If they&#8217;re not using our hosting company or they&#8217;re not using Woo Payments, or they&#8217;re not using extensions that they bought in the marketplace, maybe they bought their extensions just off the internet or something, there&#8217;s a good chance they might not be paying us any money at all. And yet, you know, we&#8217;re going to support them and make sure that they&#8217;re having a good experience, because that&#8217;s kind of the goal of it. So it&#8217;s definitely a bit of the Wild West out there.</p>\n\n\n\n<p>[00:27:28] <strong>Nathan Wrigley:</strong> There must be some kind of strange tension there as well. I mean, you&#8217;ve described it very eloquently and I think you&#8217;ve stepped around that beautifully, but that is a peculiar thing, isn&#8217;t it, that you would not have to deal with elsewhere? The fact that you may very well be dealing with rivals. You may well be dealing with people who are using up your time, but like you said, they have no relationship with you financially at all, but they built something, third party thing on top of the WooCommerce ecosystem, and I guess that&#8217;s just the broader philanthropic goal of something like WooCommerce. You&#8217;ve just got to step up and be there.</p>\n\n\n\n<p>[00:28:00] <strong>Brian Coords:</strong> Yeah, I mean I think wordpress.com probably has a lot of the same things because if you Google WordPress, you know, you&#8217;re probably going to end up on wordpress.com, even if you&#8217;re not their customer.</p>\n\n\n\n<p>On the flip side though, you know, the benefit of being open source is that, like I said, we get community contributions. We get a lot of eyes on the software. A lot of people, they give us feedback, they give us code, they give us all sorts of things. So it is a bit of a trade off.</p>\n\n\n\n<p>But I think it&#8217;s kind of worth it for the software to just exist freely and for everybody who runs on it, to always kind of know deep down that they own their store and they can do whatever they want with it, and they can put it wherever they want, and Automattic or WordPress or WooCommerce is never really going to take that away from them or take them down, you know?</p>\n\n\n\n<p>[00:28:38] <strong>Nathan Wrigley:</strong> Yeah, I&#8217;d be curious to know what proportion of Woo kind of props up the broader WordPress project, if you know what I mean? I don&#8217;t think we need to go into that, and I don&#8217;t know if there&#8217;s any data out there anywhere, but there must be a lot of money sloshing around inside the WooCommerce ecosystem. It&#8217;d be interesting to know what proportion the broader WordPress ecosystem was was made up of just Woo stuff. That&#8217;d be an interesting thing to dig into.</p>\n\n\n\n<p>[00:29:01] <strong>Brian Coords:</strong> When I worked at an agency, the kind of rule was if you wanted to make money making websites, you did websites that made money. So e-commerce was a big part. People, you know, their website&#8217;s more critical to their business, so they&#8217;re going to be buying more plugins, they&#8217;re going to be paying more developers, they&#8217;re going to be using more tools. So I think that&#8217;s part of it. E-commerce isn&#8217;t the only way websites make money. There&#8217;s definitely a lot of other things, big publishers and that sort of stuff. But yeah, it&#8217;s definitely a big part of the community.</p>\n\n\n\n<p>[00:29:26] <strong>Nathan Wrigley:</strong> Well, big and not going anywhere. Speaking of going places though, what&#8217;s coming up in the near future? So when we&#8217;re recording this, it&#8217;s kind of the middle of December. I imagine this episode will hit in the beginning of 2026 at some point. Roughly around that kind of time, what&#8217;s the thinking? What are the, some of the top level items that people may not know about? What&#8217;s the stuff that you&#8217;re working on? Roadmap stuff, I guess.</p>\n\n\n\n<p>[00:29:46] <strong>Brian Coords:</strong> Yeah, I would say the big things that I&#8217;ve seen that are really the big focus right now is, number one is really making WooCommerce closer to WordPress Core, which means making WordPress Core a little better. So WooCommerce has been pretty ahead of the curve of transitioning to blocks, using block templates and block based everything. So, I mean you can do your whole WooCommerce store in the block editor, which gives you a lot of kind of design freedom. But that means if we need something better in the block editor, we&#8217;ve got to commit that up to the block editor and make Gutenberg better. So there&#8217;s a lot of work to improve a lot of stuff inside of Gutenberg so that your WooCommerce experience is better.</p>\n\n\n\n<p>So that&#8217;s been a lot of the focus. And so we&#8217;re, there&#8217;s a lot of cool stuff coming around just new blocks, new block designs, patterns, things you can do to really customise the visual aspects of your store. And then the second big thing, I think that is taking up everybody&#8217;s mental space is AI. You can&#8217;t not talk about it. So it&#8217;s, that&#8217;s the other piece.</p>\n\n\n\n<p>[00:30:42] <strong>Nathan Wrigley:</strong> Okay, despite the fact that it consumes all the air in the room, it is so fascinating. Do you have any insight into some of the things that may be on the agenda for a WooCommerce store owner in the near future? The kind of things that you are thinking of. Even if they&#8217;re just aspirational for a WooCommerce store owner. I&#8217;d be curious to hear your thoughts on that.</p>\n\n\n\n<p>[00:31:01] <strong>Brian Coords:</strong> Yeah, I think there&#8217;s two different aspects of it that are really going to be important. One is managing your store. So we have right now in beta what&#8217;s called an MCP server in Woo. And what it basically lets you do is open up, you know, ChatGPT or Claude or something and say, log into my WooCommerce store and update all my products, put them on sale, change out the pictures, write better copy for them. It kind of lets AI log into your store and do things for you.</p>\n\n\n\n<p>And so that&#8217;s in beta right now, and it&#8217;s pretty cool. I&#8217;ve been using it. It&#8217;s pretty neat. I&#8217;ve been setting up some demo stores for people, and I just go, all right, log in and make me, you know, 50 fake sweaters with a nice description in different colours. And it does it. It&#8217;s kind of mind blowing.</p>\n\n\n\n<p>[00:31:43] <strong>Nathan Wrigley:</strong> Do you trust it at this point? And I don&#8217;t mean, you know, the broader kind of debate about AI and whether it&#8217;s trustworthy. I mean, in terms of the store, you know, do you trust it to update all of the particular product lines and what have you, or update the images? Do you feel that if you&#8217;ve given that prompt, you can sort of sit back and go, okay, that is definitely being done?</p>\n\n\n\n<p>[00:32:02] <strong>Brian Coords:</strong> I haven&#8217;t done it on a live site, I will say. The nice thing too is you can have it ask you for permission every single time, and you can kind of see what it&#8217;s going to do. That obviously kind of ruins the whole efficiency part of it, but it can do that. So I think it&#8217;s early days.</p>\n\n\n\n<p>But I do think, once you start interacting where you don&#8217;t have to actually log in and click a bunch of buttons, and you can just tell your computer what you want it to do, I think it&#8217;s going to be hard to come back from that. I think people are going to start expecting it. But I, yeah that&#8217;s, I mean we&#8217;re not doing that on the live, on any live sites, I hope not.</p>\n\n\n\n<p>[00:32:32] <strong>Nathan Wrigley:</strong> So that was half of it by the sounds of it. That was one of the threads. What was the other one?</p>\n\n\n\n<p>[00:32:35] <strong>Brian Coords:</strong> The other one, I think is about how people are going to be shopping in the future. And I think showing up, obviously all these chat companies, they need to make money, and we know that they&#8217;re going to start showing ads and they&#8217;re going to start wanting to do the same thing when you go to Google, and you look up something and it gives you some shopping recommendations and shows you some products you might want to buy and some ads. You know, we&#8217;re going to start seeing that in our chat bots and stuff.</p>\n\n\n\n<p>And so I think it&#8217;s going to be important for people that have WooCommerce stores, they want their products to show up there, and they want their ads to show up there, and they want to make sure that people who are using AI to get product recommendations, which my wife does all the time, that they&#8217;re going to show up there. So I think that&#8217;s the other half of it.</p>\n\n\n\n<p>[00:33:13] <strong>Nathan Wrigley:</strong> Yeah. Do you know it&#8217;s really curious, the whole, what we might have called SEO, which is fast giving way, I think, to AI. It&#8217;s kind of curious. I think there&#8217;s like a whole section where the discovery of the website is going to be everything. So an example might be apparel. I don&#8217;t suppose anybody&#8217;s just going to buy a blouse or a shirt based upon some text that they saw in a chat bot, but getting to that page and saying, find me, locally to me, find me a place which sells, I don&#8217;t know, affordable shirts for work, or something along those lines. And have a recommendation, which gets you to the WooCommerce store.</p>\n\n\n\n<p>But for more utilitarian things, just the stuff that you don&#8217;t really care about like, I want to buy a bunch of nuts and bolts, or hammers, or spanners, or whatever it may be, I feel like there&#8217;ll be a point where the store itself, obviously all of that commerce will take place in the store, but it will be invisible to you as a user. You&#8217;ll just tell the AI, buy these things, I need 50, or even just repeat the order from last month for these things, and it&#8217;ll just magically happen in the background. You&#8217;ll get a receipt via email, and WooCommerce will have handled it. The site will have been notified in some way, but you&#8217;ll have had no interaction. So it&#8217;s kind of scary, but interesting at the same time.</p>\n\n\n\n<p>[00:34:23] <strong>Brian Coords:</strong> I think one of the thing, I think Google&#8217;s the best example because I think WordPress and Google have this really symbiotic relationship because we make the websites and they provide the traffic. And I think it&#8217;s been good for both of them. They want a bunch of websites to send people to, and we want them sending people to our websites. And so I think Google&#8217;s a great example.</p>\n\n\n\n<p>But they&#8217;ve had product recommendations that you can connect to your WooCommerce store, you know, for a while now. It&#8217;s kind of in some ways not really that different from just Googling something. Google shows you some products and then you click through and you buy it.</p>\n\n\n\n<p>If it becomes that seamless where you don&#8217;t even have to realise you&#8217;re going to a website, which I think is possible, I also wonder, will people want to do that? Will they feel as trustworthy? Maybe, maybe not. But either way, that is probably going to be the case.</p>\n\n\n\n<p>And so that&#8217;s going to require a lot of these, the discussion&#8217;s already happening. They have these payment protocols and things, and we&#8217;re starting to see the very beginning of it. So it&#8217;s kind of interesting to be inside of WooCommerce because the companies that do all this stuff, the Stripes and the PayPals and the Googles and stuff, these are partners that they work closely with. And you get to see a little behind the scenes of them trying to figure this out in real time, you know?</p>\n\n\n\n<p>[00:35:28] <strong>Nathan Wrigley:</strong> Yeah, it kind of speaks to trust really, doesn&#8217;t it? So the repeat order thing through a ChatGPT style interface or whatever that looks like in the future, be it voice or speaking to a camera or whatever it may be, I could totally see myself ordering the, I don&#8217;t know, the groceries or the toothpaste or whatever it is that, I really don&#8217;t need to see that thing. I don&#8217;t need to go to a shopping checkout. I just need to know that my next pack of toothpaste is going to arrive reliably tomorrow morning. That&#8217;s all I need to know. I feel like there is, there&#8217;s a there there, if you know what I mean? Despite the fact that we&#8217;re so wedded to this interface of, go to the website, look at the pictures, click the cart number, click how many you want, go to the cart, proceed with the checkout, dah, dah, dah. Most of that is going to be obsolete for the utilitarian stuff, I think. I don&#8217;t know. We&#8217;ll see.</p>\n\n\n\n<p>[00:36:15] <strong>Brian Coords:</strong> I feel like Amazon&#8217;s been trying that for a while, but I still have to check it because I feel like we return 30% of the things we buy at Amazon. It comes, it&#8217;s the wrong size, it doesn&#8217;t look anything like the picture, all that sort of stuff. Hopefully those problems still get solved, before we get to the point where I&#8217;m not even going to look at what I ordered. I think we still have a lot of time there.</p>\n\n\n\n<p>[00:36:33] <strong>Nathan Wrigley:</strong> Well, so even if that interface isn&#8217;t quite as radical as I just suggested, but even if there&#8217;s like a back and forth between the AI and the website. I don&#8217;t know, I ask for a particular thing, and then the chat interface or whatever it may be shows me a picture from the website or something along those lines. This whole scraping of the website and surfacing the content of the website, and then I can make those decisions based upon what I see. Maybe it&#8217;ll be a bit more back and forward, and far less of the AI, and more of the AI meets human kind of interface.</p>\n\n\n\n<p>[00:37:01] <strong>Brian Coords:</strong> Yeah, and I think a lot of it is, it&#8217;ll feel like magic to the end user with an AI, but really it&#8217;s just going to be a ton of code and protocols and extensions and things. Under the hood, that&#8217;s going to be a ton of manual work, getting all that stuff there. But I think with WooCommerce especially, most of the Woo stores I come across, they&#8217;re very weird, I guess is the best way to put it. They&#8217;re unique products, you know? They&#8217;re often not selling the toothpaste and that sort of stuff. Or if they are, they&#8217;re selling the very interesting toothpaste that you can only buy from this one company.</p>\n\n\n\n<p>So I think that&#8217;s what&#8217;s fun about it, is I think it&#8217;ll really be for people looking for those weird, unique products, and the kind of stuff you&#8217;re not going to get on Amazon or you&#8217;re not going to get on a basic walmart.com or something. So yeah, I think it&#8217;ll be interesting to see where this goes.</p>\n\n\n\n<p>[00:37:44] <strong>Nathan Wrigley:</strong> Do you know if Automattic, or WordPress more generally, do you know if it&#8217;s investing anything in its own AI? Everything at the moment, all the oxygen seems to be being consumed by the, let&#8217;s say, four big players that we&#8217;ve all heard of. We don&#8217;t need to name the names, we all know who they are. But it&#8217;d be curious as to whether a company obviously deeply rooted in tech, like Automattic is inventing, creating those kind of things. That&#8217;d be a curious shift.</p>\n\n\n\n<p>[00:38:07] <strong>Brian Coords:</strong> Yeah, I mean you can see it already. Telex is a product that&#8217;s come out from Automattic. It lets you build blocks. They have a AI site builder. If you go to wordpress.com, a good amount of people are actually, the first thing they do is use this AI site builder that gets you kind of from zero to like a pretty decent starting site. And then you can go in and the block editor and customise everything.</p>\n\n\n\n<p>Is Automattic training their own models and stuff? I don&#8217;t think so, or at least I don&#8217;t know. But, I mean there&#8217;s a bunch of stuff happening, that&#8217;s the public facing stuff, which is building websites. There&#8217;s stuff around WooCommerce, there&#8217;s stuff around support. Our support is very heavily leaned into AI and it&#8217;s actually very good. There&#8217;s all sorts of these other places.</p>\n\n\n\n<p>And then there&#8217;s a ton of stuff internally in the company that we have because, you know, when you work with a thousand people, there&#8217;s a lot of information there. And so we have internal stuff that&#8217;s kind of like search through all of our, you know, internal dialogue and find this conversation and summarise it for me. And so it&#8217;s all there. It&#8217;ll be interesting to see which ones end up becoming good products.</p>\n\n\n\n<p>[00:39:05] <strong>Nathan Wrigley:</strong> Well, it sounds like exciting times. It sounds like you&#8217;ve landed in the right part of Automattic for you at least anyway. Yeah, fascinating times. The year 2026 for e-commerce, and WooCommerce more specifically, looks very, very bright.</p>\n\n\n\n<p>Can we just ask you, before we go, where would be the best place to find you if anybody wants to reach out and say hi?</p>\n\n\n\n<p>[00:39:23] <strong>Brian Coords:</strong> Yeah, definitely. So if you are interested in WooCommerce, you can go to developer.woo.com. That&#8217;s kind of our developer blog and it has, it&#8217;ll take you to like the docs, it&#8217;ll take you to the community Slack, it&#8217;ll take you to our email newsletter and all that sort of stuff. That&#8217;s developer.woo.com.</p>\n\n\n\n<p>For me, it&#8217;s my name, briancoords.com, and I&#8217;m mostly active on Twitter and YouTube these days. I tried all the other social networks, but everyone in WordPress stays on Twitter, so that&#8217;s where I&#8217;ll be for the foreseeable future.</p>\n\n\n\n<p>[00:39:47] <strong>Nathan Wrigley:</strong> So Brian is, as you would imagine it&#8217;s spelled, but Coords has two O&#8217;s. So it&#8217;s C-O-O-R-D-S. I&#8217;ll put all of the links in the show notes so that anything that Brian mentioned can be found there, wptavern.com. Search for Brian&#8217;s name and you will be able to find that episode. So Brian Coords, thank you so much for chatting to me today.</p>\n\n\n\n<p>[00:40:05] <strong>Brian Coords:</strong> Yeah. Thank you.</p>\n</div></details>\n\n\n\n<p>On the podcast today we have <a href="https://x.com/briancoords">Brian Coords</a>.</p>\n\n\n\n<p>Brian has been active in the WordPress space for over a decade, starting out in agencies building and managing websites, and is now a developer advocate at WooCommerce, bridging the gap between Woo’s internal engineers and the wider developer community. His journey includes being a high school teacher, working for nonprofits, and writing for the WP Tavern, before landing his role at Automattic.</p>\n\n\n\n<p>If you’re interested in where WooCommerce, and WordPress itself, are headed, this episode will help, as Brian shares insights on WordPress’s evolving focus, the importance of embracing AI, and how a slower pace of change can be a strength in any open source ecosystem.</p>\n\n\n\n<p>He talks about the massive rebrand at WooCommerce, the challenges and opportunities in competing with SaaS giants, and the unique developer relations role that balances his technical experience with communication skills.</p>\n\n\n\n<p>We get into how the team Brian works with supports developers and agencies with documentation, office hours, and feedback loops, and how WooCommerce’s global reach makes for a complex but thriving ecosystem. There’s discussion about recent marketing efforts, the realities of open source support, and the surprising diversity of WooCommerce users worldwide.</p>\n\n\n\n<p>Towards the end, we look ahead to what’s coming for WooCommerce, which is greater integration with block-based editing in WordPress Core, major investments in AI to streamline store management, and the future landscape of online shopping.</p>\n\n\n\n<p>If you want to hear how WooCommerce and WordPress are responding to a rapidly changing tech environment, this episode is for you.</p>\n\n\n\n<h2 class="wp-block-heading">Useful links</h2>\n\n\n\n<p><a href="https://www.briancoords.com"> briancoords.com </a></p>\n\n\n\n<p><a href="https://woocommerce.com">WooCommerce</a></p>\n\n\n\n<p><a href="https://wordpress.org/news/2025/12/sotw-2025/"> State of the Word 2025</a></p>\n\n\n\n<p><a href="https://woocommerce.com/community-slack/"> WooCommerce Community Slack</a></p>\n\n\n\n<p><a href="https://automattic.com/for-agencies/">Automattic for Agencies</a></p>\n\n\n\n<p><a href="https://woocommerce.com/payments/">WooPayments</a></p>\n\n\n\n<p><a href="https://telex.automattic.ai"> Telex</a></p>\n\n\n\n<p><a href="https://developer.woocommerce.com">Woo Developer Blog</a></p>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Wed, 07 Jan 2026 15:09:35 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:14:"Nathan Wrigley";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:6;a:6:{s:4:"data";s:21:"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:20:"Matt: Find My Update";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:23:"https://ma.tt/?p=151027";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:37:"https://ma.tt/2026/01/find-my-update/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:1163:"<p>The best part about blogging is the comments, and after I <a href="https://ma.tt/2026/01/find-my-upgrade/">posted</a> &#8220;I wish that when you use Find My to find your iPhone, it would also flash the flashlight, which would be great for finding it in a bag or a dark room.&#8221; <a href="https://gravatar.com/mwenderwenmark">Michael Wender</a> and <a href="https://artiss.me/">David Artiss</a> jumped in that it&#8217;s already there!</p>\n\n\n\n<p>Apple support <a href="https://support.apple.com/guide/watch/ping-your-iphone-apddd5a326d2/watchos">says if you touch and hold it will flash the light</a>! Now I haven&#8217;t been able to get this to work yet, perhaps because when I did, I got a notice that Precision Finding, which uses ultra-wideband (UWB) frequencies to help you find your phone or Airtag, which is magical, isn&#8217;t available in all regions. I&#8217;m currently stranded in St. Martin because of airspace issues with Venezuela, and apparently, this is one of the countries, like Indonesia, where UWB doesn&#8217;t work.</p>\n\n\n\n<p>Update: Hours later, the press-and-hold thing now flashes the light, so it must have been a heisenbug.</p>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Wed, 07 Jan 2026 04:30:48 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:4:"Matt";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:7;a:6:{s:4:"data";s:21:"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:80:"Open Channels FM: How to Spot a Committed Business Partner (and Avoid Red Flags)";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:33:"https://openchannels.fm/?p=113510";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:85:"https://openchannels.fm/how-to-spot-a-committed-business-partner-and-avoid-red-flags/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:199:"Successful partnerships hinge on genuine commitment, proactive engagement, and collaborative effort, requiring integration across teams and mutual benefits beyond mere visibility for lasting success.";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Mon, 05 Jan 2026 10:44:23 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:5:"BobWP";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:8;a:6:{s:4:"data";s:21:"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:21:"Matt: Find My Upgrade";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:23:"https://ma.tt/?p=151013";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:38:"https://ma.tt/2026/01/find-my-upgrade/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:165:"<p><br />I wish that when you use Find My to find your iPhone, it would also flash the flashlight, which would be great for finding it in a bag or a dark room. </p>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Mon, 05 Jan 2026 05:58:40 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:4:"Matt";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:9;a:6:{s:4:"data";s:21:"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:21:"Matt: Jackson Kiddard";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:23:"https://ma.tt/?p=151002";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:38:"https://ma.tt/2026/01/jackson-kiddard/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:620:"<blockquote class="wp-block-quote is-layout-flow wp-block-quote-is-layout-flow">\n<p>Anything that annoys you is teaching you patience.</p>\n\n\n\n<p>Anyone who abandons you is teaching you how to stand up on your own two feet.</p>\n\n\n\n<p>Anything that angers you is teaching you forgiveness and compassion.</p>\n\n\n\n<p>Anything that has power over you is teaching you how to take your power back.</p>\n\n\n\n<p>Anything you hate is teaching you unconditional love.</p>\n\n\n\n<p>Anything you fear is teaching you the courage to overcome your fear.</p>\n\n\n\n<p>Anything you can’t control is teaching you how to let go.</p>\n</blockquote>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Sun, 04 Jan 2026 07:26:00 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:4:"Matt";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:10;a:6:{s:4:"data";s:21:"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:15:"Matt: Two Links";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:23:"https://ma.tt/?p=150994";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:32:"https://ma.tt/2026/01/two-links/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:487:"<p>They&#8217;re both long reads, but worthwhile.</p>\n\n\n\n<ul class="wp-block-list">\n<li><a href="https://danwang.co/2025-letter/">Dan Wang&#8217;s 2025 Letter</a>: Is excellent writing and provides keen insight into the dynamics of American and Chinese tech.</li>\n\n\n\n<li><a href="https://zhengdongwang.com/2025/12/30/2025-letter.html">Zhengdong Wang&#8217;s 2025 Letter</a>: If you follow all the links, you&#8217;ll have the most complete view of everything happening in AI. </li>\n</ul>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Sat, 03 Jan 2026 03:30:01 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:4:"Matt";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:11;a:6:{s:4:"data";s:21:"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:20:"Matt: Happy New Year";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:23:"https://ma.tt/?p=150981";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:39:"https://ma.tt/2026/01/happy-new-year-3/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:2117:"<p>I rang in the new year with an unexpected trip to St. Barts with friends.</p>\n\n\n\n<p>I resolved in 2025 to watch more films. It&#8217;s an art form I have many friends in, and when we have hung out, I&#8217;ve realized how shallow my understanding of the film canon is. I have a lot of catch-up to do, and it also requires a lifestyle change, as I&#8217;m usually at a laptop. Making space to enjoy a film for a few hours was a departure from my regular routines.</p>\n\n\n\n<p>I watched 72 movies last year! This definitely came at the cost of books finished, if I look at my stats. But I&#8217;ve begun to really appreciate the contours of what I love about a movie now.</p>\n\n\n\n<p>This is a long lead to recommend the movie <a href="https://www.netflix.com/gp-en/title/81551446">Jay Kelly</a>, which streams on Netflix with George Clooney and Adam Sandler. After seeing many great and terrible movies, old and new, I really appreciated what they did with this film, and it was one of the rare ones I watched entirely or in sections several times, gaining new appreciation for what they pulled off.</p>\n\n\n\n<p>It starts with a <a href="https://www.gq.com/story/one-shot-scenes-in-film-and-tv-definitively-ranked">&#8220;One-er,&#8221;</a> which is a continuous shot with no cuts that moves between a number of different scenes in a really slick way. (Excellent episode of The Studio about this!)  It&#8217;s a film way of showing off, as it must be incredibly hard to have hundreds of people all pulling off something flawlessly for a long period of time, not unlike a Broadway show.</p>\n\n\n\n<p>Jay Kelly is George Clooney playing himself, which, as he says, is the hardest thing to do. There are meta-levels of reality and fiction, and so many allusions and callbacks, the entire thing is a work of art. You learn to appreciate what actors do and how film is made while watching a film being made in such a nice way.</p>\n\n\n\n<p>So that is my recommendation for the year. In older movies, I really enjoyed Kate &amp; Leopold, which also features an amazing Sting song that is impossible to find on streaming services.</p>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Fri, 02 Jan 2026 06:00:07 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:4:"Matt";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:12;a:6:{s:4:"data";s:21:"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:100:"Open Channels FM: Building Successful Collaboration Through Communication in WordPress Release Teams";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:33:"https://openchannels.fm/?p=113371";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:107:"https://openchannels.fm/building-successful-collaboration-through-communication-in-wordpress-release-teams/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:378:"In the world of open source, communication stands out as a key factor for successful collaboration. WordPress release teams unite contributors from all around the globe, bringing together a remarkable diversity of experiences, cultures, and time zones. While technical prowess is important, it is the way team members connect and exchange information that truly shapes [&#8230;]";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Wed, 31 Dec 2025 14:36:21 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:11:"Abha Thakor";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:13;a:6:{s:4:"data";s:21:"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:60:"Open Channels FM: Do the Woo / Open Channels FM 2025 Pathway";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:33:"https://openchannels.fm/?p=113788";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:65:"https://openchannels.fm/do-the-woo-open-channels-fm-2025-pathway/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:95:"For Open Channels FM 2025 has been a windy pathway that has led to a sweet spot for us in 2026.";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Tue, 30 Dec 2025 10:17:00 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:5:"BobWP";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:14;a:6:{s:4:"data";s:21:"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:16:"Matt: Riley Walz";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:23:"https://ma.tt/?p=150936";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:33:"https://ma.tt/2025/12/riley-watz/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:676:"<p>The writer Aadil Pickle has a <a href="https://sfalexandria.com/posts/rileys-ideas/">great profile of one of my favorite hackers, &#8220;Training the Idea Muscle&#8221; on Riley Walz</a>. Riley epitomizes the term &#8220;high agency,&#8221; and I&#8217;ve been continually impressed with his ability to rapidly code novel ideas and interfaces on top of public or reverse-engineered data. He&#8217;s a hacker, artist, and provocateur.</p>\n\n\n\n<p>I&#8217;m enjoying this slower time of the year, and it looks like this will be the warmest Christmas I can remember in Houston; it was 80° F today! Makes me appreciate what Christmas in the southern hemisphere must be like.</p>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Wed, 24 Dec 2025 00:32:15 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:4:"Matt";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:15;a:6:{s:4:"data";s:21:"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:139:"Gutenberg Times: Roadmap for WordPress 7.0 and schedule, commands for the Command Palette, Gutenberg 22.3, and more — Weekend Edition 353";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:35:"https://gutenbergtimes.com/?p=43471";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:143:"https://gutenbergtimes.com/roadmap-for-wordpress-7-0-and-schedule-commands-for-the-command-palette-gutenberg-22-3-and-more-weekend-edition-353/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:26120:"<p>Hi there, </p>\n\n\n\n<p>Welcome to our last edition for the year 2025. I am not ready to reflect on the whole year, however, I am excited for 2026. There will be many new features coming to WordPress with the three major releases and also plenty of bug fixes and quality-of-life enhancement towards consistency. </p>\n\n\n\n<p>The first edition for 2026 will have to wait a bit and it is scheduled for January 24, 2026, roughly a month from now, due to my vacation and training schedule.</p>\n\n\n\n<p>I wish you and yours wonderful Holidays and a happy, prosperous and healthy New Year! <img alt="🤶" class="wp-smiley" src="https://s.w.org/images/core/emoji/17.0.2/72x72/1f936.png" style="height: 1em;" /><img alt="🎄" class="wp-smiley" src="https://s.w.org/images/core/emoji/17.0.2/72x72/1f384.png" style="height: 1em;" /><img alt="🎁" class="wp-smiley" src="https://s.w.org/images/core/emoji/17.0.2/72x72/1f381.png" style="height: 1em;" /><img alt="🎆" class="wp-smiley" src="https://s.w.org/images/core/emoji/17.0.2/72x72/1f386.png" style="height: 1em;" /><img alt="🎇" class="wp-smiley" src="https://s.w.org/images/core/emoji/17.0.2/72x72/1f387.png" style="height: 1em;" /></p>\n\n\n\n<p>Yours, <img alt="💕" class="wp-smiley" src="https://s.w.org/images/core/emoji/17.0.2/72x72/1f495.png" style="height: 1em;" /><br /><em>Birgit</em></p>\n\n\n\n\n\n<p><strong>Steve Burge</strong> and <strong>Dan Knaus</strong>s interviewed me for the PublishPress podcast. We covered WordPress 6.9&#8217;s six new blocks (accordion, term query, time to read, math, comment count, and comment link) plus editorial notes for team collaboration. The release marks a restart after Automattic&#8217;s contribution pause.</p>\n\n\n\n<p>WordPress 7.0 ( April 9, 2025) will bring template management improvements and a tabs block. The AI team is building foundational infrastructure—Abilities API, MCP Adapter, PHP AI SDK, and experiments plugin—enabling plugins to integrate with AI assistants. Real-time collaborative editing remains in development, facing technical hosting challenges. <a href="https://www.youtube.com/watch?v=_9doWARTmWc">The recording is available on YouTube.</a></p>\n\n\n<div class="wp-block-newsletterglue-showhide ng-block" width="100%">\n<figure class="wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio"><div class="wp-block-embed__wrapper">\n\n</div></figure>\n</div>\n\n\n<h2 class="wp-block-heading" id="0-word-press-release-information">Roadmap WordPress 7.0 and two more releases in 2026</h2>\n\n\n\n<p>In his lates post, <strong>Matias Ventura</strong>, lead architect of Gutenberg, laid out <a href="https://make.wordpress.org/core/2025/12/11/planning-for-7-0/"><strong>the plan for WordPress 7.0.</strong></a>  It&#8217;s aspirational and not all the items will make it into the next major version of WordPress. The very detailed plan covers the project’s shift into Phase 3: Collaboration, a vision for real-time co-editing, and enhanced communication through site notes. Ventura underscores the modernization of the administrative experience via a unified design system and expanded DataViews. By integrating a standardized AI API and advancing responsive editing tools, WordPress 7.0 aims to unify the design and development process. Ultimately, the release promises to deliver a more cohesive and performant platform through refined navigation and versatile new core blocks. Here are the broad topics of the plan. </p>\n\n\n\n<ul class="wp-block-list">\n<li><a href="https://make.wordpress.org/core/2025/12/11/planning-for-7-0/#collaboration">Collaboration </a></li>\n\n\n\n<li><a href="https://make.wordpress.org/core/2025/12/11/planning-for-7-0/#admin">Admin</a></li>\n\n\n\n<li><a href="https://make.wordpress.org/core/2025/12/11/planning-for-7-0/#apis">APIs</a></li>\n\n\n\n<li><a href="https://make.wordpress.org/core/2025/12/11/planning-for-7-0/#navigation-block">Navigation Block</a></li>\n\n\n\n<li><a href="https://make.wordpress.org/core/2025/12/11/planning-for-7-0/#customization">Customization</a></li>\n\n\n\n<li><a href="https://make.wordpress.org/core/2025/12/11/planning-for-7-0/#blocks">Blocks</a></li>\n\n\n\n<li><a href="https://make.wordpress.org/core/2025/12/11/planning-for-7-0/#media">Media</a></li>\n</ul>\n\n\n\n<p><strong>Jonathan Desrosiers</strong> also published the <a href="https://make.wordpress.org/project/2025/12/18/proposal-2026-major-release-schedule/"><strong>proposed schedule of the 2026 </strong></a>releases. Following the schedule, we have two more dates to put on our calendars: Beta 1 for WordPress 7.0 will be on February 19, and RC 1 is scheduled for March 19, 2026. </p>\n\n\n\n<figure class="wp-block-image size-large"><img alt="Table of WordPress release dates for 2026" class="wp-image-43753" height="479" src="https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/12/Screenshot-2025-12-20-at-19.32.47.png?resize=652%2C479&#038;ssl=1" width="652" /></figure>\n\n\n\n<p>Provided the Release squad approves this schedule. I also can offer a timeline for the <strong>WordPress 7.0 Source of Truth:</strong> First draft will be available for public preview on February 26, 2026, and the post will be published on March 26, 2026.</p>\n\n\n\n<div class="wp-block-group has-light-background-background-color has-background"><div class="wp-block-group__inner-container is-layout-constrained wp-block-group-is-layout-constrained">\n<p><img alt="🎙" class="wp-smiley" src="https://s.w.org/images/core/emoji/17.0.2/72x72/1f399.png" style="height: 1em;" /> The latest episode is <a href="https://gutenbergtimes.com/podcast/gutenberg-changelog-125-wordpress-6-9-gutenberg-22-1-and-gutenberg-22-2/">Gutenberg Changelog #125 – WordPress 6.9, Gutenberg 22.1 and Gutenberg 22.2</a> with <strong>JC Palmes</strong>, WebDev Studios</p>\n\n\n\n<figure class="wp-block-image size-full is-style-no-vertical-margin"><img alt="Gutenberg Changelog 125 with JC Palmes and host Birgit Pauli-Haack" class="wp-image-43283" height="186" src="https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/11/Screenshot-2025-11-28-at-18.19.29.png?resize=652%2C186&#038;ssl=1" width="652" /></figure>\n\n\n<div class="wp-block-newsletterglue-showhide ng-block" width="100%">\n<figure class="wp-block-embed is-type-rich is-provider-pocket-casts wp-block-embed-pocket-casts"><div class="wp-block-embed__wrapper">\n\n</div></figure>\n</div></div></div>\n\n\n\n<h2 class="wp-block-heading" id="gutenberg-22-3-and-beyond">Gutenberg 22.3 and beyond</h2>\n\n\n\n<p><strong>Hector Prieto</strong> led the release of <a href="https://make.wordpress.org/core/2025/12/17/gutenberg-22-3-december-17/">Gutenberg 22.3 (December 17)</a>. In his release post he highlighted:</p>\n\n\n\n<ol class="wp-block-list">\n<li><a href="https://make.wordpress.org/core/2025/12/17/gutenberg-22-3-december-17/#dedicated-fonts-page-for-easier-typography-management">Dedicated Fonts page for easier typography management</a></li>\n\n\n\n<li><a href="https://make.wordpress.org/core/2025/12/17/gutenberg-22-3-december-17/#image-editing-improvements">Image editing improvements</a></li>\n\n\n\n<li><a href="https://make.wordpress.org/core/2025/12/17/gutenberg-22-3-december-17/#responsive-grid-block">Responsive Grid block</a></li>\n\n\n\n<li><a href="https://make.wordpress.org/core/2025/12/17/gutenberg-22-3-december-17/#other-highlights">Other highlights</a></li>\n</ol>\n\n\n\n<hr class="wp-block-separator has-alpha-channel-opacity is-style-wide" />\n\n\n\n<p><strong>Dave Smith,</strong> core conditrbutor on the GGutenbergProject explains in his video <br /><a href="https://www.youtube.com/watch?v=wWR6_DHQoI4"><strong>The changes leveling up Navigation in WordPress 7.0</strong></a>,He wrote in tthedescription: &#8220;Navigation is one of the most important — and most frustrating — parts of building a WordPress site.In this video, I walk you through what’s changing, why it matters, and show the real work already underway — including early prototypes and demos.&#8221; Check it out. </p>\n\n\n<div class="wp-block-newsletterglue-showhide ng-block" width="100%">\n<figure class="wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio"><div class="wp-block-embed__wrapper">\n\n</div></figure>\n</div>\n\n\n<h2 class="wp-block-heading" id="0-p">Plugins and Tools for #nocode site builders</h2>\n\n\n\n<p><strong>Jamie Marsland</strong> is at it again with short videos and teaching you new skills. In his latest video <a href="https://www.youtube.com/watch?v=qGKVSl7_1EU"><strong>&#8220;How to Create a High-Converting Landing Page With WordPress (Free Blueprint)&#8221;</strong></a> he gives you step -y -tep instructions for an easy way to create high-converting WordPress landing pages using only core blocks. He built a distraction-free landing page based on the <a href="https://storybrand.com/">StoryBrand</a> methodology, so each section has a clear purpose and guides visitors through a simple story as they scroll.</p>\n\n\n<div class="wp-block-newsletterglue-showhide ng-block" width="100%">\n<figure class="wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio"><div class="wp-block-embed__wrapper">\n\n</div></figure>\n</div>\n\n\n<p><strong><a href="https://x.com/SarahPerezTC">Sarah Perez</a>,</strong> consumer tech editor at TechCrunch, reported that &#8220;<a href="https://techcrunch.com/2025/12/03/wordpresss-vibe-coding-experiment-telex-has-already-been-put-to-real-world-use/"><strong>WordPress’s vibe-coding experiment, Telex, is now being used</strong></a>&#8221; and it features Automattic’s AI tool for natural language web development. Introduced at the &#8220;State of the Word&#8221; event, <a href="https://telex.automattic.com">Telex</a> allows users to create complex Gutenberg blocks, like pricing calculators and logo carousels, without coding. Perez highlights how &#8220;vibe coding&#8221; makes site building accessible for non-tech users, enabling them to create professional results. With the new Abilities API, Telex marks WordPress’s move toward AI-driven workflows that streamline the design process.</p>\n\n\n\n<hr class="wp-block-separator has-alpha-channel-opacity is-style-wide" />\n\n\n\n<p><strong><a href="https://x.com/courtneyr_dev">Courtney Robertson</a></strong> Developer advocate at GoDaddy released the plugin <a href="https://wordpress.org/plugins/post-formats-for-block-themes/"><strong>Post Formats for Block Themes</strong></a>, which brings back old-school post formats to modern WordPress block themes. It restores useful features for galleries, quotes, and videos often missing in newer themes. You’ll find smart auto-detection, unique block patterns for each format, and a handy Chat Log block for easy transcripts. By combining these classic tools with today’s full-site editing, this plugin helps creators maintain a great design and add variety in a simple and accessible way.</p>\n\n\n\n<hr class="wp-block-separator has-alpha-channel-opacity is-style-wide" />\n\n\n\n<p><strong>Valentin Grenier</strong>, a WordPress developer from Toulouse, France, just dropped his first plugin: <strong><a href="https://wordpress.org/plugins/simple-block-animations/">Simple block animations</a></strong>. It’s a cool, lightweight tool for adding some fun scroll-triggered visual effects to your Gutenberg blocks without needing to mess with any custom code. You get five different animation types, like fades and slides,, thatyou can tweak with durations and delays. Built using the <a href="https://developer.mozilla.org/en-US/docs/Web/API/Intersection_Observer_API">Intersection Observer API</a> and good old native CSS, it keeps things running smoothly by loading assets only when they&#8217;re needed while also being mindful of motion preferences to make it accessible. </p>\n\n\n\n<h2 class="wp-block-heading" id="2-word-press-6-0-1-and-6-1-scheduled">What&#8217;s new in WordPress Playground</h2>\n\n\n\n<p>Felyph Centra posted a few video on WordPressTV to showcase various features of WordPress Playground </p>\n\n\n\n<p><strong><a href="https://wordpress.tv/2025/12/09/previewing-github-branches-with-wordpress-playground/">Previewing GitHub branches with WordPress Playground</a>. </strong>This video demonstrates a method to streamline development reviews. This technique addresses the common pain point of needing complex local environments or relying on static screenshots to share work in progress.</p>\n\n\n\n<p><strong><a href="https://wordpress.tv/2025/12/09/introduction-to-wordpress-playground-landing-page/">Introduction to WordPress Playground landing page</a></strong>. The new landing page explains the capabilities of the platform and what is possible with WordPress Playground.</p>\n\n\n\n<p><strong><a href="https://wordpress.tv/2025/12/09/using-wordpress-playground-to-work-with-ai-agents/">Using WordPress Playground to work with AI agents</a></strong>. Centra shared how you can use the WordPress Playground to integrate with AI agents. with an example that uses GitHub Copilot agents. Using this flow it executes small tasks for a plugin, such as refactoring code or updating documentation. WordPress Playground can serve as a base to validate the AI agent’s code changes using E2E tests.</p>\n\n\n\n<p>In the post <a href="https://make.wordpress.org/playground/2025/12/19/action-required-github-proxy-com-shutdown/"><strong>Action required: github-proxy.com shutdown</strong></a> Centra lays out the migration to switch over from a third-party proxy server to Playground&#8217;s built -n CORS handling. Your existing blueprints are safe, though. If you worked with Blueprints you can also learn how to reference GitHub repos, folders and files with native Playground resources. </p>\n\n\n<div class="ng-block-aea02aa2b02e9418 wp-block-newsletterglue-container ng-block" style="color: #666666;" width="100%"><div><div><div class="ng-block-vs ng-block-vs-1" colspan="3" height="0" style="height: 0px;"></div></div><div><div class="ng-block-hs ng-block-hs-1" height="0" style="width: 0px;"></div><div align="none" class="ng-block-td" style="font-size: 16px; font-family: Helvetica; line-height: 1.6; font-weight: normal; padding-top: 20px; padding-bottom: 20px; padding-left: 0px; padding-right: 0px; text-align: none; color: #666666; background-color: #fdfcea; border-radius: 12px;"><div class="ng-block-4b548adfd333fa83 wp-block-newsletterglue-text ng-block" style="color: #666666;" width="100%"><div><div><div align="none" class="ng-block-td" style="font-size: 16px; font-family: Helvetica; line-height: 1.6; font-weight: normal; padding-top: 8px; padding-bottom: 10px; padding-left: 20px; padding-right: 20px; text-align: none; color: #666666;"><p><strong> <a href="https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/" rel="noreferrer noopener" target="_blank">&#8220;Keeping up with Gutenberg—Index- Index 2025&#8221;</a> </strong><br />A chronological list of the WordPress Make Blog posts from various teams involved in Gutenberg development: Design, Theme Review Team, Core Editor, Core JS, Core CSS, Test, and Meta team from Jan. 2024 on. Updated by yours truly. </p></div></div></div></div>\n\n<div class="ng-block-0ad2920b87ada2a3 wp-block-newsletterglue-text ng-block" style="color: #666666;" width="100%"><div><div><div align="none" class="ng-block-td" style="font-size: 16px; font-family: Helvetica; line-height: 1.6; font-weight: normal; padding-top: 8px; padding-bottom: 10px; padding-left: 20px; padding-right: 20px; text-align: none; color: #666666;"><p>The previous years are also available: <br /><strong><strong><a href="https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/keeping-up-with-gutenberg-index-2020/">2020</a> | <a href="https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/keeping-up-with-gutenberg-index-2021/">2021</a></strong> | <strong><a href="https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/keeping-up-with-gutenberg-index-2022/">2022</a></strong></strong> | <strong><a href="https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/gutenberg-index-2023">2023</a></strong> | <a href="https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/gutenberg-index-2024/"><strong>2024</strong></a></p></div></div></div></div></div><div class="ng-block-hs ng-block-hs-2" height="0" style="width: 0px;"></div></div><div><div class="ng-block-vs ng-block-vs-2" colspan="3" height="0" style="height: 0px;"></div></div></div></div>\n\n\n<h2 class="wp-block-heading" id="3-building-themes-for-fse-and-word-press">Building Blocks and Tools for the Block editor</h2>\n\n\n\n<p>In this week&#8217;s livestream<strong> JuanMa Garrido </strong>explored how to <a href="https://www.youtube.com/watch?v=ETqUp0UXH0k" rel="noreferrer noopener" target="_blank">create commands for the Commands Palette</a>. WordPress 6.9 brought the Command Palette to the whole WordPress space and not just restrict it to the Site Editor. Now all plugin developer can register commands together with their plugin&#8217;s features. </p>\n\n\n<div class="wp-block-newsletterglue-showhide ng-block" width="100%">\n<figure class="wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio"><div class="wp-block-embed__wrapper">\n\n</div></figure>\n</div>\n\n\n<hr class="wp-block-separator has-alpha-channel-opacity is-style-wide" />\n\n\n\n<p><strong>Justin Tadlock</strong> published the monthly roundup on <a href="https://developer.wordpress.org/news/2025/12/whats-new-for-developers-december-2025/">What’s new for developers? (December 2025)</a>, noting WordPress 6.9 “Gene” and pointing to the 6.9 Field Guide and State of the Word. Highlights include the new AI Experiments plugin, Breadcrumbs block improvements heading toward stability, and an experimental Tabs block. Tooling updates cover WPCS 3.3.0, Data Views/Forms and Field API enhancements, <code>@wordpress/boot</code> routing, and a visibility key rename. Themes and Playground also saw notable updates.</p>\n\n\n\n<p><strong>Ryan Welcher</strong> shot a video <a href="https://www.youtube.com/watch?v=ApGnD888tZs" rel="noreferrer noopener" target="_blank">What’s New For WordPress Developers – December 2025</a>, covering the parts of the blog post. </p>\n\n\n\n<figure class="wp-block-image size-full"><a href="https://www.youtube.com/watch?v=ApGnD888tZs"><img alt="" class="wp-image-43627" height="360" src="https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/12/Screenshot-2025-12-17-at-15.28.46.png?resize=650%2C360&#038;ssl=1" width="650" /></a></figure>\n\n\n\n<hr class="wp-block-separator has-alpha-channel-opacity is-style-wide" />\n\n\n\n<p>As a reader of this newsletter you might already know about <a href="https://developer.wordpress.com/studio/">WordPress Studio</a>, the fast, free, open-source local development tool, that&#8217;s based on WordPress Playground. <strong>Nick Diego </strong>recorded a <a href="https://www.youtube.com/watch?v=wxBXWmo2oV0"><strong>Getting Started with WordPress Studio</strong></a> video and walks you through  creating local sites, configuring your environment, and using the tools that come bundled with the app. You’ll also learn how to unlock advanced features with a free WordPress.com account, including syncing with WordPress.com and Pressable, sharing live preview links, and using the built-in AI Assistant to accelerate development. Whether you build plugins, create themes, or manage client projects, Studio helps you work faster and smarter.</p>\n\n\n<div class="wp-block-newsletterglue-showhide ng-block" width="100%">\n<figure class="wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio"><div class="wp-block-embed__wrapper">\n\n</div></figure>\n</div>\n\n\n<hr class="wp-block-separator has-alpha-channel-opacity is-style-wide" />\n\n\n\n<p>In her post, <strong><a href="https://eventkoi.com/blog/event-query-loop-block-guide/">Build Custom Event Lists &amp; Grids With One Block: Event Query Loop Block Ultimate Guide</a></strong>, <strong>Lesley Sim</strong> shared a comprehensive tutorial for managing EventKoi’s specialized query block within WordPress. The post details how to create custom list and grid layouts using various query parameters, such as date ranges and recurring event instances, without any coding. By explaining the block&#8217;s internal structure and the flexible Event Data block, Sim illustrates how users can achieve precise design control and dynamic content display.</p>\n\n\n\n<hr class="wp-block-separator has-alpha-channel-opacity is-style-wide" />\n\n\n\n<p>In his latest post for the WordPress Developer Blog, <strong><a href="https://developer.wordpress.org/news/2025/12/word-switcher-extending-core-blocks-with-interactivity/">Word Switcher: Extending Core Blocks with Interactivity</a></strong>, <strong>JuanMa Garrido</strong> provides a practical guide for beginners on enhancing standard WordPress blocks using native tools. Garrido demonstrates how to combine the <strong>Format API</strong> for editor controls, the <strong>HTML API</strong> for server-side processing, and the <strong>Interactivity API</strong> for frontend animations. Developers learn to create a &#8220;word switcher&#8221; effect that cycles through text variations without relying on heavy external libraries. This approach ensures a lightweight, performant, and professional workflow that bridges the gap between simple content entry and modern, reactive web design.</p>\n\n\n<div class="ng-block-e3fd7e703cbedec9 wp-block-newsletterglue-container ng-block" style="color: #666666;" width="100%"><div><div><div class="ng-block-vs ng-block-vs-1" colspan="3" height="0" style="height: 0px;"></div></div><div><div class="ng-block-hs ng-block-hs-1" height="0" style="width: 0px;"></div><div align="none" class="ng-block-td" style="font-size: 16px; font-family: Helvetica; line-height: 1.6; font-weight: normal; padding-top: 20px; padding-bottom: 20px; padding-left: 0px; padding-right: 0px; text-align: none; color: #666666; background-color: #f8f8f8; border-radius: 8px;"><div class="ng-block-7bbd7c027dfa7abc wp-block-newsletterglue-text ng-block" style="color: #666666;" width="100%"><div><div><div align="none" class="ng-block-td" style="font-size: 16px; font-family: Helvetica; line-height: 1.6; font-weight: normal; padding-top: 8px; padding-bottom: 10px; padding-left: 20px; padding-right: 20px; text-align: none; color: #666666;"><p><strong><a href="https://gutenbergtimes.com/need-a-zip-from-master/">Need a plugin .zip from Gutenberg&#8217;s master branch?</a></strong><br />Gutenberg Times provides daily build for testing and review.</p></div></div></div></div>\n\n<div class="ng-block-a8e362a35ed090cd wp-block-newsletterglue-image ng-block size-full is-resized" width="100%"><div><div><div align="center" class="ng-block-td" style="padding-top: 0px; padding-bottom: 0px; padding-left: 0px; padding-right: 0px;"><a href="https://playground.wordpress.net/?blueprint-url=https://gutenbergtimes.com/wp-content/uploads/2020/11/playnightly.json"><img alt="" class="wp-image-42874 ng-image" height="45" src="https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2024/02/Screenshot-2025-11-15-at-12.06.44.png?resize=196%2C45&#038;ssl=1" style="border-style: none; border-color: transparent;" width="196" /></a></div></div></div></div>\n\n<div class="ng-block-7a82e9e2d4a57d22 wp-block-newsletterglue-text ng-block" style="color: #666666;" width="100%"><div><div><div align="none" class="ng-block-td" style="font-size: 16px; font-family: Helvetica; line-height: 1.6; font-weight: normal; padding-top: 8px; padding-bottom: 10px; padding-left: 20px; padding-right: 20px; text-align: none; color: #666666;"><p>Now also available via <a href="https://playground.wordpress.net/?blueprint-url=https://gutenbergtimes.com/wp-content/uploads/2020/11/playnightly.json">WordPress Playground</a>. There is no need for a test site locally or on a server. Have you been using it? <a href="mailto:pauli@gutenbergtimes.com">Email me </a>with your experience.</p></div></div></div></div></div><div class="ng-block-hs ng-block-hs-2" height="0" style="width: 0px;"></div></div><div><div class="ng-block-vs ng-block-vs-2" colspan="3" height="0" style="height: 0px;"></div></div></div></div>\n\n\n<hr class="wp-block-separator has-alpha-channel-opacity is-style-wide" />\n\n\n\n<p class="has-text-align-center has-small-font-size"><em>Questions? Suggestions? Ideas? </em><br /><em>Don&#8217;t hesitate to send <a href="mailto:pauli@gutenbergtimes.com">them via email</a> or</em><br /><em> send me a message on WordPress Slack or Twitter @bph</em>.</p>\n\n\n\n<hr class="wp-block-separator has-alpha-channel-opacity" />\n\n\n\n<p class="has-text-align-center has-small-font-size">For questions to be answered on the <a href="http://gutenbergtimes.com/podcast">Gutenberg Changelog</a>, <br />send them to <a href="mailto:changelog@gutenbergtimes.com">changelog@gutenbergtimes.com</a></p>\n\n\n<div class="ng-block-0550679edf708a44 wp-block-newsletterglue-separator ng-block" style="color: #666666;" width="100%"><div><div><div align="center" class="ng-block-td" style="padding-top: 20px; padding-bottom: 20px; padding-left: 20px; padding-right: 20px; color: #666666;"><hr style="background-color: transparent; color: transparent; margin: 0; border: 0; border-top: 1px solid #666666; width: 560px; height: 0;" /></div></div></div></div>\n\n<div class="wp-block-newsletterglue-showhide ng-block" width="100%"><div class="ng-block-76618df72e26aac7 wp-block-newsletterglue-text ng-block" style="color: #666666;" width="100%"><div><div><div align="none" class="ng-block-td" style="font-size: 14px; font-family: Helvetica; line-height: 0.2; font-weight: normal; padding-top: 8px; padding-bottom: 10px; padding-left: 20px; padding-right: 20px; text-align: none; color: #666666;"><p><strong>Featured Image: </strong></p></div></div></div></div></div>\n\n\n\n\n<hr class="wp-block-separator has-alpha-channel-opacity is-style-wide" />";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Sat, 20 Dec 2025 18:35:49 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:18:"Birgit Pauli-Haack";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:16;a:6:{s:4:"data";s:21:"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:25:"Matt: Wolfram Automattica";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:23:"https://ma.tt/?p=150898";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:42:"https://ma.tt/2025/12/wolfram-automattica/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:2079:"<figure class="wp-block-image size-large"><img alt="" class="wp-image-150900" height="337" src="https://i0.wp.com/ma.tt/files/2025/12/Gemini_Generated_Image_pzhu6zpzhu6zpzhu-1024x572.png?resize=604%2C337&#038;quality=80&#038;ssl=1" width="604" /></figure>\n\n\n\n<p>It&#8217;s exciting to announce that <a href="https://www.wolframalpha.com/input/?i=stephen+wolfram">Stephen Wolfram</a> has joined as a special advisor to <a href="https://automattic.com/">Automattic</a>.</p>\n\n\n\n<p>I promise this is not just because he is such <a href="https://writings.stephenwolfram.com/">an incredible blogger</a>, using WordPress, natch.</p>\n\n\n\n<p>If you don&#8217;t know about Stephen Wolfram, <a href="https://www.stephenwolfram.com/about/">his about page is not a bad place to start</a>, but far more interesting is his <a href="https://writings.stephenwolfram.com/2019/02/seeking-the-productive-life-some-details-of-my-personal-infrastructure/">2019 essay on Seeking the Productive Life</a>, which includes a setup for hiking outdoors while typing on a laptop.</p>\n\n\n\n<p>Stephen was doing the remote CEO thing decades before I imagined Automattic. He spoke at Automattic&#8217;s Grand Meetup in 2019 and one of my favorite memories was seeing him at the silent disco after-party. We also did <a href="https://distributed.blog/2019/10/03/turning-ideas-into-real-things/">an episode of the Distributed podcast together</a>.</p>\n\n\n\n<p>Since he started engaging more deeply earlier this year, I&#8217;ve gotten a lot of joy from seeing him interact with teams across the company, asking questions in an incisive, inquisitive way that helps break down problems. We just finished up several hours of a deep dive into our board topics with several hundred Automatticans participating.</p>\n\n\n\n<p>Automattic has been blessed with amazing directors over the years. Currently, our board is <a href="https://en.wikipedia.org/wiki/Susan_Decker">Susan Decker</a>, <a href="https://en.wikipedia.org/wiki/Ann_E._Dunwoody">General Ann Dunwoody</a>, <a href="https://toni.org/">Toni Schneider</a>, and me.</p>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Fri, 19 Dec 2025 02:47:08 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:4:"Matt";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:17;a:6:{s:4:"data";s:21:"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:88:"Open Channels FM: Delivering Customer Value Through Collaborative Ecosystem Partnerships";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:33:"https://openchannels.fm/?p=113501";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:95:"https://openchannels.fm/delivering-customer-value-through-collaborative-ecosystem-partnerships/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:199:"In this podcast, Jonathan chats with Sandra from Greyd and Tim from BigScoots about forming strong partnerships in WordPress. They share tips on success, collaboration, and maintaining relationships.";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Thu, 18 Dec 2025 10:00:00 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:5:"BobWP";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:18;a:6:{s:4:"data";s:21:"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:23:"Matt: The Thinking Game";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:23:"https://ma.tt/?p=150883";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:40:"https://ma.tt/2025/12/the-thinking-game/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:596:"<p>If you haven&#8217;t seen it, The Thinking Game documentary is excellent, and available for free on YouTube.</p>\n\n\n\n<figure class="wp-block-embed alignfull is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio"><div class="wp-block-embed__wrapper">\n\n</div></figure>\n\n\n\n<p>You have to buy it, but the Kanye documentary <a href="https://www.inwhosenamemovie.com/">In Whose Name</a> is also pretty fascinating. (I first blogged about Kanye in 2007, <a href="https://ma.tt/2007/07/on-php/">discussing PHP&#8217;s botched version 4 to 5 upgrade</a>.)</p>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Thu, 18 Dec 2025 05:29:42 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:4:"Matt";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:19;a:6:{s:4:"data";s:21:"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:112:"WPTavern: #198 – Muntasir Sakib on Bridging the Gap Between WordPress Plugin Development and Marketing Success";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:48:"https://wptavern.com/?post_type=podcast&p=201777";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:126:"https://wptavern.com/podcast/198-muntasir-sakib-on-bridging-the-gap-between-wordpress-plugin-development-and-marketing-success";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:49111:"<details>Transcript<div>\n<p>[00:00:19] <strong>Nathan Wrigley:</strong> Welcome to the Jukebox Podcast from WP Tavern. My name is Nathan Wrigley.</p>\n\n\n\n<p>Jukebox is a podcast which is dedicated to all things WordPress. The people, the events, the plugins, the blocks, the themes, and in this case, build it and they might come, bridging the gap between WordPress plugin development and marketing success.</p>\n\n\n\n<p>If you&#8217;d like to subscribe to the podcast, you can do that by searching for WP Tavern in your podcast player of choice, or by going to wptavern.com/feed/podcast, and you can copy that URL into most podcast players.</p>\n\n\n\n<p>If you have a topic that you&#8217;d like us to feature on the podcast, I&#8217;m keen to hear from you and hopefully get you or your idea featured on the show. Head to wptavern.com/contact/jukebox, and use the form there.</p>\n\n\n\n<p>So on the podcast today, we have Muntasir Sakib. Muntasir, has been active in the WordPress space since 2018, working with well-known plugins and companies such as Tutor, LMS, Droip and more. He&#8217;s played a key role scaling products from their early days helping them achieve wider adoption.</p>\n\n\n\n<p>He&#8217;s also been active in the WordPress community more broadly at events such as WordCamp Asia and Word Camp Sylhet.</p>\n\n\n\n<p>The focus of today&#8217;s episode is a crucial, yet often overlooked topic, especially if you&#8217;re a plugin developer. It&#8217;s a chat about the moment when plugin development ends and the real success can begin. In a WordPress marketplace that&#8217;s more crowded and competitive than ever, simply build it and they will come, does not mean that users will. Muntasir wants to bust the myth by digging into why marketing is essential from day one, and not an afterthought left until launch day.</p>\n\n\n\n<p>We start by learning about Muntasir&#8217;s journey through the WordPress ecosystem, and his approach to balancing development and marketing for plugins. He explains the key differences between marketing in the WordPress ecosystem versus the SaaS world. In WordPress, you don&#8217;t control the full stack and your users expect openness and interoperability, making community focus and support critical.</p>\n\n\n\n<p>The discussion then turns to the practicalities of launching and growing a plugin. Why throwing new features at a product isn&#8217;t enough, and why listening to users and building community relationships is often more valuable than racing to add features no one has asked for.</p>\n\n\n\n<p>We talk about the dos and don&#8217;ts gained from Muntasir&#8217;s experience, including the pitfalls of relying on lifetime deals for early revenue, and why a recurring revenue model is key for long-term sustainability.</p>\n\n\n\n<p>We also talk through the role of community, partnerships, and events like WordCamps, not just as marketing opportunities, but as places to build the relationships and collaborations that can help plugins thrive.</p>\n\n\n\n<p>if you&#8217;re a WordPress plugin developer wondering how to turn a finished product into real success, or you&#8217;re trying to figure out where marketing fits into your roadmap, this episode is for you.</p>\n\n\n\n<p>If you&#8217;re interested in finding out more, you can find all of the links in the show notes by heading to wptavern.com/podcast, where you&#8217;ll find all the other episodes as well.</p>\n\n\n\n<p>And so without further delay, I bring you Muntasir Sakib.</p>\n\n\n\n<p>I am joined on the podcast by Muntasir Sakib. Hello.</p>\n\n\n\n<p>[00:03:47] <strong>Muntasir Sakib:</strong> Hello, Nathan. How are you doing?</p>\n\n\n\n<p>[00:03:48] <strong>Nathan Wrigley:</strong> Yeah, good. Very nice to connect with you. We&#8217;ve had a long chat prior to hitting the record button. And we really touched on all sorts of things in life. But that&#8217;s not the purpose of the podcast today. We&#8217;re going to keep it firmly on the WordPress side of things, and particularly about marketing, I guess maybe a good way to sum it up, which is a topic that we don&#8217;t often get into.</p>\n\n\n\n<p>Before we get into that, Muntasir, I wonder if you wouldn&#8217;t mind just introducing yourself. Just tell us a little bit about yourself and what you do. How come you&#8217;re connected to the WordPress community? Whatever you think fits the bill.</p>\n\n\n\n<p>[00:04:18] <strong>Muntasir Sakib:</strong> Thank you, Nathan, for giving me the opportunity to talk about myself a bit, and it&#8217;s nice being with you here.</p>\n\n\n\n<p>Well, I&#8217;m Muntasir, I&#8217;m Muntasir Sakib and I have been with WordPress since 2018. So you can say over half a decade. And throughout my career, I worked for some really, really amazing plugins and companies such as Tutor LMS, Droip, EasyCommerce, Core Designer, ThumbPress.</p>\n\n\n\n<p>So when I joined JoomShaper, like premium, back in the days, I was talking about 2019, we had Tutor LMS and Tutor LMS had probably 15,000 or less active installations back in the time. And then within three and a half years, with the help of the amazing team we had back then, we all worked together day and night, and with our beautiful clients and customers all around the globe we achieved 100,000 plus active installations within three and a half years. And that was a phenomenal number to mention in the WordPress industry, in the WordPress ecosystem.</p>\n\n\n\n<p>And then there&#8217;s Droip, the first ever true no-code website builder for WordPress, and that was born. It got a traction that we ever expected it to be that much. So we were overwhelmed about it as well.</p>\n\n\n\n<p>And then during my tenure so far, I, along with my team, represented Tutor LMS and Droip at WordCamp Asia 2023, WordCamp Sylhet 2023 and some other WordPress meetups as well.</p>\n\n\n\n<p>And why did we join WordCamps? That could be a question. It&#8217;s because we sponsored those events to show our gratitude to the WordPress community and the ecosystem. Because there&#8217;s a thing in WordPress, which we say Five for the Future, as per Matt. So every product companies and every business that do business in the WordPress industry should contribute in the WordPress ecosystem, contributes in the open source market so that it get better every day.</p>\n\n\n\n<p>Because we are working in the ecosystem, we bring some real value for our clients. So what if our foundation is not strong enough to get those clients, to get those correct tractions? Because in the SaaS market nowadays, there are lots of, plethora of SaaS products, but we have to bring something together, stronger and better than SaaS, so that people believe in us and they come together to work with us and use our products.</p>\n\n\n\n<p>[00:06:40] <strong>Nathan Wrigley:</strong> Yeah, thank you. So you&#8217;ve been working with a variety of different clients in the WordPress space. And when I put out a message saying, I&#8217;d like to chat with a variety of people on this podcast, you reached out and you mentioned that you wanted to talk about essentially the gap where development finishes and success begins. Because I think it&#8217;s fair to say that if you were to rewind the clock, I don&#8217;t know, maybe 15 years or something like that, maybe 10 years, it was much more straightforward to build a product as a developer, put it out into the marketplace, and because you were potentially the prime mover, the first person to have such a thing, you might succeed just off the basis of build it and they will come. That old chestnut.</p>\n\n\n\n<p>Whereas now the marketplace is much more mature, much more saturated. And so the idea of build it and they will come. Oh, really, I mean unless you are incredibly fortunate, or maybe you&#8217;ve already had some success and so have, I don&#8217;t know, your company has notoriety or what have you, that really isn&#8217;t the case anymore. When development finishes there needs to be this whole marketing piece that swings into action to alert the community.</p>\n\n\n\n<p>So how would you differentiate between the plugin marketplace, in terms of marketing, and the SaaS marketplace? What makes those two things different?</p>\n\n\n\n<p>[00:07:59] <strong>Muntasir Sakib:</strong> Well, that&#8217;s a pretty important question that we mostly overlook. Nathan, thank you for bringing that out. We need to be very specific. When it&#8217;s about WordPress product marketing, it&#8217;s more like ecosystem driven than SaaS. When we&#8217;re talking about SaaS, you control the entire environment, your onboarding journey, your analytics, your pricing model, your customer journey. Everything is under the one umbrella.</p>\n\n\n\n<p>But when it&#8217;s about WordPress, then you are selling inside an open ecosystem where users make dozens of plugins together. So you cannot give your customer some boundaries that if you use my product or my plugin, you cannot use others. It doesn&#8217;t make any sense.</p>\n\n\n\n<p>So they&#8217;re going to use as many plugins as they want to, and you have to be compatible with every one of those. So you don&#8217;t control hosting, themes, PHP versions or the user&#8217;s technical setup, all of which impact your product experience, right?</p>\n\n\n\n<p>And in wp.org, wp.org acts as a distribution channel. So you need to think about it. It&#8217;s more of like app store, which influence reviews, support expectations, and growth. In most cases, all the products start from wp.org, which provides a free version of every plugin.</p>\n\n\n\n<p>So the founders and the marketers mostly overlook the thing that free plugin often becomes your biggest acquisition engine. So your marketing depends heavily on the documentation, the on point documentation, and the onboarding journey inside your WordPress dashboard. Your operation, the smoother it is, the better it&#8217;ll be to get the traction of the pro customers and the continuous updates, and your community presence. If you have no community presence in the ecosystem in your WordPress community, then you are just gone.</p>\n\n\n\n<p>[00:09:50] <strong>Nathan Wrigley:</strong> It&#8217;s so curious, when you sort of say it like that, the idea of logging into the WordPress backend, if you&#8217;re a plugin developer or a regular user of WordPress, you&#8217;ll be really familiar with this. If you go into a website, there&#8217;s often dozens of different things. And maybe a lot of them are kind of overlapping, so there might be things which integrate with other things. And as a plugin developer, that kind of overhead is something that you just don&#8217;t really need to worry about with SaaS, because you just build the thing, and you make sure that it works and everybody logs in, and it works because it&#8217;s yours and you control the infrastructure and the hardware that it&#8217;s on and the servers and all of that kind of stuff.</p>\n\n\n\n<p>Whereas the WordPress thing, it&#8217;s just so much more complicated and you&#8217;ve really got to be thinking all the time about sticking to coding standards to make sure that at least you know your thing is doing it right. And if there&#8217;s a conflict and something breaks, well, you can be fairly sure that it wasn&#8217;t your fault, it might be somebody else&#8217;s fault. So it is much, much more complicated.</p>\n\n\n\n<p>And then throw into it all of the other bits and pieces that you&#8217;ve just mentioned, community and all of that kind of stuff. I mean, it really is a very complicated picture, and I think getting more and more complicated year by year.</p>\n\n\n\n<p>So have you, in your previous work, have you kind of identified this moment where the development cycle ends and the marketing cycle begins, if you like, but the plugin developer has basically made no preparation for the marketing piece? They&#8217;ve just built things and then have an expectation that, oh, it&#8217;ll just sell itself. Do you see that? Is that a real thing?</p>\n\n\n\n<p>[00:11:22] <strong>Muntasir Sakib:</strong> Yeah, that&#8217;s definitely a real thing. And the thing is, I don&#8217;t give the blame to the developers actually, because they were supposed to build the product, they were supposed to follow the compliance issues, and they&#8217;re supposed to build fresh code so that the thing cannot break when people are using it massively.</p>\n\n\n\n<p>But it&#8217;s mostly from our and from the marketers end that we need to tell them beforehand, like what to do and how can we get the KPIs? What are the things that we need to sell to our customers that going to help them to solve their problems?</p>\n\n\n\n<p>Because the fun fact is, in most cases, when our founders or a developers is planning to build a product, a plugin, they were thinking from their end like, okay, fine, I want to build a product so that the product going to be that much good that everyone going to use it. But it&#8217;s not the case, because we have almost like 59,000 plugins right now in WordPress directory. So in every category, in every niche, there&#8217;s a plethora of products, plethora of competitors. So there were some big competitors and there are some upcoming competitors who are small.</p>\n\n\n\n<p>So how they compete with someone who has already hundred thousand or a million of active installations, millions of happy users. We cannot compete them with just everything they have. Whether if we come with some specific niche, like some specific problems that they&#8217;re facing from our competitors, and we can add value to them, to our clients, they would be happy enough to try our product.</p>\n\n\n\n<p>So you need to give something to the customers first so that they can rely on you. And if you have a good reputation beforehand, like if you are not new in this industry, you have some other plugins beforehand, and if have a good reputation and you are coming with another solution, they&#8217;re surely going to try it. And there&#8217;s the catch.</p>\n\n\n\n<p>When people start using your product, they give you the feedback, and those feedbacks are gold mines. So you need to talk with your customers. You need to talk with the developers. You need to connect with them on regular basis. And that&#8217;s the job of us. That&#8217;s the real job of us, like the support system, the marketers, content creators. The documentations all need to come along and they need to figure out the problems, what they&#8217;re facing, and what the customers are asking for. What are the bugs they&#8217;re having? It can be a bug based on their environment, like everyone has their different environment, right?</p>\n\n\n\n<p>But the thing is, when we speak to the customers, when we talk to them and when we try to figure out their issues and try to solve their problems, they&#8217;re going to do the best marketing you can ever imagine, the word of mouth. And WordPress is doing the exact same thing. WordPress is depending on word of mouth. Your 10 happy customers is way more important and valuable to you than a hundred thousand dollars.</p>\n\n\n\n<p>[00:14:08] <strong>Nathan Wrigley:</strong> And I think that kind of speaks to what I would imagine, or at least what I would hope to be the case. When I look back at my time in WordPress and I go right back to the beginning of it, it felt like a really good, solid playground for hobbyists. There were an awful lot of people who were doing things for a hobby, and then now it&#8217;s become much more professional. In fact, when I joined the WordPress community, that whole thing was just beginning to open up. There were a few companies who were making a great deal of success for themselves, selling things into the marketplace, you know, they had a free version and a pro version. But it was still, it still felt like the beginning of that, the wild west of that.</p>\n\n\n\n<p>And I think that still there&#8217;s a little bit of that hobbyist mentality still out there where, you know, you attend events, you hang out with like-minded people. You can see that this individual over here, they had success, I could do the same. But there&#8217;s that whole thing that you&#8217;ve got to have prior to building anything, and it sounds to me like you&#8217;re making a real difference between the marketing people and the development people.</p>\n\n\n\n<p>And, okay, maybe you are this unique person that can do both. Maybe you are brilliant at developing and you are going to be an amazing marketer. I think it&#8217;s fair to say that most people are not that. They don&#8217;t have the time, they&#8217;ve got other things to do, their skillset is developing, their skillset is marketing, they&#8217;re kind of different entities.</p>\n\n\n\n<p>But it feels like for many people, that realisation hasn&#8217;t been made yet, that you need to, before launching, so maybe even at the moment you think, I am going to build this thing, maybe that&#8217;s the moment where you think, okay, two thirds of my budget is going to go into development and one third into marketing, or 50 50 or 70 30, or whatever it may be. I think that&#8217;s what you&#8217;re saying is that you need to be thinking about this right from the beginning, not leaving it until the last minute if you want it to be a success.</p>\n\n\n\n<p>[00:15:57] <strong>Muntasir Sakib:</strong> Exactly, exactly. You have to have a plan from day one when you started developing a product. How and where should I go? Who are my primary audiences? Whom to reach out. Which influencers should we work with? And when should I give them the beta version to test? I can give a beta version to like hundreds of peoples, who are willingly giving it a try. Tell us some beautiful insights, some valuable insights so that we can develop the product even more before going to the market. So that&#8217;s the thing.</p>\n\n\n\n<p>In most cases, what developers are thinking, what mostly the founders who are mostly developers, they&#8217;re thinking like, well, I can develop the product like 80% and then for the rest 20%, we can start working with the marketing team. I can think of how to go to the market and how to have some early traction. Early traction is easy, but it&#8217;s not the kicker. Early traction is easy because if you have a freemium plan, you can definitely go for wp.org. There&#8217;s a free version so everyone can use it.</p>\n\n\n\n<p>There&#8217;s a term, founder led marketing. So when you are a founder, yeah, you can just announce on your socials, like, yeah, I have a plugin. I developed it and I launched it on wp.org so you can try it. Everyone going to try it. No problem on that. But the thing is, there might be a hundred plus active installations on day one, but on day three it could go way below 10, 10 to 15.</p>\n\n\n\n<p>So where are the rest of the people went? They just came here to try the product, you didn&#8217;t ask for anything. You didn&#8217;t know how to contact with them. You didn&#8217;t know how to collect the data, how to collect the information that you don&#8217;t have in your mind, in your head. What&#8217;s the fuss about? What&#8217;s the problem they&#8217;re having? So they didn&#8217;t even bother to share?</p>\n\n\n\n<p>You need to ask first. Be the first person to ask the questions like, what are the problems you are having using my product? I eagerly want to know. I want to solve your problem. So when I am talking with each and every person, each and every client, as he&#8217;s valuable, we bring value to their life, they&#8217;re going to bring something for me too.</p>\n\n\n\n<p>[00:18:01] <strong>Nathan Wrigley:</strong> Yeah, I think the curious thing about a lot of the developers that I know who&#8217;ve brought a plugin to the market is that they&#8217;ve been focused a lot on the features. They&#8217;ve got this laundry list of features and they get really wrapped up in the features and they execute that, they build the features. And then maybe somewhere along the line they realise, oh, there&#8217;s this other feature that would be quite nice to have. Yeah, let&#8217;s do that. And then before you know it, the idea of launching the product just gets pushed back and back and back because, oh, there&#8217;s another feature and, oh, I&#8217;ve thought of another feature. And on it goes.</p>\n\n\n\n<p>And the whole time you haven&#8217;t been doing exactly what you said, kind of trying to figure out how to build up an audience, trying to figure out how to get influencers involved, how to put it out on, in this case, wordpress.org or whatever it may be. And that whole puzzle, that whole jigsaw piece, inside that puzzle needs to be thought out, I think for many people, at a much earlier date.</p>\n\n\n\n<p>I get quite a lot of email from people who would like to have some product or service distributed through something like a podcast. On some level, it&#8217;s amazing that the people would like me to help them, but also when you go to the property that they&#8217;ve got, you can see that the thing that they&#8217;ve built is amazing, but also the marketing side of things hasn&#8217;t really been taken care of. So the website is nowhere near the standard that the plugin is. Everything about it, you know, the documentation is nowhere near the standard that the plugin is and so on. So there&#8217;s this sort of real disconnect.</p>\n\n\n\n<p>So do you have any like do&#8217;s and don&#8217;ts? Have you got any, like a list of things that you highly recommend people do if they want to market a plugin? But also some things which you think, actually no, stay away from that, that&#8217;s snake oil, people have tried that and it doesn&#8217;t seem to work. Any order of any of those things.</p>\n\n\n\n<p>[00:19:35] <strong>Muntasir Sakib:</strong> Absolutely. If you&#8217;re talking about like developing features and releasing it every alternate week, these are the most common picture when we are thinking about WordPress ecosystem, or any other products. 80% people are doing that. But the problem occurs when, feature first development means you keep building what you want, not what your customers actually struggle with, right?</p>\n\n\n\n<p>So when you release a product, you have the roadmap. You make it public. You show the customers like, well, these features are coming next, but people don&#8217;t bother about what features are coming next, they&#8217;re mostly bothered about what you have right now, and are those working properly or not? You might have, like when you were thinking of any e-commerce, you might have 20 or 30 payment gateway integrations with it. But I don&#8217;t need all the payment gateway integrations, right? I need specifically like one or two, like maybe I need PayPal integrations or Stripe integrations or Wise or some other integrations like Klarna.</p>\n\n\n\n<p>The rest of the integrations you have are useless to me, so I don&#8217;t even bother whether they&#8217;re coming or not. I do bother about my product and I do bother about whether, as I am using your product, so even giving me the value of my requirements, like the PayPal is working fine, in the next update the PayPal is working still fine and it&#8217;s secured. When I click the update button, or if I enabled auto update, with an update the PayPal is not working. My business will go through the loss.</p>\n\n\n\n<p>So it&#8217;s your responsibility to take care of my business because I&#8217;m using your product. So you have to make sure that every specific niche I am giving the solution for, are working properly after every updates and everything.</p>\n\n\n\n<p>I often see companies who are trying to develop the update version, who are trying to give updates regular basis. They often consider giving it the quality assurance, the QA. The QA team mostly were doing nothing. They were just going through on the surface level. They bring the update, and then the people updated it, and the site crashed. And then they figured out, well, it might be your environment issues. It might be from your end because we are doing nothing. It&#8217;s working fine from our end. So let me see. Give me your backend credentials so that I can see what&#8217;s going on here. It&#8217;s a big no. It&#8217;s a big no for me. If you are talking about me, like it&#8217;s a big no. Why would I give my credentials to you? It&#8217;s your responsibility to take care of your product so that it&#8217;s working fine from my end.</p>\n\n\n\n<p>These are the common things, and apart from that, when we are talking about feature first development, this leads to slower performance. The more the features, the slower the performance is, and it&#8217;s non-negotiable. The higher support workload and our roadmap, as I said, a roadmap that is reactive, not strategic. So strategic roadmap is important. Reactive roadmap means you are actually way far behind from your competitors. So many founders think that features is equal to value, but features are not equal to value. In reality, clarity, reliability, and use case fit, drive adoption and revenue.</p>\n\n\n\n<p>[00:22:49] <strong>Nathan Wrigley:</strong> So the really interesting thing about this is that there&#8217;s really two completely different worlds in collision here. So if you are the developer, you are basically sat in a chair looking at a screen, wrangling code. And it&#8217;s this, you&#8217;ve got this small window on the universe. You&#8217;re just sort of staring into this thing. You&#8217;ve got complete control over it. And it&#8217;s clean and it&#8217;s, I don&#8217;t really know how to describe it. It&#8217;s all just right in front of you.</p>\n\n\n\n<p>Whereas the other side, the marketing side is the exact opposite. It&#8217;s like, turn away from the computer and look at the entire planet. Every single human being in it, all of the messiness of that, trying to find them, trying to figure out how you&#8217;re going to talk with them, trying to figure out how you&#8217;re going to let them know that you exist. Trying to figure out how you&#8217;re going to let them know that your product is exactly what they need. Trying to figure out how to do the SEO piece, and we could go on and on.</p>\n\n\n\n<p>There really are two very different universes colliding there. And I feel that in many cases, a really different personality type fits those things. Like, you know, the developer sitting in the chair concentrating on that code is a really different kind of personality type, if you know what I mean, than the person who can turn around, look at the world, cope with that messiness and figure all of that out. I&#8217;m not saying that they&#8217;re not possible by two people, I&#8217;m just saying they are very, very different things. One, much messier and harder to figure out than the other.</p>\n\n\n\n<p>But from what you are saying as a developer, you have to do both. You have to turn around and look at the world in all of its messiness because your users are going to kind of, you know, they&#8217;re the people that are going to tell you whether or not what you&#8217;re building is a good thing or what they need.</p>\n\n\n\n<p>[00:24:26] <strong>Muntasir Sakib:</strong> No, no, I think we got it wrong because I didn&#8217;t say that developers need to do both of the work, they need to code fresh and they need to look around all the users, what they&#8217;re saying and how their product is performing. It&#8217;s not their job.</p>\n\n\n\n<p>We need to be very specific. If I&#8217;m a developer, my only responsibility should be to do fresh code and to make sure that my product is working fine on every environment. And it&#8217;s the marketer&#8217;s duty to talk to the customers, to talk to the world, and if as a founder, I don&#8217;t need to jeopardise my business, my company, then I need to align with everything, with every team possible. Like there&#8217;s sales team, there&#8217;s marketing team, there&#8217;s support team, content team, developer team.</p>\n\n\n\n<p>The thing is, market research should be done by the marketers. Market research should be done, the customers should be talked with the marketers, with the salespeople. They need to come along with the ideas that, well, fine, these are the opportunities we have right now. So if we want to build a product, if we want to develop a product, we need to bring these three or four features before releasing the product in the market because these are the things people are having problem with. So I am giving you this list of features, or this list of things that you need to have in your product, and then it can go to the design team. The design team come up with a very beautiful design and then the developers start developing it.</p>\n\n\n\n<p>And then we need to figure out the fact that, well, the product is almost 80% done, so we need to reach to the influencers, we need to reach to some YouTube influencers who have great audience so that they can use it. So we can give them the beta version. They can use it, they can bring some beautiful solutions, some beautiful suggestions to make the product even more mature before going to the market. And we can share the thought with the developers so that they can update accordingly.</p>\n\n\n\n<p>[00:26:22] <strong>Nathan Wrigley:</strong> Right, I got it. Yeah, so I get the piece there. So really when I was talking about, you know, the developer facing one way and then facing the other way, the computer and the world, you are introducing then, in the middle, the developer turns around and instead of talking to the world, talks to the marketer.</p>\n\n\n\n<p>And then the marketer absorbs those messages, whatever it is that the developer thinks, okay, it&#8217;s ready, it&#8217;s nearly ready, here&#8217;s the features. They communicate with the marketing people, the marketing people turn that into real world action. And then they themselves turn around and look at that bigger world and figure out how to do that.</p>\n\n\n\n<p>I think the curious thing is, in our community, there&#8217;s so many of the solo developers who, when that thing that you&#8217;ve just suggested, gets suggested. That some of the budget goes to a marketer, it&#8217;s like, no, no, no, no, no, no, I can do it all. I&#8217;ll be fine, because we know it can work in some rare cases. But it&#8217;s not going to be as effective as getting somebody else on board.</p>\n\n\n\n<p>But I think in our community, there is a, I don&#8217;t really know how to encapsulate this, but there&#8217;s a little bit of a divide between the marketing side of things, the sort of sponsorship side of things, the affiliate side of things, all of those bits, and the developers. And it&#8217;s not always an easy conversation to have.</p>\n\n\n\n<p>I suppose, in the end it comes down to things like money and things like that, which our community is maybe not as comfortable talking about as other different communities.</p>\n\n\n\n<p>So is there anything that you think is a bad idea? I remember in the show notes that you sent to me, there were a few things where you thought, for example, you mentioned things like the one-time revenue trap of lifetime deals and things like that. Do you want to mention some of the gotchas, some of the things in the past that you&#8217;ve thought, nope, don&#8217;t do that, that&#8217;s a bad idea?</p>\n\n\n\n<p>[00:28:00] <strong>Muntasir Sakib:</strong> Yeah. You were talking about the solo developer. There are a lot of solo developers, I might say. I must say because they are a one person team, and every project they build, every line of code they write, it&#8217;s like their children. So it&#8217;s always normal to be biased to your product. Like, yes, my product is the best because I have developed it with all my passion, with all my hard work. Why aren&#8217;t people using it?</p>\n\n\n\n<p>And you might have a tight budget because when you are solo developer, the budget&#8217;s going to be tight. So you might not have that much money to spend on marketing before going to the market. And that&#8217;s fine. Welcome the community because the WordPress community is so helpful that even if you go to the community people and you tell them like, well, I am working on a product all by myself, and I want someone to come up with me and test the product and give me some valuable insights about what I can do better, before going to the market. And they&#8217;re always helpful. There are like hundreds and thousands of people who can help you, making your product even better by testing your beta versions, by testing your RC versions.</p>\n\n\n\n<p>The thing is you have to be vocal. You have to talk to the poeple. You have to ask for help because you are helpless, you are working day and night on your product, and you cannot let people know, you cannot talk to people. You are very shy to ask for help, to ask for a hand. So how do I know that you are building a very beautiful product? I am here to help you, you just need to ask me. You want to give it a try? Sure thing. I will definitely give it a try and have some suggestions for you if you may allow me. That&#8217;s it.</p>\n\n\n\n<p>And about the question is one time revenue, you think? Yeah. And whether it&#8217;s a trap or not. It&#8217;s a trap. It&#8217;s a trap. Nathan, I can say to you, like many WordPress founders rely on lifetime deals, one time license and large seasonal discounts. I mean Black Friday, Cyber Monday, the year end sales. Might going to create some cash upfront, but that doesn&#8217;t bring sustainability.</p>\n\n\n\n<p>Sustainability is something way more different than cashflow. Because sustainability comes with recurring revenue. Your support is recurring, but if you have only lifetime deals, then your revenue is not. So how can you go along with your support team year after year, when you are running just once from a customer?</p>\n\n\n\n<p>Because once a customer has got something lifetime from your end, you have to give him support. You have to provide him top-notch support for the rest of your lives, for the rest of products life. And then every year, fixed cost goes up. Teams, servers, your support team will go along. Your team will be bigger than the last year, along with your product. So your fixed cost will always go up. And lifetime buyers often create the highest support load while paying the least.</p>\n\n\n\n<p>So you have to have that in your mind that when I am working for a easy traction and I am giving them the lifetime deals, and I want to onboard thousands of customers, lifetime customers, you need to think that you need to give them support, you need to develop the product for these thousand customers who will not ever going to pay a single penny to you anymore. So this is a big burden for you.</p>\n\n\n\n<p>So real WordPress companies that scale, focus on renewals, annual plans, and clear upgrade perks. So here are the things, you might have like three to four pricing plans for one site, for ten sites and for unlimited sites. And I bought the one site license. And then I fell in love with your product, and I want to upgrade to ten site plans. So there should be a very, like one click upgradation plan, upgradation system where I can just go from one site to ten sites. And if you can&#8217;t give me that opportunity, and if you going to tell me like, okay, fine, buy the ten site license, give me the one site license key, and I&#8217;m going to dispatch that. I&#8217;m going to deactivate that and activate your license manually, that doesn&#8217;t make sense because that&#8217;s a hassle to me. I&#8217;m your customer, so you need to give me the smoother way. This is the thing.</p>\n\n\n\n<p>[00:32:09] <strong>Nathan Wrigley:</strong> When you&#8217;ve been working for some of the, I don&#8217;t know, agencies or companies where there&#8217;s obviously a marketing team which has been a part of the success. Do you know roughly, I mean, maybe it&#8217;s just a ballpark figure, do you know roughly how much of the wider team so, you know, think of Company X, which is a development company, but they&#8217;ve got in-house marketing as well. Do you know how much of the company, in terms of personnel or revenue, is given over to marketing as opposed to everything else? So, you know, is it typically like in the sort of 20%, 30%, 50%? What&#8217;s your rough estimate for those?</p>\n\n\n\n<p>[00:32:43] <strong>Muntasir Sakib:</strong> My rough estimate is your marketing budget should always be at least 30% of your total estimation cost. Because marketers need to talk to people, they need to reach out to the people, and they need to collaborate with most of the influencers who going to work for you, and you have to give them the honorarium to do the work for you.</p>\n\n\n\n<p>So if the budget is not standard enough, then they have the boundaries to not do their works. So you need to give them the free hand, explore the sides to work with the other WordPress companies, to collaborate with better partners, to collaborate with other companies and to onboard their clients as well, so that your client base will increase day by day.</p>\n\n\n\n<p>[00:33:24] <strong>Nathan Wrigley:</strong> And in the old way, when I was talking about sort of 15 years ago, it felt like most things were driven by interaction with the WordPress community. Do you think that&#8217;s still like a viable way of doing things or, you know, in the case of, I don&#8217;t know, let&#8217;s say that you&#8217;ve got an LMS plugin or something like that. Your market really isn&#8217;t other WordPressers, your market is the entire world, you know, educators and what have you.</p>\n\n\n\n<p>So do you put much stock in sort of turning up to events, and sponsoring WordPress stuff, or do you sort of advise, focusing on your customers? I&#8217;m just trying to figure out where the community bit might fit into all that.</p>\n\n\n\n<p>[00:33:59] <strong>Muntasir Sakib:</strong> Well, the thing is, let&#8217;s talk about the sponsorship first because in WordCamps you need to be sponsored under your product. If we are talking about any LMS plugin that we have. We want to let the WordPress community know that, yeah, we exist and we sponsor to this event. And the most important thing is only in the WordCamps or the WordPress meetups you&#8217;re going to get along with other companies in person, so that you can connect with them, you can talk to them. You can figure out an opportunity to work with other companies. If I am an LMS company, I have an LMS plugin, my customer&#8217;s going to need some hosting plan. They might need some security plugins. They might need some SEO plugins.</p>\n\n\n\n<p>[00:34:39] <strong>Nathan Wrigley:</strong> It&#8217;s more of a sort of partnership opportunity.</p>\n\n\n\n<p>[00:34:42] <strong>Muntasir Sakib:</strong> Exactly.</p>\n\n\n\n<p>[00:34:42] <strong>Nathan Wrigley:</strong> Figuring out who, in some curious case that you may not yet have imagined, how you could collaborate in the future. So like you said, you know, hosting or whatever it may be, or maybe there&#8217;s a form plugin out there, which you kind of get the intuition that, oh, we could use bits of your form to onboard people to our platform, or whatever it may be. So it&#8217;s very much not about marketing to the end user. It&#8217;s more about figuring out partnerships and things like that. But also being a good custodian of an open source project, I guess, as well.</p>\n\n\n\n<p>[00:35:11] <strong>Muntasir Sakib:</strong> Of course, yeah. That&#8217;s true. Because in every other companies who are doing great in WordPress ecosystem, they have a very strong relationship with the other companies. They have the mutual connections with all the people, with all the companies their customers might going to need. And the partnerships, affiliates are the best way to do the marketing to grow, to scale your product in WordPress market. Because as I said at first, word of mouth is something that brings the most valuable customers in your back.</p>\n\n\n\n<p>[00:35:40] <strong>Nathan Wrigley:</strong> Yeah, I mean, you only have to look on Facebook and LinkedIn and things like that to realise that there&#8217;s a lot of people in the WordPress community who attend these events and hang out with other people at these events and make great friendships and partnerships and those kind of things. I presume they&#8217;re doing it because, A, it&#8217;s fun, but also there&#8217;s a real value to it, you know? I know all these people and so I know where to go when I&#8217;ve got a particular problem, or I just have an intuition that I want to spin my company off in a slightly different direction. I&#8217;ve now got some people that I know, some contacts that I&#8217;ve already made who might be able to help me with that.</p>\n\n\n\n<p>Okay. What about the, sort of last one, and it&#8217;s actually alluding to your, one of the questions that you wrote here. Is there anything about the sort of psychology of this, the sort of mindset? Because I think with the best will in the world, a lot of people in our space, they kind of see marketing as a bit of a, an icky thing. Something that they really don&#8217;t feel comfortable doing.</p>\n\n\n\n<p>Is there any kind of psychology here that you could recommend or some kind of mind shift that somebody like me, for example, who is terrible at marketing, that I might be able to undergo, some magic wand that you can wave to help me out?</p>\n\n\n\n<p>[00:36:41] <strong>Muntasir Sakib:</strong> We all are learners. We learn every day. I&#8217;m still a learner, and most of the world famous marketers are learners, even the passionate developers. You still learn how to develop well, how to write fresh code in even a better way.</p>\n\n\n\n<p>But the most important thing is there are some mindset differences. There are someone who is a builder, and there are someone who is a business owner. So the thin line between builders and business owners are builders think about features. They think about features, what to come along with next, what to give to our customers, whether they like it or not. But founders think, I build outcomes and value. I bring value to the customers.</p>\n\n\n\n<p>Another mindset, if we talk about like the short term revenue and the long-term sustainability. So when we are selling lifetime deals, one time license, that&#8217;s the short term revenue that give me an early traction, a good traction within a few months. But it&#8217;ll never going to be sustainable. If you want to be sustainable, you need to have a recurring plan, you need to have recurring customers, you need to onboard more customers, but your recurring customers should be like around 70 to 80% or even more than that, so that you can sustain all along.</p>\n\n\n\n<p>Then if I&#8217;m talking about another mindset that it can be the focus on the product versus focus on the user. Failing founders, like those who cannot scale, they think that what feature should we add next? But the scaling founders, if you talk to them, they&#8217;re going to think where my users are getting stuck, so I need to solve the problem first. I need to bring value to their life so that they come along with me. They&#8217;re going to be my best audience and they&#8217;re going to do the marketing for me.</p>\n\n\n\n<p>[00:38:24] <strong>Nathan Wrigley:</strong> This stuff is so intuitive to you because obviously it&#8217;s something that you&#8217;ve spent a long time thinking about. I&#8217;ve got to say, for me, a lot of this stuff is kind of intuitive, but not at the same time. I&#8217;m definitely more on the kind of builder side than on the marketing side. I don&#8217;t know what it is about marketing, I just struggle to do those kind of things.</p>\n\n\n\n<p>And you&#8217;ve written a lot of your thoughts up in three articles, which you&#8217;ve published on LinkedIn. I don&#8217;t know if they&#8217;ve been published elsewhere, but they&#8217;re definitely on LinkedIn. And they describe all of the different scenarios of, you know, what founders need to do, how plugins can have success, where the community lies, how you can get yourself involved in different things. But also quite a lot of work you&#8217;ve put into what not to do. So example, lifetime deals, which you don&#8217;t think are a particularly great idea.</p>\n\n\n\n<p>I&#8217;m going to link to all of those different bits and pieces in the show notes so that people can go and read those, and then hopefully having been armed with all of that knowledge, they&#8217;ll understand better what it is that we&#8217;ve been talking about.</p>\n\n\n\n<p>Where do we find you, Muntasir? Where do we go online? Apart from LinkedIn, obviously, where could we find you?</p>\n\n\n\n<p>[00:39:28] <strong>Muntasir Sakib:</strong> I&#8217;m always available on Facebook, on Twitter. And I am always available on LinkedIn as well. These are the platforms you are going to find me.</p>\n\n\n\n<p>[00:39:36] <strong>Nathan Wrigley:</strong> Well, I will link to the LinkedIn posts and I will endeavor to dig out your Twitter handle as well. So hopefully people can find you and if they&#8217;ve got questions, you are open to suggestions.</p>\n\n\n\n<p>So thank you so much for chatting to me today. A subject of great interest to me because, well, as I said, there&#8217;s just great interest for me. I won&#8217;t say more than that. But thank you very much for chatting to me today. I really appreciate it.</p>\n\n\n\n<p>[00:39:56] <strong>Muntasir Sakib:</strong> Thank you, Nathan. Thank you for talking to me. And it&#8217;s great talking to you and sharing my knowledge and expertise with you.</p>\n</div></details>\n\n\n\n<p>So on the podcast today we have <a href="https://www.linkedin.com/in/muntasir-m-sakib/">Muntasir Sakib</a>.</p>\n\n\n\n<p>Muntasir has been active in the WordPress space since 2018, working with well-known plugins and companies such as Tutor LMS, Droip and more. He’s played a key role scaling products from their early days, helping them achieve wider adoption. He’s also been active in the WordPress community more broadly at events such as WordCamp Asia and WordCamp Sylhet.</p>\n\n\n\n<p>The focus of today’s episode is a crucial yet often overlooked topic, especially if you’re a plugin developer. It’s a chat about the moment when plugin development ends and real success can begin. In a WordPress marketplace that’s more crowded and competitive than ever, simply ‘build it and they will come’ does not mean users will. Muntasir wants to bust the myth by digging into why marketing is essential from day one, and not an afterthought left until launch day.</p>\n\n\n\n<p>We start by learning about Muntasir’s journey through the WordPress ecosystem, and his approach to balancing development and marketing for plugins. He explains the key differences between marketing in the WordPress ecosystem versus the SaaS world. In WordPress, you don’t control the full stack and your users expect openness and interoperability, making community focus and support critical.</p>\n\n\n\n<p>The discussion then turns to the practicalities of launching and growing a plugin. Why throwing new features at a product isn’t enough, and why listening to users and building community relationships is often more valuable than racing to add features no one has asked for.</p>\n\n\n\n<p>We talk about the do’s and don’ts gained from Muntasir’s experience, including the pitfalls of relying on lifetime deals for early revenue, and why a recurring revenue model is key for long-term sustainability.</p>\n\n\n\n<p>We also talk through the role of community, partnerships, and events like WordCamps, not just as marketing opportunities, but as places to build the relationships and collaborations that can help plugins thrive.</p>\n\n\n\n<p>If you’re a WordPress plugin developer wondering how to turn a finished product into a real success, or you’re trying to figure out where marketing fits into your roadmap, this episode is for you.</p>\n\n\n\n<h2 class="wp-block-heading">Useful links</h2>\n\n\n\n<p>Project / Events which Muntasir has been involved with:</p>\n\n\n\n<p><a href="https://tutorlms.com"> Tutor LMS</a></p>\n\n\n\n<p><a href="https://droip.com">Droip</a></p>\n\n\n\n<p><a href="https://easycommerce.dev">EasyCommerce</a></p>\n\n\n\n<p><a href="https://thumbpress.co">ThumbPress</a></p>\n\n\n\n<p><a href="https://www.joomshaper.com"> JoomShaper</a></p>\n\n\n\n<p> <a href="https://asia.wordcamp.org/2023/">WordCamp Asia 2023</a></p>\n\n\n\n<p><a href="https://sylhet.wordcamp.org/2023/">WordCamp Sylhet 2023</a></p>\n\n\n\n<p>Three of Muntasir&#8217;s articles on LinkedIn:</p>\n\n\n\n<p><a href="https://www.linkedin.com/pulse/why-marketing-still-missing-piece-most-wordpress-product-sakib-fdz0c/">Why Marketing Is Still the Missing Piece for Most WordPress Product Companies</a></p>\n\n\n\n<p><a href="https://www.linkedin.com/pulse/hidden-cost-lifetime-deals-what-plugin-owners-dont-realize-sakib-pbmqc/">The Hidden Cost of Lifetime Deals: What Plugin Owners Don&#8217;t Realize Until It&#8217;s Too Late</a></p>\n\n\n\n<p><a href="https://www.linkedin.com/pulse/after-5-years-10-plugins-heres-why-most-wordpress-products-sakib-fcw0c/">After 5 Years and 10+ Plugins: Here’s Why Most WordPress Products Fail to Scale</a></p>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Wed, 17 Dec 2025 15:00:00 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:14:"Nathan Wrigley";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:20;a:6:{s:4:"data";s:21:"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:68:"Open Channels FM: Why Context Matters in Accessibility Conversations";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:33:"https://openchannels.fm/?p=113262";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:75:"https://openchannels.fm/why-context-matters-in-accessibility-conversations/";s:7:"attribs"